<?php
/**
* @package com_splms
* @author JoomShaper http://www.joomshaper.com
* @copyright Copyright (c) 2010 - 2018 JoomShaper
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

// No Direct Access
defined ('_JEXEC') or die('Resticted Aceess');

class SplmsViewEvents extends JViewLegacy{
	
	protected $items;
	protected $params;
	protected $layout_type;

	function display($tpl = null) {
		// Assign data to the view
		$model = $this->getModel();
		$this->items = $this->get('items');
		$this->pagination	= $this->get('Pagination');

		$app = JFactory::getApplication();
		$this->params = $app->getParams();
		$menus = JFactory::getApplication()->getMenu();
		$menu = $menus->getActive();

		$this->layout_type = str_replace('_', '-', $this->params->get('layout_type', 'default'));
		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JLog::add(implode('<br />', $errors), JLog::WARNING, 'jerror');
			return false;
		}

		// Import Joomla component helper
		jimport('joomla.application.component.helper');
		jimport('joomla.filesystem.file');

		// Get Thumb Size
		$cParams = JComponentHelper::getParams('com_splms');
		$thumb_size = strtolower($cParams->get('event_thumbnail', '480X300'));

		foreach ($this->items as &$this->item) {
			// legacy compatibility
			$this->item->splms_speaker_id = $this->item->speaker_id;
			
			$this->item->url = JRoute::_('index.php?option=com_splms&view=event&id=' . $this->item->id . ':' . $this->item->alias . SplmsHelper::getItemid('event'));

			$filename = basename($this->item->image);
			$path = JPATH_BASE .'/'. dirname($this->item->image) . '/thumbs/' . JFile::stripExt($filename) . '_' . $thumb_size . '.' . JFile::getExt($filename);
			$src = JURI::base(true) . '/' . dirname($this->item->image) . '/thumbs/' . JFile::stripExt($filename) . '_' . $thumb_size . '.' . JFile::getExt($filename);

			if(JFile::exists($path)) {
				$this->item->thumb = $src;
			} else {
				$this->item->thumb = $this->item->image;	
			}
		}

		//Generate Item Meta
        SplmsHelper::itemMeta();
		parent::display($tpl);
	}
}