<?php
/**
* @package com_splms
* @author JoomShaper http://www.joomshaper.com
* @copyright Copyright (c) 2010 - 2018 JoomShaper
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

// No Direct Access
defined ('_JEXEC') or die('Resticted Aceess');


?>

<div id="splms" class="splms splms-view-events">
	<?php if(count($this->items)) { ?>

	<?php foreach ($this->items as $event) { ?>

	<div class="splms-event">
		<div class="splms-row">
			<div class="splms-col-sm-4">
				<a href="<?php echo $event->url; ?>">
					<img src="<?php echo $event->thumb; ?>" class="splms-event-img splms-img-responsive" alt="<?php echo $event->title; ?>">
				</a>
			</div>
			<div class="splms-col-sm-8">
				<div class="splms-event-details">
					<h3 class="splms-event-title">
						<a href="<?php echo $event->url; ?>">
							<?php echo $event->title; ?>
						</a>
					</h3>
					<ul class="splms-event-info-list">
						<li>
							<strong>
								<?php echo JText::_('COM_SPLMS_EVENT_DATE') . ': '; ?>
							</strong>
							
							<?php echo JHtml::date($event->event_start_date , JText::_('DATE_FORMAT_LC')) . ' @ ' . date('g:i a', strtotime($event->event_time) ); ?>
						</li>
						<li>
							<strong>
								<?php echo JText::_('COM_SPLMS_EVENT_LOCATION') . ': '; ?>
							</strong>
							<?php echo $event->event_address; ?>
						</li>
					</ul>

					<div class="splms-event-short-description">
						<p><?php echo JHtml::_('string.truncate', strip_tags($event->description), $this->params->get('intro_limit', 300)); ?></p>
					</div>

					<?php if ($this->params->get('show_readmore')) { ?>
					<a class="btn btn-primary" href="<?php echo $event->url; ?>"><?php echo $this->params->get('readmore_text', JText::_('COM_SPLMS_DETAILS')); ?></a>
					<?php } ?>
				</div>
			</div>
		</div><!--/row-->
	</div>

	<?php } ?>

	<?php if ($this->params->get('hide_pagination') == 0) { ?>
		<?php if ($this->pagination->get('pages.total') >1) { ?>
		<div class="pagination">
			<?php echo $this->pagination->getPagesLinks(); ?>
		</div>
		<?php } ?>
	<?php }?>

	<?php } ?>
</div>