<?php
/**
* @package com_splms
* @author JoomShaper http://www.joomshaper.com
* @copyright Copyright (c) 2010 - 2018 JoomShaper
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

// No Direct Access
defined ('_JEXEC') or die('Resticted Aceess');

class SplmsViewCourses extends JViewLegacy {

	protected $items;
	protected $params;
	protected $layout_type;

	function display($tpl = null) {
		// Assign data to the view
		$model = $this->getModel();
		$this->items = $this->get('items');
		$this->pagination	= $this->get('Pagination');

		$app = JFactory::getApplication();
		$this->params = $app->getParams();
		$menus = JFactory::getApplication()->getMenu();
		$menu = $menus->getActive();

		// Load Lessons model
		jimport('joomla.application.component.model');
		JModelLegacy::addIncludePath(JPATH_SITE.'/components/com_splms/models');
		$lessons_model = JModelLegacy::getInstance( 'Lessons', 'SplmsModel' );

		// Loaad jQuary framework
		JHtml::_('jquery.framework');

		// Add Script
		$doc = JFactory::getDocument();
		$doc->addScript( JURI::root(true) . '/components/com_splms/assets/js/matchheight.js' );

		//Joomla Component Helper & Get LMS Params
		jimport('joomla.application.component.helper');
		$this->params = JComponentHelper::getParams('com_splms');

		//Get Currency
		$this->currency = explode(':', $this->params->get('currency', 'USD:$'));
		$this->currency =  $this->currency[1];

		// Get Coumn
		$this->columns = $menu->params->get('columns', '2');

		// Get image thumb
		$this->thumb_size = strtolower($this->params->get('course_thumbnail', '480X300'));

		foreach ($this->items as &$this->item) {

			// legacy compatibility
			$this->item->splms_coursescategory_id = $this->item->coursecategory_id;
			$this->item->splms_course_id 		  = $this->item->id;

			// Get course teachers
			$this->item->teachers = $model->getCourseTeachers( $this->item->id );
			// Get course lessons
			$this->item->lessons  = $lessons_model->getLessons( $this->item->id );

			// Count course lesosns Attachments
			$this->item->total_attachments = array();
			foreach ($this->item->lessons as $lesson){
				if ($lesson->attachment) {
					$this->item->total_attachments[] = $lesson->attachment;
				}
			} // END:: foreach

			// Get Prices
			if ($this->item->price == 0) {
				$this->item->course_price = JText::_('COM_SPLMS_FREE');
			}else{
				$this->item->course_price = SplmsHelper::generateCurrency($this->item->price, $this->item->sale_price);
			}

			// image thumb size
			$filename = basename($this->item->image);
			$path = JPATH_BASE .'/'. dirname($this->item->image) . '/thumbs/' . JFile::stripExt($filename) . '_' . $this->thumb_size . '.' . JFile::getExt($filename);
			$src = JURI::base(true) . '/' . dirname($this->item->image) . '/thumbs/' . JFile::stripExt($filename) . '_' . $this->thumb_size . '.' . JFile::getExt($filename);
			
			if(JFile::exists($path)) {
				$this->item->thumb = $src;
			} else {
				$this->item->thumb = $this->item->image;	
			}

			//URL Generate
			$this->item->url = JRoute::_('index.php?option=com_splms&view=course&id=' . $this->item->id . ':' . $this->item->alias);
		}

		$this->layout_type = str_replace('_', '-', $this->params->get('layout_type', 'default'));

		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JLog::add(implode('<br />', $errors), JLog::WARNING, 'jerror');
			return false;
		}
        SplmsHelper::itemMeta();
		parent::display($tpl);
	}

}
