<?php
/**
* @package com_splms
* @author JoomShaper http://www.joomshaper.com
* @copyright Copyright (c) 2010 - 2018 JoomShaper
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

// No Direct Access
defined ('_JEXEC') or die('Resticted Aceess');

?>

<div id="splms" class="splms view-splms-courses">
	<?php if(count($this->items)) { ?>
	<div class="splms-courses-list">

	<?php foreach(array_chunk($this->items, $this->columns) as $this->items) { ?>
		<div class="splms-row">

		<?php foreach ($this->items as $key=>$course) { ?>
			<div class="splms-col-sm-<?php echo round(12/$this->columns); ?>">
				<div class="splms-course splms-match-height">
					<div class="splms-common-overlay-wrapper">

	            		<img src="<?php echo $course->thumb; ?>" class="splms-course-img splms-img-responsive" alt="<?php echo $course->title; ?>">

	            		<?php if ($course->price == 0) {
	            			echo '<span class="splms-badge-free">' . JText::_('COM_SPLMS_FREE') . '</span>';
	            		} ?>

						<div class="splms-common-overlay">
	                		<div class="splms-vertical-middle">
	                			<div>
	            					<a href="<?php echo $course->url; ?>" class="splms-readmore btn btn-default">
	            						<?php echo $this->params->get('readmore_text', JText::_('COM_SPLMS_DETAILS')); ?>
	            					</a>
	                			</div>
	                		</div>
						</div>
					</div>

					<div class="splms-course-info">
						<h3 class="splms-courses-title">
							<a href="<?php echo $course->url; ?>">
								<?php echo $course->title; ?>
								<small><?php echo $course->category_name; ?></small>
							</a>
						</h3>
						<div class="splms-course-time"><?php echo $course->course_time; ?></div>
						
						<!-- Has teacher -->
						<?php if (!empty($course->teachers)) { ?>
						<div class="splms-course-teachers">
							<span><?php echo JText::_('COM_SPLMS_BY'); ?></span>
							
							<?php foreach ($course->teachers as $teacher) {
								// Get Last Item
								$last_item = end($course->teachers);
							?>
							<a href="<?php echo $teacher->url; ?>" class="splms-teacher-name">
								<strong>
									<?php echo $teacher->title; ?>
								</strong>
								<?php echo ($teacher == $last_item) ? '' : ', '; ?>
							</a>
							<?php } // END:: foreach ?>
						</div>
						<?php } // END:: has teahcer ?>

						<p class="splms-course-short-info"><?php echo $course->short_description; ?></p>
						<div class="splms-course-meta">
							<ul>
								<li><?php echo $course->course_price; ?></li>
								<li><?php echo count($course->lessons); ?> <?php echo JText::_('COM_SPLMS_COMMON_LESSONS'); ?></li>
								<li><?php echo count($course->total_attachments); ?> <?php echo JText::_('COM_SPLMS_COMMON_ATTACHMENTS'); ?></li>
							</ul>
						</div>
					</div> <!-- /.splms-course-info -->
				</div> <!-- /.splms-course -->
			</div> <!-- /.splms-col-sm -->
		<?php } // END:: foreach ?>

	</div> <!-- /.splms-row -->
	<?php } // END::array_chunk ?>

	</div> <!-- /.splms-courses-list -->
	<?php } // END::has items ?>

	<?php if ($this->params->get('hide_pagination') == 0) { //Pagination ?>
		<?php if ($this->pagination->get('pages.total') >1) { ?>
			<div class="pagination">
				<?php echo $this->pagination->getPagesLinks(); ?>
			</div>
		<?php } ?>
	<?php } ?>
	
</div>