<?php
/**
* @package com_splms
* @author JoomShaper http://www.joomshaper.com
* @copyright Copyright (c) 2010 - 2018 JoomShaper
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

// No Direct Access
defined ('_JEXEC') or die('Resticted Aceess');

class SplmsViewCertificate extends JViewLegacy{

	protected $item;
	protected $params;

	function display($tpl = null) {
		// Assign data to the view
		$this->item = $this->get('Item');
		$app = JFactory::getApplication();
		$this->params = $app->getParams();
		$menus = JFactory::getApplication()->getMenu();
		$menu = $menus->getActive();

		//Joomla Component Helper & Get LMS Params
		jimport('joomla.application.component.helper');
		$lmsparams = JComponentHelper::getParams('com_splms');

		// Load Lessons model
		jimport('joomla.application.component.model');
		JModelLegacy::addIncludePath(JPATH_SITE.'/components/com_splms/models');

		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JError::raiseWarning(500, implode("\n", $errors));
			return false;
		}
		// Load models
		$model = JModelLegacy::getInstance( 'certificates', 'SplmsModel' );
		$courses_model = JModelLegacy::getInstance('Courses', 'SplmsModel');

		// Get Course Category Name
		$this->item->category 		= $model->getCourseCategory($this->item->coursescategory_id)->title;
		// Get Course Name
		$this->item->course 		= $courses_model->getCourse($this->item->course_id)->title;
		//Certificate Logo
		$this->item->logo 			= $lmsparams->get('certificate_logo');
		//certificate no
		$this->item->prefix 		= $lmsparams->get('certificate_prefix', 'Joomshaper');
		// Get Organizer
		$this->item->organization 	= $lmsparams->get('organization', 'Joomshaper');
		// Student info
		$this->item->student_info 	= $model->getUser($this->item->userid);

		$student_lmsimage 			= ( $this->item->student_info && $this->item->student_info->profile_value ) ? JURI::root() . json_decode($this->item->student_info->profile_value)->avatar : '' ;
		
		//** Student image **//
		//if inserted from lms
		if (isset($this->item->student_image) &&  $this->item->student_image) {
			$this->item->student_image = JURI::root() . $this->item->student_image;
		}
		// else has lms user profile
		elseif ($student_lmsimage) {
			$this->item->student_image = $student_lmsimage;
		}
		// else taking from gravatar
		else{
			$student_email = 'email@email.com';
			if (isset($this->item->student_info) && $this->item->student_info) {
				$student_email = $this->item->student_info->email;
			}
			// Generating Hash (Removing Spaces (Make all Lower Case))
			$this->item->student_image = 'http://www.gravatar.com/avatar/' . md5(strtolower(trim($student_email))) . '?s=120';
		}

		//Generate Item Meta
        $itemMeta               = array();
        $itemMeta['title']      = (isset($this->item->student_info->name) && $this->item->student_info->name) ? $this->item->student_info->name : '' ;
        $cleanText              = (isset($this->item->course) && $this->item->course) ? $this->item->course : '';
        $itemMeta['metadesc']   = JHtml::_('string.truncate', JFilterOutput::cleanText($cleanText), 155);
        if (isset($this->item->student_image) && $this->item->student_image) {
        	$itemMeta['image']      = $this->item->student_image;
        }

        SplmsHelper::itemMeta($itemMeta);
		parent::display($tpl);
	}

	// public function display($tpl = null){
	// 	//Joomla Component Helper & Get LMS Params
	// 	jimport('joomla.application.component.helper');
	// 	$lmsparams = JComponentHelper::getParams('com_splms');

	// 	// Get this model
	// 	$model = $this->getModel();
	// 	// Get item
	// 	$this->item = $model->getItem();
	// 	// Load Course Model
	// 	$courses_model = FOFModel::getTmpInstance('Courses', 'SplmsModel');

	// 	// Get Course Category Name
	// 	$this->item->category 		= $model->getCourseCategory($this->item->splms_coursescategory_id)->title;
	// 	// Get Course Name
	// 	$this->item->course 		= $courses_model->getCourse($this->item->splms_course_id)->title;
	// 	//Certificate Logo
	// 	$this->item->logo 			= $lmsparams->get('certificate_logo');
	// 	//certificate no
	// 	$this->item->prefix 		= $lmsparams->get('certificate_prefix', 'Joomshaper');
	// 	// Get Organizer
	// 	$this->item->organization 	= $lmsparams->get('organization', 'Joomshaper');
	// 	// Student info
	// 	$this->item->student_info 	= $model->getUser($this->item->userid);

	// 	$student_lmsimage 			= ($this->item->student_info->profile_value) ? JURI::root() . json_decode($this->item->student_info->profile_value)->avatar : '' ;
		
	// 	//** Student image **//
	// 	//if inserted from lms
	// 	if (isset($this->item->student_image) &&  $this->item->student_image) {
	// 		$this->item->student_image = JURI::root() . $this->item->student_image;
	// 	}
	// 	// else has lms user profile
	// 	elseif ($student_lmsimage) {
	// 		$this->item->student_image = $student_lmsimage;
	// 	}
	// 	// else taking from gravatar
	// 	else{
	// 		// Generating Hash (Removing Spaces (Make all Lower Case))
	// 		$this->item->student_image = 'http://www.gravatar.com/avatar/' . md5(strtolower(trim($this->item->student_info->email))) . '?s=120';
	// 	}

	// 	// Return parent display function
	// 	return parent::display($tpl = null);
	// }
}