<?php
/**
 * @package     SP Movie Databse
 *
 * @copyright   Copyright (C) 2010 - 2016 JoomShaper. All rights reserved.
 * @license     GNU General Public License version 2 or later.
 */

defined('_JEXEC') or die('Restricted Access');

class SplmsModelReview extends JModelItem {

	public function __construct($config = array()){
		parent::__construct($config);
	}

	public function storeReview($item_id = 0, $review = '', $rating = 1) {
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$columns = array('course_id', 'review', 'rating', 'created_by', 'created', 'published');
		$values = array($db->quote($item_id), $db->quote($review), $db->quote($rating), JFactory::getUser()->id, $db->quote(JFactory::getDate()), 1);
		$query
		    ->insert($db->quoteName('#__splms_reviews'))
		    ->columns($db->quoteName($columns))
		    ->values(implode(',', $values));
		 
		$db->setQuery($query);
		$db->execute();

		return $db->insertid();
	}

	public function updateReview($review = '', $rating = 1, $review_id = '') {
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);

		$fields = array(
			$db->quoteName('review') . ' = ' . $db->quote($review),
			$db->quoteName('rating') . ' = ' . $db->quote($rating),
			);

		$conditions = array(
			$db->quoteName('id') . ' = ' . $db->quote($review_id),
			$db->quoteName('created_by') . ' = ' . $db->quote(JFactory::getUser()->id),
		);
		$query->update($db->quoteName('#__splms_reviews'))->set($fields)->where($conditions);
		$db->setQuery($query);
		$db->execute();
	}

	public function getReview($review_id = 0) {
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select( array('a.*', 'b.email', 'b.name') );
		//$query->select('a.*');
	    $query->from($db->quoteName('#__splms_reviews', 'a'));
	    $query->join('LEFT', $db->quoteName('#__users', 'b') . ' ON (' . $db->quoteName('a.created_by') . ' = ' . $db->quoteName('b.id') . ')');
	    $query->where($db->quoteName('a.id') . ' = ' . $db->quote($review_id));
	    $query->order($db->quoteName('a.created') . ' DESC');
	    
	    $db->setQuery($query);

	    $review = $db->loadObject();

	    if(count((array)$review)) {
	    	$review->gravatar = md5($review->email);
	    	$review->created_date = SplmsHelper::timeAgo($review->created);
	    	return $review;
	    }

	    return false;
	}

	public function getRatings($item_id) {
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select( array('COUNT(a.rating) AS count', 'SUM(a.rating) AS total') );
	    $query->from($db->quoteName('#__splms_reviews', 'a'));
	    $query->where($db->quoteName('a.course_id') . ' = ' . $db->quote($item_id));
	    $db->setQuery($query);
		
		return $db->loadObject();
	}
}