<?php
/**
* @package com_splms
* @author JoomShaper http://www.joomshaper.com
* @copyright Copyright (c) 2010 - 2018 JoomShaper
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

// No Direct Access
defined ('_JEXEC') or die('Resticted Aceess');

jimport('joomla.form.formfield');
jimport('joomla.filesystem.folder');
jimport('joomla.filesystem.file');

class JFormFieldCoursecategories extends JFormField {

    protected $type = 'coursecategories';

    protected function getInput(){
        // Get Tournaments
        $db = JFactory::getDbo();
        $query = $db->getQuery(true);

        // Select all records from the user profile table where key begins with "custom.".
        $query->select($db->quoteName(array('id', 'title' )));
        $query->from($db->quoteName('#__splms_coursescategories'));
        $query->where($db->quoteName('published')." = 1");
        $query->order('ordering ASC');

        $db->setQuery($query);
        $results = $db->loadObjectList();
        $course_list = $results;

        $options = array('' => JText::_('COM_SPLMS_SELECT_CATEGORY_ALL'));
        foreach($course_list as $course){
            $options[] = JHTML::_( 'select.option', $course->id, $course->title );
        }

        return JHTML::_('select.genericlist', $options, $this->name, '', 'value', 'text', $this->value);
    }
}
