<?php
/**
* @package com_splms
* @author JoomShaper http://www.joomshaper.com
* @copyright Copyright (c) 2010 - 2018 JoomShaper
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

// No Direct Access
defined ('_JEXEC') or die('Resticted Aceess');

class SplmsModelCourses extends JModelList {

	protected function getListQuery() {
		$app = JFactory::getApplication();
		$user = JFactory::getUser();

		// Get Params
		$app 			= JFactory::getApplication();
		$params   		= $app->getMenu()->getActive()->params; // get the active item
		$item_type 		= $params->get('item_type', '');
		$ordering 		= $params->get('ordering', ' DESC');
		$category_id 	= $params->get('category_id', '');

		// Create a new query object.
		$db = $this->getDbo();
		$query = $db->getQuery(true);

		// Select the required fields from the table.
		$query->select('a.*');
		$query->select($db->quoteName('b.title', 'category_name'));
		$query->from($db->quoteName('#__splms_courses', 'a'));
		$query->join('LEFT', $db->quoteName('#__splms_coursescategories', 'b') . ' ON (' . $db->quoteName('a.coursecategory_id') . ' = ' . $db->quoteName('b.id') . ')');

		// Filter category
		if ( $category_id ) {
			$query->where('a.coursecategory_id = ' . $category_id);
		}

		if ($item_type) {
			$query->where($db->quoteName('a.featured_course')." = " . $db->quote(1));
		}

		// Filter by language
		$query->where('a.language in (' . $db->quote(JFactory::getLanguage()->getTag()) . ',' . $db->quote('*') . ')');
		//Authorised
		$groups = implode(',', $user->getAuthorisedViewLevels());
		$query->where('a.access IN (' . $groups . ')');
		
		$query->where($db->qn('a.published')." = ".$db->quote('1'));
		$query->order($db->quoteName('a.ordering') . $ordering);

		return $query;
	}

	protected function populateState($ordering = null, $direction = null) {
		$app = JFactory::getApplication('site');
		$params = $app->getParams();
		$this->setState('list.start', $app->input->get('limitstart', 0, 'uint'));
		$limit = $params->get('limit');
		$this->setState('list.limit', $limit);
	}

	//if item not found
	public function &getItem($id = null) {
		$item = parent::getItem($id);
		if(JFactory::getApplication()->isSite()) {
			if($item->id) {
				return $item;
			} else {
				return JError::raiseError(404, JText::_('COM_SPLMS_NO_ITEMS_FOUND'));
			}
		} else {
			return $item;
		}
	}

	// Get Couse Teachers by Course ID
	public static function getCourseTeachers($course) {
		// Load Lessons model
		jimport('joomla.application.component.model');
		JModelLegacy::addIncludePath(JPATH_SITE.'/components/com_splms/models');
		$lessons_model = JModelLegacy::getInstance( 'Lessons', 'SplmsModel' );

		$lessons = $lessons_model->getLessons($course);
		$ids = array();
		foreach ($lessons as $lesson) {
			$ids[] = $lesson->teacher_id;
		}

		$ids = array_unique($ids);
		$ids = implode(',',$ids);

		if ($ids) {
			$db = JFactory::getDbo();
			$query = $db->getQuery(true);

			$query->select($db->quoteName(array('id', 'title', 'alias', 'image', 'experience', 'specialist_in', 'website')));
			$query->from($db->quoteName('#__splms_teachers'));
			$query->where($db->quoteName('published')." = 1");
			$query->where($db->quoteName('id')." IN (".$ids . ")");
			$query->order('ordering DESC');

			$db->setQuery($query);

			$items = $db->loadObjectList();

			foreach ($items as &$item) {
				$item->url = JRoute::_('index.php?option=com_splms&view=teacher&id='.$item->id.':'.$item->alias . SplmsHelper::getItemid('teachers'));
			}
		}else{
			$items= array();
		}

		return $items;
	}


	// Get Course By Course id
	public static function getCourse($id) {
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select($db->quoteName(array('a.id', 'a.title', 'a.alias', 'a.image', 'a.course_time', 'a.price', 'a.sale_price')));
		$query->select($db->quoteName('b.title', 'category_name'));
		$query->from($db->quoteName('#__splms_courses', 'a'));
		$query->join('LEFT', $db->quoteName('#__splms_coursescategories', 'b') . ' ON (' . $db->quoteName('a.id') . ' = ' . $db->quoteName('b.id') . ')');

		$query->where($db->quoteName('a.published')." = 1");
		$query->where($db->quoteName('a.id')." = ".$db->quote($id));
		$query->order('a.ordering DESC');

		$db->setQuery($query);

		$result = $db->loadObject();

		if ($result) {
			$result->url = JRoute::_('index.php?option=com_splms&view=course&id='.$result->id.':'.$result->alias . SplmsHelper::getItemid('courses'));
		}
		
		return $result;
	}

	// Get Course By Course id
	public static function getAllCourses() {
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select($db->quoteName(array('id', 'title', 'alias', 'image', 'short_description')));
		$query->from($db->quoteName('#__splms_courses'));
		$query->where($db->quoteName('published')." = 1");
		$query->order('ordering DESC');
		$db->setQuery($query);
		$results = $db->loadObjectList();
		foreach ($results as &$result) {
			$result->url = JRoute::_('index.php?option=com_splms&view=course&id='.$result->id.':'.$result->alias . SplmsHelper::getItemid('courses'));
		}
		return $results;
	}

	// Check user already buy course
	public static function getIsbuycourse($user_id, $course_id) {
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select($db->quoteName(array('id')));
		$query->from($db->quoteName('#__splms_orders'));
		$query->where($db->quoteName('published')." = 1");
		$query->where($db->quoteName('course_id')." = ".$db->quote($course_id));
		$query->where($db->quoteName('order_user_id')." = ".$db->quote($user_id));
		$query->order('ordering DESC');
		$db->setQuery($query);
		$result = $db->loadObject();

		return $result;
	}

	// Get users puchased item
	public static function getPurchasedCourse($user_id) {
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select($db->quoteName(array('order_user_id', 'course_id', 'published')));
		$query->from($db->quoteName('#__splms_orders'));
		$query->where($db->quoteName('published') ." = 1");
		$query->where($db->quoteName('order_user_id')." = ".$db->quote($user_id));
		$query->order('ordering DESC');
		$db->setQuery($query);
		$results = $db->loadObjectList();

		foreach ($results as &$result) {
			$result->course_info = self::getCourse($result->course_id);

			$result->course_name = $result->course_info->title;
			$result->url  = $result->course_info->url;
		}

		return $results;
	}

	// Get Quizzes By Course id
	public static function getQuizzes($course_id) {
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select($db->quoteName(array('id', 'title', 'alias', 'quiz_type')));
		$query->from($db->quoteName('#__splms_quizquestions'));
		$query->where($db->quoteName('published') ." = 1");
		$query->where($db->quoteName('course_id')." = ".$db->quote($course_id));
		$query->order('ordering DESC');
		$db->setQuery($query);
		$items = $db->loadObjectList();

		foreach ($items as &$item) {
			$item->url = JRoute::_('index.php?option=com_splms&view=quizquestion&id='.$item->id.':'.$item->alias . SplmsHelper::getItemid('quizquestions'));
		}

		return $items;
	}

	//Get Related Artists
	public function getRelatedCourses($course_name, $course_id, $cat_id, $limit = 3) {
		$search = preg_replace('#\xE3\x80\x80#s', " ", htmlspecialchars(trim($course_name)));
		$search_array = explode(" ", $search);

		$str_tag_ids = implode(' OR ', array_map(function ($entry) {
			return "a.title LIKE '%" . $entry . "%'";
		}, $search_array));
		//$str_tag_ids = $str_tag_ids . " OR a.coursecategory_id = '%" . $cat_id . "%'";
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select( array('a.id', 'a.title', 'a.alias', 'a.course_sub_title', 'a.course_time', 'a.image') );
		$query->select($db->quoteName('b.title', 'category_name'));
		$query->from($db->quoteName('#__splms_courses', 'a'));
		$query->join('LEFT', $db->quoteName('#__splms_coursescategories', 'b') . ' ON (' . $db->quoteName('a.coursecategory_id') . ' = ' . $db->quoteName('b.id') . ')');
		$query->where($db->quoteName('a.id')." != ".$db->quote($course_id));
		$query->where($db->quoteName('a.published')." = ".$db->quote('1'));

		if ($str_tag_ids) {
			$query->where($str_tag_ids);
		}
		
		$query->setLimit($limit);
		$db->setQuery($query);
		$results = $db->loadObjectList();

		foreach ($results as &$result) {
			$result->url  = JRoute::_('index.php?option=com_splms&view=course&id='.$result->id.':'.$result->alias . SplmsHelper::getItemid('courses'));
		}

		return $results;
	}

	// get ratings by item id
	public function getEnrolled($course) {
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('COUNT(*)');
	    $query->from($db->quoteName('#__splms_orders', 'a'));
	    $query->where($db->quoteName('a.course_id') . ' = ' . $db->quote($course));
	    $query->where($db->quoteName('a.published')." = ".$db->quote('1'));
	    $db->setQuery($query);
		
		return $db->loadResult();
	}

	// get user's review by item id
	public function getMyReview($item_id) {
		$user = JFactory::getUser();
		if($user->id) {
			$db = JFactory::getDbo();
			$query = $db->getQuery(true);
			$query->select( array('a.*', 'b.email', 'b.name') );
	    	$query->from($db->quoteName('#__splms_reviews', 'a'));
	    	$query->join('LEFT', $db->quoteName('#__users', 'b') . ' ON (' . $db->quoteName('a.created_by') . ' = ' . $db->quoteName('b.id') . ')');
	    	$query->where($db->quoteName('a.course_id') . ' = ' . $db->quote($item_id));
		    $query->where($db->quoteName('a.created_by') . ' = ' . $db->quote($user->id));
		    $query->where($db->quoteName('a.published')." = ".$db->quote('1'));
		    $db->setQuery($query);
		    $review = $db->loadObject();
		    if($review) {
		    	$review->gravatar = md5($review->email);
	    		$review->created_date = SplmsHelper::timeago($review->created);
		    	return $review;
			}
		    return false;
		}

	    return false;
	}

	// get reviews by movie id
	public function getReviews($item_id) {
		$params = JComponentHelper::getParams('com_splms');
		$input 	= JFactory::getApplication()->input;
		$start 	= $input->post->get('start', 0, 'INT');
		$limit 	= $params->get('review_limit', 12);
		$db 	= JFactory::getDbo();
		$query 	= $db->getQuery(true);
		$query->select( array('a.*', 'b.email', 'b.name') );
	    $query->from($db->quoteName('#__splms_reviews', 'a'));
	    $query->join('INNER', $db->quoteName('#__users', 'b') . ' ON (' . $db->quoteName('a.created_by') . ' = ' . $db->quoteName('b.id') . ')');
	    $query->where($db->quoteName('a.course_id') . ' = ' . $db->quote($item_id));
	    $query->where($db->quoteName('a.published')." = ".$db->quote('1'));
	    $query->order($db->quoteName('a.created') . ' DESC');
	    $query->setLimit($limit, $start);
	    $db->setQuery($query);
		$reviews = $db->loadObjectList();

		return $reviews;
	}

	// get ratings by item id
	public function getRatings($item_id) {
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select( array('COUNT(a.rating) AS count', 'SUM(a.rating) AS total') );
	    $query->from($db->quoteName('#__splms_reviews', 'a'));
	    $query->where($db->quoteName('a.course_id') . ' = ' . $db->quote($item_id));
	    $query->where($db->quoteName('a.published')." = ".$db->quote('1'));
	    $db->setQuery($query);
		
		return $db->loadObject();
	}

	// Get total reviews by ote, id
	public function getTotalReviews($item_id) {
		$input = JFactory::getApplication()->input;
		$start 	= $input->post->get('start', 0, 'INT');
		$limit 	= 1;
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select( array('COUNT(a.id)') );
	    $query->from($db->quoteName('#__splms_reviews', 'a'));
	    $query->join('INNER', $db->quoteName('#__users', 'b') . ' ON (' . $db->quoteName('a.created_by') . ' = ' . $db->quoteName('b.id') . ')');
	    $query->where($db->quoteName('a.course_id') . ' = ' . $db->quote($item_id));
	    $query->where($db->quoteName('a.published')." = ".$db->quote('1'));
	    $db->setQuery($query);
		
		return $db->loadResult();
	}



}
