<?php
/**
* @package com_splms
* @author JoomShaper http://www.joomshaper.com
* @copyright Copyright (c) 2010 - 2018 JoomShaper
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

// No Direct Access
defined ('_JEXEC') or die('Resticted Aceess');

class SplmsControllerQuizquestions extends JControllerForm{

	public function __construct($config = array()){
		parent::__construct($config);
	}

	public function onBeforeBrowse(){
		$app		= JFactory::getApplication();
		$params		= $app->getParams();

		$this->getThisModel()->limit( $params->get('limit', 6) );
		$this->getThisModel()->limitstart($this->input->getInt('limitstart', 0));
		return true;
	}

	public function display($cachable = false, $urlparams = false, $tpl = null){
		
		$cachable = true;
		if (!is_array($urlparams))
		{
			$urlparams = [];
		}
		$additionalParams = array(
			'catid' => 'INT',
			'id' => 'INT',
			'cid' => 'ARRAY',
			'year' => 'INT',
			'month' => 'INT',
			'limit' => 'UINT',
			'limitstart' => 'UINT',
			'showall' => 'INT',
			'return' => 'BASE64',
			'filter' => 'STRING',
			'filter_order' => 'CMD',
			'filter_order_Dir' => 'CMD',
			'filter-search' => 'STRING',
			'print' => 'BOOLEAN',
			'lang' => 'CMD',
			'Itemid' => 'INT');

		$urlparams = array_merge($additionalParams, $urlparams);
		parent::display($cachable, $urlparams, $tpl);
	}

	public function submit_result() {

		$status = false;
		// Load Lessons model
		jimport('joomla.application.component.model');
		JModelLegacy::addIncludePath(JPATH_SITE.'/components/com_splms/models');
		// Load Quiz model
		$quiz_model = JModelLegacy::getInstance('quizquestions', 'SplmsModel');
		
		$input = JFactory::getApplication()->input;
		$data = $input->post->get('data', NULL, 'ARRAY');

		$user_id = $data['user_id'];
		$quiz_id = $data['quiz_id'];
		$course_id = $data['course_id'];
		$total_marks = $data['total_marks'];
		$q_result = $data['q_result'];

		$insert_data = $quiz_model->insertQuizResult($user_id, $quiz_id, $course_id, $total_marks, $q_result);

		if ($insert_data) {
			$status = true;
		}

		echo json_encode($status);
		die();

	}


}