<?php
/**
* @package com_splms
* @author JoomShaper http://www.joomshaper.com
* @copyright Copyright (c) 2010 - 2018 JoomShaper
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

// No Direct Access
defined ('_JEXEC') or die('Resticted Aceess');

class SplmsControllerPayment extends JControllerForm {

	public function getModel($name = 'form', $prefix = '', $config = array('ignore_request' => true)) {
		$model = parent::getModel($name, $prefix, $config); 
		return $model; 
	}

	public function success() {
		$input = JFactory::getApplication()->input; 

		if ( $input->get('st') == 'Completed' ) {
			JFactory::getApplication()->enqueueMessage(JText::_('COM_SPLMS_PAYMENT_SUCCESSFUL'), 'success');
		} elseif ($input->get('st') == 'Pending') {
			JFactory::getApplication()->enqueueMessage(JText::_('COM_SPLMS_PAYMENT_PENDING'), 'success');
		}
		$cookie  = JFactory::getApplication()->input->cookie;
		$cookie->set('splmsOrders', null, time() - 1);
	}

	public function paymencancel() {
		$output = '<div class="alert alert-danger">'; 
			$output .= '<p>' . JText::_('COM_SPLMS_PAYMENT_ERROR') . '</p>'; 
		$output .= '</div>'; 
		echo $output; 
		return; 
	}

	public function notify() {
		jimport('joomla.application.component.helper'); 
		jimport('joomla.log.log'); 
		$input = JFactory::getApplication()-> input; 
		$params = JComponentHelper::getParams('com_splms'); 
		
		// Load Lessons model
		jimport('joomla.application.component.model'); 
		JModelLegacy::addIncludePath(JPATH_SITE . '/components/com_splms/models'); 
		$model = JModelLegacy::getInstance('Payment', 'SplmsModel'); 

		if ($input->get('txn_id') && $input->get('txn_type')) {

			$raw_post_data = file_get_contents('php://input');
			$raw_post_array = explode('&', $raw_post_data); 
			$myPost = array(); 

			foreach ($raw_post_array as $keyval) {
				$keyval = explode('=', $keyval); 
				if (count($keyval) == 2) {
					if ($keyval[0] === 'payment_date') {
						if (substr_count($keyval[1], '+') === 1) {
							$keyval[1] = str_replace('+', '%2B', $keyval[1]); 
						}
					}
					$myPost[$keyval[0]] = urldecode($keyval[1]); 
				}
			}

			$req = 'cmd=_notify-validate'; 
			$get_magic_quotes_exists = false; 

			if (function_exists('get_magic_quotes_gpc')) {
				$get_magic_quotes_exists = true; 
			}

			foreach ($myPost as $key => $value) {
				if ($get_magic_quotes_exists == true && get_magic_quotes_gpc() == 1) {
					$value = urlencode(stripslashes($value)); 
				}else {
					$value = urlencode($value); 
				}
				$req .= "&$key=$value"; 
			}

			$verify_url = ( $params->get('shop_environment') == 'sandbox' ) ? 'https://ipnpb.sandbox.paypal.com/cgi-bin/webscr' : 'https://ipnpb.paypal.com/cgi-bin/webscr';

			$ch = curl_init($verify_url); 
			curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1); 
			curl_setopt($ch, CURLOPT_POST, 1); 
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 
			curl_setopt($ch, CURLOPT_POSTFIELDS, $req); 
			curl_setopt($ch, CURLOPT_SSLVERSION, 6); 
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 1); 
			curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2); 
			curl_setopt($ch, CURLOPT_FORBID_REUSE, 1); 
			curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 30); 
			curl_setopt($ch, CURLOPT_HTTPHEADER, array('Connection: Close')); 
			$res = curl_exec($ch); 

			if ( ! ($res)) {
				$errno = curl_errno($ch); 
				$errstr = curl_error($ch); 
				JLog::add("cURL error: [$errno] $errstr", JLog::WARNING, 'com_splms'); 
				//curl_close($ch);
			}

			$info = curl_getinfo($ch); 
			$http_code = $info['http_code']; 
			if ($http_code != 200) {
				JLog::add("PayPal responded with http code $http_code", JLog::WARNING, 'com_splms'); 
			}
			curl_close($ch); 

			if ($res == 'VERIFIED') {
				// check whether the payment_status is Completed
				// $dublicate_txn_id = $model->getDublicateTransaction($txn_id);
				if ($params->get('shop_environment') == 'sandbox') {
					$payment_conditions = $params->get('paypal_id') == $input->get('receiver_email', NULL, 'RAW'); 
				} else {
					$payment_conditions = ($input->get('payment_status') == 'Completed') && ($params->get('paypal_id') == $input->get('receiver_email', NULL, 'EMAIL')); 
				}

				if ($payment_conditions) {

					for ($i = 1; $i <= $input->get('num_cart_items', 1); $i++) {
						$user_id = $input->get('custom'); 
						$user_info = JFactory::getUser($user_id); 
						$item_number = $input->get('item_number' . $i); 
						$payment_amount = $input->get('mc_gross_' . $i); 
						$payment_currency = $input->get('mc_currency'); 
						$txn_id = $input->get('txn_id'); 
						$invoice_id = $input->get('invoice'); 
						$payment_status = $input->get('payment_status', NULL, 'WORD'); 

						$orderinfo = array(
							'user_id' => $user_id, 
							'payment_amount' => $payment_amount, 
							'payment_currency' => $payment_currency, 
							'txn_id' => $txn_id, 
							'item_number' => $item_number, 
							'invoice_id' => $invoice_id, 
							'payment_status' => $payment_status); 

						$dublicate_item = $model->getDublicateTransaction('', $item_number, $user_id);
						if(!$dublicate_item){
							$insertorder = $model->storeOrder($orderinfo);
							if ($insertorder && isset($user_info->email) && $user_info->email) {
								self::sendPurchasdeMail($user_info->email); 
							}
						}

					}
				}
			} elseif (($input->get('payment_status') == 'Pending')) {

					for ($i = 1; $i <= $input-> get('num_cart_items', 1); $i++) {
						$user_id = $input->get('custom'); 
						$user_info = JFactory::getUser($user_id); 
						$item_number = $input->get('item_number' . $i); 
						$payment_amount = $input->get('mc_gross_' . $i); 
						$payment_currency = $input-> get('mc_currency'); 
						$txn_id = $input->get('txn_id'); 
						$invoice_id = $input->get('invoice'); 
						$payment_status = $input->get('payment_status'); 

						$orderinfo = array(
							'user_id' => $user_id, 
							'payment_amount' => $payment_amount, 
							'payment_currency' => $payment_currency, 
							'txn_id' => $txn_id, 
							'item_number' => $item_number, 
							'invoice_id' => $invoice_id, 
							'payment_status' => $payment_status); 

						$dublicate_item = $model->getDublicateTransaction('', $item_number, $user_id);
						file_put_contents( __DIR__ .'/iteminfoa.txt', json_encode($dublicate_item) );
						if(!$dublicate_item){
							$insertorder = $model->storeOrder($orderinfo);
							if ($insertorder && isset($user_info->email) && $user_info->email) {
								self::sendPurchasdeMail($user_info->email); 
							}
						}
					}
			} else { // End Verified
				if (($input->get('payment_status') == 'Refunded') || ($input->get('payment_status') == 'Reversed')) {
					$txn_id = $input->get('txn_id'); 
					$invoice_id = $input->get('invoice'); 
					$item_number = $input->get('item_number'); 

					$orderinfo = array(
						'txn_id' => $txn_id, 
						'invoice_id' => $invoice_id, 
						'item_number' => $item_number, 
						'payment_status' => $payment_status); 

					$model-> refundOrder($orderinfo); 
				}
			}

		}
	}

	// Direct payment
	public function direactPayment() {

		$user = JFactory::getUser(); 
		// Load Lessons model
		jimport('joomla.application.component.model'); 
		JModelLegacy::addIncludePath(JPATH_SITE . '/components/com_splms/models'); 
		$model = JModelLegacy::getInstance('Payment', 'SplmsModel'); 
		
		//Get cookie
		$cookie  = JFactory::getApplication()->input->cookie;
		$orders_info = $cookie->get('splmsOrders', base64_encode(serialize(array())));
		$orders_info = unserialize(base64_decode($orders_info));

		if ($user-> guest) {
			JFactory::getApplication()->enqueueMessage(JText::_('COM_SPLMS_CART_LOGIN_TO_CHECKOUT'), 'warning'); 
		} elseif (isset($orders_info) && is_array($orders_info)) {
			if (count($orders_info)) {
				$model->insertOrders($orders_info); 
				//clear cookie
				$cookie->set('splmsOrders', null, time() - 1);
				
				if (isset($user->email) && $user->email) {
					self::sendPurchasdeMail($user->email, $orders_info); 
				}
				JFactory::getApplication()-> enqueueMessage(JText::_('COM_SPLMS_DIRECT_ORDER_SUBMITED'), 'success'); 
			} else {
				JFactory::getApplication()-> enqueueMessage(JText::_('COM_SPLMS_NO_ITEM_IN_CART'), 'warning');
			}
		} else {
			JFactory::getApplication()-> enqueueMessage(JText::_('COM_SPLMS_SOMETHING_WRONG'), 'warning');
		}
	}

	private function sendPurchasdeMail($customer_mail = '', $item_orders) {

		$order_courses = array(); 

		$total_price = 0; 
		foreach ($item_orders as $key => $item_order) {
			 $order_courses[$key] = $item_order['product_name']; 
			 $total_price += $item_order['price']; 
		}
		$course_name = implode(', ', $order_courses); 
		$total_price = SplmsHelper::generateCurrency($total_price); 
		$search_msg = array('{courses}', '{total_price}'); 
		$replace_msg = array($course_name, $total_price); 

		jimport('joomla.application.component.helper'); 
		$params = JComponentHelper::getParams('com_splms'); 
		$notify_mail = $params->get('notify_mail', ''); 
		$notify_name = $params->get('notify_name', ''); 
		$confirmation_txt = $params->get('confirmation_txt', ''); 
		$subject = 'You have successfully enrolled in ' . $course_name; 
		$message = '<p>' . str_ireplace($search_msg, $replace_msg, nl2br($confirmation_txt)) . '</p>'; 

		$mail = JFactory::getMailer(); 
		$sender = array($notify_mail, $notify_name); 
		$mail->setSender($sender); 
		$mail->addRecipient($customer_mail); 
		$mail->addCC($notify_mail); 
		$mail->setSubject($subject); 
		$mail->isHTML(true); 
		$mail->Encoding = 'base64'; 
		$mail->setBody($message); 
		$mail->Send(); 

	}
}