<?php
/**
* @package com_splms
* @author JoomShaper http://www.joomshaper.com
* @copyright Copyright (c) 2010 - 2018 JoomShaper
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

// No Direct Access
defined ('_JEXEC') or die('Resticted Aceess');

class SplmsViewTeachers extends JViewLegacy{

	protected $items;
	protected $pagination;
	protected $state;
	public $filterForm;
	public $activeFilters;
	protected $sidebar;

	function display($tpl = null){

		// Get application
		$app = JFactory::getApplication();
		$context = "com_splms.teachers";

		// Get data from the model
		$this->items = $this->get('Items');
		$this->pagination = $this->get('Pagination');
		$this->state = $this->get('State');
		$this->filter_order = $app->getUserStateFromRequest($context.'filter_order', 'filter_order', 'id', 'cmd');
		$this->filter_order_Dir = $app->getUserStateFromRequest($context.'filter_order_Dir', 'filter_order_Dir', 'desc', 'cmd');
		$this->filterForm = $this->get('FilterForm');
		$this->activeFilters = $this->get('ActiveFilters');
		$this->canDo = SplmsHelper::getActions();

		// Check for errors.
		if (count($errors = $this->get('Errors'))){
			JError::raiseError(500, implode('<br />', $errors));
			return false;
		}

		// has access visite this view
		SplmsHelper::hasVisitAccess();

		// Set the submenu
		SplmsHelper::addSubmenu('teachers');
		$this->addToolBar();
		$this->sidebar = JHtmlSidebar::render();

		foreach ($this->items as $item) {
			$item->specialist_in = $item->specialist_in;
			if($item->specialist_in) {
				$specalitist_decodes = (array) json_decode($item->specialist_in);
				if ($specalitist_decodes) {
					$item->specialist_in = array ();
					$i = 0;
					foreach ($specalitist_decodes as $key => $teachers_decode) {
						if ($teachers_decode->specialist_text) {
							$item->specialist_in[$i] = $teachers_decode->specialist_text;
							$i ++;
						}
					}
					$item->specialist_in = implode(',', $item->specialist_in);
				} elseif( $item->specialist_in == '' ) {
					$item->specialist_in = '....';
				}
			}
		}

		return parent::display($tpl);
	}

	protected function addToolBar() {
		JToolBarHelper::title(JText::_('COM_SPLMS_PAGE_HEADING') .  JText::_('COM_SPLMS_TEACHERS'));

		if ($this->canDo->get('core.create')) {
			JToolBarHelper::addNew('teacher.add', 'JTOOLBAR_NEW');
		}
		if ($this->canDo->get('core.edit')) {
			JToolBarHelper::editList('teacher.edit', 'JTOOLBAR_EDIT');
		}

		if ($this->canDo->get('core.edit.state')) {
			JToolbarHelper::publish('teachers.publish', 'JTOOLBAR_PUBLISH', true);
			JToolbarHelper::unpublish('teachers.unpublish', 'JTOOLBAR_UNPUBLISH', true);
			JToolbarHelper::archiveList('teachers.archive');
			JToolbarHelper::checkin('teachers.checkin');
		}

		if ($this->state->get('filter.published') == -2 && $this->canDo->get('core.delete')) {
			JToolbarHelper::deleteList('', 'teachers.delete', 'JTOOLBAR_EMPTY_TRASH');
		} elseif ($this->canDo->get('core.edit.state')) {
			JToolbarHelper::trash('teachers.trash');
		}

		if ($this->canDo->get('core.admin')) {
			JToolBarHelper::divider();
			JToolBarHelper::preferences('com_splms');
		}
	}
}
