<?php
/**
* @package com_splms
* @author JoomShaper http://www.joomshaper.com
* @copyright Copyright (c) 2010 - 2018 JoomShaper
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

// No direct access
defined('_JEXEC') or die('Restricted access');

class SplmsViewDashboard extends JViewLegacy {

	public function display($tpl = null) {

		$model = $this->getModel('Dashboard');
		$this->orders = $model->getOrders();
		$this->courses = $model->getCourses();
		$this->lessons = $model->getLessons();
		$this->total = $model->getTotalSales();
		$this->earnings = $model->generateCurrency($this->total);
		$this->users = $model->getUsers();
		$this->courseList = $model->getCourseList();
		$this->orderList = $model->getOrderList();
		$this->orderList = (!isset($this->orderList) && !count($this->orderList)) ? array() : $this->orderList;
		
		$this->canDo = SplmsHelper::getActions();

		// has access visite this view
		SplmsHelper::hasVisitAccess();

		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JError::raiseError(500, implode('<br />', $errors));
			return false;
		}

		SplmsHelper::addSubmenu('dashboard');
		$this->addToolBar();
		$this->sidebar = JHtmlSidebar::render();
		parent::display($tpl);
	}

	protected function addToolBar() {
		JToolBarHelper::title(JText::_('COM_SPLMS_PAGE_HEADING') .  JText::_('COM_SPLMS_MANAGER_DASHBOARD'));

		if ($this->canDo->get('core.admin')) {
			JToolBarHelper::preferences('com_splms');
		}
	}

}
