<?php
/**
 * @package     SP LMS
 *
 * @copyright   Copyright (C) 2010 - 2017 JoomShaper. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die('Restricted access!');

jimport('joomla.filesystem.file');

class JFormFieldCourses extends JFormField{

	protected $type = 'Courses';

	public function getCourses() {

		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('*');
		$query->from($db->quoteName('#__splms_courses'));
		$query->where($db->quoteName('published')." = 1");
		$query->where('published = 1');
		$query->order('ordering DESC');
		$db->setQuery($query);

		return $db->loadObjectList();

	}

	public function getInput() {
		$courses = $this->getCourses();
		$courseid = '';
		if ($this->value) {
			$courseid = $this->value;
		}

		$selected = ($courseid == '') ? 'selected' : '' ;

		$output = '';
		$output .= '<select id="'.$this->id.'" name="'.$this->name.'" onchange="this.form.submit();">';
		$output .= '<option value="" ' . $selected . '>'. JText::_('COM_SPSPLMS_FILTER_COURSES') .'</option>';
		foreach ($courses as $key => $course) {
			$selected = ($course->id == $courseid) ? 'selected' : '' ;
			$output .= '<option value="'. $course->id .'" ' . $selected . '>'. $course->title .'</option>';
		}
		$output .= '</select>';

		return $output;
	}

}
