<?php
/**
* @package com_splms
* @author JoomShaper http://www.joomshaper.com
* @copyright Copyright (c) 2010 - 2018 JoomShaper
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

// No Direct Access
defined ('_JEXEC') or die('Resticted Aceess');

class SplmsHelper {

	public static $extension = 'com_splms';

	public static function addSubmenu($submenu) {

		// check access if not then throw error
		$user = JFactory::getUser();
		$is_admin = $user->authorise('core.admin');
		$groups = JAccess::getGroupsByUser($user->id);
		
		if (in_array(7, $groups) || in_array(8, $groups) || $is_admin) {
			JHtmlSidebar::addEntry(
				JText::_('COM_SPLMS_DASHBOARD'),
				'index.php?option=com_splms',
				$submenu == 'dashboard'
			);
		}

		if (in_array(7, $groups) || in_array(8, $groups) || $is_admin) {
			JHtmlSidebar::addEntry(
				JText::_('COM_SPLMS_TEACHERS'),
				'index.php?option=com_splms&view=teachers',
				$submenu == 'teachers'
			);
		}

		if (in_array(7, $groups) || in_array(8, $groups) || $is_admin) {
			JHtmlSidebar::addEntry(
				JText::_('COM_SPLMS_COURSE_CATEGORIES'),
				'index.php?option=com_splms&view=coursescategories',
				$submenu == 'coursescategories'
			);
		}

		JHtmlSidebar::addEntry(
			JText::_('COM_SPLMS_COURSES'),
			'index.php?option=com_splms&view=courses',
			$submenu == 'courses'
		);

		JHtmlSidebar::addEntry(
			JText::_('COM_SPLMS_LESSONS'),
			'index.php?option=com_splms&view=lessons',
			$submenu == 'lessons'
		);

		JHtmlSidebar::addEntry(
			JText::_('COM_SPLMS_TITLE_QUIZQUESTIONS'),
			'index.php?option=com_splms&view=quizquestions',
			$submenu == 'quizquestions'
		);

		if (in_array(7, $groups) || in_array(8, $groups) || $is_admin) {
			JHtmlSidebar::addEntry(
				JText::_('COM_SPLMS_TITLE_QUIZRESULTS'),
				'index.php?option=com_splms&view=quizresults',
				$submenu == 'quizresults'
			);
		}

		if (in_array(7, $groups) || in_array(8, $groups) || $is_admin) {
			JHtmlSidebar::addEntry(
				JText::_('COM_SPLMS_TITLE_CERTIFICATES'),
				'index.php?option=com_splms&view=certificates',
				$submenu == 'certificates'
			);
		}

		if (in_array(7, $groups) || in_array(8, $groups) || $is_admin) {
			JHtmlSidebar::addEntry(
				JText::_('COM_SPLMS_SPEAKERS'),
				'index.php?option=com_splms&view=speakers',
				$submenu == 'speakers'
			);
		}

		if (in_array(7, $groups) || in_array(8, $groups) || $is_admin) {
			JHtmlSidebar::addEntry(
				JText::_('COM_SPLMS_EVENT_CATEGORIES'),
				'index.php?option=com_splms&view=eventcategories',
				$submenu == 'eventcategories'
			);
		}

		if (in_array(7, $groups) || in_array(8, $groups) || $is_admin) {
			JHtmlSidebar::addEntry(
				JText::_('COM_SPLMS_EVENTS'),
				'index.php?option=com_splms&view=events',
				$submenu == 'events'
			);
		}

		if (in_array(7, $groups) || in_array(8, $groups) || $is_admin) {
			JHtmlSidebar::addEntry(
				JText::_('COM_SPLMS_REVIEWS'),
				'index.php?option=com_splms&view=reviews',
				$submenu == 'reviews'
			);
		}
		
		if (in_array(7, $groups) || in_array(8, $groups) || $is_admin) {
			JHtmlSidebar::addEntry(
				JText::_('COM_SPLMS_ORDERS'),
				'index.php?option=com_splms&view=orders',
				$submenu == 'orders'
			);
		}
	}
	// check access if not then redirect to the courses page
	public static function hasVisitAccess() {
		$user 		= JFactory::getUser();
		$is_admin 	= $user->authorise('core.admin');
		$groups 	= JAccess::getGroupsByUser($user->id);
		if (!in_array(7, $groups) && !in_array(8, $groups) && !$is_admin) {
			$app = JFactory::getApplication();
			$app->redirect(JRoute::_('index.php?option=com_splms&view=courses', false));
		}
	}

	public static function getActions($messageId = 0) {
		$result	= new JObject;

		if (empty($messageId)) {
			$assetName = 'com_splms';
		} else {
			$assetName = 'com_splms.course.'.(int) $messageId;
		}

		$actions = JAccess::getActions('com_splms', 'component');

		foreach ($actions as $action) {
			$result->set($action->name, JFactory::getUser()->authorise($action->name, $assetName));
		}

		return $result;
	}

	// Create thumbs
	public static function createThumbs($src, $sizes = array(), $folder, $base_name, $ext) {

		list($originalWidth, $originalHeight) = getimagesize($src);

		switch($ext) {
			case 'bmp': $img = imagecreatefromwbmp($src); break;
			case 'gif': $img = imagecreatefromgif($src); break;
			case 'jpg': $img = imagecreatefromjpeg($src); break;
			case 'jpeg': $img = imagecreatefromjpeg($src); break;
			case 'png': $img = imagecreatefrompng($src); break;
		}

		if(count($sizes)) {
			$output = array();

			if($base_name) {
				$output['original'] = $folder . '/' . $base_name . '.' . $ext;
			}

			foreach ($sizes as $key => $size) {
				$targetWidth = $size[0];
				$targetHeight = $size[1];
				$ratio_thumb = $targetWidth/$targetHeight;
				$ratio_original = $originalWidth/$originalHeight;

				if ($ratio_original >= $ratio_thumb) {
					$height = $originalHeight;
					$width = ceil(($height*$targetWidth)/$targetHeight);
					$x = ceil(($originalWidth-$width)/2);
					$y = 0;
				} else {
					$width = $originalWidth;
					$height = ceil(($width*$targetHeight)/$targetWidth);
					$y = ceil(($originalHeight-$height)/2);
					$x = 0;
				}

				$new = imagecreatetruecolor($targetWidth, $targetHeight);

				if($ext == "gif" or $ext == "png") {
					imagecolortransparent($new, imagecolorallocatealpha($new, 0, 0, 0, 127));
					imagealphablending($new, false);
					imagesavealpha($new, true);
				}

				imagecopyresampled($new, $img, 0, 0, $x, $y, $targetWidth, $targetHeight, $width, $height);

				if($base_name) {
					$dest = dirname($src) . '/' . $base_name . '_' . $key . '.' . $ext;
					$output[$key] = $folder . '/' . $base_name . '_' . $key . '.' . $ext;
				} else {
					$dest = $folder . '/' . $key . '.' . $ext;
				}

				switch($ext){
					case 'bmp': imagewbmp($new, $dest); break;
					case 'gif': imagegif($new, $dest); break;
					case 'jpg': imagejpeg($new, $dest); break;
					case 'jpeg': imagejpeg($new, $dest); break;
					case 'png': imagepng($new, $dest); break;
				}
			}

			return $output;
		}

		return false;
	}

	// Get Orders
	public static function getOrders() {
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('COUNT(id)');
		$query->from($db->quoteName('#__splms_orders'));
		$query->where($db->quoteName('published')." = 1");
		$query->order('ordering DESC');
		$db->setQuery($query);
		$results = $db->loadResult();

		return $results;
	}

	// Get Orders
	public static function getCourses() {
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('COUNT(id)');
		$query->from($db->quoteName('#__splms_courses'));
		$query->where($db->quoteName('published')." = 1");
		$query->order('ordering DESC');
		$db->setQuery($query);
		$results = $db->loadResult();

		return $results;
	}

	// Get Lessons
	public static function getLessons() {
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('COUNT(id)');
		$query->from($db->quoteName('#__splms_lessons'));
		$query->where($db->quoteName('published')." = 1");
		$query->order('ordering DESC');
		$db->setQuery($query);
		$results = $db->loadResult();

		return $results;
	}

	// Get Users
	public static function getUsers() {
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('COUNT(id)');
		$query->from($db->quoteName('#__users'));
		$query->where($db->quoteName('block')." = 0");
		$db->setQuery($query);
		$results = $db->loadResult();

		return $results;
	}

	//Get total sales by day
	public static function getTotalSales() {

		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('SUM(order_payment_price)');
		$query->from($db->quoteName('#__splms_orders'));
		$query->where($db->quoteName('published')." = 1");
		$db->setQuery($query);
		$results = $db->loadResult();

		return round($results,2);
	}

	//Get total sales by day
	public static function getSales($day, $month, $year) {

		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('SUM(order_payment_price)');
		$query->from($db->quoteName('#__splms_orders'));
		$query->where('DAY(created) = ' . $day);
		$query->where('MONTH(created) = ' . $month);
		$query->where('YEAR(created) = ' . $year);
		$query->where($db->quoteName('published')." = 1");
		$db->setQuery($query);
		$results = $db->loadResult();

		return $results;
	}

	//Orders List
	public static function getOrdersList() {
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select($db->quoteName(array('a.splms_order_id', 'a.id', 'a.created', 'a.order_payment_price', 'b.title', 'b.id')));
		$query->from($db->quoteName('#__splms_orders', 'a'));
		$query->join('LEFT', $db->quoteName('#__splms_courses', 'b') . ' ON (' . $db->quoteName('a.id') . ' = ' . $db->quoteName('b.id') . ')');
		$query->where($db->quoteName('a.published')." = 1");
		$query->setLimit('5');
		$query->order('a.ordering DESC');
		$db->setQuery($query);
		$results = $db->loadObjectList();

		return $results;
	}
	// Get Courses List
	public static function getCoursesList() {
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select($db->quoteName(array('id', 'title', 'created', 'price')));
		$query->from($db->quoteName('#__splms_courses'));
		$query->where($db->quoteName('published')." = 1");
		$query->setLimit('5');
		$query->order('ordering DESC');
		$db->setQuery($query);
		$results = $db->loadObjectList();

		return $results;
	}

	// Generate Currency
	public static function generateCurrency($amt = 0, $sale_amt = null){
		//Joomla Component Helper & Get LMS Params
		jimport('joomla.application.component.helper');
		$params = JComponentHelper::getParams('com_splms');

		//Get Currency
		$currency = explode(':', $params->get('currency', 'USD:$'));

		switch ($currency[0]) {
			case 'USD':
				$lancode = 'en_US';
				break;

			case 'GBP':
				$lancode = 'en_GB';
				break;

			case 'RUB':
				$lancode = 'ru_RU';
				break;

			case 'BRL':
				$lancode = 'pt_BR';
				break;

			case 'CAD':
				$lancode = 'en_CA';
				break;

			case 'CZK':
				$lancode = 'cs_CZ';
				break;

			case 'DKK':
				$lancode = 'en_DK';
				break;

			case 'EUR':
				$lancode = 'fr_FR';
				break;

			case 'HKD':
				$lancode = 'zh_HK';
				break;

			case 'HUF':
				$lancode = 'hu_HU';
				break;

			case 'ILS':
				$lancode = 'zh_HK';
				break;

			case 'JPY':
				$lancode = 'ja_JP';
				break;

			case 'MXN':
				$lancode = 'es_MX';
				break;

			case 'NOK':
				$lancode = 'nb_NO';
				break;

			case 'NZD':
				$lancode = 'en_GB';
				break;

			case 'PHP':
				$lancode = 'en_PH';
				break;

			case 'PLN':
				$lancode = 'pl_PL';
				break;

			case 'SGD':
				$lancode = 'zh_SG';
				break;

			case 'SEK':
				$lancode = 'sv_SE';
				break;

			case 'CHF':
				$lancode = 'de_LI';
				break;

			case 'TWD':
				$lancode = 'zh_TW';
				break;

			case 'THB':
				$lancode = 'th_TH';
				break;

			case 'TRY':
				$lancode = 'tr_TR';
				break;

			default:
				$lancode = 'en_US';
				break;
		}

		// $fmt = new NumberFormatter( $lancode, NumberFormatter::CURRENCY );
		// $result = $fmt->formatCurrency($amt, $currency[0]);
		if ($currency[0] == 'EUR' || $currency[0] == 'RUB' || $currency[0] == 'CZK' || $currency[0] == 'HUF' || $currency[0] == 'PLN') {
			setlocale(LC_MONETARY, $lancode);
			if (function_exists('money_format')) {
				$price = money_format( '%!n ' . $currency[1], $amt);
				$sale_price = ($sale_amt) ? money_format( '%!n ' . $currency[1], $sale_amt) : '' ;
			} else {
				$price = self::money_format( '%!n ' . $currency[1], $amt);
				$sale_price = ($sale_amt) ? self::money_format( '%!n ' . $currency[1], $sale_amt) : '' ;
			}
		} else {
			setlocale(LC_MONETARY, $lancode);
			if (function_exists('money_format')) {
				$price = money_format( $currency[1] . '%!n', $amt);
				$sale_price = ($sale_amt) ? money_format( $currency[1] . '%!n', $sale_amt) : '' ;
			} else {
				$price = self::money_format( $currency[1] . '%!n', $amt);
				$sale_price = ($sale_amt) ? self::money_format( $currency[1] . '%!n', $sale_amt) : '' ;
			}
		}

		$output = '';
		$output .= '<div class="splms-price-box">';
		if ($sale_amt) {
			$output .= '<ins>';
	           $output .= '<div class="splms-sale-price">';
	            	$output .= '<span>' . $sale_price . '</span>';
	            $output .= '</div>';
	        $output .= '</ins>';

	        $output .= '<del>';
	            $output .= '<div class="splms-item-price">';
	            	$output .= '<span>' . $price . '</span>';
	            $output .= '</div>';
	        $output .= '</del>';
		} else {
			$output .= $price;
		}
		$output .= '</div>';


		return $output;
	}
	// Get component version
	public static function getVersion() {
		$db = JFactory::getDbo();
		$query = $db->getQuery(true)
		->select('e.manifest_cache')
		->select($db->quoteName('e.manifest_cache'))
		->from($db->quoteName('#__extensions', 'e'))
		->where($db->quoteName('e.element') . ' = ' . $db->quote('com_splms'));
		$db->setQuery($query);
		$manifest_cache = json_decode($db->loadResult());
		if(isset($manifest_cache->version) && $manifest_cache->version) {
			return $manifest_cache->version;
		}
		
		return '1.0';
	}

}
