<?php

/**
 * @package Tixon
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2017 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */
//no direct accees
defined('_JEXEC') or die('resticted aceess');

class SppagebuilderAddonSlideshow_owl extends SppagebuilderAddons {

	public function render() {
		$autoplay = (isset($this->addon->settings->autoplay) && $this->addon->settings->autoplay) ? $this->addon->settings->autoplay : '';
        $controllers = (isset($this->addon->settings->controllers) && $this->addon->settings->controllers) ? $this->addon->settings->controllers : '';
		$class = (isset($this->addon->settings->class) && $this->addon->settings->class) ? $this->addon->settings->class : '';
		
		//Check Auto Play
		$slide_autoplay = ($autoplay)? 'data-sppb-slide-ride="true"':'';
		$slide_controllers = ($controllers)? 'data-sppb-slidefull-controllers="true"':'';

		// Generate css styles

		$output  = '<div class="sppb-slider-owl-wrapper owl-theme' . $class . '">';

			$output .= '<div class="sppb-slider-owl-item-wrapper ">';
			$output .= '<div id="sp-slide-owl" class="owl-carousel" ' . $slide_controllers .' ' .$slide_autoplay.' >';
			foreach ($this->addon->settings->sp_slideshow_owl_item as $key => $slide_item) {
				$output   .= '<div class="sppb-slideshow-owl-item item">';
				$output  .= '<div class="sppb-slideshow-owl-item-wrap">';
				if($slide_item->image) $output .= '<img class="sppb-img-responsive " src="'. $slide_item->image .'" alt="' . $slide_item->title . '">';
				$output  .= '<div class="sppb-slideshow-owl-item-overlay">';
				$output  .= '<div class="sppb-slideshow-owl-item-overlay-inner">';
				$output  .= '<div>';
				if($slide_item->title){
					$output .= '<h2 class="sppb-owl-title">' . $slide_item->title . '</h2>';
				}
				if($slide_item->button_text && $slide_item->button_url) {
					$output  .= '<a href="' . $slide_item->button_url . '" class="sppb-btn sppb-btn-primary btn-transparent sppb-slideshow-owl-read-more">' . $slide_item->button_text . '</a>';
				}
				$output  .= '</div>';
				$output  .= '</div>'; // END:: /.sppb-slideshow-owl-item-overlay-inner
				$output  .= '</div>'; // END:: /.sppb-slideshow-owl-item-overlay
				$output  .= '</div>'; // END:: /.sppb-slideshow-owl-item-wra
				$output  .= '</div>'; // END:: /.sppb-slideshow-owl-item
			}		
			$output .= '</div>'; //END:: /.owl-carousel
			$output .= '</div>'; // END:: /.sppb-slider-item-wrapper

			// has dot controls
			if ($controllers) {
				$output .='<div class="owl-dots">';
					$output .='<div class="owl-dot active"><span></span></div>';
					$output .='<div class="owl-dot"><span></span></div>';
					$output .='<div class="owl-dot"><span></span></div>';
				$output .='</div>';
			}		
		$output .='</div>';	//sppb-slider-wrapper 

		return $output;
	}

	public function scripts() {
        $app = JFactory::getApplication();
        $base_path = JURI::base() . '/templates/' . $app->getTemplate() . '/js/';
        return array($base_path . 'owl.carousel.min.js', $base_path . 'addon.sliderowl.js');
    }

    public function js() {
        return'
           jQuery(document).ready(function($){"use strict";

			var $spslideowl = $("#sp-slide-owl");

			var $autoplay   = $spslideowl.attr("data-sppb-slide-ride");
			if ($autoplay == "true") { var $autoplay = true; } else { var $autoplay = false};

			var $controllers   = $spslideowl.attr("data-sppb-slide-controllers");
			if ($controllers == "true") { var $controllers = true; } else { var $controllers = false};
		
			$spslideowl.owlCarousel({
				loop: true,
				margin:0,
				autoplay: $autoplay,
				animateIn: "fadeIn",
				animateOut: "fadeOut",
				items:2,
				touchDrag  : false,
				mouseDrag  : false,
				responsive: {
					0: {
						items: 1
					},
					600: {
						items: 1
					},
					1000: {
						items: 2
					}
				},
				dots: $controllers,
			});
		
		
			$(".sppbSlidePrev").click(function(){
				$spslideowl.trigger("prev.owl.carousel", [400]);
			});
		
			$(".sppbSlideNext").click(function(){
				$spslideowl.trigger("next.owl.carousel",[400]);
			});
        });
        ';
    }

    public function stylesheets() {
        $app = JFactory::getApplication();
        $base_path = JURI::base() . '/templates/' . $app->getTemplate() . '/css/';
        return array($base_path . 'owl.carousel.css', $base_path . 'owl.transitions.css', $base_path . 'slide-animate.css');
    }

    public static function getTemplate() {
		$output = '
		<#
		let slide_autoplay = (data.autoplay)? \'data-sppb-slide-ride="true"\':"";
		let slide_controllers = (data.controllers)? \'data-sppb-slidefull-controllers="true"\':"";
		#>

		<div class="sppb-slider-owl-wrapper owl-theme {{data.class}}">
			<div class="sppb-slider-owl-item-wrapper ">
			<div id="sp-slide-owl" class="owl-carousel" {{slide_controllers}} {{slide_autoplay}}>
			<# _.each (data.sp_slideshow_owl_item, function(slide_item) { #>
				<div class="sppb-slideshow-owl-item item">
				<div class="sppb-slideshow-owl-item-wrap">
				<# if(slide_item.image){ #>
					<img class="sppb-img-responsive " src="{{slide_item.image}}" alt="{{slide_item.title}}">
				<# } #>
				<div class="sppb-slideshow-owl-item-overlay">
				<div class="sppb-slideshow-owl-item-overlay-inner">
				<div>
				<# if(slide_item.title){ #>
					<h2 class="sppb-owl-title">{{{slide_item.title}}}</h2>
				<# }
				if(slide_item.button_text && slide_item.button_url) { #>
					<a href="{{slide_item.button_url}}" class="sppb-btn sppb-btn-primary btn-transparent sppb-slideshow-owl-read-more">{{slide_item.button_text}}</a>
				<# } #>
				</div>
				</div>
				</div>
				</div>
				</div>
			<# }) #>		
			</div>
			</div>

			<# if (data.controllers) { #>
				<div class="owl-dots">
					<div class="owl-dot active"><span></span></div>
					<div class="owl-dot"><span></span></div>
					<div class="owl-dot"><span></span></div>
				</div>
			<# } #>		
		</div>
		';
        return $output;
    }
}