<?php
/**
 * @package SP Page Builder
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2016 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
//no direct accees
defined ('_JEXEC') or die ('restricted aceess');

class SppagebuilderAddonPerson extends SppagebuilderAddons{

	public function render() {

		$class = (isset($this->addon->settings->class) && $this->addon->settings->class) ? $this->addon->settings->class : '';

		//Options
		$image 				= (isset($this->addon->settings->image) && $this->addon->settings->image) ? $this->addon->settings->image : '';
		$name 				= (isset($this->addon->settings->name) && $this->addon->settings->name) ? $this->addon->settings->name : '';
		$designation 	= (isset($this->addon->settings->designation) && $this->addon->settings->designation) ? $this->addon->settings->designation : '';
		$email 				= (isset($this->addon->settings->email) && $this->addon->settings->email) ? $this->addon->settings->email : '';
		$introtext 		= (isset($this->addon->settings->introtext) && $this->addon->settings->introtext) ? $this->addon->settings->introtext : '';
		$facebook 		= (isset($this->addon->settings->facebook) && $this->addon->settings->facebook) ? $this->addon->settings->facebook : '';
		$twitter 			= (isset($this->addon->settings->twitter) && $this->addon->settings->twitter) ? $this->addon->settings->twitter : '';
		$google_plus 	= (isset($this->addon->settings->google_plus) && $this->addon->settings->google_plus) ? $this->addon->settings->google_plus : '';
		$youtube 			= (isset($this->addon->settings->youtube) && $this->addon->settings->youtube) ? $this->addon->settings->youtube : '';
		$linkedin 		= (isset($this->addon->settings->linkedin) && $this->addon->settings->linkedin) ? $this->addon->settings->linkedin : '';
		$pinterest 		= (isset($this->addon->settings->pinterest) && $this->addon->settings->pinterest) ? $this->addon->settings->pinterest : '';
		$flickr 			= (isset($this->addon->settings->flickr) && $this->addon->settings->flickr) ? $this->addon->settings->flickr : '';
		$dribbble 		= (isset($this->addon->settings->dribbble) && $this->addon->settings->dribbble) ? $this->addon->settings->dribbble : '';
		$behance 			= (isset($this->addon->settings->behance) && $this->addon->settings->behance) ? $this->addon->settings->behance : '';
		$instagram 		= (isset($this->addon->settings->instagram) && $this->addon->settings->instagram) ? $this->addon->settings->instagram : '';
		$alignment 		= (isset($this->addon->settings->alignment) && $this->addon->settings->alignment) ? $this->addon->settings->alignment : '';

		$output = '';

		$output  .= '<div class="sppb-addon sppb-addon-person ' . $alignment . ' ' . $class . '">';
		$output  .= '<div class="sppb-addon-content">';
		if($image) {
			$output  .= '<div class="sppb-person-image">';
			$output  .= '<img class="sppb-img-responsive" src="' . $image . '" alt="'. $name .'">';
			// Social Icons
			$socials = array();

			if (isset($twitter) && $twitter) {
				$socials[] = array('twitter', $twitter);
			}

			if (isset($facebook) && $facebook) {
				$socials[] = array('facebook', $facebook);
			}

			if (isset($google_plus) && $google_plus) {
				$socials[] = array('google-plus', $google_plus);
			}

			if (isset($pinterest) && $pinterest) {
				$socials[] = array('pinterest', $pinterest);
			}

			if (isset($linkedin) && $linkedin) {
				$socials[] = array('linkedin', $linkedin);
			}

			if (isset($dribbble) && $dribbble) {
				$socials[] = array('dribbble', $dribbble);
			}

			if (isset($behance) && $behance) {
				$socials[] = array('behance', $behance);
			}

			if (isset($flickr) && $flickr) {
				$socials[] = array('flickr', $flickr);
			}

			if (isset($youtube) && $youtube) {
				$socials[] = array('youtube', $youtube);
			}

			if (isset($instagram) && $instagram) {
				$socials[] = array('instagram', $instagram);
			}

			// Limit social icons
			if (count($socials) > 5) {
				$socials = array_slice($socials, 0, 5);
			}

			if (count($socials)) {
				$output .= '<div class="sppb-person-social-icons">';
				$output .= '<ul class="sppb-person-' . count($socials) . '">';
				foreach ($socials as $key => $social) {
					$output .= '<li class="social-' . ($key + 1) . '">';
					$output .= '<a target="_blank" class="social-' . $social[0] . '" href="' . $social[1] . '"><i class="fa fa-' . $social[0] . '"></i></a>';
					$output .= '</li>';
				}
				$output .= '</ul>';
				$output .= '</div>';
			}
			$output  .= '</div>';
		}
		if($name || $designation || $email) {
			$output  .= '<div class="sppb-person-information">';
			if($name) $output  .= '<span class="sppb-person-name">' . $name . '</span>';
			if($designation) $output  .= '<span class="sppb-person-designation">' . $designation . '</span>';
			if($email) $output  .= '<span class="sppb-person-email">' . $email . '</span>';
			$output  .= '</div>';
		}

		if($introtext) $output  .= '<div class="sppb-person-introtext">' . $introtext . '</div>';

		$output  .= '</div>';
		$output  .= '</div>';

		return $output;
	}

	public function css() {
		$addon_id = '#sppb-addon-' . $this->addon->id;

		$border_radius = (isset($this->addon->settings->image_border_radius) && $this->addon->settings->image_border_radius) ? 'border-radius:' . $this->addon->settings->image_border_radius . 'px' : '';
		$css = '';
		if($border_radius) {
			$css .= $addon_id . ' .sppb-person-image img {';
			$css .= $border_radius;
			$css .= "\n" . '}' . "\n"	;
		}

		$name_color = (isset($this->addon->settings->name_color) && $this->addon->settings->name_color) ? 'color:' . $this->addon->settings->name_color : '';
		if($name_color) {
			$css .= $addon_id . ' .sppb-person-name {';
			$css .= $name_color;
			$css .= "\n" . '}' . "\n"	;
		}

		$designation_color = (isset($this->addon->settings->designation_color) && $this->addon->settings->designation_color) ? 'color:' . $this->addon->settings->designation_color : '';
		if($designation_color) {
			$css .= $addon_id . ' .sppb-person-designation {';
			$css .= $designation_color;
			$css .= "\n" . '}' . "\n"	;
		}

		return $css;
	}

	public static function getTemplate(){

		$output ='
			<#
			var facebook 		= (!_.isEmpty(data.facebook)) ? data.facebook : "";
			var twitter 		= (!_.isEmpty(data.twitter)) ? data.twitter : "";
			var google_plus 	= (!_.isEmpty(data.google_plus)) ? data.google_plus : "";
			var youtube 		= (!_.isEmpty(data.youtube)) ? data.youtube : "";
			var linkedin 		= (!_.isEmpty(data.linkedin)) ? data.linkedin : "";
			var pinterest 		= (!_.isEmpty(data.pinterest)) ? data.pinterest : "";
			var flickr 			= (!_.isEmpty(data.flickr)) ? data.flickr : "";
			var dribbble 		= (!_.isEmpty(data.dribbble)) ? data.dribbble : "";
			var behance 		= (!_.isEmpty(data.behance)) ? data.behance : "";
			var instagram 		= (!_.isEmpty(data.instagram)) ? data.instagram : "";

			var socials = [];

			if (twitter) {
				socials.push({name: "twitter", url: twitter});
			}
			if (facebook) {
				socials.push({name: "facebook", url: facebook});
			}
			if (google_plus) {
				socials.push({name: "google-plus", url: google_plus});
			}
			if (pinterest) {
				socials.push({name: "pinterest", url: pinterest});
			}
			if (linkedin) {
				socials.push({name: "linkedin", url: linkedin});
			}
			if (dribbble) {
				socials.push({name: "dribbble", url: dribbble});
			}
			if (behance) {
				socials.push({name: "behance", url: behance});
			}
			if (flickr) {
				socials.push({name: "flickr", url: flickr});
			}
			if (youtube) {
				socials.push({name: "youtube", url: youtube});
			}
			if (instagram) {
				socials.push({name: "instagram", url: instagram});
			} #>
			
			<div class="sppb-addon sppb-addon-person {{ data.alignment }} {{ data.class}}">
				<div class="sppb-addon-content">
				<# if(!_.isEmpty(data.image)) { #>
					<div class="sppb-person-image">
						<# if(data.image.indexOf("https://") == -1 && data.image.indexOf("http://") == -1){ #>
							<img class="sppb-img-responsive" src=\'{{ pagebuilder_base + data.image }}\' alt="{{ data.name }}">
						<# } else { #>
							<img class="sppb-img-responsive" src=\'{{ data.image }}\' alt="{{ data.name }}">
						<# } #>
						<# if (socials) { #>
							<div class="sppb-person-social-icons">
							<ul class="sppb-person-{{socials.length}}">
							<# var keyNum = 1;
							_.each (socials, function(social, key) {
								keyNum +=key; #>
								<li class="social-{{keyNum}}">
									<a target="_blank" class="social-{{social.name}}" href="{{social.url}}"><i class="fa fa-{{social.name}}"></i></a>
								</li>
							<# }) #>
							</ul>
							</div>
						<# } #>
					</div>
				<# } #>

				<# if(data.name || data.designation || data.email ){ #>
					<div class="sppb-person-information">
						<# if(!_.isEmpty(data.name)) { #>
							<span class="sppb-person-name">{{ data.name}}</span>
						<# } #>
						<# if(!_.isEmpty(data.designation)) { #>
							<span class="sppb-person-designation">{{ data.designation}}</span>
						<# } #>
						<# if(!_.isEmpty(data.email)) { #>
							<span class="sppb-person-email">{{ data.email}}</span>
						<# } #>
					</div>
				<# } #>

				</div>
			</div>

			<style type="text/css">
				<# if(data.image_border_radius) { #>
					#sppb-addon-{{ data.id }} .sppb-person-image img {
						border-radius: {{data.image_border_radius}}px;
					}
				<# } #>
				<# if(data.name_color) { #>
					#sppb-addon-{{ data.id }} .sppb-person-name {
						color: {{data.name_color}};
					}
				<# } #>
				<# if(data.designation_color) { #>
					#sppb-addon-{{ data.id }} .sppb-person-designation {
						color: {{data.designation_color}};
					}
				<# } #>
			</style>

			';

			return $output;
	}

}
