
--
-- Database: `sp_tixon_v22`
--

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_action`
--

DROP TABLE IF EXISTS `#__acymailing_action`;
CREATE TABLE `#__acymailing_action` (
  `action_id` int(10) UNSIGNED NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` text,
  `frequency` int(10) UNSIGNED NOT NULL,
  `nextdate` int(10) UNSIGNED NOT NULL,
  `server` varchar(255) NOT NULL,
  `port` varchar(50) NOT NULL,
  `connection_method` varchar(10) NOT NULL DEFAULT '0',
  `secure_method` varchar(10) NOT NULL DEFAULT '0',
  `self_signed` tinyint(4) NOT NULL DEFAULT '0',
  `username` varchar(255) NOT NULL,
  `password` varchar(50) NOT NULL,
  `userid` int(10) UNSIGNED DEFAULT NULL,
  `conditions` text,
  `actions` text,
  `report` text,
  `published` tinyint(4) NOT NULL DEFAULT '0',
  `ordering` smallint(5) UNSIGNED DEFAULT '0',
  `delete_wrong_emails` tinyint(4) NOT NULL DEFAULT '0',
  `senderfrom` tinyint(4) NOT NULL DEFAULT '0',
  `senderto` tinyint(4) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_config`
--

DROP TABLE IF EXISTS `#__acymailing_config`;
CREATE TABLE `#__acymailing_config` (
  `namekey` varchar(200) NOT NULL,
  `value` text
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__acymailing_config`
--

INSERT INTO `#__acymailing_config` (`namekey`, `value`) VALUES
('acyrss_description', ''),
('acyrss_element', '20'),
('acyrss_format', ''),
('acyrss_name', ''),
('acyrss_order', 'senddate'),
('add_names', '1'),
('allowedfiles', 'zip,doc,docx,pdf,xls,txt,gzip,rar,jpg,jpeg,gif,xlsx,pps,csv,bmp,ico,odg,odp,ods,odt,png,ppt,swf,xcf,mp3,wma'),
('allow_modif', 'data'),
('allow_visitor', '1'),
('autosub', 'None'),
('bootstrap_frontend', '0'),
('bounce_action_lists_maxtry', '1'),
('bounce_action_maxtry', 'noaction'),
('bounce_email', 'install@joomshaper.com'),
('Business', '2'),
('captcha_plugin', 'no'),
('charset', 'UTF-8'),
('comments_feature', ''),
('confirmation_message', '1'),
('confirm_message', '0'),
('confirm_redirect', ''),
('cron_frequency', '900'),
('cron_fromip', ''),
('cron_fullreport', '1'),
('cron_last', '0'),
('cron_next', '1251990901'),
('cron_report', ''),
('cron_savepath', 'media/com_acymailing/logs/report{year}_{month}.log'),
('cron_savereport', '2'),
('cron_sendreport', '2'),
('cron_sendto', 'install@joomshaper.com'),
('css_backend', ''),
('css_frontend', 'default'),
('css_module', 'default'),
('description_business', 'Joomla!® Marketing Campaign'),
('description_enterprise', 'Joomla!® Newsletter System'),
('description_essential', 'Joomla!® Newsletter Extension'),
('description_sidekick', 'Joomla!® Newsletter System'),
('description_starter', 'Joomla!® Mailing Extension'),
('disqus_shortname', ''),
('editor', 'acyeditor'),
('elasticemail_password', ''),
('elasticemail_port', 'rest'),
('elasticemail_username', ''),
('email_botscout', '0'),
('email_botscout_key', ''),
('email_checkdomain', '0'),
('email_iptimecheck', '0'),
('email_stopforumspam', '0'),
('embed_files', '1'),
('embed_images', '0'),
('encoding_format', '8bit'),
('Enterprise', '3'),
('Essential', '1'),
('expirationdate', '0'),
('forward', '0'),
('from_email', 'install@joomshaper.com'),
('from_name', 'Shaper Tixon'),
('frontend_print', '0'),
('frontend_subject', '1'),
('generate_name', '1'),
('hostname', ''),
('indexFollow', '1'),
('installcomplete', '1'),
('itemid', '0'),
('lastlicensecheck', '1518764093'),
('last_maxexec_check', '1518764485'),
('latestversion', '5.9.1'),
('level', 'Starter'),
('mailer_method', 'phpmail'),
('max_execution_time', '390'),
('mediafolder', 'media/com_acymailing/upload'),
('menu_position', 'above'),
('modif_redirect', ''),
('module_redirect', ''),
('multiple_part', '1'),
('notification_accept', ''),
('notification_confirm', ''),
('notification_contact', ''),
('notification_contact_menu', ''),
('notification_created', ''),
('notification_refuse', ''),
('notification_unsub', ''),
('notification_unsuball', ''),
('open_popup', '1'),
('pluginNeedUpdate', ''),
('popup_height', '550'),
('popup_width', '750'),
('priority_followup', '2'),
('priority_newsletter', '3'),
('queue_nbmail', '40'),
('queue_nbmail_auto', '70'),
('queue_pause', '120'),
('queue_try', '3'),
('queue_type', 'auto'),
('redirect_tags', '0'),
('reply_email', 'install@joomshaper.com'),
('reply_name', 'Shaper Tixon'),
('require_confirmation', '0'),
('security_key', 'u4u1VyHOclbiA1kYxLi85kxINTDaQx'),
('sendmail_path', '/usr/sbin/sendmail'),
('sendorder', 'subid, ASC'),
('show_description', '1'),
('show_filter', '1'),
('show_footer', '1'),
('show_order', '1'),
('show_senddate', '1'),
('Sidekick', '4'),
('smtp_auth', '0'),
('smtp_host', 'localhost'),
('smtp_keepalive', '1'),
('smtp_password', ''),
('smtp_port', '25'),
('smtp_secured', ''),
('smtp_username', ''),
('special_chars', '0'),
('ssl_links', '0'),
('Starter', '0'),
('subscription_message', '1'),
('sub_redirect', ''),
('unsubscription_message', '1'),
('unsub_dispoptions', '1'),
('unsub_dispothersubs', '0'),
('unsub_intro', 'UNSUB_INTRO'),
('unsub_message', '1'),
('unsub_reasons', 'a:2:{i:0;s:21:\"UNSUB_SURVEY_FREQUENT\";i:1;s:21:\"UNSUB_SURVEY_RELEVANT\";}'),
('unsub_redirect', ''),
('unsub_survey', '1'),
('uploadfolder', 'media/com_acymailing/upload'),
('use_sef', '0'),
('version', '5.9.1'),
('website', 'http://localhost/work/update/spp3/tixon_quickstart_j3_v2.1/'),
('welcome_message', '1'),
('word_wrapping', '150');

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_fields`
--

DROP TABLE IF EXISTS `#__acymailing_fields`;
CREATE TABLE `#__acymailing_fields` (
  `fieldid` smallint(5) UNSIGNED NOT NULL,
  `fieldname` varchar(250) NOT NULL,
  `namekey` varchar(50) NOT NULL,
  `type` varchar(50) DEFAULT NULL,
  `value` text NOT NULL,
  `published` tinyint(3) UNSIGNED NOT NULL DEFAULT '1',
  `ordering` smallint(5) UNSIGNED DEFAULT '99',
  `options` text,
  `core` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `required` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `backend` tinyint(3) UNSIGNED NOT NULL DEFAULT '1',
  `frontcomp` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `default` text,
  `listing` tinyint(3) UNSIGNED DEFAULT NULL,
  `frontlisting` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `frontjoomlaprofile` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `frontjoomlaregistration` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `joomlaprofile` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `access` varchar(250) NOT NULL DEFAULT 'all',
  `fieldcat` int(11) NOT NULL DEFAULT '0',
  `listingfilter` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `frontlistingfilter` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `frontform` tinyint(4) DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__acymailing_fields`
--

INSERT INTO `#__acymailing_fields` (`fieldid`, `fieldname`, `namekey`, `type`, `value`, `published`, `ordering`, `options`, `core`, `required`, `backend`, `frontcomp`, `default`, `listing`, `frontlisting`, `frontjoomlaprofile`, `frontjoomlaregistration`, `joomlaprofile`, `access`, `fieldcat`, `listingfilter`, `frontlistingfilter`, `frontform`) VALUES
(1, 'NAMECAPTION', 'name', 'text', '', 1, 1, '', 1, 1, 1, 1, '', 1, 1, 0, 0, 0, 'all', 0, 0, 0, 1),
(2, 'EMAILCAPTION', 'email', 'text', '', 1, 2, '', 1, 1, 1, 1, '', 1, 1, 0, 0, 0, 'all', 0, 0, 0, 1),
(3, 'RECEIVE', 'html', 'radio', '0::JOOMEXT_TEXT\n1::HTML', 1, 3, '', 1, 1, 1, 1, '1', 1, 0, 0, 0, 0, 'all', 0, 0, 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_filter`
--

DROP TABLE IF EXISTS `#__acymailing_filter`;
CREATE TABLE `#__acymailing_filter` (
  `filid` mediumint(8) UNSIGNED NOT NULL,
  `name` varchar(250) DEFAULT NULL,
  `description` text,
  `published` tinyint(3) UNSIGNED DEFAULT NULL,
  `lasttime` int(10) UNSIGNED DEFAULT NULL,
  `trigger` text,
  `report` text,
  `action` text,
  `filter` text,
  `daycron` int(10) UNSIGNED DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_forward`
--

DROP TABLE IF EXISTS `#__acymailing_forward`;
CREATE TABLE `#__acymailing_forward` (
  `subid` int(10) UNSIGNED NOT NULL,
  `mailid` mediumint(8) UNSIGNED NOT NULL,
  `date` int(10) UNSIGNED NOT NULL,
  `ip` varchar(50) DEFAULT NULL,
  `nbforwarded` int(10) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_geolocation`
--

DROP TABLE IF EXISTS `#__acymailing_geolocation`;
CREATE TABLE `#__acymailing_geolocation` (
  `geolocation_id` int(10) UNSIGNED NOT NULL,
  `geolocation_subid` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `geolocation_type` varchar(255) NOT NULL DEFAULT 'subscription',
  `geolocation_ip` varchar(255) NOT NULL DEFAULT '',
  `geolocation_created` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `geolocation_latitude` decimal(9,6) NOT NULL DEFAULT '0.000000',
  `geolocation_longitude` decimal(9,6) NOT NULL DEFAULT '0.000000',
  `geolocation_postal_code` varchar(255) NOT NULL DEFAULT '',
  `geolocation_country` varchar(255) NOT NULL DEFAULT '',
  `geolocation_country_code` varchar(255) NOT NULL DEFAULT '',
  `geolocation_state` varchar(255) NOT NULL DEFAULT '',
  `geolocation_state_code` varchar(255) NOT NULL DEFAULT '',
  `geolocation_city` varchar(255) NOT NULL DEFAULT '',
  `geolocation_continent` varchar(255) NOT NULL DEFAULT '',
  `geolocation_timezone` varchar(255) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_history`
--

DROP TABLE IF EXISTS `#__acymailing_history`;
CREATE TABLE `#__acymailing_history` (
  `subid` int(10) UNSIGNED NOT NULL,
  `date` int(10) UNSIGNED NOT NULL,
  `ip` varchar(50) DEFAULT NULL,
  `action` varchar(50) NOT NULL COMMENT 'different actions: created,modified,confirmed',
  `data` text,
  `source` text,
  `mailid` mediumint(8) UNSIGNED DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__acymailing_history`
--

INSERT INTO `#__acymailing_history` (`subid`, `date`, `ip`, `action`, `data`, `source`, `mailid`) VALUES
(2, 1441695690, '10.0.1.138', 'created', '', 'HTTP_REFERER::http://10.0.1.12/joomla/tixon_demo/index.php/home/home-shop\nHTTP_USER_AGENT::Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/45.0.2454.85 Safari/537.36\nHTTP_HOST::10.0.1.12\nSERVER_ADDR::10.0.1.12\nREMOTE_ADDR::10.0.1.138\nREQUEST_URI::/joomla/tixon_demo/index.php/home/home-shop', 0),
(3, 1442571306, '10.0.1.3', 'created', '', 'HTTP_REFERER::http://10.0.1.3/work/projects/2015/tixon/demo/index.php/shop/user/editaddresscartBT\nHTTP_USER_AGENT::Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/45.0.2454.93 Safari/537.36\nHTTP_HOST::10.0.1.3\nSERVER_ADDR::10.0.1.3\nREMOTE_ADDR::10.0.1.3\nREQUEST_URI::/work/projects/2015/tixon/demo/index.php/shop/user', 0),
(3, 1442571324, '10.0.1.3', 'confirmed', 'EXECUTED_BY::270 ( admin )', 'HTTP_REFERER::http://10.0.1.3/work/projects/2015/tixon/demo/administrator/index.php?option=com_users&view=users\nHTTP_USER_AGENT::Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/45.0.2454.93 Safari/537.36\nHTTP_HOST::10.0.1.3\nSERVER_ADDR::10.0.1.3\nREMOTE_ADDR::10.0.1.3\nREQUEST_URI::/work/projects/2015/tixon/demo/administrator/index.php?option=com_users&view=users\nQUERY_STRING::option=com_users&view=users', 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_list`
--

DROP TABLE IF EXISTS `#__acymailing_list`;
CREATE TABLE `#__acymailing_list` (
  `name` varchar(250) NOT NULL,
  `description` text,
  `ordering` smallint(5) UNSIGNED DEFAULT '0',
  `listid` smallint(5) UNSIGNED NOT NULL,
  `published` tinyint(4) DEFAULT NULL,
  `userid` int(10) UNSIGNED DEFAULT NULL,
  `alias` varchar(250) DEFAULT NULL,
  `color` varchar(30) DEFAULT NULL,
  `visible` tinyint(4) NOT NULL DEFAULT '1',
  `welmailid` mediumint(9) DEFAULT NULL,
  `unsubmailid` mediumint(9) DEFAULT NULL,
  `type` enum('list','campaign') NOT NULL DEFAULT 'list',
  `access_sub` varchar(250) NOT NULL DEFAULT 'all',
  `access_manage` varchar(250) NOT NULL DEFAULT 'none',
  `languages` varchar(250) NOT NULL DEFAULT 'all',
  `startrule` varchar(50) NOT NULL DEFAULT '0',
  `category` varchar(250) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__acymailing_list`
--

INSERT INTO `#__acymailing_list` (`name`, `description`, `ordering`, `listid`, `published`, `userid`, `alias`, `color`, `visible`, `welmailid`, `unsubmailid`, `type`, `access_sub`, `access_manage`, `languages`, `startrule`, `category`) VALUES
('Newsletters', 'Receive our latest news', 1, 1, 1, 270, 'mailing_list', '#3366ff', 1, NULL, NULL, 'list', 'all', 'none', 'all', '0', '');

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_listcampaign`
--

DROP TABLE IF EXISTS `#__acymailing_listcampaign`;
CREATE TABLE `#__acymailing_listcampaign` (
  `campaignid` smallint(5) UNSIGNED NOT NULL,
  `listid` smallint(5) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_listmail`
--

DROP TABLE IF EXISTS `#__acymailing_listmail`;
CREATE TABLE `#__acymailing_listmail` (
  `listid` smallint(5) UNSIGNED NOT NULL,
  `mailid` mediumint(8) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_listsub`
--

DROP TABLE IF EXISTS `#__acymailing_listsub`;
CREATE TABLE `#__acymailing_listsub` (
  `listid` smallint(5) UNSIGNED NOT NULL,
  `subid` int(10) UNSIGNED NOT NULL,
  `subdate` int(10) UNSIGNED DEFAULT NULL,
  `unsubdate` int(10) UNSIGNED DEFAULT NULL,
  `status` tinyint(4) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__acymailing_listsub`
--

INSERT INTO `#__acymailing_listsub` (`listid`, `subid`, `subdate`, `unsubdate`, `status`) VALUES
(1, 1, 1440485038, NULL, 1),
(1, 2, 1441695690, NULL, 1);

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_mail`
--

DROP TABLE IF EXISTS `#__acymailing_mail`;
CREATE TABLE `#__acymailing_mail` (
  `mailid` mediumint(8) UNSIGNED NOT NULL,
  `subject` text,
  `body` longtext NOT NULL,
  `altbody` longtext NOT NULL,
  `published` tinyint(4) DEFAULT '1',
  `senddate` int(10) UNSIGNED DEFAULT NULL,
  `created` int(10) UNSIGNED DEFAULT NULL,
  `fromname` varchar(250) DEFAULT NULL,
  `fromemail` varchar(250) DEFAULT NULL,
  `replyname` varchar(250) DEFAULT NULL,
  `replyemail` varchar(250) DEFAULT NULL,
  `type` enum('news','autonews','followup','unsub','welcome','notification','joomlanotification','action','article') NOT NULL DEFAULT 'news',
  `visible` tinyint(4) NOT NULL DEFAULT '1',
  `userid` int(10) UNSIGNED DEFAULT NULL,
  `alias` varchar(250) DEFAULT NULL,
  `attach` text,
  `html` tinyint(4) NOT NULL DEFAULT '1',
  `tempid` smallint(6) NOT NULL DEFAULT '0',
  `key` varchar(200) DEFAULT NULL,
  `frequency` varchar(50) DEFAULT NULL,
  `params` text,
  `sentby` int(10) UNSIGNED DEFAULT NULL,
  `metakey` text,
  `metadesc` text,
  `filter` text,
  `language` varchar(50) NOT NULL DEFAULT '',
  `abtesting` varchar(250) DEFAULT NULL,
  `thumb` varchar(250) DEFAULT NULL,
  `summary` text NOT NULL,
  `favicon` text,
  `bccaddresses` varchar(250) DEFAULT NULL,
  `lastupdate` int(10) UNSIGNED DEFAULT NULL,
  `userlastupdate` int(10) UNSIGNED DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__acymailing_mail`
--

INSERT INTO `#__acymailing_mail` (`mailid`, `subject`, `body`, `altbody`, `published`, `senddate`, `created`, `fromname`, `fromemail`, `replyname`, `replyemail`, `type`, `visible`, `userid`, `alias`, `attach`, `html`, `tempid`, `key`, `frequency`, `params`, `sentby`, `metakey`, `metadesc`, `filter`, `language`, `abtesting`, `thumb`, `summary`, `favicon`, `bccaddresses`, `lastupdate`, `userlastupdate`) VALUES
(1, 'New Subscriber on your website : {user:email}', '<p>Hello {subtag:name},</p><p>A new user has been created in AcyMailing : </p><blockquote><p>Name : {user:name}</p><p>Email : {user:email}</p><p>IP : {user:ip} </p><p>Subscription : {user:subscription}</p></blockquote>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'notification_created', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(2, 'A User unsubscribed from all your lists : {user:email}', '<p>Hello {subtag:name},</p><p>The user {user:name} : {user:email} unsubscribed from all your lists</p><p>Subscription : {user:subscription}</p><p>{survey}</p>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'notification_unsuball', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(3, 'A User unsubscribed : {user:email}', '<p>Hello {subtag:name},</p><p>The user {user:name} : {user:email} unsubscribed from your list</p><p>Subscription : {user:subscription}</p><p>{survey}</p>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'notification_unsub', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(4, 'A User refuses to receive e-mails from your website : {user:email}', '<p>The User {user:name} : {user:email} refuses to receive any e-mail anymore from your website.</p><p>Subscription : {user:subscription}</p><p>{survey}</p>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'notification_refuse', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(5, 'New contact from your website : {user:email}', '<p>Hello {subtag:name},</p><p>A user submitted the form : </p><blockquote><p>Name : {user:name}</p><p>Email : {user:email}</p><p>IP : {user:ip} </p><p>Subscription : {user:subscription}</p></blockquote>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'notification_contact', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(6, 'A user subscribed or modified his subscription : {user:email}', '<p>Hello {subtag:name},</p><p>A user submitted the form : </p><blockquote><p>Name : {user:name}</p><p>Email : {user:email}</p><p>IP : {user:ip} </p><p>Subscription : {user:subscription}</p></blockquote>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'notification_contact_menu', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(7, 'A user confirmed his subscription : {user:email}', '<p>Hello {subtag:name},</p><p>A user confirmed his subscription : </p><blockquote><p>Name : {user:name}</p><p>Email : {user:email}</p><p>IP : {user:ip} </p><p>Subscription : {user:subscription}</p></blockquote>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'notification_confirm', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(8, '{subtag:name|ucfirst}, {trans:PLEASE_CONFIRM_SUB}', '<div style=\"text-align: center; width: 100%; background-color: #ffffff;\">\r\n			<table style=\"text-align:justify; margin:auto; background-color:#ebebeb; border:1px solid #e7e7e7\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"600\" align=\"center\" bgcolor=\"#ebebeb\">\r\n			<tbody>\r\n			<tr style=\"line-height: 0px;\">\r\n			<td style=\"line-height: 0px;\" height=\"38px\"><img src=\"media/com_acymailing/templates/newsletter-4/top.png\" border=\"0\" alt=\" - - - \" /></td>\r\n			</tr>\r\n			<tr>\r\n			<td style=\"text-align:center\" width=\"600\">\r\n			<table style=\"margin:auto;\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"520\">\r\n			<tbody>\r\n			<tr>\r\n			<td style=\"background-color: #ffffff; border: 1px solid #dbdbdb; padding: 20px; width: 500px; margin: 15px auto; text-align: left;\">\r\n			<h1>Hello {subtag:name|ucfirst},</h1>\r\n			<p>{trans:CONFIRM_MSG}<br /><br />{trans:CONFIRM_MSG_ACTIVATE}</p>\r\n			<br />\r\n			<p style=\"text-align:center;\"><strong>{confirm}{trans:CONFIRM_SUBSCRIPTION}{/confirm}</strong></p>\r\n			</td>\r\n			</tr>\r\n			</tbody>\r\n			</table>\r\n			</td>\r\n			</tr>\r\n			<tr style=\"line-height: 0px;\">\r\n			<td style=\"line-height: 0px;\" height=\"40px\"><img src=\"media/com_acymailing/templates/newsletter-4/bottom.png\" border=\"0\" alt=\" - - - \" /></td>\r\n			</tr>\r\n			</tbody>\r\n			</table>\r\n			</div>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'confirmation', NULL, 1, 1, NULL, NULL, 'a:3:{s:6:\"action\";s:7:\"confirm\";s:13:\"actionbtntext\";s:28:\"{trans:CONFIRM_SUBSCRIPTION}\";s:9:\"actionurl\";s:19:\"{confirm}{/confirm}\";}', NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(9, 'AcyMailing Cron Report {mainreport}', '<p>{report}</p><p>{detailreport}</p>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'report', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(10, 'Modify your subscription', '<p>Hello {subtag:name}, </p><p>You requested some changes on your subscription,</p><p>Please {modify}click here{/modify} to be identified as the owner of this account and then modify your subscription.</p>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'modif', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(11, '{joomlacontent:current| type:title}', '<div style=\"text-align: center; width: 100%; background-color:#ffffff;\">\r\n		<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"w600\" style=\"text-align: justify; margin: auto; width: 600px;\">\r\n			<tbody>\r\n				<tr class=\"acyeditor_delete\" style=\"line-height: 0px;\" id=\"zone_2\">\r\n					<td class=\"w600\" colspan=\"5\" style=\"background-color: #69b4c0;\" valign=\"bottom\" width=\"600\" id=\"zone_3\"><img id=\"zone_29\" alt=\" - - - \" border=\"0\" src=\"http://localhost/work/update/spp3/tixon_quickstart_j3_v2.1//media/com_acymailing/templates/newsletter-4/images/top.png\"></td>\r\n				</tr>\r\n				<tr class=\"acyeditor_delete\" id=\"zone_4\">\r\n					<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\" id=\"zone_5\"></td>\r\n					<td class=\"w520 acyeditor_text\" colspan=\"3\" height=\"80\" style=\"text-align: left; background-color: #ebebeb;\" width=\"520\" id=\"zone_6\"><strong>​</strong>​​​​​​​​<img alt=\"-\" border=\"0\" src=\"http://localhost/work/update/spp3/tixon_quickstart_j3_v2.1//media/com_acymailing/templates/newsletter-4/images/message_icon.png\" style=\"float: left; margin-right: 10px;\">\r\n						<h3>{joomlacontent:current| type:title}<span style=\"display: none;\">&nbsp;</span></h3>\r\n					</td>\r\n					<td class=\"acyeditor_picture w40\" style=\"background-color: #ebebeb;\" width=\"40\" id=\"zone_7\"></td>\r\n				</tr>\r\n				<tr class=\"acyeditor_delete\" id=\"zone_8\">\r\n					<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\" id=\"zone_9\"></td>\r\n					<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\" id=\"zone_10\"></td>\r\n					<td class=\"w480\" height=\"20\" style=\"background-color: #fff;\" width=\"480\" id=\"zone_11\"></td>\r\n					<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\" id=\"zone_12\"></td>\r\n					<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\" id=\"zone_13\"></td>\r\n				</tr>\r\n				<tr class=\"acyeditor_delete\" id=\"zone_14\">\r\n					<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\" id=\"zone_15\"></td>\r\n					<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\" id=\"zone_16\"></td>\r\n					<td class=\"w480 pict acyeditor_text\" style=\"background-color: #fff; text-align: left;\" width=\"480\" id=\"zone_17\">{joomlacontent:current| type:intro| format:TOP_LEFT| pict:1| link}</td>\r\n					<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\" id=\"zone_18\"></td>\r\n					<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\" id=\"zone_19\"></td>\r\n				</tr>\r\n				<tr class=\"acyeditor_delete\" id=\"zone_20\">\r\n					<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\" id=\"zone_21\"></td>\r\n					<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\" id=\"zone_22\"></td>\r\n					<td class=\"w480\" height=\"20\" style=\"background-color: #fff;\" width=\"480\" id=\"zone_23\"></td>\r\n					<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\" id=\"zone_24\"></td>\r\n					<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\" id=\"zone_25\"></td>\r\n				</tr>\r\n				<tr class=\"acyeditor_delete\" style=\"line-height: 0px;\" id=\"zone_26\">\r\n					<td class=\"w600\" colspan=\"5\" style=\"background-color: #ebebeb;\" width=\"600\" id=\"zone_27\"><img id=\"zone_31\" alt=\" - - - \" border=\"0\" src=\"http://localhost/work/update/spp3/tixon_quickstart_j3_v2.1//media/com_acymailing/templates/newsletter-4/images/bottom.png\"></td>\r\n				</tr>\r\n			</tbody>\r\n		</table>\r\n		</div>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'article', 0, NULL, 'send-in-article', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_queue`
--

DROP TABLE IF EXISTS `#__acymailing_queue`;
CREATE TABLE `#__acymailing_queue` (
  `senddate` int(10) UNSIGNED NOT NULL,
  `subid` int(10) UNSIGNED NOT NULL,
  `mailid` mediumint(8) UNSIGNED NOT NULL,
  `priority` tinyint(3) UNSIGNED DEFAULT '3',
  `try` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `paramqueue` varchar(250) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_rules`
--

DROP TABLE IF EXISTS `#__acymailing_rules`;
CREATE TABLE `#__acymailing_rules` (
  `ruleid` smallint(5) UNSIGNED NOT NULL,
  `name` varchar(250) NOT NULL,
  `ordering` smallint(6) DEFAULT NULL,
  `regex` text NOT NULL,
  `executed_on` text NOT NULL,
  `action_message` text NOT NULL,
  `action_user` text NOT NULL,
  `published` tinyint(3) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_stats`
--

DROP TABLE IF EXISTS `#__acymailing_stats`;
CREATE TABLE `#__acymailing_stats` (
  `mailid` mediumint(8) UNSIGNED NOT NULL,
  `senthtml` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `senttext` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `senddate` int(10) UNSIGNED NOT NULL,
  `openunique` mediumint(8) UNSIGNED NOT NULL DEFAULT '0',
  `opentotal` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `bounceunique` mediumint(8) UNSIGNED NOT NULL DEFAULT '0',
  `fail` mediumint(8) UNSIGNED NOT NULL DEFAULT '0',
  `clicktotal` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `clickunique` mediumint(8) UNSIGNED NOT NULL DEFAULT '0',
  `unsub` mediumint(8) UNSIGNED NOT NULL DEFAULT '0',
  `forward` mediumint(8) UNSIGNED NOT NULL DEFAULT '0',
  `bouncedetails` text
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_subscriber`
--

DROP TABLE IF EXISTS `#__acymailing_subscriber`;
CREATE TABLE `#__acymailing_subscriber` (
  `subid` int(10) UNSIGNED NOT NULL,
  `email` varchar(200) NOT NULL,
  `userid` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `name` varchar(250) NOT NULL DEFAULT '',
  `created` int(10) UNSIGNED DEFAULT NULL,
  `confirmed` tinyint(4) NOT NULL DEFAULT '0',
  `enabled` tinyint(4) NOT NULL DEFAULT '1',
  `accept` tinyint(4) NOT NULL DEFAULT '1',
  `ip` varchar(100) DEFAULT NULL,
  `html` tinyint(4) NOT NULL DEFAULT '1',
  `key` varchar(250) DEFAULT NULL,
  `confirmed_date` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `confirmed_ip` varchar(100) DEFAULT NULL,
  `lastopen_date` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `lastopen_ip` varchar(100) DEFAULT NULL,
  `lastclick_date` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `lastsent_date` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `source` varchar(250) NOT NULL DEFAULT '',
  `filterflags` varchar(50) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__acymailing_subscriber`
--

INSERT INTO `#__acymailing_subscriber` (`subid`, `email`, `userid`, `name`, `created`, `confirmed`, `enabled`, `accept`, `ip`, `html`, `key`, `confirmed_date`, `confirmed_ip`, `lastopen_date`, `lastopen_ip`, `lastclick_date`, `lastsent_date`, `source`, `filterflags`) VALUES
(1, 'install@joomshaper.com', 270, 'Anthony', 1440376268, 1, 1, 1, NULL, 1, NULL, 0, NULL, 0, NULL, 0, 0, '', ''),
(2, 'sdfdsf@gmaiil.com', 0, 'Sdfdsf', 1441695690, 0, 1, 1, '10.0.1.138', 1, 'N4ZvQKEx6pui3u', 0, NULL, 0, NULL, 0, 0, 'module_110', ''),
(3, 'rifatwahid@ymail.com', 271, 'Rifat wahid Alif', 1442571306, 1, 1, 1, '10.0.1.3', 1, 'dZu3K0JjVcS1n8', 1442571324, '10.0.1.3', 0, NULL, 0, 0, 'joomla', ''),
(4, 'techjoomshaper@gmail.com', 744, 'Super User', 1505871663, 1, 1, 1, NULL, 1, NULL, 0, NULL, 0, NULL, 0, 0, '', ''),
(5, 'install@test.com', 928, 'Super User', 1518052092, 1, 1, 1, NULL, 1, NULL, 0, NULL, 0, NULL, 0, 0, '', '');

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_tag`
--

DROP TABLE IF EXISTS `#__acymailing_tag`;
CREATE TABLE `#__acymailing_tag` (
  `tagid` smallint(5) UNSIGNED NOT NULL,
  `name` varchar(250) NOT NULL,
  `userid` int(10) UNSIGNED DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_tagmail`
--

DROP TABLE IF EXISTS `#__acymailing_tagmail`;
CREATE TABLE `#__acymailing_tagmail` (
  `tagid` smallint(5) UNSIGNED NOT NULL,
  `mailid` mediumint(8) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_template`
--

DROP TABLE IF EXISTS `#__acymailing_template`;
CREATE TABLE `#__acymailing_template` (
  `tempid` smallint(5) UNSIGNED NOT NULL,
  `name` varchar(250) DEFAULT NULL,
  `description` text,
  `body` longtext,
  `altbody` longtext,
  `created` int(10) UNSIGNED DEFAULT NULL,
  `published` tinyint(4) NOT NULL DEFAULT '1',
  `premium` tinyint(4) NOT NULL DEFAULT '0',
  `ordering` smallint(5) UNSIGNED DEFAULT '0',
  `namekey` varchar(50) NOT NULL,
  `styles` text,
  `subject` varchar(250) DEFAULT NULL,
  `stylesheet` text,
  `fromname` varchar(250) DEFAULT NULL,
  `fromemail` varchar(250) DEFAULT NULL,
  `replyname` varchar(250) DEFAULT NULL,
  `replyemail` varchar(250) DEFAULT NULL,
  `thumb` varchar(250) DEFAULT NULL,
  `readmore` varchar(250) DEFAULT NULL,
  `access` varchar(250) NOT NULL DEFAULT 'all',
  `category` varchar(250) NOT NULL DEFAULT '',
  `header` longtext
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__acymailing_template`
--

INSERT INTO `#__acymailing_template` (`tempid`, `name`, `description`, `body`, `altbody`, `created`, `published`, `premium`, `ordering`, `namekey`, `styles`, `subject`, `stylesheet`, `fromname`, `fromemail`, `replyname`, `replyemail`, `thumb`, `readmore`, `access`, `category`, `header`) VALUES
(1, 'Notification template', '', '<div style=\"text-align: center; width: 100%; background-color:#ffffff;\">\r\n<div class=\"acymailing_online acyeditor_delete acyeditor_text\" style=\"text-align:center\">{readonline}This email contains graphics, so if you don\'t see them, view it in your browser{/readonline}</div>\r\n\r\n<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"w600\" style=\"text-align: justify; margin: auto; width:600px\">\r\n	<tbody class=\"acyeditor_sortable\">\r\n		<tr style=\"line-height: 0px;\" class=\"acyeditor_delete\">\r\n			<td class=\"w600\" colspan=\"5\" style=\"background-color: #69b4c0;\" valign=\"bottom\" width=\"600\"><img alt=\" - - - \" src=\"media/com_acymailing/templates/newsletter-4/images/top.png\" /></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n			<td class=\"acyeditor_text w520\" colspan=\"3\" height=\"80\" style=\"text-align: left; background-color: rgb(235, 235, 235);\" width=\"520\"><img alt=\"-\" src=\"media/com_acymailing/templates/newsletter-4/images/message_icon.png\" style=\"float:left; margin-right:10px;\" />\r\n				<h3>Topic of your message</h3>\r\n\r\n				<h4>Subtitle for your message</h4>\r\n			</td>\r\n			<td class=\"acyeditor_picture w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n			<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\"></td>\r\n			<td class=\"w480\" height=\"20\" style=\"background-color:#fff;\" width=\"480\"></td>\r\n			<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\"></td>\r\n			<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n			<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\"></td>\r\n			<td class=\"acyeditor_text w480 pict\" style=\"background-color:#fff; text-align: left;\" width=\"480\">\r\n			<h1>Dear {subtag:name},</h1>\r\n			Your message here...<br />\r\n			</td>\r\n			<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\"></td>\r\n			<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n			<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\"></td>\r\n			<td class=\"w480\" height=\"20\" style=\"background-color:#fff;\" width=\"480\"></td>\r\n			<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\"></td>\r\n			<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n		</tr>\r\n		<tr style=\"line-height: 0px;\" class=\"acyeditor_delete\">\r\n			<td class=\"w600\" colspan=\"5\" style=\"background-color:#ebebeb;\" width=\"600\"><img alt=\" - - - \" src=\"media/com_acymailing/templates/newsletter-4/images/bottom.png\" /></td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n\r\n<div class=\"acyeditor_delete acyeditor_text\" style=\"text-align:center\">Not interested any more? {unsubscribe}Unsubscribe{/unsubscribe}</div>\r\n</div>', '', NULL, 1, 0, 1, 'newsletter-4', 'a:10:{s:6:\"tag_h1\";s:76:\"color:#393939 !important; font-size:14px; font-weight:bold; margin:10px 0px;\";s:6:\"tag_h2\";s:106:\"color: #309fb3 !important; font-size: 14px; font-weight: normal; text-align:left; margin:0px; padding:0px;\";s:6:\"tag_h3\";s:144:\"color: #393939 !important; font-size: 18px; font-weight: bold; text-align:left; margin:0px; padding-bottom:5px; border-bottom:1px solid #bdbdbd;\";s:6:\"tag_h4\";s:117:\"color: #309fb3 !important; font-size: 14px; font-weight: bold; text-align:left; margin:0px; padding: 5px 0px 0px 0px;\";s:5:\"tag_a\";s:71:\"color:#309FB3; text-decoration:none; font-style:italic; cursor:pointer;\";s:19:\"acymailing_readmore\";s:90:\"font-size: 12px; color: #fff; background-color:#309fb3; font-weight:bold; padding:3px 5px;\";s:17:\"acymailing_online\";s:52:\"color:#a3a3a3; text-decoration:none; font-size:11px;\";s:16:\"acymailing_unsub\";s:52:\"color:#a3a3a3; text-decoration:none; font-size:11px;\";s:8:\"color_bg\";s:7:\"#ffffff\";s:18:\"acymailing_content\";s:19:\"text-align:justify;\";}', NULL, 'div,table,p, td{font-family: Verdana, Arial, Helvetica, sans-serif; font-size:12px; text-align:justify; color:#8c8c8c; margin:0px}\r\ndiv.info{text-align:center;padding:10px;font-size:11px;color:#a3a3a3;}\r\n\r\n@media (min-width:10px){\r\n	.w600 { width: 320px !important;}\r\n	.w520 { width: 280px !important;}\r\n	.w480 { width: 260px !important;}\r\n	.w40 { width: 20px !important;}\r\n	.w20 { width: 10px !important;}\r\n	.w600 img {max-width:320px; height:auto !important}\r\n	.w480 img {max-width:260px; height:auto !important;}\r\n}\r\n\r\n@media (min-width:480px) {\r\n	.w600 { width: 480px !important;}\r\n	.w520 { width: 440px !important;}\r\n	.w480 { width: 420px !important;}\r\n	.w40 { width: 20px !important;}\r\n	.w20 { width: 10px !important;}\r\n	.w600 img {max-width:480px; height:auto !important}\r\n	.w480 img {max-width:420px;  height:auto !important;}\r\n}\r\n\r\n@media (min-width:600px){\r\n	.w600 { width: 600px !important;}\r\n	.w520 { width: 520px !important;}\r\n	.w480 { width: 480px !important;}\r\n	.w40 { width40px !important;}\r\n	.w20 { width: 20px !important;}\r\n	.w600 img {max-width:600px; height:auto !important}\r\n	.w480 img {max-width:480px;  height:auto !important;}\r\n}\r\n', NULL, NULL, NULL, NULL, 'media/com_acymailing/templates/newsletter-4/newsletter-4.png', '', 'all', '', NULL),
(2, 'Newspaper', '', '<div align=\"center\" style=\"width:100%; background-color:#454545; padding-bottom:20px; color:#ffffff;\">\r\n<div class=\"acymailing_online acyeditor_delete acyeditor_text\">{readonline}This e-mail contains graphics, if you don\'t see them <strong>» view it online.</strong>{/readonline}</div>\r\n\r\n<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"w600\" style=\"margin:auto; background-color:#ffffff; color:#454545;\" width=\"600\">\r\n	<tbody  class=\"acyeditor_sortable\">\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w30\" style=\"background-color:#ffffff\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text w540\" style=\"font-family:Times New Roman, Times, serif; background-color:#ffffff; text-align:left\" width=\"540\">&nbsp;\r\n			<h1><img alt=\"logo\" src=\"media/com_acymailing/templates/newsletter-5/images/logo.png\" style=\"float: right; width: 107px; height: 70px;\" /></h1>\r\n\r\n			<h1>Your title here</h1>\r\n\r\n			<h3>your subtitle</h3>\r\n			</td>\r\n			<td class=\"w30\" style=\"line-height:0px; background-color:#ffffff\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w600\" colspan=\"3\" style=\"line-height:0px; background-color:#e4e4e4\" valign=\"top\" width=\"600\"><img alt=\"---\" src=\"media/com_acymailing/templates/newsletter-5/images/header.png\" /></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"acyeditor_picture w600\" colspan=\"3\" style=\"line-height:0px; background-color:#ffffff\" valign=\"top\" width=\"600\"><img alt=\"banner\" src=\"media/com_acymailing/templates/newsletter-5/images/banner.png\" /></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w600\" colspan=\"3\" style=\"line-height:0px;\" valign=\"top\" width=\"600\"><img alt=\"---\" src=\"media/com_acymailing/templates/newsletter-5/images/separator.png\" /></td>\r\n		</tr>\r\n		<tr>\r\n			<td class=\"w30\" style=\"background-color:#ffffff\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text w540\" style=\"text-align:justify; color:#575757; font-family:Times New Roman, Times, serif; font-size:13px; background-color:#ffffff\" width=\"540\">\r\n				<div>This issue will present the 5 last articles.<br />\r\n				{tableofcontents}<br />\r\n				{autocontent:|max:5|order:id,DESC|type:intro|link|pict:1}</div>\r\n			</td>\r\n			<td class=\"w30\" style=\"background-color:#ffffff\" width=\"30\"></td>\r\n		</tr>\r\n		<tr style=\"line-height: 0px;\">\r\n			<td class=\"w600\" colspan=\"3\" style=\"background-color:#ffffff\" width=\"600\"><img alt=\"--\" src=\"media/com_acymailing/templates/newsletter-5/images/footer1.png\" width=\"600\" /></td>\r\n		</tr>\r\n		<tr>\r\n			<td class=\"acyfooter acyeditor_text w600\" colspan=\"3\" height=\"25\" style=\"text-align:center; background-color:#ebebeb;  color:#454545; font-family:Times New Roman, Times, serif; font-size:13px\" width=\"600\"><a href=\"#\">www.mywebsite.com</a> | <a href=\"#\">contact</a> | <a href=\"#\">Facebook</a> | <a href=\"#\">Twitter</a></td>\r\n		</tr>\r\n		<tr style=\"line-height: 0px;\">\r\n			<td class=\"w600\" colspan=\"3\" style=\"background-color:#454545;\" width=\"600\"><img alt=\"--\" src=\"media/com_acymailing/templates/newsletter-5/images/footer2.png\" width=\"600\" /></td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n\r\n<div class=\"acymailing_unsub acyeditor_delete acyeditor_text\">{unsubscribe}If you\'re not interested any more <strong>» unsubscribe</strong>{/unsubscribe}</div>\r\n</div>\r\n', '', NULL, 1, 0, 2, 'newsletter-5', 'a:10:{s:6:\"tag_h1\";s:71:\"color:#454545 !important; font-size:24px; font-weight:bold; margin:0px;\";s:6:\"tag_h2\";s:145:\"color:#b20000 !important; font-size:18px; font-weight:bold; margin:0px; margin-bottom:10px; padding-bottom:4px; border-bottom: 1px solid #d6d6d6;\";s:6:\"tag_h3\";s:76:\"color:#b20101 !important; font-weight:bold; font-size:18px; margin:10px 0px;\";s:6:\"tag_h4\";s:67:\"color:#e52323 !important; font-weight:bold; margin:0px; padding:0px\";s:5:\"tag_a\";s:65:\"cursor:pointer; color:#9d0000; text-decoration:none; border:none;\";s:19:\"acymailing_readmore\";s:152:\"cursor:pointer; color:#ffffff; background-color:#9d0000; border-top:1px solid #9d0000; border-bottom:1px solid #9d0000; padding:3px 5px; font-size:13px;\";s:17:\"acymailing_online\";s:148:\"color:#dddddd; text-decoration:none; font-size:13px; margin:10px; text-align:center; font-family:Times New Roman, Times, serif; padding-bottom:10px;\";s:8:\"color_bg\";s:7:\"#454545\";s:18:\"acymailing_content\";s:0:\"\";s:16:\"acymailing_unsub\";s:131:\"color:#dddddd; text-decoration:none; font-size:13px; text-align:center; font-family:Times New Roman, Times, serif; padding-top:10px\";}', NULL, '.acyfooter a{\r\n	color:#454545;\r\n}\r\n.dark{\r\n	color:#454545;\r\n	font-weight:bold;\r\n}\r\ndiv,table,p, td{font-family:\"Times New Roman\", Times, serif;font-size:13px;color:#575757;}\r\n\r\n\r\n\r\n@media (min-width:10px){\r\n	.w600 { width:320px !important; }\r\n	.w540 { width:260px !important; }\r\n	.w30 { width:30px !important; }\r\n	.w600 img {max-width:320px; height:auto !important; }\r\n	.w540 img {max-width:260px; height:auto !important; }\r\n}\r\n\r\n@media (min-width: 480px){\r\n	.w600 { width:480px !important; }\r\n	.w540 { width:420px !important; }\r\n	.w30 { width:30px !important; }\r\n	.w600 img {max-width:480px; height:auto !important; }\r\n	.w540 img {max-width:420px; height:auto !important; }\r\n}\r\n\r\n@media (min-width:600px){\r\n	.w600 { width:600px !important; }\r\n	.w540 { width:540px !important; }\r\n	.w30 { width:30px !important; }\r\n	.w600 img {max-width:600px; height:auto !important; }\r\n	.w540 img {max-width:540px; height:auto !important; }\r\n}\r\n', NULL, NULL, NULL, NULL, 'media/com_acymailing/templates/newsletter-5/newsletter-5.png', '', 'all', '', NULL),
(3, 'Build Bio', '', '<div align=\"center\" style=\"width:100%; background-color:#3c3c3c; padding-bottom:20px; color:#ffffff;\">\r\n<div class=\"acymailing_online acyeditor_delete acyeditor_text\">{readonline}This e-mail contains graphics, if you don\'t see them <strong>» view it online.</strong>{/readonline}</div>\r\n\r\n<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"w600\" style=\"margin:auto; background-color:#ffffff; color:#575757;\" width=\"600\">\r\n	<tbody class=\"acyeditor_sortable\">\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w600\" colspan=\"3\" style=\"line-height:0px; background-color:#eeeeee\" valign=\"bottom\" width=\"600\"><img alt=\"mail\" height=\"41\" src=\"media/com_acymailing/templates/newsletter-6/images/header.png\" width=\"600\" /></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w30\" style=\"color:#ffffff;\" width=\"30\"></td>\r\n			<td class=\"acyeditor_picture w540\" style=\"line-height:0px; background-color:#ffffff; text-align:center\" width=\"540\"><img alt=\"\" src=\"media/com_acymailing/templates/newsletter-6/images/banner.png\" style=\"width: 540px; height: 122px;\" /></td>\r\n			<td class=\"w30\" height=\"122\" style=\"background-color:#ffffff\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w30\" style=\"background-color:#b9cf00; color:#ffffff;\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text w540\" height=\"25\" style=\"text-align:right; background-color:#b9cf00; color:#ffffff;\" width=\"540\"><span class=\"hide\">Newsletter</span> {date:3}</td>\r\n			<td class=\"w30\" style=\"background-color:#b9cf00; color:#ffffff;\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w600\" colspan=\"3\" height=\"25\" style=\"background-color:#ffffff\" width=\"600\"></td>\r\n		</tr>\r\n		<tr>\r\n			<td class=\"w30\" style=\"background-color:#ffffff\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text w540\" style=\"text-align:justify; color:#575757; background-color:#ffffff\" width=\"540\"><span class=\"intro\">Hello {subtag:name},</span><br />\r\n			<br />\r\n			Your introduction text here\r\n			<br />\r\n			<h2>Your title</h2>\r\n			<strong>Your catchphrase</strong><br />\r\n			Your content here <a href=\"#\">with some link</a><br />\r\n			<br />\r\n			More content<br />\r\n			<br />\r\n			<span class=\"acymailing_readmore\">Read More</span>\r\n\r\n			<h2>Another title</h2>\r\n			<img alt=\"picture\" height=\"160\" src=\"media/com_acymailing/templates/newsletter-6/images/picture.png\" style=\"float:left;\" width=\"193\" /> <strong>Another catchphrase</strong> Some content and <a href=\"#\">another link</a><br />\r\n			<br />\r\n			More content<br />\r\n			<br />\r\n			<span class=\"acymailing_readmore\">Read More</span></td>\r\n			<td class=\"w30\" style=\"background-color:#ffffff\" width=\"30\"></td>\r\n		</tr>\r\n		<tr style=\"line-height: 0px;\" class=\"acyeditor_delete\">\r\n			<td class=\"w600\" colspan=\"3\" style=\"line-height:0px; background-color:#efefef;\" valign=\"top\" width=\"600\"><img alt=\"--\" height=\"18\" src=\"media/com_acymailing/templates/newsletter-6/images/footer1.png\" width=\"600\" /></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w30\" height=\"20\" style=\"line-height:0px; background-color:#efefef;\" width=\"30\"></td>\r\n			<td class=\"acyfooter acyeditor_text w540\" style=\"text-align:right; background-color:#efefef; color:#575757;\" width=\"540\"><a href=\"#\">www.mywebsite.com</a> | <a href=\"#\">Contact</a><a href=\"#\"><img alt=\"message\" class=\"hide\" src=\"media/com_acymailing/templates/newsletter-6/images/mail.png\" style=\"border: medium none; width: 35px; height: 20px;\" /></a></td>\r\n			<td class=\"w30\" height=\"20\" style=\"line-height:0px; background-color:#efefef;\" width=\"30\"></td>\r\n		</tr>\r\n		<tr style=\"line-height: 0px;\" class=\"acyeditor_delete\">\r\n			<td class=\"w600\" colspan=\"3\" style=\"background-color:#efefef; line-height:0px;\" valign=\"top\" width=\"600\"><img alt=\"--\" height=\"24\" src=\"media/com_acymailing/templates/newsletter-6/images/footer2.png\" width=\"600\" /></td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n\r\n<div class=\"acymailing_unsub acyeditor_delete acyeditor_text\" >{unsubscribe}If you\'re not interested any more <strong>» unsubscribe</strong>{/unsubscribe}</div>\r\n</div>', '', NULL, 1, 0, 3, 'newsletter-6', 'a:9:{s:6:\"tag_h1\";s:69:\"font-weight:bold; font-size:14px;color:#3c3c3c !important;margin:0px;\";s:6:\"tag_h2\";s:129:\"color:#b9cf00 !important; font-size:14px; font-weight:bold; margin-top:20px; border-bottom:1px solid #d6d6d6; padding-bottom:4px;\";s:6:\"tag_h3\";s:149:\"color:#7e7e7e !important; font-size:14px; font-weight:bold; margin:20px 0px 0px 0px; border-bottom:1px solid #d6d6d6; padding-bottom:0px 0px 4px 0px;\";s:6:\"tag_h4\";s:84:\"color:#879700 !important; font-size:12px; font-weight:bold; margin:0px; padding:0px;\";s:8:\"color_bg\";s:7:\"#3c3c3c\";s:5:\"tag_a\";s:65:\"cursor:pointer; color:#a2b500; text-decoration:none; border:none;\";s:17:\"acymailing_online\";s:91:\"color:#dddddd; text-decoration:none; font-size:11px; text-align:center; padding-bottom:10px\";s:16:\"acymailing_unsub\";s:88:\"color:#dddddd; text-decoration:none; font-size:11px; text-align:center; padding-top:10px\";s:19:\"acymailing_readmore\";s:73:\"cursor:pointer; color:#ffffff; background-color:#b9cf00; padding:3px 5px;\";}', NULL, 'table, div, p, td{\r\n	font-family: Verdana, Arial, Helvetica, sans-serif;\r\n	font-size:11px;\r\n	color:#575757;\r\n}\r\n.intro{\r\n	font-weight:bold;\r\n	font-size:12px;}\r\n\r\n.acyfooter a{\r\n	color:#575757;}\r\n\r\n@media (min-width: 10px){\r\n	.w600  { width:320px !important; }\r\n	.w540  { width:260px !important; }\r\n	.w30 { width:30px !important; }\r\n	.w600 img{max-width:320px; height:auto !important}\r\n	.w540 img{max-width:260px; height:auto !important}\r\n}\r\n\r\n@media (min-width: 480px){\r\n	.w600  { width:480px !important; }\r\n	.w540  { width:420px !important; }\r\n	.w30 { width:30px !important; }\r\n	.w600 img{max-width:480px; height:auto !important}\r\n	.w540 img{max-width:420px; height:auto !important}\r\n}\r\n\r\n@media (min-width:600px){\r\n	.w600  { width:600px !important; }\r\n	.w540  { width:540px !important; }\r\n	.w30 { width:30px !important; }\r\n	.w600 img{max-width:600px; height:auto !important}\r\n	.w540 img{max-width:540px; height:auto !important}\r\n}\r\n', NULL, NULL, NULL, NULL, 'media/com_acymailing/templates/newsletter-6/newsletter-6.png', '', 'all', '', NULL),
(4, 'Technology', '', '<div align=\"center\" style=\"width:100%; background-color:#575757; padding-bottom:20px; color:#999999;\">\r\n<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"w600\" style=\"background-color:#fff; color:#999999; margin:auto\" width=\"600\">\r\n	<tbody class=\"acyeditor_sortable\">\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w30\" style=\"background-color:#575757\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text w540\" style=\"text-align:right; color:#d2d1d1; background-color:#575757\" width=\"540\"><span class=\"acymailing_online\">{readonline}If you can\'t see this e-mail properly, <span style=\"text-decoration:underline\">view it online</span>{/readonline}</span></td>\r\n			<td class=\"w30\" style=\"background-color:#575757\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"acyeditor_picture w600\" colspan=\"3\" style=\"line-height:0px; background-color:#575757\" valign=\"bottom\" width=\"600\"><img alt=\"--\" src=\"media/com_acymailing/templates/technology_resp/images/shadowtop.jpg\" /></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"acyeditor_picture w600\" colspan=\"3\" style=\"line-height:0px; background-color:#f5f5f5\" width=\"600\"><img alt=\"--\" src=\"media/com_acymailing/templates/technology_resp/images/top.jpg\" /></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w30\" height=\"32\" style=\"background-color:#f5f5f5; border-bottom:1px solid #ddd\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text links w540\" style=\"background-color:#f5f5f5; border-bottom:1px solid #ddd; text-align:right; color:#ababab\" width=\"540\"><a href=\"#\"><img alt=\"mail\" src=\"media/com_acymailing/templates/technology_resp/images/mail.jpg\" style=\"float:right; border:none\" /></a> Newsletter {mailid} | {date:%B %Y} |&nbsp; <a href=\"#\">www.acyba.com</a> |</td>\r\n			<td class=\"w30\" height=\"32\" style=\"background-color:#f5f5f5; border-bottom:1px solid #ddd\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w600\" colspan=\"3\" height=\"16\" width=\"600\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w30\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text w540\" width=\"540\"><img alt=\"picture\" src=\"media/com_acymailing/templates/technology_resp/images/pic1.jpg\" style=\"float:right\" />\r\n			<h1>Your title !</h1>\r\n\r\n			<h3>Your catchphrase</h3>\r\n			Your introduction content here</td>\r\n			<td class=\"w30\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w30\" style=\"background-color:#fafafa\" width=\"30\"></td>\r\n			<td class=\"acyeditor_picture w540\" style=\"background-color:#fafafa; line-height:0px\" width=\"540\"><img alt=\"---\" src=\"media/com_acymailing/templates/technology_resp/images/separator1.jpg\" /></td>\r\n			<td class=\"w30\" style=\"background-color:#fafafa\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w30\" style=\"background-color:#fafafa\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text w540\" style=\"background-color:#fafafa; color:#999999\" width=\"540\">\r\n			<h2>Your subtitle</h2>\r\n			<img alt=\"picture\" src=\"media/com_acymailing/templates/technology_resp/images/pic2.jpg\" style=\"float:left\" />\r\n			<h3>Your catchphrase</h3>\r\n			Your content here<br />\r\n			<a href=\"#\">Some link</a> and some content<br />\r\n			<br />\r\n			<img alt=\"buy this product\" src=\"media/com_acymailing/templates/technology_resp/images/buyproduct.jpg\" /><br />\r\n			<br />\r\n			<br />\r\n			<br />\r\n			&nbsp;\r\n			<h2>Another subtitle</h2>\r\n			<img alt=\"picture\" src=\"media/com_acymailing/templates/technology_resp/images/pic3.jpg\" style=\"float:right\" />\r\n			<h3>Another catchphrase</h3>\r\n			Other content<br />\r\n			<br />\r\n			<img alt=\"buy this product\" src=\"media/com_acymailing/templates/technology_resp/images/buyproduct.jpg\" /></td>\r\n			<td class=\"w30\" style=\"background-color:#fafafa\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w30\" style=\"background-color:#fafafa\" width=\"30\"></td>\r\n			<td class=\"acyeditor_picture w540\" style=\"background-color:#fafafa; line-height:0px\" width=\"540\"><img alt=\"---\" src=\"media/com_acymailing/templates/technology_resp/images/separator2.jpg\" /></td>\r\n			<td class=\"w30\" style=\"background-color:#fafafa\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w600\" colspan=\"3\" height=\"16\" width=\"600\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w30\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text special w540\" style=\"color:#999999\" width=\"540\">\r\n			<h2>Best product of the month</h2>\r\n\r\n			<h3>Lorem ipsum dolor sit amet.</h3>\r\n			Liget, volutpat esvft sem. Praesent auctor posuere orci, sit amet molee. Integer nec scelerisque quam. Lore uctor posum ipsum doLiget, volutpat esvft sem. Praesent auctor posuere orci, sit amet molee. Integer nec scelerisque quam. Lore uctor posum ipsum dolor sit amesent.<br />\r\n			<br />\r\n			<img alt=\"read more\" src=\"media/com_acymailing/templates/technology_resp/images/readmore.jpg\" style=\"border:none\" /></td>\r\n			<td class=\"w30\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w600\" colspan=\"3\" height=\"16\" width=\"600\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w30\" height=\"30\" style=\"background-color:#f5f5f5; border-top:1px solid #ddd\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text w540\" height=\"30\" style=\"background-color:#f5f5f5; border-top:1px solid #ddd; text-align:right; color:#ababab\" valign=\"bottom\" width=\"540\">Follow us | <img alt=\"facebook\" src=\"media/com_acymailing/templates/technology_resp/images/facebook.jpg\" style=\"border:none\" /> <img alt=\"twitter\" src=\"media/com_acymailing/templates/technology_resp/images/twitter.jpg\" style=\"border:none\" /> <img alt=\"pinterest\" src=\"media/com_acymailing/templates/technology_resp/images/pinterest.jpg\" style=\"border:none\" /> <img alt=\"rss\" src=\"media/com_acymailing/templates/technology_resp/images/rss.jpg\" style=\"border:none\" /></td>\r\n			<td class=\"w30\" height=\"30\" style=\"background-color:#f5f5f5; border-top:1px solid #ddd\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"acyeditor_picture w600\" colspan=\"3\" style=\"line-height:0px; background-color:#f5f5f5\" width=\"600\"><img alt=\"--\" src=\"media/com_acymailing/templates/technology_resp/images/bottom.jpg\" /></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"acyeditor_picture w600\" colspan=\"3\" style=\"line-height:0px; background-color:#575757\" valign=\"bottom\" width=\"600\"><img alt=\"--\" src=\"media/com_acymailing/templates/technology_resp/images/shadowbottom.jpg\" /></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w30\" style=\"background-color:#575757\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text w540\" style=\"text-align:right; color:#d2d1d1; background-color:#575757\" width=\"540\"><span class=\"acymailing_unsub\">{unsubscribe}If you don\'t want to receive our news anymore, <span style=\"text-decoration:underline\">unsubscribe</span>{/unsubscribe} </span></td>\r\n			<td class=\"w30\" style=\"background-color:#575757\" width=\"30\"></td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n</div>', '', NULL, 1, 0, 4, 'technology_resp', 'a:9:{s:6:\"tag_h1\";s:104:\"font-size:20px; margin:0px; margin-bottom:15px; padding:0px; font-weight:bold; color:#01bbe5 !important;\";s:6:\"tag_h2\";s:165:\"font-size:12px; font-weight:bold; color:#565656 !important; text-transform:uppercase; margin:10px 0px; padding:0px; padding-bottom:5px; border-bottom:1px solid #ddd;\";s:6:\"tag_h3\";s:104:\"color:#565656 !important; font-weight:bold; font-size:12px; margin:0px; margin-bottom:10px; padding:0px;\";s:6:\"tag_h4\";s:0:\"\";s:8:\"color_bg\";s:7:\"#575757\";s:5:\"tag_a\";s:62:\"cursor:pointer;color:#01bbe5;text-decoration:none;border:none;\";s:17:\"acymailing_online\";s:30:\"color:#d2d1d1; cursor:pointer;\";s:16:\"acymailing_unsub\";s:30:\"color:#d2d1d1; cursor:pointer;\";s:19:\"acymailing_readmore\";s:88:\"cursor:pointer; font-weight:bold; color:#fff; background-color:#01bbe5; padding:2px 5px;\";}', NULL, 'table, div, p , td{\r\n	font-family:Arial, Helvetica, sans-serif;\r\n	font-size:12px;\r\n}\r\np{margin:0px; padding:0px}\r\n\r\n.special h2{font-size:18px;\r\n	margin:0px;\r\n	margin-bottom:15px;\r\n	padding:0px;\r\n	font-weight:bold;\r\n	color:#01bbe5 !important;\r\n	text-transform:none;\r\n	border:none}\r\n\r\n.links a{color:#ababab}\r\n\r\n@media (min-width:10px){\r\n	.w600 { width:320px !important;}\r\n	.w540 { width:260px !important;}\r\n	.w30 { width:30px !important;}\r\n	.w600 img {max-width:320px; height:auto !important}\r\n	.w540 img {max-width:260px; height:auto !important}\r\n}\r\n\r\n@media (min-width: 480px){\r\n	.w600 { width:480px !important;}\r\n	.w540 { width:420px !important;}\r\n	.w30 { width:30px !important;}\r\n	.w600 img {max-width:480px; height:auto !important}\r\n	.w540 img {max-width:420px; height:auto !important}\r\n}\r\n\r\n@media (min-width:600px){\r\n	.w600 { width:600px !important;}\r\n	.w540 { width:540px !important;}\r\n	.w30 { width:30px !important;}\r\n	.w600 img {max-width:600px; height:auto !important}\r\n	.w540 img {max-width:540px; height:auto !important}\r\n}\r\n', NULL, NULL, NULL, NULL, 'media/com_acymailing/templates/technology_resp/thumb.jpg', '', 'all', '', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_url`
--

DROP TABLE IF EXISTS `#__acymailing_url`;
CREATE TABLE `#__acymailing_url` (
  `urlid` int(10) UNSIGNED NOT NULL,
  `name` varchar(250) NOT NULL,
  `url` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_urlclick`
--

DROP TABLE IF EXISTS `#__acymailing_urlclick`;
CREATE TABLE `#__acymailing_urlclick` (
  `urlid` int(10) UNSIGNED NOT NULL,
  `mailid` mediumint(8) UNSIGNED NOT NULL,
  `click` smallint(5) UNSIGNED NOT NULL DEFAULT '0',
  `subid` int(10) UNSIGNED NOT NULL,
  `date` int(10) UNSIGNED NOT NULL,
  `ip` varchar(100) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_userstats`
--

DROP TABLE IF EXISTS `#__acymailing_userstats`;
CREATE TABLE `#__acymailing_userstats` (
  `mailid` mediumint(8) UNSIGNED NOT NULL,
  `subid` int(10) UNSIGNED NOT NULL,
  `html` tinyint(3) UNSIGNED NOT NULL DEFAULT '1',
  `sent` tinyint(3) UNSIGNED NOT NULL DEFAULT '1',
  `senddate` int(10) UNSIGNED NOT NULL,
  `open` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `opendate` int(11) NOT NULL,
  `bounce` tinyint(4) NOT NULL DEFAULT '0',
  `fail` tinyint(4) NOT NULL DEFAULT '0',
  `ip` varchar(100) DEFAULT NULL,
  `browser` varchar(255) DEFAULT NULL,
  `browser_version` tinyint(3) UNSIGNED DEFAULT NULL,
  `is_mobile` tinyint(3) UNSIGNED DEFAULT NULL,
  `mobile_os` varchar(255) DEFAULT NULL,
  `user_agent` varchar(255) DEFAULT NULL,
  `bouncerule` varchar(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__assets`
--

DROP TABLE IF EXISTS `#__assets`;
CREATE TABLE `#__assets` (
  `id` int(10) UNSIGNED NOT NULL COMMENT 'Primary Key',
  `parent_id` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set parent.',
  `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `level` int(10) UNSIGNED NOT NULL COMMENT 'The cached level in the nested tree.',
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The unique name for the asset.\n',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The descriptive title for the asset.',
  `rules` varchar(5120) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded access control.'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__assets`
--

INSERT INTO `#__assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES
(1, 0, 1, 446, 0, 'root.1', 'Root Asset', '{\"core.login.site\":{\"6\":1,\"2\":1},\"core.login.admin\":{\"6\":1},\"core.login.offline\":[],\"core.admin\":{\"8\":1},\"core.manage\":{\"7\":1},\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(2, 1, 2, 3, 1, 'com_admin', 'com_admin', '{}'),
(3, 1, 4, 13, 1, 'com_banners', 'com_banners', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(4, 1, 14, 15, 1, 'com_cache', 'com_cache', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
(5, 1, 16, 17, 1, 'com_checkin', 'com_checkin', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
(6, 1, 18, 19, 1, 'com_config', 'com_config', '{}'),
(7, 1, 20, 89, 1, 'com_contact', 'com_contact', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(8, 1, 90, 193, 1, 'com_content', 'com_content', '{\"core.admin\":{\"7\":1},\"core.options\":[],\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1},\"core.edit.own\":[]}'),
(9, 1, 194, 195, 1, 'com_cpanel', 'com_cpanel', '{}'),
(10, 1, 196, 197, 1, 'com_installer', 'com_installer', '{\"core.admin\":[],\"core.manage\":{\"7\":0},\"core.delete\":{\"7\":0},\"core.edit.state\":{\"7\":0}}'),
(11, 1, 198, 199, 1, 'com_languages', 'com_languages', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(12, 1, 200, 201, 1, 'com_login', 'com_login', '{}'),
(13, 1, 202, 203, 1, 'com_mailto', 'com_mailto', '{}'),
(14, 1, 204, 205, 1, 'com_massmail', 'com_massmail', '{}'),
(15, 1, 206, 207, 1, 'com_media', 'com_media', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":{\"5\":1},\"core.edit\":[],\"core.edit.state\":[]}'),
(16, 1, 208, 209, 1, 'com_menus', 'com_menus', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(17, 1, 39, 40, 1, 'com_messages', 'com_messages', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
(18, 1, 212, 293, 1, 'com_modules', 'com_modules', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(19, 1, 294, 301, 1, 'com_newsfeeds', 'com_newsfeeds', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(20, 1, 302, 303, 1, 'com_plugins', 'com_plugins', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(21, 1, 304, 305, 1, 'com_redirect', 'com_redirect', '{\"core.admin\":{\"7\":1},\"core.manage\":[]}'),
(22, 1, 306, 307, 1, 'com_search', 'com_search', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
(23, 1, 308, 309, 1, 'com_templates', 'com_templates', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(24, 1, 310, 313, 1, 'com_users', 'com_users', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(26, 1, 314, 315, 1, 'com_wrapper', 'com_wrapper', '{}'),
(33, 1, 376, 377, 1, 'com_finder', 'com_finder', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
(34, 8, 107, 110, 2, 'com_content.category.9', 'Uncategorised', '{\"core.create\":{\"10\":0,\"12\":0},\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(35, 3, 7, 8, 2, 'com_banners.category.10', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(36, 7, 25, 26, 2, 'com_contact.category.11', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(37, 19, 297, 298, 2, 'com_newsfeeds.category.12', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(40, 3, 9, 10, 2, 'com_banners.category.15', 'Sample Data-Banners', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(41, 7, 27, 88, 2, 'com_contact.category.16', 'Sample Data-Contact', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(42, 19, 299, 300, 2, 'com_newsfeeds.category.17', 'Sample Data-Newsfeeds', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(44, 8, 113, 154, 2, 'com_content.category.19', 'Joomla!', '{\"core.create\":{\"10\":0,\"12\":0},\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'),
(46, 44, 140, 153, 3, 'com_content.category.21', 'Components', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'),
(59, 41, 28, 29, 3, 'com_contact.category.34', 'Park Site', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(60, 41, 30, 87, 3, 'com_contact.category.35', 'Shop Site', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(61, 60, 31, 32, 4, 'com_contact.category.36', 'Staff', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(62, 60, 33, 86, 4, 'com_contact.category.37', 'Fruit Encyclopedia', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(63, 62, 34, 35, 5, 'com_contact.category.38', 'A', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(64, 62, 36, 37, 5, 'com_contact.category.39', 'B', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(65, 62, 38, 39, 5, 'com_contact.category.40', 'C', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(66, 62, 40, 41, 5, 'com_contact.category.41', 'D', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(67, 62, 42, 43, 5, 'com_contact.category.42', 'E', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(68, 62, 44, 45, 5, 'com_contact.category.43', 'F', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(69, 62, 46, 47, 5, 'com_contact.category.44', 'G', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(70, 62, 48, 49, 5, 'com_contact.category.45', 'H', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(71, 62, 50, 51, 5, 'com_contact.category.46', 'I', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(72, 62, 52, 53, 5, 'com_contact.category.47', 'J', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(73, 62, 54, 55, 5, 'com_contact.category.48', 'K', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(74, 62, 56, 57, 5, 'com_contact.category.49', 'L', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(75, 62, 58, 59, 5, 'com_contact.category.50', 'M', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(76, 62, 60, 61, 5, 'com_contact.category.51', 'N', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(77, 62, 62, 63, 5, 'com_contact.category.52', 'O', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(78, 62, 64, 65, 5, 'com_contact.category.53', 'P', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(79, 62, 66, 67, 5, 'com_contact.category.54', 'Q', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(80, 62, 68, 69, 5, 'com_contact.category.55', 'R', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(81, 62, 70, 71, 5, 'com_contact.category.56', 'S', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(82, 62, 72, 73, 5, 'com_contact.category.57', 'T', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(83, 62, 74, 75, 5, 'com_contact.category.58', 'U', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(84, 62, 76, 77, 5, 'com_contact.category.59', 'V', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(85, 62, 78, 79, 5, 'com_contact.category.60', 'W', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(86, 62, 80, 81, 5, 'com_contact.category.61', 'X', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(87, 62, 82, 83, 5, 'com_contact.category.62', 'Y', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(88, 62, 84, 85, 5, 'com_contact.category.63', 'Z', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(89, 46, 141, 142, 4, 'com_content.article.1', 'Administrator Components', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(100, 44, 116, 117, 3, 'com_content.category.71', 'Milky Way', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(104, 44, 118, 119, 3, 'com_content.article.8', 'Beginners', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(105, 46, 143, 144, 4, 'com_content.article.9', 'Contact', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(106, 46, 145, 146, 4, 'com_content.article.10', 'Content', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(119, 44, 120, 121, 3, 'com_content.article.21', 'Getting Help', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(120, 44, 122, 123, 3, 'com_content.article.22', 'Getting Started', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(122, 44, 124, 125, 3, 'com_content.article.24', 'Joomla!', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(130, 44, 126, 127, 3, 'com_content.article.32', 'Parameters', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(133, 44, 128, 129, 3, 'com_content.article.35', 'Professionals', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(136, 44, 130, 131, 3, 'com_content.article.38', 'Sample Sites', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(137, 46, 147, 148, 4, 'com_content.article.39', 'Search', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(145, 44, 132, 133, 3, 'com_content.article.47', 'The Joomla! Community', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(146, 44, 134, 135, 3, 'com_content.article.48', 'The Joomla! Project', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(148, 44, 136, 137, 3, 'com_content.article.50', 'Upgraders', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(150, 46, 149, 150, 4, 'com_content.article.52', 'Users', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(151, 44, 138, 139, 3, 'com_content.article.53', 'Using Joomla!', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(158, 46, 151, 152, 4, 'com_content.article.60', 'News Feeds', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(168, 34, 108, 109, 3, 'com_content.article.67', 'What\'s New in 1.5?', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(169, 24, 311, 312, 2, 'com_users.category.77', 'Uncategorised', ''),
(173, 1, 378, 379, 1, 'com_joomlaupdate', 'com_joomlaupdate', '{\"core.admin\":[],\"core.manage\":[],\"core.delete\":[],\"core.edit.state\":[]}'),
(175, 1, 380, 381, 1, 'com_tags', 'com_tags', '{\"core.admin\":{\"8\":1},\"core.manage\":{\"7\":1},\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(176, 1, 382, 383, 1, 'com_contenthistory', 'com_contenthistory', '{}'),
(177, 1, 384, 385, 1, 'com_ajax', 'com_ajax', '{}'),
(178, 1, 386, 387, 1, 'com_postinstall', 'com_postinstall', '{}'),
(179, 8, 155, 192, 2, 'com_content.category.79', 'Blog', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(180, 1, 388, 415, 1, 'com_sppagebuilder', 'sppagebuilder', '{}'),
(181, 18, 213, 214, 2, 'com_modules.module.91', 'SP Page Builder', ''),
(182, 18, 215, 216, 2, 'com_modules.module.92', 'SP Page Builder Admin Menu', ''),
(185, 18, 217, 218, 2, 'com_modules.module.17', 'Breadcrumbs', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(186, 18, 219, 220, 2, 'com_modules.module.35', 'Search', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(187, 18, 221, 222, 2, 'com_modules.module.94', 'Bottom-1', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(188, 18, 223, 224, 2, 'com_modules.module.95', 'Latest News', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(189, 18, 225, 226, 2, 'com_modules.module.96', 'Our Partners', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(190, 18, 227, 228, 2, 'com_modules.module.97', 'Quick Link', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(191, 179, 156, 157, 3, 'com_content.category.80', 'News', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(192, 179, 158, 159, 3, 'com_content.category.81', 'Tutorial', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(193, 179, 160, 161, 3, 'com_content.category.82', 'Review', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(194, 179, 162, 163, 3, 'com_content.category.83', 'Updates', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(195, 179, 164, 165, 3, 'com_content.article.71', 'Doner spare ribs pastrami shank', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(196, 179, 166, 167, 3, 'com_content.article.72', 'Jerky shank chicken boudin', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(197, 179, 168, 169, 3, 'com_content.article.73', 'Leberkas tail swine pork', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(198, 179, 170, 171, 3, 'com_content.article.74', 'Meatball kevin beef ribs shoulder', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(199, 179, 172, 173, 3, 'com_content.article.75', '5 Effective Email Unsubscribe Pages', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(200, 179, 174, 175, 3, 'com_content.article.76', 'Who Actually Clicks on Banner Ads?', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(201, 179, 176, 177, 3, 'com_content.article.77', 'See the new Miss Universe get her crown', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(203, 18, 229, 230, 2, 'com_modules.module.99', 'Latest News', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(204, 18, 231, 232, 2, 'com_modules.module.100', 'Search', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(205, 18, 233, 234, 2, 'com_modules.module.101', 'Information', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(206, 18, 235, 236, 2, 'com_modules.module.102', 'Search', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(207, 18, 237, 238, 2, 'com_modules.module.103', 'Latest News', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(208, 18, 239, 240, 2, 'com_modules.module.104', 'Information', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(209, 18, 241, 242, 2, 'com_modules.module.105', 'Off Canvas Menu', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(212, 18, 243, 244, 2, 'com_modules.module.108', 'Helix 3 Preset', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(214, 1, 416, 417, 1, 'com_acymailing', 'AcyMailing', '{}'),
(215, 18, 245, 246, 2, 'com_modules.module.110', 'NEWSLETTER', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(216, 18, 247, 248, 2, 'com_modules.module.111', 'FLICKER GALLERY', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(217, 179, 178, 191, 3, 'com_content.category.84', 'Tixon Blog', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(218, 217, 179, 180, 4, 'com_content.article.78', 'See the New Miss Universe Get Her Crown', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(219, 217, 181, 182, 4, 'com_content.article.79', 'Who Actually Clicks on Banner Ads?', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(220, 217, 183, 184, 4, 'com_content.article.80', '5 Effective Email Unsubscribe Pages', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(221, 217, 185, 186, 4, 'com_content.article.81', 'Meatball Kevin Beef Ribs Shoulder', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(222, 217, 187, 188, 4, 'com_content.article.82', 'Leberkas Tail Swine Pork Opening Up a World of Education', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(223, 217, 189, 190, 4, 'com_content.article.83', 'Opening Up a World of Education For Next Generation', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(224, 1, 418, 419, 1, 'com_virtuemart', 'VIRTUEMART', '{}'),
(225, 1, 420, 421, 1, 'com_virtuemart_allinone', 'VirtueMart_allinone', '{}'),
(226, 18, 249, 250, 2, 'com_modules.module.112', 'VM - Administrator Module', ''),
(227, 18, 251, 252, 2, 'com_modules.module.113', 'VM - Currencies Selector', ''),
(228, 18, 253, 254, 2, 'com_modules.module.114', 'Latest products', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(229, 18, 255, 256, 2, 'com_modules.module.115', 'VM - Search in Shop', ''),
(230, 18, 257, 258, 2, 'com_modules.module.116', 'VM - Manufacturer', ''),
(231, 18, 259, 260, 2, 'com_modules.module.117', 'VM - Shopping cart', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(232, 18, 261, 262, 2, 'com_modules.module.118', 'Shop Category', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(233, 18, 263, 264, 2, 'com_modules.module.119', 'VM Currency Selector', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(234, 18, 265, 266, 2, 'com_modules.module.120', 'VM Manufacturers', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(235, 18, 267, 268, 2, 'com_modules.module.121', 'Top Products', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(236, 18, 269, 270, 2, 'com_modules.module.122', 'Search Product', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(237, 18, 271, 272, 2, 'com_modules.module.123', 'Shopping Cart', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(238, 18, 273, 274, 2, 'com_modules.module.124', 'VM Shopping Cart', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(242, 1, 422, 423, 1, 'com_tcpdf', 'tcpdf', '{}'),
(243, 18, 275, 276, 2, 'com_modules.module.125', 'GET IN TOUCH', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(244, 18, 277, 278, 2, 'com_modules.module.126', 'Recent Products 2', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(245, 18, 279, 280, 2, 'com_modules.module.127', 'Recent Products', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(246, 3, 11, 12, 2, 'com_banners.category.88', 'Menu Add', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(247, 18, 281, 282, 2, 'com_modules.module.128', 'Menu Add', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(248, 1, 424, 425, 1, '#__ucm_content.1', '#__ucm_content.1', '[]'),
(249, 1, 426, 427, 1, '#__ucm_content.2', '#__ucm_content.2', '[]'),
(250, 1, 428, 429, 1, '#__ucm_content.3', '#__ucm_content.3', '[]'),
(251, 1, 430, 431, 1, '#__ucm_content.4', '#__ucm_content.4', '[]'),
(252, 1, 432, 433, 1, '#__ucm_content.5', '#__ucm_content.5', '[]'),
(253, 1, 434, 435, 1, '#__ucm_content.6', '#__ucm_content.6', '[]'),
(254, 1, 436, 437, 1, '#__ucm_content.7', '#__ucm_content.7', '[]'),
(255, 1, 438, 441, 1, 'com_spsimpleportfolio', 'SP Simple Portfolio', '{}'),
(256, 18, 283, 284, 2, 'com_modules.module.129', 'Portfolio Module', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(257, 18, 285, 286, 2, 'com_modules.module.130', 'Portfolio Module -  Construct  Portfolio', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(258, 255, 439, 440, 2, 'com_spsimpleportfolio.category.89', 'Medical', '{}'),
(259, 18, 287, 288, 2, 'com_modules.module.131', 'Portfolio Module -  Medical  Portfolio', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(260, 18, 289, 290, 2, 'com_modules.module.132', 'Portfolio Module - Medical Portfolio', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(261, 18, 291, 292, 2, 'com_modules.module.133', 'SP Page Builder', '{}'),
(262, 1, 442, 443, 1, 'com_fields', 'com_fields', '{}'),
(263, 1, 444, 445, 1, 'com_associations', 'com_associations', '{}'),
(264, 180, 389, 390, 2, 'com_sppagebuilder.page.1', 'Home', '{}'),
(265, 180, 391, 392, 2, 'com_sppagebuilder.page.13', 'service', '{}'),
(266, 180, 393, 394, 2, 'com_sppagebuilder.page.10', 'About Us', '{}'),
(267, 180, 395, 396, 2, 'com_sppagebuilder.page.8', 'Lawyer', '{}'),
(268, 180, 397, 398, 2, 'com_sppagebuilder.page.9', 'Construction', '{}'),
(269, 180, 399, 400, 2, 'com_sppagebuilder.page.6', 'Portfolio', '{}'),
(270, 180, 401, 402, 2, 'com_sppagebuilder.page.17', 'Home Shop ', '{}'),
(271, 180, 403, 404, 2, 'com_sppagebuilder.page.18', 'agency', '{}'),
(272, 180, 405, 406, 2, 'com_sppagebuilder.page.59', 'Medical', '{}'),
(273, 180, 407, 408, 2, 'com_sppagebuilder.page.60', 'Politics', '{}'),
(274, 180, 409, 410, 2, 'com_sppagebuilder.page.14', 'Tixon-Pricing', '{}'),
(275, 180, 411, 412, 2, 'com_sppagebuilder.page.15', 'Faq', '{}'),
(276, 180, 413, 414, 2, 'com_sppagebuilder.page.16', 'Contact', '{}');

-- --------------------------------------------------------

--
-- Table structure for table `#__associations`
--

DROP TABLE IF EXISTS `#__associations`;
CREATE TABLE `#__associations` (
  `id` int(11) NOT NULL COMMENT 'A reference to the associated item.',
  `context` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The context of the associated item.',
  `key` char(32) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The key for the association computed from an md5 on associated ids.'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__banners`
--

DROP TABLE IF EXISTS `#__banners`;
CREATE TABLE `#__banners` (
  `id` int(11) NOT NULL,
  `cid` int(11) NOT NULL DEFAULT '0',
  `type` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `imptotal` int(11) NOT NULL DEFAULT '0',
  `impmade` int(11) NOT NULL DEFAULT '0',
  `clicks` int(11) NOT NULL DEFAULT '0',
  `clickurl` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `catid` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `custombannercode` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sticky` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `own_prefix` tinyint(1) NOT NULL DEFAULT '0',
  `metakey_prefix` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `purchase_type` tinyint(4) NOT NULL DEFAULT '-1',
  `track_clicks` tinyint(4) NOT NULL DEFAULT '-1',
  `track_impressions` tinyint(4) NOT NULL DEFAULT '-1',
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `reset` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `version` int(10) UNSIGNED NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__banners`
--

INSERT INTO `#__banners` (`id`, `cid`, `type`, `name`, `alias`, `imptotal`, `impmade`, `clicks`, `clickurl`, `state`, `catid`, `description`, `custombannercode`, `sticky`, `ordering`, `metakey`, `params`, `own_prefix`, `metakey_prefix`, `purchase_type`, `track_clicks`, `track_impressions`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `reset`, `created`, `language`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `version`) VALUES
(2, 3, 0, 'Shop 1', 'shop-1', 0, 0, 0, 'http://shop.joomla.org/amazoncom-bookstores.html', 1, 15, 'Get books about Joomla! at the Joomla! Book Shop.', '', 0, 1, '', '{\"imageurl\":\"images\\/banners\\/white.png\",\"width\":\"\",\"height\":\"\",\"alt\":\"Joomla! Books\"}', 0, '', -1, 0, 0, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2018-02-22 06:56:02', 'en-GB', 587, 'Joomla', '0000-00-00 00:00:00', 0, 1),
(3, 2, 0, 'Shop 2', 'shop-2', 0, 0, 0, 'http://shop.joomla.org', 1, 15, 'T Shirts, caps and more from the Joomla! Shop.', '', 0, 2, '', '{\"imageurl\":\"images\\/banners\\/white.png\",\"width\":\"\",\"height\":\"\",\"alt\":\"Joomla! Shop\"}', 0, '', -1, 0, 0, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2018-02-22 06:56:02', 'en-GB', 587, 'Joomla', '0000-00-00 00:00:00', 0, 1),
(4, 1, 0, 'Support Joomla!', 'support-joomla', 0, 0, 0, 'http://contribute.joomla.org', 1, 15, 'Your contributions of time, talent and money make Joomla possible.', '', 0, 3, '', '{\"imageurl\":\"images\\/banners\\/white.png\",\"width\":\"\",\"height\":\"\",\"alt\":\"\"}', 0, '', -1, 0, 0, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2018-02-22 06:56:02', 'en-GB', 587, 'Joomla', '0000-00-00 00:00:00', 0, 1),
(5, 0, 0, 'Menu Aadd', 'menu-aadd', 0, 8636, 6, 'http://joomshaper.com', 1, 88, '', '', 0, 4, '', '{\"imageurl\":\"images\\/demo\\/menu-ad.jpg\",\"width\":800,\"height\":\"\",\"alt\":\"Menu Add\"}', 0, '', -1, 0, 0, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2018-02-22 06:56:02', '*', 0, '', '2018-02-22 06:56:02', 587, 7);

-- --------------------------------------------------------

--
-- Table structure for table `#__banner_clients`
--

DROP TABLE IF EXISTS `#__banner_clients`;
CREATE TABLE `#__banner_clients` (
  `id` int(11) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `contact` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extrainfo` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `own_prefix` tinyint(4) NOT NULL DEFAULT '0',
  `metakey_prefix` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `purchase_type` tinyint(4) NOT NULL DEFAULT '-1',
  `track_clicks` tinyint(4) NOT NULL DEFAULT '-1',
  `track_impressions` tinyint(4) NOT NULL DEFAULT '-1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__banner_clients`
--

INSERT INTO `#__banner_clients` (`id`, `name`, `contact`, `email`, `extrainfo`, `state`, `checked_out`, `checked_out_time`, `metakey`, `own_prefix`, `metakey_prefix`, `purchase_type`, `track_clicks`, `track_impressions`) VALUES
(1, 'Joomla!', 'Administrator', 'email@email.com', '', 1, 0, '0000-00-00 00:00:00', '', 0, '', -1, -1, -1),
(2, 'Shop', 'Example', 'example@example.com', '', 1, 0, '0000-00-00 00:00:00', '', 0, '', -1, 0, 0),
(3, 'Bookstore', 'Bookstore Example', 'example@example.com', '', 1, 0, '0000-00-00 00:00:00', '', 0, '', -1, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__banner_tracks`
--

DROP TABLE IF EXISTS `#__banner_tracks`;
CREATE TABLE `#__banner_tracks` (
  `track_date` datetime NOT NULL,
  `track_type` int(10) UNSIGNED NOT NULL,
  `banner_id` int(10) UNSIGNED NOT NULL,
  `count` int(10) UNSIGNED NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__categories`
--

DROP TABLE IF EXISTS `#__categories`;
CREATE TABLE `#__categories` (
  `id` int(11) NOT NULL,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `parent_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `lft` int(11) NOT NULL DEFAULT '0',
  `rgt` int(11) NOT NULL DEFAULT '0',
  `level` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `path` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extension` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'The meta keywords for the page.',
  `metadata` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_user_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `hits` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `version` int(10) UNSIGNED NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__categories`
--

INSERT INTO `#__categories` (`id`, `asset_id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `extension`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `modified_user_id`, `modified_time`, `hits`, `language`, `version`) VALUES
(1, 0, 0, 0, 113, 0, '', 'system', 'ROOT', 'root', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{}', '', '', '', 587, '2018-02-22 06:56:02', 0, '0000-00-00 00:00:00', 0, '*', 1),
(9, 34, 1, 13, 14, 1, 'uncategorised', 'com_content', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 587, '2018-02-22 06:56:02', 0, '0000-00-00 00:00:00', 0, '*', 1),
(10, 35, 1, 87, 88, 1, 'uncategorised', 'com_banners', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\",\"foobar\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 587, '2018-02-22 06:56:02', 0, '0000-00-00 00:00:00', 0, '*', 1),
(11, 36, 1, 83, 84, 1, 'uncategorised', 'com_contact', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 587, '2018-02-22 06:56:02', 0, '0000-00-00 00:00:00', 0, '*', 1),
(12, 37, 1, 19, 20, 1, 'uncategorised', 'com_newsfeeds', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 587, '2018-02-22 06:56:02', 0, '0000-00-00 00:00:00', 0, '*', 1),
(15, 40, 1, 85, 86, 1, 'sample-data-banners', 'com_banners', 'Sample Data-Banners', 'sample-data-banners', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\",\"foobar\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 587, '2018-02-22 06:56:02', 0, '0000-00-00 00:00:00', 0, '*', 1),
(16, 41, 1, 21, 82, 1, 'sample-data-contact', 'com_contact', 'Sample Data-Contact', 'sample-data-contact', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 587, '2018-02-22 06:56:02', 0, '0000-00-00 00:00:00', 0, '*', 1),
(17, 42, 1, 17, 18, 1, 'sample-data-newsfeeds', 'com_newsfeeds', 'Sample Data-Newsfeeds', 'sample-data-newsfeeds', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 587, '2018-02-22 06:56:02', 0, '0000-00-00 00:00:00', 0, '*', 1),
(19, 44, 1, 1, 4, 1, 'joomla', 'com_content', 'Joomla!', 'joomla', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 587, '2018-02-22 06:56:02', 587, '2018-02-22 06:56:02', 0, '*', 1),
(21, 46, 19, 2, 3, 2, 'joomla/components', 'com_content', 'Components', 'components', '', '<p>Components are larger extensions that produce the major content for your site. Each component has one or more \"views\" that control how content is displayed. In the Joomla administrator there are additional extensions such as Menus, Redirection, and the extension managers.</p>', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 587, '2018-02-22 06:56:02', 587, '2018-02-22 06:56:02', 0, '*', 1),
(34, 59, 16, 22, 23, 2, 'sample-data-contact/park-site', 'com_contact', 'Park Site', 'park-site', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 587, '2018-02-22 06:56:02', 0, '0000-00-00 00:00:00', 0, 'en-GB', 1),
(35, 60, 16, 24, 81, 2, 'sample-data-contact/shop-site', 'com_contact', 'Shop Site', 'shop-site', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 587, '2018-02-22 06:56:02', 0, '0000-00-00 00:00:00', 0, '*', 1),
(36, 61, 35, 25, 26, 3, 'sample-data-contact/shop-site/staff', 'com_contact', 'Staff', 'staff', '', '<p>Please feel free to contact our staff at any time should you need assistance.</p>', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 587, '2018-02-22 06:56:02', 0, '0000-00-00 00:00:00', 0, '*', 1),
(37, 62, 35, 27, 80, 3, 'sample-data-contact/shop-site/fruit-encyclopedia', 'com_contact', 'Fruit Encyclopedia', 'fruit-encyclopedia', '', '<p> </p><p>Our directory of information about different kinds of fruit.</p><p>We love fruit and want the world to know more about all of its many varieties.</p><p>Although it is small now, we work on it whenever we have a chance.</p><p>All of the images can be found in <a href=\"http://commons.wikimedia.org/wiki/Main_Page\">Wikimedia Commons</a>.</p><p><img src=\"images/sampledata/fruitshop/apple.jpg\" border=\"0\" alt=\"Apples\" title=\"Apples\" /></p><p><em>This encyclopedia is implemented using the contact component, each fruit a separate contact and a category for each letter. A CSS style is used to create the horizontal layout of the alphabet headings. </em></p><p><em>If you wanted to, you could allow some users (such as your growers) to have access to just this category in the contact component and let them help you to create new content for the encyclopedia.</em></p><p> </p>', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 587, '2018-02-22 06:56:02', 0, '0000-00-00 00:00:00', 0, '*', 1),
(38, 63, 37, 28, 29, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/a', 'com_contact', 'A', 'a', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 587, '2018-02-22 06:56:02', 0, '0000-00-00 00:00:00', 0, '*', 1),
(39, 64, 37, 30, 31, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/b', 'com_contact', 'B', 'b', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 587, '2018-02-22 06:56:02', 0, '0000-00-00 00:00:00', 0, '*', 1),
(40, 65, 37, 32, 33, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/c', 'com_contact', 'C', 'c', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 587, '2018-02-22 06:56:02', 0, '0000-00-00 00:00:00', 0, '*', 1),
(41, 66, 37, 34, 35, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/d', 'com_contact', 'D', 'd', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 587, '2018-02-22 06:56:02', 0, '0000-00-00 00:00:00', 0, '*', 1),
(42, 67, 37, 36, 37, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/e', 'com_contact', 'E', 'e', '', '', 0, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 587, '2018-02-22 06:56:02', 0, '0000-00-00 00:00:00', 0, '*', 1),
(43, 68, 37, 38, 39, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/f', 'com_contact', 'F', 'f', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 587, '2018-02-22 06:56:02', 0, '0000-00-00 00:00:00', 0, '*', 1),
(44, 69, 37, 40, 41, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/g', 'com_contact', 'G', 'g', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 587, '2018-02-22 06:56:02', 0, '0000-00-00 00:00:00', 0, '*', 1),
(45, 70, 37, 42, 43, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/h', 'com_contact', 'H', 'h', '', '', 0, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 587, '2018-02-22 06:56:02', 0, '0000-00-00 00:00:00', 0, '*', 1),
(46, 71, 37, 44, 45, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/i', 'com_contact', 'I', 'i', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 587, '2018-02-22 06:56:02', 0, '0000-00-00 00:00:00', 0, '*', 1),
(47, 72, 37, 46, 47, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/j', 'com_contact', 'J', 'j', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 587, '2018-02-22 06:56:02', 0, '0000-00-00 00:00:00', 0, '*', 1),
(48, 73, 37, 48, 49, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/k', 'com_contact', 'K', 'k', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 587, '2018-02-22 06:56:02', 0, '0000-00-00 00:00:00', 0, '*', 1),
(49, 74, 37, 50, 51, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/l', 'com_contact', 'L', 'l', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 587, '2018-02-22 06:56:02', 0, '0000-00-00 00:00:00', 0, '*', 1),
(50, 75, 37, 52, 53, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/m', 'com_contact', 'M', 'm', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 587, '2018-02-22 06:56:02', 0, '0000-00-00 00:00:00', 0, '*', 1),
(51, 76, 37, 54, 55, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/n', 'com_contact', 'N', 'n', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 587, '2018-02-22 06:56:02', 0, '0000-00-00 00:00:00', 0, '*', 1),
(52, 77, 37, 56, 57, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/o', 'com_contact', 'O', 'o', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 587, '2018-02-22 06:56:02', 0, '0000-00-00 00:00:00', 0, '*', 1),
(53, 78, 37, 58, 59, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/p', 'com_contact', 'P', 'p', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 587, '2018-02-22 06:56:02', 0, '0000-00-00 00:00:00', 0, '*', 1),
(54, 79, 37, 60, 61, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/q', 'com_contact', 'Q', 'q', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 587, '2018-02-22 06:56:02', 0, '0000-00-00 00:00:00', 0, '*', 1),
(55, 80, 37, 62, 63, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/r', 'com_contact', 'R', 'r', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 587, '2018-02-22 06:56:02', 0, '0000-00-00 00:00:00', 0, '*', 1),
(56, 81, 37, 64, 65, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/s', 'com_contact', 'S', 's', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 587, '2018-02-22 06:56:02', 0, '0000-00-00 00:00:00', 0, '*', 1),
(57, 82, 37, 66, 67, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/t', 'com_contact', 'T', 't', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 587, '2018-02-22 06:56:02', 0, '0000-00-00 00:00:00', 0, '*', 1),
(58, 83, 37, 68, 69, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/u', 'com_contact', 'U', 'u', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 587, '2018-02-22 06:56:02', 0, '0000-00-00 00:00:00', 0, '*', 1),
(59, 84, 37, 70, 71, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/v', 'com_contact', 'V', 'v', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 587, '2018-02-22 06:56:02', 0, '0000-00-00 00:00:00', 0, '*', 1),
(60, 85, 37, 72, 73, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/w', 'com_contact', 'W', 'w', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 587, '2018-02-22 06:56:02', 0, '0000-00-00 00:00:00', 0, '*', 1),
(61, 86, 37, 74, 75, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/x', 'com_contact', 'X', 'x', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 587, '2018-02-22 06:56:02', 0, '0000-00-00 00:00:00', 0, '*', 1),
(62, 87, 37, 76, 77, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/y', 'com_contact', 'Y', 'y', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 587, '2018-02-22 06:56:02', 0, '0000-00-00 00:00:00', 0, '*', 1),
(63, 88, 37, 78, 79, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/z', 'com_contact', 'Z', 'z', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 587, '2018-02-22 06:56:02', 0, '0000-00-00 00:00:00', 0, '*', 1),
(77, 169, 1, 89, 90, 1, 'uncategorised', 'com_users', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 587, '2018-02-22 06:56:02', 0, '0000-00-00 00:00:00', 0, '*', 1),
(79, 179, 1, 91, 102, 1, 'blog', 'com_content', 'Blog', 'blog', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 587, '2018-02-22 06:56:02', 0, '0000-00-00 00:00:00', 0, '*', 1),
(80, 191, 79, 92, 93, 2, 'blog/news', 'com_content', 'News', 'news', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 587, '2018-02-22 06:56:02', 587, '2018-02-22 06:56:02', 0, '*', 1),
(81, 192, 79, 94, 95, 2, 'blog/tutorial', 'com_content', 'Tutorial', 'tutorial', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 587, '2018-02-22 06:56:02', 0, '0000-00-00 00:00:00', 0, '*', 1),
(82, 193, 79, 96, 97, 2, 'blog/review', 'com_content', 'Review', 'review', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 587, '2018-02-22 06:56:02', 0, '0000-00-00 00:00:00', 0, '*', 1),
(83, 194, 79, 98, 99, 2, 'blog/updates', 'com_content', 'Updates', 'updates', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 587, '2018-02-22 06:56:02', 0, '0000-00-00 00:00:00', 0, '*', 1),
(84, 217, 79, 100, 101, 2, 'blog/tixon-blog', 'com_content', 'Tixon Blog', 'tixon-blog', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 587, '2018-02-22 06:56:02', 587, '2018-02-22 06:56:02', 0, '*', 1),
(85, 239, 1, 103, 104, 1, 'construct', 'com_spsimpleportfolio', 'Construct', 'construct', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 587, '2018-02-22 06:56:02', 587, '2018-02-22 06:56:02', 0, '*', 1),
(87, 241, 1, 107, 108, 1, 'portfilio', 'com_spsimpleportfolio', 'Portfolio', 'Portfolio', '', '', 1, 0, '0000-00-00 00:00:00', 0, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 587, '2018-02-22 06:56:02', 587, '2018-02-22 06:56:02', 0, '*', 1),
(88, 246, 1, 109, 110, 1, 'menu-add', 'com_banners', 'Menu Add', 'menu-add', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 587, '2018-02-22 06:56:02', 0, '2018-02-22 06:56:02', 0, '*', 1),
(89, 258, 1, 111, 112, 1, 'medical', 'com_spsimpleportfolio', 'Medical', 'medical', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 587, '2018-02-22 06:56:02', 0, '2018-02-22 06:56:02', 0, '*', 1);

-- --------------------------------------------------------

--
-- Table structure for table `#__contact_details`
--

DROP TABLE IF EXISTS `#__contact_details`;
CREATE TABLE `#__contact_details` (
  `id` int(11) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `con_position` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` mediumtext COLLATE utf8mb4_unicode_ci,
  `suburb` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `postcode` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telephone` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fax` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `misc` longtext COLLATE utf8mb4_unicode_ci,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_to` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `default_con` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `catid` int(11) NOT NULL DEFAULT '0',
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `mobile` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `webpage` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname1` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname2` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname3` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `language` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `featured` tinyint(3) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',
  `xreference` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'A reference to enable linkages to external data sets.',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `version` int(10) UNSIGNED NOT NULL DEFAULT '1',
  `hits` int(10) UNSIGNED NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__contact_details`
--

INSERT INTO `#__contact_details` (`id`, `name`, `alias`, `con_position`, `address`, `suburb`, `state`, `country`, `postcode`, `telephone`, `fax`, `misc`, `image`, `email_to`, `default_con`, `published`, `checked_out`, `checked_out_time`, `ordering`, `params`, `user_id`, `catid`, `access`, `mobile`, `webpage`, `sortname1`, `sortname2`, `sortname3`, `language`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `metakey`, `metadesc`, `metadata`, `featured`, `xreference`, `publish_up`, `publish_down`, `version`, `hits`) VALUES
(1, 'Contact Name Here', 'name', 'Position', 'Street Address', 'Suburb', 'State', 'Country', 'Zip Code', 'Telephone', 'Fax', '<p>Information about or by the contact.</p>', 'images/powered_by.png', 'email@example.com', 1, 1, 0, '0000-00-00 00:00:00', 1, '{\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"presentation_style\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_profile\":\"\",\"show_links\":\"1\",\"linka_name\":\"Twitter\",\"linka\":\"http:\\/\\/twitter.com\\/joomla\",\"linkb_name\":\"YouTube\",\"linkb\":\"http:\\/\\/www.youtube.com\\/user\\/joomla\",\"linkc_name\":\"Facebook\",\"linkc\":\"http:\\/\\/www.facebook.com\\/joomla\",\"linkd_name\":\"FriendFeed\",\"linkd\":\"http:\\/\\/friendfeed.com\\/joomla\",\"linke_name\":\"Scribed\",\"linke\":\"http:\\/\\/www.scribd.com\\/people\\/view\\/504592-joomla\",\"contact_layout\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\"}', 0, 16, 1, '', '', 'last', 'first', 'middle', 'en-GB', '2018-02-22 06:56:02', 587, 'Joomla', '0000-00-00 00:00:00', 0, '', '', '{\"robots\":\"\",\"rights\":\"\"}', 1, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 13),
(2, 'Webmaster', 'webmaster', '', '', '', '', '', '', '', '', '', '', 'webmaster@example.com', 0, 1, 0, '0000-00-00 00:00:00', 1, '{\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"presentation_style\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_profile\":\"\",\"show_links\":\"\",\"linka_name\":\"\",\"linka\":\"\",\"linkb_name\":\"\",\"linkb\":\"\",\"linkc_name\":\"\",\"linkc\":\"\",\"linkd_name\":\"\",\"linkd\":\"\",\"linke_name\":\"\",\"linke\":\"\",\"show_email_form\":\"1\",\"show_email_copy\":\"1\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"1\",\"custom_reply\":\"\",\"redirect\":\"\"}', 0, 34, 1, '', '', '', '', '', 'en-GB', '2018-02-22 06:56:02', 587, 'Joomla', '0000-00-00 00:00:00', 0, '', '', '{\"robots\":\"\",\"rights\":\"\"}', 1, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 1),
(3, 'Owner', 'owner', '', '', '', '', '', '', '', '', '<p>I\'m the owner of this store.</p>', '', '', 0, 1, 0, '0000-00-00 00:00:00', 2, '{\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"presentation_style\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_profile\":\"\",\"show_links\":\"\",\"linka_name\":\"\",\"linka\":\"\",\"linkb_name\":\"\",\"linkb\":\"\",\"linkc_name\":\"\",\"linkc\":\"\",\"linkd_name\":\"\",\"linkd\":\"\",\"linke_name\":\"\",\"linke\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\"}', 0, 36, 1, '', '', '', '', '', '*', '2018-02-22 06:56:02', 587, 'Joomla', '0000-00-00 00:00:00', 0, '', '', '{\"robots\":\"\",\"rights\":\"\"}', 1, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0),
(4, 'Buyer', 'buyer', '', '', '', '', '', '', '', '', '<p>I am in charge of buying fruit. If you sell good fruit, contact me.</p>', '', '', 0, 1, 0, '0000-00-00 00:00:00', 1, '{\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"presentation_style\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_profile\":\"\",\"show_links\":\"0\",\"linka_name\":\"\",\"linka\":\"\",\"linkb_name\":\"\",\"linkb\":\"\",\"linkc_name\":\"\",\"linkc\":\"\",\"linkd_name\":\"\",\"linkd\":\"\",\"linke_name\":\"\",\"linke\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\"}', 0, 36, 1, '', '', '', '', '', '*', '2018-02-22 06:56:02', 587, 'Joomla', '0000-00-00 00:00:00', 0, '', '', '{\"robots\":\"\",\"rights\":\"\"}', 1, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 4),
(5, 'Bananas', 'bananas', 'Scientific Name: Musa', 'Image Credit: Enzik\r\nRights: Creative Commons Share Alike Unported 3.0\r\nSource: http://commons.wikimedia.org/wiki/File:Bananas_-_Morocco.jpg', '', 'Type: Herbaceous', 'Large Producers: India, China, Brasil', '', '', '', '<p>Bananas are a great source of potassium.</p>\r\n<p> </p>', 'images/sampledata/fruitshop/bananas_2.jpg', '', 0, 1, 0, '0000-00-00 00:00:00', 1, '{\"show_contact_category\":\"show_with_link\",\"show_contact_list\":\"\",\"presentation_style\":\"plain\",\"show_name\":\"\",\"show_position\":\"1\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"1\",\"show_postcode\":\"\",\"show_country\":\"1\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_profile\":\"\",\"show_links\":\"1\",\"linka_name\":\"Wikipedia: Banana English\",\"linka\":\"http:\\/\\/en.wikipedia.org\\/wiki\\/Banana\",\"linkb_name\":\"Wikipedia:  \\u0939\\u093f\\u0928\\u094d\\u0926\\u0940 \\u0915\\u0947\\u0932\\u093e\",\"linkb\":\"http:\\/\\/hi.wikipedia.org\\/wiki\\/%E0%A4%95%E0%A5%87%E0%A4%B2%E0%A4%BE\",\"linkc_name\":\"Wikipedia:Banana Portugu\\u00eas\",\"linkc\":\"http:\\/\\/pt.wikipedia.org\\/wiki\\/Banana\",\"linkd_name\":\"Wikipedia: \\u0411\\u0430\\u043d\\u0430\\u043d  \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439\",\"linkd\":\"http:\\/\\/ru.wikipedia.org\\/\\u0411\\u0430\\u043d\\u0430\\u043d\",\"linke_name\":\"\",\"linke\":\"\",\"contact_layout\":\"beez5:encyclopedia\"}', 0, 39, 1, '', '', '', '', '', '*', '2018-02-22 06:56:02', 587, 'Joomla', '0000-00-00 00:00:00', 0, '', '', '{\"robots\":\"\",\"rights\":\"\"}', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0),
(6, 'Apples', 'apples', 'Scientific Name: Malus domestica', 'Image Credit: Fievet\r\nRights: Public Domain\r\nSource: http://commons.wikimedia.org/wiki/File:Pommes_vertes.JPG', '', 'Family: Rosaceae', 'Large: Producers: China, United States', '', '', '', '<p>Apples are a versatile fruit, used for eating, cooking, and preserving.</p>\r\n<p>There are more that 7500 different kinds of apples grown around the world.</p>', 'images/sampledata/fruitshop/apple.jpg', '', 0, 1, 0, '0000-00-00 00:00:00', 1, '{\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"presentation_style\":\"plain\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_profile\":\"\",\"show_links\":\"1\",\"linka_name\":\"Wikipedia: Apples English\",\"linka\":\"http:\\/\\/en.wikipedia.org\\/wiki\\/Apple\",\"linkb_name\":\"Wikipedia: Manzana Espa\\u00f1ol \",\"linkb\":\"http:\\/\\/es.wikipedia.org\\/wiki\\/Manzana\",\"linkc_name\":\"Wikipedia: \\u82f9\\u679c \\u4e2d\\u6587\",\"linkc\":\"http:\\/\\/zh.wikipedia.org\\/zh\\/\\u82f9\\u679c\",\"linkd_name\":\"Wikipedia: Tofaa Kiswahili\",\"linkd\":\"http:\\/\\/sw.wikipedia.org\\/wiki\\/Tofaa\",\"linke_name\":\"\",\"linke\":\"\",\"contact_layout\":\"beez5:encyclopedia\"}', 0, 38, 1, '', '', '', '', '', '*', '2018-02-22 06:56:02', 587, 'Joomla', '0000-00-00 00:00:00', 0, '', '', '{\"robots\":\"\",\"rights\":\"\"}', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 1),
(7, 'Tamarind', 'tamarind', 'Scientific Name: Tamarindus indica', 'Image Credit: Franz Eugen Köhler, Köhler\'s Medizinal-Pflanzen \r\nRights: Public Domain\r\nSource:http://commons.wikimedia.org/wiki/File:Koeh-134.jpg', '', 'Family: Fabaceae', 'Large Producers: India, United States', '', '', '', '<p>Tamarinds are a versatile fruit used around the world. In its young form it is used in hot sauces; ripened it is the basis for many refreshing drinks.</p>\r\n<p> </p>', 'images/sampledata/fruitshop/tamarind.jpg', '', 0, 1, 0, '0000-00-00 00:00:00', 1, '{\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"presentation_style\":\"plain\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_profile\":\"\",\"show_links\":\"1\",\"linka_name\":\"Wikipedia: Tamarind English\",\"linka\":\"http:\\/\\/en.wikipedia.org\\/wiki\\/Tamarind\",\"linkb_name\":\"Wikipedia: \\u09a4\\u09c7\\u0981\\u09a4\\u09c1\\u09b2  \\u09ac\\u09be\\u0982\\u09b2\\u09be  \",\"linkb\":\"http:\\/\\/bn.wikipedia.org\\/wiki\\/\\u09a4\\u09c7\\u0981\\u09a4\\u09c1\\u09b2 \",\"linkc_name\":\"Wikipedia: Tamarinier Fran\\u00e7ais\",\"linkc\":\"http:\\/\\/fr.wikipedia.org\\/wiki\\/Tamarinier\",\"linkd_name\":\"Wikipedia:Tamaline lea faka-Tonga\",\"linkd\":\"http:\\/\\/to.wikipedia.org\\/wiki\\/Tamaline\",\"linke_name\":\"\",\"linke\":\"\",\"contact_layout\":\"beez5:encyclopedia\"}', 0, 57, 1, '', '', '', '', '', '*', '2018-02-22 06:56:02', 587, 'Joomla', '0000-00-00 00:00:00', 0, '', '', '{\"robots\":\"\",\"rights\":\"\"}', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0),
(8, 'Shop Address', 'shop-address', '', '', 'Our City', 'Our Province', 'Our Country', '', '555-555-5555', '', '<p>Here are directions for how to get to our shop.</p>', '', '', 0, 1, 0, '0000-00-00 00:00:00', 1, '{\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"presentation_style\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_profile\":\"\",\"show_links\":\"\",\"linka_name\":\"\",\"linka\":\"\",\"linkb_name\":\"\",\"linkb\":\"\",\"linkc_name\":\"\",\"linkc\":\"\",\"linkd_name\":\"\",\"linkd\":\"\",\"linke_name\":\"\",\"linke\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\"}', 0, 35, 1, '', '', '', '', '', '*', '2018-02-22 06:56:02', 587, 'Joomla', '0000-00-00 00:00:00', 0, '', '', '{\"robots\":\"\",\"rights\":\"\"}', 1, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `#__content`
--

DROP TABLE IF EXISTS `#__content`;
CREATE TABLE `#__content` (
  `id` int(10) UNSIGNED NOT NULL,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `introtext` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `fulltext` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `catid` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `images` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `urls` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribs` varchar(5120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` int(10) UNSIGNED NOT NULL DEFAULT '1',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `hits` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `featured` tinyint(3) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The language code for the article.',
  `xreference` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__content`
--

INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES
(1, 89, 'Administrator Components', 'administrator-components', '<p>All components are also used in the administrator area of your website. In addition to the ones listed here, there are components in the administrator that do not have direct front end displays, but do help shape your site. The most important ones for most users are</p>\r\n<ul>\r\n<li>Media Manager</li>\r\n<li>Extensions Manager</li>\r\n<li>Menu Manager</li>\r\n<li>Global Configuration</li>\r\n<li>Banners</li>\r\n<li>Redirect</li>\r\n</ul>\r\n<hr title=\"Media Manager\" alt=\"Media Manager\" class=\"system-pagebreak\" style=\"color: gray; border: 1px dashed gray;\" />\r\n<p> </p>\r\n<h3>Media Manager</h3>\r\n<p>The media manager component lets you upload and insert images into content throughout your site. Optionally, you can enable the flash uploader which will allow you to to upload multiple images. <a href=\"http://help.joomla.org/proxy/index.php?option=com_help&amp;keyref=Help31:Content_Media_Manager\">Help</a></p>\r\n<hr title=\"Extensions Manager\" alt=\"Extensions Manager\" class=\"system-pagebreak\" style=\"color: gray; border: 1px dashed gray;\" />\r\n<h3>Extensions Manager</h3>\r\n<p>The extensions manager lets you install, update, uninstall and manage all of your extensions. The extensions manager has been extensively redesigned, although the core install and uninstall functionality remains the same as in Joomla! 1.5. <a href=\"http://help.joomla.org/proxy/index.php?option=com_help&amp;keyref=Help31:Extensions_Extension_Manager_Install\">Help</a></p>\r\n<hr title=\"Menu Manager\" alt=\"Menu Manager\" class=\"system-pagebreak\" style=\"color: gray; border: 1px dashed gray;\" />\r\n<h3>Menu Manager</h3>\r\n<p>The menu manager lets you create the menus you see displayed on your site. It also allows you to assign modules and template styles to specific menu links. <a href=\"http://help.joomla.org/proxy/index.php?option=com_help&amp;keyref=Help31:Menus_Menu_Manager\">Help</a></p>\r\n<hr title=\"Global Configuration\" alt=\"Global Configuration\" class=\"system-pagebreak\" style=\"color: gray; border: 1px dashed gray;\" />\r\n<h3>Global Configuration</h3>\r\n<p>The global configuration is where the site administrator configures things such as whether search engine friendly urls are enabled, the site meta data (descriptive text used by search engines and indexers) and other functions. For many beginning users simply leaving the settings on default is a good way to begin, although when your site is ready for the public you will want to change the meta data to match its content. <a href=\"http://help.joomla.org/proxy/index.php?option=com_help&amp;keyref=Help31:Site_Global_Configuration\">Help</a></p>\r\n<hr title=\"Banners\" alt=\"Banners\" class=\"system-pagebreak\" style=\"color: gray; border: 1px dashed gray;\" />\r\n<h3>Banners</h3>\r\n<p>The banners component provides a simple way to display a rotating image in a module and, if you wish to have advertising, a way to track the number of times an image is viewed and clicked. <a href=\"http://help.joomla.org/proxy/index.php?option=com_help&amp;keyref=Help31:Components_Banners_Banners_Edit\">Help</a></p>\r\n<hr title=\"Redirect\" class=\"system-pagebreak\" />\r\n<h3><br />Redirect</h3>\r\n<p>The redirect component is used to manage broken links that produce Page Not Found (404) errors. If enabled it will allow you to redirect broken links to specific pages. It can also be used to manage migration related URL changes. <a href=\"http://help.joomla.org/proxy/index.php?option=com_help&amp;keyref=Help31:Components_Redirect_Manager\">Help</a></p>', '', 1, 21, '2018-02-22 06:56:02', 587, 'Joomla', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2018-02-22 06:56:02', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 1, 7, '', '', 1, 7, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(8, 104, 'Beginners', 'beginners', '<p>If this is your first Joomla! site or your first web site, you have come to the right place. Joomla will help you get your website up and running quickly and easily.</p>\r\n<p>Start off using your site by logging in using the administrator account you created when you installed Joomla.</p>\r\n', '\r\n<p>Explore the articles and other resources right here on your site data to learn more about how Joomla works. (When you\'re done reading, you can delete or archive all of this.) You will also probably want to visit the Beginners\' Areas of the <a href=\"http://docs.joomla.org/Beginners\">Joomla documentation</a> and <a href=\"http://forum.joomla.org\">support forums</a>.</p>\r\n<p>You\'ll also want to sign up for the Joomla Security Mailing list and the Announcements mailing list. For inspiration visit the <a href=\"http://community.joomla.org/showcase/\">Joomla! Site Showcase</a> to see an amazing array of ways people use Joomla to tell their stories on the web.</p>\r\n<p>The basic Joomla installation will let you get a great site up and running, but when you are ready for more features the power of Joomla is in the creative ways that developers have extended it to do all kinds of things. Visit the <a href=\"http://extensions.joomla.org/\">Joomla! Extensions Directory</a> to see thousands of extensions that can do almost anything you could want on a website. Can\'t find what you need? You may want to find a Joomla professional in the <a href=\"http://resources.joomla.org/\">Joomla! Resource Directory</a>.</p>\r\n<p>Want to learn more? Consider attending a <a href=\"http://community.joomla.org/events.html\">Joomla! Day</a> or other event or joining a local <a href=\"http://community.joomla.org/user-groups.html\">Joomla! Users Group</a>. Can\'t find one near you? Start one yourself.</p>', 1, 19, '2018-02-22 06:56:02', 587, 'Joomla', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2018-02-22 06:56:02', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 1, 4, '', '', 1, 3, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 1, '*', ''),
(9, 105, 'Contacts', 'contact', '<p>The contact component provides a way to provide contact forms and information for your site or to create a complex directory that can be used for many different purposes. <a href=\"http://help.joomla.org/proxy/index.php?option=com_help&amp;keyref=Help31:Components_Contacts_Contacts\">Help</a></p>', '', 1, 21, '2018-02-22 06:56:02', 587, 'Joomla', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2018-02-22 06:56:02', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', 1, 2, '', '', 1, 1, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(10, 106, 'Content', 'content', '<p>The content component (com_content) is what you use to write articles. It is extremely flexible and has the largest number of built in views. Articles can be created and edited from the front end, making content the easiest component to use to create your site content. <a href=\"http://help.joomla.org/proxy/index.php?option=com_help&amp;keyref=Help31:Content_Article_Manager\">Help</a></p>', '', 1, 21, '2018-02-22 06:56:02', 587, 'Joomla', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2018-02-22 06:56:02', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', 1, 1, '', '', 1, 3, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(21, 119, 'Getting Help', 'getting-help', '<p> There are lots of places you can get help with Joomla!. In many places in your site administrator you will see the help icon. Click on this for more information about the options and functions of items on your screen. Other places to get help are:</p>\r\n<ul>\r\n<li><a href=\"http://forum.joomla.org\">Support Forums</a></li>\r\n<li><a href=\"http://docs.joomla.org\">Documentation</a></li>\r\n<li><a href=\"http://resources.joomla.org\">Professionals</a></li>\r\n<li><a href=\"http://shop.joomla.org/amazoncom-bookstores.html\">Books</a></li>\r\n</ul>', '', 1, 19, '2018-02-22 06:56:02', 587, 'Joomla', '2018-02-22 06:56:02', 587, 0, '0000-00-00 00:00:00', '2018-02-22 06:56:02', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"0\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 2, 8, '', '', 1, 5, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(22, 120, 'Getting Started', 'getting-started', '<p>It\'s easy to get started creating your website. Knowing some of the basics will help.</p>\r\n<h3>What is a Content Management System?</h3>\r\n<p>A content management system is software that allows you to create and manage webpages easily by separating the creation of your content from the mechanics required to present it on the web.</p>\r\n<p>In this site, the content is stored in a <em>database</em>. The look and feel are created by a <em>template</em>. The Joomla! software brings together the template and the content to create web pages.</p>\r\n<h3>Site and Administrator</h3>\r\n<p>Your site actually has two separate sites. The site (also called the front end) is what visitors to your site will see. The administrator (also called the back end) is only used by people managing your site. You can access the administrator by clicking the \"Site Administrator\" link on the \"This Site\" menu or by adding /administrator to the end of you domain name.</p>\r\n<p>Log in to the administrator using the username and password created during the installation of Joomla.</p>\r\n<h3>Logging in</h3>\r\n<p>To login to the front end of your site use the login form or the login menu link on the \"This Site\" menu. Use the user name and password that were created as part of the installation process. Once logged-in you will be able to create and edit articles.</p>\r\n<p>In managing your site, you will be able to create content that only logged-in users are able to see.</p>\r\n<h3>Creating an article</h3>\r\n<p>Once you are logged-in, a new menu will be visible. To create a new article, click on the \"submit article\" link on that menu.</p>\r\n<p>The new article interface gives you a lot of options, but all you need to do is add a title and put something in the content area. To make it easy to find, set the state to published and put it in the Joomla category.</p>\r\n<div>You can edit an existing article by clicking on the edit icon (this only displays to users who have the right to edit).</div>\r\n<h3>Learn more</h3>\r\n<p>There is much more to learn about how to use Joomla! to create the web site you envision. You can learn much more at the <a href=\"http://docs.joomla.org\">Joomla! documentation site</a> and on the<a href=\"http://forum.joomla.org\"> Joomla! forums</a>.</p>', '', 1, 19, '2018-02-22 06:56:02', 587, 'Joomla', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2018-02-22 06:56:02', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 1, 9, '', '', 1, 68, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(24, 122, 'Joomla!', 'joomla', '<p>Congratulations! You have a Joomla site! Joomla makes it easy to build a website just the way you want it and keep it simple to update and maintain.</p>\r\n<p>Joomla is a flexible and powerful platform, whether you are building a small site for yourself or a huge site with hundreds of thousands of visitors. Joomla is open source, which means you can make it work just the way you want it to.</p>\r\n<p>The content in this installation of Joomla has been designed to give you an in depth tour of Joomla\'s features.</p>', '', 1, 19, '2018-02-22 06:56:02', 587, 'Joomla', '2018-02-22 06:56:02', 587, 0, '0000-00-00 00:00:00', '2018-02-22 06:56:02', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"0\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 3, 2, '', '', 1, 10, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 1, '*', ''),
(32, 130, 'Options', 'options', '<p>As you make your Joomla! site you will control the details of the display using <em>options</em> also referred to as <em>parameter</em><strong>s</strong>. Options control everything from whether the author\'s name is displayed to who can view what to the number of items shown on a list.</p>\r\n<p>Default options for each component are changed using the Options button on the component toolbar.</p>\r\n<p>Options can also be set on an individual item, such as an article or contact and in menu links.</p>\r\n<p>If you are happy with how your site looks, it is fine to leave all of the options set to the defaults that were created when your site was installed. As you become more experienced with Joomla you will use options more.</p>\r\n<p> </p>', '', 1, 19, '2018-02-22 06:56:02', 587, 'Joomla', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2018-02-22 06:56:02', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 1, 10, '', '', 1, 8, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(35, 133, 'Professionals', 'professionals', '<p>Joomla! 3 continues development of the Joomla Platform and CMS as a powerful and flexible way to bring your vision of the web to reality. With the new administrator interface and adoption of Twitter Bootstrap, the ability to control its look and the management of extensions is now complete.</p>\r\n', '\r\n<p>Working with multiple template styles and overrides for the same views, creating the design you want is easier than it has ever been. Limiting support to PHP 5.3.10 and above makes Joomla lighter and faster than ever. </p>\r\n<p>The separation of the Joomla! Platform project from the Joomla! CMS project makes continuous development of new, powerful APIs and continuous improvement of existing APIs possible while maintaining the stability of the CMS that millions of webmasters and professionals rely upon.</p>', 1, 19, '2018-02-22 06:56:02', 587, 'Joomla', '2018-02-22 06:56:02', 587, 0, '0000-00-00 00:00:00', '2018-02-22 06:56:02', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"0\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 2, 5, '', '', 1, 43, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 1, '*', ''),
(38, 136, 'Sample Sites', 'sample-sites', '<p>Your installation includes sample data, designed to show you some of the options you have for building your website. In addition to information about Joomla! there are two sample \"sites within a site\" designed to help you get started with building your own site.</p>\r\n<p>The first site is a simple site about <a href=\"index.php?Itemid=243\">Australian Parks</a>. It shows how you can quickly and easily build a personal site with just the building blocks that are part of Joomla. It includes a personal blog, weblinks, and a very simple image gallery.</p>\r\n<p>The second site is slightly more complex and represents what you might do if you are building a site for a small business, in this case a <a href=\"index.php/welcome.html\"></a><a href=\"index.php?Itemid=429\">Fruit Shop</a>.</p>\r\n<p>In building either style site, or something completely different, you will probably want to add <a href=\"http://extensions.joomla.org\">extensions</a> and either create or purchase your own template. Many Joomla users start by modifying the <a href=\"http://docs.joomla.org/How_do_you_modify_a_template%3F\">templates</a> that come with the core distribution so that they include special images and other design elements that relate to their site\'s focus.</p>', '', 1, 19, '2018-02-22 06:56:02', 587, 'Joomla', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2018-02-22 06:56:02', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 1, 11, '', '', 1, 15, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(39, 137, 'Search', 'search-component', '<p>Joomla! 2.5 offers two search options.</p>\r\n<p>The Basic Search component provides basic search functionality for the information contained in your core components. Many extensions can also be searched by the search component. <a href=\"http://help.joomla.org/proxy/index.php?option=com_help&amp;keyref=Help31:Components_Search\">Help</a></p>\r\n<p>The Smart Search component offers searching similar to that found in major search engines. Smart Search is disabled by default. If you choose to enable it you will need to take several steps. First, enable the Smart Search Plugin in the plugin manager. Then, if you are using the Basic Search Module replace it with the Smart Search Module. Finally, if you have already created content, go to the Smart Search component in your site administrator and click the Index icon. Once indexing of your content is complete, Smart Search will be ready to use. Help.</p>', '', 1, 21, '2018-02-22 06:56:02', 587, 'Joomla', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2018-02-22 06:56:02', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 1, 3, '', '', 1, 19, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(47, 145, 'The Joomla! Community', 'the-joomla-community', '<p>Joomla means All Together, and it is a community of people all working and having fun together that makes Joomla possible. Thousands of people each year participate in the Joomla community, and we hope you will be one of them.</p>\r\n<p>People with all kinds of skills, of all skill levels and from around the world are welcome to join in. Participate in the <a href=\"http://joomla.org\">Joomla.org</a> family of websites (the<a href=\"http://forum.joomla.org\"> forum </a>is a great place to start). Come to a <a href=\"http://community.joomla.org/events.html\">Joomla! event</a>. Join or start a <a href=\"http://community.joomla.org/user-groups.html\">Joomla! Users Group</a>. Whether you are a developer, site administrator, designer, end user or fan, there are ways for you to participate and contribute.</p>', '', 1, 19, '2018-02-22 06:56:02', 587, 'Joomla', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2018-02-22 06:56:02', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 1, 3, '', '', 1, 2, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(48, 146, 'The Joomla! Project', 'the-joomla-project', '<p>The Joomla Project consists of all of the people who make and support the Joomla Web Platform and Content Management System.</p>\r\n<p>Our mission is to provide a flexible platform for digital publishing and collaboration.</p>\r\n<p>The core values are:</p>\r\n<ul>\r\n<li>Freedom</li>\r\n<li>Equality</li>\r\n<li>Trust</li>\r\n<li>Community</li>\r\n<li>Collaboration</li>\r\n<li>Usability</li>\r\n</ul>\r\n<p>In our vision, we see:</p>\r\n<ul>\r\n<li>People publishing and collaborating in their communities and around the world</li>\r\n<li>Software that is free, secure, and high-quality</li>\r\n<li>A community that is enjoyable and rewarding to participate in</li>\r\n<li>People around the world using their preferred languages</li>\r\n<li>A project that acts autonomously</li>\r\n<li>A project that is socially responsible</li>\r\n<li>A project dedicated to maintaining the trust of its users</li>\r\n</ul>\r\n<p>There are millions of users around the world and thousands of people who contribute to the Joomla Project. They work in three main groups: the Production Working Group, responsible for everything that goes into software and documentation; the Community Working Group, responsible for creating a nurturing the community; and Open Source Matters, the non profit organization responsible for managing legal, financial and organizational issues.</p>\r\n<p>Joomla is a free and open source project, which uses the GNU General Public License version 2 or later.</p>', '', 1, 19, '2018-02-22 06:56:02', 587, 'Joomla', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2018-02-22 06:56:02', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 1, 1, '', '', 1, 4, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(50, 148, 'Upgraders', 'upgraders', '<p>If you are an experienced Joomla! user, this Joomla site will seem very familiar but also very different. The biggest change is the new administrator interface and the adoption of responsive design. Hundreds of other improvements have been made.</p>\r\n<p> </p>\r\n<p> </p>', '', 1, 19, '2018-02-22 06:56:02', 587, 'Joomla', '2018-02-22 06:56:02', 587, 0, '0000-00-00 00:00:00', '2018-02-22 06:56:02', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"0\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 3, 6, '', '', 1, 3, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 1, '*', ''),
(52, 150, 'Users', 'users-component', '<p>The users extension lets your site visitors register, login and logout, change their passwords and other information, and recover lost passwords. In the administrator it allows you to create, block and manage users and create user groups and access levels. <a href=\"http://help.joomla.org/proxy/index.php?option=com_help&amp;keyref=Help31:Users_User_Manager\">Help</a></p>\r\n<p>Please note that some of the user views will not display if you are not logged-in to the site.</p>', '', 1, 21, '2018-02-22 06:56:02', 587, 'Joomla', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2018-02-22 06:56:02', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', 1, 5, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(53, 151, 'Using Joomla!', 'using-joomla', '<p>With Joomla you can create anything from a simple personal website to a complex ecommerce or social site with millions of visitors.</p>\r\n<p>This section of the sample data provides you with a brief introduction to Joomla concepts and reference material to help you understand how Joomla works.</p>\r\n<p><em>When you no longer need the sample data, you can can simply unpublish the sample data category found within each extension in the site administrator or you may completely delete each item and all of the categories. </em></p>', '', 1, 19, '2018-02-22 06:56:02', 587, 'Joomla', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2018-02-22 06:56:02', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 1, 7, '', '', 1, 9, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(60, 158, 'News Feeds', 'news-feeds', '<p>News Feeds (com_newsfeeds) provides a way to organize and present news feeds. News feeds are a way that you present information from another site on your site. For example, the joomla.org website has numerous feeds that you can incorporate on your site. You an use menus to present a single feed, a list of feeds in a category, or a list of all feed categories. <a href=\"http://help.joomla.org/proxy/index.php?option=com_help&amp;keyref=Help31:Components_Newsfeeds_Feeds\">Help</a></p>', '', 1, 21, '2018-02-22 06:56:02', 587, 'Joomla', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2018-02-22 06:56:02', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 1, 4, '', '', 1, 8, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(67, 168, 'What\'s New in 1.5?', 'whats-new-in-15', '<p>This article deliberately archived as an example.</p><p>As with previous releases, Joomla! provides a unified and easy-to-use framework for delivering content for Web sites of all kinds. To support the changing nature of the Internet and emerging Web technologies, Joomla! required substantial restructuring of its core functionality and we also used this effort to simplify many challenges within the current user interface. Joomla! 1.5 has many new features.</p>\r\n<p style=\"margin-bottom: 0in;\">In Joomla! 1.5, you\'\'ll notice:</p>\r\n<ul>\r\n<li>Substantially improved usability, manageability, and scalability far beyond the original Mambo foundations</li>\r\n<li>Expanded accessibility to support internationalisation, double-byte characters and right-to-left support for Arabic, Farsi, and Hebrew languages among others</li>\r\n<li>Extended integration of external applications through Web services</li>\r\n<li>Enhanced content delivery, template and presentation capabilities to support accessibility standards and content delivery to any destination</li>\r\n<li>A more sustainable and flexible framework for Component and Extension developers</li>\r\n<li>Backward compatibility with previous releases of Components, Templates, Modules, and other Extensions</li>\r\n</ul>', '', 2, 9, '2018-02-22 06:56:02', 587, 'Joomla', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2018-02-22 06:56:02', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_readmore\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"page_title\":\"\",\"alternative_readmore\":\"\",\"layout\":\"\"}', 1, 0, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(71, 195, 'Doner spare ribs pastrami shank', 'doner-spare-ribs-pastrami-shank', '<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.</p>\r\n', '\r\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus</p>', 1, 79, '2018-02-22 06:56:02', 587, '', '2018-02-22 06:56:02', 587, 0, '0000-00-00 00:00:00', '2018-02-22 06:56:02', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"post_format\":\"status\",\"gallery\":\"\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"<blockquote class=\\\"twitter-tweet\\\" lang=\\\"en\\\"><p>Published a new blog entry One Month Extra for all JoomShaper Members in News. <a href=\\\"http:\\/\\/t.co\\/2pQYdykKy8\\\">http:\\/\\/t.co\\/2pQYdykKy8<\\/a><\\/p>&mdash; JoomShaper (@joomshaper) <a href=\\\"https:\\/\\/twitter.com\\/joomshaper\\/status\\/562210375480139777\\\">February 2, 2015<\\/a><\\/blockquote>\\r\\n<script async src=\\\"\\/\\/platform.twitter.com\\/widgets.js\\\" charset=\\\"utf-8\\\"><\\/script>\"}', 4, 6, '', '', 1, 19, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(72, 196, 'Jerky shank chicken boudin', 'jerky-shank-chicken-boudin', '<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.</p>\r\n', '\r\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus</p>', 1, 79, '2018-02-22 06:56:02', 587, '', '2018-02-22 06:56:02', 587, 0, '0000-00-00 00:00:00', '2018-02-22 06:56:02', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"post_format\":\"video\",\"gallery\":\"\",\"audio\":\"\",\"video\":\"http:\\/\\/vimeo.com\\/43426940\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\"}', 4, 5, '', '', 1, 51, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(73, 197, 'Leberkas tail swine pork', 'leberkas-tail-swine-pork', '<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.</p>\r\n', '\r\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus</p>', 1, 79, '2018-02-22 06:56:02', 587, '', '2018-02-22 06:56:02', 587, 0, '0000-00-00 00:00:00', '2018-02-22 06:56:02', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/blog\\/blog01.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/blog01.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"post_format\":\"standard\",\"gallery\":\"\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\"}', 3, 4, '', '', 1, 133, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES
(74, 198, 'Meatball kevin beef ribs shoulder', 'meatball-kevin-beef-ribs-shoulder', '<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.</p>\r\n', '\r\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus</p>', 1, 79, '2018-02-22 06:56:02', 587, '', '2018-02-22 06:56:02', 587, 0, '0000-00-00 00:00:00', '2018-02-22 06:56:02', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"post_format\":\"gallery\",\"gallery\":\"{\\\"gallery_images\\\":[\\\"images\\/blog\\/blog06.jpg\\\",\\\"images\\/blog\\/blog05.jpg\\\",\\\"images\\/blog\\/blog04.jpg\\\"]}\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\"}', 3, 3, '', '', 1, 49, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(75, 199, '5 Effective Email Unsubscribe Pages', '5-effective-email-unsubscribe-pages', '<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.</p>\r\n', '\r\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus</p>', 1, 79, '2018-02-22 06:56:02', 587, '', '2018-02-22 06:56:02', 587, 0, '0000-00-00 00:00:00', '2018-02-22 06:56:02', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"post_format\":\"audio\",\"gallery\":\"\",\"audio\":\"<iframe width=\\\"100%\\\" height=\\\"450\\\" scrolling=\\\"no\\\" frameborder=\\\"no\\\" src=\\\"https:\\/\\/w.soundcloud.com\\/player\\/?url=https%3A\\/\\/api.soundcloud.com\\/tracks\\/28830162&amp;auto_play=false&amp;hide_related=false&amp;show_comments=true&amp;show_user=true&amp;show_reposts=false&amp;visual=true\\\"><\\/iframe>\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\"}', 4, 2, '', '', 1, 27, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(76, 200, 'Who Actually Clicks on Banner Ads?', 'who-actually-clicks-on-banner-ads', '<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.</p>\r\n', '\r\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus</p>', 1, 79, '2018-02-22 06:56:02', 587, '', '2018-02-22 06:56:02', 587, 0, '0000-00-00 00:00:00', '2018-02-22 06:56:02', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"post_format\":\"link\",\"gallery\":\"\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"Responive Joomla Templates\",\"link_url\":\"http:\\/\\/www.joomshaper.com\\/joomla-templates\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\"}', 4, 1, '', '', 1, 42, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(77, 201, 'See the new Miss Universe get her crown', 'see-the-new-miss-universe-get-her-crown', '<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.</p>\r\n', '\r\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus</p>', 1, 79, '2018-02-22 06:56:02', 587, '', '2018-02-22 06:56:02', 587, 0, '0000-00-00 00:00:00', '2018-02-22 06:56:02', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"post_format\":\"quote\",\"gallery\":\"\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"Pork meatball ground round prosciutto. Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami. Filet mignon bresaola pork boudin capicola prosciutto. Frankfurter chicken leberkas drumstick ball tip turducken rump spare ribs meatball. Tail salami pork loin ham. Drumstick flank porchetta, hamburger ham swine biltong chicken pancetta. Spare ribs prosciutto t-bone.\",\"quote_author\":\"- John Doe\",\"post_status\":\"\"}', 2, 0, '', '', 1, 43, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(78, 218, 'See the New Miss Universe Get Her Crown', 'see-the-new-miss-universe-get-her-crown', '<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.</p>\r\n', '\r\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus</p>', 1, 84, '2018-02-22 06:56:02', 587, '', '2018-02-22 06:56:02', 587, 0, '0000-00-00 00:00:00', '2018-02-22 06:56:02', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/demo\\/blog\\/blog1.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/demo\\/blog\\/blog1.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"post_format\":\"standard\",\"gallery\":\"\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\"}', 4, 4, '', '', 1, 22, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(79, 219, 'Who Actually Clicks on Banner Ads?', 'who-actually-clicks-on-banner-ads', '<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.</p>\r\n', '\r\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus</p>', 1, 84, '2018-02-22 06:56:02', 587, '', '2018-02-22 06:56:02', 587, 0, '0000-00-00 00:00:00', '2018-02-22 06:56:02', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/demo\\/blog\\/blog2.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/demo\\/blog\\/blog2.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"post_format\":\"standard\",\"gallery\":\"\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\"}', 4, 3, '', '', 1, 34, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(80, 220, '5 Effective Email Unsubscribe Pages', '5-effective-email-unsubscribe-pages', '<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.</p>\r\n', '\r\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus</p>', 1, 84, '2018-02-22 06:56:02', 587, '', '2018-02-22 06:56:02', 587, 0, '0000-00-00 00:00:00', '2018-02-22 06:56:02', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/demo\\/blog\\/blog3.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/demo\\/blog\\/blog3.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"post_format\":\"standard\",\"gallery\":\"\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\"}', 4, 2, '', '', 1, 29, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(81, 221, 'Meatball Kevin Beef Ribs Shoulder', 'meatball-kevin-beef-ribs-shoulder', '<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.</p>\r\n', '\r\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus</p>', 1, 84, '2018-02-22 06:56:02', 587, '', '2018-02-22 06:56:02', 587, 0, '0000-00-00 00:00:00', '2018-02-22 06:56:02', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/demo\\/blog\\/blog4.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/demo\\/blog\\/blog4.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"post_format\":\"standard\",\"gallery\":\"\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\"}', 4, 1, '', '', 1, 84, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(82, 222, 'Leberkas Tail Swine Pork Opening Up a World of Education', 'leberkas-tail-swine-pork-opening-up-a-world-of-education', '<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.</p>\r\n', '\r\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus</p>', 1, 84, '2018-02-22 06:56:02', 587, '', '2018-02-22 06:56:02', 587, 0, '0000-00-00 00:00:00', '2018-02-22 06:56:02', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/demo\\/blog\\/blog5.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/demo\\/blog\\/blog5.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"post_format\":\"standard\",\"gallery\":\"\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\"}', 4, 0, '', '', 1, 131, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(83, 223, 'Opening Up a World of Education For Next Generation', 'opening-up-a-world-of-education-for-next-generation', '<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.</p>\r\n', '\r\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus</p>', 1, 84, '2018-02-22 06:56:02', 587, '', '2018-02-22 06:56:02', 587, 0, '0000-00-00 00:00:00', '2018-02-22 06:56:02', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/demo\\/blog\\/blog6.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/demo\\/blog\\/blog6.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"post_format\":\"standard\",\"gallery\":\"\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\"}', 5, 0, '', '', 1, 82, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '');

-- --------------------------------------------------------

--
-- Table structure for table `#__contentitem_tag_map`
--

DROP TABLE IF EXISTS `#__contentitem_tag_map`;
CREATE TABLE `#__contentitem_tag_map` (
  `type_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_content_id` int(10) UNSIGNED NOT NULL COMMENT 'PK from the core content table',
  `content_item_id` int(11) NOT NULL COMMENT 'PK from the content type table',
  `tag_id` int(10) UNSIGNED NOT NULL COMMENT 'PK from the tag table',
  `tag_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Date of most recent save for this tag-item',
  `type_id` mediumint(8) NOT NULL COMMENT 'PK from the content_type table'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Maps items from content tables to tags';

--
-- Dumping data for table `#__contentitem_tag_map`
--

INSERT INTO `#__contentitem_tag_map` (`type_alias`, `core_content_id`, `content_item_id`, `tag_id`, `tag_date`, `type_id`) VALUES
('com_content.article', 2, 76, 2, '2018-02-22 00:56:02', 1),
('com_content.article', 2, 76, 3, '2018-02-22 00:56:02', 1),
('com_content.article', 2, 76, 4, '2018-02-22 00:56:02', 1),
('com_content.article', 2, 76, 5, '2018-02-22 00:56:02', 1),
('com_content.article', 7, 78, 2, '2018-02-22 00:56:02', 1),
('com_content.article', 7, 78, 5, '2018-02-22 00:56:02', 1),
('com_content.article', 6, 79, 2, '2018-02-22 00:56:02', 1),
('com_content.article', 6, 79, 3, '2018-02-22 00:56:02', 1),
('com_content.article', 6, 79, 4, '2018-02-22 00:56:02', 1),
('com_content.article', 5, 80, 2, '2018-02-22 00:56:02', 1),
('com_content.article', 5, 80, 4, '2018-02-22 00:56:02', 1),
('com_content.article', 5, 80, 5, '2018-02-22 00:56:02', 1),
('com_content.article', 4, 81, 3, '2018-02-22 00:56:02', 1),
('com_content.article', 4, 81, 4, '2018-02-22 00:56:02', 1),
('com_content.article', 4, 81, 5, '2018-02-22 00:56:02', 1),
('com_content.article', 3, 82, 2, '2018-02-22 00:56:02', 1),
('com_content.article', 3, 82, 3, '2018-02-22 00:56:02', 1),
('com_content.article', 3, 82, 5, '2018-02-22 00:56:02', 1),
('com_content.article', 1, 83, 2, '2018-02-22 00:56:02', 1),
('com_content.article', 1, 83, 3, '2018-02-22 00:56:02', 1),
('com_content.article', 1, 83, 4, '2018-02-22 00:56:02', 1);

-- --------------------------------------------------------

--
-- Table structure for table `#__content_frontpage`
--

DROP TABLE IF EXISTS `#__content_frontpage`;
CREATE TABLE `#__content_frontpage` (
  `content_id` int(11) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__content_frontpage`
--

INSERT INTO `#__content_frontpage` (`content_id`, `ordering`) VALUES
(8, 2),
(24, 1),
(35, 4),
(50, 3);

-- --------------------------------------------------------

--
-- Table structure for table `#__content_rating`
--

DROP TABLE IF EXISTS `#__content_rating`;
CREATE TABLE `#__content_rating` (
  `content_id` int(11) NOT NULL DEFAULT '0',
  `rating_sum` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `rating_count` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `lastip` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__content_rating`
--

INSERT INTO `#__content_rating` (`content_id`, `rating_sum`, `rating_count`, `lastip`) VALUES
(39, 5, 1, '10.0.1.17'),
(72, 5, 1, '::1'),
(73, 5, 1, '::1'),
(74, 9, 2, '10.0.1.2'),
(75, 9, 2, '10.0.1.6'),
(77, 5, 1, '::1'),
(79, 9, 2, '10.0.1.17'),
(80, 3, 1, '10.0.1.3'),
(81, 5, 1, '10.0.1.3'),
(82, 4, 1, '10.0.1.3'),
(83, 4, 1, '10.0.1.3');

-- --------------------------------------------------------

--
-- Table structure for table `#__content_types`
--

DROP TABLE IF EXISTS `#__content_types`;
CREATE TABLE `#__content_types` (
  `type_id` int(10) UNSIGNED NOT NULL,
  `type_title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type_alias` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `table` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `rules` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_mappings` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `router` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `content_history_options` varchar(5120) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'JSON string for com_contenthistory options'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__content_types`
--

INSERT INTO `#__content_types` (`type_id`, `type_title`, `type_alias`, `table`, `rules`, `field_mappings`, `router`, `content_history_options`) VALUES
(1, 'Article', 'com_content.article', '{\"special\":{\"dbtable\":\"#__content\",\"key\":\"id\",\"type\":\"Content\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"state\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"introtext\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"attribs\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"urls\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"asset_id\"}, \"special\":{\"fulltext\":\"fulltext\"}}', 'ContentHelperRoute::getArticleRoute', '{\"formFile\":\"administrator\\/components\\/com_content\\/models\\/forms\\/article.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}'),
(2, 'Weblink', 'com_weblinks.weblink', '{\"special\":{\"dbtable\":\"#__weblinks\",\"key\":\"id\",\"type\":\"Weblink\",\"prefix\":\"WeblinksTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"state\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"urls\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"null\"}, \"special\":{}}', 'WeblinksHelperRoute::getWeblinkRoute', '{\"formFile\":\"administrator\\/components\\/com_weblinks\\/models\\/forms\\/weblink.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"featured\",\"images\"], \"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\"], \"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"], \"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}'),
(3, 'Contact', 'com_contact.contact', '{\"special\":{\"dbtable\":\"#__contact_details\",\"key\":\"id\",\"type\":\"Contact\",\"prefix\":\"ContactTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"address\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"image\", \"core_urls\":\"webpage\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"null\"}, \"special\":{\"con_position\":\"con_position\",\"suburb\":\"suburb\",\"state\":\"state\",\"country\":\"country\",\"postcode\":\"postcode\",\"telephone\":\"telephone\",\"fax\":\"fax\",\"misc\":\"misc\",\"email_to\":\"email_to\",\"default_con\":\"default_con\",\"user_id\":\"user_id\",\"mobile\":\"mobile\",\"sortname1\":\"sortname1\",\"sortname2\":\"sortname2\",\"sortname3\":\"sortname3\"}}', 'ContactHelperRoute::getContactRoute', '{\"formFile\":\"administrator\\/components\\/com_contact\\/models\\/forms\\/contact.xml\",\"hideFields\":[\"default_con\",\"checked_out\",\"checked_out_time\",\"version\",\"xreference\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"], \"displayLookup\":[ {\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ] }'),
(4, 'Newsfeed', 'com_newsfeeds.newsfeed', '{\"special\":{\"dbtable\":\"#__newsfeeds\",\"key\":\"id\",\"type\":\"Newsfeed\",\"prefix\":\"NewsfeedsTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"link\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"null\"}, \"special\":{\"numarticles\":\"numarticles\",\"cache_time\":\"cache_time\",\"rtl\":\"rtl\"}}', 'NewsfeedsHelperRoute::getNewsfeedRoute', '{\"formFile\":\"administrator\\/components\\/com_newsfeeds\\/models\\/forms\\/newsfeed.xml\",\"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}'),
(5, 'User', 'com_users.user', '{\"special\":{\"dbtable\":\"#__users\",\"key\":\"id\",\"type\":\"User\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"null\",\"core_alias\":\"username\",\"core_created_time\":\"registerdate\",\"core_modified_time\":\"lastvisitDate\",\"core_body\":\"null\", \"core_hits\":\"null\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"access\":\"null\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"null\", \"core_language\":\"null\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"null\", \"core_ordering\":\"null\", \"core_metakey\":\"null\", \"core_metadesc\":\"null\", \"core_catid\":\"null\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\":{}}', 'UsersHelperRoute::getUserRoute', ''),
(6, 'Article Category', 'com_content.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'ContentHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
(7, 'Contact Category', 'com_contact.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'ContactHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
(8, 'Newsfeeds Category', 'com_newsfeeds.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'NewsfeedsHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
(9, 'Weblinks Category', 'com_weblinks.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'WeblinksHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
(10, 'Tag', 'com_tags.tag', '{\"special\":{\"dbtable\":\"#__tags\",\"key\":\"tag_id\",\"type\":\"Tag\",\"prefix\":\"TagsTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"urls\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"null\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\"}}', 'TagsHelperRoute::getTagRoute', '{\"formFile\":\"administrator\\/components\\/com_tags\\/models\\/forms\\/tag.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\", \"lft\", \"rgt\", \"level\", \"path\", \"urls\", \"publish_up\", \"publish_down\"],\"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}]}'),
(11, 'Banner', 'com_banners.banner', '{\"special\":{\"dbtable\":\"#__banners\",\"key\":\"id\",\"type\":\"Banner\",\"prefix\":\"BannersTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"description\", \"core_hits\":\"null\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"link\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\":{\"imptotal\":\"imptotal\", \"impmade\":\"impmade\", \"clicks\":\"clicks\", \"clickurl\":\"clickurl\", \"custombannercode\":\"custombannercode\", \"cid\":\"cid\", \"purchase_type\":\"purchase_type\", \"track_impressions\":\"track_impressions\", \"track_clicks\":\"track_clicks\"}}', '', '{\"formFile\":\"administrator\\/components\\/com_banners\\/models\\/forms\\/banner.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\", \"reset\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"imptotal\", \"impmade\", \"reset\"], \"convertToInt\":[\"publish_up\", \"publish_down\", \"ordering\"], \"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"cid\",\"targetTable\":\"#__banner_clients\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}'),
(12, 'Banners Category', 'com_banners.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\": {\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', '', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"], \"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
(13, 'Banner Client', 'com_banners.client', '{\"special\":{\"dbtable\":\"#__banner_clients\",\"key\":\"id\",\"type\":\"Client\",\"prefix\":\"BannersTable\"}}', '', '', '', '{\"formFile\":\"administrator\\/components\\/com_banners\\/models\\/forms\\/client.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\"], \"ignoreChanges\":[\"checked_out\", \"checked_out_time\"], \"convertToInt\":[], \"displayLookup\":[]}'),
(14, 'User Notes', 'com_users.note', '{\"special\":{\"dbtable\":\"#__user_notes\",\"key\":\"id\",\"type\":\"Note\",\"prefix\":\"UsersTable\"}}', '', '', '', '{\"formFile\":\"administrator\\/components\\/com_users\\/models\\/forms\\/note.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\", \"publish_up\", \"publish_down\"],\"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\"], \"convertToInt\":[\"publish_up\", \"publish_down\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}]}'),
(15, 'User Notes Category', 'com_users.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', '', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"], \"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}');

-- --------------------------------------------------------

--
-- Table structure for table `#__core_log_searches`
--

DROP TABLE IF EXISTS `#__core_log_searches`;
CREATE TABLE `#__core_log_searches` (
  `search_term` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `hits` int(10) UNSIGNED NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__extensions`
--

DROP TABLE IF EXISTS `#__extensions`;
CREATE TABLE `#__extensions` (
  `extension_id` int(11) NOT NULL,
  `package_id` int(11) NOT NULL DEFAULT '0' COMMENT 'Parent package ID for extensions installed as a package.',
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `element` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `folder` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_id` tinyint(3) NOT NULL,
  `enabled` tinyint(3) NOT NULL DEFAULT '0',
  `access` int(10) UNSIGNED NOT NULL DEFAULT '1',
  `protected` tinyint(3) NOT NULL DEFAULT '0',
  `manifest_cache` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `custom_data` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `system_data` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) DEFAULT '0',
  `state` int(11) DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__extensions`
--

INSERT INTO `#__extensions` (`extension_id`, `package_id`, `name`, `type`, `element`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `system_data`, `checked_out`, `checked_out_time`, `ordering`, `state`) VALUES
(1, 0, 'com_mailto', 'component', 'com_mailto', '', 0, 1, 1, 1, '{\"name\":\"com_mailto\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MAILTO_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mailto\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(2, 0, 'com_wrapper', 'component', 'com_wrapper', '', 0, 1, 1, 1, '{\"name\":\"com_wrapper\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_WRAPPER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"wrapper\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(3, 0, 'com_admin', 'component', 'com_admin', '', 1, 1, 1, 1, '{\"name\":\"com_admin\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_ADMIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(4, 0, 'com_banners', 'component', 'com_banners', '', 1, 1, 1, 0, '{\"name\":\"com_banners\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"banners\"}', '{\"purchase_type\":\"3\",\"track_impressions\":\"0\",\"track_clicks\":\"0\",\"metakey_prefix\":\"\",\"save_history\":\"1\",\"history_limit\":10}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(5, 0, 'com_cache', 'component', 'com_cache', '', 1, 1, 1, 1, '{\"name\":\"com_cache\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CACHE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(6, 0, 'com_categories', 'component', 'com_categories', '', 1, 1, 1, 1, '{\"name\":\"com_categories\",\"type\":\"component\",\"creationDate\":\"December 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(7, 0, 'com_checkin', 'component', 'com_checkin', '', 1, 1, 1, 1, '{\"name\":\"com_checkin\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CHECKIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(8, 0, 'com_contact', 'component', 'com_contact', '', 1, 1, 1, 0, '{\"name\":\"com_contact\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contact\"}', '{\"show_contact_category\":\"hide\",\"save_history\":\"1\",\"history_limit\":10,\"show_contact_list\":\"0\",\"presentation_style\":\"sliders\",\"show_name\":\"1\",\"show_position\":\"1\",\"show_email\":\"0\",\"show_street_address\":\"1\",\"show_suburb\":\"1\",\"show_state\":\"1\",\"show_postcode\":\"1\",\"show_country\":\"1\",\"show_telephone\":\"1\",\"show_mobile\":\"1\",\"show_fax\":\"1\",\"show_webpage\":\"1\",\"show_misc\":\"1\",\"show_image\":\"1\",\"image\":\"\",\"allow_vcard\":\"0\",\"show_articles\":\"0\",\"show_profile\":\"0\",\"show_links\":\"0\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"contact_icons\":\"0\",\"icon_address\":\"\",\"icon_email\":\"\",\"icon_telephone\":\"\",\"icon_mobile\":\"\",\"icon_fax\":\"\",\"icon_misc\":\"\",\"show_headings\":\"1\",\"show_position_headings\":\"1\",\"show_email_headings\":\"0\",\"show_telephone_headings\":\"1\",\"show_mobile_headings\":\"0\",\"show_fax_headings\":\"0\",\"allow_vcard_headings\":\"0\",\"show_suburb_headings\":\"1\",\"show_state_headings\":\"1\",\"show_country_headings\":\"1\",\"show_email_form\":\"1\",\"show_email_copy\":\"1\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"1\",\"custom_reply\":\"0\",\"redirect\":\"\",\"show_category_crumb\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(9, 0, 'com_cpanel', 'component', 'com_cpanel', '', 1, 1, 1, 1, '{\"name\":\"com_cpanel\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CPANEL_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10, 0, 'com_installer', 'component', 'com_installer', '', 1, 1, 1, 1, '{\"name\":\"com_installer\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_INSTALLER_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(11, 0, 'com_languages', 'component', 'com_languages', '', 1, 1, 1, 1, '{\"name\":\"com_languages\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\"}', '{\"administrator\":\"en-GB\",\"site\":\"en-GB\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(12, 0, 'com_login', 'component', 'com_login', '', 1, 1, 1, 1, '{\"name\":\"com_login\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_LOGIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(13, 0, 'com_media', 'component', 'com_media', '', 1, 1, 0, 1, '{\"name\":\"com_media\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MEDIA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"media\"}', '{\"upload_extensions\":\"bmp,csv,doc,gif,ico,jpg,jpeg,odg,odp,ods,odt,pdf,png,ppt,swf,txt,xcf,xls,BMP,CSV,DOC,GIF,ICO,JPG,JPEG,ODG,ODP,ODS,ODT,PDF,PNG,PPT,SWF,TXT,XCF,XLS\",\"upload_maxsize\":\"10\",\"file_path\":\"images\",\"image_path\":\"images\",\"restrict_uploads\":\"1\",\"allowed_media_usergroup\":\"3\",\"check_mime\":\"1\",\"image_extensions\":\"bmp,gif,jpg,png\",\"ignore_extensions\":\"\",\"upload_mime\":\"image\\/jpeg,image\\/gif,image\\/png,image\\/bmp,application\\/x-shockwave-flash,application\\/msword,application\\/excel,application\\/pdf,application\\/powerpoint,text\\/plain,application\\/x-zip\",\"upload_mime_illegal\":\"text\\/html\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(14, 0, 'com_menus', 'component', 'com_menus', '', 1, 1, 1, 1, '{\"name\":\"com_menus\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MENUS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(15, 0, 'com_messages', 'component', 'com_messages', '', 1, 1, 1, 1, '{\"name\":\"com_messages\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MESSAGES_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(16, 0, 'com_modules', 'component', 'com_modules', '', 1, 1, 1, 1, '{\"name\":\"com_modules\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MODULES_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(17, 0, 'com_newsfeeds', 'component', 'com_newsfeeds', '', 1, 1, 1, 0, '{\"name\":\"com_newsfeeds\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"newsfeeds\"}', '{\"newsfeed_layout\":\"_:default\",\"save_history\":\"1\",\"history_limit\":5,\"show_feed_image\":\"1\",\"show_feed_description\":\"1\",\"show_item_description\":\"1\",\"feed_character_count\":\"0\",\"feed_display_order\":\"des\",\"float_first\":\"right\",\"float_second\":\"right\",\"show_tags\":\"1\",\"category_layout\":\"_:default\",\"show_category_title\":\"1\",\"show_description\":\"1\",\"show_description_image\":\"1\",\"maxLevel\":\"-1\",\"show_empty_categories\":\"0\",\"show_subcat_desc\":\"1\",\"show_cat_items\":\"1\",\"show_cat_tags\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"1\",\"show_cat_items_cat\":\"1\",\"filter_field\":\"1\",\"show_pagination_limit\":\"1\",\"show_headings\":\"1\",\"show_articles\":\"0\",\"show_link\":\"1\",\"show_pagination\":\"1\",\"show_pagination_results\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(18, 0, 'com_plugins', 'component', 'com_plugins', '', 1, 1, 1, 1, '{\"name\":\"com_plugins\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_PLUGINS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(19, 0, 'com_search', 'component', 'com_search', '', 1, 1, 1, 0, '{\"name\":\"com_search\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_SEARCH_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"search\"}', '{\"enabled\":\"0\",\"show_date\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(20, 0, 'com_templates', 'component', 'com_templates', '', 1, 1, 1, 1, '{\"name\":\"com_templates\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_TEMPLATES_XML_DESCRIPTION\",\"group\":\"\"}', '{\"template_positions_display\":\"0\",\"upload_limit\":\"2\",\"image_formats\":\"gif,bmp,jpg,jpeg,png\",\"source_formats\":\"txt,less,ini,xml,js,php,css\",\"font_formats\":\"woff,ttf,otf\",\"compressed_formats\":\"zip\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(22, 0, 'com_content', 'component', 'com_content', '', 1, 1, 0, 1, '{\"name\":\"com_content\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"content\"}', '{\"article_layout\":\"_:default\",\"show_title\":\"1\",\"link_titles\":\"1\",\"show_intro\":\"1\",\"info_block_position\":\"0\",\"show_category\":\"1\",\"link_category\":\"1\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"1\",\"link_author\":\"1\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"1\",\"show_item_navigation\":\"1\",\"show_vote\":\"1\",\"show_readmore\":\"1\",\"show_readmore_title\":\"0\",\"readmore_limit\":\"100\",\"show_tags\":\"1\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"0\",\"urls_position\":\"0\",\"show_publishing_options\":\"1\",\"show_article_options\":\"1\",\"save_history\":\"1\",\"history_limit\":10,\"show_urls_images_frontend\":\"0\",\"show_urls_images_backend\":\"1\",\"targeta\":0,\"targetb\":0,\"targetc\":0,\"float_intro\":\"left\",\"float_fulltext\":\"left\",\"category_layout\":\"_:blog\",\"show_category_heading_title_text\":\"1\",\"show_category_title\":\"0\",\"show_description\":\"0\",\"show_description_image\":\"0\",\"maxLevel\":\"0\",\"show_empty_categories\":\"0\",\"show_no_articles\":\"1\",\"show_subcat_desc\":\"0\",\"show_cat_num_articles\":\"0\",\"show_cat_tags\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"0\",\"show_cat_num_articles_cat\":\"1\",\"num_leading_articles\":\"1\",\"num_intro_articles\":\"4\",\"num_columns\":\"1\",\"num_links\":\"0\",\"multi_column_order\":\"0\",\"show_subcategory_content\":\"0\",\"show_pagination_limit\":\"1\",\"filter_field\":\"hide\",\"show_headings\":\"1\",\"list_show_date\":\"0\",\"date_format\":\"\",\"list_show_hits\":\"1\",\"list_show_author\":\"1\",\"orderby_pri\":\"order\",\"orderby_sec\":\"rdate\",\"order_date\":\"published\",\"show_pagination\":\"2\",\"show_pagination_results\":\"0\",\"show_featured\":\"show\",\"show_feed_link\":\"1\",\"feed_summary\":\"0\",\"feed_show_readmore\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(23, 0, 'com_config', 'component', 'com_config', '', 1, 1, 0, 1, '{\"name\":\"com_config\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CONFIG_XML_DESCRIPTION\",\"group\":\"\"}', '{\"filters\":{\"1\":{\"filter_type\":\"NH\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"9\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"6\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"7\":{\"filter_type\":\"NONE\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"2\":{\"filter_type\":\"NH\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"3\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"4\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"5\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"8\":{\"filter_type\":\"NONE\",\"filter_tags\":\"\",\"filter_attributes\":\"\"}}}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(24, 0, 'com_redirect', 'component', 'com_redirect', '', 1, 1, 0, 1, '{\"name\":\"com_redirect\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_REDIRECT_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(25, 0, 'com_users', 'component', 'com_users', '', 1, 1, 0, 1, '{\"name\":\"com_users\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_USERS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"users\"}', '{\"allowUserRegistration\":\"1\",\"new_usertype\":\"2\",\"guest_usergroup\":\"13\",\"sendpassword\":\"1\",\"useractivation\":\"1\",\"mail_to_admin\":\"0\",\"captcha\":\"\",\"frontend_userparams\":\"1\",\"site_language\":\"0\",\"change_login_name\":\"0\",\"reset_count\":\"10\",\"reset_time\":\"1\",\"mailSubjectPrefix\":\"\",\"mailBodySuffix\":\"\",\"save_history\":\"1\",\"history_limit\":5}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(27, 0, 'com_finder', 'component', 'com_finder', '', 1, 1, 0, 0, '{\"name\":\"com_finder\",\"type\":\"component\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"finder\"}', '{\"show_description\":\"1\",\"description_length\":255,\"allow_empty_query\":\"0\",\"show_url\":\"1\",\"show_advanced\":\"1\",\"expand_advanced\":\"0\",\"show_date_filters\":\"0\",\"highlight_terms\":\"1\",\"opensearch_name\":\"\",\"opensearch_description\":\"\",\"batch_size\":\"50\",\"memory_table_limit\":30000,\"title_multiplier\":\"1.7\",\"text_multiplier\":\"0.7\",\"meta_multiplier\":\"1.2\",\"path_multiplier\":\"2.0\",\"misc_multiplier\":\"0.3\",\"stemmer\":\"snowball\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(28, 0, 'com_joomlaupdate', 'component', 'com_joomlaupdate', '', 1, 1, 0, 1, '{\"name\":\"com_joomlaupdate\",\"type\":\"component\",\"creationDate\":\"February 2012\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.2\",\"description\":\"COM_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(29, 0, 'com_tags', 'component', 'com_tags', '', 1, 1, 1, 1, '{\"name\":\"com_tags\",\"type\":\"component\",\"creationDate\":\"December 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"COM_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tags\"}', '{\"tag_layout\":\"_:default\",\"save_history\":\"1\",\"history_limit\":5,\"show_tag_title\":\"0\",\"tag_list_show_tag_image\":\"0\",\"tag_list_show_tag_description\":\"0\",\"tag_list_image\":\"\",\"show_tag_num_items\":\"0\",\"tag_list_orderby\":\"title\",\"tag_list_orderby_direction\":\"ASC\",\"show_headings\":\"0\",\"tag_list_show_date\":\"0\",\"tag_list_show_item_image\":\"0\",\"tag_list_show_item_description\":\"0\",\"tag_list_item_maximum_characters\":0,\"return_any_or_all\":\"1\",\"include_children\":\"0\",\"maximum\":200,\"tag_list_language_filter\":\"all\",\"tags_layout\":\"_:default\",\"all_tags_orderby\":\"title\",\"all_tags_orderby_direction\":\"ASC\",\"all_tags_show_tag_image\":\"0\",\"all_tags_show_tag_descripion\":\"0\",\"all_tags_tag_maximum_characters\":20,\"all_tags_show_tag_hits\":\"0\",\"filter_field\":\"1\",\"show_pagination_limit\":\"1\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"tag_field_ajax_mode\":\"1\",\"show_feed_link\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(30, 0, 'com_contenthistory', 'component', 'com_contenthistory', '', 1, 1, 1, 0, '{\"name\":\"com_contenthistory\",\"type\":\"component\",\"creationDate\":\"May 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"COM_CONTENTHISTORY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contenthistory\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(31, 0, 'com_ajax', 'component', 'com_ajax', '', 1, 1, 1, 1, '{\"name\":\"com_ajax\",\"type\":\"component\",\"creationDate\":\"August 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"COM_AJAX_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"ajax\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(32, 0, 'com_postinstall', 'component', 'com_postinstall', '', 1, 1, 1, 1, '{\"name\":\"com_postinstall\",\"type\":\"component\",\"creationDate\":\"September 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"COM_POSTINSTALL_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(33, 0, 'com_fields', 'component', 'com_fields', '', 1, 1, 1, 0, '{\"name\":\"com_fields\",\"type\":\"component\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"COM_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fields\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(34, 0, 'com_associations', 'component', 'com_associations', '', 1, 1, 1, 0, '{\"name\":\"com_associations\",\"type\":\"component\",\"creationDate\":\"Januar 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"COM_ASSOCIATIONS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(102, 0, 'LIB_PHPUTF8', 'library', 'phputf8', '', 0, 1, 1, 1, '{\"name\":\"LIB_PHPUTF8\",\"type\":\"library\",\"creationDate\":\"2006\",\"author\":\"Harry Fuecks\",\"copyright\":\"Copyright various authors\",\"authorEmail\":\"hfuecks@gmail.com\",\"authorUrl\":\"http:\\/\\/sourceforge.net\\/projects\\/phputf8\",\"version\":\"0.5\",\"description\":\"LIB_PHPUTF8_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"phputf8\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(103, 0, 'LIB_JOOMLA', 'library', 'joomla', '', 0, 1, 1, 1, '{\"name\":\"LIB_JOOMLA\",\"type\":\"library\",\"creationDate\":\"2008\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"https:\\/\\/www.joomla.org\",\"version\":\"13.1\",\"description\":\"LIB_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '{\"mediaversion\":\"34f7f08f0e99ce71dc60f2e603b7f9e9\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(104, 0, 'LIB_IDNA', 'library', 'idna_convert', '', 0, 1, 1, 1, '{\"name\":\"LIB_IDNA\",\"type\":\"library\",\"creationDate\":\"2004\",\"author\":\"phlyLabs\",\"copyright\":\"2004-2011 phlyLabs Berlin, http:\\/\\/phlylabs.de\",\"authorEmail\":\"phlymail@phlylabs.de\",\"authorUrl\":\"http:\\/\\/phlylabs.de\",\"version\":\"0.8.0\",\"description\":\"LIB_IDNA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"idna_convert\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(105, 0, 'FOF', 'library', 'fof', '', 0, 1, 1, 1, '{\"name\":\"FOF\",\"type\":\"library\",\"creationDate\":\"2015-04-22 13:15:32\",\"author\":\"Nicholas K. Dionysopoulos \\/ Akeeba Ltd\",\"copyright\":\"(C)2011-2015 Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@akeebabackup.com\",\"authorUrl\":\"https:\\/\\/www.akeebabackup.com\",\"version\":\"2.4.3\",\"description\":\"LIB_FOF_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fof\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(106, 0, 'LIB_PHPASS', 'library', 'phpass', '', 0, 1, 1, 1, '{\"name\":\"LIB_PHPASS\",\"type\":\"library\",\"creationDate\":\"2004-2006\",\"author\":\"Solar Designer\",\"copyright\":\"\",\"authorEmail\":\"solar@openwall.com\",\"authorUrl\":\"http:\\/\\/www.openwall.com\\/phpass\\/\",\"version\":\"0.3\",\"description\":\"LIB_PHPASS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"phpass\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(200, 0, 'mod_articles_archive', 'module', 'mod_articles_archive', '', 0, 1, 1, 0, '{\"name\":\"mod_articles_archive\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_ARCHIVE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_archive\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(201, 0, 'mod_articles_latest', 'module', 'mod_articles_latest', '', 0, 1, 1, 0, '{\"name\":\"mod_articles_latest\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LATEST_NEWS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_latest\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(202, 0, 'mod_articles_popular', 'module', 'mod_articles_popular', '', 0, 1, 1, 0, '{\"name\":\"mod_articles_popular\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_popular\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(203, 0, 'mod_banners', 'module', 'mod_banners', '', 0, 1, 1, 0, '{\"name\":\"mod_banners\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_banners\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(204, 0, 'mod_breadcrumbs', 'module', 'mod_breadcrumbs', '', 0, 1, 1, 1, '{\"name\":\"mod_breadcrumbs\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_BREADCRUMBS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_breadcrumbs\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(205, 0, 'mod_custom', 'module', 'mod_custom', '', 0, 1, 1, 1, '{\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_custom\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(206, 0, 'mod_feed', 'module', 'mod_feed', '', 0, 1, 1, 0, '{\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"July 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_feed\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(207, 0, 'mod_footer', 'module', 'mod_footer', '', 0, 1, 1, 0, '{\"name\":\"mod_footer\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FOOTER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_footer\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(208, 0, 'mod_login', 'module', 'mod_login', '', 0, 1, 1, 1, '{\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_login\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(209, 0, 'mod_menu', 'module', 'mod_menu', '', 0, 1, 1, 1, '{\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_menu\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(210, 0, 'mod_articles_news', 'module', 'mod_articles_news', '', 0, 1, 1, 0, '{\"name\":\"mod_articles_news\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_NEWS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_news\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(211, 0, 'mod_random_image', 'module', 'mod_random_image', '', 0, 1, 1, 0, '{\"name\":\"mod_random_image\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_RANDOM_IMAGE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_random_image\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(212, 0, 'mod_related_items', 'module', 'mod_related_items', '', 0, 1, 1, 0, '{\"name\":\"mod_related_items\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_RELATED_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_related_items\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(213, 0, 'mod_search', 'module', 'mod_search', '', 0, 1, 1, 0, '{\"name\":\"mod_search\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SEARCH_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_search\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(214, 0, 'mod_stats', 'module', 'mod_stats', '', 0, 1, 1, 0, '{\"name\":\"mod_stats\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_stats\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(215, 0, 'mod_syndicate', 'module', 'mod_syndicate', '', 0, 1, 1, 1, '{\"name\":\"mod_syndicate\",\"type\":\"module\",\"creationDate\":\"May 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SYNDICATE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_syndicate\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(216, 0, 'mod_users_latest', 'module', 'mod_users_latest', '', 0, 1, 1, 0, '{\"name\":\"mod_users_latest\",\"type\":\"module\",\"creationDate\":\"December 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_USERS_LATEST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_users_latest\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(218, 0, 'mod_whosonline', 'module', 'mod_whosonline', '', 0, 1, 1, 0, '{\"name\":\"mod_whosonline\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_WHOSONLINE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_whosonline\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(219, 0, 'mod_wrapper', 'module', 'mod_wrapper', '', 0, 1, 1, 0, '{\"name\":\"mod_wrapper\",\"type\":\"module\",\"creationDate\":\"October 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_WRAPPER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_wrapper\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(220, 0, 'mod_articles_category', 'module', 'mod_articles_category', '', 0, 1, 1, 0, '{\"name\":\"mod_articles_category\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_CATEGORY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_category\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(221, 0, 'mod_articles_categories', 'module', 'mod_articles_categories', '', 0, 1, 1, 0, '{\"name\":\"mod_articles_categories\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_categories\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(222, 0, 'mod_languages', 'module', 'mod_languages', '', 0, 1, 1, 1, '{\"name\":\"mod_languages\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"MOD_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_languages\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(223, 0, 'mod_finder', 'module', 'mod_finder', '', 0, 1, 0, 0, '{\"name\":\"mod_finder\",\"type\":\"module\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_finder\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(300, 0, 'mod_custom', 'module', 'mod_custom', '', 1, 1, 1, 1, '{\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_custom\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(301, 0, 'mod_feed', 'module', 'mod_feed', '', 1, 1, 1, 0, '{\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"July 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_feed\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(302, 0, 'mod_latest', 'module', 'mod_latest', '', 1, 1, 1, 0, '{\"name\":\"mod_latest\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LATEST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_latest\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(303, 0, 'mod_logged', 'module', 'mod_logged', '', 1, 1, 1, 0, '{\"name\":\"mod_logged\",\"type\":\"module\",\"creationDate\":\"January 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGGED_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_logged\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(304, 0, 'mod_login', 'module', 'mod_login', '', 1, 1, 1, 1, '{\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"March 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_login\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(305, 0, 'mod_menu', 'module', 'mod_menu', '', 1, 1, 1, 0, '{\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"March 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_menu\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(307, 0, 'mod_popular', 'module', 'mod_popular', '', 1, 1, 1, 0, '{\"name\":\"mod_popular\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_popular\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(308, 0, 'mod_quickicon', 'module', 'mod_quickicon', '', 1, 1, 1, 1, '{\"name\":\"mod_quickicon\",\"type\":\"module\",\"creationDate\":\"Nov 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_QUICKICON_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_quickicon\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(309, 0, 'mod_status', 'module', 'mod_status', '', 1, 1, 1, 0, '{\"name\":\"mod_status\",\"type\":\"module\",\"creationDate\":\"Feb 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATUS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_status\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(310, 0, 'mod_submenu', 'module', 'mod_submenu', '', 1, 1, 1, 0, '{\"name\":\"mod_submenu\",\"type\":\"module\",\"creationDate\":\"Feb 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SUBMENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_submenu\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(311, 0, 'mod_title', 'module', 'mod_title', '', 1, 1, 1, 0, '{\"name\":\"mod_title\",\"type\":\"module\",\"creationDate\":\"Nov 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_TITLE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_title\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(312, 0, 'mod_toolbar', 'module', 'mod_toolbar', '', 1, 1, 1, 1, '{\"name\":\"mod_toolbar\",\"type\":\"module\",\"creationDate\":\"Nov 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_TOOLBAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_toolbar\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(313, 0, 'mod_multilangstatus', 'module', 'mod_multilangstatus', '', 1, 1, 1, 0, '{\"name\":\"mod_multilangstatus\",\"type\":\"module\",\"creationDate\":\"September 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MULTILANGSTATUS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_multilangstatus\"}', '{\"cache\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(314, 0, 'mod_version', 'module', 'mod_version', '', 1, 1, 1, 0, '{\"name\":\"mod_version\",\"type\":\"module\",\"creationDate\":\"January 2012\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_VERSION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_version\"}', '{\"format\":\"short\",\"product\":\"1\",\"cache\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(315, 0, 'mod_stats_admin', 'module', 'mod_stats_admin', '', 1, 1, 1, 0, '{\"name\":\"mod_stats_admin\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_stats_admin\"}', '{\"serverinfo\":\"0\",\"siteinfo\":\"0\",\"counter\":\"0\",\"increase\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(316, 0, 'mod_tags_popular', 'module', 'mod_tags_popular', '', 0, 1, 1, 0, '{\"name\":\"mod_tags_popular\",\"type\":\"module\",\"creationDate\":\"January 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"MOD_TAGS_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_tags_popular\"}', '{\"maximum\":\"5\",\"timeframe\":\"alltime\",\"owncache\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(317, 0, 'mod_tags_similar', 'module', 'mod_tags_similar', '', 0, 1, 1, 0, '{\"name\":\"mod_tags_similar\",\"type\":\"module\",\"creationDate\":\"January 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"MOD_TAGS_SIMILAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_tags_similar\"}', '{\"maximum\":\"5\",\"matchtype\":\"any\",\"owncache\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(318, 0, 'mod_sampledata', 'module', 'mod_sampledata', '', 1, 0, 1, 0, '{\"name\":\"mod_sampledata\",\"type\":\"module\",\"creationDate\":\"July 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.0\",\"description\":\"MOD_SAMPLEDATA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_sampledata\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(400, 0, 'plg_authentication_gmail', 'plugin', 'gmail', 'authentication', 0, 0, 1, 0, '{\"name\":\"plg_authentication_gmail\",\"type\":\"plugin\",\"creationDate\":\"February 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_GMAIL_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"gmail\"}', '{\"applysuffix\":\"0\",\"suffix\":\"\",\"verifypeer\":\"1\",\"user_blacklist\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(401, 0, 'plg_authentication_joomla', 'plugin', 'joomla', 'authentication', 0, 1, 1, 1, '{\"name\":\"plg_authentication_joomla\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_AUTH_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(402, 0, 'plg_authentication_ldap', 'plugin', 'ldap', 'authentication', 0, 0, 1, 0, '{\"name\":\"plg_authentication_ldap\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LDAP_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"ldap\"}', '{\"host\":\"\",\"port\":\"389\",\"use_ldapV3\":\"0\",\"negotiate_tls\":\"0\",\"no_referrals\":\"0\",\"auth_method\":\"bind\",\"base_dn\":\"\",\"search_string\":\"\",\"users_dn\":\"\",\"username\":\"admin\",\"password\":\"bobby7\",\"ldap_fullname\":\"fullName\",\"ldap_email\":\"mail\",\"ldap_uid\":\"uid\"}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(403, 0, 'plg_content_contact', 'plugin', 'contact', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_contact\",\"type\":\"plugin\",\"creationDate\":\"January 2014\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.2\",\"description\":\"PLG_CONTENT_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contact\"}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(404, 0, 'plg_content_emailcloak', 'plugin', 'emailcloak', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_emailcloak\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_EMAILCLOAK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"emailcloak\"}', '{\"mode\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 1, 0);
INSERT INTO `#__extensions` (`extension_id`, `package_id`, `name`, `type`, `element`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `system_data`, `checked_out`, `checked_out_time`, `ordering`, `state`) VALUES
(406, 0, 'plg_content_loadmodule', 'plugin', 'loadmodule', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_loadmodule\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LOADMODULE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"loadmodule\"}', '{\"style\":\"xhtml\"}', '', '', 0, '2011-09-18 15:22:50', 0, 0),
(407, 0, 'plg_content_pagebreak', 'plugin', 'pagebreak', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"pagebreak\"}', '{\"title\":\"1\",\"multipage_toc\":\"1\",\"showall\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(408, 0, 'plg_content_pagenavigation', 'plugin', 'pagenavigation', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_pagenavigation\",\"type\":\"plugin\",\"creationDate\":\"January 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_PAGENAVIGATION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"pagenavigation\"}', '{\"position\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(409, 0, 'plg_content_vote', 'plugin', 'vote', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_vote\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_VOTE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"vote\"}', '', '', '', 0, '0000-00-00 00:00:00', 6, 0),
(410, 0, 'plg_editors_codemirror', 'plugin', 'codemirror', 'editors', 0, 1, 1, 1, '{\"name\":\"plg_editors_codemirror\",\"type\":\"plugin\",\"creationDate\":\"28 March 2011\",\"author\":\"Marijn Haverbeke\",\"copyright\":\"Copyright (C) 2014 - 2017 by Marijn Haverbeke <marijnh@gmail.com> and others\",\"authorEmail\":\"marijnh@gmail.com\",\"authorUrl\":\"http:\\/\\/codemirror.net\\/\",\"version\":\"5.34.0\",\"description\":\"PLG_CODEMIRROR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"codemirror\"}', '{\"lineNumbers\":\"1\",\"lineWrapping\":\"1\",\"matchTags\":\"1\",\"matchBrackets\":\"1\",\"marker-gutter\":\"1\",\"autoCloseTags\":\"1\",\"autoCloseBrackets\":\"1\",\"autoFocus\":\"1\",\"theme\":\"default\",\"tabmode\":\"indent\"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(411, 0, 'plg_editors_none', 'plugin', 'none', 'editors', 0, 1, 1, 1, '{\"name\":\"plg_editors_none\",\"type\":\"plugin\",\"creationDate\":\"September 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_NONE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"none\"}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(412, 0, 'plg_editors_tinymce', 'plugin', 'tinymce', 'editors', 0, 1, 1, 0, '{\"name\":\"plg_editors_tinymce\",\"type\":\"plugin\",\"creationDate\":\"2005-2017\",\"author\":\"Ephox Corporation\",\"copyright\":\"Ephox Corporation\",\"authorEmail\":\"N\\/A\",\"authorUrl\":\"http:\\/\\/www.tinymce.com\",\"version\":\"4.5.8\",\"description\":\"PLG_TINY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tinymce\"}', '{\"mode\":\"1\",\"skin\":\"0\",\"mobile\":\"0\",\"entity_encoding\":\"raw\",\"lang_mode\":\"1\",\"text_direction\":\"ltr\",\"content_css\":\"1\",\"content_css_custom\":\"\",\"relative_urls\":\"1\",\"newlines\":\"0\",\"invalid_elements\":\"script,applet,iframe\",\"extended_elements\":\"\",\"html_height\":\"550\",\"html_width\":\"750\",\"resizing\":\"1\",\"element_path\":\"1\",\"fonts\":\"1\",\"paste\":\"1\",\"searchreplace\":\"1\",\"insertdate\":\"1\",\"colors\":\"1\",\"table\":\"1\",\"smilies\":\"1\",\"hr\":\"1\",\"link\":\"1\",\"media\":\"1\",\"print\":\"1\",\"directionality\":\"1\",\"fullscreen\":\"1\",\"alignment\":\"1\",\"visualchars\":\"1\",\"visualblocks\":\"1\",\"nonbreaking\":\"1\",\"template\":\"1\",\"blockquote\":\"1\",\"wordcount\":\"1\",\"advlist\":\"1\",\"autosave\":\"1\",\"contextmenu\":\"1\",\"inlinepopups\":\"1\",\"custom_plugin\":\"\",\"custom_button\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(413, 0, 'plg_editors-xtd_article', 'plugin', 'article', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_article\",\"type\":\"plugin\",\"creationDate\":\"October 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_ARTICLE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"article\"}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(414, 0, 'plg_editors-xtd_image', 'plugin', 'image', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_image\",\"type\":\"plugin\",\"creationDate\":\"August 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_IMAGE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"image\"}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(415, 0, 'plg_editors-xtd_pagebreak', 'plugin', 'pagebreak', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"August 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_EDITORSXTD_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"pagebreak\"}', '', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(416, 0, 'plg_editors-xtd_readmore', 'plugin', 'readmore', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_readmore\",\"type\":\"plugin\",\"creationDate\":\"March 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_READMORE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"readmore\"}', '', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(417, 0, 'plg_search_categories', 'plugin', 'categories', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_categories\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"categories\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(418, 0, 'plg_search_contacts', 'plugin', 'contacts', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_contacts\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_CONTACTS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contacts\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(419, 0, 'plg_search_content', 'plugin', 'content', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_content\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"content\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(420, 0, 'plg_search_newsfeeds', 'plugin', 'newsfeeds', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"newsfeeds\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(422, 0, 'plg_system_languagefilter', 'plugin', 'languagefilter', 'system', 0, 0, 1, 1, '{\"name\":\"plg_system_languagefilter\",\"type\":\"plugin\",\"creationDate\":\"July 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LANGUAGEFILTER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"languagefilter\"}', '{\"detect_browser\":\"0\",\"automatic_change\":\"1\",\"item_associations\":\"1\",\"remove_default_prefix\":\"0\",\"lang_cookie\":\"0\",\"alternate_meta\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(423, 0, 'plg_system_p3p', 'plugin', 'p3p', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_p3p\",\"type\":\"plugin\",\"creationDate\":\"September 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_P3P_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"p3p\"}', '{\"headers\":\"NOI ADM DEV PSAi COM NAV OUR OTRo STP IND DEM\"}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(424, 0, 'plg_system_cache', 'plugin', 'cache', 'system', 0, 0, 1, 1, '{\"name\":\"plg_system_cache\",\"type\":\"plugin\",\"creationDate\":\"February 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CACHE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"cache\"}', '{\"browsercache\":\"0\",\"cachetime\":\"15\"}', '', '', 0, '0000-00-00 00:00:00', 9, 0),
(425, 0, 'plg_system_debug', 'plugin', 'debug', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_debug\",\"type\":\"plugin\",\"creationDate\":\"December 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_DEBUG_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"debug\"}', '{\"profile\":\"1\",\"queries\":\"1\",\"memory\":\"1\",\"language_files\":\"1\",\"language_strings\":\"1\",\"strip-first\":\"1\",\"strip-prefix\":\"\",\"strip-suffix\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(426, 0, 'plg_system_log', 'plugin', 'log', 'system', 0, 1, 1, 1, '{\"name\":\"plg_system_log\",\"type\":\"plugin\",\"creationDate\":\"April 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LOG_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"log\"}', '', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(427, 0, 'plg_system_redirect', 'plugin', 'redirect', 'system', 0, 0, 1, 1, '{\"name\":\"plg_system_redirect\",\"type\":\"plugin\",\"creationDate\":\"April 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_REDIRECT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"redirect\"}', '', '', '', 0, '0000-00-00 00:00:00', 6, 0),
(428, 0, 'plg_system_remember', 'plugin', 'remember', 'system', 0, 1, 1, 1, '{\"name\":\"plg_system_remember\",\"type\":\"plugin\",\"creationDate\":\"April 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_REMEMBER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"remember\"}', '', '', '', 0, '0000-00-00 00:00:00', 7, 0),
(429, 0, 'plg_system_sef', 'plugin', 'sef', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_sef\",\"type\":\"plugin\",\"creationDate\":\"December 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEF_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"sef\"}', '', '', '', 0, '0000-00-00 00:00:00', 8, 0),
(430, 0, 'plg_system_logout', 'plugin', 'logout', 'system', 0, 1, 1, 1, '{\"name\":\"plg_system_logout\",\"type\":\"plugin\",\"creationDate\":\"April 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LOGOUT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"logout\"}', '', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(431, 0, 'plg_user_contactcreator', 'plugin', 'contactcreator', 'user', 0, 0, 1, 0, '{\"name\":\"plg_user_contactcreator\",\"type\":\"plugin\",\"creationDate\":\"August 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTACTCREATOR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contactcreator\"}', '{\"autowebpage\":\"\",\"category\":\"34\",\"autopublish\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(432, 0, 'plg_user_joomla', 'plugin', 'joomla', 'user', 0, 1, 1, 0, '{\"name\":\"plg_user_joomla\",\"type\":\"plugin\",\"creationDate\":\"December 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_USER_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '{\"strong_passwords\":\"1\",\"autoregister\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(433, 0, 'plg_user_profile', 'plugin', 'profile', 'user', 0, 0, 1, 0, '{\"name\":\"plg_user_profile\",\"type\":\"plugin\",\"creationDate\":\"January 2008\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_USER_PROFILE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"profile\"}', '{\"register-require_address1\":\"1\",\"register-require_address2\":\"1\",\"register-require_city\":\"1\",\"register-require_region\":\"1\",\"register-require_country\":\"1\",\"register-require_postal_code\":\"1\",\"register-require_phone\":\"1\",\"register-require_website\":\"1\",\"register-require_favoritebook\":\"1\",\"register-require_aboutme\":\"1\",\"register-require_tos\":\"1\",\"register-require_dob\":\"1\",\"profile-require_address1\":\"1\",\"profile-require_address2\":\"1\",\"profile-require_city\":\"1\",\"profile-require_region\":\"1\",\"profile-require_country\":\"1\",\"profile-require_postal_code\":\"1\",\"profile-require_phone\":\"1\",\"profile-require_website\":\"1\",\"profile-require_favoritebook\":\"1\",\"profile-require_aboutme\":\"1\",\"profile-require_tos\":\"1\",\"profile-require_dob\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(434, 0, 'plg_extension_joomla', 'plugin', 'joomla', 'extension', 0, 1, 1, 1, '{\"name\":\"plg_extension_joomla\",\"type\":\"plugin\",\"creationDate\":\"May 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_EXTENSION_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(435, 0, 'plg_content_joomla', 'plugin', 'joomla', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_joomla\",\"type\":\"plugin\",\"creationDate\":\"November 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(436, 0, 'plg_system_languagecode', 'plugin', 'languagecode', 'system', 0, 0, 1, 0, '{\"name\":\"plg_system_languagecode\",\"type\":\"plugin\",\"creationDate\":\"November 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LANGUAGECODE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"languagecode\"}', '{\"ar-aa\":\"\",\"en-gb\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 10, 0),
(437, 0, 'plg_quickicon_joomlaupdate', 'plugin', 'joomlaupdate', 'quickicon', 0, 1, 1, 1, '{\"name\":\"plg_quickicon_joomlaupdate\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_QUICKICON_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomlaupdate\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(438, 0, 'plg_quickicon_extensionupdate', 'plugin', 'extensionupdate', 'quickicon', 0, 1, 1, 1, '{\"name\":\"plg_quickicon_extensionupdate\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_QUICKICON_EXTENSIONUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"extensionupdate\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(439, 0, 'plg_captcha_recaptcha', 'plugin', 'recaptcha', 'captcha', 0, 0, 1, 0, '{\"name\":\"plg_captcha_recaptcha\",\"type\":\"plugin\",\"creationDate\":\"December 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.4.0\",\"description\":\"PLG_CAPTCHA_RECAPTCHA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"recaptcha\"}', '{\"public_key\":\"\",\"private_key\":\"\",\"theme\":\"clean\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(440, 0, 'plg_system_highlight', 'plugin', 'highlight', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_highlight\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_HIGHLIGHT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"highlight\"}', '', '', '', 0, '0000-00-00 00:00:00', 7, 0),
(441, 0, 'plg_content_finder', 'plugin', 'finder', 'content', 0, 0, 1, 0, '{\"name\":\"plg_content_finder\",\"type\":\"plugin\",\"creationDate\":\"December 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"finder\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(442, 0, 'plg_finder_categories', 'plugin', 'categories', 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_categories\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"categories\"}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(443, 0, 'plg_finder_contacts', 'plugin', 'contacts', 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_contacts\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CONTACTS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contacts\"}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(444, 0, 'plg_finder_content', 'plugin', 'content', 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_content\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"content\"}', '', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(445, 0, 'plg_finder_newsfeeds', 'plugin', 'newsfeeds', 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"newsfeeds\"}', '', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(447, 0, 'plg_finder_tags', 'plugin', 'tags', 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_tags\",\"type\":\"plugin\",\"creationDate\":\"February 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tags\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(448, 0, 'plg_twofactorauth_totp', 'plugin', 'totp', 'twofactorauth', 0, 0, 1, 0, '{\"name\":\"plg_twofactorauth_totp\",\"type\":\"plugin\",\"creationDate\":\"August 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"PLG_TWOFACTORAUTH_TOTP_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"totp\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(449, 0, 'plg_authentication_cookie', 'plugin', 'cookie', 'authentication', 0, 1, 1, 0, '{\"name\":\"plg_authentication_cookie\",\"type\":\"plugin\",\"creationDate\":\"July 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_AUTH_COOKIE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"cookie\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(450, 0, 'plg_twofactorauth_yubikey', 'plugin', 'yubikey', 'twofactorauth', 0, 0, 1, 0, '{\"name\":\"plg_twofactorauth_yubikey\",\"type\":\"plugin\",\"creationDate\":\"September 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"PLG_TWOFACTORAUTH_YUBIKEY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"yubikey\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(451, 0, 'plg_search_tags', 'plugin', 'tags', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_tags\",\"type\":\"plugin\",\"creationDate\":\"March 2014\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tags\"}', '{\"search_limit\":\"50\",\"show_tagged_items\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(452, 0, 'plg_system_updatenotification', 'plugin', 'updatenotification', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_updatenotification\",\"type\":\"plugin\",\"creationDate\":\"May 2015\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_SYSTEM_UPDATENOTIFICATION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"updatenotification\"}', '{\"lastrun\":1519620383}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(453, 0, 'plg_editors-xtd_module', 'plugin', 'module', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_module\",\"type\":\"plugin\",\"creationDate\":\"October 2015\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_MODULE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"module\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(454, 0, 'plg_system_stats', 'plugin', 'stats', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_stats\",\"type\":\"plugin\",\"creationDate\":\"November 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_SYSTEM_STATS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"stats\"}', '{\"mode\":1,\"lastrun\":1519620457,\"unique_id\":\"c1ea66ec531d513dd29f29b245d74394557e28cd\",\"interval\":12}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(455, 0, 'plg_installer_packageinstaller', 'plugin', 'packageinstaller', 'installer', 0, 1, 1, 1, '{\"name\":\"plg_installer_packageinstaller\",\"type\":\"plugin\",\"creationDate\":\"May 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_PACKAGEINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"packageinstaller\"}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(456, 0, 'PLG_INSTALLER_FOLDERINSTALLER', 'plugin', 'folderinstaller', 'installer', 0, 1, 1, 1, '{\"name\":\"PLG_INSTALLER_FOLDERINSTALLER\",\"type\":\"plugin\",\"creationDate\":\"May 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_FOLDERINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"folderinstaller\"}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(457, 0, 'PLG_INSTALLER_URLINSTALLER', 'plugin', 'urlinstaller', 'installer', 0, 1, 1, 1, '{\"name\":\"PLG_INSTALLER_URLINSTALLER\",\"type\":\"plugin\",\"creationDate\":\"May 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_URLINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"urlinstaller\"}', '', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(458, 0, 'plg_quickicon_phpversioncheck', 'plugin', 'phpversioncheck', 'quickicon', 0, 1, 1, 1, '{\"name\":\"plg_quickicon_phpversioncheck\",\"type\":\"plugin\",\"creationDate\":\"August 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_QUICKICON_PHPVERSIONCHECK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"phpversioncheck\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(459, 0, 'plg_editors-xtd_menu', 'plugin', 'menu', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_menu\",\"type\":\"plugin\",\"creationDate\":\"August 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"menu\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(460, 0, 'plg_editors-xtd_contact', 'plugin', 'contact', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_contact\",\"type\":\"plugin\",\"creationDate\":\"October 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contact\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(461, 0, 'plg_system_fields', 'plugin', 'fields', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_fields\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_SYSTEM_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fields\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(462, 0, 'plg_fields_calendar', 'plugin', 'calendar', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_calendar\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_CALENDAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"calendar\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(463, 0, 'plg_fields_checkboxes', 'plugin', 'checkboxes', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_checkboxes\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_CHECKBOXES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"checkboxes\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(464, 0, 'plg_fields_color', 'plugin', 'color', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_color\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_COLOR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"color\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(465, 0, 'plg_fields_editor', 'plugin', 'editor', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_editor\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_EDITOR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"editor\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(466, 0, 'plg_fields_imagelist', 'plugin', 'imagelist', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_imagelist\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_IMAGELIST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"imagelist\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(467, 0, 'plg_fields_integer', 'plugin', 'integer', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_integer\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_INTEGER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"integer\"}', '{\"multiple\":\"0\",\"first\":\"1\",\"last\":\"100\",\"step\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(468, 0, 'plg_fields_list', 'plugin', 'list', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_list\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_LIST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"list\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(469, 0, 'plg_fields_media', 'plugin', 'media', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_media\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_MEDIA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"media\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(470, 0, 'plg_fields_radio', 'plugin', 'radio', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_radio\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_RADIO_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"radio\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(471, 0, 'plg_fields_sql', 'plugin', 'sql', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_sql\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_SQL_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"sql\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(472, 0, 'plg_fields_text', 'plugin', 'text', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_text\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_TEXT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"text\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(473, 0, 'plg_fields_textarea', 'plugin', 'textarea', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_textarea\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_TEXTAREA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"textarea\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(474, 0, 'plg_fields_url', 'plugin', 'url', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_url\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_URL_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"url\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(475, 0, 'plg_fields_user', 'plugin', 'user', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_user\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_USER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"user\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(476, 0, 'plg_fields_usergrouplist', 'plugin', 'usergrouplist', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_usergrouplist\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_USERGROUPLIST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"usergrouplist\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(477, 0, 'plg_content_fields', 'plugin', 'fields', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_fields\",\"type\":\"plugin\",\"creationDate\":\"February 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_CONTENT_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fields\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(478, 0, 'plg_editors-xtd_fields', 'plugin', 'fields', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_fields\",\"type\":\"plugin\",\"creationDate\":\"February 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fields\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(479, 0, 'plg_sampledata_blog', 'plugin', 'blog', 'sampledata', 0, 0, 1, 0, '{\"name\":\"plg_sampledata_blog\",\"type\":\"plugin\",\"creationDate\":\"July 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.0\",\"description\":\"PLG_SAMPLEDATA_BLOG_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"blog\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(503, 0, 'beez3', 'template', 'beez3', '', 0, 1, 1, 0, '{\"name\":\"beez3\",\"type\":\"template\",\"creationDate\":\"25 November 2009\",\"author\":\"Angie Radtke\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"a.radtke@derauftritt.de\",\"authorUrl\":\"http:\\/\\/www.der-auftritt.de\",\"version\":\"3.1.0\",\"description\":\"TPL_BEEZ3_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"templateDetails\"}', '{\"wrapperSmall\":\"53\",\"wrapperLarge\":\"72\",\"sitetitle\":\"\",\"sitedescription\":\"\",\"navposition\":\"center\",\"templatecolor\":\"nature\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(504, 0, 'hathor', 'template', 'hathor', '', 1, 1, 1, 0, '{\"name\":\"hathor\",\"type\":\"template\",\"creationDate\":\"May 2010\",\"author\":\"Andrea Tarr\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"3.0.0\",\"description\":\"TPL_HATHOR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"templateDetails\"}', '{\"showSiteName\":\"0\",\"colourChoice\":\"0\",\"boldText\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(506, 0, 'protostar', 'template', 'protostar', '', 0, 1, 1, 0, '{\"name\":\"protostar\",\"type\":\"template\",\"creationDate\":\"4\\/30\\/2012\",\"author\":\"Kyle Ledbetter\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"TPL_PROTOSTAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"templateDetails\"}', '{\"templateColor\":\"\",\"logoFile\":\"\",\"googleFont\":\"1\",\"googleFontName\":\"Open+Sans\",\"fluidContainer\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(507, 0, 'isis', 'template', 'isis', '', 1, 1, 1, 0, '{\"name\":\"isis\",\"type\":\"template\",\"creationDate\":\"3\\/30\\/2012\",\"author\":\"Kyle Ledbetter\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"TPL_ISIS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"templateDetails\"}', '{\"templateColor\":\"\",\"logoFile\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(600, 802, 'English (en-GB)', 'language', 'en-GB', '', 0, 1, 1, 1, '{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"February 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.5\",\"description\":\"en-GB site language\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(601, 802, 'English (en-GB)', 'language', 'en-GB', '', 1, 1, 1, 1, '{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"February 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.5\",\"description\":\"en-GB administrator language\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(700, 0, 'files_joomla', 'file', 'joomla', '', 0, 1, 1, 1, '{\"name\":\"files_joomla\",\"type\":\"file\",\"creationDate\":\"February 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.5\",\"description\":\"FILES_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(802, 0, 'English (en-GB) Language Pack', 'package', 'pkg_en-GB', '', 0, 1, 1, 1, '{\"name\":\"English (en-GB) Language Pack\",\"type\":\"package\",\"creationDate\":\"February 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.5.1\",\"description\":\"en-GB language pack\",\"group\":\"\",\"filename\":\"pkg_en-GB\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10001, 0, 'Helix3 - Ajax', 'plugin', 'helix3', 'ajax', 0, 1, 1, 0, '{\"name\":\"Helix3 - Ajax\",\"type\":\"plugin\",\"creationDate\":\"Jan 2015\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (C) 2010 - 2017 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"2.5.1\",\"description\":\"Helix3 Framework - Joomla Template Framework by JoomShaper\",\"group\":\"\",\"filename\":\"helix3\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10002, 0, 'System - Helix3 Framework', 'plugin', 'helix3', 'system', 0, 1, 1, 0, '{\"name\":\"System - Helix3 Framework\",\"type\":\"plugin\",\"creationDate\":\"Jan 2015\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (C) 2010 - 2017 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"2.5.1\",\"description\":\"Helix3 Framework - Joomla Template Framework by JoomShaper\",\"group\":\"\",\"filename\":\"helix3\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10004, 0, 'SP Page Builder', 'component', 'com_sppagebuilder', '', 1, 1, 0, 0, '{\"name\":\"SP Page Builder\",\"type\":\"component\",\"creationDate\":\"Sep 2014\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright @ 2010 - 2017 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"http:\\/\\/www.joomshaper.com\",\"version\":\"3.1.1\",\"description\":\"\",\"group\":\"\",\"filename\":\"sppagebuilder\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10005, 0, 'mod_sppagebuilder_icons', 'module', 'mod_sppagebuilder_icons', '', 1, 1, 2, 0, '{\"name\":\"mod_sppagebuilder_icons\",\"type\":\"module\",\"creationDate\":\"August 2014\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2010 - 2016 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.0.2\",\"description\":\"MOD_SPPAGEBUILDER_ICONS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_sppagebuilder_icons\"}', '[]', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10006, 0, 'mod_sppagebuilder_admin_menu', 'module', 'mod_sppagebuilder_admin_menu', '', 1, 1, 2, 0, '{\"name\":\"mod_sppagebuilder_admin_menu\",\"type\":\"module\",\"creationDate\":\"August 2014\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2010 - 2017 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.3\",\"description\":\"MOD_SPPAGEBUILDER_MENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_sppagebuilder_admin_menu\"}', '[]', '', '', 0, '0000-00-00 00:00:00', 0, 0);
INSERT INTO `#__extensions` (`extension_id`, `package_id`, `name`, `type`, `element`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `system_data`, `checked_out`, `checked_out_time`, `ordering`, `state`) VALUES
(10019, 0, 'shaper_tixon', 'template', 'shaper_tixon', '', 0, 1, 1, 0, '{\"name\":\"shaper_tixon\",\"type\":\"template\",\"creationDate\":\"Oct 2015\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (C) 2010 - 2018 JoomShaper.com. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"http:\\/\\/www.joomshaper.com\",\"version\":\"2.2\",\"description\":\"Shaper Tixon - Responsive Multipurpose Joomla Template\",\"group\":\"\",\"filename\":\"templateDetails\"}', '{\"sticky_header\":\"1\",\"boxed_layout\":\"0\",\"logo_type\":\"image\",\"logo_position\":\"logo\",\"body_bg_repeat\":\"inherit\",\"body_bg_size\":\"inherit\",\"body_bg_attachment\":\"inherit\",\"body_bg_position\":\"0 0\",\"enabled_copyright\":\"1\",\"copyright_position\":\"footer1\",\"copyright\":\"\\u00a9 2015 Your Company. All Rights Reserved. Designed By JoomShaper\",\"show_social_icons\":\"1\",\"social_position\":\"top1\",\"enable_contactinfo\":\"1\",\"contact_position\":\"top2\",\"contact_phone\":\"+228 872 4444\",\"contact_email\":\"contact@email.com\",\"comingsoon_mode\":\"0\",\"comingsoon_title\":\"Coming Soon Title\",\"comingsoon_date\":\"5-10-2018\",\"comingsoon_content\":\"Coming soon content\",\"preset\":\"preset1\",\"preset1_bg\":\"#ffffff\",\"preset1_text\":\"#000000\",\"preset1_major\":\"#26aae1\",\"preset2_bg\":\"#ffffff\",\"preset2_text\":\"#000000\",\"preset2_major\":\"#3d449a\",\"preset3_bg\":\"#ffffff\",\"preset3_text\":\"#000000\",\"preset3_major\":\"#2bb673\",\"preset4_bg\":\"#ffffff\",\"preset4_text\":\"#000000\",\"preset4_major\":\"#eb4947\",\"menu\":\"mainmenu\",\"menu_type\":\"mega_offcanvas\",\"menu_animation\":\"menu-fade\",\"enable_body_font\":\"1\",\"body_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontWeight\\\":\\\"300\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"\\\"}\",\"enable_h1_font\":\"1\",\"h1_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontWeight\\\":\\\"800\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"\\\"}\",\"enable_h2_font\":\"1\",\"h2_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontWeight\\\":\\\"600\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"\\\"}\",\"enable_h3_font\":\"1\",\"h3_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontWeight\\\":\\\"regular\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"\\\"}\",\"enable_h4_font\":\"1\",\"h4_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontWeight\\\":\\\"regular\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"\\\"}\",\"enable_h5_font\":\"1\",\"h5_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontWeight\\\":\\\"600\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"\\\"}\",\"enable_h6_font\":\"1\",\"h6_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontWeight\\\":\\\"600\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"\\\"}\",\"enable_navigation_font\":\"0\",\"enable_custom_font\":\"0\",\"compress_css\":\"0\",\"compress_js\":\"0\",\"lessoption\":\"0\",\"show_post_format\":\"1\",\"commenting_engine\":\"disabled\",\"disqus_devmode\":\"0\",\"intensedebate_acc\":\"\",\"fb_width\":\"500\",\"fb_cpp\":\"10\",\"comments_count\":\"0\",\"social_share\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10020, 0, 'plg_search_sppagebuilder', 'plugin', 'sppagebuilder', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_sppagebuilder\",\"type\":\"plugin\",\"creationDate\":\"July 2015\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2015 Open Source Matters. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.3\",\"description\":\"PLG_SEARCH_SPPAGEBUILDER_DESCRIPTION\",\"group\":\"\",\"filename\":\"sppagebuilder\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10021, 0, 'System - SP Page Builder Pro Updater', 'plugin', 'sppagebuilderproupdater', 'system', 0, 1, 1, 0, '{\"name\":\"System - SP Page Builder Pro Updater\",\"type\":\"plugin\",\"creationDate\":\"Jul 2015\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (C) 2010 - 2016 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.1\",\"description\":\"SP Page Builder Pro Updater Plugin\",\"group\":\"\",\"filename\":\"sppagebuilderproupdater\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10022, 0, 'AcyMailing', 'component', 'com_acymailing', '', 1, 1, 0, 0, '{\"name\":\"AcyMailing\",\"type\":\"component\",\"creationDate\":\"February 2018\",\"author\":\"Acyba\",\"copyright\":\"Copyright (C) 2009-2018 ACYBA SAS - All rights reserved.\",\"authorEmail\":\"dev@acyba.com\",\"authorUrl\":\"http:\\/\\/www.acyba.com\",\"version\":\"5.9.1\",\"description\":\"Manage your Mailing lists, Newsletters, e-mail marketing campaigns\",\"group\":\"\",\"filename\":\"acymailing_j3\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10023, 0, 'AcyMailing : trigger Joomla Content plugins', 'plugin', 'contentplugin', 'acymailing', 0, 0, 1, 0, '{\"version\":\"3.7.0\",\"author\":\"Acyba\",\"creationDate\":\"November 2009\"}', '', '', '', 0, '0000-00-00 00:00:00', 15, 0),
(10024, 0, 'AcyMailing Manage text', 'plugin', 'managetext', 'acymailing', 0, 1, 1, 0, '{\"version\":\"1.0.0\",\"author\":\"Acyba\",\"creationDate\":\"October 2010\"}', '', '', '', 0, '0000-00-00 00:00:00', 10, 0),
(10025, 0, 'AcyMailing Tag : Website links', 'plugin', 'online', 'acymailing', 0, 1, 1, 0, '{\"version\":\"3.7.0\",\"author\":\"Acyba\",\"creationDate\":\"September 2009\"}', '', '', '', 0, '0000-00-00 00:00:00', 6, 0),
(10026, 0, 'AcyMailing : share on social networks', 'plugin', 'share', 'acymailing', 0, 1, 1, 0, '{\"version\":\"1.0.0\",\"author\":\"Acyba\",\"creationDate\":\"August 2010\"}', '', '', '', 0, '0000-00-00 00:00:00', 20, 0),
(10027, 0, 'AcyMailing : Statistics Plugin', 'plugin', 'stats', 'acymailing', 0, 1, 1, 0, '{\"version\":\"3.7.0\",\"author\":\"Acyba\",\"creationDate\":\"September 2009\"}', '', '', '', 0, '0000-00-00 00:00:00', 50, 0),
(10028, 0, 'AcyMailing table of contents generator', 'plugin', 'tablecontents', 'acymailing', 0, 1, 1, 0, '{\"version\":\"1.0.0\",\"author\":\"Acyba\",\"creationDate\":\"January 2011\"}', '', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(10029, 0, 'AcyMailing Tag : CB User information', 'plugin', 'tagcbuser', 'acymailing', 0, 0, 1, 0, '{\"version\":\"3.7.1\",\"author\":\"Acyba\",\"creationDate\":\"September 2009\"}', '', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(10030, 0, 'AcyMailing Tag : content insertion', 'plugin', 'tagcontent', 'acymailing', 0, 1, 1, 0, '{\"version\":\"3.7.0\",\"author\":\"Acyba\",\"creationDate\":\"September 2009\"}', '', '', '', 0, '0000-00-00 00:00:00', 11, 0),
(10031, 0, 'AcyMailing Tag : Subscriber information', 'plugin', 'tagsubscriber', 'acymailing', 0, 1, 1, 0, '{\"version\":\"4.9.4\",\"author\":\"Acyba\",\"creationDate\":\"juillet 2015\"}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(10032, 0, 'AcyMailing Tag : Manage the Subscription', 'plugin', 'tagsubscription', 'acymailing', 0, 1, 1, 0, '{\"version\":\"4.9.4\",\"author\":\"Acyba\",\"creationDate\":\"juillet 2015\"}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(10033, 0, 'AcyMailing Tag : Date / Time', 'plugin', 'tagtime', 'acymailing', 0, 1, 1, 0, '{\"version\":\"4.9.4\",\"author\":\"Acyba\",\"creationDate\":\"juillet 2015\"}', '', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(10034, 0, 'AcyMailing Tag : Joomla User Information', 'plugin', 'taguser', 'acymailing', 0, 1, 1, 0, '{\"version\":\"4.9.4\",\"author\":\"Acyba\",\"creationDate\":\"juillet 2015\"}', '', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(10035, 0, 'AcyMailing Template Class Replacer', 'plugin', 'template', 'acymailing', 0, 1, 1, 0, '{\"version\":\"4.9.4\",\"author\":\"Acyba\",\"creationDate\":\"juillet 2015\"}', '', '', '', 0, '0000-00-00 00:00:00', 25, 0),
(10036, 0, 'AcyMailing Editor', 'plugin', 'acyeditor', 'editors', 0, 1, 1, 0, '{\"version\":\"4.9.4\",\"author\":\"Acyba\",\"creationDate\":\"juillet 2015\"}', '', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(10037, 0, 'AcyMailing : (auto)Subscribe during Joomla registration', 'plugin', 'regacymailing', 'system', 0, 1, 1, 0, '{\"version\":\"4.9.4\",\"author\":\"Acyba\",\"creationDate\":\"juillet 2015\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10038, 0, 'AcyMailing Module', 'module', 'mod_acymailing', '', 0, 1, 1, 0, '{\"version\":\"3.7.0\",\"author\":\"Acyba\",\"creationDate\":\"September 2009\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10039, 0, 'SP Flickr Gallery', 'module', 'mod_sp_flickrgallery', '', 0, 1, 0, 0, '{\"name\":\"SP Flickr Gallery\",\"type\":\"module\",\"creationDate\":\"July 2015\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (C) 2010 - 2015 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.0\",\"description\":\"This Module will take photos from flickr by your flickr ID\",\"group\":\"\",\"filename\":\"mod_sp_flickrgallery\"}', '{\"flickr_id\":\"122684712@N04\",\"columns\":\"4\",\"limit\":\"8\",\"layout\":\"default\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10040, 0, 'VIRTUEMART', 'component', 'com_virtuemart', '', 1, 1, 0, 0, '{\"name\":\"VIRTUEMART\",\"type\":\"component\",\"creationDate\":\"December 21 2017\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004-2015 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"max|at|virtuemart.net\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.2.12\",\"description\":\"\",\"group\":\"\",\"filename\":\"virtuemart\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10041, 0, 'VirtueMart_allinone', 'component', 'com_virtuemart_allinone', '', 1, 1, 0, 0, '{\"name\":\"VirtueMart_allinone\",\"type\":\"component\",\"creationDate\":\"December 21 2017\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004-2017 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.2.12\",\"description\":\"\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10042, 0, 'VM Payment - Standard', 'plugin', 'standard', 'vmpayment', 0, 1, 1, 0, '{\"name\":\"Standard\",\"type\":\"plugin\",\"creationDate\":\"December 21 2017\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2017 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.2.12\",\"description\":\"Standard payment plugin\",\"group\":\"\",\"filename\":\"standard\"}', '', '', '', 0, '0000-00-00 00:00:00', 20, 0),
(10043, 0, 'VM Payment - Klarna', 'plugin', 'klarna', 'vmpayment', 0, 0, 1, 0, '{\"name\":\"Klarna\",\"type\":\"plugin\",\"creationDate\":\"December 21 2017\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2017 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.2.12\",\"description\":\"Klarna VirtueMart Payment Plugin\",\"group\":\"\",\"filename\":\"klarna\"}', '', '', '', 0, '0000-00-00 00:00:00', 6, 0),
(10044, 0, 'VM Payment - KlarnaCheckout', 'plugin', 'klarnacheckout', 'vmpayment', 0, 0, 1, 0, '{\"name\":\"Klarna Checkout\",\"type\":\"plugin\",\"creationDate\":\"December 21 2017\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2017 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.2.12\",\"description\":\"\",\"group\":\"\",\"filename\":\"klarnacheckout\"}', '', '', '', 0, '0000-00-00 00:00:00', 20, 0),
(10045, 0, 'VM Payment - Sofort Banking/Überweisung', 'plugin', 'sofort', 'vmpayment', 0, 1, 1, 0, '{\"name\":\"Sofort\",\"type\":\"plugin\",\"creationDate\":\"December 21 2017\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2017 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.2.12\",\"description\":\"<a href=\\\"http:\\/www.sofort.com\\\" target=\\\"_blank\\\">Sofort<\\/a> is a popular\\n\\tpayment provider and available in many countries. \\n    \",\"group\":\"\",\"filename\":\"sofort\"}', '', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(10046, 0, 'VM Payment - PayPal', 'plugin', 'paypal', 'vmpayment', 0, 1, 1, 0, '{\"name\":\"PayPal\",\"type\":\"plugin\",\"creationDate\":\"December 21 2017\",\"author\":\"VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2017 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.2.12\",\"description\":\"PayPal\",\"group\":\"\",\"filename\":\"paypal\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10047, 0, 'VM Payment - Heidelpay', 'plugin', 'heidelpay', 'vmpayment', 0, 0, 1, 0, '{\"name\":\"Heidelpay\",\"type\":\"plugin\",\"creationDate\":\"12-Sep-2012\",\"author\":\"Heidelberger Payment GmbH\",\"copyright\":\"Copyright Heidelberger Payment GmbH\",\"authorEmail\":\"info@heidelpay.de\",\"authorUrl\":\"http:\\/\\/www.heidelpay.de\",\"version\":\"16.11.07\",\"description\":\"\\n        <h2>Virtuemart Plugin von:<\\/h2><p><a href=\\\"http:\\/\\/www.Heidelpay.de\\\" target=\\\"_blank\\\"><img src=\\\"http:\\/\\/www.heidelpay.de\\/gfx\\/logo.gif\\\" style=\\\"margin-right:20px;\\\"\\/><\\/a><\\/p> \",\"group\":\"\",\"filename\":\"heidelpay\"}', '', '', '', 0, '0000-00-00 00:00:00', 8, 0),
(10048, 0, 'VM Payment - Paybox', 'plugin', 'paybox', 'vmpayment', 0, 0, 1, 0, '{\"name\":\"VM Payment - Paybox\",\"type\":\"plugin\",\"creationDate\":\"December 21 2017\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2017 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.2.12\",\"description\":\"<a href=\\\"http:\\/\\/paybox.com\\\" target=\\\"_blank\\\">Paybox<\\/a> \\n    \",\"group\":\"\",\"filename\":\"paybox\"}', '', '', '', 0, '0000-00-00 00:00:00', 7, 0),
(10049, 0, 'VM Payment - Pay with Amazon', 'plugin', 'amazon', 'vmpayment', 0, 0, 1, 0, '{\"name\":\"AMAZON\",\"type\":\"plugin\",\"creationDate\":\"December 21 2017\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2017 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.2.12\",\"description\":\"AMAZON PAY plugin\",\"group\":\"\",\"filename\":\"amazon\"}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(10050, 0, 'System - Pay with Amazon', 'plugin', 'amazon', 'system', 0, 0, 1, 0, '{\"name\":\"AMAZON\",\"type\":\"plugin\",\"creationDate\":\"December 21 2017\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2017 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.2.12\",\"description\":\"AMAZON payment SYSTEM plugin\",\"group\":\"\",\"filename\":\"amazon\"}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(10051, 0, 'VM Payment - Realex HPP & API', 'plugin', 'realex_hpp_api', 'vmpayment', 0, 0, 1, 0, '{\"name\":\"realex_hpp_api\",\"type\":\"plugin\",\"creationDate\":\"December 21 2017\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2017 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.2.12\",\"description\":\"Realex HPP and API\",\"group\":\"\",\"filename\":\"realex_hpp_api\"}', '', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(10052, 0, 'VM UserField - Realex HPP & API', 'plugin', 'realex_hpp_api', 'vmuserfield', 0, 0, 1, 0, '{\"name\":\"Realex_hpp_api\",\"type\":\"plugin\",\"creationDate\":\"December 21 2017\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2017 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.2.12\",\"description\":\"Card storage plugin for Realex\",\"group\":\"\",\"filename\":\"realex_hpp_api\"}', '', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(10053, 0, 'VM Payment - Skrill', 'plugin', 'skrill', 'vmpayment', 0, 0, 1, 0, '{\"name\":\"Skrill\",\"type\":\"plugin\",\"creationDate\":\"December 21 2017\",\"author\":\"Skrill Holdings Limited\",\"copyright\":\"Copyright (C) 2004 - 2017 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"http:\\/\\/www.skrill.com\",\"version\":\"3.2.12\",\"description\":\"<a href=\\\"http:\\/\\/www.skrill.com\\\" target=\\\"_blank\\\">skrill<\\/a> is a popular\\n\\tpayment provider authorised by the Financial Services Authority of the United Kingdom (FSA). \\n    \",\"group\":\"\",\"filename\":\"skrill\"}', '', '', '', 0, '0000-00-00 00:00:00', 9, 0),
(10054, 0, 'VM Payment - Authorize.net', 'plugin', 'authorizenet', 'vmpayment', 0, 0, 1, 0, '{\"name\":\"Authorize.net AIM\",\"type\":\"plugin\",\"creationDate\":\"December 21 2017\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2017 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.2.12\",\"description\":\"Authorize.net AIM\",\"group\":\"\",\"filename\":\"authorizenet\"}', '', '', '', 0, '0000-00-00 00:00:00', 20, 0),
(10055, 0, 'VM Payment - Sofort iDeal', 'plugin', 'sofort_ideal', 'vmpayment', 0, 0, 1, 0, '{\"name\":\"Sofort Ideal\",\"type\":\"plugin\",\"creationDate\":\"December 21 2017\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2017 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.2.12\",\"description\":\"<a href=\\\"http:\\/www.sofort.com\\\" target=\\\"_blank\\\">Sofort<\\/a> is a popular\\n\\tpayment provider and available in many countries. \\n    \",\"group\":\"\",\"filename\":\"sofort\"}', '', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(10056, 0, 'VM Payment - Klikandpay', 'plugin', 'klikandpay', 'vmpayment', 0, 0, 1, 0, '{\"name\":\"VM Payment - klikandpay\",\"type\":\"plugin\",\"creationDate\":\"December 21 2017\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2017 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.2.12\",\"description\":\"<a href=\\\"http:\\/\\/klikandpay.com\\\" target=\\\"_blank\\\">klikandpay<\\/a> \\n    \",\"group\":\"\",\"filename\":\"klikandpay\"}', '', '', '', 0, '0000-00-00 00:00:00', 10, 0),
(10057, 0, 'VM Shipment - By weight, ZIP and countries', 'plugin', 'weight_countries', 'vmshipment', 0, 1, 1, 0, '{\"name\":\"By weight, ZIP and countries\",\"type\":\"plugin\",\"creationDate\":\"December 21 2017\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2017 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.2.12\",\"description\":\"VMSHIPMENT_WEIGHT_COUNTRIES_PLUGIN_DESC\",\"group\":\"\",\"filename\":\"weight_countries\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10058, 0, 'VM Custom - Customer text input', 'plugin', 'textinput', 'vmcustom', 0, 1, 1, 0, '{\"name\":\"VMCustom - textinput\",\"type\":\"plugin\",\"creationDate\":\"December 21 2017\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004-2014 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.2.12\",\"description\":\"text input plugin for product\",\"group\":\"\",\"filename\":\"textinput\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10059, 0, 'VM Custom - Product specification', 'plugin', 'specification', 'vmcustom', 0, 1, 1, 0, '{\"name\":\"plgvm_specification\",\"type\":\"plugin\",\"creationDate\":\"December 21 2017\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004-2014 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.2.12\",\"description\":\"VMCustom - specification; text input plugin for product\",\"group\":\"\",\"filename\":\"specification\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10060, 0, 'VM Calculation - Avalara Tax', 'plugin', 'avalara', 'vmcalculation', 0, 0, 1, 0, '{\"name\":\"VM - Calculation Avalara Tax\",\"type\":\"plugin\",\"creationDate\":\"December 21 2017\",\"author\":\"Max Milbers\",\"copyright\":\"Copyright (C) 2013 iStraxx UG (haftungsbeschr\\u00e4nkt). All rights reserved\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.2.12\",\"description\":\"VM - Calculation Avalara Tax; On demand tax calculation for whole U.S.A.\",\"group\":\"\",\"filename\":\"avalara\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10061, 0, 'VirtueMart Product', 'plugin', 'virtuemart', 'search', 0, 0, 1, 0, '{\"name\":\"Search - VirtueMart\",\"type\":\"plugin\",\"creationDate\":\"December 21 2017\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2017 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.2.12\",\"description\":\"PLG_SEARCH_VIRTUEMART_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"virtuemart\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10062, 0, 'mod_vmmenu', 'module', 'mod_vmmenu', '', 1, 1, 3, 0, '{\"name\":\"VirtueMart Administrator Menu\",\"type\":\"module\",\"creationDate\":\"December 21 2017\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004-2013 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"max|at|virtuemart.net\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.2.12\",\"description\":\"MOD_VMMENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_vmmenu\"}', '', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(10063, 0, 'mod_virtuemart_currencies', 'module', 'mod_virtuemart_currencies', '', 0, 1, 1, 0, '{\"name\":\"mod_virtuemart_currencies\",\"type\":\"module\",\"creationDate\":\"December 21 2017\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2017 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.2.12\",\"description\":\"MOD_VIRTUEMART_CURRENCIES_DESC\",\"group\":\"\",\"filename\":\"mod_virtuemart_currencies\"}', '', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(10064, 0, 'mod_virtuemart_product', 'module', 'mod_virtuemart_product', '', 0, 1, 1, 0, '{\"name\":\"mod_virtuemart_product\",\"type\":\"module\",\"creationDate\":\"December 21 2017\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2017 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.2.12\",\"description\":\"MOD_VIRTUEMART_PRODUCT_DESC\",\"group\":\"\",\"filename\":\"mod_virtuemart_product\"}', '', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(10065, 0, 'mod_virtuemart_search', 'module', 'mod_virtuemart_search', '', 0, 1, 1, 0, '{\"name\":\"mod_virtuemart_search\",\"type\":\"module\",\"creationDate\":\"December 21 2017\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2017 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.2.12\",\"description\":\"MOD_VIRTUEMART_SEARCH_DESC\",\"group\":\"\",\"filename\":\"mod_virtuemart_search\"}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(10066, 0, 'mod_virtuemart_manufacturer', 'module', 'mod_virtuemart_manufacturer', '', 0, 1, 1, 0, '{\"name\":\"mod_virtuemart_manufacturer\",\"type\":\"module\",\"creationDate\":\"December 21 2017\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2017 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.2.12\",\"description\":\"MOD_VIRTUEMART_MANUFACTURER_DESC\",\"group\":\"\",\"filename\":\"mod_virtuemart_manufacturer\"}', '', '', '', 0, '0000-00-00 00:00:00', 8, 0),
(10067, 0, 'mod_virtuemart_cart', 'module', 'mod_virtuemart_cart', '', 0, 1, 1, 0, '{\"name\":\"mod_virtuemart_cart\",\"type\":\"module\",\"creationDate\":\"December 21 2017\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2017 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.2.12\",\"description\":\"MOD_VIRTUEMART_CART_DESC\",\"group\":\"\",\"filename\":\"mod_virtuemart_cart\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10068, 0, 'mod_virtuemart_category', 'module', 'mod_virtuemart_category', '', 0, 1, 1, 0, '{\"name\":\"mod_virtuemart_category\",\"type\":\"module\",\"creationDate\":\"December 21 2017\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2017 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.2.12\",\"description\":\"MOD_VIRTUEMART_CATEGORY_DESC\",\"group\":\"\",\"filename\":\"mod_virtuemart_category\"}', '', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(10069, 0, 'tcpdf', 'component', 'com_tcpdf', '', 1, 1, 0, 0, '{\"name\":\"tcpdf\",\"type\":\"component\",\"creationDate\":\"February 2015\",\"author\":\"Nicola Asuni, The VirtueMart Development Team\",\"copyright\":\"Copyright (c) 2001-2013 Nicola Asuni - Tecnick.com LTD - Tutti i diritti riservati - All Rights Reserved. 2015 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"${PHING.VM.MAINTAINERURL}\",\"version\":\"1.0.4\",\"description\":\"TCPDF 6.2.12 by Nicola Asuni. Joomla Installer by the VirtueMart Team\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10070, 0, 'SP Simple Portfolio', 'component', 'com_spsimpleportfolio', '', 1, 1, 0, 0, '{\"name\":\"SP Simple Portfolio\",\"type\":\"component\",\"creationDate\":\"December 2015\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (c) 2010- 2018 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"http:\\/\\/www.joomshaper.com\",\"version\":\"1.6\",\"description\":\"Simple Portfolio Component for Joomla 3.3+\",\"group\":\"\",\"filename\":\"spsimpleportfolio\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10071, 0, 'SP Simple Portfolio Module', 'module', 'mod_spsimpleportfolio', '', 0, 1, 0, 0, '{\"name\":\"SP Simple Portfolio Module\",\"type\":\"module\",\"creationDate\":\"December 2014\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2010 - 2018 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.6\",\"description\":\"Module to display latest item from SP Simple Portfolio\",\"group\":\"\",\"filename\":\"mod_spsimpleportfolio\"}', '{\"show_filter\":\"1\",\"category_id\":\"\",\"layout_type\":\"default\",\"columns\":\"3\",\"thumbnail_type\":\"masonry\",\"limit\":\"12\",\"cache\":\"1\",\"cache_time\":\"900\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10072, 0, 'VM Payment - 2Checkout', 'plugin', 'tco', 'vmpayment', 0, 0, 1, 0, '{\"name\":\"2Checkout\",\"type\":\"plugin\",\"creationDate\":\"October 2015\",\"author\":\"Craig Christenson\",\"copyright\":\"Copyright (C) 2004-2015 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"http:\\/\\/www.2checkout.com\",\"version\":\"3.2.12\",\"description\":\"<a href=\\\"https:\\/\\/www.2checkout.com\\/referral?r=virtuemart\\\" target=\\\"_blank\\\">2Checkout<\\/a> is a popular payment provider and available in many countries. \\n    \",\"group\":\"\",\"filename\":\"tco\"}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(10073, 0, 'System - SP PageBuilder', 'plugin', 'sppagebuilder', 'system', 0, 1, 1, 0, '{\"name\":\"System - SP PageBuilder\",\"type\":\"plugin\",\"creationDate\":\"Sep 2016\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (C) 2010 - 2016 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.3\",\"description\":\"SP Page Builder System plugin to add support for 3rd party components\",\"group\":\"\",\"filename\":\"sppagebuilder\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10074, 0, 'SP Page Builder', 'module', 'mod_sppagebuilder', '', 0, 1, 0, 0, '{\"name\":\"SP Page Builder\",\"type\":\"module\",\"creationDate\":\"Oct 2016\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2010 - 2016 JoomShaper.com. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.2\",\"description\":\"Module to display content from SP Page Builder\",\"group\":\"\",\"filename\":\"mod_sppagebuilder\"}', '{\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10075, 0, 'plg_installer_webinstaller', 'plugin', 'webinstaller', 'installer', 0, 1, 1, 0, '{\"name\":\"plg_installer_webinstaller\",\"type\":\"plugin\",\"creationDate\":\"28 April 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2013-2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"1.1.1\",\"description\":\"PLG_INSTALLER_WEBINSTALLER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"webinstaller\"}', '{\"tab_position\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10076, 0, 'AcyMailing JCE integration', 'plugin', 'jceacymailing', 'system', 0, 1, 1, 0, '{\"version\":\"5.8.1\",\"author\":\"Acyba\",\"creationDate\":\"septembre 2017\"}', '', '', '', 0, '0000-00-00 00:00:00', 23, 0),
(10077, 0, 'VM Framework Loader during Plugin Updates', 'plugin', 'vmLoaderPluginUpdate', 'system', 0, 1, 1, 0, '{\"name\":\"VM Framework Loader during Plugin Updates\",\"type\":\"plugin\",\"creationDate\":\"2017-08-06\",\"author\":\"Reinhold Kainhofer\",\"copyright\":\"Copyright (C) 2017 Reinhold Kainhofer.\",\"authorEmail\":\"office@open-tools.net\",\"authorUrl\":\"http:\\/\\/www.virtuemart.net\\/\",\"version\":\"1.0\",\"description\":\"Makes sure the VirtueMart framework is loaded during automatic plugin updates using Joomla\'s plugin updater.\",\"group\":\"\",\"filename\":\"vmLoaderPluginUpdate\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__fields`
--

DROP TABLE IF EXISTS `#__fields`;
CREATE TABLE `#__fields` (
  `id` int(10) UNSIGNED NOT NULL,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `context` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `group_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `label` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `default_value` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'text',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `fieldparams` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_user_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `access` int(11) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__fields_categories`
--

DROP TABLE IF EXISTS `#__fields_categories`;
CREATE TABLE `#__fields_categories` (
  `field_id` int(11) NOT NULL DEFAULT '0',
  `category_id` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__fields_groups`
--

DROP TABLE IF EXISTS `#__fields_groups`;
CREATE TABLE `#__fields_groups` (
  `id` int(10) UNSIGNED NOT NULL,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `context` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `access` int(11) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__fields_values`
--

DROP TABLE IF EXISTS `#__fields_values`;
CREATE TABLE `#__fields_values` (
  `field_id` int(10) UNSIGNED NOT NULL,
  `item_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Allow references to items which have strings as ids, eg. none db systems.',
  `value` text COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__languages`
--

DROP TABLE IF EXISTS `#__languages`;
CREATE TABLE `#__languages` (
  `lang_id` int(11) UNSIGNED NOT NULL,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `lang_code` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `title` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title_native` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sef` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL,
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `sitename` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `published` int(11) NOT NULL DEFAULT '0',
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__languages`
--

INSERT INTO `#__languages` (`lang_id`, `asset_id`, `lang_code`, `title`, `title_native`, `sef`, `image`, `description`, `metakey`, `metadesc`, `sitename`, `published`, `access`, `ordering`) VALUES
(1, 0, 'en-GB', 'English (UK)', 'English (UK)', 'en', 'en', '', '', '', '', 1, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `#__menu`
--

DROP TABLE IF EXISTS `#__menu`;
CREATE TABLE `#__menu` (
  `id` int(11) NOT NULL,
  `menutype` varchar(24) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The type of menu this item belongs to. FK to #__menu_types.menutype',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The display title of the menu item.',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL COMMENT 'The SEF alias of the menu item.',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `path` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The computed path of the menu item based on the alias field.',
  `link` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The actually link the menu item refers to.',
  `type` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The type of link: Component, URL, Alias, Separator',
  `published` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'The published state of the menu link.',
  `parent_id` int(10) UNSIGNED NOT NULL DEFAULT '1' COMMENT 'The parent menu item in the menu tree.',
  `level` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'The relative level in the tree.',
  `component_id` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'FK to #__extensions.id',
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'FK to #__users.id',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'The time the menu item was checked out.',
  `browserNav` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'The click behaviour of the link.',
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'The access level required to view the menu item.',
  `img` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The image of the menu item.',
  `template_style_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded data for the menu item.',
  `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `home` tinyint(3) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'Indicates if this menu item is the home or default page.',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` tinyint(4) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__menu`
--

INSERT INTO `#__menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES
(1, '', 'Menu_Item_Root', 'root', '', '', '', '', 1, 0, 0, 0, 0, '0000-00-00 00:00:00', 0, 0, '', 0, '', 0, 455, 0, '*', 0),
(2, 'main', 'com_banners', 'Banners', '', 'Banners', 'index.php?option=com_banners', 'component', 1, 1, 1, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners', 0, '', 1, 10, 0, '*', 1),
(3, 'main', 'com_banners', 'Banners', '', 'Banners/Banners', 'index.php?option=com_banners', 'component', 1, 2, 2, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners', 0, '', 2, 3, 0, '*', 1),
(4, 'main', 'com_banners_categories', 'Categories', '', 'Banners/Categories', 'index.php?option=com_categories&extension=com_banners', 'component', 1, 2, 2, 6, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners-cat', 0, '', 4, 5, 0, '*', 1),
(5, 'main', 'com_banners_clients', 'Clients', '', 'Banners/Clients', 'index.php?option=com_banners&view=clients', 'component', 1, 2, 2, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners-clients', 0, '', 6, 7, 0, '*', 1),
(6, 'main', 'com_banners_tracks', 'Tracks', '', 'Banners/Tracks', 'index.php?option=com_banners&view=tracks', 'component', 1, 2, 2, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners-tracks', 0, '', 8, 9, 0, '*', 1),
(7, 'main', 'com_contact', 'Contacts', '', 'Contacts', 'index.php?option=com_contact', 'component', 1, 1, 1, 8, 0, '0000-00-00 00:00:00', 0, 0, 'class:contact', 0, '', 351, 356, 0, '*', 1),
(8, 'main', 'com_contact_contacts', 'Contacts', '', 'Contacts/Contacts', 'index.php?option=com_contact', 'component', 1, 7, 2, 8, 0, '0000-00-00 00:00:00', 0, 0, 'class:contact', 0, '', 352, 353, 0, '*', 1),
(9, 'main', 'com_contact_categories', 'Categories', '', 'Contacts/Categories', 'index.php?option=com_categories&extension=com_contact', 'component', 1, 7, 2, 6, 0, '0000-00-00 00:00:00', 0, 0, 'class:contact-cat', 0, '', 354, 355, 0, '*', 1),
(10, 'main', 'com_messages', 'Messaging', '', 'Messaging', 'index.php?option=com_messages', 'component', 1, 1, 1, 15, 0, '0000-00-00 00:00:00', 0, 0, 'class:messages', 0, '', 357, 360, 0, '*', 1),
(11, 'main', 'com_messages_add', 'New Private Message', '', 'Messaging/New Private Message', 'index.php?option=com_messages&task=message.add', 'component', 1, 10, 2, 15, 0, '0000-00-00 00:00:00', 0, 0, 'class:messages-add', 0, '', 358, 359, 0, '*', 1),
(13, 'main', 'com_newsfeeds', 'News Feeds', '', 'News Feeds', 'index.php?option=com_newsfeeds', 'component', 1, 1, 1, 17, 0, '0000-00-00 00:00:00', 0, 0, 'class:newsfeeds', 0, '', 361, 366, 0, '*', 1),
(14, 'main', 'com_newsfeeds_feeds', 'Feeds', '', 'News Feeds/Feeds', 'index.php?option=com_newsfeeds', 'component', 1, 13, 2, 17, 0, '0000-00-00 00:00:00', 0, 0, 'class:newsfeeds', 0, '', 362, 363, 0, '*', 1),
(15, 'main', 'com_newsfeeds_categories', 'Categories', '', 'News Feeds/Categories', 'index.php?option=com_categories&extension=com_newsfeeds', 'component', 1, 13, 2, 6, 0, '0000-00-00 00:00:00', 0, 0, 'class:newsfeeds-cat', 0, '', 364, 365, 0, '*', 1),
(16, 'main', 'com_redirect', 'Redirect', '', 'Redirect', 'index.php?option=com_redirect', 'component', 1, 1, 1, 24, 0, '0000-00-00 00:00:00', 0, 0, 'class:redirect', 0, '', 373, 374, 0, '*', 1),
(17, 'main', 'com_search', 'Basic Search', '', 'Basic Search', 'index.php?option=com_search', 'component', 1, 1, 1, 19, 0, '0000-00-00 00:00:00', 0, 0, 'class:search', 0, '', 371, 372, 0, '*', 1),
(21, 'main', 'com_finder', 'Smart Search', '', 'Smart Search', 'index.php?option=com_finder', 'component', 1, 1, 1, 27, 0, '0000-00-00 00:00:00', 0, 0, 'class:finder', 0, '', 369, 370, 0, '*', 1),
(22, 'main', 'com_joomlaupdate', 'Joomla! Update', '', 'Joomla! Update', 'index.php?option=com_joomlaupdate', 'component', 1, 1, 1, 28, 0, '0000-00-00 00:00:00', 0, 0, 'class:joomlaupdate', 0, '', 367, 368, 0, '*', 1),
(201, 'usermenu', 'Your Profile', 'your-profile', '', 'your-profile', 'index.php?option=com_users&view=profile', 'component', 1, 1, 1, 25, 0, '0000-00-00 00:00:00', 0, 2, '', 11, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 375, 376, 0, '*', 0),
(229, 'mainmenu', 'Single Contact', 'single-contact', '', 'joomla/contact-component/single-contact', 'index.php?option=com_contact&view=contact&id=1', 'component', 1, 270, 3, 8, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"presentation_style\":\"\",\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"show_tags\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_links\":\"\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 315, 316, 0, '*', 0),
(251, 'mainmenu', 'Contact Categories', 'contact-categories', '', 'joomla/contact-component/contact-categories', 'index.php?option=com_contact&view=categories&id=16', 'component', 1, 270, 3, 8, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"show_base_description\":\"\",\"categories_description\":\"\",\"maxLevelcat\":\"\",\"show_empty_categories_cat\":\"\",\"show_subcat_desc_cat\":\"\",\"show_cat_items_cat\":\"\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"-1\",\"show_empty_categories\":\"\",\"show_subcat_desc\":\"\",\"show_cat_items\":\"\",\"filter_field\":\"\",\"show_pagination_limit\":\"\",\"show_headings\":\"\",\"show_position_headings\":\"\",\"show_email_headings\":\"\",\"show_telephone_headings\":\"\",\"show_mobile_headings\":\"\",\"show_fax_headings\":\"\",\"show_suburb_headings\":\"\",\"show_state_headings\":\"\",\"show_country_headings\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"presentation_style\":\"sliders\",\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_links\":\"1\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\",\"show_feed_link\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 311, 312, 0, '*', 0),
(252, 'mainmenu', 'News Feed Categories', 'new-feed-categories', '', 'joomla/other-components/news-feeds-component/new-feed-categories', 'index.php?option=com_newsfeeds&view=categories&id=0', 'component', 1, 267, 4, 17, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"show_base_description\":\"\",\"categories_description\":\"\",\"maxLevelcat\":\"\",\"show_empty_categories_cat\":\"\",\"show_subcat_desc_cat\":\"\",\"show_cat_items_cat\":\"\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_subcat_desc\":\"\",\"show_cat_items\":\"\",\"filter_field\":\"\",\"show_pagination_limit\":\"\",\"show_headings\":\"\",\"show_articles\":\"\",\"show_link\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_feed_image\":\"\",\"show_feed_description\":\"\",\"show_item_description\":\"\",\"feed_character_count\":\"0\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 332, 333, 0, '*', 0),
(253, 'mainmenu', 'News Feed Category', 'news-feed-category', '', 'joomla/other-components/news-feeds-component/news-feed-category', 'index.php?option=com_newsfeeds&view=category&id=17', 'component', 1, 267, 4, 17, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"-1\",\"show_empty_categories\":\"\",\"show_subcat_desc\":\"\",\"show_cat_items\":\"\",\"filter_field\":\"\",\"show_pagination_limit\":\"\",\"show_headings\":\"\",\"show_articles\":\"\",\"show_link\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_feed_image\":\"\",\"show_feed_description\":\"\",\"show_item_description\":\"\",\"feed_character_count\":\"0\",\"feed_display_order\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 336, 337, 0, '*', 0),
(254, 'mainmenu', 'Single News Feed', 'single-news-feed', '', 'joomla/other-components/news-feeds-component/single-news-feed', 'index.php?option=com_newsfeeds&view=newsfeed&id=4', 'component', 1, 267, 4, 17, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"show_feed_image\":\"\",\"show_feed_description\":\"\",\"show_item_description\":\"\",\"show_tags\":\"\",\"feed_character_count\":\"0\",\"feed_display_order\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 334, 335, 0, '*', 0),
(255, 'mainmenu', 'Search', 'search', '', 'joomla/other-components/search', 'index.php?option=com_search&view=search', 'component', 1, 268, 3, 19, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"search_areas\":\"1\",\"show_date\":\"1\",\"searchphrase\":\"0\",\"ordering\":\"newest\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 343, 344, 0, '*', 0),
(257, 'mainmenu', 'Single Article', 'single-article', '', 'joomla/content-component/single-article', 'index.php?option=com_content&view=article&id=73', 'component', 1, 266, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 299, 300, 0, '*', 0),
(259, 'mainmenu', 'Article Category Blog', 'article-category-blog', '', 'joomla/content-component/article-category-blog', 'index.php?option=com_content&view=category&layout=blog&id=79', 'component', 1, 266, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"layout_type\":\"blog\",\"show_category_heading_title_text\":\"\",\"show_category_title\":\"\",\"show_description\":\"0\",\"show_description_image\":\"0\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"show_cat_tags\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"1\",\"num_intro_articles\":\"4\",\"num_columns\":\"2\",\"num_links\":\"4\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"2\",\"show_pagination_results\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"1\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 301, 302, 0, '*', 0),
(260, 'mainmenu', 'Article Category List', 'article-category-list', '', 'joomla/content-component/article-category-list', 'index.php?option=com_content&view=category&id=19', 'component', 1, 266, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_category_heading_title\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"show_cat_tags\":\"\",\"page_subheading\":\"\",\"show_pagination_limit\":\"\",\"filter_field\":\"\",\"show_headings\":\"\",\"list_show_date\":\"\",\"date_format\":\"\",\"list_show_hits\":\"\",\"list_show_author\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"alpha\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"display_num\":\"10\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 303, 304, 0, '*', 0),
(262, 'mainmenu', 'Featured Articles', 'featured-articles', '', 'joomla/content-component/featured-articles', 'index.php?option=com_content&view=featured', 'component', 1, 266, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"featured_categories\":[\"\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"1\",\"num_intro_articles\":\"4\",\"num_columns\":\"2\",\"num_links\":\"4\",\"multi_column_order\":\"1\",\"orderby_pri\":\"\",\"orderby_sec\":\"front\",\"order_date\":\"\",\"show_pagination\":\"2\",\"show_pagination_results\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"1\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 305, 306, 0, '*', 0),
(263, 'mainmenu', 'Submit Article', 'submit-article', '', 'joomla/content-component/submit-article', 'index.php?option=com_content&view=form&layout=edit', 'component', 1, 266, 3, 22, 0, '0000-00-00 00:00:00', 0, 3, '', 11, '{\"enable_category\":\"0\",\"catid\":\"19\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 307, 308, 0, '*', 0),
(266, 'mainmenu', 'Content Component', 'content-component', '', 'joomla/content-component', '#', 'url', 1, 280, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 298, 309, 0, '*', 0),
(267, 'mainmenu', 'News Feeds Component', 'news-feeds-component', '', 'joomla/other-components/news-feeds-component', 'index.php?option=com_content&view=article&id=60', 'component', 1, 268, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Newsfeeds Categories View \",\"show_page_heading\":1,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"left\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 331, 338, 0, '*', 0),
(268, 'mainmenu', 'Other Components', 'other-components', '', 'joomla/other-components', '#', 'url', 1, 280, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 330, 345, 0, '*', 0),
(270, 'mainmenu', 'Contact Component', 'contact-component', '', 'joomla/contact-component', '#', 'url', 1, 280, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 310, 319, 0, '*', 0),
(271, 'mainmenu', 'Users Component', 'users-component', '', 'joomla/users-component', '#', 'url', 1, 280, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 320, 329, 0, '*', 0),
(275, 'mainmenu', 'Contact Single Category', 'contact-single-category', '', 'joomla/contact-component/contact-single-category', 'index.php?option=com_contact&view=category&catid=26&id=36', 'component', 1, 270, 3, 8, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"-1\",\"show_empty_categories\":\"\",\"show_subcat_desc\":\"\",\"show_cat_items\":\"\",\"filter_field\":\"\",\"show_pagination_limit\":\"\",\"show_headings\":\"\",\"show_position_headings\":\"\",\"show_email_headings\":\"\",\"show_telephone_headings\":\"\",\"show_mobile_headings\":\"\",\"show_fax_headings\":\"\",\"show_suburb_headings\":\"\",\"show_state_headings\":\"\",\"show_country_headings\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"initial_sort\":\"\",\"presentation_style\":\"sliders\",\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_links\":\"1\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\",\"show_feed_link\":\"1\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 313, 314, 0, '*', 0),
(276, 'mainmenu', 'Search Components', 'search-component', '', 'joomla/other-components/search-component', 'index.php?option=com_content&view=article&id=39', 'component', 1, 268, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"left\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 339, 340, 0, '*', 0),
(278, 'mainmenu', 'Blog', 'blog', '', 'blog', 'index.php?option=com_content&view=category&layout=blog&id=84', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 11, '{\"layout_type\":\"blog\",\"show_category_heading_title_text\":\"\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"show_cat_tags\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"\",\"num_intro_articles\":\"\",\"num_columns\":\"\",\"num_links\":\"\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_featured\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"0\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"278\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 271, 296, 0, '*', 0),
(279, 'mainmenu', 'Pages', 'pages', '', 'pages', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 31, 46, 0, '*', 0),
(280, 'mainmenu', 'Joomla!', 'joomla', '', 'joomla', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menulayout\":\"{\\\"width\\\":800,\\\"menuItem\\\":4,\\\"menuAlign\\\":\\\"full\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":3,\\\"menuParentId\\\":\\\"266\\\",\\\"moduleId\\\":\\\"\\\"},{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":3,\\\"menuParentId\\\":\\\"270\\\",\\\"moduleId\\\":\\\"\\\"},{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":3,\\\"menuParentId\\\":\\\"271\\\",\\\"moduleId\\\":\\\"\\\"},{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":3,\\\"menuParentId\\\":\\\"268\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"1\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 297, 346, 0, '*', 0),
(402, 'mainmenu', 'Login Form', 'login-form', '', 'joomla/users-component/login-form', 'index.php?option=com_users&view=login', 'component', 1, 271, 3, 25, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"login_redirect_url\":\"\",\"logindescription_show\":\"1\",\"login_description\":\"\",\"login_image\":\"\",\"logout_redirect_url\":\"\",\"logoutdescription_show\":\"1\",\"logout_description\":\"\",\"logout_image\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 321, 322, 0, '*', 0),
(403, 'mainmenu', 'User Profile', 'user-profile', '', 'joomla/users-component/user-profile', 'index.php?option=com_users&view=profile', 'component', 1, 271, 3, 25, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 323, 324, 0, '*', 0),
(404, 'mainmenu', 'Edit User Profile', 'edit-user-profile', '', 'joomla/users-component/edit-user-profile', 'index.php?option=com_users&view=profile&layout=edit', 'component', 1, 271, 3, 25, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 325, 326, 0, '*', 0),
(405, 'mainmenu', 'Registration Form', 'registration-form', '', 'joomla/users-component/registration-form', 'index.php?option=com_users&view=registration', 'component', 1, 271, 3, 25, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 327, 328, 0, '*', 0),
(437, 'mainmenu', 'Home', 'home', '', 'home', 'index.php?option=com_sppagebuilder&view=page&id=1', 'component', 1, 1, 1, 10004, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 11, 30, 1, '*', 0),
(449, 'usermenu', 'Submit an Article', 'submit-an-article', '', 'submit-an-article', 'index.php?option=com_content&view=form&layout=edit', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 3, '', 11, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 377, 378, 0, '*', 0),
(450, 'usermenu', 'Submit a Web Link', 'submit-a-web-link', '', 'submit-a-web-link', 'index.php?option=com_weblinks&view=form&layout=edit', 'component', 1, 1, 1, 21, 0, '0000-00-00 00:00:00', 0, 3, '', 11, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 379, 380, 0, '*', 0),
(452, 'mainmenu', 'Featured Contacts', 'featured-contacts', '', 'joomla/contact-component/featured-contacts', 'index.php?option=com_contact&view=featured&id=16', 'component', 1, 270, 3, 8, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"show_pagination_limit\":\"\",\"show_headings\":\"\",\"show_position_headings\":\"\",\"show_email_headings\":\"\",\"show_telephone_headings\":\"\",\"show_mobile_headings\":\"\",\"show_fax_headings\":\"\",\"show_suburb_headings\":\"\",\"show_state_headings\":\"\",\"show_country_headings\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"presentation_style\":\"sliders\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_links\":\"1\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":1,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 317, 318, 0, '*', 0),
(466, 'mainmenu', 'Smart Search', 'smart-search', '', 'joomla/other-components/smart-search', 'index.php?option=com_finder&view=search', 'component', 1, 268, 3, 27, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"show_date_filters\":\"\",\"show_advanced\":\"\",\"expand_advanced\":\"\",\"show_description\":\"\",\"description_length\":255,\"show_url\":\"\",\"show_pagination_limit\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"allow_empty_query\":\"0\",\"show_suggested_query\":\"1\",\"show_explained_query\":\"1\",\"sort_order\":\"\",\"sort_direction\":\"\",\"show_feed\":\"0\",\"show_feed_text\":\"0\",\"show_feed_link\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 341, 342, 0, '*', 0),
(471, 'main', 'com_tags', 'com-tags', '', 'com-tags', 'index.php?option=com_tags', 'component', 1, 1, 1, 29, 0, '0000-00-00 00:00:00', 0, 1, 'class:tags', 0, '', 381, 382, 0, '', 1),
(472, 'main', 'com_postinstall', 'Post-installation messages', '', 'Post-installation messages', 'index.php?option=com_postinstall', 'component', 1, 1, 1, 32, 0, '0000-00-00 00:00:00', 0, 1, 'class:postinstall', 0, '', 383, 384, 0, '*', 1),
(475, 'partners', 'JoomShaper', 'joomshaper', '', 'joomshaper', 'http://www.joomshaper.com/', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 385, 386, 0, '*', 0),
(476, 'partners', 'Themeum', 'themeum', '', 'themeum', 'http://www.themeum.com/', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 387, 388, 0, '*', 0),
(477, 'partners', 'ShapeBootstrap', 'shapebootstrap', '', 'shapebootstrap', 'http://shapebootstrap.net/', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 389, 390, 0, '*', 0),
(479, 'partners', 'Page Builder', 'page-builder', '', 'page-builder', 'http://www.joomshaper.com/page-builder', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 391, 392, 0, '*', 0),
(481, 'quicklink', 'Helix 3 Framework', 'helix-framework', '', 'helix-framework', 'http://www.joomshaper.com/helix3', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"481\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 393, 394, 0, '*', 0),
(482, 'quicklink', 'Documentation', 'documentation', '', 'documentation', 'http://www.joomshaper.com/documentation/', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 395, 396, 0, '*', 0),
(483, 'quicklink', 'Demo Page Builder ', 'demo-pagebuilder', '', 'demo-pagebuilder', 'http://demo.joomshaper.com/page-builder/', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 397, 398, 0, '*', 0),
(484, 'quicklink', 'Plans & Pricing', 'plan-pricing', '', 'plan-pricing', 'http://www.joomshaper.com/join-now', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 399, 400, 0, '*', 0),
(487, 'mainmenu', 'Coming Soon', '2015-02-02-15-01-12', '', 'pages/2015-02-02-15-01-12', '?tmpl=comingsoon', 'url', 1, 279, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"487\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 42, 43, 0, '*', 0),
(488, 'mainmenu', '404 Page', '2015-02-02-15-05-34', '', 'pages/2015-02-02-15-05-34', 'index.php?option=com_404', 'url', 1, 279, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 44, 45, 0, '*', 0),
(489, 'mainmenu', 'Portfolio', 'portfolio', '', 'home/portfolio', 'index.php?option=com_sppagebuilder&view=page&id=6', 'component', 1, 437, 2, 10004, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 18, 19, 0, '*', 0),
(490, 'mainmenu', 'Corporate', 'corporate', '', 'home/corporate', 'index.php?option=com_sppagebuilder&view=page&id=2', 'component', -2, 437, 2, 10004, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 16, 17, 0, '*', 0),
(492, 'mainmenu', 'Blog With Right Sidebar', 'blog-with-right-sidebar', '', 'blog/blog-with-right-sidebar', 'index.php?option=com_content&view=category&layout=blog&id=84', 'component', 1, 278, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 11, '{\"layout_type\":\"blog\",\"show_category_heading_title_text\":\"\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"show_cat_tags\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"\",\"num_intro_articles\":\"\",\"num_columns\":\"\",\"num_links\":\"\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_featured\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"0\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 272, 273, 0, '*', 0),
(493, 'mainmenu', 'Blog With Left Sidebar', 'blog-with-left-sidebar', '', 'blog/blog-with-left-sidebar', 'index.php?option=com_content&view=category&layout=blog&id=84', 'component', 1, 278, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 11, '{\"layout_type\":\"blog\",\"show_category_heading_title_text\":\"\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"show_cat_tags\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"\",\"num_intro_articles\":\"\",\"num_columns\":\"\",\"num_links\":\"\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_featured\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"0\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 274, 275, 0, '*', 0);
INSERT INTO `#__menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES
(494, 'mainmenu', 'Standard Post Format', 'standard-post-format', '', 'blog/post-formats/standard-post-format', 'index.php?option=com_content&view=article&id=73', 'component', 1, 503, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 279, 280, 0, '*', 0),
(495, 'mainmenu', 'Video Post Format', 'video-post-format', '', 'blog/post-formats/video-post-format', 'index.php?option=com_content&view=article&id=72', 'component', 1, 503, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 281, 282, 0, '*', 0),
(496, 'mainmenu', 'Gallery Post Format', 'gallery-post-format', '', 'blog/post-formats/gallery-post-format', 'index.php?option=com_content&view=article&id=74', 'component', 1, 503, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 285, 286, 0, '*', 0),
(497, 'mainmenu', 'Audio Post Format', 'audio-post-format', '', 'blog/post-formats/audio-post-format', 'index.php?option=com_content&view=article&id=75', 'component', 1, 503, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 283, 284, 0, '*', 0),
(498, 'mainmenu', 'Image Post Format', 'image-post-format', '', 'blog/post-formats/image-post-format', 'index.php?option=com_content&view=article&id=73', 'component', 1, 503, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 293, 294, 0, '*', 0),
(499, 'mainmenu', 'Link Post Format', 'link-post-format', '', 'blog/post-formats/link-post-format', 'index.php?option=com_content&view=article&id=76', 'component', 1, 503, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 287, 288, 0, '*', 0),
(500, 'mainmenu', 'Status Post Format', 'status-post-format', '', 'blog/post-formats/status-post-format', 'index.php?option=com_content&view=article&id=71', 'component', 1, 503, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 291, 292, 0, '*', 0),
(501, 'mainmenu', 'Quote Post Format', 'quote-post-format', '', 'blog/post-formats/quote-post-format', 'index.php?option=com_content&view=article&id=77', 'component', 1, 503, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 289, 290, 0, '*', 0),
(502, 'mainmenu', 'Portfolio', 'portfolios', '', 'home/portfolios', 'index.php?option=com_sppagebuilder&view=page&id=6', 'component', -2, 437, 2, 10004, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 22, 23, 0, '*', 0),
(503, 'mainmenu', 'Post Formats', 'post-formats', '', 'blog/post-formats', '#', 'url', 1, 278, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"left\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 278, 295, 0, '*', 0),
(504, 'mainmenu', 'Article Category Blog', 'article-category-blog-2', '', 'blog/article-category-blog-2', 'index.php?option=com_content&view=category&layout=blog&id=84', 'component', 1, 278, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 11, '{\"layout_type\":\"blog\",\"show_category_heading_title_text\":\"\",\"show_category_title\":\"\",\"show_description\":\"0\",\"show_description_image\":\"0\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"show_cat_tags\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"1\",\"num_intro_articles\":\"4\",\"num_columns\":\"2\",\"num_links\":\"4\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"2\",\"show_pagination_results\":\"\",\"show_featured\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"0\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"1\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 276, 277, 0, '*', 0),
(522, 'mainmenu', 'Lawyer', 'lawyer', '', 'home/lawyer', 'index.php?option=com_sppagebuilder&view=page&id=8', 'component', 1, 437, 2, 10004, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 12, 13, 0, '*', 0),
(523, 'mainmenu', 'Construction', 'construction', '', 'home/construction', 'index.php?option=com_sppagebuilder&view=page&id=9', 'component', 1, 437, 2, 10004, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 14, 15, 0, '*', 0),
(524, 'mainmenu', 'About Us', 'about-us', '', 'pages/about-us', 'index.php?option=com_sppagebuilder&view=page&id=10', 'component', 1, 279, 2, 10004, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 32, 33, 0, '*', 0),
(525, 'mainmenu', 'Service', 'service', '', 'pages/service', 'index.php?option=com_sppagebuilder&view=page&id=13', 'component', 1, 279, 2, 10004, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 34, 35, 0, '*', 0),
(526, 'mainmenu', 'Pricing Table', 'pricing', '', 'pages/pricing', 'index.php?option=com_sppagebuilder&view=page&id=14', 'component', 1, 279, 2, 10004, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 36, 37, 0, '*', 0),
(527, 'mainmenu', 'Faq', 'faq', '', 'pages/faq', 'index.php?option=com_sppagebuilder&view=page&id=15', 'component', 1, 279, 2, 10004, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 38, 39, 0, '*', 0),
(528, 'mainmenu', 'Contact', 'contact', '', 'pages/contact', 'index.php?option=com_sppagebuilder&view=page&id=16', 'component', 1, 279, 2, 10004, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 40, 41, 0, '*', 0),
(542, 'mainmenu', 'Shop', 'home-shop', '', 'home/home-shop', 'index.php?option=com_sppagebuilder&view=page&id=17', 'component', 1, 437, 2, 10004, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 20, 21, 0, '*', 0),
(543, 'mainmenu', 'shop', 'shops', '', 'shops', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=0&virtuemart_manufacturer_id=0', 'component', 0, 1, 1, 10040, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"543\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"categorylayout\":\"default\",\"showcategory\":\"1\",\"showproducts\":\"1\",\"productsublayout\":\"0\"}', 349, 350, 0, '*', 0),
(544, 'mainmenu', 'test', 'test', '', 'test', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=4&virtuemart_manufacturer_id=0', 'component', -2, 1, 1, 10040, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"categorylayout\":\"0\",\"showcategory\":\"1\",\"showproducts\":\"1\",\"productsublayout\":\"0\"}', 401, 402, 0, '*', 0),
(545, 'mainmenu', 'Cart', 'cart', '', 'cart', 'index.php?option=com_virtuemart&view=cart', 'component', 0, 1, 1, 10040, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"545\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"fa-shopping-cart\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 347, 348, 0, '*', 0),
(546, 'mainmenu', 'Agency', 'agency', '', 'home/agency', 'index.php?option=com_sppagebuilder&view=page&id=18', 'component', 1, 437, 2, 10004, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 24, 25, 0, '*', 0),
(548, 'mainmenu', 'Addons', 'addons', '', 'addons', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menulayout\":\"{\\\"width\\\":900,\\\"menuItem\\\":4,\\\"menuAlign\\\":\\\"full\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":3,\\\"menuParentId\\\":\\\"592\\\",\\\"moduleId\\\":\\\"\\\"},{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":3,\\\"menuParentId\\\":\\\"593\\\",\\\"moduleId\\\":\\\"\\\"},{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":3,\\\"menuParentId\\\":\\\"594\\\",\\\"moduleId\\\":\\\"\\\"},{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":3,\\\"menuParentId\\\":\\\"619\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"1\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"tixon-addons-list\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 119, 208, 0, '*', 0),
(549, 'mainmenu', 'Accordion', 'accordion', '', 'addons/addons-list-1/accordion', 'index.php?option=com_sppagebuilder&view=page&id=19', 'component', 1, 592, 3, 10004, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 121, 122, 0, '*', 0),
(550, 'mainmenu', 'Animated Number', 'animated-number', '', 'addons/addons-list-1/animated-number', 'index.php?option=com_sppagebuilder&view=page&id=20', 'component', 1, 592, 3, 10004, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 123, 124, 0, '*', 0),
(551, 'mainmenu', 'Call To Action', 'call-to-action', '', 'addons/addons-list-1/call-to-action', 'index.php?option=com_sppagebuilder&view=page&id=21', 'component', 1, 592, 3, 10004, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 125, 126, 0, '*', 0),
(552, 'mainmenu', 'Team', 'team', '', 'addons/addons-list-1/team', 'index.php?option=com_sppagebuilder&view=page&id=22', 'component', 1, 592, 3, 10004, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 127, 128, 0, '*', 0),
(553, 'mainmenu', 'Video & Audio', 'video-audio', '', 'addons/addons-list-1/video-audio', 'index.php?option=com_sppagebuilder&view=page&id=23', 'component', 1, 592, 3, 10004, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 129, 130, 0, '*', 0),
(554, 'mainmenu', 'Feature Box', 'feature-box', '', 'addons/addons-list-1/feature-box', 'index.php?option=com_sppagebuilder&view=page&id=24', 'component', 1, 592, 3, 10004, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 131, 132, 0, '*', 0),
(555, 'mainmenu', 'Icon', 'icon', '', 'addons/addons-list-2/icon', 'index.php?option=com_sppagebuilder&view=page&id=25', 'component', 1, 593, 3, 10004, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 143, 144, 0, '*', 0),
(556, 'mainmenu', 'Button', 'button', '', 'addons/addons-list-2/button', 'index.php?option=com_sppagebuilder&view=page&id=26', 'component', 1, 593, 3, 10004, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 145, 146, 0, '*', 0),
(557, 'mainmenu', 'Alert', 'alert', '', 'addons/addons-list-2/alert', 'index.php?option=com_sppagebuilder&view=page&id=27', 'component', 1, 593, 3, 10004, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 147, 148, 0, '*', 0),
(558, 'mainmenu', 'Block Number', 'block-number', '', 'addons/addons-list-2/block-number', 'index.php?option=com_sppagebuilder&view=page&id=28', 'component', 1, 593, 3, 10004, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 149, 150, 0, '*', 0),
(559, 'mainmenu', 'Blockquote', 'blockquote', '', 'addons/addons-list-2/blockquote', 'index.php?option=com_sppagebuilder&view=page&id=29', 'component', 1, 593, 3, 10004, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 151, 152, 0, '*', 0),
(560, 'mainmenu', 'Audio', 'audio', '', 'addons/addons-list-2/audio', 'index.php?option=com_sppagebuilder&view=page&id=30', 'component', 1, 593, 3, 10004, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 153, 154, 0, '*', 0),
(561, 'mainmenu', 'Pricing', 'pricing', '', 'addons/addons-list-3/pricing', 'index.php?option=com_sppagebuilder&view=page&id=35', 'component', 1, 594, 3, 10004, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 165, 166, 0, '*', 0),
(562, 'mainmenu', 'Tab & Tours', 'tab-tours', '', 'addons/addons-list-3/tab-tours', 'index.php?option=com_sppagebuilder&view=page&id=31', 'component', 1, 594, 3, 10004, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 167, 168, 0, '*', 0),
(563, 'mainmenu', 'Flicker Gallery', 'flicker-gallery', '', 'addons/addons-list-3/flicker-gallery', 'index.php?option=com_sppagebuilder&view=page&id=32', 'component', 1, 594, 3, 10004, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 169, 170, 0, '*', 0),
(564, 'mainmenu', 'Carosuel', 'carosuel', '', 'addons/addons-list-3/carosuel', 'index.php?option=com_sppagebuilder&view=page&id=33', 'component', 1, 594, 3, 10004, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 171, 172, 0, '*', 0),
(565, 'mainmenu', 'Carosuel Pro', 'carosuel-pro', '', 'addons/addons-list-3/carosuel-pro', 'index.php?option=com_sppagebuilder&view=page&id=34', 'component', 1, 594, 3, 10004, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 173, 174, 0, '*', 0),
(566, 'mainmenu', 'Shop', 'shop', '', 'shop', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=0&virtuemart_manufacturer_id=0', 'component', 1, 1, 1, 10040, 0, '0000-00-00 00:00:00', 0, 1, ' ', 11, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"menulayout\":\"{\\\"width\\\":800,\\\"menuItem\\\":2,\\\"menuAlign\\\":\\\"center\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":4,\\\"menuParentId\\\":\\\"567\\\",\\\"moduleId\\\":\\\"\\\"},{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":4,\\\"menuParentId\\\":\\\"573\\\",\\\"moduleId\\\":\\\"\\\"},{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":4,\\\"menuParentId\\\":\\\"\\\",\\\"moduleId\\\":\\\"127\\\"}]},{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"\\\",\\\"moduleId\\\":\\\"128\\\"}]}]}\",\"megamenu\":\"1\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"categorylayout\":\"default\",\"showcategory\":\"1\",\"showproducts\":\"1\",\"productsublayout\":\"0\"}', 47, 118, 0, '*', 0),
(567, 'mainmenu', 'Categories', 'categoris', '', 'shop/categoris', '#', 'url', 1, 566, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 48, 69, 0, '*', 0),
(568, 'mainmenu', 'Women', 'test', '', 'shop/categoris/test', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=7&virtuemart_manufacturer_id=0', 'component', 1, 567, 3, 10040, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"categorylayout\":\"default\",\"showcategory\":\"1\",\"showproducts\":\"1\",\"productsublayout\":\"0\"}', 61, 62, 0, '*', 0),
(569, 'mainmenu', 'Article Category Blog', 'article-category-blog', '', 'shop/categoris/article-category-blog', 'index.php?option=com_content&view=category&layout=blog&id=79', 'component', -2, 567, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"layout_type\":\"blog\",\"show_category_heading_title_text\":\"\",\"show_category_title\":\"\",\"show_description\":\"0\",\"show_description_image\":\"0\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"show_cat_tags\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"1\",\"num_intro_articles\":\"4\",\"num_columns\":\"2\",\"num_links\":\"4\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"2\",\"show_pagination_results\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"1\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 49, 50, 0, '*', 0),
(570, 'mainmenu', 'Article Category List', 'article-category-list', '', 'shop/categoris/article-category-list', 'index.php?option=com_content&view=category&id=19', 'component', -2, 567, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_category_heading_title\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"show_cat_tags\":\"\",\"page_subheading\":\"\",\"show_pagination_limit\":\"\",\"filter_field\":\"\",\"show_headings\":\"\",\"list_show_date\":\"\",\"date_format\":\"\",\"list_show_hits\":\"\",\"list_show_author\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"alpha\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"display_num\":\"10\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 51, 52, 0, '*', 0),
(571, 'mainmenu', 'Featured Articles', 'featured-articles', '', 'shop/categoris/featured-articles', 'index.php?option=com_content&view=featured', 'component', -2, 567, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"featured_categories\":[\"\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"1\",\"num_intro_articles\":\"4\",\"num_columns\":\"2\",\"num_links\":\"4\",\"multi_column_order\":\"1\",\"orderby_pri\":\"\",\"orderby_sec\":\"front\",\"order_date\":\"\",\"show_pagination\":\"2\",\"show_pagination_results\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"1\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 53, 54, 0, '*', 0),
(572, 'mainmenu', 'Submit Article', 'submit-article', '', 'shop/categoris/submit-article', 'index.php?option=com_content&view=form&layout=edit', 'component', -2, 567, 3, 22, 0, '0000-00-00 00:00:00', 0, 3, '', 0, '{\"enable_category\":\"0\",\"catid\":\"19\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 55, 56, 0, '*', 0),
(573, 'mainmenu', 'Top Categories', 'top-categories', '', 'shop/top-categories', '#', 'url', 1, 566, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 70, 91, 0, '*', 0),
(574, 'mainmenu', 'Contact Categories', 'contact-categories', '', 'shop/top-categories/contact-categories', 'index.php?option=com_contact&view=categories&id=16', 'component', -2, 573, 3, 8, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"show_base_description\":\"\",\"categories_description\":\"\",\"maxLevelcat\":\"\",\"show_empty_categories_cat\":\"\",\"show_subcat_desc_cat\":\"\",\"show_cat_items_cat\":\"\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"-1\",\"show_empty_categories\":\"\",\"show_subcat_desc\":\"\",\"show_cat_items\":\"\",\"filter_field\":\"\",\"show_pagination_limit\":\"\",\"show_headings\":\"\",\"show_position_headings\":\"\",\"show_email_headings\":\"\",\"show_telephone_headings\":\"\",\"show_mobile_headings\":\"\",\"show_fax_headings\":\"\",\"show_suburb_headings\":\"\",\"show_state_headings\":\"\",\"show_country_headings\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"presentation_style\":\"sliders\",\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_links\":\"1\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\",\"show_feed_link\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 71, 72, 0, '*', 0),
(575, 'mainmenu', 'Contact Single Category', 'contact-single-category', '', 'shop/top-categories/contact-single-category', 'index.php?option=com_contact&view=category&catid=26&id=36', 'component', -2, 573, 3, 8, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"-1\",\"show_empty_categories\":\"\",\"show_subcat_desc\":\"\",\"show_cat_items\":\"\",\"filter_field\":\"\",\"show_pagination_limit\":\"\",\"show_headings\":\"\",\"show_position_headings\":\"\",\"show_email_headings\":\"\",\"show_telephone_headings\":\"\",\"show_mobile_headings\":\"\",\"show_fax_headings\":\"\",\"show_suburb_headings\":\"\",\"show_state_headings\":\"\",\"show_country_headings\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"initial_sort\":\"\",\"presentation_style\":\"sliders\",\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_links\":\"1\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\",\"show_feed_link\":\"1\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 73, 74, 0, '*', 0);
INSERT INTO `#__menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES
(576, 'mainmenu', 'Single Contact', 'single-contact', '', 'shop/top-categories/single-contact', 'index.php?option=com_contact&view=contact&id=1', 'component', -2, 573, 3, 8, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"presentation_style\":\"\",\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"show_tags\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_links\":\"\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 75, 76, 0, '*', 0),
(577, 'mainmenu', 'Featured Contacts', 'featured-contacts', '', 'shop/top-categories/featured-contacts', 'index.php?option=com_contact&view=featured&id=16', 'component', -2, 573, 3, 8, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"show_pagination_limit\":\"\",\"show_headings\":\"\",\"show_position_headings\":\"\",\"show_email_headings\":\"\",\"show_telephone_headings\":\"\",\"show_mobile_headings\":\"\",\"show_fax_headings\":\"\",\"show_suburb_headings\":\"\",\"show_state_headings\":\"\",\"show_country_headings\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"presentation_style\":\"sliders\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_links\":\"1\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":1,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 77, 78, 0, '*', 0),
(578, 'mainmenu', 'Users Component', 'users-component', '', 'shop/users-component', '#', 'url', -2, 566, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 92, 101, 0, '*', 0),
(579, 'mainmenu', 'Login Form', 'login-form', '', 'shop/users-component/login-form', 'index.php?option=com_users&view=login', 'component', -2, 578, 3, 25, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"login_redirect_url\":\"\",\"logindescription_show\":\"1\",\"login_description\":\"\",\"login_image\":\"\",\"logout_redirect_url\":\"\",\"logoutdescription_show\":\"1\",\"logout_description\":\"\",\"logout_image\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 93, 94, 0, '*', 0),
(580, 'mainmenu', 'User Profile', 'user-profile', '', 'shop/users-component/user-profile', 'index.php?option=com_users&view=profile', 'component', -2, 578, 3, 25, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 95, 96, 0, '*', 0),
(581, 'mainmenu', 'Edit User Profile', 'edit-user-profile', '', 'shop/users-component/edit-user-profile', 'index.php?option=com_users&view=profile&layout=edit', 'component', -2, 578, 3, 25, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 97, 98, 0, '*', 0),
(582, 'mainmenu', 'Registration Form', 'registration-form', '', 'shop/users-component/registration-form', 'index.php?option=com_users&view=registration', 'component', -2, 578, 3, 25, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 99, 100, 0, '*', 0),
(583, 'mainmenu', 'Other Components', 'other-components', '', 'shop/other-components', '#', 'url', -2, 566, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 102, 117, 0, '*', 0),
(584, 'mainmenu', 'News Feeds Component', 'news-feeds-component', '', 'shop/other-components/news-feeds-component', 'index.php?option=com_content&view=article&id=60', 'component', -2, 583, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Newsfeeds Categories View \",\"show_page_heading\":1,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"left\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 103, 110, 0, '*', 0),
(585, 'mainmenu', 'News Feed Categories', 'new-feed-categories', '', 'shop/other-components/news-feeds-component/new-feed-categories', 'index.php?option=com_newsfeeds&view=categories&id=0', 'component', -2, 584, 4, 17, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"show_base_description\":\"\",\"categories_description\":\"\",\"maxLevelcat\":\"\",\"show_empty_categories_cat\":\"\",\"show_subcat_desc_cat\":\"\",\"show_cat_items_cat\":\"\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_subcat_desc\":\"\",\"show_cat_items\":\"\",\"filter_field\":\"\",\"show_pagination_limit\":\"\",\"show_headings\":\"\",\"show_articles\":\"\",\"show_link\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_feed_image\":\"\",\"show_feed_description\":\"\",\"show_item_description\":\"\",\"feed_character_count\":\"0\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 104, 105, 0, '*', 0),
(586, 'mainmenu', 'Single News Feed', 'single-news-feed', '', 'shop/other-components/news-feeds-component/single-news-feed', 'index.php?option=com_newsfeeds&view=newsfeed&id=4', 'component', -2, 584, 4, 17, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"show_feed_image\":\"\",\"show_feed_description\":\"\",\"show_item_description\":\"\",\"show_tags\":\"\",\"feed_character_count\":\"0\",\"feed_display_order\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 106, 107, 0, '*', 0),
(587, 'mainmenu', 'News Feed Category', 'news-feed-category', '', 'shop/other-components/news-feeds-component/news-feed-category', 'index.php?option=com_newsfeeds&view=category&id=17', 'component', -2, 584, 4, 17, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"-1\",\"show_empty_categories\":\"\",\"show_subcat_desc\":\"\",\"show_cat_items\":\"\",\"filter_field\":\"\",\"show_pagination_limit\":\"\",\"show_headings\":\"\",\"show_articles\":\"\",\"show_link\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_feed_image\":\"\",\"show_feed_description\":\"\",\"show_item_description\":\"\",\"feed_character_count\":\"0\",\"feed_display_order\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 108, 109, 0, '*', 0),
(588, 'mainmenu', 'Search Components', 'search-component', '', 'shop/other-components/search-component', 'index.php?option=com_content&view=article&id=39', 'component', -2, 583, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"left\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 111, 112, 0, '*', 0),
(589, 'mainmenu', 'Smart Search', 'smart-search', '', 'shop/other-components/smart-search', 'index.php?option=com_finder&view=search', 'component', -2, 583, 3, 27, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"show_date_filters\":\"\",\"show_advanced\":\"\",\"expand_advanced\":\"\",\"show_description\":\"\",\"description_length\":255,\"show_url\":\"\",\"show_pagination_limit\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"allow_empty_query\":\"0\",\"show_suggested_query\":\"1\",\"show_explained_query\":\"1\",\"sort_order\":\"\",\"sort_direction\":\"\",\"show_feed\":\"0\",\"show_feed_text\":\"0\",\"show_feed_link\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 113, 114, 0, '*', 0),
(590, 'mainmenu', 'Search', 'search', '', 'shop/other-components/search', 'index.php?option=com_search&view=search', 'component', -2, 583, 3, 19, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"search_areas\":\"1\",\"show_date\":\"1\",\"searchphrase\":\"0\",\"ordering\":\"newest\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 115, 116, 0, '*', 0),
(591, 'mainmenu', 'Clothing', 'clothing', '', 'shop/categoris/clothing', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=5&virtuemart_manufacturer_id=0', 'component', 1, 567, 3, 10040, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"categorylayout\":\"default\",\"showcategory\":\"1\",\"showproducts\":\"1\",\"productsublayout\":\"0\"}', 57, 58, 0, '*', 0),
(592, 'mainmenu', 'Addons List 1', 'addons-list-1', '', 'addons/addons-list-1', '#', 'url', 1, 548, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"addon-list-1\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 120, 141, 0, '*', 0),
(593, 'mainmenu', 'Addons List 2', 'addons-list-2', '', 'addons/addons-list-2', '#', 'url', 1, 548, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 142, 163, 0, '*', 0),
(594, 'mainmenu', 'Addons List 3', 'addons-list-3', '', 'addons/addons-list-3', '#', 'url', 1, 548, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 164, 185, 0, '*', 0),
(595, 'mainmenu', 'Men', 'men', '', 'shop/categoris/men', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=6&virtuemart_manufacturer_id=0', 'component', 1, 567, 3, 10040, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"categorylayout\":\"default\",\"showcategory\":\"1\",\"showproducts\":\"1\",\"productsublayout\":\"0\"}', 59, 60, 0, '*', 0),
(596, 'mainmenu', 'Home & Kichen', 'home-kichen', '', 'shop/categoris/home-kichen', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=4&virtuemart_manufacturer_id=0', 'component', 1, 567, 3, 10040, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"categorylayout\":\"default\",\"showcategory\":\"1\",\"showproducts\":\"1\",\"productsublayout\":\"0\"}', 63, 64, 0, '*', 0),
(597, 'mainmenu', 'Music & Poster', 'music-poster', '', 'shop/categoris/music-poster', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=2&virtuemart_manufacturer_id=0', 'component', 1, 567, 3, 10040, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"categorylayout\":\"default\",\"showcategory\":\"1\",\"showproducts\":\"1\",\"productsublayout\":\"0\"}', 65, 66, 0, '*', 0),
(598, 'mainmenu', 'Stationery', 'stationery', '', 'shop/categoris/stationery', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=1&virtuemart_manufacturer_id=0', 'component', 1, 567, 3, 10040, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"categorylayout\":\"default\",\"showcategory\":\"1\",\"showproducts\":\"1\",\"productsublayout\":\"0\"}', 67, 68, 0, '*', 0),
(599, 'mainmenu', 'Home & Kitchen', 'home-kitchen', '', 'shop/top-categories/home-kitchen', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=4&virtuemart_manufacturer_id=0', 'component', 1, 573, 3, 10040, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"categorylayout\":\"default\",\"showcategory\":\"1\",\"showproducts\":\"1\",\"productsublayout\":\"0\"}', 79, 80, 0, '*', 0),
(600, 'mainmenu', 'Music & Poster', 'music-poster', '', 'shop/top-categories/music-poster', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=2&virtuemart_manufacturer_id=0', 'component', 1, 573, 3, 10040, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"categorylayout\":\"default\",\"showcategory\":\"1\",\"showproducts\":\"1\",\"productsublayout\":\"0\"}', 89, 90, 0, '*', 0),
(601, 'mainmenu', 'Clothing', 'clothing', '', 'shop/top-categories/clothing', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=5&virtuemart_manufacturer_id=0', 'component', 1, 573, 3, 10040, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"categorylayout\":\"default\",\"showcategory\":\"1\",\"showproducts\":\"1\",\"productsublayout\":\"0\"}', 81, 82, 0, '*', 0),
(602, 'mainmenu', 'Men', 'men', '', 'shop/top-categories/men', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=6&virtuemart_manufacturer_id=0', 'component', 1, 573, 3, 10040, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"categorylayout\":\"default\",\"showcategory\":\"1\",\"showproducts\":\"1\",\"productsublayout\":\"0\"}', 83, 84, 0, '*', 0),
(603, 'mainmenu', 'Woman', 'woman', '', 'shop/top-categories/woman', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=7&virtuemart_manufacturer_id=0', 'component', 1, 573, 3, 10040, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"categorylayout\":\"default\",\"showcategory\":\"1\",\"showproducts\":\"1\",\"productsublayout\":\"0\"}', 85, 86, 0, '*', 0),
(604, 'mainmenu', 'Stationery', 'stationery', '', 'shop/top-categories/stationery', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=1&virtuemart_manufacturer_id=0', 'component', 1, 573, 3, 10040, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"categorylayout\":\"default\",\"showcategory\":\"1\",\"showproducts\":\"1\",\"productsublayout\":\"0\"}', 87, 88, 0, '*', 0),
(605, 'mainmenu', 'Joomla Module', 'joomla-module', '', 'addons/addons-list-1/joomla-module', 'index.php?option=com_sppagebuilder&view=page&id=36', 'component', 1, 592, 3, 10004, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 133, 134, 0, '*', 0),
(606, 'mainmenu', 'Contact From', 'contact-from', '', 'addons/addons-list-1/contact-from', 'index.php?option=com_sppagebuilder&view=page&id=37', 'component', 1, 592, 3, 10004, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 135, 136, 0, '*', 0),
(607, 'mainmenu', 'Button Group', 'button-group', '', 'addons/addons-list-1/button-group', 'index.php?option=com_sppagebuilder&view=page&id=38', 'component', 1, 592, 3, 10004, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 137, 138, 0, '*', 0),
(608, 'mainmenu', 'Clients', 'clients', '', 'addons/addons-list-1/clients', 'index.php?option=com_sppagebuilder&view=page&id=39', 'component', 1, 592, 3, 10004, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 139, 140, 0, '*', 0),
(609, 'mainmenu', 'Divider', 'divider', '', 'addons/addons-list-4/divider', 'index.php?option=com_sppagebuilder&view=page&id=40', 'component', 1, 619, 3, 10004, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 205, 206, 0, '*', 0),
(610, 'mainmenu', 'Dropcap', 'dropcap', '', 'addons/addons-list-2/dropcap', 'index.php?option=com_sppagebuilder&view=page&id=41', 'component', 1, 593, 3, 10004, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 155, 156, 0, '*', 0),
(611, 'mainmenu', 'Facebook Like', 'facebook-like', '', 'addons/addons-list-2/facebook-like', 'index.php?option=com_sppagebuilder&view=page&id=42', 'component', 1, 593, 3, 10004, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 157, 158, 0, '*', 0),
(612, 'mainmenu', 'Facebook Likebox', 'facebook-likebox', '', 'addons/addons-list-2/facebook-likebox', 'index.php?option=com_sppagebuilder&view=page&id=43', 'component', 1, 593, 3, 10004, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 159, 160, 0, '*', 0),
(613, 'mainmenu', 'Gallery', 'gallery', '', 'addons/addons-list-2/gallery', 'index.php?option=com_sppagebuilder&view=page&id=44', 'component', 1, 593, 3, 10004, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 161, 162, 0, '*', 0),
(614, 'mainmenu', 'Google Map', 'google-map', '', 'addons/addons-list-3/google-map', 'index.php?option=com_sppagebuilder&view=page&id=45', 'component', 1, 594, 3, 10004, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 175, 176, 0, '*', 0),
(615, 'mainmenu', 'G+ Button', 'g-button', '', 'addons/addons-list-3/g-button', 'index.php?option=com_sppagebuilder&view=page&id=46', 'component', 1, 594, 3, 10004, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 177, 178, 0, '*', 0),
(616, 'mainmenu', 'Image', 'image', '', 'addons/addons-list-3/image', 'index.php?option=com_sppagebuilder&view=page&id=47', 'component', 1, 594, 3, 10004, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 179, 180, 0, '*', 0),
(617, 'mainmenu', 'Image Content', 'image-content', '', 'addons/addons-list-3/image-content', 'index.php?option=com_sppagebuilder&view=page&id=48', 'component', 1, 594, 3, 10004, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 181, 182, 0, '*', 0),
(618, 'mainmenu', 'Person', 'person', '', 'addons/addons-list-3/person', 'index.php?option=com_sppagebuilder&view=page&id=49', 'component', 1, 594, 3, 10004, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 183, 184, 0, '*', 0),
(619, 'mainmenu', 'Addons List 4', 'addons-list-4', '', 'addons/addons-list-4', '#', 'url', 1, 548, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 186, 207, 0, '*', 0),
(620, 'mainmenu', 'Progress Bar', 'pie-progress', '', 'addons/addons-list-4/pie-progress', 'index.php?option=com_sppagebuilder&view=page&id=50', 'component', 1, 619, 3, 10004, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 187, 188, 0, '*', 0),
(621, 'mainmenu', 'Pie Progress', 'pie-progress-2', '', 'addons/addons-list-4/pie-progress-2', 'index.php?option=com_sppagebuilder&view=page&id=51', 'component', 1, 619, 3, 10004, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 189, 190, 0, '*', 0),
(622, 'mainmenu', 'Raw Html', 'raw-html', '', 'addons/addons-list-4/raw-html', 'index.php?option=com_sppagebuilder&view=page&id=52', 'component', 1, 619, 3, 10004, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 191, 192, 0, '*', 0),
(623, 'mainmenu', 'Soundcloud', 'soundcloud', '', 'addons/addons-list-4/soundcloud', 'index.php?option=com_sppagebuilder&view=page&id=53', 'component', 1, 619, 3, 10004, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 193, 194, 0, '*', 0),
(624, 'mainmenu', 'Testimonial', 'testimonial', '', 'addons/addons-list-4/testimonial', 'index.php?option=com_sppagebuilder&view=page&id=54', 'component', 1, 619, 3, 10004, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 195, 196, 0, '*', 0),
(625, 'mainmenu', 'Testimonial Pro', 'testimonial-pro', '', 'addons/addons-list-4/testimonial-pro', 'index.php?option=com_sppagebuilder&view=page&id=55', 'component', 1, 619, 3, 10004, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 197, 198, 0, '*', 0),
(626, 'mainmenu', 'Text Block', 'text-block', '', 'addons/addons-list-4/text-block', 'index.php?option=com_sppagebuilder&view=page&id=56', 'component', 1, 619, 3, 10004, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 199, 200, 0, '*', 0),
(627, 'mainmenu', 'Twitter Feed', 'twitter-feed', '', 'addons/addons-list-4/twitter-feed', 'index.php?option=com_sppagebuilder&view=page&id=57', 'component', 1, 619, 3, 10004, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 201, 202, 0, '*', 0),
(628, 'mainmenu', 'Twitter Share', 'twitter-share', '', 'addons/addons-list-4/twitter-share', 'index.php?option=com_sppagebuilder&view=page&id=58', 'component', 1, 619, 3, 10004, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 203, 204, 0, '*', 0),
(630, 'mainmenu', 'Portfolio', 'portfolio', '', 'portfolio', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 1, 1, 10070, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_filter\":\"1\",\"category_id\":\"\",\"layout_type\":\"gallery_space\",\"columns\":\"3\",\"thumbnail_type\":\"square\",\"limit\":\"12\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"menulayout\":\"{\\\"width\\\":900,\\\"menuItem\\\":3,\\\"menuAlign\\\":\\\"full\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":4,\\\"menuParentId\\\":\\\"631\\\",\\\"moduleId\\\":\\\"\\\"},{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":4,\\\"menuParentId\\\":\\\"632\\\",\\\"moduleId\\\":\\\"\\\"},{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":4,\\\"menuParentId\\\":\\\"633\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"1\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 209, 270, 0, '*', 0),
(631, 'mainmenu', 'Masonry', 'masonry', '', 'portfolio/masonry', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 630, 2, 10070, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_filter\":\"1\",\"category_id\":\"\",\"layout_type\":\"default\",\"columns\":\"3\",\"thumbnail_type\":\"masonry\",\"limit\":\"12\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 210, 229, 0, '*', 0),
(632, 'mainmenu', 'Square', 'square', '', 'portfolio/square', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 630, 2, 10070, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_filter\":\"1\",\"category_id\":\"\",\"layout_type\":\"default\",\"columns\":\"3\",\"thumbnail_type\":\"square\",\"limit\":\"12\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 230, 249, 0, '*', 0),
(633, 'mainmenu', 'Rectangular', 'rectangular', '', 'portfolio/rectangular', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 630, 2, 10070, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_filter\":\"1\",\"category_id\":\"\",\"layout_type\":\"default\",\"columns\":\"3\",\"thumbnail_type\":\"rectangular\",\"limit\":\"12\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 250, 269, 0, '*', 0),
(634, 'mainmenu', 'Masonry 2 Columns', 'masonry-2-columns', '', 'portfolio/masonry/masonry-2-columns', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 631, 3, 10070, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_filter\":\"1\",\"category_id\":\"\",\"layout_type\":\"default\",\"columns\":\"2\",\"thumbnail_type\":\"masonry\",\"limit\":\"8\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 211, 212, 0, '*', 0),
(635, 'mainmenu', 'Masonry 3 Columns', 'masonry-3-columns', '', 'portfolio/masonry/masonry-3-columns', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 631, 3, 10070, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_filter\":\"1\",\"category_id\":\"\",\"layout_type\":\"default\",\"columns\":\"3\",\"thumbnail_type\":\"masonry\",\"limit\":\"12\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 213, 214, 0, '*', 0);
INSERT INTO `#__menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES
(636, 'mainmenu', 'Masonry 4 Columns', 'masonry-4-columns', '', 'portfolio/masonry/masonry-4-columns', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 631, 3, 10070, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_filter\":\"1\",\"category_id\":\"\",\"layout_type\":\"default\",\"columns\":\"4\",\"thumbnail_type\":\"masonry\",\"limit\":\"12\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 215, 216, 0, '*', 0),
(637, 'mainmenu', '2 Columns Gallery Style', '2-columns-gallery-style', '', 'portfolio/masonry/2-columns-gallery-style', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 631, 3, 10070, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_filter\":\"1\",\"category_id\":\"\",\"layout_type\":\"default\",\"columns\":\"2\",\"thumbnail_type\":\"masonry\",\"limit\":\"8\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 217, 218, 0, '*', 0),
(638, 'mainmenu', '3 Columns Gallery Style', '3-columns-gallery-style', '', 'portfolio/masonry/3-columns-gallery-style', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 631, 3, 10070, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_filter\":\"1\",\"category_id\":\"\",\"layout_type\":\"default\",\"columns\":\"3\",\"thumbnail_type\":\"masonry\",\"limit\":\"12\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 219, 220, 0, '*', 0),
(639, 'mainmenu', '4 Columns Gallery Style', '4-columns-gallery-style', '', 'portfolio/masonry/4-columns-gallery-style', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 631, 3, 10070, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_filter\":\"1\",\"category_id\":\"\",\"layout_type\":\"default\",\"columns\":\"4\",\"thumbnail_type\":\"masonry\",\"limit\":\"12\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 221, 222, 0, '*', 0),
(640, 'mainmenu', ' 2 Columns Gallery Style No Space', '2-columns-gallery-style-no-space', '', 'portfolio/masonry/2-columns-gallery-style-no-space', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 631, 3, 10070, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_filter\":\"1\",\"category_id\":\"\",\"layout_type\":\"gallery_nospace\",\"columns\":\"2\",\"thumbnail_type\":\"masonry\",\"limit\":\"8\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 223, 224, 0, '*', 0),
(641, 'mainmenu', '3 Columns Gallery Style No Space', '3-columns-gallery-style-no-space', '', 'portfolio/masonry/3-columns-gallery-style-no-space', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 631, 3, 10070, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_filter\":\"1\",\"category_id\":\"\",\"layout_type\":\"gallery_nospace\",\"columns\":\"3\",\"thumbnail_type\":\"masonry\",\"limit\":\"12\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 225, 226, 0, '*', 0),
(642, 'mainmenu', '4 Columns Gallery Style No Space', '4-columns-gallery-style-no-space', '', 'portfolio/masonry/4-columns-gallery-style-no-space', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 631, 3, 10070, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_filter\":\"1\",\"category_id\":\"\",\"layout_type\":\"gallery_nospace\",\"columns\":\"4\",\"thumbnail_type\":\"masonry\",\"limit\":\"12\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 227, 228, 0, '*', 0),
(643, 'mainmenu', 'Square 2 Columns', 'square-2-columns', '', 'portfolio/square/square-2-columns', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 632, 3, 10070, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_filter\":\"1\",\"category_id\":\"\",\"layout_type\":\"default\",\"columns\":\"2\",\"thumbnail_type\":\"square\",\"limit\":\"8\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 231, 232, 0, '*', 0),
(644, 'mainmenu', 'Square 3 Columns', 'square-3-columns', '', 'portfolio/square/square-3-columns', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 632, 3, 10070, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_filter\":\"1\",\"category_id\":\"\",\"layout_type\":\"default\",\"columns\":\"3\",\"thumbnail_type\":\"square\",\"limit\":\"12\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 233, 234, 0, '*', 0),
(645, 'mainmenu', 'Square 4 Columns', 'square-4-columns', '', 'portfolio/square/square-4-columns', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 632, 3, 10070, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_filter\":\"1\",\"category_id\":\"\",\"layout_type\":\"default\",\"columns\":\"4\",\"thumbnail_type\":\"square\",\"limit\":\"12\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 235, 236, 0, '*', 0),
(646, 'mainmenu', '2 Columns Gallery Style', '2-columns-gallery-style', '', 'portfolio/square/2-columns-gallery-style', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 632, 3, 10070, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_filter\":\"1\",\"category_id\":\"\",\"layout_type\":\"default\",\"columns\":\"2\",\"thumbnail_type\":\"square\",\"limit\":\"8\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 237, 238, 0, '*', 0),
(647, 'mainmenu', '3 Columns Gallery Style', '3-columns-gallery-style', '', 'portfolio/square/3-columns-gallery-style', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 632, 3, 10070, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_filter\":\"1\",\"category_id\":\"\",\"layout_type\":\"default\",\"columns\":\"3\",\"thumbnail_type\":\"square\",\"limit\":\"12\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 239, 240, 0, '*', 0),
(648, 'mainmenu', '4 Columns Gallery Style', '4-columns-gallery-style', '', 'portfolio/square/4-columns-gallery-style', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 632, 3, 10070, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_filter\":\"1\",\"category_id\":\"\",\"layout_type\":\"default\",\"columns\":\"4\",\"thumbnail_type\":\"square\",\"limit\":\"12\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 241, 242, 0, '*', 0),
(649, 'mainmenu', ' 2 Columns Gallery Style No Space', '2-columns-gallery-style-no-space', '', 'portfolio/square/2-columns-gallery-style-no-space', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 632, 3, 10070, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_filter\":\"1\",\"category_id\":\"\",\"layout_type\":\"gallery_nospace\",\"columns\":\"2\",\"thumbnail_type\":\"square\",\"limit\":\"8\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 243, 244, 0, '*', 0),
(650, 'mainmenu', '3 Columns Gallery Style No Space', '3-columns-gallery-style-no-space', '', 'portfolio/square/3-columns-gallery-style-no-space', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 632, 3, 10070, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_filter\":\"1\",\"category_id\":\"\",\"layout_type\":\"gallery_nospace\",\"columns\":\"3\",\"thumbnail_type\":\"square\",\"limit\":\"12\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 245, 246, 0, '*', 0),
(651, 'mainmenu', '4 Columns Gallery Style No Space', '4-columns-gallery-style-no-space', '', 'portfolio/square/4-columns-gallery-style-no-space', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 632, 3, 10070, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_filter\":\"1\",\"category_id\":\"\",\"layout_type\":\"gallery_nospace\",\"columns\":\"4\",\"thumbnail_type\":\"square\",\"limit\":\"12\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 247, 248, 0, '*', 0),
(652, 'mainmenu', 'Rectangular 2 Columns', 'rectangular-2-columns', '', 'portfolio/rectangular/rectangular-2-columns', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 633, 3, 10070, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_filter\":\"1\",\"category_id\":\"\",\"layout_type\":\"default\",\"columns\":\"2\",\"thumbnail_type\":\"rectangular\",\"limit\":\"8\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 251, 252, 0, '*', 0),
(653, 'mainmenu', 'Rectangular 3 Columns', 'rectangular-3-columns', '', 'portfolio/rectangular/rectangular-3-columns', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 633, 3, 10070, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_filter\":\"1\",\"category_id\":\"\",\"layout_type\":\"default\",\"columns\":\"3\",\"thumbnail_type\":\"rectangular\",\"limit\":\"12\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 253, 254, 0, '*', 0),
(654, 'mainmenu', 'Rectangular 4 Columns', 'rectangular-4-columns', '', 'portfolio/rectangular/rectangular-4-columns', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 633, 3, 10070, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_filter\":\"1\",\"category_id\":\"\",\"layout_type\":\"default\",\"columns\":\"4\",\"thumbnail_type\":\"rectangular\",\"limit\":\"12\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 255, 256, 0, '*', 0),
(655, 'mainmenu', '2 Columns Gallery Style', '2-columns-gallery-style', '', 'portfolio/rectangular/2-columns-gallery-style', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 633, 3, 10070, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_filter\":\"1\",\"category_id\":\"\",\"layout_type\":\"default\",\"columns\":\"2\",\"thumbnail_type\":\"rectangular\",\"limit\":\"8\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 257, 258, 0, '*', 0),
(656, 'mainmenu', '3 Columns Gallery Style', '3-columns-gallery-style', '', 'portfolio/rectangular/3-columns-gallery-style', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 633, 3, 10070, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_filter\":\"1\",\"category_id\":\"\",\"layout_type\":\"default\",\"columns\":\"3\",\"thumbnail_type\":\"rectangular\",\"limit\":\"12\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 259, 260, 0, '*', 0),
(657, 'mainmenu', '4 Columns Gallery Style', '4-columns-gallery-style', '', 'portfolio/rectangular/4-columns-gallery-style', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 633, 3, 10070, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_filter\":\"1\",\"category_id\":\"\",\"layout_type\":\"default\",\"columns\":\"4\",\"thumbnail_type\":\"rectangular\",\"limit\":\"12\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 261, 262, 0, '*', 0),
(658, 'mainmenu', ' 2 Columns Gallery Style No Space', '2-columns-gallery-style-no-space', '', 'portfolio/rectangular/2-columns-gallery-style-no-space', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 633, 3, 10070, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_filter\":\"1\",\"category_id\":\"\",\"layout_type\":\"gallery_nospace\",\"columns\":\"2\",\"thumbnail_type\":\"rectangular\",\"limit\":\"8\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 263, 264, 0, '*', 0),
(659, 'mainmenu', '3 Columns Gallery Style No Space', '3-columns-gallery-style-no-space', '', 'portfolio/rectangular/3-columns-gallery-style-no-space', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 633, 3, 10070, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_filter\":\"1\",\"category_id\":\"\",\"layout_type\":\"gallery_nospace\",\"columns\":\"3\",\"thumbnail_type\":\"rectangular\",\"limit\":\"12\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 265, 266, 0, '*', 0),
(660, 'mainmenu', '4 Columns Gallery Style No Space', '4-columns-gallery-style-no-space', '', 'portfolio/rectangular/4-columns-gallery-style-no-space', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 633, 3, 10070, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_filter\":\"1\",\"category_id\":\"\",\"layout_type\":\"gallery_nospace\",\"columns\":\"4\",\"thumbnail_type\":\"rectangular\",\"limit\":\"12\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 267, 268, 0, '*', 0),
(696, 'mainmenu', 'Medical', 'medical', '', 'home/medical', 'index.php?option=com_sppagebuilder&view=page&id=59', 'component', 1, 437, 2, 10004, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 26, 27, 0, '*', 0),
(697, 'mainmenu', 'Politics', 'politics', '', 'home/politics', 'index.php?option=com_sppagebuilder&view=page&id=60', 'component', 1, 437, 2, 10004, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 28, 29, 0, '*', 0),
(734, 'main', 'com_associations', 'multilingual-associations', '', 'multilingual-associations', 'index.php?option=com_associations', 'component', 1, 1, 1, 34, 0, '0000-00-00 00:00:00', 0, 1, 'class:associations', 0, '{}', 403, 404, 0, '*', 1),
(787, 'main', 'TCPDF', 'tcpdf', '', 'tcpdf', 'index.php?option=com_tcpdf', 'component', 1, 1, 1, 10069, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 405, 406, 0, '', 1),
(788, 'main', 'COM_VIRTUEMART', 'com-virtuemart', '', 'com-virtuemart', 'index.php?option=com_virtuemart', 'component', 1, 1, 1, 10040, 0, '0000-00-00 00:00:00', 0, 1, '../components/com_virtuemart/assets/images/vmgeneral/menu_icon.png', 0, '{}', 407, 432, 0, '', 1),
(789, 'main', 'COM_VIRTUEMART_CONTROL_PANEL', 'com-virtuemart-control-panel', '', 'com-virtuemart/com-virtuemart-control-panel', 'index.php?option=com_virtuemart&view=virtuemart', 'component', 1, 788, 2, 10040, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-report.png', 0, '{}', 408, 409, 0, '', 1),
(790, 'main', 'COM_VIRTUEMART_MENU_CATEGORIES', 'com-virtuemart-menu-categories', '', 'com-virtuemart/com-virtuemart-menu-categories', 'index.php?option=com_virtuemart&view=category', 'component', 1, 788, 2, 10040, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-categories.png', 0, '{}', 410, 411, 0, '', 1),
(791, 'main', 'COM_VIRTUEMART_MENU_PRODUCTS', 'com-virtuemart-menu-products', '', 'com-virtuemart/com-virtuemart-menu-products', 'index.php?option=com_virtuemart&view=product', 'component', 1, 788, 2, 10040, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-products.png', 0, '{}', 412, 413, 0, '', 1),
(792, 'main', 'COM_VIRTUEMART_MENU_ORDERS', 'com-virtuemart-menu-orders', '', 'com-virtuemart/com-virtuemart-menu-orders', 'index.php?option=com_virtuemart&view=orders', 'component', 1, 788, 2, 10040, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-orders.png', 0, '{}', 414, 415, 0, '', 1),
(793, 'main', 'COM_VIRTUEMART_MENU_REPORT', 'com-virtuemart-menu-report', '', 'com-virtuemart/com-virtuemart-menu-report', 'index.php?option=com_virtuemart&view=report', 'component', 1, 788, 2, 10040, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-report.png', 0, '{}', 416, 417, 0, '', 1),
(794, 'main', 'COM_VIRTUEMART_MENU_USERS', 'com-virtuemart-menu-users', '', 'com-virtuemart/com-virtuemart-menu-users', 'index.php?option=com_virtuemart&view=user', 'component', 1, 788, 2, 10040, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-shoppers.png', 0, '{}', 418, 419, 0, '', 1),
(795, 'main', 'COM_VIRTUEMART_MENU_MANUFACTURERS', 'com-virtuemart-menu-manufacturers', '', 'com-virtuemart/com-virtuemart-menu-manufacturers', 'index.php?option=com_virtuemart&view=manufacturer', 'component', 1, 788, 2, 10040, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-manufacturers.png', 0, '{}', 420, 421, 0, '', 1),
(796, 'main', 'COM_VIRTUEMART_MENU_STORE', 'com-virtuemart-menu-store', '', 'com-virtuemart/com-virtuemart-menu-store', 'index.php?option=com_virtuemart&view=user&task=editshop', 'component', 1, 788, 2, 10040, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-shop.png', 0, '{}', 422, 423, 0, '', 1),
(797, 'main', 'COM_VIRTUEMART_MENU_MEDIAFILES', 'com-virtuemart-menu-mediafiles', '', 'com-virtuemart/com-virtuemart-menu-mediafiles', 'index.php?option=com_virtuemart&view=media', 'component', 1, 788, 2, 10040, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-media.png', 0, '{}', 424, 425, 0, '', 1),
(798, 'main', 'COM_VIRTUEMART_MENU_SHIPMENTMETHODS', 'com-virtuemart-menu-shipmentmethods', '', 'com-virtuemart/com-virtuemart-menu-shipmentmethods', 'index.php?option=com_virtuemart&view=shipmentmethod', 'component', 1, 788, 2, 10040, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-shipmentmethods.png', 0, '{}', 426, 427, 0, '', 1),
(799, 'main', 'COM_VIRTUEMART_MENU_PAYMENTMETHODS', 'com-virtuemart-menu-paymentmethods', '', 'com-virtuemart/com-virtuemart-menu-paymentmethods', 'index.php?option=com_virtuemart&view=paymentmethod', 'component', 1, 788, 2, 10040, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-paymentmethods.png', 0, '{}', 428, 429, 0, '', 1),
(800, 'main', 'COM_VIRTUEMART_MENU_CONFIGURATION', 'com-virtuemart-menu-configuration', '', 'com-virtuemart/com-virtuemart-menu-configuration', 'index.php?option=com_virtuemart&view=config', 'component', 1, 788, 2, 10040, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-config.png', 0, '{}', 430, 431, 0, '', 1),
(801, 'main', 'VirtueMart AIO', 'virtuemart-aio', '', 'virtuemart-aio', 'index.php?option=com_virtuemart_allinone', 'component', 1, 1, 1, 10041, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 433, 434, 0, '', 1),
(802, 'main', 'AcyMailing', 'acymailing', '', 'acymailing', 'index.php?option=com_acymailing', 'component', 1, 1, 1, 10022, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_acymailing/images/icons/icon-16-acymailing.png', 0, '{}', 435, 450, 0, '', 1),
(803, 'main', 'Users', 'users', '', 'acymailing/users', 'index.php?option=com_acymailing&ctrl=subscriber', 'component', 1, 802, 2, 10022, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_acymailing/images/icons/icon-16-users.png', 0, '{}', 436, 437, 0, '', 1),
(804, 'main', 'Lists', 'lists', '', 'acymailing/lists', 'index.php?option=com_acymailing&ctrl=list', 'component', 1, 802, 2, 10022, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_acymailing/images/icons/icon-16-acylist.png', 0, '{}', 438, 439, 0, '', 1),
(805, 'main', 'Newsletters', 'newsletters', '', 'acymailing/newsletters', 'index.php?option=com_acymailing&ctrl=newsletter', 'component', 1, 802, 2, 10022, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_acymailing/images/icons/icon-16-newsletter.png', 0, '{}', 440, 441, 0, '', 1),
(806, 'main', 'Templates', 'templates', '', 'acymailing/templates', 'index.php?option=com_acymailing&ctrl=template', 'component', 1, 802, 2, 10022, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_acymailing/images/icons/icon-16-acytemplate.png', 0, '{}', 442, 443, 0, '', 1),
(807, 'main', 'Queue', 'queue', '', 'acymailing/queue', 'index.php?option=com_acymailing&ctrl=queue', 'component', 1, 802, 2, 10022, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_acymailing/images/icons/icon-16-process.png', 0, '{}', 444, 445, 0, '', 1),
(808, 'main', 'Statistics', 'statistics', '', 'acymailing/statistics', 'index.php?option=com_acymailing&ctrl=stats', 'component', 1, 802, 2, 10022, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_acymailing/images/icons/icon-16-stats.png', 0, '{}', 446, 447, 0, '', 1),
(809, 'main', 'Configuration', 'configuration', '', 'acymailing/configuration', 'index.php?option=com_acymailing&ctrl=cpanel', 'component', 1, 802, 2, 10022, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_acymailing/images/icons/icon-16-acyconfig.png', 0, '{}', 448, 449, 0, '', 1),
(812, 'main', 'COM_SPPAGEBUILDER', 'com-sppagebuilder', '', 'com-sppagebuilder', 'index.php?option=com_sppagebuilder', 'component', 1, 1, 1, 10004, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 451, 452, 0, '', 1),
(813, 'main', 'COM_SPSIMPLEPORTFOLIO', 'com-spsimpleportfolio', '', 'com-spsimpleportfolio', 'index.php?option=com_spsimpleportfolio', 'component', 1, 1, 1, 10070, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 453, 454, 0, '', 1);

-- --------------------------------------------------------

--
-- Table structure for table `#__menu_types`
--

DROP TABLE IF EXISTS `#__menu_types`;
CREATE TABLE `#__menu_types` (
  `id` int(10) UNSIGNED NOT NULL,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `menutype` varchar(24) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(48) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__menu_types`
--

INSERT INTO `#__menu_types` (`id`, `asset_id`, `menutype`, `title`, `description`, `client_id`) VALUES
(2, 0, 'usermenu', 'User Menu', 'A Menu for logged-in Users', 0),
(4, 0, 'mainmenu', 'Main Menu', 'Main Menu', 0),
(8, 0, 'partners', 'Our Partmers', '', 0),
(9, 0, 'quicklink', 'Quick Link', '', 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__messages`
--

DROP TABLE IF EXISTS `#__messages`;
CREATE TABLE `#__messages` (
  `message_id` int(10) UNSIGNED NOT NULL,
  `user_id_from` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `user_id_to` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `folder_id` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `date_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `priority` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `subject` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `message` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__messages_cfg`
--

DROP TABLE IF EXISTS `#__messages_cfg`;
CREATE TABLE `#__messages_cfg` (
  `user_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `cfg_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `cfg_value` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__modules`
--

DROP TABLE IF EXISTS `#__modules`;
CREATE TABLE `#__modules` (
  `id` int(11) NOT NULL,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `position` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `module` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `showtitle` tinyint(3) UNSIGNED NOT NULL DEFAULT '1',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_id` tinyint(4) NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__modules`
--

INSERT INTO `#__modules` (`id`, `asset_id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES
(2, 0, 'Login', '', '', 1, 'login', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_login', 1, 1, '', 1, '*'),
(3, 0, 'Popular Articles', '', '', 3, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_popular', 3, 1, '{\"count\":\"5\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\",\"automatic_title\":\"1\"}', 1, '*'),
(4, 0, 'Recently Added Articles', '', '', 4, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_latest', 3, 1, '{\"count\":\"5\",\"ordering\":\"c_dsc\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\",\"automatic_title\":\"1\"}', 1, '*'),
(8, 0, 'Toolbar', '', '', 1, 'toolbar', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_toolbar', 3, 1, '', 1, '*'),
(9, 0, 'Quick Icons', '', '', 1, 'icon', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_quickicon', 3, 1, '', 1, '*'),
(10, 0, 'Logged-in Users', '', '', 2, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_logged', 3, 1, '{\"count\":\"5\",\"name\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\",\"automatic_title\":\"1\"}', 1, '*'),
(12, 0, 'Admin Menu', '', '', 1, 'menu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 3, 1, '{\"layout\":\"\",\"moduleclass_sfx\":\"\",\"shownew\":\"1\",\"showhelp\":\"1\",\"cache\":\"0\"}', 1, '*'),
(13, 0, 'Admin Submenu', '', '', 1, 'submenu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_submenu', 3, 1, '', 1, '*'),
(14, 0, 'User Status', '', '', 2, 'status', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_status', 3, 1, '', 1, '*'),
(15, 0, 'Title', '', '', 1, 'title', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_title', 3, 1, '', 1, '*'),
(17, 185, 'Breadcrumbs', '', '', 1, 'breadcrumb', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_breadcrumbs', 1, 1, '{\"showHere\":\"1\",\"showHome\":\"1\",\"homeText\":\"\",\"showLast\":\"1\",\"separator\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"icon\":\"\",\"background_color\":\"\",\"color\":\"\",\"padding\":\"\",\"margin\":\"\"}', 0, '*'),
(35, 186, 'Search', '', '', 1, 'offcanvas', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_search', 1, 1, '{\"label\":\"\",\"width\":\"20\",\"text\":\"\",\"button\":\"0\",\"button_pos\":\"right\",\"imagebutton\":\"0\",\"button_text\":\"\",\"opensearch\":\"1\",\"opensearch_title\":\"\",\"set_itemid\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"icon\":\"\",\"background_color\":\"\",\"color\":\"\",\"padding\":\"\",\"margin\":\"\"}', 0, '*'),
(79, 0, 'Multilanguage status', '', '', 1, 'status', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 'mod_multilangstatus', 3, 1, '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', 1, '*'),
(86, 0, 'Joomla Version', '', '', 1, 'footer', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_version', 3, 1, '{\"format\":\"short\",\"product\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', 1, '*'),
(91, 181, 'SP Page Builder', '', '', 0, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_sppagebuilder_icons', 1, 1, '', 1, '*'),
(92, 182, 'SP Page Builder Admin Menu', '', '', 1, 'menu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_sppagebuilder_admin_menu', 1, 1, '', 1, '*'),
(94, 187, 'Bottom-1', '', '<p><img src=\"images/demo/bottom-logo.png\" alt=\"\" /></p>\r\n<p> </p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam,</p>\r\n<p>Tixon Inc ©</p>\r\n<p>5826 Baker Street, New York, USA</p>', 1, 'bottom1', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(95, 188, 'Latest News', '', '', 1, 'bottom2', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 'mod_articles_latest', 1, 1, '{\"catid\":[\"\"],\"count\":\"3\",\"show_featured\":\"\",\"ordering\":\"c_dsc\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"icon\":\"\",\"background_color\":\"\",\"color\":\"\",\"padding\":\"\",\"margin\":\"\"}', 0, '*'),
(96, 189, 'Our Partners', '', '', 1, 'bottom3', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 'mod_menu', 1, 1, '{\"menutype\":\"partners\",\"base\":\"\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"1\",\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"icon\":\"\",\"background_color\":\"\",\"color\":\"\",\"padding\":\"\",\"margin\":\"\"}', 0, '*'),
(97, 190, 'Quick Link', '', '', 1, 'bottom4', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 1, '{\"menutype\":\"quicklink\",\"base\":\"\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"1\",\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"icon\":\"\",\"background_color\":\"\",\"color\":\"\",\"padding\":\"\",\"margin\":\"\"}', 0, '*'),
(99, 203, 'Latest News', '', '', 2, 'right', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_latest', 1, 1, '{\"catid\":[\"79\"],\"count\":\"6\",\"show_featured\":\"\",\"ordering\":\"c_dsc\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"icon\":\"\",\"background_color\":\"\",\"color\":\"\",\"padding\":\"\",\"margin\":\"\"}', 0, '*'),
(100, 204, 'Search', '', '', 1, 'right', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_search', 1, 1, '{\"label\":\"\",\"width\":\"20\",\"text\":\"\",\"button\":\"0\",\"button_pos\":\"right\",\"imagebutton\":\"0\",\"button_text\":\"\",\"opensearch\":\"1\",\"opensearch_title\":\"\",\"set_itemid\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"icon\":\"\",\"background_color\":\"\",\"color\":\"\",\"padding\":\"\",\"margin\":\"\"}', 0, '*'),
(101, 205, 'Information', '', '', 3, 'right', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 1, '{\"menutype\":\"partners\",\"base\":\"\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"1\",\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"icon\":\"\",\"background_color\":\"\",\"color\":\"\",\"padding\":\"\",\"margin\":\"\"}', 0, '*'),
(102, 206, 'Search', '', '', 7, 'left', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_search', 1, 1, '{\"label\":\"\",\"width\":\"20\",\"text\":\"\",\"button\":\"0\",\"button_pos\":\"right\",\"imagebutton\":\"0\",\"button_text\":\"\",\"opensearch\":\"1\",\"opensearch_title\":\"\",\"set_itemid\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(103, 207, 'Latest News', '', '', 6, 'left', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_latest', 1, 1, '{\"catid\":[\"79\"],\"count\":\"6\",\"show_featured\":\"\",\"ordering\":\"c_dsc\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"icon\":\"\",\"background_color\":\"\",\"color\":\"\",\"padding\":\"\",\"margin\":\"\"}', 0, '*'),
(104, 208, 'Information', '', '', 9, 'left', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 1, '{\"menutype\":\"partners\",\"base\":\"\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"1\",\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"icon\":\"\",\"background_color\":\"\",\"color\":\"\",\"padding\":\"\",\"margin\":\"\"}', 0, '*'),
(105, 209, 'Off Canvas Menu', '', '', 1, 'offcanvas', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 0, '{\"menutype\":\"mainmenu\",\"base\":\"\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"1\",\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"icon\":\"\",\"background_color\":\"\",\"color\":\"\",\"padding\":\"\",\"margin\":\"\"}', 0, '*'),
(110, 215, 'NEWSLETTER', '', '', 1, 'bottom3', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_acymailing', 1, 1, '{\"effect\":\"normal\",\"lists\":\"None\",\"hiddenlists\":\"All\",\"displaymode\":\"tableless\",\"listschecked\":\"All\",\"checkmode\":\"0\",\"dropdown\":\"0\",\"overlay\":\"0\",\"link\":\"0\",\"listposition\":\"before\",\"customfields\":\"email\",\"nametext\":\"\",\"emailtext\":\"\",\"fieldsize\":\"100%\",\"displayfields\":\"0\",\"introtext\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. \",\"finaltext\":\"\",\"showsubscribe\":\"1\",\"subscribetext\":\"\",\"subscribetextreg\":\"\",\"showunsubscribe\":\"0\",\"unsubscribetext\":\"\",\"redirectmode\":\"0\",\"redirectlink\":\"\",\"redirectlinkunsub\":\"\",\"showterms\":\"0\",\"showtermspopup\":\"1\",\"termscontent\":\"0\",\"mootoolsintro\":\"\",\"mootoolsbutton\":\"\",\"boxwidth\":\"250\",\"boxheight\":\"200\",\"moduleclass_sfx\":\"\",\"textalign\":\"none\",\"loggedin\":\"1\",\"cache\":\"0\",\"includejs\":\"header\",\"itemid\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(111, 216, 'FLICKER GALLERY', '', '', 1, 'bottom2', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_sp_flickrgallery', 1, 1, '{\"flickr_id\":\"122684712@N04\",\"flickr_setid\":\"72157650430054357\",\"columns\":\"4\",\"limit\":\"8\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(112, 226, 'VM - Administrator Module', '', '', 5, 'menu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_vmmenu', 3, 1, '', 1, '*'),
(113, 227, 'VM - Currencies Selector', '', '', 5, 'position-4', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_virtuemart_currencies', 1, 1, '', 0, '*'),
(114, 228, 'Latest products', '', '', 3, 'position-4', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_virtuemart_product', 1, 1, '{\"layout\":\"default\",\"product_group\":\"latest\",\"max_items\":\"4\",\"products_per_row\":\"4\",\"display_style\":\"list\",\"show_price\":\"1\",\"show_addtocart\":\"1\",\"headerText\":\"\",\"footerText\":\"\",\"filter_category\":\"0\",\"virtuemart_category_id\":\"0\",\"vmcache\":\"0\",\"vmcachetime\":\"300\",\"cache\":\"1\",\"moduleclass_sfx\":\"\",\"class_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(115, 229, 'VM - Search in Shop', '', '', 2, 'position-4', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_virtuemart_search', 1, 1, '', 0, '*'),
(116, 230, 'VM - Manufacturer', '', '', 8, 'position-4', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_virtuemart_manufacturer', 1, 1, '', 0, '*'),
(117, 231, 'VM - Shopping cart', '', '', 1, 'position-4', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_virtuemart_cart', 1, 1, '{\"moduleclass_sfx\":\"\",\"show_price\":\"1\",\"show_product_list\":\"1\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(118, 232, 'Shop Category', '', '', 4, 'left', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_virtuemart_category', 1, 1, '{\"Parent_Category_id\":\"0\",\"level\":\"1\",\"layout\":\"default\",\"cache\":\"1\",\"moduleclass_sfx\":\" tixon-shop-category left-title\",\"class_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(119, 233, 'VM Currency Selector', '', '', 7, 'left', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 'mod_virtuemart_currencies', 1, 1, '{\"text_before\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam,\",\"product_currency\":\"Us Dollar\",\"cache\":\"0\",\"moduleclass_sfx\":\" tixon-currency-selector left-title\",\"class_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(120, 234, 'VM Manufacturers', '', '', 8, 'left', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 'mod_virtuemart_manufacturer', 1, 1, '{\"show\":\"text\",\"display_style\":\"list\",\"manufacturers_per_row\":\"1\",\"headerText\":\"\",\"footerText\":\"\",\"cache\":\"1\",\"moduleclass_sfx\":\" tixon-manufacturers left-title\",\"class_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(121, 235, 'Top Products', '', '', 8, 'left', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_virtuemart_product', 1, 1, '{\"layout\":\"single\",\"product_group\":\"topten\",\"max_items\":\"5\",\"products_per_row\":\"2\",\"display_style\":\"div\",\"show_price\":\"1\",\"show_addtocart\":\"0\",\"headerText\":\"\",\"footerText\":\"\",\"filter_category\":\"0\",\"virtuemart_category_id\":\"5\",\"vmcache\":\"1\",\"vmcachetime\":\"300\",\"cache\":\"0\",\"moduleclass_sfx\":\" tixon-shop-products left-title\",\"class_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(122, 236, 'Search Product', '', '', 2, 'left', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_virtuemart_search', 1, 1, '{\"width\":\"20\",\"text\":\"\",\"filter_category\":\"0\",\"button\":\"0\",\"button_pos\":\"right\",\"imagebutton\":\"0\",\"button_text\":\"\",\"set_itemid\":\"\",\"moduleclass_sfx\":\"tixon-search-products left-title\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(123, 237, 'Shopping Cart', '', '', 2, 'left', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_virtuemart_cart', 1, 1, '{\"moduleclass_sfx\":\"left-title tixon-shopping-cart\",\"show_price\":\"1\",\"show_product_list\":\"1\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(124, 238, 'VM Shopping Cart', '', '', 1, 'menu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_virtuemart_cart', 1, 0, '{\"moduleclass_sfx\":\"left-title tixon-shopping-cart\",\"show_price\":\"1\",\"show_product_list\":\"1\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(125, 243, 'GET IN TOUCH', '', '<p><strong>Email:</strong> coffee[at]tixon.com</p>\r\n<p><strong>Phone:</strong> +44 6745 734-472</p>\r\n<p><strong>Fax:</strong> +44 6745 734-473</p>\r\n<p><strong>Website:</strong> www.tixon.com</p>\r\n<p><strong>Address:</strong> 5826 Baker Street, New York, USA</p>', 1, 'bottom3', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(126, 244, 'Recent Products 2', '', '', 1, 'mega-menu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 'mod_virtuemart_product', 1, 1, '{\"layout\":\"default\",\"product_group\":\"latest\",\"max_items\":\"4\",\"products_per_row\":\"1\",\"display_style\":\"list\",\"show_price\":\"1\",\"show_addtocart\":\"1\",\"headerText\":\"\",\"footerText\":\"\",\"filter_category\":\"0\",\"virtuemart_category_id\":\"0\",\"vmcache\":\"0\",\"vmcachetime\":\"300\",\"cache\":\"1\",\"moduleclass_sfx\":\"tixon-shop-products menu-products\",\"class_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(127, 245, 'Recent Products', '', '', 2, 'mega-menu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_virtuemart_product', 1, 1, '{\"layout\":\"single\",\"product_group\":\"random\",\"max_items\":\"4\",\"products_per_row\":\"2\",\"display_style\":\"div\",\"show_price\":\"1\",\"show_addtocart\":\"0\",\"headerText\":\"\",\"footerText\":\"\",\"filter_category\":\"0\",\"virtuemart_category_id\":\"5\",\"vmcache\":\"1\",\"vmcachetime\":\"300\",\"cache\":\"0\",\"moduleclass_sfx\":\" tixon-shop-products menu-products\",\"class_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(128, 247, 'Menu Add', '', '', 1, 'mega-menu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_banners', 1, 0, '{\"target\":\"1\",\"count\":5,\"cid\":\"0\",\"catid\":[\"88\"],\"tag_search\":\"0\",\"ordering\":\"0\",\"header_text\":\"\",\"footer_text\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(129, 256, 'Portfolio Module', '', '', 1, 'pagebuilder', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_spsimpleportfolio', 1, 1, '{\"show_filter\":\"0\",\"category_id\":\"87\",\"layout_type\":\"gallery_space\",\"columns\":\"4\",\"thumbnail_type\":\"square\",\"limit\":\"12\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(130, 257, 'Portfolio Module -  Construct  Portfolio', '', '', 1, 'pagebuilder', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_spsimpleportfolio', 1, 1, '{\"show_filter\":\"0\",\"category_id\":\"85\",\"layout_type\":\"default\",\"columns\":\"3\",\"thumbnail_type\":\"square\",\"limit\":\"9\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(131, 259, 'Portfolio Module -  Medical  Portfolio', '', '', 1, 'pagebuilder', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', -2, 'mod_spsimpleportfolio', 1, 1, '{\"show_filter\":\"0\",\"category_id\":\"89\",\"layout_type\":\"gallery_space\",\"columns\":\"3\",\"thumbnail_type\":\"square\",\"limit\":\"6\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(132, 260, 'Portfolio Module - Medical Portfolio', '', '', 1, 'pagebuilder', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_spsimpleportfolio', 1, 1, '{\"show_filter\":\"0\",\"category_id\":\"89\",\"layout_type\":\"default\",\"columns\":\"3\",\"thumbnail_type\":\"square\",\"limit\":\"9\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(133, 261, 'SP Page Builder', '', '', 0, '', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 'mod_sppagebuilder', 1, 1, '', 0, '*');

-- --------------------------------------------------------

--
-- Table structure for table `#__modules_menu`
--

DROP TABLE IF EXISTS `#__modules_menu`;
CREATE TABLE `#__modules_menu` (
  `moduleid` int(11) NOT NULL DEFAULT '0',
  `menuid` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__modules_menu`
--

INSERT INTO `#__modules_menu` (`moduleid`, `menuid`) VALUES
(1, 101),
(2, 0),
(3, 0),
(4, 0),
(6, 0),
(7, 0),
(8, 0),
(9, 0),
(10, 0),
(12, 0),
(13, 0),
(14, 0),
(15, 0),
(17, 0),
(20, 0),
(22, 234),
(22, 238),
(22, 242),
(22, 243),
(22, 244),
(22, 296),
(22, 399),
(22, 400),
(25, 294),
(26, -463),
(26, -462),
(26, -433),
(26, -432),
(26, -431),
(26, -430),
(26, -429),
(26, -427),
(26, -400),
(26, -399),
(26, -296),
(26, -244),
(26, -243),
(26, -242),
(26, -238),
(26, -234),
(32, 309),
(35, 0),
(45, 303),
(57, 238),
(57, 427),
(57, 429),
(57, 430),
(57, 431),
(57, 432),
(57, 433),
(57, 462),
(57, 463),
(79, 0),
(86, 0),
(87, 238),
(87, 427),
(87, 429),
(87, 430),
(87, 431),
(87, 432),
(87, 433),
(87, 462),
(87, 463),
(91, 0),
(92, 0),
(94, 0),
(95, 0),
(96, 0),
(97, 0),
(99, 492),
(100, 492),
(101, 492),
(102, 493),
(103, 493),
(104, 493),
(105, 0),
(110, -542),
(111, 0),
(112, 0),
(113, 0),
(114, 0),
(115, 0),
(116, 0),
(117, 0),
(118, 543),
(118, 566),
(118, 567),
(118, 568),
(118, 573),
(118, 591),
(118, 595),
(118, 596),
(118, 597),
(118, 598),
(118, 599),
(118, 600),
(118, 601),
(118, 602),
(118, 603),
(118, 604),
(119, 543),
(120, 543),
(120, 566),
(120, 567),
(120, 568),
(120, 573),
(120, 591),
(120, 595),
(120, 596),
(120, 597),
(120, 598),
(120, 599),
(120, 600),
(120, 601),
(120, 602),
(120, 603),
(120, 604),
(121, 543),
(121, 566),
(121, 567),
(121, 568),
(121, 573),
(121, 591),
(121, 595),
(121, 596),
(121, 597),
(121, 598),
(121, 599),
(121, 600),
(121, 601),
(121, 602),
(121, 603),
(121, 604),
(122, 543),
(122, 566),
(122, 567),
(122, 568),
(122, 573),
(122, 591),
(122, 595),
(122, 596),
(122, 597),
(122, 598),
(122, 599),
(122, 600),
(122, 601),
(122, 602),
(122, 603),
(122, 604),
(123, 543),
(123, 566),
(123, 567),
(123, 568),
(123, 573),
(123, 591),
(123, 595),
(123, 596),
(123, 597),
(123, 598),
(123, 599),
(123, 600),
(123, 601),
(123, 602),
(123, 603),
(123, 604),
(124, 0),
(125, 542),
(126, 0),
(127, 543),
(127, 566),
(127, 567),
(127, 568),
(127, 573),
(127, 591),
(127, 595),
(127, 596),
(127, 597),
(127, 598),
(127, 599),
(127, 600),
(127, 601),
(127, 602),
(127, 603),
(127, 604),
(128, 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__newsfeeds`
--

DROP TABLE IF EXISTS `#__newsfeeds`;
CREATE TABLE `#__newsfeeds` (
  `catid` int(11) NOT NULL DEFAULT '0',
  `id` int(10) UNSIGNED NOT NULL,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `link` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `numarticles` int(10) UNSIGNED NOT NULL DEFAULT '1',
  `cache_time` int(10) UNSIGNED NOT NULL DEFAULT '3600',
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `rtl` tinyint(4) NOT NULL DEFAULT '0',
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `xreference` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` int(10) UNSIGNED NOT NULL DEFAULT '1',
  `hits` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `images` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__newsfeeds`
--

INSERT INTO `#__newsfeeds` (`catid`, `id`, `name`, `alias`, `link`, `published`, `numarticles`, `cache_time`, `checked_out`, `checked_out_time`, `ordering`, `rtl`, `access`, `language`, `params`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `metakey`, `metadesc`, `metadata`, `xreference`, `publish_up`, `publish_down`, `description`, `version`, `hits`, `images`) VALUES
(17, 1, 'Joomla! Announcements', 'joomla-announcements', 'http://feeds.joomla.org/JoomlaAnnouncements', 1, 5, 3600, 0, '0000-00-00 00:00:00', 1, 1, 1, 'en-GB', '{\"show_feed_image\":\"\",\"show_feed_description\":\"\",\"show_item_description\":\"\",\"feed_character_count\":\"0\",\"newsfeed_layout\":\"\",\"feed_display_order\":\"\"}', '2018-02-22 06:56:02', 587, 'Joomla', '0000-00-00 00:00:00', 0, '', '', '{\"robots\":\"\",\"rights\":\"\"}', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 1, 1, ''),
(17, 2, 'New Joomla! Extensions', 'new-joomla-extensions', 'http://feeds.joomla.org/JoomlaExtensions', 1, 5, 3600, 0, '0000-00-00 00:00:00', 4, 1, 1, 'en-GB', '{\"show_feed_image\":\"\",\"show_feed_description\":\"\",\"show_item_description\":\"\",\"feed_character_count\":\"0\",\"newsfeed_layout\":\"\",\"feed_display_order\":\"\"}', '2018-02-22 06:56:02', 587, 'Joomla', '0000-00-00 00:00:00', 0, '', '', '{\"robots\":\"\",\"rights\":\"\"}', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 1, 0, ''),
(17, 3, 'Joomla! Security News', 'joomla-security-news', 'http://feeds.joomla.org/JoomlaSecurityNews', 1, 5, 3600, 0, '0000-00-00 00:00:00', 2, 1, 1, 'en-GB', '{\"show_feed_image\":\"\",\"show_feed_description\":\"\",\"show_item_description\":\"\",\"feed_character_count\":\"0\",\"newsfeed_layout\":\"\",\"feed_display_order\":\"\"}', '2018-02-22 06:56:02', 587, 'Joomla', '0000-00-00 00:00:00', 0, '', '', '{\"robots\":\"\",\"rights\":\"\"}', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 1, 0, ''),
(17, 4, 'Joomla! Connect', 'joomla-connect', 'http://feeds.joomla.org/JoomlaConnect', 1, 5, 3600, 0, '0000-00-00 00:00:00', 3, 1, 1, 'en-GB', '{\"show_feed_image\":\"\",\"show_feed_description\":\"\",\"show_item_description\":\"\",\"feed_character_count\":\"0\",\"newsfeed_layout\":\"\",\"feed_display_order\":\"\"}', '2018-02-22 06:56:02', 587, 'Joomla', '0000-00-00 00:00:00', 0, '', '', '{\"robots\":\"\",\"rights\":\"\"}', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 1, 2, '');

-- --------------------------------------------------------

--
-- Table structure for table `#__overrider`
--

DROP TABLE IF EXISTS `#__overrider`;
CREATE TABLE `#__overrider` (
  `id` int(10) NOT NULL COMMENT 'Primary Key',
  `constant` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `string` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__postinstall_messages`
--

DROP TABLE IF EXISTS `#__postinstall_messages`;
CREATE TABLE `#__postinstall_messages` (
  `postinstall_message_id` bigint(20) UNSIGNED NOT NULL,
  `extension_id` bigint(20) NOT NULL DEFAULT '700' COMMENT 'FK to #__extensions',
  `title_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Lang key for the title',
  `description_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Lang key for description',
  `action_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `language_extension` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'com_postinstall' COMMENT 'Extension holding lang keys',
  `language_client_id` tinyint(3) NOT NULL DEFAULT '1',
  `type` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'link' COMMENT 'Message type - message, link, action',
  `action_file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT 'RAD URI to the PHP file containing action method',
  `action` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT 'Action method name or URL',
  `condition_file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'RAD URI to file holding display condition method',
  `condition_method` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Display condition method, must return boolean',
  `version_introduced` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '3.2.0' COMMENT 'Version when this message was introduced',
  `enabled` tinyint(3) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__postinstall_messages`
--

INSERT INTO `#__postinstall_messages` (`postinstall_message_id`, `extension_id`, `title_key`, `description_key`, `action_key`, `language_extension`, `language_client_id`, `type`, `action_file`, `action`, `condition_file`, `condition_method`, `version_introduced`, `enabled`) VALUES
(1, 700, 'PLG_TWOFACTORAUTH_TOTP_POSTINSTALL_TITLE', 'PLG_TWOFACTORAUTH_TOTP_POSTINSTALL_BODY', 'PLG_TWOFACTORAUTH_TOTP_POSTINSTALL_ACTION', 'plg_twofactorauth_totp', 1, 'action', 'site://plugins/twofactorauth/totp/postinstall/actions.php', 'twofactorauth_postinstall_action', 'site://plugins/twofactorauth/totp/postinstall/actions.php', 'twofactorauth_postinstall_condition', '3.2.0', 1),
(2, 700, 'COM_CPANEL_MSG_EACCELERATOR_TITLE', 'COM_CPANEL_MSG_EACCELERATOR_BODY', 'COM_CPANEL_MSG_EACCELERATOR_BUTTON', 'com_cpanel', 1, 'action', 'admin://components/com_admin/postinstall/eaccelerator.php', 'admin_postinstall_eaccelerator_action', 'admin://components/com_admin/postinstall/eaccelerator.php', 'admin_postinstall_eaccelerator_condition', '3.2.0', 1),
(3, 700, 'COM_CPANEL_WELCOME_BEGINNERS_TITLE', 'COM_CPANEL_WELCOME_BEGINNERS_MESSAGE', '', 'com_cpanel', 1, 'message', '', '', '', '', '3.2.0', 1),
(5, 700, 'COM_CPANEL_MSG_HTACCESS_TITLE', 'COM_CPANEL_MSG_HTACCESS_BODY', '', 'com_cpanel', 1, 'message', '', '', 'admin://components/com_admin/postinstall/htaccess.php', 'admin_postinstall_htaccess_condition', '3.4.0', 1),
(6, 700, 'COM_CPANEL_MSG_ROBOTS_TITLE', 'COM_CPANEL_MSG_ROBOTS_BODY', '', 'com_cpanel', 1, 'message', '', '', '', '', '3.3.0', 1),
(7, 700, 'COM_CPANEL_MSG_LANGUAGEACCESS340_TITLE', 'COM_CPANEL_MSG_LANGUAGEACCESS340_BODY', '', 'com_cpanel', 1, 'message', '', '', 'admin://components/com_admin/postinstall/languageaccess340.php', 'admin_postinstall_languageaccess340_condition', '3.4.1', 1),
(8, 700, 'COM_CPANEL_MSG_STATS_COLLECTION_TITLE', 'COM_CPANEL_MSG_STATS_COLLECTION_BODY', '', 'com_cpanel', 1, 'message', '', '', 'admin://components/com_admin/postinstall/statscollection.php', 'admin_postinstall_statscollection_condition', '3.5.0', 1),
(9, 700, 'PLG_SYSTEM_UPDATENOTIFICATION_POSTINSTALL_UPDATECACHETIME', 'PLG_SYSTEM_UPDATENOTIFICATION_POSTINSTALL_UPDATECACHETIME_BODY', 'PLG_SYSTEM_UPDATENOTIFICATION_POSTINSTALL_UPDATECACHETIME_ACTION', 'plg_system_updatenotification', 1, 'action', 'site://plugins/system/updatenotification/postinstall/updatecachetime.php', 'updatecachetime_postinstall_action', 'site://plugins/system/updatenotification/postinstall/updatecachetime.php', 'updatecachetime_postinstall_condition', '3.6.3', 1),
(10, 700, 'COM_CPANEL_MSG_JOOMLA40_PRE_CHECKS_TITLE', 'COM_CPANEL_MSG_JOOMLA40_PRE_CHECKS_BODY', '', 'com_cpanel', 1, 'message', '', '', 'admin://components/com_admin/postinstall/joomla40checks.php', 'admin_postinstall_joomla40checks_condition', '3.7.0', 1),
(11, 700, 'TPL_HATHOR_MESSAGE_POSTINSTALL_TITLE', 'TPL_HATHOR_MESSAGE_POSTINSTALL_BODY', 'TPL_HATHOR_MESSAGE_POSTINSTALL_ACTION', 'tpl_hathor', 1, 'action', 'admin://templates/hathor/postinstall/hathormessage.php', 'hathormessage_postinstall_action', 'admin://templates/hathor/postinstall/hathormessage.php', 'hathormessage_postinstall_condition', '3.7.0', 1);

-- --------------------------------------------------------

--
-- Table structure for table `#__schemas`
--

DROP TABLE IF EXISTS `#__schemas`;
CREATE TABLE `#__schemas` (
  `extension_id` int(11) NOT NULL,
  `version_id` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__schemas`
--

INSERT INTO `#__schemas` (`extension_id`, `version_id`) VALUES
(700, '3.8.4-2018-01-16'),
(10004, '3.1-2018-01-01'),
(10070, '1.5-2017-14-09');

-- --------------------------------------------------------

--
-- Table structure for table `#__spmedia`
--

DROP TABLE IF EXISTS `#__spmedia`;
CREATE TABLE `#__spmedia` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `title` varchar(255) NOT NULL,
  `path` varchar(255) NOT NULL,
  `thumb` varchar(255) NOT NULL,
  `alt` varchar(255) NOT NULL,
  `caption` varchar(2048) NOT NULL,
  `description` mediumtext NOT NULL,
  `type` varchar(100) NOT NULL DEFAULT 'image',
  `extension` varchar(100) NOT NULL,
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` bigint(20) NOT NULL DEFAULT '0',
  `modified_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__sppagebuilder`
--

DROP TABLE IF EXISTS `#__sppagebuilder`;
CREATE TABLE `#__sppagebuilder` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `asset_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `text` mediumtext NOT NULL,
  `extension` varchar(255) NOT NULL DEFAULT 'com_sppagebuilder',
  `extension_view` varchar(255) NOT NULL DEFAULT 'page',
  `view_id` bigint(20) NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `published` tinyint(3) NOT NULL DEFAULT '1',
  `catid` int(10) NOT NULL,
  `access` int(10) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL,
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` bigint(20) NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) NOT NULL DEFAULT '0',
  `checked_out` int(10) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `og_title` varchar(255) NOT NULL,
  `og_image` varchar(255) NOT NULL,
  `og_description` varchar(255) NOT NULL,
  `language` char(7) NOT NULL,
  `hits` bigint(20) NOT NULL DEFAULT '0',
  `css` longtext NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__sppagebuilder`
--

INSERT INTO `#__sppagebuilder` (`id`, `asset_id`, `title`, `text`, `extension`, `extension_view`, `view_id`, `active`, `published`, `catid`, `access`, `ordering`, `created_on`, `created_by`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `og_title`, `og_image`, `og_description`, `language`, `hits`, `css`) VALUES
(1, 264, 'Home', '[{\"layout\":12,\"settings\":{\"title\":\"\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"tixon-slider\",\"padding\":\"\",\"margin\":\"\",\"fullscreen\":1},\"id\":1480329814,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{},\"id\":1480329815,\"addons\":[{\"name\":\"slideshow_full\",\"title\":\"Slideshow (Full Width)\",\"id\":1480329816,\"settings\":{\"layout\":\"layout1\",\"autoplay\":\"0\",\"controllers\":\"1\",\"arrows\":\"1\",\"background\":\"\",\"color\":\"\",\"class\":\"\",\"sp_slideshow_full_item\":[{\"title\":\"A THEME FOR\",\"sub_title\":\"DIFFERENT\",\"content\":\"100% RESPONSIVE\",\"bg\":\"images/demo/slider/slider1.jpg\",\"button_text\":\"\",\"button_url\":\"\",\"button_size\":\"\",\"button_type\":\"default\",\"button_before_icon\":\"\",\"button_after_icon\":\"\",\"title_animation\":\"zoomIn sppb-wow zoomIn sppb-wow zoomIn sppb-wow zoomIn sppb-wow zoomIn sppb-wow zoomIn sppb-wow zoomIn sppb-wow zoomIn\",\"title_animationduration\":\"\",\"title_animationdelay\":\"\",\"subtitle_animation\":\"fadeInLeftBig sppb-wow fadeInLeftBig sppb-wow fadeInLeftBig sppb-wow fadeInLeftBig sppb-wow fadeInLeftBig sppb-wow fadeInLeftBig sppb-wow fadeInLeftBig sppb-wow fadeInLeftBig\",\"subtitle_animationduration\":\"\",\"subtitle_animationdelay\":\"200\",\"cotent_animation\":\"fadeInRightBig sppb-wow fadeInRightBig sppb-wow fadeInRightBig sppb-wow fadeInRightBig sppb-wow fadeInRightBig sppb-wow fadeInRightBig sppb-wow fadeInRightBig sppb-wow fadeInRightBig\",\"cotent_animationduration\":\"\",\"cotent_animationdelay\":\"400\",\"button_animation\":\"fadeInUpBig sppb-wow fadeInUpBig sppb-wow fadeInUpBig sppb-wow fadeInUpBig sppb-wow fadeInUpBig sppb-wow fadeInUpBig sppb-wow fadeInUpBig sppb-wow fadeInUpBig\",\"button_animationduration\":\"\",\"button_animationdelay\":\"\"},{\"title\":\"THINK ABOUT\",\"sub_title\":\"QUALITY\",\"content\":\"THE BEAUTY OF DESIGN\",\"bg\":\"images/demo/slider/slider2.jpg\",\"button_text\":\"\",\"button_url\":\"\",\"button_size\":\"\",\"button_type\":\"default\",\"button_before_icon\":\"\",\"button_after_icon\":\"\",\"title_animation\":\"fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp\",\"title_animationduration\":\"\",\"title_animationdelay\":\"\",\"subtitle_animation\":\"fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp\",\"subtitle_animationduration\":\"\",\"subtitle_animationdelay\":\"200\",\"cotent_animation\":\"fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp\",\"cotent_animationduration\":\"\",\"cotent_animationdelay\":\"400\",\"button_animation\":\"\",\"button_animationduration\":\"\",\"button_animationdelay\":\"\"},{\"title\":\"CREATIVE SOLUTIONS\",\"sub_title\":\"CREATIVITY\",\"content\":\"WEBSITES LOOK PERFECT\",\"bg\":\"images/demo/slider/slider-3.jpg\",\"button_text\":\"\",\"button_url\":\"\",\"button_size\":\"\",\"button_type\":\"default\",\"button_before_icon\":\"\",\"button_after_icon\":\"\",\"title_animation\":\"zoomIn sppb-wow zoomIn sppb-wow zoomIn sppb-wow zoomIn sppb-wow zoomIn sppb-wow zoomIn sppb-wow zoomIn sppb-wow zoomIn\",\"title_animationduration\":\"\",\"title_animationdelay\":\"0\",\"subtitle_animation\":\"flipInX sppb-wow flipInX sppb-wow flipInX sppb-wow flipInX sppb-wow flipInX sppb-wow flipInX sppb-wow flipInX sppb-wow flipInX\",\"subtitle_animationduration\":\"\",\"subtitle_animationdelay\":\"200\",\"cotent_animation\":\"fadeInUpBig sppb-wow fadeInUpBig sppb-wow fadeInUpBig sppb-wow fadeInUpBig sppb-wow fadeInUpBig sppb-wow fadeInUpBig sppb-wow fadeInUpBig sppb-wow fadeInUpBig\",\"cotent_animationduration\":\"\",\"cotent_animationdelay\":\"400\",\"button_animation\":\"\",\"button_animationduration\":\"\",\"button_animationdelay\":\"\"}],\"dynamicId\":1480329816},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"3,3,3,3\",\"settings\":{\"title_fontweight\":\"\",\"fullscreen\":0,\"margin\":{\"md\":\"90px 0 90px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"class\":\"tixon-features\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontsize\":\"\",\"title\":\"\",\"instFormId\":1480329817,\"columns_align_center\":0,\"no_gutter\":0,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1480329817,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-3\",\"settings\":{\"class\":\"\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"fadeInDown\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1480329818,\"addons\":[{\"name\":\"feature\",\"title\":\"Feature Box\",\"id\":1480329819,\"settings\":{\"title\":\"CLEAN & TRENDY DESIGN\",\"heading_selector\":\"h3\",\"title_fontsize\":\"16\",\"title_fontweight\":\"500\",\"title_text_color\":\"#38434a\",\"title_margin\":\"20px 0 25px 0\",\"title_url\":\"\",\"title_position\":\"after\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_type\":\"linea_icon\",\"icon_name\":\"fa-laptop\",\"linea_icon_name\":\"icon-basic-helm\",\"icon_size\":\"70\",\"icon_color\":\"\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"\",\"icon_margin_bottom\":\"\",\"icon_padding\":\"\",\"text\":\"Sirloin pork loine beefb andoe uillen capicola shank swine\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"class\":\"\",\"animationdelay\":200,\"animationduration\":\"\",\"animation\":\"fadeInDown\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1480329820,\"addons\":[{\"name\":\"feature\",\"title\":\"Feature Box\",\"id\":1480329821,\"settings\":{\"title\":\"UNLIMITED OPTIONS\",\"heading_selector\":\"h3\",\"title_fontsize\":\"16\",\"title_fontweight\":\"500\",\"title_text_color\":\"#38434a\",\"title_margin\":\"20px 0 25px 0\",\"title_url\":\"\",\"title_position\":\"after\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_type\":\"linea_icon\",\"icon_name\":\"fa-laptop\",\"linea_icon_name\":\"icon-basic-lightbulb\",\"icon_size\":\"70\",\"icon_color\":\"\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"0\",\"icon_margin_bottom\":\"\",\"icon_padding\":\"\",\"text\":\"Jowl salami leberkas turkey pork brisket meatball turducken lank\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"class\":\"\",\"animationdelay\":400,\"animationduration\":\"\",\"animation\":\"fadeInDown\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1480329822,\"addons\":[{\"name\":\"feature\",\"title\":\"Feature Box\",\"id\":1480329823,\"settings\":{\"title\":\"A TOUCH OF INDIVIDUALITY\",\"heading_selector\":\"h3\",\"title_fontsize\":\"16\",\"title_fontweight\":\"500\",\"title_text_color\":\"#38434a\",\"title_margin\":\"20px 0 25px 0\",\"title_url\":\"\",\"title_position\":\"after\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_type\":\"linea_icon\",\"icon_name\":\"fa-laptop\",\"linea_icon_name\":\"icon-basic-chronometer\",\"icon_size\":\"70\",\"icon_color\":\"\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"0\",\"icon_margin_bottom\":\"\",\"icon_padding\":\"\",\"text\":\"Sirloin pork loine beefb andoe uillen capicola shank swine\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3 active-column-parent\",\"settings\":{\"class\":\"\",\"animationdelay\":600,\"animationduration\":\"\",\"animation\":\"fadeInDown\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1480329824,\"addons\":[{\"name\":\"feature\",\"title\":\"Feature Box\",\"id\":1480329825,\"settings\":{\"title\":\"BASED ON NEGOTIATIONS\",\"heading_selector\":\"h3\",\"title_fontsize\":\"16\",\"title_fontweight\":\"500\",\"title_text_color\":\"#38434a\",\"title_margin\":\"20px 0 25px 0\",\"title_url\":\"\",\"title_position\":\"after\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_type\":\"linea_icon\",\"icon_name\":\"fa-laptop\",\"linea_icon_name\":\"icon-basic-headset\",\"icon_size\":\"70\",\"icon_color\":\"\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"0\",\"icon_margin_bottom\":\"\",\"icon_padding\":\"\",\"text\":\"Sirloin pork loine beefb andoe uillen capicola shank swine\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{\"admin_label\":\"\",\"title\":\"RECENT PROJECTS\",\"heading_selector\":\"h2\",\"title_fontsize\":\"16\",\"title_fontweight\":\"600\",\"title_text_color\":\"#38434a\",\"title_margin_top\":\"0\",\"title_margin_bottom\":\"10\",\"subtitle\":\"Some sample of our innovative work\\n\\n\\n\\n\",\"subtitle_fontsize\":\"24\",\"title_position\":\"sppb-text-left\",\"columns_equal_height\":\"0\",\"fullscreen\":\"0\",\"no_gutter\":\"0\",\"id\":\"\",\"class\":\"heading-style1 tixon-project-section\",\"padding\":\"80px 0 60px\",\"margin\":\"0px 0px 0px 0px\",\"color\":\"\",\"background_color\":\"#f7f9fc\",\"background_image\":\"\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":\"0\",\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animation\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"id\":1480329826,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{\"class\":\"\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1480329827,\"addons\":[{\"name\":\"button\",\"title\":\"Button\",\"id\":1480329828,\"settings\":{\"text\":\"VIEW ALL\",\"url\":\"index.php/portfolio\",\"size\":\"\",\"type\":\"primary\",\"icon\":\"\",\"target\":\"\",\"block\":\"\",\"margin\":\"0 15px 0 0\",\"class\":\"btn-transparent project-btn-top\"},\"visibility\":1},{\"name\":\"module\",\"title\":\"Joomla Module\",\"id\":1480329829,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"id\":\"129\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"6,6\",\"settings\":{\"title_fontweight\":\"\",\"fullscreen\":0,\"margin\":{\"md\":\"90px 0 90px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"class\":\"tixon-about-info\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontsize\":\"\",\"title\":\"\",\"instFormId\":1480329830,\"columns_align_center\":0,\"no_gutter\":0,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1480329830,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-6\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInLeft\",\"animationduration\":1000,\"animationdelay\":500,\"class\":\" left-content\"},\"id\":1480329831,\"addons\":[{\"name\":\"heading\",\"title\":\"Addon Heading\",\"id\":1480329832,\"settings\":{\"heading_style\":\"style1\",\"title\":\"We Believe Everyone Has <br/>Something Important To Say\",\"heading_selector\":\"h2\",\"use_link\":\"0\",\"title_link\":\"\",\"link_new_tab\":\"0\",\"title_fontsize\":\"24\",\"title_fontstyle\":null,\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_margin\":\"0px 0px 30px 0px\",\"title_padding\":\"0px 0px 0px 0px\",\"alignment\":\"sppb-text-left\",\"subtitle\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam\",\"subtitle_fontsize\":\"18\",\"subtitle_fontweight\":\"400\",\"subtitle_text_color\":\"\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null},\"visibility\":1},{\"name\":\"text_block\",\"title\":\"Text Block\",\"id\":1480329833,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"#38434a\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"text\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"visibility\":1},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1480329834,\"settings\":{\"gap\":\"50\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"id\":1481526804587,\"name\":\"button_group\",\"visibility\":true,\"settings\":{\"admin_label\":\"Buttons\",\"alignment\":\"sppb-text-left\",\"margin\":\"10\",\"class\":\"\",\"sp_button_group_item\":[{\"title\":\"Learn More\",\"fontstyle\":null,\"letterspace\":\"0\",\"url\":\"\",\"type\":\"primary\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#ffffff\",\"background_color_hover\":\"#222222\",\"color_hover\":\"#ffffff\",\"size\":\"\",\"shape\":\"rounded\",\"block\":\"\",\"icon\":\"\",\"icon_position\":\"left\",\"target\":\"\"},{\"title\":\"Buy Now\",\"fontstyle\":null,\"letterspace\":\"0\",\"url\":\"\",\"type\":\"success\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#ffffff\",\"background_color_hover\":\"#222222\",\"color_hover\":\"#ffffff\",\"size\":\"\",\"shape\":\"rounded\",\"block\":\"\",\"icon\":\"\",\"icon_position\":\"left\",\"target\":\"\"}],\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null}}],\"visibility\":1},{\"class_name\":\"col-sm-6\",\"settings\":{\"class\":\" right-content\",\"animationdelay\":500,\"animationduration\":1000,\"animation\":\"fadeInRight\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1480329837,\"addons\":[{\"name\":\"image\",\"title\":\"Image\",\"id\":1480329838,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"image\":\"images/mobile.png\",\"alt_text\":\"\",\"position\":\"sppb-text-left\",\"link\":\"javascript:void(0);\",\"target\":\"\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"3,3,3,3\",\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"columns_equal_height\":\"0\",\"fullscreen\":\"0\",\"no_gutter\":\"0\",\"id\":\"\",\"class\":\"tixon-counter\",\"padding\":{\"md\":\"90px 0 90px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"\",\"background_color\":\"#f7f9fc\",\"background_image\":\"\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":\"0\",\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animation\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1480329839,\"columns_align_center\":0,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1480329839,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-3\",\"settings\":{\"class\":\" each-counter\",\"animationdelay\":500,\"animationduration\":800,\"animation\":\"zoomIn\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1480329840,\"addons\":[{\"name\":\"icon\",\"title\":\"Icon\",\"id\":1480329841,\"settings\":{\"icon_type\":\"linea_icon\",\"name\":\"fa-align-center\",\"linea_icon_name\":\"icon-basic-clubs\",\"size\":\"60\",\"color\":\"\",\"background\":\"\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"\",\"margin_top\":\"\",\"margin_bottom\":\"20\",\"padding\":\"\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"dynamicId\":1480329841},\"visibility\":1},{\"name\":\"animated_number\",\"title\":\"Animated Number\",\"id\":1480329842,\"settings\":{\"number\":\"678\",\"duration\":\"1000\",\"counter_title\":\"Complete Project\",\"alignment\":\"sppb-text-center\",\"font_size\":\"48\",\"color\":\"\",\"title_font_size\":\"16\",\"counter_color\":\"\",\"background\":\"\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"\",\"class\":\"font-blod\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"class\":\" each-counter\",\"animationdelay\":600,\"animationduration\":800,\"animation\":\"zoomIn\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1480329843,\"addons\":[{\"name\":\"icon\",\"title\":\"Icon\",\"id\":1480329844,\"settings\":{\"icon_type\":\"linea_icon\",\"name\":\"fa-align-center\",\"linea_icon_name\":\"icon-basic-heart\",\"size\":\"60\",\"color\":\"\",\"background\":\"\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"\",\"margin_top\":\"\",\"margin_bottom\":\"20\",\"padding\":\"\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"dynamicId\":1480329844},\"visibility\":1},{\"name\":\"animated_number\",\"title\":\"Animated Number\",\"id\":1480329845,\"settings\":{\"number\":\"178\",\"duration\":\"1000\",\"counter_title\":\"Happy Clients\",\"alignment\":\"sppb-text-center\",\"font_size\":\"48\",\"color\":\"\",\"title_font_size\":\"16\",\"counter_color\":\"\",\"background\":\"\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"\",\"class\":\"font-blod\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"class\":\" each-counter\",\"animationdelay\":700,\"animationduration\":800,\"animation\":\"zoomIn\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1480329846,\"addons\":[{\"name\":\"icon\",\"title\":\"Icon\",\"id\":1480329847,\"settings\":{\"icon_type\":\"linea_icon\",\"name\":\"fa-align-center\",\"linea_icon_name\":\"icon-basic-cup\",\"size\":\"60\",\"color\":\"\",\"background\":\"\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"\",\"margin_top\":\"\",\"margin_bottom\":\"20\",\"padding\":\"\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"dynamicId\":1480329847},\"visibility\":1},{\"name\":\"animated_number\",\"title\":\"Animated Number\",\"id\":1480329848,\"settings\":{\"number\":\"969\",\"duration\":\"1000\",\"counter_title\":\"Winning Awards\",\"alignment\":\"sppb-text-center\",\"font_size\":\"48\",\"color\":\"\",\"title_font_size\":\"16\",\"counter_color\":\"\",\"background\":\"\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"\",\"class\":\"font-blod\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"class\":\" each-counter\",\"animationdelay\":800,\"animationduration\":800,\"animation\":\"zoomIn\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1480329849,\"addons\":[{\"name\":\"icon\",\"title\":\"Icon\",\"id\":1480329850,\"settings\":{\"icon_type\":\"linea_icon\",\"name\":\"fa-align-center\",\"linea_icon_name\":\"icon-basic-bolt\",\"size\":\"60\",\"color\":\"\",\"background\":\"\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"\",\"margin_top\":\"\",\"margin_bottom\":\"20\",\"padding\":\"\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"dynamicId\":1480329850},\"visibility\":1},{\"name\":\"animated_number\",\"title\":\"Animated Number\",\"id\":1480329851,\"settings\":{\"number\":\"99\",\"duration\":\"1000\",\"counter_title\":\"Years of Experience\",\"alignment\":\"sppb-text-center\",\"font_size\":\"48\",\"color\":\"\",\"title_font_size\":\"16\",\"counter_color\":\"\",\"background\":\"\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"\",\"class\":\"font-blod\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"4,4,4\",\"settings\":{\"fullscreen\":0,\"margin\":{\"md\":\"90px 0 90px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"class\":\"heading-style1 tixon-core-services\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"subtitle_fontsize\":24,\"subtitle\":\"What actually we do \",\"title_margin_bottom\":15,\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontweight\":600,\"title_fontsize\":16,\"heading_selector\":\"h2\",\"title\":\"CORE SERVICES\",\"instFormId\":1480329852,\"columns_align_center\":0,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1480329852,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-4\",\"settings\":{\"class\":\" each-service\",\"animationdelay\":500,\"animationduration\":800,\"animation\":\"fadeInLeft\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1480329853,\"addons\":[{\"name\":\"feature\",\"title\":\"Feature Box\",\"id\":1480329854,\"settings\":{\"title\":\"WEB DESIGN & DEVELOPMENT\",\"heading_selector\":\"h3\",\"title_fontsize\":\"16\",\"title_fontweight\":\"600\",\"title_text_color\":\"#38434a\",\"title_margin\":\"25px 0 25px 0\",\"title_url\":\"\",\"title_position\":\"after\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_type\":\"linea_icon\",\"icon_name\":\"fa-laptop\",\"linea_icon_name\":\"icon-basic-laptop\",\"icon_size\":\"70\",\"icon_color\":\"\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"\",\"icon_margin_bottom\":\"\",\"icon_padding\":\"\",\"text\":\"Lorem ipsum dolor sit amet, consecttur adipisicing elit, sed.onsequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore.\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"visibility\":1},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1480329855,\"settings\":{\"gap\":\"25\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"name\":\"text_block\",\"title\":\"Text Block\",\"id\":1480329856,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"text\":\"<ul>\\n<li>Web Design</li>\\n<li>Web Development</li>\\n<li>Digital Strategy</li>\\n<li>Information Architecture</li>\\n<li>Copywriting</li>\\n</ul>\",\"alignment\":\"sppb-text-left\",\"class\":\"service-list-item\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-4\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInLeft\",\"animationduration\":800,\"animationdelay\":600,\"class\":\" each-service\"},\"id\":1480329857,\"addons\":[{\"name\":\"feature\",\"title\":\"Feature Box\",\"id\":1480329858,\"settings\":{\"title\":\"CLEAN & TRENDY DESIGN\",\"heading_selector\":\"h3\",\"title_fontsize\":\"16\",\"title_fontweight\":\"600\",\"title_text_color\":\"#38434a\",\"title_margin\":\"25px 0 25px 0\",\"title_url\":\"\",\"title_position\":\"after\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_type\":\"linea_icon\",\"icon_name\":\"fa-laptop\",\"linea_icon_name\":\"icon-basic-postcard-multiple\",\"icon_size\":\"70\",\"icon_color\":\"\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"\",\"icon_margin_bottom\":\"\",\"icon_padding\":\"\",\"text\":\"Lorem ipsum dolor sit amet, consecttur adipisicing elit, sed.onsequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore.\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"visibility\":1},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1480329859,\"settings\":{\"gap\":\"25\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"name\":\"text_block\",\"title\":\"Text Block\",\"id\":1480329860,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"text\":\"<ul>\\n<li>Web Design</li>\\n<li>Web Development</li>\\n<li>Digital Strategy</li>\\n<li>Information Architecture</li>\\n<li>Copywriting</li>\\n</ul>\",\"alignment\":\"sppb-text-left\",\"class\":\"service-list-item\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-4\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInLeft\",\"animationduration\":800,\"animationdelay\":700,\"class\":\" each-service\"},\"id\":1480329861,\"addons\":[{\"name\":\"feature\",\"title\":\"Feature Box\",\"id\":1480329862,\"settings\":{\"title\":\"JOOMLA & HELIX FRAMEWORK\",\"heading_selector\":\"h3\",\"title_fontsize\":\"16\",\"title_fontweight\":\"600\",\"title_text_color\":\"#38434a\",\"title_margin\":\"25px 0 25px 0\",\"title_url\":\"\",\"title_position\":\"after\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_type\":\"linea_icon\",\"icon_name\":\"fa-laptop\",\"linea_icon_name\":\"icon-basic-folder-multiple\",\"icon_size\":\"70\",\"icon_color\":\"\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"\",\"icon_margin_bottom\":\"\",\"icon_padding\":\"\",\"text\":\"Lorem ipsum dolor sit amet, consecttur adipisicing elit, sed.onsequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore.\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"visibility\":1},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1480329863,\"settings\":{\"gap\":\"25\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"name\":\"text_block\",\"title\":\"Text Block\",\"id\":1480329864,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"text\":\"<ul>\\n<li>Web Design</li>\\n<li>Web Development</li>\\n<li>Digital Strategy</li>\\n<li>Information Architecture</li>\\n<li>Copywriting</li>\\n</ul>\",\"alignment\":\"sppb-text-left\",\"class\":\"service-list-item\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{\"admin_label\":\"\",\"title\":\"LATEST BLOG POSTS<br/>\",\"heading_selector\":\"h2\",\"title_fontsize\":\"16\",\"title_fontweight\":\"600\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"15\",\"subtitle\":\"What actually we do\",\"subtitle_fontsize\":\"24\",\"title_position\":\"sppb-text-left\",\"columns_equal_height\":\"0\",\"fullscreen\":\"0\",\"no_gutter\":\"0\",\"id\":\"\",\"class\":\"heading-style1 tixon-latest-blog\",\"padding\":{\"md\":\"90px 0 90px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0 0px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"\",\"background_color\":\"#f2f4f7\",\"background_image\":\"\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":\"0\",\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animation\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1480329865,\"columns_align_center\":0,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1480329865,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeIn\",\"animationduration\":500,\"animationdelay\":300,\"class\":\"\"},\"id\":1480329866,\"addons\":[{\"name\":\"button\",\"title\":\"Button\",\"id\":1480329867,\"settings\":{\"text\":\"MORE BLOG\",\"url\":\"index.php/blog\",\"size\":\"\",\"type\":\"primary\",\"icon\":\"\",\"target\":\"\",\"block\":\"\",\"margin\":\"0 15px 0 0\",\"class\":\"btn-transparent project-btn-top\"},\"visibility\":1},{\"name\":\"latest_post\",\"title\":\"Latest Posts\",\"id\":1480329868,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"item_limit\":\"5\",\"intro_text_limit\":\"100\",\"category\":\"84\",\"ordering\":\"latest\",\"post_type\":\"\",\"class\":\"\",\"global_options\":\"\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_boxshadow\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"3,3,3,3\",\"settings\":{\"title_fontweight\":600,\"heading_selector\":\"h2\",\"title\":\"HAPPY CLIENTS\",\"title_fontsize\":16,\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":15,\"subtitle\":\"What actually we do\",\"subtitle_fontsize\":24,\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"heading-style1 tixon-happy-clients\",\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"90px 0 90px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"fullscreen\":0,\"instFormId\":1480329869,\"columns_align_center\":0,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1480329869,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-3\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInLeft\",\"animationduration\":800,\"animationdelay\":500,\"class\":\"\"},\"id\":1480329870,\"addons\":[{\"name\":\"image\",\"title\":\"Image\",\"id\":1480329871,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"image\":\"images/clients/client1.png\",\"alt_text\":\"\",\"position\":\"sppb-text-center\",\"link\":\"http://\",\"target\":\"\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInLeft\",\"animationduration\":800,\"animationdelay\":600,\"class\":\"\"},\"id\":1480329872,\"addons\":[{\"name\":\"image\",\"title\":\"Image\",\"id\":1480329873,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"image\":\"images/clients/client2.png\",\"alt_text\":\"\",\"position\":\"sppb-text-center\",\"link\":\"http://\",\"target\":\"\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInLeft\",\"animationduration\":800,\"animationdelay\":700,\"class\":\"\"},\"id\":1480329874,\"addons\":[{\"name\":\"image\",\"title\":\"Image\",\"id\":1480329875,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"image\":\"images/clients/client3.png\",\"alt_text\":\"\",\"position\":\"sppb-text-center\",\"link\":\"http://\",\"target\":\"\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"class\":\"\",\"animationdelay\":800,\"animationduration\":800,\"animation\":\"fadeInLeft\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1480329876,\"addons\":[{\"name\":\"image\",\"title\":\"Image\",\"id\":1480329877,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"image\":\"images/clients/client4.png\",\"alt_text\":\"\",\"position\":\"sppb-text-center\",\"link\":\"http://\",\"target\":\"\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{\"fullscreen\":0,\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"padding\":{\"md\":\"60px 0 60px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"class\":\"tixon-call-to-action\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_image\":\"\",\"color\":\"\",\"background_color\":\"#f2f4f7\",\"title_position\":\"sppb-text-left\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontweight\":\"\",\"title_fontsize\":\"\",\"title\":\"\",\"instFormId\":1480329878,\"columns_align_center\":0,\"no_gutter\":0,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1480329878,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{\"class\":\"\",\"animationdelay\":500,\"animationduration\":800,\"animation\":\"fadeInDown\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1480329879,\"addons\":[{\"name\":\"call_to_action\",\"title\":\"Call to Action\",\"id\":1480329880,\"settings\":{\"title\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit\",\"heading_selector\":\"h2\",\"title_fontsize\":\"24\",\"title_fontweight\":\"\",\"title_text_color\":\"#38434a\",\"title_margin_top\":\"0\",\"title_margin_bottom\":\"10\",\"subtitle\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elitsed do eiusmod tempor\",\"subtitle_fontsize\":\"14\",\"subtitle_fontweight\":\"\",\"subtitle_text_color\":\"\",\"text\":\"\",\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"button_text\":\"BUY NOW\",\"button_url\":\"javascript:void(0)\",\"button_size\":\"\",\"button_type\":\"primary\",\"button_icon\":\"\",\"button_block\":\"\",\"button_target\":\"\",\"button_position\":\"right\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"}]', 'com_sppagebuilder', 'page', 0, 0, 1, 0, 1, 0, '2015-01-22 07:12:35', 928, '2018-02-14 05:45:32', 928, 0, '0000-00-00 00:00:00', '', '', '', '*', 338, ''),
(6, 269, 'Portfolio', '[{\"id\":1519283183632,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":1,\"no_gutter\":0,\"padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":\"0\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"12\",\"columns\":[{\"id\":1519283183631,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1519362781190,\"name\":\"slideshow_owl\",\"visibility\":true,\"settings\":{\"autoplay\":\"1\",\"controllers\":\"1\",\"class\":\"\",\"sp_slideshow_owl_item\":[{\"title\":\"Tixon  <br>Creative\",\"image\":\"images/portfolioslide/1.jpg\",\"button_text\":\"read more\",\"button_url\":\"#\"},{\"title\":\"Tixon  <br>Creative\",\"image\":\"images/portfolioslide/1.jpg\",\"button_text\":\"read more\",\"button_url\":\"#\"},{\"title\":\"Tixon  <br>Creative\",\"image\":\"images/portfolioslide/1.jpg\",\"button_text\":\"read more\",\"button_url\":\"#\"},{\"title\":\"Tixon  <br>Creative\",\"image\":\"images/portfolioslide/1.jpg\",\"button_text\":\"read more\",\"button_url\":\"#\"},{\"title\":\"Tixon  <br>Creative\",\"image\":\"images/portfolioslide/1.jpg\",\"button_text\":\"read more\",\"button_url\":\"#\"},{\"title\":\"Tixon  <br>Creative\",\"image\":\"images/portfolioslide/1.jpg\",\"button_text\":\"read more\",\"button_url\":\"#\"}],\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_use_overlay\":0,\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0 0 30px 0\",\"sm\":\"0 0 20px 0\",\"xs\":\"0 0 10px 0\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1519362781190}}]}]},{\"layout\":12,\"settings\":{\"title_fontweight\":\"\",\"fullscreen\":0,\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"padding\":{\"md\":\"100px 0 100px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"class\":\"\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"title_position\":\"sppb-text-center\",\"subtitle_fontsize\":\"\",\"subtitle\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit sed <br>\\neiusmod tempor incididunt ut labore et dolore\",\"title_margin_bottom\":20,\"title_margin_top\":0,\"title_text_color\":\"#333333\",\"title_fontsize\":36,\"heading_selector\":\"h2\",\"title\":\"Showcase\",\"instFormId\":1518589065,\"columns_align_center\":0,\"no_gutter\":0,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1518589065,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12 active-column-parent\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\"\"},\"id\":1518589066,\"addons\":[{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1518589067,\"settings\":{\"gap\":\"20\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"name\":\"module\",\"title\":\"Joomla Module\",\"id\":1518589068,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"id\":\"129\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{\"title\":\"\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-left\",\"background_color\":\"#f2f4f7\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"tixon-call-to-action\",\"padding\":{\"md\":\"60px 0 60px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"fullscreen\":0,\"instFormId\":1518589069,\"columns_align_center\":0,\"no_gutter\":0,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1518589069,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{},\"id\":1518589070,\"addons\":[{\"name\":\"call_to_action\",\"title\":\"Call to Action\",\"id\":1518589071,\"settings\":{\"title\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit\",\"heading_selector\":\"h2\",\"title_fontsize\":\"24\",\"title_fontweight\":\"\",\"title_text_color\":\"#38434a\",\"title_margin_top\":\"0\",\"title_margin_bottom\":\"10\",\"subtitle\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elitsed do eiusmod tempor\",\"subtitle_fontsize\":\"14\",\"subtitle_fontweight\":\"\",\"subtitle_text_color\":\"\",\"text\":\"\",\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"button_text\":\"BUY NOW\",\"button_url\":\"http://www.joomshaper.com/helix\",\"button_size\":\"\",\"button_type\":\"primary\",\"button_icon\":\"\",\"button_block\":\"\",\"button_target\":\"\",\"button_position\":\"right\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"}]', 'com_sppagebuilder', 'page', 0, 0, 1, 0, 1, 0, '2015-01-22 07:12:35', 587, '2018-02-26 05:53:19', 587, 0, '0000-00-00 00:00:00', '', '', '', '*', 102, '');
INSERT INTO `#__sppagebuilder` (`id`, `asset_id`, `title`, `text`, `extension`, `extension_view`, `view_id`, `active`, `published`, `catid`, `access`, `ordering`, `created_on`, `created_by`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `og_title`, `og_image`, `og_description`, `language`, `hits`, `css`) VALUES
(8, 267, 'Lawyer', '[{\"layout\":12,\"settings\":{\"title\":\"\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"tixon-slider-lawyer\",\"padding\":\"\",\"margin\":\"\",\"fullscreen\":1},\"id\":1481609204,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{},\"id\":1481609205,\"addons\":[{\"name\":\"slideshow_full\",\"title\":\"Slideshow (Full Width)\",\"id\":1481609206,\"settings\":{\"layout\":\"layout2\",\"autoplay\":\"1\",\"controllers\":\"0\",\"arrows\":\"1\",\"background\":\"\",\"color\":\"\",\"class\":\"\",\"sp_slideshow_full_item\":[{\"title\":\"legal rights\",\"sub_title\":\"you deserve justice\",\"content\":\"\\\"We offer legal advice and aid in solving problems regarding<br />procedures of the law\\\"\",\"bg\":\"images/demo/slider/lawyear/slider1.jpg\",\"button_text\":\"request a free consultation\",\"button_url\":\"#\",\"button_size\":\"\",\"button_type\":\"default\",\"button_before_icon\":\"\",\"button_after_icon\":\"\",\"title_animation\":\"fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp\",\"title_animationduration\":\"\",\"title_animationdelay\":\"\",\"subtitle_animation\":\"fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp\",\"subtitle_animationduration\":\"\",\"subtitle_animationdelay\":\"200\",\"cotent_animation\":\"fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp\",\"cotent_animationduration\":\"\",\"cotent_animationdelay\":\"400\",\"button_animation\":\"fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp\",\"button_animationduration\":\"\",\"button_animationdelay\":\"600\"},{\"title\":\"welcome  to\",\"sub_title\":\"tixon lawfarm\",\"content\":\"\\\"We offer legal advice and aid in solving problems regarding<br />procedures of the law\\\"\",\"bg\":\"images/demo/slider/lawyear/slider2.jpg\",\"button_text\":\"request a free consultation\",\"button_url\":\"#\",\"button_size\":\"\",\"button_type\":\"default\",\"button_before_icon\":\"\",\"button_after_icon\":\"\",\"title_animation\":\"fadeInRightBig sppb-wow fadeInRightBig sppb-wow fadeInRightBig sppb-wow fadeInRightBig sppb-wow fadeInRightBig sppb-wow fadeInRightBig sppb-wow fadeInRightBig sppb-wow fadeInRightBig\",\"title_animationduration\":\"\",\"title_animationdelay\":\"\",\"subtitle_animation\":\"fadeInRight sppb-wow fadeInRight sppb-wow fadeInRight sppb-wow fadeInRight sppb-wow fadeInRight sppb-wow fadeInRight sppb-wow fadeInRight sppb-wow fadeInRight\",\"subtitle_animationduration\":\"\",\"subtitle_animationdelay\":\"200\",\"cotent_animation\":\"fadeInRight sppb-wow fadeInRight sppb-wow fadeInRight sppb-wow fadeInRight sppb-wow fadeInRight sppb-wow fadeInRight sppb-wow fadeInRight sppb-wow fadeInRight\",\"cotent_animationduration\":\"\",\"cotent_animationdelay\":\"400\",\"button_animation\":\"fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp\",\"button_animationduration\":\"\",\"button_animationdelay\":\"600\"},{\"title\":\"full service\",\"sub_title\":\"Law firm\",\"content\":\"\\\"We offer legal advice and aid in solving problems regarding<br />procedures of the law\\\"\",\"bg\":\"images/demo/slider/lawyear/slider3.jpg\",\"button_text\":\"request a free consultation\",\"button_url\":\"#\",\"button_size\":\"\",\"button_type\":\"default\",\"button_before_icon\":\"\",\"button_after_icon\":\"\",\"title_animation\":\"zoomInRight sppb-wow zoomInRight sppb-wow zoomInRight sppb-wow zoomInRight sppb-wow zoomInRight sppb-wow zoomInRight sppb-wow zoomInRight sppb-wow zoomInRight\",\"title_animationduration\":\"\",\"title_animationdelay\":\"\",\"subtitle_animation\":\"rotateInDownLeft sppb-wow rotateInDownLeft sppb-wow rotateInDownLeft sppb-wow rotateInDownLeft sppb-wow rotateInDownLeft sppb-wow rotateInDownLeft sppb-wow rotateInDownLeft sppb-wow rotateInDownLeft\",\"subtitle_animationduration\":\"\",\"subtitle_animationdelay\":\"200\",\"cotent_animation\":\"fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp sppb-wow fadeInUp\",\"cotent_animationduration\":\"\",\"cotent_animationdelay\":\"400\",\"button_animation\":\"flipInX sppb-wow flipInX sppb-wow flipInX sppb-wow flipInX sppb-wow flipInX sppb-wow flipInX sppb-wow flipInX sppb-wow flipInX\",\"button_animationduration\":\"\",\"button_animationdelay\":\"600\"}]},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"8,2,2\",\"settings\":{\"title\":\"\",\"heading_selector\":\"h2\",\"title_fontsize\":36,\"title_fontweight\":300,\"title_text_color\":\"#000000\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\" lawyer-cta\",\"padding\":\"\",\"margin\":\"90px 0 90px\",\"fullscreen\":0},\"id\":1481609207,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-2\",\"settings\":{},\"id\":1481609208,\"addons\":[],\"visibility\":1},{\"class_name\":\"col-sm-8\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\" lawyer-cta-wrap\"},\"id\":1481609209,\"addons\":[{\"name\":\"image\",\"title\":\"Image\",\"id\":1481609210,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"image\":\"images/lawyer/lawyer-icon.png\",\"alt_text\":\"\",\"position\":\"sppb-text-center\",\"link\":\"http://\",\"target\":\"\",\"class\":\"\"},\"visibility\":1},{\"name\":\"call_to_action\",\"title\":\"Call to Action\",\"id\":1481609211,\"settings\":{\"title\":\"Welcome to Tixon Law Firm\",\"heading_selector\":\"h3\",\"title_fontsize\":\"34\",\"title_fontweight\":\"300\",\"title_text_color\":\"\",\"title_margin_top\":\"40\",\"title_margin_bottom\":\"\",\"subtitle\":\"Providing Legal Help \",\"subtitle_fontsize\":\"16\",\"subtitle_fontweight\":\"300\",\"subtitle_text_color\":\"#000000\",\"text\":\"\",\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"button_text\":\"\",\"button_url\":\"\",\"button_size\":\"\",\"button_type\":\"default\",\"button_icon\":\"\",\"button_block\":\"\",\"button_target\":\"\",\"button_position\":\"bottom\",\"class\":\"lawyer-cta-1\"},\"visibility\":1},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1481609212,\"settings\":{\"gap\":\"35\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"name\":\"text_block\",\"title\":\"Text Block\",\"id\":1481609213,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"text\":\"We practice in personal injury, family, criminal and labor litigation, with an emphasis on complex contractual matters and mass tort litigation. We are a leading group of highly professional lawyer\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"visibility\":1},{\"name\":\"call_to_action\",\"title\":\"Call to Action\",\"id\":1481609214,\"settings\":{\"title\":\"Call for Consultation\",\"heading_selector\":\"h3\",\"title_fontsize\":\"16\",\"title_fontweight\":\"700\",\"title_text_color\":\"\",\"title_margin_top\":\"30\",\"title_margin_bottom\":\"\",\"subtitle\":\"+98235 610 394\",\"subtitle_fontsize\":\"34\",\"subtitle_fontweight\":\"700\",\"subtitle_text_color\":\"#0072bc\",\"text\":\"Mon - Fri (9:00- 5:00)\",\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"button_text\":\"\",\"button_url\":\"\",\"button_size\":\"\",\"button_type\":\"default\",\"button_icon\":\"\",\"button_block\":\"\",\"button_target\":\"\",\"button_position\":\"bottom\",\"class\":\"lawyer-cta-2\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-2\",\"settings\":{},\"id\":1481609215,\"addons\":[],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"4,4,4\",\"settings\":{\"title\":\"OUR PRACTICE AREA\",\"heading_selector\":\"h3\",\"title_fontsize\":24,\"title_fontweight\":600,\"title_text_color\":\"#000000\",\"title_margin_top\":\"\",\"title_margin_bottom\":25,\"subtitle\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit sed do eiusmod </br> tempor incididunt ut labore et dolore\",\"subtitle_fontsize\":16,\"title_position\":\"sppb-text-center\",\"background_color\":\"#f7f9fc\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"lawyer-service\",\"padding\":{\"md\":\"90px 0 90px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"fullscreen\":0,\"instFormId\":1481609216,\"columns_align_center\":0,\"no_gutter\":0,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1481609216,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-4\",\"settings\":{\"class\":\"\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"fadeInUp\",\"padding\":\"\",\"color\":\"#38434a\",\"background\":\"\"},\"id\":1481609217,\"addons\":[{\"id\":1481610946418,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"title\":\"Family Law\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin\":\"12px 0 20px\",\"title_url\":\"\",\"title_position\":\"left\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_type\":\"linea_icon\",\"icon_name\":\"fa-adjust\",\"linea_icon_name\":\"icon-basic-home\",\"icon_size\":\"48\",\"icon_color\":\"\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"\",\"icon_margin_bottom\":\"\",\"icon_padding\":\"\",\"text\":\"\\t\\t\\tLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore.\",\"alignment\":\"sppb-text-left\",\"class\":\"each-service\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null}},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1481609219,\"settings\":{\"gap\":\"80\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"id\":1481610831017,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"title\":\"Money Laundering\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin\":\"12px 0 20px\",\"title_url\":\"\",\"title_position\":\"left\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_type\":\"linea_icon\",\"icon_name\":\"fa-adjust\",\"linea_icon_name\":\"icon-basic-cards-diamonds\",\"icon_size\":\"48\",\"icon_color\":\"\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"\",\"icon_margin_bottom\":\"\",\"icon_padding\":\"\",\"text\":\"\\t\\t\\t\\tLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore.\",\"alignment\":\"sppb-text-left\",\"class\":\"each-service\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null}}],\"visibility\":1},{\"class_name\":\"col-sm-4\",\"settings\":{\"class\":\"\",\"animationdelay\":200,\"animationduration\":\"\",\"animation\":\"fadeInDown\",\"padding\":\"\",\"color\":\"#38434a\",\"background\":\"\"},\"id\":1481609221,\"addons\":[{\"id\":1481610831014,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"title\":\"Business Law\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin\":\"12px 0 20px\",\"title_url\":\"\",\"title_position\":\"left\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_type\":\"linea_icon\",\"icon_name\":\"fa-adjust\",\"linea_icon_name\":\"icon-basic-case\",\"icon_size\":\"48\",\"icon_color\":\"\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"\",\"icon_margin_bottom\":\"\",\"icon_padding\":\"\",\"text\":\"\\t\\t\\t\\tLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore.\",\"alignment\":\"sppb-text-left\",\"class\":\"each-service\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null}},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1481609223,\"settings\":{\"gap\":\"80\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"id\":1481610831020,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"title\":\"Drug Offences\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin\":\"12px 0 20px\",\"title_url\":\"\",\"title_position\":\"left\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_type\":\"linea_icon\",\"icon_name\":\"fa-adjust\",\"linea_icon_name\":\"icon-basic-paperplane\",\"icon_size\":\"48\",\"icon_color\":\"\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"\",\"icon_margin_bottom\":\"\",\"icon_padding\":\"\",\"text\":\"\\t\\t\\t\\tLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore.\",\"alignment\":\"sppb-text-left\",\"class\":\"each-service\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null}}],\"visibility\":1},{\"class_name\":\"col-sm-4\",\"settings\":{\"class\":\"\",\"animationdelay\":400,\"animationduration\":\"\",\"animation\":\"fadeInUp\",\"padding\":\"\",\"color\":\"#38434a\",\"background\":\"\"},\"id\":1481609225,\"addons\":[{\"id\":1481610831023,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"title\":\"Sexual Offences\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin\":\"12px 0 20px\",\"title_url\":\"\",\"title_position\":\"left\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_type\":\"linea_icon\",\"icon_name\":\"fa-adjust\",\"linea_icon_name\":\"icon-basic-helm\",\"icon_size\":\"48\",\"icon_color\":\"\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"\",\"icon_margin_bottom\":\"\",\"icon_padding\":\"\",\"text\":\"\\t\\t\\t\\tLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore.\",\"alignment\":\"sppb-text-left\",\"class\":\"each-service\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null}},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1481609227,\"settings\":{\"gap\":\"80\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"id\":1481610831026,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"title\":\"Civil Litigation\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin\":\"12px 0 20px\",\"title_url\":\"\",\"title_position\":\"left\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_type\":\"linea_icon\",\"icon_name\":\"fa-adjust\",\"linea_icon_name\":\"icon-basic-flag2\",\"icon_size\":\"48\",\"icon_color\":\"\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"\",\"icon_margin_bottom\":\"\",\"icon_padding\":\"\",\"text\":\"\\t\\t\\t\\tLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore.\",\"alignment\":\"sppb-text-left\",\"class\":\"each-service\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null}}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"6,6\",\"settings\":{\"fullscreen\":0,\"margin\":\"\",\"padding\":\"\",\"class\":\"layer-experience\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontweight\":\"\",\"title_fontsize\":\"\",\"title\":\"\",\"instFormId\":1481609229,\"columns_align_center\":0,\"no_gutter\":0},\"id\":1481609229,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-6\",\"settings\":{\"class\":\"\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"fadeInLeft\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1481609230,\"addons\":[{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1481609231,\"settings\":{\"gap\":\"80\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"name\":\"heading\",\"title\":\"Addon Heading\",\"id\":1481609232,\"settings\":{\"heading_style\":\"style1\",\"title\":\"OVER 20 YEARS EXPERIENCE\",\"heading_selector\":\"h3\",\"use_link\":\"0\",\"title_link\":\"\",\"link_new_tab\":\"0\",\"title_fontsize\":\"28\",\"title_fontstyle\":null,\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_margin\":\"0px 0px 30px 0px\",\"title_padding\":\"0px 0px 0px 0px\",\"alignment\":\"sppb-text-left\",\"subtitle\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam\",\"subtitle_fontsize\":\"18\",\"subtitle_fontweight\":\"400\",\"subtitle_text_color\":\"\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null},\"visibility\":1},{\"name\":\"text_block\",\"title\":\"Text Block\",\"id\":1481609233,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"#000000\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"30\",\"text\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"visibility\":1},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1481609234,\"settings\":{\"gap\":\"50\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"name\":\"button\",\"title\":\"Button\",\"id\":1481609235,\"settings\":{\"text\":\"More About Us\",\"url\":\"javascript:void(0)\",\"size\":\"\",\"type\":\"primary\",\"icon\":\"\",\"target\":\"\",\"block\":\"\",\"margin\":\"0 20px 0 0\",\"class\":\"btn-transparent\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-6\",\"settings\":{\"class\":\"\",\"animationdelay\":200,\"animationduration\":\"\",\"animation\":\"fadeInRight\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1481609236,\"addons\":[{\"name\":\"image\",\"title\":\"Image\",\"id\":1481609237,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"image\":\"images/demo/lawyear-1.jpg\",\"alt_text\":\"\",\"position\":\"sppb-text-center\",\"link\":\"#\",\"target\":\"\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"3,3,3,3\",\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"columns_equal_height\":\"0\",\"fullscreen\":\"0\",\"no_gutter\":\"0\",\"id\":\"\",\"class\":\"tixon-counter\",\"padding\":{\"md\":\"90px 0 90px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"\",\"background_color\":\"#f7f9fc\",\"background_image\":\"\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":\"0\",\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animation\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1481609238,\"columns_align_center\":0,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1481609238,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-3\",\"settings\":{\"class\":\" each-counter\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"zoomIn\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1481609239,\"addons\":[{\"name\":\"icon\",\"title\":\"Icon\",\"id\":1481609240,\"settings\":{\"icon_type\":\"linea_icon\",\"name\":\"fa-align-center\",\"linea_icon_name\":\"icon-basic-clubs\",\"size\":\"60\",\"color\":\"\",\"background\":\"\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"\",\"margin_top\":\"\",\"margin_bottom\":\"30\",\"padding\":\"\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"visibility\":1},{\"name\":\"animated_number\",\"title\":\"Animated Number\",\"id\":1481609241,\"settings\":{\"number\":\"7290\",\"duration\":\"1000\",\"counter_title\":\"Trusted clients\",\"alignment\":\"sppb-text-center\",\"font_size\":\"48\",\"color\":\"\",\"title_font_size\":\"16\",\"counter_color\":\"\",\"background\":\"\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"\",\"class\":\"font-blod\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"zoomIn\",\"animationduration\":\"\",\"animationdelay\":200,\"class\":\" each-counter\"},\"id\":1481609242,\"addons\":[{\"name\":\"icon\",\"title\":\"Icon\",\"id\":1481609243,\"settings\":{\"icon_type\":\"linea_icon\",\"name\":\"fa-align-center\",\"linea_icon_name\":\"icon-basic-heart\",\"size\":\"60\",\"color\":\"\",\"background\":\"\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"\",\"margin_top\":\"\",\"margin_bottom\":\"30\",\"padding\":\"\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"visibility\":1},{\"name\":\"animated_number\",\"title\":\"Animated Number\",\"id\":1481609244,\"settings\":{\"number\":\"2537\",\"duration\":\"1000\",\"counter_title\":\"Recovered for our clients\",\"alignment\":\"sppb-text-center\",\"font_size\":\"48\",\"color\":\"\",\"title_font_size\":\"16\",\"counter_color\":\"\",\"background\":\"\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"\",\"class\":\"font-blod\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"class\":\" each-counter\",\"animationdelay\":400,\"animationduration\":\"\",\"animation\":\"zoomIn\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1481609245,\"addons\":[{\"name\":\"icon\",\"title\":\"Icon\",\"id\":1481609246,\"settings\":{\"icon_type\":\"linea_icon\",\"name\":\"fa-align-center\",\"linea_icon_name\":\"icon-basic-cup\",\"size\":\"60\",\"color\":\"\",\"background\":\"\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"\",\"margin_top\":\"\",\"margin_bottom\":\"30\",\"padding\":\"\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"visibility\":1},{\"name\":\"animated_number\",\"title\":\"Animated Number\",\"id\":1481609247,\"settings\":{\"number\":\"452\",\"duration\":\"1000\",\"counter_title\":\"Cases won\",\"alignment\":\"sppb-text-center\",\"font_size\":\"48\",\"color\":\"\",\"title_font_size\":\"16\",\"counter_color\":\"\",\"background\":\"\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"\",\"class\":\"font-blod\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"class\":\" each-counter\",\"animationdelay\":600,\"animationduration\":\"\",\"animation\":\"zoomIn\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1481609248,\"addons\":[{\"name\":\"icon\",\"title\":\"Icon\",\"id\":1481609249,\"settings\":{\"icon_type\":\"linea_icon\",\"name\":\"fa-align-center\",\"linea_icon_name\":\"icon-basic-bolt\",\"size\":\"60\",\"color\":\"\",\"background\":\"\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"\",\"margin_top\":\"\",\"margin_bottom\":\"30\",\"padding\":\"\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"visibility\":1},{\"name\":\"animated_number\",\"title\":\"Animated Number\",\"id\":1481609250,\"settings\":{\"number\":\"2731\",\"duration\":\"1000\",\"counter_title\":\"Specialists engaged\",\"alignment\":\"sppb-text-center\",\"font_size\":\"48\",\"color\":\"\",\"title_font_size\":\"16\",\"counter_color\":\"\",\"background\":\"\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"\",\"class\":\"font-blod\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"6,6\",\"settings\":{\"fullscreen\":0,\"margin\":{\"md\":\"90px 0 90px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"class\":\"lawyer-accordion\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontweight\":\"\",\"title_fontsize\":\"\",\"title\":\"\",\"instFormId\":1481609251,\"columns_align_center\":0,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1481609251,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-6\",\"settings\":{\"class\":\"\",\"animationdelay\":200,\"animationduration\":\"\",\"animation\":\"fadeInLeft\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1481609252,\"addons\":[{\"name\":\"accordion\",\"title\":\"Accordion\",\"id\":1481609253,\"settings\":{\"title\":\"CASE RESULT\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"600\",\"title_text_color\":\"#38434a\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"50\",\"style\":\"panel-default\",\"class\":\"\",\"sp_accordion_item\":[{\"title\":\"Does not reflect adjustments for fees, costs, or medical liens\",\"icon\":\"\",\"content\":\"$699 Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.\"},{\"title\":\"Costs, or medical liens does not reflect adjustments for fees\",\"icon\":\"\",\"content\":\"$699 Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.\"},{\"title\":\"Costs, or medical liens does not reflect adjustments for fees\",\"icon\":\"\",\"content\":\"$699 Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.\"}]},\"visibility\":1},{\"name\":\"button\",\"title\":\"Button\",\"id\":1481609254,\"settings\":{\"text\":\"All Cases & Result\",\"url\":\"javascript:void(0)\",\"size\":\"\",\"type\":\"primary\",\"icon\":\"\",\"target\":\"\",\"block\":\"\",\"margin\":\"\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-6 active-column-parent\",\"settings\":{\"class\":\"\",\"animationdelay\":400,\"animationduration\":\"\",\"animation\":\"fadeInRight\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1481609255,\"addons\":[{\"name\":\"tab\",\"title\":\"Tabs\",\"id\":1481609256,\"settings\":{\"title\":\"WHY CLIENTS LOVE US\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"600\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"50\",\"style\":\"tabs\",\"class\":\"\",\"sp_tab_item\":[{\"title\":\"Consulting\",\"icon\":\"\",\"content\":\"<div>\\n<p class=\\\"icon linea-icon-basic-compass\\\"> </p>\\nAnim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod.</div>\\n<div>\\n<p class=\\\"icon linea-icon-basic-flag2\\\"> </p>\\nBrunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.</div>\"},{\"title\":\"Criminal Law\",\"icon\":\"\",\"content\":\"<div>\\n<p class=\\\"icon linea-icon-basic-compass\\\"> </p>\\nAnim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod.</div>\\n<div>\\n<p class=\\\"icon linea-icon-basic-flag2\\\"> </p>\\nBrunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.</div>\"},{\"title\":\"Civil Law\",\"icon\":\"\",\"content\":\"<div>\\n<p class=\\\"icon linea-icon-basic-compass\\\"> </p>\\nAnim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod.</div>\\n<div>\\n<p class=\\\"icon linea-icon-basic-flag2\\\"> </p>\\nBrunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.</div>\"},{\"title\":\"Family Law\",\"icon\":\"\",\"content\":\"<div>\\n<p class=\\\"icon linea-icon-basic-compass\\\"> </p>\\nAnim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod.</div>\\n<div>\\n<p class=\\\"icon linea-icon-basic-flag2\\\"> </p>\\nBrunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.</div>\"}]},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{\"admin_label\":\"\",\"title\":\"RECENT LEGAL ARTICLES<br/>\",\"heading_selector\":\"h2\",\"title_fontsize\":\"24\",\"title_fontweight\":\"600\",\"title_text_color\":\"#38434a\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"30\",\"subtitle\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit  sed do eiusmod </br> tempor incididunt ut labore et dolore\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"columns_equal_height\":\"0\",\"fullscreen\":\"0\",\"no_gutter\":\"0\",\"id\":\"\",\"class\":\"\",\"padding\":{\"md\":\"90px 0 50px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0 0px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"\",\"background_color\":\"#f2f4f7\",\"background_image\":\"\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":\"0\",\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animation\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1481609257,\"columns_align_center\":0,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1481609257,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeIn\",\"animationduration\":500,\"animationdelay\":300,\"class\":\"\"},\"id\":1481609258,\"addons\":[{\"name\":\"latest_post\",\"title\":\"Latest Posts\",\"id\":1481609259,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"item_limit\":\"5\",\"intro_text_limit\":\"100\",\"category\":\"\",\"class\":\"\",\"dynamicId\":1481609259},\"visibility\":1},{\"name\":\"text_block\",\"title\":\"Text Block\",\"id\":1481609260,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"text\":\"Know about our Latest articles. <a href=\\\"index.php/blog\\\">Click Here</a>\",\"alignment\":\"sppb-text-center\",\"class\":\"more-articles\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"3,3,3,3\",\"settings\":{\"title\":\"OUR CLIENTS\",\"heading_selector\":\"h2\",\"title_fontsize\":24,\"title_fontweight\":600,\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod </br> tempor incididunt ut labore et dolore\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"tixon-happy-clients\",\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"90px 0 90px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"fullscreen\":0,\"instFormId\":1481609261,\"columns_align_center\":0,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1481609261,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-3\",\"settings\":{\"class\":\"\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"fadeInLeft\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1481609262,\"addons\":[{\"name\":\"image\",\"title\":\"Image\",\"id\":1481609263,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"image\":\"images/clients/client1.png\",\"alt_text\":\"\",\"position\":\"sppb-text-center\",\"link\":\"http://\",\"target\":\"\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"class\":\"\",\"animationdelay\":200,\"animationduration\":\"\",\"animation\":\"fadeInLeft\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1481609264,\"addons\":[{\"name\":\"image\",\"title\":\"Image\",\"id\":1481609265,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"image\":\"images/clients/client2.png\",\"alt_text\":\"\",\"position\":\"sppb-text-center\",\"link\":\"http://\",\"target\":\"\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"class\":\"\",\"animationdelay\":400,\"animationduration\":\"\",\"animation\":\"fadeInLeft\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1481609266,\"addons\":[{\"name\":\"image\",\"title\":\"Image\",\"id\":1481609267,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"image\":\"images/clients/client3.png\",\"alt_text\":\"\",\"position\":\"sppb-text-center\",\"link\":\"http://\",\"target\":\"\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInLeft\",\"animationduration\":\"\",\"animationdelay\":600,\"class\":\"\"},\"id\":1481609268,\"addons\":[{\"name\":\"image\",\"title\":\"Image\",\"id\":1481609269,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"image\":\"images/clients/client4.png\",\"alt_text\":\"\",\"position\":\"sppb-text-center\",\"link\":\"http://\",\"target\":\"\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h1\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-left\",\"columns_equal_height\":\"0\",\"fullscreen\":\"0\",\"no_gutter\":\"0\",\"id\":\"\",\"class\":\"tixon-call-to-action\",\"padding\":{\"md\":\"60px 0 60px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"\",\"background_color\":\"#f2f4f7\",\"background_image\":\"\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"50% 50%\",\"background_video\":\"0\",\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animation\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1481609270,\"columns_align_center\":0,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1481609270,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{\"class\":\"\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"fadeInDown\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1481609271,\"addons\":[{\"name\":\"call_to_action\",\"title\":\"Call to Action\",\"id\":1481609272,\"settings\":{\"title\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit\",\"heading_selector\":\"h2\",\"title_fontsize\":\"24\",\"title_fontweight\":\"\",\"title_text_color\":\"#38434a\",\"title_margin_top\":\"0\",\"title_margin_bottom\":\"10\",\"subtitle\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elitsed do eiusmod tempor\",\"subtitle_fontsize\":\"14\",\"subtitle_fontweight\":\"\",\"subtitle_text_color\":\"\",\"text\":\"\",\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"button_text\":\"Download Now!\",\"button_url\":\"javascript:void(0)\",\"button_size\":\"\",\"button_type\":\"primary\",\"button_icon\":\"\",\"button_block\":\"\",\"button_target\":\"_blank\",\"button_position\":\"right\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"}]', 'com_sppagebuilder', 'page', 0, 0, 1, 0, 1, 0, '2015-01-22 07:12:35', 928, '2018-02-14 05:48:01', 928, 0, '0000-00-00 00:00:00', '', '', '', '*', 35, '');
INSERT INTO `#__sppagebuilder` (`id`, `asset_id`, `title`, `text`, `extension`, `extension_view`, `view_id`, `active`, `published`, `catid`, `access`, `ordering`, `created_on`, `created_by`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `og_title`, `og_image`, `og_description`, `language`, `hits`, `css`) VALUES
(9, 268, 'Construction', '[{\"layout\":12,\"settings\":{\"title\":\"\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"tixon-slider tixon-slider-construction\",\"padding\":\"\",\"margin\":\"\",\"fullscreen\":1},\"id\":1481612759,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{},\"id\":1481612760,\"addons\":[{\"name\":\"slideshow_full\",\"title\":\"Slideshow (Full Width)\",\"id\":1481612761,\"settings\":{\"layout\":\"layout2\",\"autoplay\":\"0\",\"controllers\":\"0\",\"arrows\":\"1\",\"background\":\"\",\"color\":\"\",\"class\":\"\",\"sp_slideshow_full_item\":[{\"title\":\"WE ARE EXPERIENCE COMPANY\",\"sub_title\":\"CREATIVE & PROFESSIONAL\",\"content\":\"\",\"bg\":\"images/construction/contstruct-slider3.jpg\",\"button_text\":\"DETAILS ABOUT\",\"button_url\":\"#\",\"button_size\":\"\",\"button_type\":\"default\",\"button_before_icon\":\"\",\"button_after_icon\":\"\",\"title_animation\":\"fadeInRightBig sppb-wow fadeInRightBig\",\"title_animationduration\":\"\",\"title_animationdelay\":\"\",\"subtitle_animation\":\"fadeInRightBig sppb-wow fadeInRightBig\",\"subtitle_animationduration\":\"\",\"subtitle_animationdelay\":\"200\",\"cotent_animation\":\"\",\"cotent_animationduration\":\"300\",\"cotent_animationdelay\":\"0\",\"button_animation\":\"fadeInRightBig sppb-wow fadeInRightBig\",\"button_animationduration\":\"\",\"button_animationdelay\":\"400\"},{\"title\":\"your trust is our strength\",\"sub_title\":\"your satisfaction. our concern.\",\"content\":\"\",\"bg\":\"images/construction/contstruct-slider2.jpg\",\"button_text\":\"VIEW OUR GALLERY\",\"button_url\":\"#\",\"button_size\":\"\",\"button_type\":\"default\",\"button_before_icon\":\"\",\"button_after_icon\":\"\",\"title_animation\":\"fadeInLeftBig sppb-wow fadeInLeftBig\",\"title_animationduration\":\"\",\"title_animationdelay\":\"\",\"subtitle_animation\":\"fadeInRightBig sppb-wow fadeInRightBig\",\"subtitle_animationduration\":\"\",\"subtitle_animationdelay\":\"200\",\"cotent_animation\":\"\",\"cotent_animationduration\":\"\",\"cotent_animationdelay\":\"\",\"button_animation\":\"zoomIn sppb-wow zoomIn\",\"button_animationduration\":\"\",\"button_animationdelay\":\"400\"},{\"title\":\"we build your dream\",\"sub_title\":\"great architecture. smart design\",\"content\":\"\",\"bg\":\"images/construction/contstruct-slider1.jpg\",\"button_text\":\"View OUR SERVICES\",\"button_url\":\"#\",\"button_size\":\"\",\"button_type\":\"default\",\"button_before_icon\":\"\",\"button_after_icon\":\"\",\"title_animation\":\"zoomInDown sppb-wow zoomInDown\",\"title_animationduration\":\"\",\"title_animationdelay\":\"\",\"subtitle_animation\":\"fadeInUpBig sppb-wow fadeInUpBig\",\"subtitle_animationduration\":\"\",\"subtitle_animationdelay\":\"200\",\"cotent_animation\":\"\",\"cotent_animationduration\":\"\",\"cotent_animationdelay\":\"\",\"button_animation\":\"fadeInUp sppb-wow fadeInUp\",\"button_animationduration\":\"\",\"button_animationdelay\":\"400\"}]},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"4,8\",\"settings\":{\"title_fontweight\":\"\",\"fullscreen\":0,\"margin\":{\"md\":\"90px 0 90px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"class\":\"construction-info\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontsize\":\"\",\"title\":\"\",\"instFormId\":1481612762,\"columns_align_center\":0,\"no_gutter\":0,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1481612762,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-4\",\"settings\":{\"class\":\" left-content\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"fadeInDown\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1481612763,\"addons\":[{\"name\":\"call_to_action\",\"title\":\"Call to Action\",\"id\":1481612764,\"settings\":{\"admin_label\":\"\",\"title\":\"REASONS TO WORK WITH US?\",\"heading_selector\":\"h3\",\"title_fontsize\":\"40\",\"title_lineheight\":\"\",\"title_fontstyle\":[\"bolder\"],\"title_letterspace\":\"0\",\"title_fontweight\":\"800\",\"title_text_color\":\"#0072bc\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"30\",\"subtitle\":\"Quisque sollicitudin tincidunt elit at vulputate. Praesent et sollicitudin libero. Morbi arcu neque\",\"subtitle_fontsize\":\"18\",\"subtitle_text_color\":\"\",\"text\":\"\",\"button_text\":\"\",\"button_fontstyle\":null,\"button_letterspace\":\"0\",\"button_url\":\"\",\"button_target\":\"\",\"button_position\":\"\",\"button_type\":\"default\",\"button_appearance\":\"\",\"button_background_color\":\"#444444\",\"button_color\":\"#ffffff\",\"button_background_color_hover\":\"#222222\",\"button_color_hover\":\"#ffffff\",\"button_size\":\"\",\"button_shape\":\"rounded\",\"button_block\":\"\",\"button_icon\":\"\",\"icon_position\":\"left\",\"class\":\"reason-to-work text-left\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0,\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"acl\":null,\"instFormId\":1481612764,\"use_global_width\":0},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-8\",\"settings\":{\"class\":\" right-content\",\"animationdelay\":200,\"animationduration\":\"\",\"animation\":\"fadeInDown\",\"padding\":\"0 0 0 30px\",\"color\":\"\",\"background\":\"\"},\"id\":1481612765,\"addons\":[{\"name\":\"call_to_action\",\"title\":\"Call to Action\",\"id\":1481612766,\"settings\":{\"title\":\"Professional Construction Services\",\"heading_selector\":\"h4\",\"title_fontsize\":\"18\",\"title_fontweight\":\"500\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"30\",\"subtitle\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. \",\"subtitle_fontsize\":\"14\",\"subtitle_fontweight\":\"\",\"subtitle_text_color\":\"\",\"text\":\"\",\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"button_text\":\"\",\"button_url\":\"\",\"button_size\":\"\",\"button_type\":\"default\",\"button_icon\":\"\",\"button_block\":\"\",\"button_target\":\"\",\"button_position\":\"right\",\"class\":\"\"},\"visibility\":1},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1481612767,\"settings\":{\"gap\":\"25\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"name\":\"button\",\"title\":\"Button\",\"id\":1481612768,\"settings\":{\"text\":\"GET A QUOTE\",\"url\":\"javascript:void(0)\",\"size\":\"\",\"type\":\"primary\",\"icon\":\"\",\"target\":\"\",\"block\":\"\",\"margin\":\"0 20px 0 0\",\"class\":\"btn-transparent\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{\"admin_label\":\"\",\"title\":\"RECENT PROJECTS\",\"heading_selector\":\"h2\",\"title_fontsize\":\"24\",\"title_fontweight\":\"\",\"title_text_color\":\"#38434a\",\"title_margin_top\":\"0\",\"title_margin_bottom\":\"10\",\"subtitle\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit sed <br>  eiusmod tempor incididunt ut labore et dolore\\n\\n\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"columns_equal_height\":\"0\",\"fullscreen\":\"0\",\"no_gutter\":\"0\",\"id\":\"\",\"class\":\"\",\"padding\":{\"md\":\"90px 0 90px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"\",\"background_color\":\"#f7f9fc\",\"background_image\":\"\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":\"0\",\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animation\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1481612769,\"columns_align_center\":0,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1481612769,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{\"class\":\" text-center\",\"animationdelay\":300,\"animationduration\":500,\"animation\":\"fadeIn\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1481612770,\"addons\":[{\"name\":\"module\",\"title\":\"Joomla Module\",\"id\":1481612771,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"id\":\"130\",\"class\":\"\"},\"visibility\":1},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1481612772,\"settings\":{\"gap\":\"30\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"name\":\"button\",\"title\":\"Button\",\"id\":1481612773,\"settings\":{\"text\":\"VIEW ALL PROJECT\",\"url\":\"index.php/portfolio\",\"size\":\"\",\"type\":\"primary\",\"icon\":\"\",\"target\":\"\",\"block\":\"\",\"margin\":\"0 20px 0 0\",\"class\":\"btn-transparent btn-view-all\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"4,4,4\",\"settings\":{\"fullscreen\":0,\"margin\":{\"md\":\"90px 0 0 0\",\"sm\":\"   \",\"xs\":\"   \"},\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"class\":\"construction-core-services\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"title_position\":\"sppb-text-center\",\"subtitle_fontsize\":\"\",\"subtitle\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit sed <br>  eiusmod tempor incididunt ut labore et dolore\\n\\n\",\"title_margin_bottom\":10,\"title_margin_top\":0,\"title_text_color\":\"#38434a\",\"title_fontweight\":\"\",\"title_fontsize\":24,\"heading_selector\":\"h2\",\"title\":\"CORE SERVICES\",\"instFormId\":1481612774,\"columns_align_center\":0,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1481612774,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-4\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInLeft\",\"animationduration\":\"\",\"animationdelay\":200,\"class\":\"\"},\"id\":1481612775,\"addons\":[{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1481612776,\"settings\":{\"gap\":\"60\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"name\":\"feature\",\"title\":\"Feature Box\",\"id\":1481612777,\"settings\":{\"title\":\"CLEAN & TRENDY DESIGN\",\"heading_selector\":\"h3\",\"title_fontsize\":\"16\",\"title_fontweight\":\"700\",\"title_text_color\":\"#38434a\",\"title_margin\":\"15px 0 20px 0\",\"title_url\":\"\",\"title_position\":\"after\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_type\":\"linea_icon\",\"icon_name\":\"fa-laptop\",\"linea_icon_name\":\"icon-basic-lock-open\",\"icon_size\":\"70\",\"icon_color\":\"\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"\",\"icon_margin_bottom\":\"\",\"icon_padding\":\"\",\"text\":\"Lorem ipsum dolor sit amet, consecttur adipisicing elit, sed.onsequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore.\",\"alignment\":\"sppb-text-right\",\"class\":\"\"},\"visibility\":1},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1481612778,\"settings\":{\"gap\":\"40\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"name\":\"feature\",\"title\":\"Feature Box\",\"id\":1481612779,\"settings\":{\"title\":\"CLEAN & TRENDY DESIGN\",\"heading_selector\":\"h3\",\"title_fontsize\":\"16\",\"title_fontweight\":\"700\",\"title_text_color\":\"#38434a\",\"title_margin\":\"15px 0 20px 0\",\"title_url\":\"\",\"title_position\":\"after\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_type\":\"linea_icon\",\"icon_name\":\"fa-laptop\",\"linea_icon_name\":\"icon-basic-anticlockwise\",\"icon_size\":\"70\",\"icon_color\":\"\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"\",\"icon_margin_bottom\":\"\",\"icon_padding\":\"\",\"text\":\"Lorem ipsum dolor sit amet, consecttur adipisicing elit, sed.onsequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore.\",\"alignment\":\"sppb-text-right\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-4\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeIn\",\"animationduration\":\"\",\"animationdelay\":400,\"class\":\"\"},\"id\":1481612780,\"addons\":[{\"name\":\"image\",\"title\":\"Image\",\"id\":1481612781,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"image\":\"images/construction/construction-worker.png\",\"alt_text\":\"\",\"position\":\"sppb-text-center\",\"link\":\"\",\"target\":\"\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-4\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInRight\",\"animationduration\":\"\",\"animationdelay\":200,\"class\":\"\"},\"id\":1481612782,\"addons\":[{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1481612783,\"settings\":{\"gap\":\"60\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"name\":\"feature\",\"title\":\"Feature Box\",\"id\":1481612784,\"settings\":{\"title\":\"CLEAN & TRENDY DESIGN\",\"heading_selector\":\"h3\",\"title_fontsize\":\"16\",\"title_fontweight\":\"700\",\"title_text_color\":\"#38434a\",\"title_margin\":\"15px 0 20px 0\",\"title_url\":\"\",\"title_position\":\"after\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_type\":\"linea_icon\",\"icon_name\":\"fa-laptop\",\"linea_icon_name\":\"icon-basic-notebook-pen\",\"icon_size\":\"70\",\"icon_color\":\"\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"\",\"icon_margin_bottom\":\"\",\"icon_padding\":\"\",\"text\":\"Lorem ipsum dolor sit amet, consecttur adipisicing elit, sed.onsequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore.\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"visibility\":1},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1481612785,\"settings\":{\"gap\":\"40\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"name\":\"feature\",\"title\":\"Feature Box\",\"id\":1481612786,\"settings\":{\"title\":\"CLEAN & TRENDY DESIGN\",\"heading_selector\":\"h3\",\"title_fontsize\":\"16\",\"title_fontweight\":\"700\",\"title_text_color\":\"#38434a\",\"title_margin\":\"15px 0 20px 0\",\"title_url\":\"\",\"title_position\":\"after\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_type\":\"linea_icon\",\"icon_name\":\"fa-laptop\",\"linea_icon_name\":\"icon-basic-mixer2\",\"icon_size\":\"70\",\"icon_color\":\"\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"\",\"icon_margin_bottom\":\"\",\"icon_padding\":\"\",\"text\":\"Lorem ipsum dolor sit amet, consecttur adipisicing elit, sed.onsequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore.\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{\"fullscreen\":0,\"margin\":{\"md\":\"0 0 70px \",\"sm\":\"   \",\"xs\":\"   \"},\"padding\":{\"md\":\"90px 0 70px \",\"sm\":\"   \",\"xs\":\"   \"},\"class\":\"\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_image\":\"\",\"color\":\"\",\"background_color\":\"#f7f9fc\",\"title_position\":\"sppb-text-center\",\"subtitle_fontsize\":16,\"subtitle\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit sed <br>  eiusmod tempor incididunt ut labore et dolore\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontweight\":600,\"title_fontsize\":24,\"heading_selector\":\"h2\",\"title\":\"LATEST NEWS\",\"instFormId\":1481612787,\"columns_align_center\":0,\"no_gutter\":0,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1481612787,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeIn\",\"animationduration\":500,\"animationdelay\":300,\"class\":\"\"},\"id\":1481612788,\"addons\":[{\"name\":\"latest_post\",\"title\":\"Latest Posts\",\"id\":1481612789,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"item_limit\":\"5\",\"intro_text_limit\":\"100\",\"category\":\"84\",\"class\":\"\",\"dynamicId\":1481612789},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{\"title_fontweight\":\"\",\"title\":\"\",\"title_fontsize\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"background_color\":\"#f7f9fc\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"tixon-call-to-action\",\"padding\":{\"md\":\"50px 0 50px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0   \",\"sm\":\"   \",\"xs\":\"   \"},\"fullscreen\":0,\"instFormId\":1481612790,\"columns_align_center\":0,\"no_gutter\":0,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1481612790,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{\"class\":\"\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"fadeInDown\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1481612791,\"addons\":[{\"name\":\"call_to_action\",\"title\":\"Call to Action\",\"id\":1481612792,\"settings\":{\"title\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"600\",\"title_text_color\":\"\",\"title_margin_top\":\"0\",\"title_margin_bottom\":\"10\",\"subtitle\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elitsed do eiusmod tempor\",\"subtitle_fontsize\":\"14\",\"subtitle_fontweight\":\"\",\"subtitle_text_color\":\"\",\"text\":\"\",\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"button_text\":\"Buy Now\",\"button_url\":\"javascript:void(0)\",\"button_size\":\"\",\"button_type\":\"primary\",\"button_icon\":\"\",\"button_block\":\"\",\"button_target\":\"\",\"button_position\":\"right\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"3,3,3,3\",\"settings\":{\"title\":\"HAPPY CLIENTS\",\"heading_selector\":\"h2\",\"title_fontsize\":24,\"title_fontweight\":600,\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":15,\"subtitle\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit  sed do <br> eiusmod tempor incididunt ut labore et dolore\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"tixon-happy-clients\",\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"70px 0 90px \",\"sm\":\"   \",\"xs\":\"   \"},\"fullscreen\":0,\"instFormId\":1481612793,\"columns_align_center\":0,\"no_gutter\":0,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1481612793,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-3\",\"settings\":{\"class\":\"\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"fadeInLeft\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1481612794,\"addons\":[{\"name\":\"image\",\"title\":\"Image\",\"id\":1481612795,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"image\":\"images/clients/client1.png\",\"alt_text\":\"\",\"position\":\"sppb-text-center\",\"link\":\"http://\",\"target\":\"\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"class\":\"\",\"animationdelay\":200,\"animationduration\":\"\",\"animation\":\"fadeInLeft\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1481612796,\"addons\":[{\"name\":\"image\",\"title\":\"Image\",\"id\":1481612797,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"image\":\"images/clients/client2.png\",\"alt_text\":\"\",\"position\":\"sppb-text-center\",\"link\":\"http://\",\"target\":\"\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"class\":\"\",\"animationdelay\":400,\"animationduration\":\"\",\"animation\":\"fadeInLeft\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1481612798,\"addons\":[{\"name\":\"image\",\"title\":\"Image\",\"id\":1481612799,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"image\":\"images/clients/client3.png\",\"alt_text\":\"\",\"position\":\"sppb-text-center\",\"link\":\"http://\",\"target\":\"\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3 active-column-parent\",\"settings\":{\"class\":\"\",\"animationdelay\":600,\"animationduration\":\"\",\"animation\":\"fadeInLeft\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1481612800,\"addons\":[{\"name\":\"image\",\"title\":\"Image\",\"id\":1481612801,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"image\":\"images/clients/client4.png\",\"alt_text\":\"\",\"position\":\"sppb-text-center\",\"link\":\"http://\",\"target\":\"\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"}]', 'com_sppagebuilder', 'page', 0, 0, 1, 0, 1, 0, '2015-08-26 06:58:40', 928, '2018-02-14 06:04:27', 928, 0, '0000-00-00 00:00:00', '', '', '', '*', 31, ''),
(10, 266, 'About Us', '[{\"layout\":\"7,5\",\"settings\":{\"admin_label\":\"\",\"separator1\":\"\",\"title\":\"\",\"heading_selector\":\"h2\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"separator2\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"18\",\"title_position\":\"sppb-text-left\",\"columns_equal_height\":\"0\",\"fullscreen\":\"0\",\"no_gutter\":\"0\",\"id\":\"\",\"class\":\"tixon-about-us\",\"padding\":\"90px 0px 90px 0px\",\"margin\":\"\",\"color\":\"\",\"background_color\":\"\",\"background_image\":\"\",\"background_parallax\":\"0\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":\"0\",\"external_background_video\":\"0\",\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"background_external_video\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animation\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"id\":1481537663,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-7\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"0 60px 0 0\",\"animation\":\"fadeInDown\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\" left-part\"},\"id\":1481537664,\"addons\":[{\"name\":\"heading\",\"title\":\"Addon Heading\",\"id\":1481537665,\"settings\":{\"heading_style\":\"style1\",\"title\":\"WHO WE ARE\",\"heading_selector\":\"h2\",\"use_link\":\"0\",\"title_link\":\"\",\"link_new_tab\":\"0\",\"title_fontsize\":\"16\",\"title_fontstyle\":null,\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_margin\":\"0px 0px 20px 0px\",\"title_padding\":\"0px 0px 0px 0px\",\"alignment\":\"sppb-text-left\",\"subtitle\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam\",\"subtitle_fontsize\":\"18\",\"subtitle_fontweight\":\"400\",\"subtitle_text_color\":\"\",\"global_options\":\"\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_boxshadow\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null},\"visibility\":1},{\"name\":\"text_block\",\"title\":\"Text Block\",\"id\":1481537666,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"text\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Sed ut perspiciatis unde omnis iste natus erro.\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-5\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"0 60px 0 0\",\"animation\":\"fadeInDown\",\"animationduration\":\"\",\"animationdelay\":200,\"class\":\" right-part\"},\"id\":1481537667,\"addons\":[{\"name\":\"animated_number\",\"title\":\"Animated Number\",\"id\":1481537668,\"settings\":{\"number\":\"178\",\"duration\":\"3000\",\"counter_title\":\"Complete Project\",\"alignment\":\"sppb-text-center\",\"font_size\":\"48\",\"color\":\"\",\"title_font_size\":\"16\",\"counter_color\":\"\",\"background\":\"\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"\",\"class\":\"font-blod border-right border-bottom padding\"},\"visibility\":1},{\"name\":\"animated_number\",\"title\":\"Animated Number\",\"id\":1481537669,\"settings\":{\"number\":\"30000\",\"duration\":\"3000\",\"counter_title\":\"Happy Clients\",\"alignment\":\"sppb-text-center\",\"font_size\":\"48\",\"color\":\"\",\"title_font_size\":\"16\",\"counter_color\":\"\",\"background\":\"\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"\",\"class\":\"font-blod padding border-bottom\"},\"visibility\":1},{\"name\":\"animated_number\",\"title\":\"Animated Number\",\"id\":1481537670,\"settings\":{\"number\":\"29\",\"duration\":\"300\",\"counter_title\":\"Winning Awards\",\"alignment\":\"sppb-text-center\",\"font_size\":\"48\",\"color\":\"\",\"title_font_size\":\"16\",\"counter_color\":\"\",\"background\":\"\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"\",\"class\":\"font-blod padding border-right \"},\"visibility\":1},{\"name\":\"animated_number\",\"title\":\"Animated Number\",\"id\":1481537671,\"settings\":{\"number\":\"9\",\"duration\":\"1000\",\"counter_title\":\"Years of Experience\",\"alignment\":\"sppb-text-center\",\"font_size\":\"48\",\"color\":\"\",\"title_font_size\":\"16\",\"counter_color\":\"\",\"background\":\"\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"\",\"class\":\"font-blod padding \"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{\"admin_label\":\"\",\"separator1\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"separator2\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"columns_equal_height\":\"0\",\"fullscreen\":\"1\",\"no_gutter\":\"0\",\"id\":\"\",\"class\":\"\",\"padding\":\"\",\"margin\":\"0px 0px 0px 0px\",\"color\":\"\",\"background_color\":\"#f7f9fc\",\"background_image\":\"\",\"background_parallax\":\"0\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":\"0\",\"external_background_video\":\"0\",\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"background_external_video\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animation\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"id\":1481537672,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeIn\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\"\"},\"id\":1481537673,\"addons\":[{\"name\":\"image_content\",\"title\":\"Image Content\",\"id\":1481537674,\"settings\":{\"image\":\"images/demo/about1.jpg\",\"image_alignment\":\"left\",\"title\":\"WHY WE ARE DIFFERENT\",\"heading_selector\":\"h3\",\"title_fontsize\":\"16\",\"title_fontweight\":\"700\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"20\",\"text\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.<br /><br />Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Sed ut perspiciatis unde omnis iste natus erro.<br /><br /><br />\",\"button_text\":\"Learn More\",\"button_url\":\"#\",\"button_size\":\"\",\"button_type\":\"primary\",\"button_icon\":\"\",\"button_block\":\"\",\"button_target\":\"\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"3,3,3,3\",\"settings\":{\"title_fontweight\":700,\"fullscreen\":0,\"margin\":{\"md\":\"90px 0 90px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"class\":\"heading-style1\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"subtitle_fontsize\":24,\"subtitle\":\"We Craft Awesome Things\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontsize\":16,\"title\":\"TEAM MEMBERS\",\"instFormId\":1481537675,\"columns_align_center\":0,\"no_gutter\":0,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1481537675,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-3\",\"settings\":{\"class\":\"\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"fadeInRight\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1481537676,\"addons\":[{\"name\":\"person\",\"title\":\"Person\",\"id\":1481537677,\"settings\":{\"image\":\"images/demo/team/team1.jpg\",\"name\":\"John Doe\",\"designation\":\"CEO & Founder\",\"facebook\":\"#fa\",\"twitter\":\"\",\"google_plus\":\"\",\"youtube\":\"\",\"linkedin\":\"\",\"pinterest\":\"\",\"flickr\":\"#\",\"dribbble\":\"#\",\"behance\":\"#\",\"instagram\":\"#\",\"alignment\":\"sppb-text-left\",\"class\":\"\",\"instFormId\":1481537677,\"social_position\":\"after\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"class\":\"\",\"animationdelay\":200,\"animationduration\":\"\",\"animation\":\"fadeInRight\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1481537678,\"addons\":[{\"name\":\"person\",\"title\":\"Person\",\"id\":1481537679,\"settings\":{\"image\":\"images/demo/team/team2.jpg\",\"name\":\"Michel Jacky\",\"designation\":\"Developer\",\"facebook\":\"\",\"twitter\":\"\",\"google_plus\":\"\",\"youtube\":\"\",\"linkedin\":\"#\",\"pinterest\":\"#\",\"flickr\":\"\",\"dribbble\":\"#\",\"behance\":\"\",\"instagram\":\"\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"class\":\"\",\"animationdelay\":400,\"animationduration\":\"\",\"animation\":\"fadeInRight\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1481537680,\"addons\":[{\"name\":\"person\",\"title\":\"Person\",\"id\":1481537681,\"settings\":{\"image\":\"images/demo/team/team3.jpg\",\"name\":\"Alus Chashi\",\"designation\":\"Designer\",\"facebook\":\"http://www.facebook.com/joomshaper\",\"twitter\":\"http://twitter.com/joomshaper\",\"google_plus\":\"http://plus.google.com/+Joomshapers\",\"youtube\":\"#\",\"linkedin\":\"#\",\"pinterest\":\"\",\"flickr\":\"\",\"dribbble\":\"\",\"behance\":\"\",\"instagram\":\"\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"class\":\"\",\"animationdelay\":600,\"animationduration\":\"\",\"animation\":\"fadeInRight\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1481537682,\"addons\":[{\"name\":\"person\",\"title\":\"Person\",\"id\":1481537683,\"settings\":{\"image\":\"images/demo/team/team4.jpg\",\"name\":\"Andru Katter\",\"designation\":\"Manager\",\"facebook\":\"\",\"twitter\":\"\",\"google_plus\":\"\",\"youtube\":\"\",\"linkedin\":\"\",\"pinterest\":\"\",\"flickr\":\"\",\"dribbble\":\"\",\"behance\":\"#\",\"instagram\":\"\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"3,3,3,3\",\"settings\":{\"fullscreen\":0,\"margin\":{\"md\":\"0px 0px 0 0\",\"sm\":\"   \",\"xs\":\"   \"},\"padding\":{\"md\":\"90px 0 90px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"class\":\"heading-style1 tixon-skills\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_image\":\"\",\"color\":\"\",\"background_color\":\"#f7f9fc\",\"title_position\":\"sppb-text-left\",\"subtitle_fontsize\":24,\"subtitle\":\"Powerful Super heros skill \",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontweight\":600,\"title_fontsize\":16,\"heading_selector\":\"h2\",\"title\":\"OUR SKILLS\",\"instFormId\":1481537684,\"columns_align_center\":0,\"no_gutter\":0,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1481537684,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-3\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\"\"},\"id\":1481537685,\"addons\":[{\"name\":\"progress_bar\",\"title\":\"Progress Bar\",\"id\":1481537686,\"settings\":{\"type\":\"sppb-progress-bar-primary\",\"progress\":\"85\",\"text\":\"Web Design\",\"stripped\":\"\",\"active\":\"active\",\"class\":\"\",\"dynamicId\":1481537686},\"visibility\":1},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1481537687,\"settings\":{\"gap\":\"50\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"1\",\"class\":\"\"},\"visibility\":1},{\"name\":\"progress_bar\",\"title\":\"Progress Bar\",\"id\":1481537688,\"settings\":{\"type\":\"sppb-progress-bar-primary\",\"progress\":\"45\",\"text\":\"MOTION GRAPICHS\",\"stripped\":\"\",\"active\":\"\",\"class\":\"\",\"dynamicId\":1481537688},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{},\"id\":1481537689,\"addons\":[{\"name\":\"progress_bar\",\"title\":\"Progress Bar\",\"id\":1481537690,\"settings\":{\"type\":\"sppb-progress-bar-primary\",\"progress\":\"75\",\"text\":\"HTML & CSS\",\"stripped\":\"\",\"active\":\"\",\"class\":\"\",\"dynamicId\":1481537690},\"visibility\":1},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1481537691,\"settings\":{\"gap\":\"50\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"1\",\"class\":\"\"},\"visibility\":1},{\"name\":\"progress_bar\",\"title\":\"Progress Bar\",\"id\":1481537692,\"settings\":{\"type\":\"sppb-progress-bar-primary\",\"progress\":\"96\",\"text\":\"JOOMLA\",\"stripped\":\"\",\"active\":\"\",\"class\":\"\",\"dynamicId\":1481537692},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{},\"id\":1481537693,\"addons\":[{\"name\":\"progress_bar\",\"title\":\"Progress Bar\",\"id\":1481537694,\"settings\":{\"type\":\"sppb-progress-bar-primary\",\"progress\":\"95\",\"text\":\"WEB DEVELOPMENT\",\"stripped\":\"\",\"active\":\"\",\"class\":\"\",\"dynamicId\":1481537694},\"visibility\":1},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1481537695,\"settings\":{\"gap\":\"50\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"1\",\"class\":\"\"},\"visibility\":1},{\"name\":\"progress_bar\",\"title\":\"Progress Bar\",\"id\":1481537696,\"settings\":{\"type\":\"sppb-progress-bar-primary\",\"progress\":\"85\",\"text\":\"Web Design\",\"stripped\":\"\",\"active\":\"active\",\"class\":\"\",\"dynamicId\":1481537696},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{},\"id\":1481537697,\"addons\":[{\"name\":\"progress_bar\",\"title\":\"Progress Bar\",\"id\":1481537698,\"settings\":{\"type\":\"sppb-progress-bar-primary\",\"progress\":\"80\",\"text\":\"PHOTOGRAPHY\",\"stripped\":\"\",\"active\":\"\",\"class\":\"\",\"dynamicId\":1481537698},\"visibility\":1},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1481537699,\"settings\":{\"gap\":\"50\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"1\",\"class\":\"\"},\"visibility\":1},{\"name\":\"progress_bar\",\"title\":\"Progress Bar\",\"id\":1481537700,\"settings\":{\"type\":\"sppb-progress-bar-primary\",\"progress\":\"95\",\"text\":\"WEB DEVELOPMENT\",\"stripped\":\"\",\"active\":\"\",\"class\":\"\",\"dynamicId\":1481537700},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"4,4,4\",\"settings\":{\"title_fontweight\":600,\"title\":\"HAPPY CLIENTS\",\"title_fontsize\":16,\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"Powerful Super heros skill \",\"subtitle_fontsize\":24,\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"heading-style1 tixon-clients-feedback\",\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"90px 0 90px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"fullscreen\":0,\"heading_selector\":\"h2\",\"title_position\":\"sppb-text-left\",\"instFormId\":1481537701,\"columns_align_center\":0,\"no_gutter\":0,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1481537701,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-4\",\"settings\":{\"class\":\"\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"fadeInLeft\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1481537702,\"addons\":[{\"name\":\"feature\",\"title\":\"Feature Box\",\"id\":1481537703,\"settings\":{\"title\":\"ALEXANDER PAYNOM (DEVELOPER)\",\"heading_selector\":\"h3\",\"title_fontsize\":\"16\",\"title_fontweight\":\"700\",\"title_text_color\":\"\",\"title_margin\":\"10px 0 15px 0\",\"title_url\":\"\",\"title_position\":\"after\",\"feature_type\":\"image\",\"feature_image\":\"images/demo/testimonial/testimonial1.jpg\",\"icon_type\":\"fontawesome_icon\",\"icon_name\":\"\",\"linea_icon_name\":\"0\",\"icon_size\":\"36\",\"icon_color\":\"\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"\",\"icon_margin_bottom\":\"\",\"icon_padding\":\"\",\"text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer adipiscing erat eget risus sollicitudin pellentesque et non erat. \",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-4\",\"settings\":{\"class\":\"\",\"animationdelay\":200,\"animationduration\":\"\",\"animation\":\"fadeInLeft\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1481537704,\"addons\":[{\"name\":\"feature\",\"title\":\"Feature Box\",\"id\":1481537705,\"settings\":{\"title\":\"JENNIFER PAYA (CEO. ROBIND)\",\"heading_selector\":\"h3\",\"title_fontsize\":\"16\",\"title_fontweight\":\"700\",\"title_text_color\":\"\",\"title_margin\":\"10px 0 15px 0\",\"title_url\":\"\",\"title_position\":\"after\",\"feature_type\":\"image\",\"feature_image\":\"images/demo/testimonial/testimonial2.jpg\",\"icon_type\":\"fontawesome_icon\",\"icon_name\":\"\",\"linea_icon_name\":\"0\",\"icon_size\":\"36\",\"icon_color\":\"\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"\",\"icon_margin_bottom\":\"\",\"icon_padding\":\"\",\"text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer adipiscing erat eget risus sollicitudin pellentesque et non erat. \",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-4\",\"settings\":{\"class\":\"\",\"animationdelay\":400,\"animationduration\":\"\",\"animation\":\"fadeInLeft\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1481537706,\"addons\":[{\"name\":\"feature\",\"title\":\"Feature Box\",\"id\":1481537707,\"settings\":{\"title\":\"JOHN SMITH (DESIGNER)\",\"heading_selector\":\"h3\",\"title_fontsize\":\"16\",\"title_fontweight\":\"700\",\"title_text_color\":\"\",\"title_margin\":\"10px 0 15px 0\",\"title_url\":\"\",\"title_position\":\"after\",\"feature_type\":\"image\",\"feature_image\":\"images/demo/testimonial/testimonial3.jpg\",\"icon_type\":\"fontawesome_icon\",\"icon_name\":\"\",\"linea_icon_name\":\"0\",\"icon_size\":\"36\",\"icon_color\":\"\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"\",\"icon_margin_bottom\":\"\",\"icon_padding\":\"\",\"text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer adipiscing erat eget risus sollicitudin pellentesque et non erat. \",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{\"fullscreen\":0,\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"padding\":{\"md\":\"60px 0 60px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"class\":\"tixon-call-to-action\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_image\":\"\",\"color\":\"\",\"background_color\":\"#f2f4f7\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontweight\":\"\",\"title_fontsize\":\"\",\"title\":\"\",\"instFormId\":1481537708,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1481537708,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12 active-column-parent\",\"settings\":{\"class\":\"\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"fadeInUp\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1481537709,\"addons\":[{\"name\":\"call_to_action\",\"title\":\"Call to Action\",\"id\":1481537710,\"settings\":{\"title\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"600\",\"title_text_color\":\"\",\"title_margin_top\":\"0\",\"title_margin_bottom\":\"10\",\"subtitle\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elitsed do eiusmod tempor\",\"subtitle_fontsize\":\"14\",\"subtitle_fontweight\":\"\",\"subtitle_text_color\":\"\",\"text\":\"\",\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"button_text\":\"BUY NOW\",\"button_url\":\"#\",\"button_size\":\"\",\"button_type\":\"primary\",\"button_icon\":\"\",\"button_block\":\"\",\"button_target\":\"\",\"button_position\":\"right\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"}]', 'com_sppagebuilder', 'page', 0, 0, 1, 0, 1, 0, '2015-01-22 07:12:35', 928, '2018-02-14 06:55:54', 928, 0, '0000-00-00 00:00:00', '', '', '', '*', 92, '');
INSERT INTO `#__sppagebuilder` (`id`, `asset_id`, `title`, `text`, `extension`, `extension_view`, `view_id`, `active`, `published`, `catid`, `access`, `ordering`, `created_on`, `created_by`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `og_title`, `og_image`, `og_description`, `language`, `hits`, `css`) VALUES
(13, 265, 'service', '[{\"layout\":\"3,3,3,3\",\"settings\":{\"admin_label\":\"\",\"separator1\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"separator2\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"columns_equal_height\":\"0\",\"fullscreen\":\"0\",\"no_gutter\":\"0\",\"id\":\"\",\"class\":\"tixon-features\",\"padding\":\"90px 0 90px 0\",\"margin\":\"\",\"color\":\"\",\"background_color\":\"\",\"background_image\":\"\",\"background_parallax\":\"0\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":\"0\",\"external_background_video\":\"0\",\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"background_external_video\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animation\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"id\":1481606502283,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-3\",\"settings\":{\"class\":\"\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"fadeInDown\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1480329818,\"addons\":[{\"name\":\"feature\",\"title\":\"Feature Box\",\"id\":1480329819,\"settings\":{\"title\":\"CLEAN & TRENDY DESIGN\",\"heading_selector\":\"h3\",\"title_fontsize\":\"16\",\"title_fontweight\":\"600\",\"title_text_color\":\"#38434a\",\"title_margin\":\"25px 0 25px 0\",\"title_url\":\"\",\"title_position\":\"after\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_type\":\"linea_icon\",\"icon_name\":\"fa-laptop\",\"linea_icon_name\":\"icon-basic-helm\",\"icon_size\":\"70\",\"icon_color\":\"\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"\",\"icon_margin_bottom\":\"\",\"icon_padding\":\"\",\"text\":\"Sirloin pork loine beefb andoe uillen capicola shank swine chuck flank\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"class\":\"\",\"animationdelay\":200,\"animationduration\":\"\",\"animation\":\"fadeInDown\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1480329820,\"addons\":[{\"name\":\"feature\",\"title\":\"Feature Box\",\"id\":1480329821,\"settings\":{\"title\":\"UNLIMITED OPTIONS\",\"heading_selector\":\"h3\",\"title_fontsize\":\"16\",\"title_fontweight\":\"600\",\"title_text_color\":\"#38434a\",\"title_margin\":\"25px 0 25px 0\",\"title_url\":\"\",\"title_position\":\"after\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_type\":\"linea_icon\",\"icon_name\":\"fa-laptop\",\"linea_icon_name\":\"icon-basic-lightbulb\",\"icon_size\":\"70\",\"icon_color\":\"\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"0\",\"icon_margin_bottom\":\"\",\"icon_padding\":\"\",\"text\":\"Sirloin pork loine beefb andoe uillen capicola shank swine chuck flank\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"class\":\"\",\"animationdelay\":400,\"animationduration\":\"\",\"animation\":\"fadeInDown\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1480329822,\"addons\":[{\"name\":\"feature\",\"title\":\"Feature Box\",\"id\":1480329823,\"settings\":{\"title\":\"A TOUCH OF INDIVIDUALITY\",\"heading_selector\":\"h3\",\"title_fontsize\":\"16\",\"title_fontweight\":\"600\",\"title_text_color\":\"#38434a\",\"title_margin\":\"25px 0 25px 0\",\"title_url\":\"\",\"title_position\":\"after\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_type\":\"linea_icon\",\"icon_name\":\"fa-laptop\",\"linea_icon_name\":\"icon-basic-chronometer\",\"icon_size\":\"70\",\"icon_color\":\"\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"0\",\"icon_margin_bottom\":\"\",\"icon_padding\":\"\",\"text\":\"Sirloin pork loine beefb andoe uillen capicola shank swine chuck flank\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3 active-column-parent\",\"settings\":{\"class\":\"\",\"animationdelay\":600,\"animationduration\":\"\",\"animation\":\"fadeInDown\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1480329824,\"addons\":[{\"name\":\"feature\",\"title\":\"Feature Box\",\"id\":1480329825,\"settings\":{\"title\":\"BASED ON NEGOTIATIONS\",\"heading_selector\":\"h3\",\"title_fontsize\":\"16\",\"title_fontweight\":\"600\",\"title_text_color\":\"#38434a\",\"title_margin\":\"25px 0 25px 0\",\"title_url\":\"\",\"title_position\":\"after\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_type\":\"linea_icon\",\"icon_name\":\"fa-laptop\",\"linea_icon_name\":\"icon-basic-headset\",\"icon_size\":\"70\",\"icon_color\":\"\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"0\",\"icon_margin_bottom\":\"\",\"icon_padding\":\"\",\"text\":\"Sirloin pork loine beefb andoe uillen capicola shank swine chuck flank\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"4,4,4\",\"settings\":{\"admin_label\":\"\",\"separator1\":\"\",\"title\":\"CORE SERVICES\",\"heading_selector\":\"h2\",\"title_fontsize\":\"16\",\"title_fontweight\":\"700\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"separator2\":\"\",\"subtitle\":\"What actually we do\",\"subtitle_fontsize\":\"24\",\"title_position\":\"sppb-text-left\",\"columns_equal_height\":\"0\",\"fullscreen\":0,\"no_gutter\":0,\"id\":\"\",\"class\":\"heading-style1 tixon-core-services\",\"padding\":{\"md\":\"90px 0 90px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"\",\"background_color\":\"#f7f9fc\",\"background_image\":\"\",\"background_parallax\":\"0\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":\"0\",\"external_background_video\":\"0\",\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"background_external_video\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animation\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1481606501,\"columns_align_center\":0,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1481606501,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-4\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInLeft\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\" each-service\"},\"id\":1481606502,\"addons\":[{\"name\":\"feature\",\"title\":\"Feature Box\",\"id\":1481606503,\"settings\":{\"title\":\"CLEAN & TRENDY DESIGN\",\"heading_selector\":\"h3\",\"title_fontsize\":\"16\",\"title_fontweight\":\"600\",\"title_text_color\":\"#38434a\",\"title_margin\":\"25px 0 25px 0\",\"title_url\":\"\",\"title_position\":\"after\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_type\":\"linea_icon\",\"icon_name\":\"fa-laptop\",\"linea_icon_name\":\"icon-basic-laptop\",\"icon_size\":\"70\",\"icon_color\":\"\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"\",\"icon_margin_bottom\":\"\",\"icon_padding\":\"\",\"text\":\"Lorem ipsum dolor sit amet, consecttur adipisicing elit, sed.onsequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore.\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"visibility\":1},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1481606504,\"settings\":{\"gap\":\"25\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"name\":\"text_block\",\"title\":\"Text Block\",\"id\":1481606505,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"text\":\"<ul>\\n<li>Web Design</li>\\n<li>Web Development</li>\\n<li>Digital Strategy</li>\\n<li>Information Architecture</li>\\n<li>Copywriting</li>\\n</ul>\",\"alignment\":\"sppb-text-left\",\"class\":\"service-list-item\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-4\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInLeft\",\"animationduration\":\"\",\"animationdelay\":200,\"class\":\" each-service\"},\"id\":1481606506,\"addons\":[{\"name\":\"feature\",\"title\":\"Feature Box\",\"id\":1481606507,\"settings\":{\"title\":\"CLEAN & TRENDY DESIGN\",\"heading_selector\":\"h3\",\"title_fontsize\":\"16\",\"title_fontweight\":\"600\",\"title_text_color\":\"#38434a\",\"title_margin\":\"25px 0 25px 0\",\"title_url\":\"\",\"title_position\":\"after\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_type\":\"linea_icon\",\"icon_name\":\"fa-laptop\",\"linea_icon_name\":\"icon-basic-postcard-multiple\",\"icon_size\":\"70\",\"icon_color\":\"\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"\",\"icon_margin_bottom\":\"\",\"icon_padding\":\"\",\"text\":\"Lorem ipsum dolor sit amet, consecttur adipisicing elit, sed.onsequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore.\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"visibility\":1},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1481606508,\"settings\":{\"gap\":\"25\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"name\":\"text_block\",\"title\":\"Text Block\",\"id\":1481606509,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"text\":\"<ul>\\n<li>Web Design</li>\\n<li>Web Development</li>\\n<li>Digital Strategy</li>\\n<li>Information Architecture</li>\\n<li>Copywriting</li>\\n</ul>\",\"alignment\":\"sppb-text-left\",\"class\":\"service-list-item\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-4\",\"settings\":{\"class\":\" each-service\",\"animationdelay\":400,\"animationduration\":\"\",\"animation\":\"fadeInLeft\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1481606510,\"addons\":[{\"name\":\"feature\",\"title\":\"Feature Box\",\"id\":1481606511,\"settings\":{\"title\":\"JOOMLA & HELIX FRAMEWORK\",\"heading_selector\":\"h3\",\"title_fontsize\":\"16\",\"title_fontweight\":\"600\",\"title_text_color\":\"#38434a\",\"title_margin\":\"25px 0 25px 0\",\"title_url\":\"\",\"title_position\":\"after\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_type\":\"linea_icon\",\"icon_name\":\"fa-laptop\",\"linea_icon_name\":\"icon-basic-folder-multiple\",\"icon_size\":\"70\",\"icon_color\":\"\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"\",\"icon_margin_bottom\":\"\",\"icon_padding\":\"\",\"text\":\"Lorem ipsum dolor sit amet, consecttur adipisicing elit, sed.onsequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore.\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"visibility\":1},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1481606512,\"settings\":{\"gap\":\"25\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"name\":\"text_block\",\"title\":\"Text Block\",\"id\":1481606513,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"text\":\"<ul>\\n<li>Web Design</li>\\n<li>Web Development</li>\\n<li>Digital Strategy</li>\\n<li>Information Architecture</li>\\n<li>Copywriting</li>\\n</ul>\",\"alignment\":\"sppb-text-left\",\"class\":\"service-list-item\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"6,6\",\"settings\":{\"title\":\"\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"lawyer-accordion\",\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"90px 0 90px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"fullscreen\":0,\"instFormId\":1481606514,\"columns_align_center\":0,\"no_gutter\":0,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1481606514,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-6\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInLeft\",\"animationduration\":\"\",\"animationdelay\":200,\"class\":\"\"},\"id\":1481606515,\"addons\":[{\"name\":\"heading\",\"title\":\"Addon Heading\",\"id\":1481606516,\"settings\":{\"style\":\"style1\",\"title\":\"WHY US\",\"heading_selector\":\"h3\",\"title_fontsize\":\"16\",\"title_fontweight\":\"700\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"Why Choose Excutive\",\"subtitle_fontsize\":\"\",\"subtitle_fontweight\":\"24\",\"subtitle_text_color\":\"\",\"instFormId\":1481606516,\"use_link\":0,\"title_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"alignment\":\"sppb-text-left\"},\"visibility\":1},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1481606517,\"settings\":{\"gap\":\"50\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"name\":\"accordion\",\"title\":\"Accordion\",\"id\":1481606518,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"#38434a\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"50\",\"style\":\"panel-default\",\"class\":\"accordion-service\",\"sp_accordion_item\":[{\"title\":\"What is lorem ipsum dolor sit amet ?\",\"icon\":\"\",\"content\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\"},{\"title\":\"Sed do eiusmod tempor incididunt ut labore et dolore ?\",\"icon\":\"\",\"content\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\"},{\"title\":\"Duis aute irure dolor in reprehenderit in voluptate velit esse cillum ?\",\"icon\":\"\",\"content\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\"}]},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-6\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInRight\",\"animationduration\":\"\",\"animationdelay\":200,\"class\":\"\"},\"id\":1481606519,\"addons\":[{\"name\":\"heading\",\"title\":\"Addon Heading\",\"id\":1481606520,\"settings\":{\"style\":\"style1\",\"title\":\"UNCOMPROMISING QUALITY\",\"heading_selector\":\"h3\",\"title_fontsize\":\"16\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"Had a idea? We can help you...\",\"subtitle_fontsize\":\"24\",\"subtitle_fontweight\":\"\",\"subtitle_text_color\":\"\",\"instFormId\":1481606520,\"title_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"alignment\":\"sppb-text-left\"},\"visibility\":1},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1481606521,\"settings\":{\"gap\":\"50\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"name\":\"tab\",\"title\":\"Tabs\",\"id\":1481606522,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"50\",\"style\":\"tabs\",\"class\":\"tab-service\",\"sp_tab_item\":[{\"title\":\"WORDPRESS\",\"icon\":\"\",\"content\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor.<br /><br />Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod.\"},{\"title\":\"JOOOMLA\",\"icon\":\"\",\"content\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor.<br /><br />Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod.\"},{\"title\":\"ANIMATIONS\",\"icon\":\"\",\"content\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor.<br /><br />Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod.\"}]},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{\"fullscreen\":0,\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"padding\":{\"md\":\"50px 0 50px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"class\":\"tixon-call-to-action\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_image\":\"\",\"color\":\"\",\"background_color\":\"#f7f9fc\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontweight\":\"\",\"title_fontsize\":\"\",\"title\":\"\",\"instFormId\":1481606523,\"columns_align_center\":0,\"no_gutter\":0,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1481606523,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12 active-column-parent\",\"settings\":{\"class\":\"\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"fadeInUp\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1481606524,\"addons\":[{\"name\":\"call_to_action\",\"title\":\"Call to Action\",\"id\":1481606525,\"settings\":{\"title\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"600\",\"title_text_color\":\"\",\"title_margin_top\":\"0\",\"title_margin_bottom\":\"10\",\"subtitle\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elitsed do eiusmod tempor\",\"subtitle_fontsize\":\"14\",\"subtitle_fontweight\":\"\",\"subtitle_text_color\":\"\",\"text\":\"\",\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"button_text\":\"Buy Now\",\"button_url\":\"#\",\"button_size\":\"\",\"button_type\":\"primary\",\"button_icon\":\"\",\"button_block\":\"\",\"button_target\":\"\",\"button_position\":\"right\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"}]', 'com_sppagebuilder', 'page', 0, 0, 1, 0, 1, 0, '2015-08-27 09:07:49', 928, '2018-02-14 06:58:32', 928, 0, '0000-00-00 00:00:00', '', '', '', '*', 40, ''),
(14, 274, 'Tixon-Pricing', '[{\"layout\":\"4,4,4\",\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"pricing-style1\",\"padding\":\"\",\"margin\":\"90px 0\",\"fullscreen\":0},\"id\":1518591534,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-4\",\"settings\":{\"class\":\"\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"fadeInLeft\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1518591535,\"addons\":[{\"name\":\"pricing\",\"title\":\"Pricing Table\",\"id\":1518591536,\"settings\":{\"title\":\"Basic\",\"price\":\"29\",\"duration\":\"\",\"pricing_content\":\"Lorem ipsum dolor sit amet, \\nconsectetur adipisicing\\nincididunt ut labore et dolore magna\\nUt enim ad minim veniam\\nquis nostrud\",\"button_text\":\"Buy Now\",\"button_url\":\"#\",\"button_size\":\"\",\"button_type\":\"default\",\"button_icon\":\"\",\"button_block\":\"\",\"background\":\"\",\"color\":\"\",\"featured\":\"\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"instFormId\":1518591536,\"price_position\":\"after\",\"price_symbol\":\"$\",\"price_symbol_alignment\":\"middle\",\"price_symbol_font_size\":{\"md\":\"36\",\"sm\":\"\",\"xs\":\"\"}},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-4\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInLeft\",\"animationduration\":\"\",\"animationdelay\":200,\"class\":\"\"},\"id\":1518591537,\"addons\":[{\"name\":\"pricing\",\"title\":\"Pricing Table\",\"id\":1518591538,\"settings\":{\"title\":\"Standard\",\"price\":\"29\",\"duration\":\"\",\"pricing_content\":\"Lorem ipsum dolor sit amet, \\nconsectetur adipisicing\\nincididunt ut labore et dolore magna\\nUt enim ad minim veniam\\nquis nostrud\",\"button_text\":\"Buy Now\",\"button_url\":\"#\",\"button_size\":\"\",\"button_type\":\"success\",\"button_icon\":\"\",\"button_block\":\"\",\"background\":\"\",\"color\":\"\",\"featured\":\"sppb-pricing-featured\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"instFormId\":1518591538,\"price_position\":\"after\",\"price_symbol\":\"$\",\"price_symbol_alignment\":\"middle\",\"price_symbol_font_size\":{\"md\":\"36\",\"sm\":\"\",\"xs\":\"\"}},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-4\",\"settings\":{\"class\":\"\",\"animationdelay\":400,\"animationduration\":\"\",\"animation\":\"fadeInLeft\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1518591539,\"addons\":[{\"name\":\"pricing\",\"title\":\"Pricing Table\",\"id\":1518591540,\"settings\":{\"title\":\"Professional\",\"price\":\"29\",\"duration\":\"\",\"pricing_content\":\"Lorem ipsum dolor sit amet, \\nconsectetur adipisicing\\nincididunt ut labore et dolore magna\\nUt enim ad minim veniam\\nquis nostrud\",\"button_text\":\"Buy Now\",\"button_url\":\"#\",\"button_size\":\"\",\"button_type\":\"default\",\"button_icon\":\"\",\"button_block\":\"\",\"background\":\"\",\"color\":\"\",\"featured\":\"\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"instFormId\":1518591540,\"price_symbol\":\"$\",\"price_symbol_alignment\":\"middle\",\"price_symbol_font_size\":{\"md\":\"36\",\"sm\":\"\",\"xs\":\"\"},\"price_position\":\"after\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"4,4,4\",\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"background_color\":\"#f7f9fc\",\"color\":\"\",\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"pricing-style2\",\"padding\":\"\",\"margin\":\"90px 0\",\"fullscreen\":0},\"id\":1518591541,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-4\",\"settings\":{\"class\":\"\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"fadeInRight\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1518591542,\"addons\":[{\"name\":\"pricing\",\"title\":\"Pricing Table\",\"id\":1518591543,\"settings\":{\"title\":\"Basic\",\"price\":\"29\",\"duration\":\"\",\"pricing_content\":\"Lorem ipsum dolor sit amet, \\nconsectetur adipisicing\\nincididunt ut labore et dolore magna\\nUt enim ad minim veniam\\nquis nostrud\",\"button_text\":\"Buy Now\",\"button_url\":\"#\",\"button_size\":\"\",\"button_type\":\"default\",\"button_icon\":\"\",\"button_block\":\"\",\"background\":\"\",\"color\":\"\",\"featured\":\"\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"instFormId\":1518591543,\"price_position\":\"after\",\"price_symbol\":\"$\",\"price_symbol_font_size\":{\"md\":\"36\",\"sm\":\"\",\"xs\":\"\"},\"price_symbol_alignment\":\"middle\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-4\",\"settings\":{\"class\":\"\",\"animationdelay\":200,\"animationduration\":\"\",\"animation\":\"fadeInRight\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1518591544,\"addons\":[{\"name\":\"pricing\",\"title\":\"Pricing Table\",\"id\":1518591545,\"settings\":{\"title\":\"Standard\",\"price\":\"29\",\"duration\":\"\",\"pricing_content\":\"Lorem ipsum dolor sit amet, \\nconsectetur adipisicing\\nincididunt ut labore et dolore magna\\nUt enim ad minim veniam\\nquis nostrud\",\"button_text\":\"Buy Now\",\"button_url\":\"#\",\"button_size\":\"\",\"button_type\":\"default\",\"button_icon\":\"\",\"button_block\":\"\",\"background\":\"#0072bc\",\"color\":\"\",\"featured\":\"sppb-pricing-featured\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"instFormId\":1518591545,\"global_user_border\":0,\"global_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0,\"global_text_color\":\"#fff\",\"price_position\":\"after\",\"price_symbol\":\"$\",\"price_symbol_alignment\":\"middle\",\"price_symbol_font_size\":{\"md\":\"36\",\"sm\":\"\",\"xs\":\"\"}},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-4\",\"settings\":{\"class\":\"\",\"animationdelay\":400,\"animationduration\":\"\",\"animation\":\"fadeInRight\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1518591546,\"addons\":[{\"name\":\"pricing\",\"title\":\"Pricing Table\",\"id\":1518591547,\"settings\":{\"title\":\"Professional\",\"price\":\"29\",\"duration\":\"\",\"pricing_content\":\"Lorem ipsum dolor sit amet, \\nconsectetur adipisicing\\nincididunt ut labore et dolore magna\\nUt enim ad minim veniam\\nquis nostrud\",\"button_text\":\"Buy Now\",\"button_url\":\"#\",\"button_size\":\"\",\"button_type\":\"default\",\"button_icon\":\"\",\"button_block\":\"\",\"background\":\"\",\"color\":\"\",\"featured\":\"\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"instFormId\":1518591547,\"price_position\":\"after\",\"price_symbol\":\"$\",\"price_symbol_alignment\":\"middle\",\"price_symbol_font_size\":{\"md\":\"36\",\"sm\":\"\",\"xs\":\"\"}},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"4,4,4\",\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"pricing-style3\",\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"90px 0 90px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"fullscreen\":0,\"instFormId\":1518591548,\"columns_align_center\":0,\"no_gutter\":0,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1518591548,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-4\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInDown\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\"\"},\"id\":1518591549,\"addons\":[{\"name\":\"pricing\",\"title\":\"Pricing Table\",\"id\":1518591550,\"settings\":{\"title\":\"Basic\",\"price\":\"29\",\"duration\":\"\",\"pricing_content\":\"Lorem ipsum dolor sit amet, \\nconsectetur adipisicing\\nincididunt ut labore et dolore magna\\nUt enim ad minim veniam\\nquis nostrud\",\"button_text\":\"Buy Now\",\"button_url\":\"#\",\"button_size\":\"\",\"button_type\":\"default\",\"button_icon\":\"\",\"button_block\":\"\",\"background\":\"\",\"color\":\"\",\"featured\":\"\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"instFormId\":1518591550,\"price_symbol\":\"$\",\"price_symbol_alignment\":\"middle\",\"price_position\":\"after\",\"price_symbol_font_size\":{\"md\":\"36\",\"sm\":\"\",\"xs\":\"\"}},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-4\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInDown\",\"animationduration\":\"\",\"animationdelay\":200,\"class\":\"\"},\"id\":1518591551,\"addons\":[{\"name\":\"pricing\",\"title\":\"Pricing Table\",\"id\":1518591552,\"settings\":{\"title\":\"Basic\",\"price\":\"29\",\"duration\":\"\",\"pricing_content\":\"Lorem ipsum dolor sit amet, \\nconsectetur adipisicing\\nincididunt ut labore et dolore magna\\nUt enim ad minim veniam\\nquis nostrud\",\"button_text\":\"Buy Now\",\"button_url\":\"#\",\"button_size\":\"\",\"button_type\":\"default\",\"button_icon\":\"\",\"button_block\":\"\",\"background\":\"\",\"color\":\"\",\"featured\":\"sppb-pricing-featured\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"instFormId\":1518591552,\"price_position\":\"after\",\"price_symbol\":\"$\",\"price_symbol_alignment\":\"middle\",\"price_symbol_font_size\":{\"md\":\"36\",\"sm\":\"\",\"xs\":\"\"}},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-4 active-column-parent\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInDown\",\"animationduration\":\"\",\"animationdelay\":400,\"class\":\"\"},\"id\":1518591553,\"addons\":[{\"name\":\"pricing\",\"title\":\"Pricing Table\",\"id\":1518591554,\"settings\":{\"title\":\"Professional\",\"price\":\"29\",\"duration\":\"\",\"pricing_content\":\"Lorem ipsum dolor sit amet, \\nconsectetur adipisicing\\nincididunt ut labore et dolore magna\\nUt enim ad minim veniam\\nquis nostrud\",\"button_text\":\"Buy Now\",\"button_url\":\"#\",\"button_size\":\"\",\"button_type\":\"default\",\"button_icon\":\"\",\"button_block\":\"\",\"background\":\"\",\"color\":\"\",\"featured\":\"\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"instFormId\":1518591554,\"price_position\":\"after\",\"price_symbol\":\"$\",\"price_symbol_alignment\":\"middle\",\"price_symbol_font_size\":{\"md\":\"36\",\"sm\":\"\",\"xs\":\"\"}},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{\"fullscreen\":0,\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"padding\":{\"md\":\"50px 0 50px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"class\":\"tixon-call-to-action\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_image\":\"\",\"color\":\"\",\"background_color\":\"#f7f9fc\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontweight\":\"\",\"title_fontsize\":\"\",\"title\":\"\",\"instFormId\":1518591555,\"columns_align_center\":0,\"no_gutter\":0,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1518591555,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInUp\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\"\"},\"id\":1518591556,\"addons\":[{\"name\":\"call_to_action\",\"title\":\"Call to Action\",\"id\":1518591557,\"settings\":{\"title\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"600\",\"title_text_color\":\"\",\"title_margin_top\":\"0\",\"title_margin_bottom\":\"10\",\"subtitle\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elitsed do eiusmod tempor\",\"subtitle_fontsize\":\"14\",\"subtitle_fontweight\":\"\",\"subtitle_text_color\":\"\",\"text\":\"\",\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"button_text\":\"Buy Now\",\"button_url\":\"#\",\"button_size\":\"\",\"button_type\":\"primary\",\"button_icon\":\"\",\"button_block\":\"\",\"button_target\":\"\",\"button_position\":\"right\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"}]', 'com_sppagebuilder', 'page', 0, 0, 1, 0, 1, 0, '2015-08-27 12:14:00', 928, '2018-02-14 07:08:02', 928, 0, '0000-00-00 00:00:00', '', '', '', '*', 14, ''),
(15, 275, 'Faq', '[{\"layout\":12,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"lawyer-accordion\",\"padding\":{\"md\":\"90px 0 90px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"fullscreen\":0,\"instFormId\":1518592096,\"columns_align_center\":0,\"no_gutter\":0,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1518592096,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"\",\"animationduration\":300,\"animationdelay\":0,\"class\":\"\"},\"id\":1518592097,\"addons\":[{\"name\":\"heading\",\"title\":\"Addon Heading\",\"id\":1518592098,\"settings\":{\"style\":\"style1\",\"title\":\"Frequently asked questions (FAQ)\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"30\",\"subtitle\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et<br/>dolore magna aliqua. Ut enim ad minim veniam\",\"subtitle_fontsize\":\"\",\"subtitle_fontweight\":\"\",\"subtitle_text_color\":\"\"},\"visibility\":1},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1518592099,\"settings\":{\"gap\":\"50\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"name\":\"accordion\",\"title\":\"Accordion\",\"id\":1518592100,\"settings\":{\"title\":\"\",\"heading_selector\":\"h2\",\"title_fontsize\":\"16\",\"title_fontweight\":\"700\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"style\":\"panel-default\",\"class\":\"accordion-service\",\"sp_accordion_item\":[{\"title\":\"Frequently asked questions (FAQ)\",\"icon\":\"\",\"content\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.\"},{\"title\":\"Frequently asked questions (FAQ)\",\"icon\":\"\",\"content\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. \"},{\"title\":\"Frequently asked questions (FAQ)\",\"icon\":\"\",\"content\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.\"},{\"title\":\"Frequently asked questions (FAQ)\",\"icon\":\"\",\"content\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.\"},{\"title\":\"Frequently asked questions (FAQ)\",\"icon\":\"\",\"content\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.\"},{\"title\":\"Frequently asked questions (FAQ)\",\"icon\":\"\",\"content\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.\"},{\"title\":\"Frequently asked questions (FAQ)\",\"icon\":\"\",\"content\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.\"},{\"title\":\"Frequently asked questions (FAQ)\",\"icon\":\"\",\"content\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.\"},{\"title\":\"Frequently asked questions (FAQ)\",\"icon\":\"\",\"content\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.\"},{\"title\":\"Frequently asked questions (FAQ)\",\"icon\":\"\",\"content\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.\"},{\"title\":\"Frequently asked questions (FAQ)\",\"icon\":\"\",\"content\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.\"}]},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{\"title\":\"\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"background_color\":\"#f7f9fc\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"tixon-call-to-action\",\"padding\":{\"md\":\"50px 0 50px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"fullscreen\":0,\"instFormId\":1518592101,\"columns_align_center\":0,\"no_gutter\":0,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1518592101,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12 active-column-parent\",\"settings\":{\"class\":\"\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"fadeInDown\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1518592102,\"addons\":[{\"name\":\"call_to_action\",\"title\":\"Call to Action\",\"id\":1518592103,\"settings\":{\"title\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"700\",\"title_text_color\":\"\",\"title_margin_top\":\"0\",\"title_margin_bottom\":\"10\",\"subtitle\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elitsed do eiusmod tempor\",\"subtitle_fontsize\":\"14\",\"subtitle_fontweight\":\"\",\"subtitle_text_color\":\"\",\"text\":\"\",\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"button_text\":\"Buy Now\",\"button_url\":\"#\",\"button_size\":\"\",\"button_type\":\"primary\",\"button_icon\":\"\",\"button_block\":\"\",\"button_target\":\"\",\"button_position\":\"right\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"}]', 'com_sppagebuilder', 'page', 0, 0, 1, 0, 1, 0, '2015-08-27 12:46:59', 928, '2018-02-14 07:09:32', 928, 0, '0000-00-00 00:00:00', '', '', '', '*', 10, '');
INSERT INTO `#__sppagebuilder` (`id`, `asset_id`, `title`, `text`, `extension`, `extension_view`, `view_id`, `active`, `published`, `catid`, `access`, `ordering`, `created_on`, `created_by`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `og_title`, `og_image`, `og_description`, `language`, `hits`, `css`) VALUES
(16, 276, 'Contact', '[{\"layout\":12,\"settings\":{\"fullscreen\":0,\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"padding\":{\"md\":\"90px 0 90px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"class\":\"\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_position\":\"0 0\",\"background_attachment\":\"fixed\",\"background_size\":\"cover\",\"background_repeat\":\"no-repeat\",\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"title_position\":\"sppb-text-center\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontweight\":\"\",\"title_fontsize\":\"\",\"heading_selector\":\"h3\",\"title\":\"\",\"instFormId\":1518592198,\"columns_align_center\":0,\"no_gutter\":0,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1518592198,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{\"class\":\"\",\"animationdelay\":0,\"animationduration\":300,\"animation\":\"\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1518592199,\"addons\":[{\"name\":\"gmap\",\"title\":\"Google Map\",\"id\":1518592200,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"map\":\"40.7324319, -73.82480799999996\",\"height\":\"455\",\"type\":\"ROADMAP\",\"zoom\":\"18\",\"mousescroll\":\"false\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"4,8\",\"settings\":{\"title\":\"\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"tixon-contact-from\",\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0 0 90px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"fullscreen\":0,\"instFormId\":1518592201,\"columns_align_center\":0,\"no_gutter\":0,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1518592201,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-4\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInRight\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\"\"},\"id\":1518592202,\"addons\":[{\"name\":\"heading\",\"title\":\"COM_SPPAGEBUILDER_ADDON_HEADING\",\"id\":1518592203,\"settings\":{\"style\":\"style1\",\"title\":\"CONTACT DETAILS\",\"heading_selector\":\"h3\",\"title_fontsize\":\"16\",\"title_fontweight\":\"700\",\"title_text_color\":\"#303640\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"subtitle_fontweight\":\"\",\"subtitle_text_color\":\"\",\"instFormId\":1518592203,\"use_link\":0,\"title_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"alignment\":\"sppb-text-left\"},\"visibility\":1},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1518592204,\"settings\":{\"gap\":\"40\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"name\":\"text_block\",\"title\":\"Text Block\",\"id\":1518592205,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"text\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<strong><br /><br />Email</strong>: <a href=\\\"mailto:coffee@tixon.com\\\">coffee@tixon.com</a><a href=\\\"mailto:coffee@tixon.com\\\"><br /><br /></a><strong>Phone</strong>: +44 6745 734-472<br /><br /><strong>Fax</strong>: +44 6745 734-473<br /><br /><strong>Website</strong>: www.tixon.com\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-8 active-column-parent\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInRight\",\"animationduration\":\"\",\"animationdelay\":200,\"class\":\"\"},\"id\":1518592206,\"addons\":[{\"name\":\"heading\",\"title\":\"COM_SPPAGEBUILDER_ADDON_HEADING\",\"id\":1518592207,\"settings\":{\"style\":\"style1\",\"title\":\"LEAVE A COMMENT!\",\"heading_selector\":\"h3\",\"title_fontsize\":\"16\",\"title_fontweight\":\"700\",\"title_text_color\":\"#303640\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"subtitle_fontweight\":\"\",\"subtitle_text_color\":\"\",\"instFormId\":1518592207,\"use_link\":0,\"title_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"alignment\":\"sppb-text-left\"},\"visibility\":1},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1518592208,\"settings\":{\"gap\":\"40\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"name\":\"ajax_contact\",\"title\":\"Contact Form\",\"id\":1518592209,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"recipient_email\":\"email@yourdomain.com\",\"formcaptcha\":1,\"captcha_question\":\"3 + 4 = ?\",\"captcha_answer\":\"7\",\"class\":\"\",\"instFormId\":1518592209,\"show_label\":0,\"show_checkbox\":0,\"use_custom_button\":0,\"name_input_col\":\"6\",\"email_input_col\":\"6\",\"captcha_type\":\"default\",\"captcha_input_col\":\"6\",\"subject_input_col\":\"6\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{\"fullscreen\":0,\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"padding\":{\"md\":\"60px 0 60px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"class\":\"tixon-call-to-action\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_image\":\"\",\"color\":\"\",\"background_color\":\"#f2f4f7\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontweight\":\"\",\"title_fontsize\":\"\",\"title\":\"\",\"instFormId\":1518592210,\"columns_align_center\":0,\"no_gutter\":0,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1518592210,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInDown\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\"\"},\"id\":1518592211,\"addons\":[{\"name\":\"call_to_action\",\"title\":\"Call to Action\",\"id\":1518592212,\"settings\":{\"title\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"600\",\"title_text_color\":\"\",\"title_margin_top\":\"0\",\"title_margin_bottom\":\"10\",\"subtitle\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elitsed do eiusmod tempor\",\"subtitle_fontsize\":\"14\",\"subtitle_fontweight\":\"\",\"subtitle_text_color\":\"\",\"text\":\"\",\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"button_text\":\"BUY NOW\",\"button_url\":\"#\",\"button_size\":\"\",\"button_type\":\"primary\",\"button_icon\":\"\",\"button_block\":\"\",\"button_target\":\"\",\"button_position\":\"right\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"}]', 'com_sppagebuilder', 'page', 0, 0, 1, 0, 1, 0, '2015-08-31 10:47:59', 928, '2018-02-14 07:13:40', 928, 0, '0000-00-00 00:00:00', '', '', '', '*', 18, ''),
(17, 270, 'Home Shop ', '[{\"layout\":12,\"settings\":{\"fullscreen\":1,\"margin\":\"\",\"padding\":\"\",\"class\":\"tixon-slider\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontweight\":\"\",\"title_fontsize\":\"\",\"title\":\"\"},\"id\":1518589333,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{},\"id\":1518589334,\"addons\":[{\"name\":\"slideshow_full\",\"title\":\"Slideshow (Full Width)\",\"id\":1518589335,\"settings\":{\"layout\":\"layout3\",\"autoplay\":\"0\",\"controllers\":\"1\",\"arrows\":\"1\",\"background\":\"\",\"color\":\"\",\"class\":\"\",\"sp_slideshow_full_item\":[{\"title\":\"New<strong> trend</strong> for <strong>new age</strong>\",\"sub_title\":\"\",\"content\":\"\",\"bg\":\"images/shop/shop-slider1.jpg\",\"button_text\":\"\",\"button_url\":\"\",\"button_size\":\"\",\"button_type\":\"default\",\"button_before_icon\":\"\",\"button_after_icon\":\"\",\"title_animation\":\"flipInX\",\"title_animationduration\":\"\",\"title_animationdelay\":\"500\",\"subtitle_animation\":\"\",\"subtitle_animationduration\":\"\",\"subtitle_animationdelay\":\"\",\"cotent_animation\":\"\",\"cotent_animationduration\":\"\",\"cotent_animationdelay\":\"\",\"button_animation\":\"\",\"button_animationduration\":\"\",\"button_animationdelay\":\"\"},{\"title\":\"Shop<strong> trend</strong> for <strong>new age</strong>\",\"sub_title\":\"\",\"content\":\"\",\"bg\":\"images/shop-slider2.jpg\",\"button_text\":\"\",\"button_url\":\"\",\"button_size\":\"\",\"button_type\":\"default\",\"button_before_icon\":\"\",\"button_after_icon\":\"\",\"title_animation\":\"zoomIn\",\"title_animationduration\":\"\",\"title_animationdelay\":\"500\",\"subtitle_animation\":\"\",\"subtitle_animationduration\":\"\",\"subtitle_animationdelay\":\"\",\"cotent_animation\":\"\",\"cotent_animationduration\":\"\",\"cotent_animationdelay\":\"\",\"button_animation\":\"\",\"button_animationduration\":\"\",\"button_animationdelay\":\"\"},{\"title\":\"New<strong> Fashion</strong> & <strong>Style</strong>\",\"sub_title\":\"\",\"content\":\"\",\"bg\":\"images/shop-slider3.jpg\",\"button_text\":\"\",\"button_url\":\"\",\"button_size\":\"\",\"button_type\":\"default\",\"button_before_icon\":\"\",\"button_after_icon\":\"\",\"title_animation\":\"fadeInLeftBig\",\"title_animationduration\":\"\",\"title_animationdelay\":\"500\",\"subtitle_animation\":\"\",\"subtitle_animationduration\":\"\",\"subtitle_animationdelay\":\"\",\"cotent_animation\":\"\",\"cotent_animationduration\":\"\",\"cotent_animationdelay\":\"\",\"button_animation\":\"\",\"button_animationduration\":\"\",\"button_animationdelay\":\"\"},{\"title\":\"<strong> Real man</strong> Spring<strong> collection</strong>\",\"sub_title\":\"\",\"content\":\"\",\"bg\":\"images/shop-slider4.jpg\",\"button_text\":\"\",\"button_url\":\"\",\"button_size\":\"\",\"button_type\":\"default\",\"button_before_icon\":\"\",\"button_after_icon\":\"\",\"title_animation\":\"bounceInUp\",\"title_animationduration\":\"\",\"title_animationdelay\":\"500\",\"subtitle_animation\":\"\",\"subtitle_animationduration\":\"\",\"subtitle_animationdelay\":\"\",\"cotent_animation\":\"\",\"cotent_animationduration\":\"\",\"cotent_animationdelay\":\"\",\"button_animation\":\"\",\"button_animationduration\":\"\",\"button_animationdelay\":\"\"}]},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"6,6\",\"settings\":{\"title\":\"Welcome to our store\",\"title_fontsize\":28,\"title_fontweight\":600,\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"Introduction About Category\",\"subtitle_fontsize\":18,\"title_position\":\"sppb-text-center\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"masonry-grid-style\",\"padding\":\"\",\"margin\":\"90px 0 30px\",\"fullscreen\":0},\"id\":1518589336,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-6\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInDown\",\"animationduration\":\"\",\"animationdelay\":200,\"class\":\"\"},\"id\":1518589337,\"addons\":[{\"name\":\"fancy_image_link\",\"title\":\"Fancy Image Link\",\"id\":1518589338,\"settings\":{\"title\":\"\",\"count\":\"sppb-col-sm-12\",\"class\":\"\",\"sp_fancy_image_link_item\":[{\"title\":\"Leather Shoes\",\"image\":\"images/shop/cats1.jpg\",\"url\":\"index.php/shop\",\"btn_text\":\"View All\"}]},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-6\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInDown\",\"animationduration\":\"\",\"animationdelay\":400,\"class\":\"\"},\"id\":1518589339,\"addons\":[{\"name\":\"fancy_image_link\",\"title\":\"Fancy Image Link\",\"id\":1518589340,\"settings\":{\"title\":\"\",\"count\":\"sppb-col-sm-6\",\"class\":\"\",\"sp_fancy_image_link_item\":[{\"title\":\"Mens\",\"image\":\"images/shop/cats2.jpg\",\"url\":\"index.php/shop\",\"btn_text\":\"View All\"},{\"title\":\"Womens\",\"image\":\"images/shop/cats3.jpg\",\"url\":\"index.php/shop\",\"btn_text\":\"View All\"}]},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"4,5,3\",\"settings\":{\"title\":\"\",\"title_fontsize\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"masonry-grid-style\",\"padding\":\"\",\"margin\":\"0 0 90px\",\"fullscreen\":0,\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\"},\"id\":1518589341,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-4\",\"settings\":{\"class\":\"\",\"animationdelay\":200,\"animationduration\":\"\",\"animation\":\"fadeInDown\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1518589342,\"addons\":[{\"name\":\"fancy_image_link\",\"title\":\"Fancy Image Link\",\"id\":1518589343,\"settings\":{\"title\":\"\",\"count\":\"sppb-col-sm-12\",\"class\":\"\",\"sp_fancy_image_link_item\":[{\"title\":\"Furnitures\",\"image\":\"images/shop/cats4.jpg\",\"url\":\"index.php/shop\",\"btn_text\":\"View All\"}]},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-5\",\"settings\":{\"class\":\"\",\"animationdelay\":400,\"animationduration\":\"\",\"animation\":\"fadeInDown\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1518589344,\"addons\":[{\"name\":\"fancy_image_link\",\"title\":\"Fancy Image Link\",\"id\":1518589345,\"settings\":{\"title\":\"\",\"count\":\"sppb-col-sm-12\",\"class\":\"\",\"sp_fancy_image_link_item\":[{\"title\":\"Jewellery \",\"image\":\"images/shop/cats5.jpg\",\"url\":\"index.php/shop\",\"btn_text\":\"View All\"}]},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInDown\",\"animationduration\":\"\",\"animationdelay\":600,\"class\":\"\"},\"id\":1518589346,\"addons\":[{\"name\":\"fancy_image_link\",\"title\":\"Fancy Image Link\",\"id\":1518589347,\"settings\":{\"title\":\"\",\"count\":\"sppb-col-sm-12\",\"class\":\"\",\"sp_fancy_image_link_item\":[{\"title\":\"Watches\",\"image\":\"images/shop/cats6.jpg\",\"url\":\"index.php/shop\",\"btn_text\":\"View All\"}]},\"visibility\":1},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1518589348,\"settings\":{\"gap\":\"30\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"1\",\"class\":\"\"},\"visibility\":1},{\"name\":\"fancy_image_link\",\"title\":\"Fancy Image Link\",\"id\":1518589349,\"settings\":{\"title\":\"\",\"count\":\"sppb-col-sm-12\",\"class\":\"\",\"sp_fancy_image_link_item\":[{\"title\":\"Accessories\",\"image\":\"images/shop/cats7.jpg\",\"url\":\"index.php/shop\",\"btn_text\":\"View All\"}]},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"6,6\",\"settings\":{\"background_repeat\":\"no-repeat\",\"fullscreen\":0,\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"class\":\"shop-call-to-action\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_image\":\"images/shop/cta-bg.jpg\",\"color\":\"\",\"background_color\":\"\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontweight\":\"\",\"title_fontsize\":\"\",\"title\":\"\",\"background_size\":\"cover\",\"instFormId\":1518589350,\"columns_align_center\":0,\"no_gutter\":0,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1518589350,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-6 active-column-parent\",\"settings\":{\"class\":\" shop-call-to-action\",\"animationdelay\":200,\"animationduration\":\"\",\"animation\":\"fadeInLeft\",\"padding\":{\"md\":\"120px 0 120px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"\",\"background\":\"\",\"instFormId\":1518589351,\"items_align_center\":0,\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"use_border\":0},\"id\":1518589351,\"addons\":[{\"name\":\"call_to_action\",\"title\":\"Call to Action\",\"id\":1518589352,\"settings\":{\"title\":\"Tixon Design\",\"heading_selector\":\"h3\",\"title_fontsize\":\"18\",\"title_fontweight\":\"400\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"NEW DESIGN <br>SEND HER YOUR LOVE\",\"subtitle_fontsize\":\"44\",\"subtitle_fontweight\":\"100\",\"subtitle_text_color\":\"\",\"text\":\"\",\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"button_text\":\"Buy Now\",\"button_url\":\"index.php/shop\",\"button_size\":\"\",\"button_type\":\"default\",\"button_icon\":\"\",\"button_block\":\"\",\"button_target\":\"\",\"button_position\":\"bottom\",\"class\":\"text-left\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-6\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeIn\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\"\"},\"id\":1518589353,\"addons\":[],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{\"fullscreen\":0,\"margin\":{\"md\":\"100px 0 100px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"class\":\"\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"title_position\":\"sppb-text-center\",\"subtitle_fontsize\":18,\"subtitle\":\"Brand New Products\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontweight\":700,\"title_fontsize\":28,\"heading_selector\":\"h2\",\"title\":\"NEW ARRIVALS\",\"instFormId\":1518589354,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1518589354,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeIn\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\"\"},\"id\":1518589355,\"addons\":[{\"name\":\"module\",\"title\":\"Joomla Module\",\"id\":1518589356,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"id\":\"114\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"3,6,3\",\"settings\":{\"fullscreen\":0,\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"padding\":{\"md\":\"100px 0 100px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"class\":\"text-center\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_size\":\"cover\",\"background_image\":\"images/demo/newsletter-shop-page-bg.png\",\"color\":\"\",\"background_color\":\"\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":-30,\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontweight\":600,\"title_fontsize\":28,\"heading_selector\":\"h2\",\"title\":\"Sign Up For Newsletter\",\"instFormId\":1518589357,\"columns_align_center\":0,\"no_gutter\":0,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1518589357,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-3\",\"settings\":{},\"id\":1518589358,\"addons\":[],\"visibility\":1},{\"class_name\":\"col-sm-6\",\"settings\":{\"class\":\" shop-newsletter\",\"animationdelay\":200,\"animationduration\":\"\",\"animation\":\"fadeInUp\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1518589359,\"addons\":[{\"name\":\"module\",\"title\":\"Joomla Module\",\"id\":1518589360,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"id\":\"110\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{},\"id\":1518589361,\"addons\":[],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"3,3,3,3\",\"settings\":{\"fullscreen\":0,\"margin\":{\"md\":\"90px 0 90px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"class\":\"tixon-happy-clients\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"subtitle_fontsize\":18,\"subtitle\":\"Remarkable people happy with us\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontsize\":28,\"title\":\"HAPPY CLIENTS\",\"heading_selector\":\"h2\",\"title_fontweight\":600,\"title_position\":\"sppb-text-center\",\"instFormId\":1518589362,\"columns_align_center\":0,\"no_gutter\":0,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1518589362,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-3\",\"settings\":{\"class\":\"\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"fadeInLeft\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1518589363,\"addons\":[{\"name\":\"image\",\"title\":\"Image\",\"id\":1518589364,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"image\":\"images/clients/client1.png\",\"alt_text\":\"\",\"position\":\"sppb-text-center\",\"link\":\"http://\",\"target\":\"\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"class\":\"\",\"animationdelay\":200,\"animationduration\":\"\",\"animation\":\"fadeInLeft\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1518589365,\"addons\":[{\"name\":\"image\",\"title\":\"Image\",\"id\":1518589366,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"image\":\"images/clients/client2.png\",\"alt_text\":\"\",\"position\":\"sppb-text-center\",\"link\":\"http://\",\"target\":\"\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"class\":\"\",\"animationdelay\":400,\"animationduration\":\"\",\"animation\":\"fadeInLeft\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1518589367,\"addons\":[{\"name\":\"image\",\"title\":\"Image\",\"id\":1518589368,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"image\":\"images/clients/client3.png\",\"alt_text\":\"\",\"position\":\"sppb-text-center\",\"link\":\"http://\",\"target\":\"\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"class\":\"\",\"animationdelay\":600,\"animationduration\":\"\",\"animation\":\"fadeInLeft\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1518589369,\"addons\":[{\"name\":\"image\",\"title\":\"Image\",\"id\":1518589370,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"image\":\"images/clients/client4.png\",\"alt_text\":\"\",\"position\":\"sppb-text-center\",\"link\":\"http://\",\"target\":\"\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"}]', 'com_sppagebuilder', 'page', 0, 0, 1, 0, 1, 0, '2015-09-03 06:11:26', 928, '2018-02-14 06:27:48', 928, 0, '0000-00-00 00:00:00', '', '', '', '*', 48, '');
INSERT INTO `#__sppagebuilder` (`id`, `asset_id`, `title`, `text`, `extension`, `extension_view`, `view_id`, `active`, `published`, `catid`, `access`, `ordering`, `created_on`, `created_by`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `og_title`, `og_image`, `og_description`, `language`, `hits`, `css`) VALUES
(18, 271, 'agency', '[{\"layout\":12,\"settings\":{\"title\":\"\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"tixon-slider-construction\",\"padding\":0,\"margin\":\"0 0 100px\",\"fullscreen\":1},\"id\":1481613874,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12 active-column-parent\",\"settings\":{},\"id\":1481613875,\"addons\":[{\"name\":\"slideshow_full\",\"title\":\"Slideshow (Full Width)\",\"id\":1481613876,\"settings\":{\"layout\":\"layout4\",\"autoplay\":\"0\",\"controllers\":\"1\",\"arrows\":\"1\",\"background\":\"\",\"color\":\"\",\"class\":\"\",\"sp_slideshow_full_item\":[{\"title\":\"Welcome To\",\"sub_title\":\"Agency\",\"content\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.\",\"bg\":\"images/agency/slide1.jpg\",\"button_text\":\"\",\"button_url\":\"\",\"button_size\":\"\",\"button_type\":\"default\",\"button_before_icon\":\"\",\"button_after_icon\":\"\",\"title_animation\":\"fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft\",\"title_animationduration\":\"500\",\"title_animationdelay\":\"500\",\"subtitle_animation\":\"fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft\",\"subtitle_animationduration\":\"500\",\"subtitle_animationdelay\":\"700\",\"cotent_animation\":\"fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft\",\"cotent_animationduration\":\"500\",\"cotent_animationdelay\":\"900\",\"button_animation\":\"\",\"button_animationduration\":\"\",\"button_animationdelay\":\"\"},{\"title\":\"Improvimg\",\"sub_title\":\"Economy\",\"content\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.\",\"bg\":\"images/agency/slide2.jpg\",\"button_text\":\"\",\"button_url\":\"\",\"button_size\":\"\",\"button_type\":\"default\",\"button_before_icon\":\"\",\"button_after_icon\":\"\",\"title_animation\":\"fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft\",\"title_animationduration\":\"500\",\"title_animationdelay\":\"500\",\"subtitle_animation\":\"fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft\",\"subtitle_animationduration\":\"500\",\"subtitle_animationdelay\":\"700\",\"cotent_animation\":\"fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft\",\"cotent_animationduration\":\"500\",\"cotent_animationdelay\":\"900\",\"button_animation\":\"\",\"button_animationduration\":\"300\",\"button_animationdelay\":\"0\"},{\"title\":\"SMARTER\",\"sub_title\":\"BUSINESS\",\"content\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.\",\"bg\":\"images/agency/slide3.jpg\",\"button_text\":\"\",\"button_url\":\"\",\"button_size\":\"\",\"button_type\":\"default\",\"button_before_icon\":\"\",\"button_after_icon\":\"\",\"title_animation\":\"fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft\",\"title_animationduration\":\"500\",\"title_animationdelay\":\"500\",\"subtitle_animation\":\"fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft\",\"subtitle_animationduration\":\"500\",\"subtitle_animationdelay\":\"700\",\"cotent_animation\":\"fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft sppb-wow fadeInLeft\",\"cotent_animationduration\":\"500\",\"cotent_animationdelay\":\"900\",\"button_animation\":\"\",\"button_animationduration\":\"\",\"button_animationdelay\":\"\"}]},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"3,3,3,3\",\"settings\":{\"title\":\"Tixon is a Powerful</br> Cooperation Lasting for year!\",\"heading_selector\":\"h2\",\"title_fontsize\":50,\"title_fontweight\":300,\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":25,\"subtitle\":\"LOREM IPSUM DOLOR SIT AMET, CONSECTETUR ADIPISICING ELIT\",\"subtitle_fontsize\":20,\"title_position\":\"sppb-text-left\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\" tixon-custom-color agency-features\",\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 90px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"fullscreen\":0,\"instFormId\":1481613877,\"columns_align_center\":0,\"no_gutter\":0,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1481613877,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-3\",\"settings\":{\"class\":\"\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"fadeInDown\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1481613878,\"addons\":[{\"name\":\"call_to_action\",\"title\":\"Call to Action\",\"id\":1481613879,\"settings\":{\"admin_label\":\"\",\"title\":\"01\",\"heading_selector\":\"h2\",\"title_fontsize\":\"90\",\"title_lineheight\":\"\",\"title_fontstyle\":null,\"title_letterspace\":\"0\",\"title_fontweight\":\"500\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"OUR <br/>RESOURCES\",\"subtitle_fontsize\":\"26\",\"subtitle_fontweight\":\"700\",\"subtitle_text_color\":\"\",\"text\":\"\\tLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam.\",\"button_text\":\"\",\"button_fontstyle\":null,\"button_letterspace\":\"0\",\"button_url\":\"\",\"button_target\":\"\",\"button_position\":\"bottom\",\"button_type\":\"default\",\"button_appearance\":\"\",\"button_background_color\":\"#444444\",\"button_color\":\"#ffffff\",\"button_background_color_hover\":\"#222222\",\"button_color_hover\":\"#ffffff\",\"button_size\":\"\",\"button_shape\":\"rounded\",\"button_block\":\"\",\"button_icon\":\"\",\"icon_position\":\"left\",\"class\":\"text-left tixon-custom-color\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"class\":\"\",\"animationdelay\":200,\"animationduration\":\"\",\"animation\":\"fadeInDown\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1481613880,\"addons\":[{\"name\":\"call_to_action\",\"title\":\"Call to Action\",\"id\":1481613881,\"settings\":{\"admin_label\":\"\",\"title\":\"02\",\"heading_selector\":\"h2\",\"title_fontsize\":\"90\",\"title_lineheight\":\"\",\"title_fontstyle\":null,\"title_letterspace\":\"0\",\"title_fontweight\":\"500\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"NEW <br/>STRATEGY\",\"subtitle_fontsize\":\"26\",\"subtitle_fontweight\":\"700\",\"subtitle_text_color\":\"\",\"text\":\"\\tLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam.\",\"button_text\":\"\",\"button_fontstyle\":null,\"button_letterspace\":\"0\",\"button_url\":\"\",\"button_target\":\"\",\"button_position\":\"bottom\",\"button_type\":\"default\",\"button_appearance\":\"\",\"button_background_color\":\"#444444\",\"button_color\":\"#ffffff\",\"button_background_color_hover\":\"#222222\",\"button_color_hover\":\"#ffffff\",\"button_size\":\"\",\"button_shape\":\"rounded\",\"button_block\":\"\",\"button_icon\":\"\",\"icon_position\":\"left\",\"class\":\"text-left tixon-custom-color\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInDown\",\"animationduration\":\"\",\"animationdelay\":400,\"class\":\"\"},\"id\":1481613882,\"addons\":[{\"name\":\"call_to_action\",\"title\":\"Call to Action\",\"id\":1481613883,\"settings\":{\"admin_label\":\"\",\"title\":\"03\",\"heading_selector\":\"h2\",\"title_fontsize\":\"90\",\"title_lineheight\":\"\",\"title_fontstyle\":null,\"title_letterspace\":\"0\",\"title_fontweight\":\"500\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"CREATIVE <br/>DEVELOPMENT\",\"subtitle_fontsize\":\"26\",\"subtitle_fontweight\":\"700\",\"subtitle_text_color\":\"\",\"text\":\"\\tLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam.\",\"button_text\":\"\",\"button_fontstyle\":null,\"button_letterspace\":\"0\",\"button_url\":\"\",\"button_target\":\"\",\"button_position\":\"bottom\",\"button_type\":\"default\",\"button_appearance\":\"\",\"button_background_color\":\"#444444\",\"button_color\":\"#ffffff\",\"button_background_color_hover\":\"#222222\",\"button_color_hover\":\"#ffffff\",\"button_size\":\"\",\"button_shape\":\"rounded\",\"button_block\":\"\",\"button_icon\":\"\",\"icon_position\":\"left\",\"class\":\"text-left tixon-custom-color\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInDown\",\"animationduration\":\"\",\"animationdelay\":600,\"class\":\"\"},\"id\":1481613884,\"addons\":[{\"name\":\"call_to_action\",\"title\":\"Call to Action\",\"id\":1481613885,\"settings\":{\"admin_label\":\"\",\"title\":\"04\",\"heading_selector\":\"h2\",\"title_fontsize\":\"90\",\"title_lineheight\":\"\",\"title_fontstyle\":null,\"title_letterspace\":\"0\",\"title_fontweight\":\"500\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"AMAZING <br/>PROTOTYPE\",\"subtitle_fontsize\":\"26\",\"subtitle_fontweight\":\"700\",\"subtitle_text_color\":\"\",\"text\":\"\\tLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam.\",\"button_text\":\"\",\"button_fontstyle\":null,\"button_letterspace\":\"0\",\"button_url\":\"\",\"button_target\":\"\",\"button_position\":\"bottom\",\"button_type\":\"default\",\"button_appearance\":\"\",\"button_background_color\":\"#444444\",\"button_color\":\"#ffffff\",\"button_background_color_hover\":\"#222222\",\"button_color_hover\":\"#ffffff\",\"button_size\":\"\",\"button_shape\":\"rounded\",\"button_block\":\"\",\"button_icon\":\"\",\"icon_position\":\"left\",\"class\":\"text-left tixon-custom-color\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"6,6\",\"settings\":{\"fullscreen\":1,\"margin\":\"\",\"padding\":\"\",\"class\":\"\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontweight\":\"\",\"title_fontsize\":\"\",\"title\":\"\"},\"id\":1481613886,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-6\",\"settings\":{\"class\":\"\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"fadeIn\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1481613887,\"addons\":[{\"name\":\"image\",\"title\":\"Image\",\"id\":1481613888,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"image\":\"images/agency-img.jpg\",\"alt_text\":\"\",\"position\":\"sppb-text-center\",\"link\":\"http://\",\"target\":\"\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-6\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeIn\",\"animationduration\":\"\",\"animationdelay\":400,\"class\":\"\"},\"id\":1481613889,\"addons\":[{\"name\":\"tab\",\"title\":\"Tabs\",\"id\":1481613890,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"style\":\"tabs\",\"class\":\"agency-tabs\",\"sp_tab_item\":[{\"title\":\"House </br>Insurance\",\"icon\":\"fa-home\",\"content\":\"<h2>House insurance</h2>\\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident,</p>\\n<a class=\\\"btn btn-primary\\\" href=\\\"#\\\">Get quote</a>\"},{\"title\":\"Health  </br>Insurance\",\"icon\":\"fa-life-bouy\",\"content\":\"<h2>House insurance</h2>\\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident,</p>\\n<a class=\\\"btn btn-primary\\\" href=\\\"#\\\">Get quote</a>\"},{\"title\":\"Life  </br>Insurance\",\"icon\":\"fa-heart-o\",\"content\":\"<h2>Life Insurance</h2>\\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident,</p>\\n<a class=\\\"btn btn-primary\\\" href=\\\"#\\\">Get quote</a>\"}]},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"7,5\",\"settings\":{\"fullscreen\":0,\"margin\":{\"md\":\"90px 0 70px \",\"sm\":\"   \",\"xs\":\"   \"},\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"class\":\"\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontweight\":\"\",\"title_fontsize\":\"\",\"title\":\"\",\"heading_selector\":\"h2\",\"title_position\":\"sppb-text-left\",\"instFormId\":1481613891,\"columns_align_center\":0,\"no_gutter\":0,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1481613891,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-7\",\"settings\":{\"class\":\" tixon-custom-color\",\"animationdelay\":200,\"animationduration\":\"\",\"animation\":\"fadeInRight\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1481613892,\"addons\":[{\"name\":\"heading\",\"title\":\"Addon Heading\",\"id\":1481613893,\"settings\":{\"heading_style\":\"style2\",\"title\":\"Meet Our Insurance Agency\",\"heading_selector\":\"h2\",\"use_link\":\"0\",\"title_link\":\"\",\"link_new_tab\":\"0\",\"title_fontsize\":\"50\",\"title_fontstyle\":null,\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_margin\":\"0px 0px 30px 0px\",\"title_padding\":\"0px 0px 0px 0px\",\"alignment\":\"sppb-text-left\",\"subtitle\":\"LOREM IPSUM DOLOR SIT AMET, CONSECTETUR ADIPISICING ELIT\",\"subtitle_fontsize\":\"20\",\"subtitle_fontweight\":\"\",\"subtitle_text_color\":\"\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null},\"visibility\":1},{\"name\":\"text_block\",\"title\":\"Text Block\",\"id\":1481613894,\"settings\":{\"admin_label\":\"\",\"title\":\"June, 2015\",\"heading_selector\":\"h4\",\"title_fontsize\":\"24\",\"title_lineheight\":\"\",\"title_fontstyle\":null,\"title_letterspace\":\"0\",\"title_fontweight\":\"300\",\"title_text_color\":\"\",\"title_margin_top\":\"40\",\"title_margin_bottom\":\"20\",\"text\":\"\\t<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</p>\",\"alignment\":\"sppb-text-left\",\"class\":\" meetup-time-details\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null},\"visibility\":1},{\"name\":\"text_block\",\"title\":\"Text Block\",\"id\":1481613895,\"settings\":{\"admin_label\":\"\",\"title\":\"July, 2015\",\"heading_selector\":\"h4\",\"title_fontsize\":\"24\",\"title_lineheight\":\"\",\"title_fontstyle\":null,\"title_letterspace\":\"0\",\"title_fontweight\":\"300\",\"title_text_color\":\"\",\"title_margin_top\":\"0\",\"title_margin_bottom\":\"20\",\"text\":\"\\t<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</p>\",\"alignment\":\"sppb-text-left\",\"class\":\" meetup-time-details\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null},\"visibility\":1},{\"name\":\"text_block\",\"title\":\"Text Block\",\"id\":1481613896,\"settings\":{\"admin_label\":\"\",\"title\":\"September, 2015\",\"heading_selector\":\"h4\",\"title_fontsize\":\"24\",\"title_lineheight\":\"\",\"title_fontstyle\":null,\"title_letterspace\":\"0\",\"title_fontweight\":\"300\",\"title_text_color\":\"\",\"title_margin_top\":\"0\",\"title_margin_bottom\":\"20\",\"text\":\"\\t<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</p>\",\"alignment\":\"sppb-text-left\",\"class\":\" meetup-time-details last\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-5\",\"settings\":{\"class\":\"\",\"animationdelay\":400,\"animationduration\":\"\",\"animation\":\"fadeInRight\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1481613897,\"addons\":[{\"name\":\"image\",\"title\":\"Image\",\"id\":1481613898,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"image\":\"images/agency-people.jpg\",\"alt_text\":\"\",\"position\":\"sppb-text-center\",\"link\":\"http://\",\"target\":\"\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"columns_equal_height\":\"0\",\"fullscreen\":\"0\",\"no_gutter\":\"0\",\"id\":\"\",\"class\":\"agency-call-to-action\",\"padding\":{\"md\":\"100px 0 100px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"\",\"background_color\":\"\",\"background_image\":\"images/call-to-action-bg.jpg\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"50% 50%\",\"background_video\":\"0\",\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animation\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1481613899,\"columns_align_center\":0,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1481613899,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{\"class\":\"\",\"animationdelay\":200,\"animationduration\":\"\",\"animation\":\"fadeInUp\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1481613900,\"addons\":[{\"name\":\"call_to_action\",\"title\":\"Call to Action\",\"id\":1481613901,\"settings\":{\"title\":\"INSURANCES FOR <br>YOUR CHILD\'S FUTURE\",\"heading_selector\":\"h2\",\"title_fontsize\":\"50\",\"title_fontweight\":\"400\",\"title_text_color\":\"#ffffff\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"50\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"subtitle_fontweight\":\"\",\"subtitle_text_color\":\"\",\"text\":\"\",\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"button_text\":\"Get a quote \",\"button_url\":\"javascript:void(0)\",\"button_size\":\"\",\"button_type\":\"primary\",\"button_icon\":\"\",\"button_block\":\"\",\"button_target\":\"\",\"button_position\":\"bottom\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"3,3,3,3\",\"settings\":{\"fullscreen\":0,\"margin\":{\"md\":\"90px 0 90px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"class\":\"tixon-happy-clients tixon-custom-color agency-happy-clients\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_position\":\"0 0\",\"background_attachment\":\"fixed\",\"background_size\":\"cover\",\"background_repeat\":\"no-repeat\",\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"title_position\":\"sppb-text-left\",\"subtitle_fontsize\":20,\"subtitle\":\"REMARKABLE PEOPLE HAPPY WITH US\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontweight\":300,\"title_fontsize\":50,\"heading_selector\":\"h2\",\"title\":\"HAPPY CLIENTS\",\"instFormId\":1481613902,\"columns_align_center\":0,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1481613902,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-3\",\"settings\":{\"class\":\"\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"fadeInLeft\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1481613903,\"addons\":[{\"name\":\"image\",\"title\":\"Image\",\"id\":1481613904,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"image\":\"images/clients/client1.png\",\"alt_text\":\"\",\"position\":\"sppb-text-center\",\"link\":\"http://\",\"target\":\"\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"class\":\"\",\"animationdelay\":200,\"animationduration\":\"\",\"animation\":\"fadeInLeft\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1481613905,\"addons\":[{\"name\":\"image\",\"title\":\"Image\",\"id\":1481613906,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"image\":\"images/clients/client2.png\",\"alt_text\":\"\",\"position\":\"sppb-text-center\",\"link\":\"http://\",\"target\":\"\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"class\":\"\",\"animationdelay\":400,\"animationduration\":\"\",\"animation\":\"fadeInLeft\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1481613907,\"addons\":[{\"name\":\"image\",\"title\":\"Image\",\"id\":1481613908,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"image\":\"images/clients/client3.png\",\"alt_text\":\"\",\"position\":\"sppb-text-center\",\"link\":\"http://\",\"target\":\"\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"class\":\"\",\"animationdelay\":600,\"animationduration\":\"\",\"animation\":\"fadeInLeft\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1481613909,\"addons\":[{\"name\":\"image\",\"title\":\"Image\",\"id\":1481613910,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"image\":\"images/clients/client4.png\",\"alt_text\":\"\",\"position\":\"sppb-text-center\",\"link\":\"http://\",\"target\":\"\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"}]', 'com_sppagebuilder', 'page', 0, 0, 1, 0, 1, 0, '2015-09-11 06:10:37', 587, '2018-02-26 05:54:49', 587, 0, '0000-00-00 00:00:00', '', '', '', '*', 30, ''),
(19, 0, 'Accordion', '[{\"type\":\"sp_row\",\"layout\":\"66\",\"disable\":false,\"settings\":{\"fullscreen\":0,\"margin\":\"90px 0\",\"padding\":\"\",\"class\":\"lawyer-accordion\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontweight\":\"\",\"title_fontsize\":\"\",\"title\":\"\"},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-6 active-column-parent\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInLeft\",\"animationduration\":\"\",\"animationdelay\":200,\"class\":\"\",\"sortableitem\":\"[object Object]\"},\"attr\":[{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"atts\":{\"gap\":\"20\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"accordion\",\"title\":\"Accordion\",\"atts\":{\"title\":\"Tixon Accordion Style 01\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"600\",\"title_text_color\":\"#38434a\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"20\",\"style\":\"panel-default\",\"class\":\"\"},\"scontent\":[{\"type\":\"repeatable\",\"name\":\"sp_accordion_item\",\"atts\":{\"title\":\"Does not reflect adjustments for fees, costs, or medical liens\",\"icon\":\"\",\"content\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\"}},{\"type\":\"repeatable\",\"name\":\"sp_accordion_item\",\"atts\":{\"title\":\"Costs, or medical liens does not reflect adjustments for fees\",\"icon\":\"\",\"content\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\"}},{\"type\":\"repeatable\",\"name\":\"sp_accordion_item\",\"atts\":{\"title\":\"Costs, or medical liens does not reflect adjustments for fees\",\"icon\":\"\",\"content\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\"}}]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-6\",\"settings\":{\"class\":\"\",\"animationdelay\":400,\"animationduration\":\"\",\"animation\":\"fadeInRight\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"attr\":[{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"atts\":{\"gap\":\"20\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"accordion\",\"title\":\"Accordion\",\"atts\":{\"title\":\"Tixon Accordion Style 02\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"#38434a\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"20\",\"style\":\"panel-default\",\"class\":\"accordion-service\"},\"scontent\":[{\"type\":\"repeatable\",\"name\":\"sp_accordion_item\",\"atts\":{\"title\":\"What is lorem ipsum dolor sit amet ?\",\"icon\":\"\",\"content\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\"}},{\"type\":\"repeatable\",\"name\":\"sp_accordion_item\",\"atts\":{\"title\":\"Sed do eiusmod tempor incididunt ut labore et dolore ?\",\"icon\":\"\",\"content\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\"}},{\"type\":\"repeatable\",\"name\":\"sp_accordion_item\",\"atts\":{\"title\":\"Duis aute irure dolor in reprehenderit in voluptate velit esse cillum ?\",\"icon\":\"\",\"content\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\"}}]}]}]},{\"type\":\"sp_row\",\"layout\":\"66\",\"disable\":false,\"settings\":{},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-6\",\"settings\":{\"sortableitem\":\"[object Object]\"},\"attr\":[{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"atts\":{\"gap\":\"20\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"accordion\",\"title\":\"Accordion\",\"atts\":{\"title\":\"Primary Style\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"20\",\"title_margin_bottom\":\"20\",\"style\":\"panel-primary\",\"class\":\"\"},\"scontent\":[{\"type\":\"repeatable\",\"name\":\"sp_accordion_item\",\"atts\":{\"title\":\"Accordion Title 1\",\"icon\":\"fa-flickr\",\"content\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. \"}},{\"type\":\"repeatable\",\"name\":\"sp_accordion_item\",\"atts\":{\"title\":\"Accordion Title 2\",\"icon\":\"fa-codepen\",\"content\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\"}},{\"type\":\"repeatable\",\"name\":\"sp_accordion_item\",\"atts\":{\"title\":\"Accordion Title 3\",\"icon\":\"fa-behance-square\",\"content\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\"}}]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-6\",\"settings\":{},\"attr\":[{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"atts\":{\"gap\":\"20\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"accordion\",\"title\":\"Accordion\",\"atts\":{\"title\":\"Default Style\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"20\",\"title_margin_bottom\":\"20\",\"style\":\"panel-default\",\"class\":\"\"},\"scontent\":[{\"type\":\"repeatable\",\"name\":\"sp_accordion_item\",\"atts\":{\"title\":\"Accordion Title 1\",\"icon\":\"fa-flickr\",\"content\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch.\"}},{\"type\":\"repeatable\",\"name\":\"sp_accordion_item\",\"atts\":{\"title\":\"Accordion Title 2\",\"icon\":\"fa-codepen\",\"content\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\"}},{\"type\":\"repeatable\",\"name\":\"sp_accordion_item\",\"atts\":{\"title\":\"Accordion Title 3\",\"icon\":\"fa-behance-square\",\"content\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\"}}]}]}]},{\"type\":\"sp_row\",\"layout\":\"48\",\"disable\":false,\"settings\":{},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-4\",\"settings\":{\"sortableitem\":\"[object Object]\"},\"attr\":[{\"name\":\"accordion\",\"title\":\"Accordion\",\"atts\":{\"title\":\"Success Style\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"20\",\"title_margin_bottom\":\"30\",\"style\":\"panel-success\",\"class\":\"\"},\"scontent\":[{\"type\":\"repeatable\",\"name\":\"sp_accordion_item\",\"atts\":{\"title\":\"Accordion Title 1\",\"icon\":\"\",\"content\":\"<img class=\\\"pull-left\\\" style=\\\"margin-right: 15px;\\\" src=\\\"images/sppagebuilder/video-bg.png\\\" alt=\\\"\\\" width=\\\"61\\\" height=\\\"44\\\" />\\n<p>Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus.</p>\"}},{\"type\":\"repeatable\",\"name\":\"sp_accordion_item\",\"atts\":{\"title\":\"Accordion Title 2\",\"icon\":\"\",\"content\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\"}},{\"type\":\"repeatable\",\"name\":\"sp_accordion_item\",\"atts\":{\"title\":\"Accordion Title 3\",\"icon\":\"\",\"content\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\"}}]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-8\",\"settings\":{},\"attr\":[{\"name\":\"accordion\",\"title\":\"Accordion\",\"atts\":{\"title\":\"Info Style\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"20\",\"title_margin_bottom\":\"30\",\"style\":\"panel-info\",\"class\":\"\"},\"scontent\":[{\"type\":\"repeatable\",\"name\":\"sp_accordion_item\",\"atts\":{\"title\":\"Accordion Title 1\",\"icon\":\"fa-align-center\",\"content\":\"<img class=\\\"pull-left\\\" style=\\\"margin-right: 15px;\\\" src=\\\"images/sppagebuilder/coustomizable.png\\\" alt=\\\"\\\" width=\\\"52\\\" height=\\\"52\\\" />\\n<p>Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum.</p>\"}},{\"type\":\"repeatable\",\"name\":\"sp_accordion_item\",\"atts\":{\"title\":\"Accordion Title 2\",\"icon\":\"fa-bank\",\"content\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\"}},{\"type\":\"repeatable\",\"name\":\"sp_accordion_item\",\"atts\":{\"title\":\"Accordion Title 3\",\"icon\":\"fa-android\",\"content\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\"}}]}]}]},{\"type\":\"sp_row\",\"layout\":\"57\",\"disable\":false,\"settings\":{},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-5\",\"settings\":{\"sortableitem\":\"[object Object]\"},\"attr\":[{\"name\":\"accordion\",\"title\":\"Accordion\",\"atts\":{\"title\":\"Warning Style\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"20\",\"title_margin_bottom\":\"30\",\"style\":\"panel-warning\",\"class\":\"\"},\"scontent\":[{\"type\":\"repeatable\",\"name\":\"sp_accordion_item\",\"atts\":{\"title\":\"Accordion Title 1\",\"icon\":\"fa-bug\",\"content\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute\"}},{\"type\":\"repeatable\",\"name\":\"sp_accordion_item\",\"atts\":{\"title\":\"Accordion Title 2\",\"icon\":\"\",\"content\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\"}},{\"type\":\"repeatable\",\"name\":\"sp_accordion_item\",\"atts\":{\"title\":\"Accordion Title 3\",\"icon\":\"\",\"content\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\"}}]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-7\",\"settings\":{},\"attr\":[{\"name\":\"accordion\",\"title\":\"Accordion\",\"atts\":{\"title\":\"Danger Style\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"20\",\"title_margin_bottom\":\"30\",\"style\":\"panel-danger\",\"class\":\"\"},\"scontent\":[{\"type\":\"repeatable\",\"name\":\"sp_accordion_item\",\"atts\":{\"title\":\"Accordion Title 1\",\"icon\":\"\",\"content\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt.\"}},{\"type\":\"repeatable\",\"name\":\"sp_accordion_item\",\"atts\":{\"title\":\"Accordion Title 2\",\"icon\":\"\",\"content\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\"}},{\"type\":\"repeatable\",\"name\":\"sp_accordion_item\",\"atts\":{\"title\":\"Accordion Title 3\",\"icon\":\"\",\"content\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\"}}]}]}]},{\"type\":\"sp_row\",\"layout\":12,\"disable\":false,\"settings\":{\"title\":\"\",\"subtitle\":\"\",\"title_position\":\"sppb-text-center\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":\"\",\"margin\":\"\",\"fullscreen\":\"\"},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-12\",\"settings\":{\"sortableitem\":\"[object Object]\",\"class\":\"\",\"animationdelay\":0,\"animationduration\":300,\"animation\":\"\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"attr\":[{\"name\":\"accordion\",\"title\":\"Accordion\",\"atts\":{\"title\":\"Default Style\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"20\",\"title_margin_bottom\":\"30\",\"style\":\"panel-default\",\"class\":\"\"},\"scontent\":[{\"type\":\"repeatable\",\"name\":\"sp_accordion_item\",\"atts\":{\"title\":\"Accordion Title 1\",\"icon\":\"fa-adjust\",\"content\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor\"}},{\"type\":\"repeatable\",\"name\":\"sp_accordion_item\",\"atts\":{\"title\":\"Accordion Title 2\",\"icon\":\"fa-ambulance\",\"content\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor\"}},{\"type\":\"repeatable\",\"name\":\"sp_accordion_item\",\"atts\":{\"title\":\"Accordion Title 3\",\"icon\":\"fa-youtube\",\"content\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor\"}}]}]}]}]', 'com_sppagebuilder', 'page', 0, 0, 1, 0, 1, 0, '2015-09-21 08:40:45', 270, '2015-10-01 06:41:45', 270, 0, '0000-00-00 00:00:00', '', '', '', '*', 0, '');
INSERT INTO `#__sppagebuilder` (`id`, `asset_id`, `title`, `text`, `extension`, `extension_view`, `view_id`, `active`, `published`, `catid`, `access`, `ordering`, `created_on`, `created_by`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `og_title`, `og_image`, `og_description`, `language`, `hits`, `css`) VALUES
(20, 0, 'Animated Number', '[{\"type\":\"sp_row\",\"layout\":\"3333\",\"disable\":false,\"settings\":{\"title_fontweight\":600,\"fullscreen\":0,\"margin\":\"50px 0 100px\",\"padding\":\"\",\"class\":\"\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":50,\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontsize\":28,\"title\":\"Animated Number\"},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-3 active-column-parent\",\"settings\":{\"sortableitem\":\"[object Object]\",\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\"\"},\"attr\":[{\"name\":\"animated_number\",\"title\":\"Animated Number\",\"atts\":{\"number\":\"435\",\"duration\":\"2000\",\"counter_title\":\"\",\"alignment\":\"sppb-text-center\",\"font_size\":\"72\",\"color\":\"#2991d6\",\"title_font_size\":\"25\",\"counter_color\":\"\",\"background\":\"\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"text_block\",\"title\":\"Text Block\",\"atts\":{\"title\":\"AWARDS\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"20\",\"title_margin_bottom\":\"\",\"text\":\"\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-3\",\"settings\":{},\"attr\":[{\"name\":\"animated_number\",\"title\":\"Animated Number\",\"atts\":{\"number\":\"735\",\"duration\":\"2000\",\"counter_title\":\"\",\"alignment\":\"sppb-text-center\",\"font_size\":\"72\",\"color\":\"#a1c63d\",\"title_font_size\":\"25\",\"counter_color\":\"\",\"background\":\"\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"text_block\",\"title\":\"Text Block\",\"atts\":{\"title\":\"CLIENTS\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"20\",\"title_margin_bottom\":\"\",\"text\":\"\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-3\",\"settings\":{},\"attr\":[{\"name\":\"animated_number\",\"title\":\"Animated Number\",\"atts\":{\"number\":\"475\",\"duration\":\"2000\",\"counter_title\":\"\",\"alignment\":\"sppb-text-center\",\"font_size\":\"72\",\"color\":\"#fba020\",\"title_font_size\":\"25\",\"counter_color\":\"\",\"background\":\"\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"text_block\",\"title\":\"Text Block\",\"atts\":{\"title\":\"JOOMLA\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"20\",\"title_margin_bottom\":\"\",\"text\":\"\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-3\",\"settings\":{},\"attr\":[{\"name\":\"animated_number\",\"title\":\"Animated Number\",\"atts\":{\"number\":\"357\",\"duration\":\"2000\",\"counter_title\":\"\",\"alignment\":\"sppb-text-center\",\"font_size\":\"72\",\"color\":\"#e72b5c\",\"title_font_size\":\"25\",\"counter_color\":\"\",\"background\":\"\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"text_block\",\"title\":\"Text Block\",\"atts\":{\"title\":\"TEMPLATE\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"20\",\"title_margin_bottom\":\"\",\"text\":\"\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"scontent\":[]}]}]},{\"type\":\"sp_row\",\"layout\":12,\"disable\":false,\"settings\":{\"title_fontweight\":600,\"fullscreen\":0,\"margin\":\"80px 0 0\",\"padding\":\"\",\"class\":\"\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"title_position\":\"sppb-text-left\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontsize\":28,\"heading_selector\":\"h2\",\"title\":\"Animated Number with image\"},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-12\",\"settings\":{},\"attr\":[]}]},{\"type\":\"sp_row\",\"layout\":\"444\",\"disable\":false,\"settings\":{\"fullscreen\":0,\"margin\":\"0 0 80px\",\"padding\":\"80px 40px\",\"class\":\"\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_image\":\"\",\"color\":\"\",\"background_color\":\"#0d182e\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":35,\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontsize\":\"\",\"title\":\"\",\"heading_selector\":\"h2\",\"title_fontweight\":\"\"},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-4\",\"settings\":{\"sortableitem\":\"[object Object]\",\"class\":\"\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"attr\":[{\"name\":\"image\",\"title\":\"Image\",\"atts\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"image\":\"images/sppagebuilder/custom-addon.png\",\"alt_text\":\"\",\"position\":\"sppb-text-center\",\"link\":\"http://\",\"target\":\"\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"atts\":{\"gap\":\"20\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"animated_number\",\"title\":\"Animated Number\",\"atts\":{\"number\":\"435\",\"duration\":\"2000\",\"counter_title\":\"\",\"alignment\":\"sppb-text-center\",\"font_size\":\"48\",\"color\":\"#ffffff\",\"title_font_size\":\"25\",\"counter_color\":\"\",\"background\":\"\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-4\",\"settings\":{\"sortableitem\":\"[object Object]\"},\"attr\":[{\"name\":\"image\",\"title\":\"Image\",\"atts\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"image\":\"images/sppagebuilder/addon.png\",\"alt_text\":\"\",\"position\":\"sppb-text-center\",\"link\":\"http://\",\"target\":\"\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"atts\":{\"gap\":\"20\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"animated_number\",\"title\":\"Animated Number\",\"atts\":{\"number\":\"735\",\"duration\":\"2000\",\"counter_title\":\"\",\"alignment\":\"sppb-text-center\",\"font_size\":\"48\",\"color\":\"#ffffff\",\"title_font_size\":\"25\",\"counter_color\":\"\",\"background\":\"\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-4\",\"settings\":{\"sortableitem\":\"[object Object]\"},\"attr\":[{\"name\":\"image\",\"title\":\"Image\",\"atts\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"image\":\"images/sppagebuilder/Drag-drop.png\",\"alt_text\":\"\",\"position\":\"sppb-text-center\",\"link\":\"http://\",\"target\":\"\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"atts\":{\"gap\":\"20\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"animated_number\",\"title\":\"Animated Number\",\"atts\":{\"number\":\"475\",\"duration\":\"2000\",\"counter_title\":\"\",\"alignment\":\"sppb-text-center\",\"font_size\":\"48\",\"color\":\"#ffffff\",\"title_font_size\":\"25\",\"counter_color\":\"\",\"background\":\"\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"\",\"class\":\"\"},\"scontent\":[]}]}]},{\"type\":\"sp_row\",\"layout\":12,\"disable\":false,\"settings\":{\"title_fontweight\":600,\"fullscreen\":0,\"margin\":\"80px 0 0\",\"padding\":\"\",\"class\":\"\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"title_position\":\"sppb-text-left\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontsize\":28,\"heading_selector\":\"h2\",\"title\":\"Animated Number with icon\"},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-12\",\"settings\":{},\"attr\":[]}]},{\"type\":\"sp_row\",\"layout\":\"444\",\"disable\":false,\"settings\":{\"subtitle_fontsize\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontsize\":\"\",\"title\":\"\",\"subtitle\":\"\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"images/sppagebuilder/banner1.jpg\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":\"80px 40px\",\"margin\":\"0 0 80px\",\"fullscreen\":0,\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\"},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-4\",\"settings\":{\"sortableitem\":\"[object Object]\",\"class\":\"\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"attr\":[{\"name\":\"animated_number\",\"title\":\"Animated Number\",\"atts\":{\"number\":\"435\",\"duration\":\"2000\",\"counter_title\":\"\",\"alignment\":\"sppb-text-center\",\"font_size\":\"48\",\"color\":\"#ffffff\",\"title_font_size\":\"25\",\"counter_color\":\"\",\"background\":\"\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"atts\":{\"gap\":\"20\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"image\",\"title\":\"Image\",\"atts\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"image\":\"images/sppagebuilder/feature8.png\",\"alt_text\":\"\",\"position\":\"sppb-text-center\",\"link\":\"http://\",\"target\":\"\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-4\",\"settings\":{\"sortableitem\":\"[object Object]\"},\"attr\":[{\"name\":\"animated_number\",\"title\":\"Animated Number\",\"atts\":{\"number\":\"735\",\"duration\":\"2000\",\"counter_title\":\"\",\"alignment\":\"sppb-text-center\",\"font_size\":\"48\",\"color\":\"#ffffff\",\"title_font_size\":\"25\",\"counter_color\":\"\",\"background\":\"\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"atts\":{\"gap\":\"20\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"image\",\"title\":\"Image\",\"atts\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"image\":\"images/sppagebuilder/feature1.png\",\"alt_text\":\"\",\"position\":\"sppb-text-center\",\"link\":\"http://\",\"target\":\"\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-4\",\"settings\":{\"sortableitem\":\"[object Object]\"},\"attr\":[{\"name\":\"animated_number\",\"title\":\"Animated Number\",\"atts\":{\"number\":\"475\",\"duration\":\"2000\",\"counter_title\":\"\",\"alignment\":\"sppb-text-center\",\"font_size\":\"48\",\"color\":\"#ffffff\",\"title_font_size\":\"25\",\"counter_color\":\"\",\"background\":\"\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"atts\":{\"gap\":\"20\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"image\",\"title\":\"Image\",\"atts\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"image\":\"images/sppagebuilder/feature2.png\",\"alt_text\":\"\",\"position\":\"sppb-text-center\",\"link\":\"http://\",\"target\":\"\",\"class\":\"\"},\"scontent\":[]}]}]}]', 'com_sppagebuilder', 'page', 0, 0, 1, 0, 1, 0, '2015-09-21 08:54:50', 270, '2015-09-30 09:38:35', 270, 0, '0000-00-00 00:00:00', '', '', '', '*', 0, ''),
(21, 0, 'Call To Action', '[{\"type\":\"sp_row\",\"layout\":12,\"disable\":false,\"settings\":{\"title\":\"\",\"title_fontsize\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":\"0 20px\",\"margin\":\"50px 0 100px\",\"fullscreen\":0},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-12\",\"settings\":{\"class\":\"\",\"animationdelay\":0,\"animationduration\":300,\"animation\":\"\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"attr\":[{\"name\":\"call_to_action\",\"title\":\"Call to Action\",\"atts\":{\"title\":\"SP Page Bulider for joomla 3.3 +\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"Duis at nisl quis quam condimentum pulvinar. \",\"subtitle_fontsize\":\"16\",\"subtitle_fontweight\":\"\",\"subtitle_text_color\":\"\",\"text\":\"\",\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"button_text\":\"Documentation\",\"button_url\":\"http://www.joomshaper.com/documentation/joomla-extensions/sp-page-builder\",\"button_size\":\"\",\"button_type\":\"info\",\"button_icon\":\"\",\"button_block\":\"\",\"button_target\":\"_blank\",\"button_position\":\"right\",\"class\":\"\"},\"scontent\":[]}]}]},{\"type\":\"sp_row\",\"layout\":12,\"disable\":false,\"settings\":{\"title\":\"\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"background_color\":\"\",\"color\":\"#ffffff\",\"background_image\":\"images/sppagebuilder/banner1.jpg\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":\"60px 20px\",\"margin\":\"100px 0\",\"fullscreen\":0},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-12\",\"settings\":{\"class\":\"\",\"animationdelay\":0,\"animationduration\":300,\"animation\":\"\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"attr\":[{\"name\":\"call_to_action\",\"title\":\"Call to Action\",\"atts\":{\"title\":\"Let\'s Build Your Website\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"#ffffff\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"Duis at nisl quis quam condi mentum pulvinar quis quam condi \",\"subtitle_fontsize\":\"16\",\"subtitle_fontweight\":\"\",\"subtitle_text_color\":\"#ffffff\",\"text\":\"\",\"background\":\"\",\"color\":\"#ffffff\",\"padding\":\"30\",\"button_text\":\"Preview\",\"button_url\":\"http://www.joomshaper.com/page-builder\",\"button_size\":\"lg\",\"button_type\":\"success\",\"button_icon\":\"\",\"button_block\":\"\",\"button_target\":\"_blank\",\"button_position\":\"right\",\"class\":\" btn-text-white\"},\"scontent\":[]}]}]},{\"type\":\"sp_row\",\"layout\":12,\"disable\":false,\"settings\":{\"title\":\"\",\"title_fontsize\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":\"0 20px\",\"margin\":\"100px 0 50px\",\"fullscreen\":0},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-12\",\"settings\":{\"class\":\"\",\"animationdelay\":0,\"animationduration\":300,\"animation\":\"\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"attr\":[{\"name\":\"call_to_action\",\"title\":\"Call to Action\",\"atts\":{\"title\":\"We Are Best and Creative  Agency\",\"heading_selector\":\"h2\",\"title_fontsize\":\"28\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"subtitle_fontweight\":\"\",\"subtitle_text_color\":\"\",\"text\":\"Duis at nisl quis quam condimentum pulvinar<br/><br/>\",\"background\":\"\",\"color\":\"\",\"padding\":\"30\",\"button_text\":\"Download\",\"button_url\":\"http://www.joomshaper.com/page-builder\",\"button_size\":\"lg\",\"button_type\":\"success\",\"button_icon\":\"fa-cloud-download\",\"button_block\":\"\",\"button_target\":\"_blank\",\"button_position\":\"bottom\",\"class\":\"\"},\"scontent\":[]}]}]}]', 'com_sppagebuilder', 'page', 0, 0, 1, 0, 1, 0, '2015-09-21 08:56:44', 270, '2015-09-30 11:45:24', 270, 0, '0000-00-00 00:00:00', '', '', '', '*', 0, ''),
(22, 0, 'Team', '[{\"type\":\"sp_row\",\"layout\":\"3333\",\"settings\":{\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"heading_selector\":\"h2\",\"fullscreen\":0,\"margin\":\"50px 0 100px\",\"padding\":\"0 20px\",\"class\":\"\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_position\":\"0 0\",\"background_attachment\":\"fixed\",\"background_size\":\"cover\",\"background_repeat\":\"no-repeat\",\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"title_position\":\"sppb-text-left\",\"subtitle\":\"\",\"title\":\"Head of the Team\",\"title_fontsize\":28,\"subtitle_fontsize\":\"\"},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-3\",\"settings\":{\"sortableitem\":\"[object Object]\",\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"\",\"animationduration\":300,\"animationdelay\":0,\"class\":\"\"},\"attr\":[{\"name\":\"person\",\"title\":\"Person\",\"atts\":{\"image\":\"images/sppagebuilder/team1.jpg\",\"name\":\"Michel Jony\",\"designation\":\"CEO & Founder\",\"facebook\":\"\",\"twitter\":\"\",\"google_plus\":\"\",\"youtube\":\"\",\"linkedin\":\"\",\"pinterest\":\"\",\"flickr\":\"\",\"dribbble\":\"\",\"behance\":\"\",\"instagram\":\"\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-3\",\"settings\":{},\"attr\":[{\"name\":\"person\",\"title\":\"Person\",\"atts\":{\"image\":\"images/sppagebuilder/team2.jpg\",\"name\":\"Hasan Shasa\",\"designation\":\"Web Developer\",\"facebook\":\"\",\"twitter\":\"\",\"google_plus\":\"\",\"youtube\":\"\",\"linkedin\":\"\",\"pinterest\":\"\",\"flickr\":\"\",\"dribbble\":\"\",\"behance\":\"\",\"instagram\":\"\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-3\",\"settings\":{},\"attr\":[{\"name\":\"person\",\"title\":\"Person\",\"atts\":{\"image\":\"images/sppagebuilder/team5.jpg\",\"name\":\"Anny Sollen\",\"designation\":\"Creative Desiner\",\"facebook\":\"\",\"twitter\":\"\",\"google_plus\":\"\",\"youtube\":\"\",\"linkedin\":\"\",\"pinterest\":\"\",\"flickr\":\"\",\"dribbble\":\"\",\"behance\":\"\",\"instagram\":\"\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-3\",\"settings\":{},\"attr\":[{\"name\":\"person\",\"title\":\"Person\",\"atts\":{\"image\":\"images/sppagebuilder/team4.jpg\",\"name\":\"Jenifer Hankey\",\"designation\":\"PHP Developer \",\"facebook\":\"\",\"twitter\":\"\",\"google_plus\":\"\",\"youtube\":\"\",\"linkedin\":\"\",\"pinterest\":\"\",\"flickr\":\"\",\"dribbble\":\"\",\"behance\":\"\",\"instagram\":\"\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"scontent\":[]}]}]},{\"type\":\"sp_row\",\"layout\":\"3333\",\"settings\":{\"fullscreen\":0,\"margin\":\"100px 0\",\"padding\":\"0 20px\",\"class\":\"\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_position\":\"0 0\",\"background_attachment\":\"fixed\",\"background_size\":\"cover\",\"background_repeat\":\"no-repeat\",\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"title_position\":\"sppb-text-left\",\"subtitle\":\"\",\"title\":\"Marketing Team\",\"title_fontsize\":28,\"subtitle_fontsize\":\"\",\"heading_selector\":\"h2\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\"},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-3\",\"settings\":{\"sortableitem\":\"[object Object]\",\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"\",\"animationduration\":300,\"animationdelay\":0,\"class\":\"\"},\"attr\":[{\"name\":\"person\",\"title\":\"Person\",\"atts\":{\"image\":\"images/sppagebuilder/team6.jpg\",\"name\":\"Rifat Alif\",\"designation\":\"CEO & Founder\",\"facebook\":\"#\",\"twitter\":\"#\",\"google_plus\":\"#\",\"youtube\":\"#\",\"linkedin\":\"\",\"pinterest\":\"\",\"flickr\":\"\",\"dribbble\":\"\",\"behance\":\"\",\"instagram\":\"\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-3\",\"settings\":{},\"attr\":[{\"name\":\"person\",\"title\":\"Person\",\"atts\":{\"image\":\"images/sppagebuilder/team3.jpg\",\"name\":\"Risat Rajin\",\"designation\":\"CEO & Founder\",\"facebook\":\"#\",\"twitter\":\"#\",\"google_plus\":\"#\",\"youtube\":\"#\",\"linkedin\":\"\",\"pinterest\":\"\",\"flickr\":\"\",\"dribbble\":\"\",\"behance\":\"\",\"instagram\":\"\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-3\",\"settings\":{},\"attr\":[{\"name\":\"person\",\"title\":\"Person\",\"atts\":{\"image\":\"images/sppagebuilder/team8.jpg\",\"name\":\"Nayem money\",\"designation\":\"CEO & Founder\",\"facebook\":\"#\",\"twitter\":\"#\",\"google_plus\":\"#\",\"youtube\":\"#\",\"linkedin\":\"\",\"pinterest\":\"\",\"flickr\":\"\",\"dribbble\":\"\",\"behance\":\"\",\"instagram\":\"\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-3\",\"settings\":{},\"attr\":[{\"name\":\"person\",\"title\":\"Person\",\"atts\":{\"image\":\"images/sppagebuilder/team1.jpg\",\"name\":\"Risat Rajin\",\"designation\":\"CEO & Founder\",\"facebook\":\"#\",\"twitter\":\"#\",\"google_plus\":\"#\",\"youtube\":\"#\",\"linkedin\":\"\",\"pinterest\":\"\",\"flickr\":\"\",\"dribbble\":\"\",\"behance\":\"\",\"instagram\":\"\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"scontent\":[]}]}]}]', 'com_sppagebuilder', 'page', 0, 0, 1, 0, 1, 0, '2015-09-21 08:57:05', 270, '2015-09-22 13:12:09', 270, 0, '0000-00-00 00:00:00', '', '', '', '*', 0, ''),
(23, 0, 'Video & Audio', '[{\"type\":\"sp_row\",\"layout\":12,\"disable\":false,\"settings\":{\"fullscreen\":0,\"margin\":\"50px 0 100px\",\"padding\":\"\",\"class\":\"\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_position\":\"0 0\",\"background_attachment\":\"fixed\",\"background_size\":\"cover\",\"background_repeat\":\"no-repeat\",\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"title_position\":\"sppb-text-center\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_fontsize\":28,\"heading_selector\":\"h3\",\"title\":\"Full Screen\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\"},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-12\",\"settings\":{\"class\":\"\",\"animationdelay\":0,\"animationduration\":300,\"animation\":\"\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"attr\":[{\"name\":\"video\",\"title\":\"Video\",\"atts\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"url\":\"http://vimeo.com/73887131\",\"class\":\"\"},\"scontent\":[]}]}]},{\"type\":\"sp_row\",\"layout\":\"66\",\"disable\":false,\"settings\":{\"title\":\"\",\"title_fontsize\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":\"0 20px\",\"margin\":\"100px 0\",\"fullscreen\":0},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-6\",\"settings\":{\"sortableitem\":\"[object Object]\"},\"attr\":[{\"name\":\"video\",\"title\":\"Video\",\"atts\":{\"title\":\"Vimeo\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"20\",\"url\":\"http://vimeo.com/4445417\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-6\",\"settings\":{},\"attr\":[{\"name\":\"video\",\"title\":\"Video\",\"atts\":{\"title\":\"Youtube\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"20\",\"url\":\"https://www.youtube.com/watch?v=VCI1SlqUeMs\",\"class\":\"\"},\"scontent\":[]}]}]},{\"type\":\"sp_row\",\"layout\":\"66\",\"disable\":false,\"settings\":{\"title\":\"\",\"title_fontsize\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":\"0 20px\",\"margin\":\"100px 0\",\"fullscreen\":0},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-6\",\"settings\":{\"sortableitem\":\"[object Object]\"},\"attr\":[{\"name\":\"video\",\"title\":\"Video\",\"atts\":{\"title\":\"Youtube\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"20\",\"url\":\"https://www.youtube.com/watch?v=AQSTBqvfw8s\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-6\",\"settings\":{},\"attr\":[{\"name\":\"video\",\"title\":\"Video\",\"atts\":{\"title\":\"Vevo\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"20\",\"url\":\"https://www.youtube.com/watch?v=qpgTC9MDx1o\",\"class\":\"\"},\"scontent\":[]}]}]},{\"type\":\"sp_row\",\"layout\":\"66\",\"disable\":false,\"settings\":{\"title\":\"\",\"title_fontsize\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":\"0 20px\",\"margin\":\"100px 0\",\"fullscreen\":0},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-6\",\"settings\":{\"sortableitem\":\"[object Object]\"},\"attr\":[{\"name\":\"soundcloud\",\"title\":\"Souncloud\",\"atts\":{\"title\":\"Souncloud\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"20\",\"embed\":\"<iframe width=\\\"100%\\\" height=\\\"350\\\" scrolling=\\\"no\\\" frameborder=\\\"no\\\" src=\\\"https://w.soundcloud.com/player/?url=https%3A//api.soundcloud.com/tracks/154798838&auto_play=false&hide_related=false&show_comments=true&show_user=true&show_reposts=false&visual=true\\\"></iframe>\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-6\",\"settings\":{},\"attr\":[{\"name\":\"soundcloud\",\"title\":\"Souncloud\",\"atts\":{\"title\":\"Souncloud\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"20\",\"embed\":\"<iframe width=\\\"100%\\\" height=\\\"350\\\" scrolling=\\\"no\\\" frameborder=\\\"no\\\" src=\\\"https://w.soundcloud.com/player/?url=https%3A//api.soundcloud.com/tracks/119076886&auto_play=false&hide_related=false&show_comments=true&show_user=true&show_reposts=false&visual=true\\\"></iframe>\",\"class\":\"\"},\"scontent\":[]}]}]}]', 'com_sppagebuilder', 'page', 0, 0, 1, 0, 1, 0, '2015-09-21 08:57:49', 270, '2015-09-30 11:51:01', 270, 0, '0000-00-00 00:00:00', '', '', '', '*', 0, ''),
(24, 0, 'Feature Box', '[{\"type\":\"sp_row\",\"layout\":\"444\",\"settings\":{\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":\"0 20px\",\"margin\":\"50px 0 100px\",\"fullscreen\":0},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-4\",\"settings\":{\"class\":\"\",\"animationdelay\":0,\"animationduration\":300,\"animation\":\"\",\"padding\":\"\",\"color\":\"\",\"background\":\"\",\"sortableitem\":\"[object Object]\"},\"attr\":[{\"name\":\"feature\",\"title\":\"Feature Box\",\"atts\":{\"title\":\"Page Builder\",\"heading_selector\":\"h3\",\"title_fontsize\":\"20\",\"title_fontweight\":\"\",\"title_text_color\":\"#1a1a1a\",\"title_margin\":\"\",\"title_url\":\"\",\"title_position\":\"after\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_type\":\"fontawesome_icon\",\"icon_name\":\"fa-wrench\",\"linea_icon_name\":\"0\",\"icon_size\":\"32\",\"icon_color\":\"#ffffff\",\"icon_background\":\"#48b6e5\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"100\",\"icon_margin_top\":\"\",\"icon_margin_bottom\":\"10\",\"icon_padding\":\"40\",\"text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer adipiscing.\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-4\",\"settings\":{},\"attr\":[{\"name\":\"feature\",\"title\":\"Feature Box\",\"atts\":{\"title\":\"Joomla Core\",\"heading_selector\":\"h3\",\"title_fontsize\":\"20\",\"title_fontweight\":\"\",\"title_text_color\":\"#1a1a1a\",\"title_margin\":\"\",\"title_url\":\"\",\"title_position\":\"after\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_type\":\"fontawesome_icon\",\"icon_name\":\"fa-android\",\"linea_icon_name\":\"0\",\"icon_size\":\"32\",\"icon_color\":\"#ffffff\",\"icon_background\":\"#a1c63d\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"100\",\"icon_margin_top\":\"\",\"icon_margin_bottom\":\"10\",\"icon_padding\":\"40\",\"text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer adipiscing.\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-4\",\"settings\":{},\"attr\":[{\"name\":\"feature\",\"title\":\"Feature Box\",\"atts\":{\"title\":\"Fully Responsive\",\"heading_selector\":\"h3\",\"title_fontsize\":\"20\",\"title_fontweight\":\"\",\"title_text_color\":\"#1a1a1a\",\"title_margin\":\"\",\"title_url\":\"\",\"title_position\":\"after\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_type\":\"fontawesome_icon\",\"icon_name\":\"fa-apple\",\"linea_icon_name\":\"0\",\"icon_size\":\"32\",\"icon_color\":\"#ffffff\",\"icon_background\":\"#fba020\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"100\",\"icon_margin_top\":\"\",\"icon_margin_bottom\":\"10\",\"icon_padding\":\"40\",\"text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer adipiscing.\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"scontent\":[]}]}]},{\"type\":\"sp_row\",\"layout\":\"3333\",\"settings\":{\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":\"0 20px\",\"margin\":\"100px 0\",\"fullscreen\":0},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-3\",\"settings\":{\"sortableitem\":\"[object Object]\",\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"\",\"animationduration\":300,\"animationdelay\":0,\"class\":\"\"},\"attr\":[{\"name\":\"feature\",\"title\":\"Feature Box\",\"atts\":{\"title\":\"Framework\",\"heading_selector\":\"h3\",\"title_fontsize\":\"20\",\"title_fontweight\":\"\",\"title_text_color\":\"#1a1a1a\",\"title_margin\":\"\",\"title_url\":\"\",\"title_position\":\"after\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_type\":\"fontawesome_icon\",\"icon_name\":\"fa-cog\",\"linea_icon_name\":\"0\",\"icon_size\":\"22\",\"icon_color\":\"#ffffff\",\"icon_background\":\"#428bca\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"5\",\"icon_margin_top\":\"\",\"icon_margin_bottom\":\"10\",\"icon_padding\":\"25\",\"text\":\"Lorem ipsum dolor sit amet consectetur adipiscing elit.\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-3\",\"settings\":{\"sortableitem\":\"[object Object]\"},\"attr\":[{\"name\":\"feature\",\"title\":\"Feature Box\",\"atts\":{\"title\":\"Supports\",\"heading_selector\":\"h3\",\"title_fontsize\":\"20\",\"title_fontweight\":\"\",\"title_text_color\":\"#1a1a1a\",\"title_margin\":\"\",\"title_url\":\"\",\"title_position\":\"after\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_type\":\"fontawesome_icon\",\"icon_name\":\"fa-bell\",\"linea_icon_name\":\"0\",\"icon_size\":\"22\",\"icon_color\":\"#ffffff\",\"icon_background\":\"#e62955\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"5\",\"icon_margin_top\":\"\",\"icon_margin_bottom\":\"10\",\"icon_padding\":\"25\",\"text\":\"Lorem ipsum dolor sit amet consectetur adipiscing elit.\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-3\",\"settings\":{\"sortableitem\":\"[object Object]\"},\"attr\":[{\"name\":\"feature\",\"title\":\"Feature Box\",\"atts\":{\"title\":\"Creative\",\"heading_selector\":\"h3\",\"title_fontsize\":\"20\",\"title_fontweight\":\"\",\"title_text_color\":\"#1a1a1a\",\"title_margin\":\"\",\"title_url\":\"\",\"title_position\":\"after\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_type\":\"fontawesome_icon\",\"icon_name\":\"fa-dropbox\",\"linea_icon_name\":\"0\",\"icon_size\":\"22\",\"icon_color\":\"#ffffff\",\"icon_background\":\"#e0da24\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"5\",\"icon_margin_top\":\"\",\"icon_margin_bottom\":\"10\",\"icon_padding\":\"25\",\"text\":\"Lorem ipsum dolor sit amet consectetur adipiscing elit.\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-3\",\"settings\":{},\"attr\":[{\"name\":\"feature\",\"title\":\"Feature Box\",\"atts\":{\"title\":\"Development\",\"heading_selector\":\"h3\",\"title_fontsize\":\"20\",\"title_fontweight\":\"\",\"title_text_color\":\"#1a1a1a\",\"title_margin\":\"\",\"title_url\":\"\",\"title_position\":\"after\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_type\":\"fontawesome_icon\",\"icon_name\":\"fa-copy\",\"linea_icon_name\":\"0\",\"icon_size\":\"22\",\"icon_color\":\"#ffffff\",\"icon_background\":\"#8433e8\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"5\",\"icon_margin_top\":\"\",\"icon_margin_bottom\":\"10\",\"icon_padding\":\"25\",\"text\":\"Lorem ipsum dolor sit amet consectetur adipiscing elit.\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"scontent\":[]}]}]},{\"type\":\"sp_row\",\"layout\":\"3333\",\"settings\":{\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":\"0 20px\",\"margin\":\"100px 0\",\"fullscreen\":0},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-3\",\"settings\":{\"sortableitem\":\"[object Object]\",\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"\",\"animationduration\":300,\"animationdelay\":0,\"class\":\"\"},\"attr\":[{\"name\":\"feature\",\"title\":\"Feature Box\",\"atts\":{\"title\":\"Web Development\",\"heading_selector\":\"h3\",\"title_fontsize\":\"22\",\"title_fontweight\":\"\",\"title_text_color\":\"#1a1a1a\",\"title_margin\":\"\",\"title_url\":\"\",\"title_position\":\"after\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_type\":\"fontawesome_icon\",\"icon_name\":\"fa-apple\",\"linea_icon_name\":\"0\",\"icon_size\":\"36\",\"icon_color\":\"#e00732\",\"icon_background\":\"\",\"icon_border_color\":\"#f3f3f3\",\"icon_border_width\":\"2\",\"icon_border_radius\":\"5\",\"icon_margin_top\":\"\",\"icon_margin_bottom\":\"10\",\"icon_padding\":\"30\",\"text\":\"Lorem ipsum dolor sit amet consectetur adipiscing\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-3\",\"settings\":{\"sortableitem\":\"[object Object]\"},\"attr\":[{\"name\":\"feature\",\"title\":\"Feature Box\",\"atts\":{\"title\":\"Web Development\",\"heading_selector\":\"h3\",\"title_fontsize\":\"22\",\"title_fontweight\":\"\",\"title_text_color\":\"#1c1c1c\",\"title_margin\":\"\",\"title_url\":\"\",\"title_position\":\"after\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_type\":\"fontawesome_icon\",\"icon_name\":\"fa-truck\",\"linea_icon_name\":\"0\",\"icon_size\":\"36\",\"icon_color\":\"#00aeef\",\"icon_background\":\"\",\"icon_border_color\":\"#f3f3f3\",\"icon_border_width\":\"2\",\"icon_border_radius\":\"5\",\"icon_margin_top\":\"\",\"icon_margin_bottom\":\"10\",\"icon_padding\":\"30\",\"text\":\"Lorem ipsum dolor sit amet consectetur adipiscing\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-3\",\"settings\":{\"sortableitem\":\"[object Object]\"},\"attr\":[{\"name\":\"feature\",\"title\":\"Feature Box\",\"atts\":{\"title\":\"Web Development\",\"heading_selector\":\"h3\",\"title_fontsize\":\"22\",\"title_fontweight\":\"\",\"title_text_color\":\"#1c1c1c\",\"title_margin\":\"\",\"title_url\":\"\",\"title_position\":\"after\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_type\":\"fontawesome_icon\",\"icon_name\":\"fa-flag\",\"linea_icon_name\":\"0\",\"icon_size\":\"36\",\"icon_color\":\"#f26c4f\",\"icon_background\":\"\",\"icon_border_color\":\"#f3f3f3\",\"icon_border_width\":\"2\",\"icon_border_radius\":\"5\",\"icon_margin_top\":\"\",\"icon_margin_bottom\":\"10\",\"icon_padding\":\"30\",\"text\":\"Lorem ipsum dolor sit amet consectetur adipiscing\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-3\",\"settings\":{},\"attr\":[{\"name\":\"feature\",\"title\":\"Feature Box\",\"atts\":{\"title\":\"Web Development\",\"heading_selector\":\"h3\",\"title_fontsize\":\"22\",\"title_fontweight\":\"\",\"title_text_color\":\"#1a1a1a\",\"title_margin\":\"\",\"title_url\":\"\",\"title_position\":\"after\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_type\":\"fontawesome_icon\",\"icon_name\":\"fa-dollar\",\"linea_icon_name\":\"0\",\"icon_size\":\"36\",\"icon_color\":\"#3cb878\",\"icon_background\":\"\",\"icon_border_color\":\"#f3f3f3\",\"icon_border_width\":\"2\",\"icon_border_radius\":\"5\",\"icon_margin_top\":\"\",\"icon_margin_bottom\":\"10\",\"icon_padding\":\"30\",\"text\":\"Lorem ipsum dolor sit amet consectetur adipiscing\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"scontent\":[]}]}]}]', 'com_sppagebuilder', 'page', 0, 0, 1, 0, 1, 0, '2015-09-21 08:58:21', 270, '2015-09-21 09:05:43', 270, 0, '0000-00-00 00:00:00', '', '', '', '*', 0, '');
INSERT INTO `#__sppagebuilder` (`id`, `asset_id`, `title`, `text`, `extension`, `extension_view`, `view_id`, `active`, `published`, `catid`, `access`, `ordering`, `created_on`, `created_by`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `og_title`, `og_image`, `og_description`, `language`, `hits`, `css`) VALUES
(25, 0, 'Icon', '[{\"type\":\"sp_row\",\"layout\":\"3333\",\"settings\":{\"fullscreen\":0,\"margin\":\"50px 0 100px\",\"padding\":\"0 20px\",\"class\":\"\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_position\":\"0 0\",\"background_attachment\":\"fixed\",\"background_size\":\"cover\",\"background_repeat\":\"no-repeat\",\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"title_position\":\"sppb-text-center\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"#1a1a1a\",\"title_fontsize\":28,\"heading_selector\":\"h3\",\"title\":\"Circle Style\"},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-3\",\"settings\":{\"sortableitem\":\"[object Object]\",\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"\",\"animationduration\":300,\"animationdelay\":0,\"class\":\"\"},\"attr\":[{\"name\":\"icon\",\"title\":\"Icon\",\"atts\":{\"icon_type\":\"fontawesome_icon\",\"name\":\"fa-apple\",\"linea_icon_name\":\"0\",\"size\":\"32\",\"color\":\"#ffffff\",\"background\":\"#48b6e5\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"100\",\"margin_top\":\"\",\"margin_bottom\":\"\",\"padding\":\"40\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-3\",\"settings\":{},\"attr\":[{\"name\":\"icon\",\"title\":\"Icon\",\"atts\":{\"icon_type\":\"fontawesome_icon\",\"name\":\"fa-apple\",\"linea_icon_name\":\"0\",\"size\":\"32\",\"color\":\"#ffffff\",\"background\":\"#a1c63d\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"100\",\"margin_top\":\"\",\"margin_bottom\":\"\",\"padding\":\"40\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-3\",\"settings\":{},\"attr\":[{\"name\":\"icon\",\"title\":\"Icon\",\"atts\":{\"icon_type\":\"fontawesome_icon\",\"name\":\"fa-apple\",\"linea_icon_name\":\"0\",\"size\":\"32\",\"color\":\"#ffffff\",\"background\":\"#fba020\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"100\",\"margin_top\":\"\",\"margin_bottom\":\"\",\"padding\":\"40\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-3\",\"settings\":{},\"attr\":[{\"name\":\"icon\",\"title\":\"Icon\",\"atts\":{\"icon_type\":\"fontawesome_icon\",\"name\":\"fa-apple\",\"linea_icon_name\":\"0\",\"size\":\"32\",\"color\":\"#ffffff\",\"background\":\"#e65c17\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"100\",\"margin_top\":\"\",\"margin_bottom\":\"\",\"padding\":\"40\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"scontent\":[]}]}]},{\"type\":\"sp_row\",\"layout\":\"3333\",\"settings\":{\"fullscreen\":0,\"margin\":\"100px 0\",\"padding\":\"0 20px\",\"class\":\"\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_position\":\"0 0\",\"background_attachment\":\"fixed\",\"background_size\":\"cover\",\"background_repeat\":\"no-repeat\",\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"title_position\":\"sppb-text-center\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"#1a1a1a\",\"title_fontsize\":28,\"heading_selector\":\"h3\",\"title\":\"Rounded Corner Style\"},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-3\",\"settings\":{\"sortableitem\":\"[object Object]\",\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"\",\"animationduration\":300,\"animationdelay\":0,\"class\":\"\"},\"attr\":[{\"name\":\"icon\",\"title\":\"Icon\",\"atts\":{\"icon_type\":\"fontawesome_icon\",\"name\":\"fa-apple\",\"linea_icon_name\":\"0\",\"size\":\"25\",\"color\":\"#ffffff\",\"background\":\"#19e3d6\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"5\",\"margin_top\":\"\",\"margin_bottom\":\"\",\"padding\":\"30\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-3\",\"settings\":{},\"attr\":[{\"name\":\"icon\",\"title\":\"Icon\",\"atts\":{\"icon_type\":\"fontawesome_icon\",\"name\":\"fa-apple\",\"linea_icon_name\":\"0\",\"size\":\"25\",\"color\":\"#ffffff\",\"background\":\"#e8a921\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"5\",\"margin_top\":\"\",\"margin_bottom\":\"\",\"padding\":\"30\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-3\",\"settings\":{},\"attr\":[{\"name\":\"icon\",\"title\":\"Icon\",\"atts\":{\"icon_type\":\"fontawesome_icon\",\"name\":\"fa-apple\",\"linea_icon_name\":\"0\",\"size\":\"25\",\"color\":\"#ffffff\",\"background\":\"#9813f0\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"5\",\"margin_top\":\"\",\"margin_bottom\":\"\",\"padding\":\"30\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-3\",\"settings\":{},\"attr\":[{\"name\":\"icon\",\"title\":\"Icon\",\"atts\":{\"icon_type\":\"fontawesome_icon\",\"name\":\"fa-apple\",\"linea_icon_name\":\"0\",\"size\":\"25\",\"color\":\"#ffffff\",\"background\":\"#2a18f0\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"5\",\"margin_top\":\"\",\"margin_bottom\":\"\",\"padding\":\"30\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"scontent\":[]}]}]},{\"type\":\"sp_row\",\"layout\":\"3333\",\"settings\":{\"fullscreen\":0,\"margin\":\"100px 0\",\"padding\":\"0 20px\",\"class\":\"\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_position\":\"0 0\",\"background_attachment\":\"fixed\",\"background_size\":\"cover\",\"background_repeat\":\"no-repeat\",\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"title_position\":\"sppb-text-center\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"#1a1a1a\",\"title_fontsize\":28,\"heading_selector\":\"h3\",\"title\":\"Square Style\"},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-3\",\"settings\":{\"sortableitem\":\"[object Object]\",\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"\",\"animationduration\":300,\"animationdelay\":0,\"class\":\"\"},\"attr\":[{\"name\":\"icon\",\"title\":\"Icon\",\"atts\":{\"icon_type\":\"fontawesome_icon\",\"name\":\"fa-apple\",\"linea_icon_name\":\"0\",\"size\":\"25\",\"color\":\"#21b3ed\",\"background\":\"\",\"border_color\":\"#f3f3f3\",\"border_width\":\"2\",\"border_radius\":\"\",\"margin_top\":\"\",\"margin_bottom\":\"\",\"padding\":\"25\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-3\",\"settings\":{},\"attr\":[{\"name\":\"icon\",\"title\":\"Icon\",\"atts\":{\"icon_type\":\"fontawesome_icon\",\"name\":\"fa-play-circle\",\"linea_icon_name\":\"0\",\"size\":\"25\",\"color\":\"#f01843\",\"background\":\"\",\"border_color\":\"#f3f3f3\",\"border_width\":\"2\",\"border_radius\":\"\",\"margin_top\":\"\",\"margin_bottom\":\"\",\"padding\":\"25\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-3\",\"settings\":{},\"attr\":[{\"name\":\"icon\",\"title\":\"Icon\",\"atts\":{\"icon_type\":\"fontawesome_icon\",\"name\":\"fa-flickr\",\"linea_icon_name\":\"0\",\"size\":\"25\",\"color\":\"#3deb26\",\"background\":\"\",\"border_color\":\"#f3f3f3\",\"border_width\":\"2\",\"border_radius\":\"\",\"margin_top\":\"\",\"margin_bottom\":\"\",\"padding\":\"25\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-3\",\"settings\":{},\"attr\":[{\"name\":\"icon\",\"title\":\"Icon\",\"atts\":{\"icon_type\":\"fontawesome_icon\",\"name\":\"fa-youtube\",\"linea_icon_name\":\"0\",\"size\":\"25\",\"color\":\"#e6b120\",\"background\":\"\",\"border_color\":\"#f3f3f3\",\"border_width\":\"2\",\"border_radius\":\"\",\"margin_top\":\"\",\"margin_bottom\":\"\",\"padding\":\"25\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"scontent\":[]}]}]}]', 'com_sppagebuilder', 'page', 0, 0, 1, 0, 1, 0, '2015-09-21 08:58:58', 270, '2015-09-21 09:05:39', 270, 0, '0000-00-00 00:00:00', '', '', '', '*', 0, ''),
(26, 0, 'Button', '[{\"type\":\"sp_row\",\"layout\":\"66\",\"disable\":false,\"settings\":{\"fullscreen\":0,\"margin\":\"50px 0 100px\",\"padding\":\"0 20px\",\"class\":\"\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_position\":\"0 0\",\"background_attachment\":\"fixed\",\"background_size\":\"cover\",\"background_repeat\":\"no-repeat\",\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"title_position\":\"sppb-text-center\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontweight\":\"\",\"title_fontsize\":\"\",\"title\":\"\"},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-6 active-column-parent\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"\",\"animationduration\":300,\"animationdelay\":0,\"class\":\"\",\"sortableitem\":\"[object Object]\"},\"attr\":[{\"name\":\"text_block\",\"title\":\"Text Block\",\"atts\":{\"title\":\"Default Style\",\"heading_selector\":\"h3\",\"title_fontsize\":\"28\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"30\",\"text\":\"\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"button\",\"title\":\"Button\",\"atts\":{\"text\":\"Button\",\"url\":\"#\",\"size\":\"lg\",\"type\":\"default\",\"icon\":\"\",\"target\":\"\",\"block\":\"\",\"margin\":\"0 20px 0 0\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"button\",\"title\":\"Button\",\"atts\":{\"text\":\"Button\",\"url\":\"#\",\"size\":\"\",\"type\":\"default\",\"icon\":\"\",\"target\":\"\",\"block\":\"\",\"margin\":\"0 20px 0 0\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"button\",\"title\":\"Button\",\"atts\":{\"text\":\"Button\",\"url\":\"#\",\"size\":\"sm\",\"type\":\"default\",\"icon\":\"\",\"target\":\"\",\"block\":\"\",\"margin\":\"0 20px 0 0\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"button\",\"title\":\"Button\",\"atts\":{\"text\":\"Button\",\"url\":\"#\",\"size\":\"xs\",\"type\":\"default\",\"icon\":\"\",\"target\":\"\",\"block\":\"\",\"margin\":\"\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-6\",\"settings\":{},\"attr\":[{\"name\":\"text_block\",\"title\":\"Text Block\",\"atts\":{\"title\":\"Primary Style\",\"heading_selector\":\"h3\",\"title_fontsize\":\"28\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"30\",\"text\":\"\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"button\",\"title\":\"Button\",\"atts\":{\"text\":\"Button\",\"url\":\"\",\"size\":\"lg\",\"type\":\"primary\",\"icon\":\"fa-android\",\"target\":\"\",\"block\":\"\",\"margin\":\"0 20px 0 0\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"button\",\"title\":\"Button\",\"atts\":{\"text\":\"Button\",\"url\":\"\",\"size\":\"\",\"type\":\"primary\",\"icon\":\"\",\"target\":\"\",\"block\":\"\",\"margin\":\"0 20px 0 0\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"button\",\"title\":\"Button\",\"atts\":{\"text\":\"Button\",\"url\":\"\",\"size\":\"sm\",\"type\":\"primary\",\"icon\":\"\",\"target\":\"\",\"block\":\"\",\"margin\":\"0 20px 0 0\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"button\",\"title\":\"Button\",\"atts\":{\"text\":\"Button\",\"url\":\"\",\"size\":\"xs\",\"type\":\"primary\",\"icon\":\"\",\"target\":\"\",\"block\":\"\",\"margin\":\"\",\"class\":\"\"},\"scontent\":[]}]}]},{\"type\":\"sp_row\",\"layout\":\"66\",\"disable\":false,\"settings\":{\"fullscreen\":0,\"margin\":\"100px 0\",\"padding\":\"0 20px\",\"class\":\"\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_position\":\"0 0\",\"background_attachment\":\"fixed\",\"background_size\":\"cover\",\"background_repeat\":\"no-repeat\",\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"title_position\":\"sppb-text-center\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontweight\":\"\",\"title_fontsize\":\"\",\"title\":\"\"},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-6\",\"settings\":{\"sortableitem\":\"[object Object]\",\"class\":\"\",\"animationdelay\":0,\"animationduration\":300,\"animation\":\"\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"attr\":[{\"name\":\"text_block\",\"title\":\"Text Block\",\"atts\":{\"title\":\"Success Style\",\"heading_selector\":\"h3\",\"title_fontsize\":\"28\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"30\",\"text\":\"\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"button\",\"title\":\"Button\",\"atts\":{\"text\":\"Button\",\"url\":\"#\",\"size\":\"lg\",\"type\":\"success\",\"icon\":\"fa-bell\",\"target\":\"\",\"block\":\"\",\"margin\":\"0 20px 0 0\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"button\",\"title\":\"Button\",\"atts\":{\"text\":\"Button\",\"url\":\"#\",\"size\":\"\",\"type\":\"success\",\"icon\":\"\",\"target\":\"\",\"block\":\"\",\"margin\":\"0 20px 0 0\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"button\",\"title\":\"Button\",\"atts\":{\"text\":\"Button\",\"url\":\"#\",\"size\":\"sm\",\"type\":\"success\",\"icon\":\"\",\"target\":\"\",\"block\":\"\",\"margin\":\"0 20px 0 0\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"button\",\"title\":\"Button\",\"atts\":{\"text\":\"Button\",\"url\":\"#\",\"size\":\"xs\",\"type\":\"success\",\"icon\":\"\",\"target\":\"\",\"block\":\"\",\"margin\":\"0 20px 0 0\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-6\",\"settings\":{},\"attr\":[{\"name\":\"text_block\",\"title\":\"Text Block\",\"atts\":{\"title\":\"Info Style\",\"heading_selector\":\"h3\",\"title_fontsize\":\"28\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"30\",\"text\":\"\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"button\",\"title\":\"Button\",\"atts\":{\"text\":\"Button\",\"url\":\"\",\"size\":\"lg\",\"type\":\"info\",\"icon\":\"fa-bell-o\",\"target\":\"\",\"block\":\"\",\"margin\":\"0 20px 0 0\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"button\",\"title\":\"Button\",\"atts\":{\"text\":\"Button\",\"url\":\"\",\"size\":\"\",\"type\":\"info\",\"icon\":\"\",\"target\":\"\",\"block\":\"\",\"margin\":\"0 20px 0 0\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"button\",\"title\":\"Button\",\"atts\":{\"text\":\"Button\",\"url\":\"\",\"size\":\"sm\",\"type\":\"info\",\"icon\":\"\",\"target\":\"\",\"block\":\"\",\"margin\":\"0 20px 0 0\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"button\",\"title\":\"Button\",\"atts\":{\"text\":\"Button\",\"url\":\"\",\"size\":\"xs\",\"type\":\"info\",\"icon\":\"\",\"target\":\"\",\"block\":\"\",\"margin\":\"\",\"class\":\"\"},\"scontent\":[]}]}]},{\"type\":\"sp_row\",\"layout\":\"66\",\"disable\":false,\"settings\":{\"fullscreen\":0,\"margin\":\"\",\"padding\":\"0 20px\",\"class\":\"\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_position\":\"0 0\",\"background_attachment\":\"fixed\",\"background_size\":\"cover\",\"background_repeat\":\"no-repeat\",\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"title_position\":\"sppb-text-center\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontweight\":\"\",\"title_fontsize\":\"\",\"title\":\"\"},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-6\",\"settings\":{\"sortableitem\":\"[object Object]\",\"class\":\"\",\"animationdelay\":0,\"animationduration\":300,\"animation\":\"\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"attr\":[{\"name\":\"text_block\",\"title\":\"Text Block\",\"atts\":{\"title\":\"Warning Style\",\"heading_selector\":\"h3\",\"title_fontsize\":\"28\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"30\",\"text\":\"\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"button\",\"title\":\"Button\",\"atts\":{\"text\":\"Button\",\"url\":\"#\",\"size\":\"lg\",\"type\":\"warning\",\"icon\":\"fa-apple\",\"target\":\"\",\"block\":\"\",\"margin\":\"0 20px 0 0\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"button\",\"title\":\"Button\",\"atts\":{\"text\":\"Button\",\"url\":\"#\",\"size\":\"\",\"type\":\"warning\",\"icon\":\"\",\"target\":\"\",\"block\":\"\",\"margin\":\"0 20px 0 0\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"button\",\"title\":\"Button\",\"atts\":{\"text\":\"Button\",\"url\":\"#\",\"size\":\"sm\",\"type\":\"warning\",\"icon\":\"\",\"target\":\"\",\"block\":\"\",\"margin\":\"0 20px 0 0\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"button\",\"title\":\"Button\",\"atts\":{\"text\":\"Button\",\"url\":\"#\",\"size\":\"xs\",\"type\":\"warning\",\"icon\":\"\",\"target\":\"\",\"block\":\"\",\"margin\":\"\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-6\",\"settings\":{},\"attr\":[{\"name\":\"text_block\",\"title\":\"Text Block\",\"atts\":{\"title\":\"Danger Style\",\"heading_selector\":\"h3\",\"title_fontsize\":\"28\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"30\",\"text\":\"\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"button\",\"title\":\"Button\",\"atts\":{\"text\":\"Button\",\"url\":\"\",\"size\":\"lg\",\"type\":\"danger\",\"icon\":\"fa-android\",\"target\":\"\",\"block\":\"\",\"margin\":\"0 20px 0 0\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"button\",\"title\":\"Button\",\"atts\":{\"text\":\"Button\",\"url\":\"\",\"size\":\"\",\"type\":\"danger\",\"icon\":\"\",\"target\":\"\",\"block\":\"\",\"margin\":\"0 20px 0 0\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"button\",\"title\":\"Button\",\"atts\":{\"text\":\"Button\",\"url\":\"\",\"size\":\"sm\",\"type\":\"danger\",\"icon\":\"\",\"target\":\"\",\"block\":\"\",\"margin\":\"0 20px 0 0\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"button\",\"title\":\"Button\",\"atts\":{\"text\":\"Button\",\"url\":\"\",\"size\":\"xs\",\"type\":\"danger\",\"icon\":\"\",\"target\":\"\",\"block\":\"\",\"margin\":\"\",\"class\":\"\"},\"scontent\":[]}]}]},{\"type\":\"sp_row\",\"layout\":12,\"disable\":false,\"settings\":{\"title\":\"\",\"title_fontsize\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":\"0 20px\",\"margin\":\"100px 0 50px\",\"fullscreen\":0,\"title_fontweight\":\"\"},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-12\",\"settings\":{\"sortableitem\":\"[object Object]\",\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"\",\"animationduration\":300,\"animationdelay\":0,\"class\":\"\"},\"attr\":[{\"name\":\"text_block\",\"title\":\"Text Block\",\"atts\":{\"title\":\"Link Style\",\"heading_selector\":\"h3\",\"title_fontsize\":\"28\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"30\",\"text\":\"\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"button\",\"title\":\"Button\",\"atts\":{\"text\":\"Button\",\"url\":\"#\",\"size\":\"\",\"type\":\"link\",\"icon\":\"\",\"target\":\"\",\"block\":\"\",\"margin\":\"0 20px 0 0\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"button\",\"title\":\"Button\",\"atts\":{\"text\":\"Button\",\"url\":\"#\",\"size\":\"lg\",\"type\":\"link\",\"icon\":\"fa-apple\",\"target\":\"\",\"block\":\"\",\"margin\":\"0 20px 0 0\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"button\",\"title\":\"Button\",\"atts\":{\"text\":\"Button\",\"url\":\"#\",\"size\":\"sm\",\"type\":\"link\",\"icon\":\"\",\"target\":\"\",\"block\":\"\",\"margin\":\"0 20px 0 0\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"button\",\"title\":\"Button\",\"atts\":{\"text\":\"Button\",\"url\":\"#\",\"size\":\"xs\",\"type\":\"link\",\"icon\":\"\",\"target\":\"\",\"block\":\"\",\"margin\":\"\",\"class\":\"\"},\"scontent\":[]}]}]}]', 'com_sppagebuilder', 'page', 0, 0, 1, 0, 1, 0, '2015-09-21 08:59:42', 270, '2015-10-01 11:51:49', 270, 0, '0000-00-00 00:00:00', '', '', '', '*', 0, ''),
(27, 0, 'Alert', '[{\"type\":\"sp_row\",\"layout\":\"444\",\"disable\":false,\"settings\":{\"title\":\"\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":\"\",\"margin\":\"70px 0 20px 0\",\"fullscreen\":0},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-4\",\"settings\":{\"sortableitem\":\"[object Object]\"},\"attr\":[{\"name\":\"alert\",\"title\":\"Alert\",\"atts\":{\"title\":\"Info Style\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"30\",\"title_margin_bottom\":\"30\",\"text\":\"Change this and that and try again. Duis mollis, est non commodo luctus, nisi erat porttitor ligula, eget lacinia odio sem nec elit. Cras mattis consectetur purus sit amet fermentum.\",\"close\":\"yes\",\"type\":\"info\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-4\",\"settings\":{},\"attr\":[{\"name\":\"alert\",\"title\":\"Alert\",\"atts\":{\"title\":\"Warning Style\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"30\",\"title_margin_bottom\":\"30\",\"text\":\"Change this and that and try again. Duis mollis, est non commodo luctus, nisi erat porttitor ligula, eget lacinia odio sem nec elit. Cras mattis consectetur purus sit amet fermentum.\",\"close\":\"yes\",\"type\":\"warning\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-4\",\"settings\":{},\"attr\":[{\"name\":\"alert\",\"title\":\"Alert\",\"atts\":{\"title\":\"Danger Style\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"30\",\"title_margin_bottom\":\"30\",\"text\":\"Change this and that and try again. Duis mollis, est non commodo luctus, nisi erat porttitor ligula, eget lacinia odio sem nec elit. Cras mattis consectetur purus sit amet fermentum.\",\"close\":\"no\",\"type\":\"danger\",\"class\":\"\"},\"scontent\":[]}]}]},{\"type\":\"sp_row\",\"layout\":\"66\",\"disable\":false,\"settings\":{},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-6\",\"settings\":{\"sortableitem\":\"[object Object]\"},\"attr\":[{\"name\":\"alert\",\"title\":\"Alert\",\"atts\":{\"title\":\"Info Style\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"30\",\"title_margin_bottom\":\"30\",\"text\":\"Change this and that and try again. Duis mollis, est non commodo luctus, nisi erat porttitor ligula, eget lacinia odio sem nec elit. Cras mattis consectetur purus sit amet fermentum.\",\"close\":\"yes\",\"type\":\"info\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-6\",\"settings\":{\"sortableitem\":\"[object Object]\"},\"attr\":[{\"name\":\"alert\",\"title\":\"Alert\",\"atts\":{\"title\":\"Warning Style\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"30\",\"title_margin_bottom\":\"30\",\"text\":\"Change this and that and try again. Duis mollis, est non commodo luctus, nisi erat porttitor ligula, eget lacinia odio sem nec elit. Cras mattis consectetur purus sit amet fermentum.\",\"close\":\"yes\",\"type\":\"warning\",\"class\":\"\"},\"scontent\":[]}]}]},{\"type\":\"sp_row\",\"layout\":12,\"disable\":false,\"settings\":{\"subtitle_fontsize\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontweight\":\"\",\"title_fontsize\":\"\",\"fullscreen\":0,\"margin\":\"30px 0 100px 0\",\"padding\":\"\",\"class\":\"\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_position\":\"0 0\",\"background_attachment\":\"fixed\",\"background_size\":\"cover\",\"background_repeat\":\"no-repeat\",\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"title_position\":\"sppb-text-center\",\"subtitle\":\"\",\"title\":\"\"},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-12\",\"settings\":{\"class\":\"\",\"animationdelay\":0,\"animationduration\":300,\"animation\":\"\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"attr\":[{\"name\":\"alert\",\"title\":\"Alert\",\"atts\":{\"title\":\"Success\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"text\":\"Change this and that and try again. Duis mollis, est non commodo luctus, nisi erat porttitor ligula, eget lacinia odio sem nec elit. Cras mattis consectetur purus sit amet fermentum.\",\"close\":\"yes\",\"type\":\"success\",\"class\":\"\"},\"scontent\":[]}]}]}]', 'com_sppagebuilder', 'page', 0, 0, 1, 0, 1, 0, '2015-09-21 09:00:09', 270, '2015-10-01 10:44:07', 270, 0, '0000-00-00 00:00:00', '', '', '', '*', 0, ''),
(28, 0, 'Block Number', '[{\"type\":\"sp_row\",\"layout\":\"66\",\"settings\":{\"title\":\"Circle Style\",\"subtitle\":\"\",\"title_position\":\"sppb-text-left\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":\"0 40px\",\"margin\":\"100px 0\",\"fullscreen\":0,\"title_fontsize\":28,\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle_fontsize\":\"\"},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-6\",\"settings\":{\"sortableitem\":\"[object Object]\",\"class\":\"\",\"animationdelay\":0,\"animationduration\":300,\"animation\":\"\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"attr\":[{\"name\":\"blocknumber\",\"title\":\"Block Number\",\"atts\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"heading\":\"Conse Etetuer\",\"text\":\"Lorem ipsum dolor sit amet consectetuer rutrum dignissim et neque id.\",\"number\":\"01\",\"size\":\"48\",\"background\":\"#48b6e5\",\"color\":\"#ffffff\",\"border_radius\":\"100\",\"alignment\":\"left\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-6\",\"settings\":{},\"attr\":[{\"name\":\"blocknumber\",\"title\":\"Block Number\",\"atts\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"heading\":\"Rutrum Dignissim\",\"text\":\"Lorem ipsum dolor sit amet consectetuer rutrum dignissim et neque id.\",\"number\":\"01\",\"size\":\"48\",\"background\":\"#fba020\",\"color\":\"#ffffff\",\"border_radius\":\"100\",\"alignment\":\"left\",\"class\":\"\"},\"scontent\":[]}]}]},{\"type\":\"sp_row\",\"layout\":\"444\",\"settings\":{\"title_position\":\"sppb-text-left\",\"heading_selector\":\"h2\",\"title\":\"Rounded Corner Style\",\"subtitle\":\"\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":\"0 40px\",\"margin\":\"100px 0\",\"fullscreen\":0,\"title_fontsize\":28,\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle_fontsize\":\"\"},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-4\",\"settings\":{\"sortableitem\":\"[object Object]\"},\"attr\":[{\"name\":\"blocknumber\",\"title\":\"Block Number\",\"atts\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"heading\":\"\",\"text\":\"Lorem ipsum dolor sit amet consectetuer rutrum dignissim\",\"number\":\"03\",\"size\":\"48\",\"background\":\"#a1c63d\",\"color\":\"#ffffff\",\"border_radius\":\"10\",\"alignment\":\"left\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-4\",\"settings\":{},\"attr\":[{\"name\":\"blocknumber\",\"title\":\"Block Number\",\"atts\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"heading\":\"\",\"text\":\"Lorem ipsum dolor sit amet consectetuer rutrum dignissim\",\"number\":\"04\",\"size\":\"48\",\"background\":\"#c7c118\",\"color\":\"#ffffff\",\"border_radius\":\"10\",\"alignment\":\"left\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-4\",\"settings\":{},\"attr\":[{\"name\":\"blocknumber\",\"title\":\"Block Number\",\"atts\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"heading\":\"\",\"text\":\"Lorem ipsum dolor sit amet consectetuer rutrum dignissim\",\"number\":\"05\",\"size\":\"48\",\"background\":\"#d9234d\",\"color\":\"#ffffff\",\"border_radius\":\"10\",\"alignment\":\"left\",\"class\":\"\"},\"scontent\":[]}]}]},{\"type\":\"sp_row\",\"layout\":\"444\",\"settings\":{\"title\":\"Center Alignment\",\"subtitle\":\"\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":\"0 40px\",\"margin\":\"100px 0\",\"fullscreen\":0,\"title_fontsize\":28,\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle_fontsize\":\"\",\"heading_selector\":\"h2\",\"title_position\":\"sppb-text-left\"},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-4\",\"settings\":{\"sortableitem\":\"[object Object]\"},\"attr\":[{\"name\":\"blocknumber\",\"title\":\"Block Number\",\"atts\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"heading\":\"\",\"text\":\"Lorem ipsum dolor sit amet consectetuer rutrum dignissim et neque id.\",\"number\":\"03\",\"size\":\"48\",\"background\":\"#a1c63d\",\"color\":\"#ffffff\",\"border_radius\":\"10\",\"alignment\":\"center\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-4\",\"settings\":{},\"attr\":[{\"name\":\"blocknumber\",\"title\":\"Block Number\",\"atts\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"heading\":\"\",\"text\":\"Lorem ipsum dolor sit amet consectetuer rutrum dignissim et neque id.\",\"number\":\"04\",\"size\":\"48\",\"background\":\"#c7c118\",\"color\":\"#ffffff\",\"border_radius\":\"10\",\"alignment\":\"center\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-4\",\"settings\":{},\"attr\":[{\"name\":\"blocknumber\",\"title\":\"Block Number\",\"atts\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"heading\":\"\",\"text\":\"Lorem ipsum dolor sit amet consectetuer rutrum dignissim et neque id.\",\"number\":\"05\",\"size\":\"48\",\"background\":\"#d9234d\",\"color\":\"#ffffff\",\"border_radius\":\"10\",\"alignment\":\"center\",\"class\":\"\"},\"scontent\":[]}]}]},{\"type\":\"sp_row\",\"layout\":\"444\",\"settings\":{\"title_position\":\"sppb-text-right\",\"heading_selector\":\"h2\",\"title\":\"Right Alignment\",\"subtitle\":\"\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":\"0 40px\",\"margin\":\"100px 0\",\"fullscreen\":0,\"title_fontsize\":28,\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle_fontsize\":\"\"},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-4\",\"settings\":{\"sortableitem\":\"[object Object]\"},\"attr\":[{\"name\":\"blocknumber\",\"title\":\"Block Number\",\"atts\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"heading\":\"\",\"text\":\"Lorem ipsum dolor sit amet consectetuer rutrum dignissim\",\"number\":\"03\",\"size\":\"48\",\"background\":\"#55d41a\",\"color\":\"#ffffff\",\"border_radius\":\"\",\"alignment\":\"right\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-4\",\"settings\":{},\"attr\":[{\"name\":\"blocknumber\",\"title\":\"Block Number\",\"atts\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"heading\":\"\",\"text\":\"Lorem ipsum dolor sit amet consectetuer rutrum dignissim\",\"number\":\"04\",\"size\":\"48\",\"background\":\"#21dced\",\"color\":\"#ffffff\",\"border_radius\":\"\",\"alignment\":\"right\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-4\",\"settings\":{},\"attr\":[{\"name\":\"blocknumber\",\"title\":\"Block Number\",\"atts\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"heading\":\"\",\"text\":\"Lorem ipsum dolor sit amet consectetuer rutrum dignissim\",\"number\":\"05\",\"size\":\"48\",\"background\":\"#e6b512\",\"color\":\"#ffffff\",\"border_radius\":\"\",\"alignment\":\"right\",\"class\":\"\"},\"scontent\":[]}]}]}]', 'com_sppagebuilder', 'page', 0, 0, 1, 0, 1, 0, '2015-09-21 09:00:42', 270, '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '', '', '', '*', 0, ''),
(29, 0, 'Blockquote', '[{\"type\":\"sp_row\",\"layout\":\"66\",\"settings\":{\"subtitle_fontsize\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontsize\":\"\",\"fullscreen\":0,\"margin\":\"100px 0\",\"padding\":\"0 20px\",\"class\":\"\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_position\":\"0 0\",\"background_attachment\":\"fixed\",\"background_size\":\"cover\",\"background_repeat\":\"no-repeat\",\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"title_position\":\"sppb-text-center\",\"subtitle\":\"\",\"title\":\"\"},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-6\",\"settings\":{\"sortableitem\":\"[object Object]\",\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"\",\"animationduration\":300,\"animationdelay\":0,\"class\":\"\"},\"attr\":[{\"name\":\"blockquote\",\"title\":\"Blockquote\",\"atts\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante.\",\"footer\":\"John Doe\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-6\",\"settings\":{},\"attr\":[{\"name\":\"blockquote\",\"title\":\"Blockquote\",\"atts\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante.\",\"footer\":\"Shohan Santa\",\"class\":\"\"},\"scontent\":[]}]}]},{\"type\":\"sp_row\",\"layout\":\"444\",\"settings\":{\"fullscreen\":0,\"margin\":\"100px 0\",\"padding\":\"0 20px\",\"class\":\"\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_position\":\"0 0\",\"background_attachment\":\"fixed\",\"background_size\":\"cover\",\"background_repeat\":\"no-repeat\",\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"title_position\":\"sppb-text-center\",\"subtitle\":\"\",\"title\":\"\",\"title_fontsize\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle_fontsize\":\"\"},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-4\",\"settings\":{\"class\":\"\",\"animationdelay\":0,\"animationduration\":300,\"animation\":\"\",\"padding\":\"\",\"color\":\"\",\"background\":\"\",\"sortableitem\":\"[object Object]\"},\"attr\":[{\"name\":\"blockquote\",\"title\":\"Blockquote\",\"atts\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante.\",\"footer\":\"Hamilton koe\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-4\",\"settings\":{\"sortableitem\":\"[object Object]\"},\"attr\":[{\"name\":\"blockquote\",\"title\":\"Blockquote\",\"atts\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante.\",\"footer\":\"John Doe\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-4\",\"settings\":{},\"attr\":[{\"name\":\"blockquote\",\"title\":\"Blockquote\",\"atts\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante.\",\"footer\":\"John Doe\",\"class\":\"\"},\"scontent\":[]}]}]}]', 'com_sppagebuilder', 'page', 0, 0, 1, 0, 1, 0, '2015-09-21 09:01:12', 270, '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '', '', '', '*', 0, ''),
(30, 0, 'Audio', '[{\"type\":\"sp_row\",\"layout\":\"66\",\"disable\":false,\"settings\":{\"title\":\"\",\"subtitle\":\"\",\"title_position\":\"sppb-text-left\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":\"50px 0 0\",\"margin\":0,\"fullscreen\":0,\"heading_selector\":\"h2\",\"title_fontsize\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle_fontsize\":\"\"},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-6 active-column-parent\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"0 30px\",\"animation\":\"\",\"animationduration\":300,\"animationdelay\":0,\"class\":\"\",\"sortableitem\":\"[object Object]\"},\"attr\":[{\"name\":\"text_block\",\"title\":\"Text Block\",\"atts\":{\"title\":\"Audio Player\",\"heading_selector\":\"h3\",\"title_fontsize\":\"28\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"30\",\"text\":\"\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"audio\",\"title\":\"Audio\",\"atts\":{\"title\":\"Audio 1\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"mp3_link\":\"http://demo.themeum.com/html/triangle/1.1/audio/juicy.mp3\",\"ogg_link\":\"\",\"autoplay\":\"autoplay\",\"repeat\":\"loop\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"atts\":{\"gap\":\"70\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-6\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"0 30px\",\"animation\":\"\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\"\"},\"attr\":[{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"atts\":{\"gap\":\"70\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"audio\",\"title\":\"Audio\",\"atts\":{\"title\":\"Audio 2\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"mp3_link\":\"http://demo.themeum.com/html/triangle/1.1/audio/juicy.mp3\",\"ogg_link\":\"\",\"autoplay\":\"\",\"repeat\":\"loop\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"atts\":{\"gap\":\"70\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"scontent\":[]}]}]},{\"type\":\"sp_row\",\"layout\":\"66\",\"disable\":false,\"settings\":{\"title\":\"\",\"heading_selector\":\"h2\",\"title_fontsize\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-left\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":\"50px 0 0\",\"margin\":0,\"fullscreen\":0},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-6 active-column-parent\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"0 30px\",\"animation\":\"\",\"animationduration\":300,\"animationdelay\":0,\"class\":\"\",\"sortableitem\":\"[object Object]\"},\"attr\":[{\"name\":\"text_block\",\"title\":\"Text Block\",\"atts\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"28\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"30\",\"text\":\"\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"audio\",\"title\":\"Audio\",\"atts\":{\"title\":\"Audio 3\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"mp3_link\":\"http://demo.themeum.com/html/triangle/1.1/audio/juicy.mp3\",\"ogg_link\":\"\",\"autoplay\":\"autoplay\",\"repeat\":\"loop\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"atts\":{\"gap\":\"70\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-6\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"0 30px\",\"animation\":\"\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\"\"},\"attr\":[{\"name\":\"audio\",\"title\":\"Audio\",\"atts\":{\"title\":\"Audio 4\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"mp3_link\":\"http://demo.themeum.com/html/triangle/1.1/audio/juicy.mp3\",\"ogg_link\":\"\",\"autoplay\":\"\",\"repeat\":\"loop\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"atts\":{\"gap\":\"70\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"scontent\":[]}]}]}]', 'com_sppagebuilder', 'page', 0, 0, 1, 0, 1, 0, '2015-09-21 09:01:43', 270, '2015-09-30 10:42:13', 270, 0, '0000-00-00 00:00:00', '', '', '', '*', 0, '');
INSERT INTO `#__sppagebuilder` (`id`, `asset_id`, `title`, `text`, `extension`, `extension_view`, `view_id`, `active`, `published`, `catid`, `access`, `ordering`, `created_on`, `created_by`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `og_title`, `og_image`, `og_description`, `language`, `hits`, `css`) VALUES
(31, 0, 'Tabs & Tours', '[{\"type\":\"sp_row\",\"layout\":\"66\",\"disable\":false,\"settings\":{\"title\":\"\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"tixon-addons-list\",\"padding\":\"\",\"margin\":\"90px 0\",\"fullscreen\":0},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-6 active-column-parent\",\"settings\":{\"sortableitem\":\"[object Object]\",\"class\":\"\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"fadeIn\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"attr\":[{\"name\":\"tab\",\"title\":\"Tabs\",\"atts\":{\"title\":\"Tabs Style 01\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"50\",\"style\":\"tabs\",\"class\":\"agency-tabs\"},\"scontent\":[{\"type\":\"repeatable\",\"name\":\"sp_tab_item\",\"atts\":{\"title\":\"House </br>Insurance\",\"icon\":\"fa-home\",\"content\":\"<h2>House insurance</h2>\\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident,</p>\\n<a class=\\\"btn btn-primary\\\" href=\\\"#\\\">Get quote</a>\"}},{\"type\":\"repeatable\",\"name\":\"sp_tab_item\",\"atts\":{\"title\":\"Health  </br>Insurance\",\"icon\":\"fa-life-bouy\",\"content\":\"<h2>House insurance</h2>\\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident,</p>\\n<a class=\\\"btn btn-primary\\\" href=\\\"#\\\">Get quote</a>\"}},{\"type\":\"repeatable\",\"name\":\"sp_tab_item\",\"atts\":{\"title\":\"Life  </br>Insurance\",\"icon\":\"fa-heart-o\",\"content\":\"<h2>Life Insurance</h2>\\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident,</p>\\n<a class=\\\"btn btn-primary\\\" href=\\\"#\\\">Get quote</a>\"}}]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-6\",\"settings\":{\"class\":\"\",\"animationdelay\":400,\"animationduration\":\"\",\"animation\":\"fadeIn\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"attr\":[{\"name\":\"tab\",\"title\":\"Tabs\",\"atts\":{\"title\":\"Tabs Style 02\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"50\",\"style\":\"tabs\",\"class\":\"agency-tabs-two agency-tabs\"},\"scontent\":[{\"type\":\"repeatable\",\"name\":\"sp_tab_item\",\"atts\":{\"title\":\"Life Insurance\",\"icon\":\"\",\"content\":\"<h2>Life insurance</h2>\\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident,</p>\\n<a class=\\\"btn btn-primary\\\" href=\\\"#\\\">Get quote</a>\"}},{\"type\":\"repeatable\",\"name\":\"sp_tab_item\",\"atts\":{\"title\":\"Health  Insurance\",\"icon\":\"\",\"content\":\"<h2>House insurance</h2>\\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident,</p>\\n<a class=\\\"btn btn-primary\\\" href=\\\"#\\\">Get quote</a>\"}},{\"type\":\"repeatable\",\"name\":\"sp_tab_item\",\"atts\":{\"title\":\"Life Insurance\",\"icon\":\"\",\"content\":\"<h2>Life Insurance</h2>\\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident,</p>\\n<a class=\\\"btn btn-primary\\\" href=\\\"#\\\">Get quote</a>\"}}]}]}]},{\"type\":\"sp_row\",\"layout\":\"66\",\"disable\":false,\"settings\":{\"fullscreen\":0,\"margin\":\"90px 0\",\"padding\":\"\",\"class\":\"lawyer-accordion tixon-addons-list\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontweight\":\"\",\"title_fontsize\":\"\",\"title\":\"\"},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-6\",\"settings\":{\"sortableitem\":\"[object Object]\",\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInLeft\",\"animationduration\":\"\",\"animationdelay\":200,\"class\":\"\"},\"attr\":[{\"name\":\"tab\",\"title\":\"Tabs\",\"atts\":{\"title\":\"Tabs Style 03\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"600\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"50\",\"style\":\"tabs\",\"class\":\"\"},\"scontent\":[{\"type\":\"repeatable\",\"name\":\"sp_tab_item\",\"atts\":{\"title\":\"Consulting\",\"icon\":\"\",\"content\":\"<div>\\n<p class=\\\"icon linea-icon-basic-compass\\\"> </p>\\nAnim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod.</div>\\n<div>\\n<p class=\\\"icon linea-icon-basic-flag2\\\"> </p>\\nBrunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.</div>\"}},{\"type\":\"repeatable\",\"name\":\"sp_tab_item\",\"atts\":{\"title\":\"Criminal Law\",\"icon\":\"\",\"content\":\"<div>\\n<p class=\\\"icon linea-icon-basic-compass\\\"> </p>\\nAnim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod.</div>\\n<div>\\n<p class=\\\"icon linea-icon-basic-flag2\\\"> </p>\\nBrunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.</div>\"}},{\"type\":\"repeatable\",\"name\":\"sp_tab_item\",\"atts\":{\"title\":\"Civil Law\",\"icon\":\"\",\"content\":\"<div>\\n<p class=\\\"icon linea-icon-basic-compass\\\"> </p>\\nAnim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod.</div>\\n<div>\\n<p class=\\\"icon linea-icon-basic-flag2\\\"> </p>\\nBrunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.</div>\"}},{\"type\":\"repeatable\",\"name\":\"sp_tab_item\",\"atts\":{\"title\":\"Family Law\",\"icon\":\"\",\"content\":\"<div>\\n<p class=\\\"icon linea-icon-basic-compass\\\"> </p>\\nAnim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod.</div>\\n<div>\\n<p class=\\\"icon linea-icon-basic-flag2\\\"> </p>\\nBrunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.</div>\"}}]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-6\",\"settings\":{\"class\":\"\",\"animationdelay\":400,\"animationduration\":\"\",\"animation\":\"fadeInRight\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"attr\":[{\"name\":\"tab\",\"title\":\"Tabs\",\"atts\":{\"title\":\"Tabs Style 04\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"600\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"50\",\"style\":\"tabs\",\"class\":\"\"},\"scontent\":[{\"type\":\"repeatable\",\"name\":\"sp_tab_item\",\"atts\":{\"title\":\"Consulting\",\"icon\":\"fa-home\",\"content\":\"<div>\\n<p class=\\\"icon linea-icon-basic-compass\\\"> </p>\\nAnim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod.</div>\\n<div>\\n<p class=\\\"icon linea-icon-basic-flag2\\\"> </p>\\nBrunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.</div>\"}},{\"type\":\"repeatable\",\"name\":\"sp_tab_item\",\"atts\":{\"title\":\"Criminal Law\",\"icon\":\"fa-life-bouy\",\"content\":\"<div>\\n<p class=\\\"icon linea-icon-basic-compass\\\"> </p>\\nAnim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod.</div>\\n<div>\\n<p class=\\\"icon linea-icon-basic-flag2\\\"> </p>\\nBrunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.</div>\"}},{\"type\":\"repeatable\",\"name\":\"sp_tab_item\",\"atts\":{\"title\":\"Civil Law\",\"icon\":\"fa-heart-o\",\"content\":\"<div>\\n<p class=\\\"icon linea-icon-basic-compass\\\"> </p>\\nAnim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod.</div>\\n<div>\\n<p class=\\\"icon linea-icon-basic-flag2\\\"> </p>\\nBrunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.</div>\"}},{\"type\":\"repeatable\",\"name\":\"sp_tab_item\",\"atts\":{\"title\":\"Family Law\",\"icon\":\"fa-female\",\"content\":\"<div>\\n<p class=\\\"icon linea-icon-basic-compass\\\"> </p>\\nAnim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod.</div>\\n<div>\\n<p class=\\\"icon linea-icon-basic-flag2\\\"> </p>\\nBrunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.</div>\"}}]}]}]}]', 'com_sppagebuilder', 'page', 0, 0, 1, 0, 1, 0, '2015-09-21 09:02:35', 270, '2015-10-01 06:23:58', 270, 0, '0000-00-00 00:00:00', '', '', '', '*', 0, ''),
(32, 0, 'Flicker Gallery', '[{\"type\":\"sp_row\",\"layout\":\"444\",\"settings\":{\"fullscreen\":0,\"margin\":\"20px 0 0\",\"padding\":\"\",\"class\":\"\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontsize\":\"\",\"title\":\"\"},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-4\",\"settings\":{\"sortableitem\":\"[object Object]\"},\"attr\":[{\"name\":\"flickr\",\"title\":\"Flickr Gallery\",\"atts\":{\"title\":\"Flickr Gallery\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"20\",\"id\":\"\",\"count\":\"8\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-4\",\"settings\":{},\"attr\":[{\"name\":\"flickr\",\"title\":\"Flickr Gallery\",\"atts\":{\"title\":\"Flickr Gallery\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"20\",\"id\":\"\",\"count\":\"8\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-4\",\"settings\":{},\"attr\":[{\"name\":\"flickr\",\"title\":\"Flickr Gallery\",\"atts\":{\"title\":\"Flickr Gallery\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"20\",\"id\":\"\",\"count\":\"8\",\"class\":\"\"},\"scontent\":[]}]}]},{\"type\":\"sp_row\",\"layout\":\"66\",\"settings\":{\"fullscreen\":0,\"margin\":\"50px 0\",\"padding\":\"\",\"class\":\"\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontsize\":\"\",\"title\":\"\"},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-6\",\"settings\":{\"sortableitem\":\"[object Object]\"},\"attr\":[{\"name\":\"flickr\",\"title\":\"Flickr Gallery\",\"atts\":{\"title\":\"Flickr Gallery\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"20\",\"id\":\"\",\"count\":\"12\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-6\",\"settings\":{\"sortableitem\":\"[object Object]\"},\"attr\":[{\"name\":\"flickr\",\"title\":\"Flickr Gallery\",\"atts\":{\"title\":\"Flickr Gallery\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"20\",\"id\":\"\",\"count\":\"12\",\"class\":\"\"},\"scontent\":[]}]}]}]', 'com_sppagebuilder', 'page', 0, 0, 1, 0, 1, 0, '2015-09-21 09:03:22', 270, '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '', '', '', '*', 0, ''),
(33, 0, 'Carosuel', '[{\"type\":\"sp_row\",\"layout\":12,\"disable\":false,\"settings\":{\"title_fontweight\":\"\",\"fullscreen\":1,\"margin\":\"0 0 100px\",\"padding\":\"\",\"class\":\"\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontsize\":\"\",\"title\":\"\"},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-12\",\"settings\":{\"sortableitem\":\"[object Object]\"},\"attr\":[{\"name\":\"carousel\",\"title\":\"Carousel\",\"atts\":{\"autoplay\":\"1\",\"controllers\":\"1\",\"arrows\":\"1\",\"background\":\"\",\"color\":\"#ffffff\",\"alignment\":\"sppb-text-left\",\"class\":\" btn-text-white\"},\"scontent\":[{\"type\":\"repeatable\",\"name\":\"sp_carousel_item\",\"atts\":{\"title\":\"SP Page Builder For Joomla 3.3 +\",\"content\":\"Anim pariatur cliche reprehenderit &nbsp;enim eiusmod high life accusamus <br />terry richardson ad squid reprehenderit &nbsp;enim eiusm<br /><br />\",\"bg\":\"images/demo/slider/lawyear/slider2.jpg\",\"button_text\":\"Download\",\"button_url\":\"http://www.joomshaper.com/page-builder\",\"button_size\":\"\",\"button_type\":\"success\",\"button_icon\":\"\"}},{\"type\":\"repeatable\",\"name\":\"sp_carousel_item\",\"atts\":{\"title\":\"Let\'s Build Your Website \",\"content\":\"Anim pariatur cliche reprehenderit &nbsp;enim eiusmod high life accusamus <br />terry richardson ad squid reprehenderit &nbsp;enim eiusm<br /><br />\",\"bg\":\"images/demo/slider/lawyear/slider3.jpg\",\"button_text\":\"Download\",\"button_url\":\"http://www.joomshaper.com/page-builder\",\"button_size\":\"\",\"button_type\":\"success\",\"button_icon\":\"\"}}]}]}]},{\"type\":\"sp_row\",\"layout\":12,\"disable\":false,\"settings\":{\"title\":\"Carosuel With Background\",\"heading_selector\":\"h2\",\"title_fontsize\":30,\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":0,\"margin\":\"0 0 100px\",\"fullscreen\":1,\"title_fontweight\":\"\"},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-12\",\"settings\":{\"sortableitem\":\"[object Object]\"},\"attr\":[{\"name\":\"carousel\",\"title\":\"Carousel\",\"atts\":{\"autoplay\":\"1\",\"controllers\":\"1\",\"arrows\":\"1\",\"background\":\"#f0f0f0\",\"color\":\"\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"scontent\":[{\"type\":\"repeatable\",\"name\":\"sp_carousel_item\",\"atts\":{\"title\":\"SP Page Builder For Joomla 3.3 +\",\"content\":\"Anim pariatur cliche reprehenderit  enim eiusmod high life accusamus <br/>terry richardson ad squid reprehenderit  enim eiusm<br/><br/>\",\"bg\":\"\",\"button_text\":\"Download\",\"button_url\":\"http://www.joomshaper.com/page-builder\",\"button_size\":\"\",\"button_type\":\"success\",\"button_icon\":\"\"}},{\"type\":\"repeatable\",\"name\":\"sp_carousel_item\",\"atts\":{\"title\":\"Let\'s Build Your Website \",\"content\":\"Anim pariatur cliche reprehenderit  enim eiusmod high life accusamus <br/>terry richardson ad squid reprehenderit  enim eiusm<br/><br/>\",\"bg\":\"\",\"button_text\":\"Download\",\"button_url\":\"http://www.joomshaper.com/page-builder\",\"button_size\":\"\",\"button_type\":\"success\",\"button_icon\":\"\"}}]}]}]}]', 'com_sppagebuilder', 'page', 0, 0, 1, 0, 1, 0, '2015-09-21 09:04:04', 270, '2015-10-01 11:37:40', 270, 0, '0000-00-00 00:00:00', '', '', '', '*', 0, ''),
(34, 0, 'Carosuel Pro', '[{\"type\":\"sp_row\",\"layout\":12,\"disable\":false,\"settings\":{\"background_repeat\":\"no-repeat\",\"title_position\":\"sppb-text-center\",\"heading_selector\":\"h2\",\"title\":\"\",\"title_fontsize\":30,\"title_text_color\":\"#ffffff\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":0,\"margin\":\"0 0 100px\",\"fullscreen\":1,\"title_fontweight\":\"\"},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-12\",\"settings\":{\"sortableitem\":\"[object Object]\"},\"attr\":[{\"name\":\"carouselpro\",\"title\":\"Carousel Pro\",\"atts\":{\"autoplay\":\"1\",\"controllers\":\"1\",\"arrows\":\"1\",\"background\":\"\",\"color\":\"#ffffff\",\"class\":\"\"},\"scontent\":[{\"type\":\"repeatable\",\"name\":\"sp_carouselpro_item\",\"atts\":{\"title\":\"We are Best Agency\",\"content\":\"Anim pariatur cliche reprehenderit enim eiusmod <br />high life accusamus terry richards squid\",\"bg\":\"images/demo/slider/slider-3.jpg\",\"image\":\"images/sppagebuilder/agancy-slide1.png\",\"video\":\"\",\"button_text\":\"\",\"button_url\":\"\",\"button_size\":\"\",\"button_type\":\"default\",\"button_icon\":\"\"}},{\"type\":\"repeatable\",\"name\":\"sp_carouselpro_item\",\"atts\":{\"title\":\"SP Page Builder\",\"content\":\"Anim pariatur cliche reprehenderit enim eiusmod <br />high life accusamus terry richards squid\",\"bg\":\"images/demo/slider/slider1.jpg\",\"image\":\"images/sppagebuilder/agancy-slide1.png\",\"video\":\"\",\"button_text\":\"\",\"button_url\":\"\",\"button_size\":\"\",\"button_type\":\"default\",\"button_icon\":\"\"}}]}]}]},{\"type\":\"sp_row\",\"layout\":12,\"disable\":false,\"settings\":{\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"heading_selector\":\"h2\",\"title\":\"Carosuel Without Background\",\"title_fontsize\":30,\"title_text_color\":\"\",\"title_margin_top\":0,\"title_margin_bottom\":0,\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":0,\"margin\":\"0 0 50px\",\"fullscreen\":1},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-12\",\"settings\":{\"sortableitem\":\"[object Object]\"},\"attr\":[{\"name\":\"carouselpro\",\"title\":\"Carousel Pro\",\"atts\":{\"autoplay\":\"1\",\"controllers\":\"1\",\"arrows\":\"1\",\"background\":\"\",\"color\":\"\",\"class\":\"\"},\"scontent\":[{\"type\":\"repeatable\",\"name\":\"sp_carouselpro_item\",\"atts\":{\"title\":\"SP Page Builder\",\"content\":\"Eiusmod high life accusamus terry richardson<br/>Anim pariatur cliche reprehenderit\",\"bg\":\"\",\"image\":\"images/sppagebuilder/corporate1-slide1.png\",\"video\":\"\",\"button_text\":\"\",\"button_url\":\"\",\"button_size\":\"\",\"button_type\":\"default\",\"button_icon\":\"\"}},{\"type\":\"repeatable\",\"name\":\"sp_carouselpro_item\",\"atts\":{\"title\":\"Build Your Website\",\"content\":\"Eiusmod high life accusamus terry richardson<br/>Anim pariatur cliche reprehenderit\",\"bg\":\"\",\"image\":\"images/sppagebuilder/corporate1-slide2.png\",\"video\":\"\",\"button_text\":\"\",\"button_url\":\"\",\"button_size\":\"\",\"button_type\":\"default\",\"button_icon\":\"\"}}]}]}]}]', 'com_sppagebuilder', 'page', 0, 0, 1, 0, 1, 0, '2015-09-21 09:04:39', 270, '2015-10-01 07:24:23', 270, 0, '0000-00-00 00:00:00', '', '', '', '*', 0, ''),
(35, 0, 'Pricing', '[{\"type\":\"sp_row\",\"layout\":\"444\",\"disable\":false,\"settings\":{\"title\":\"Pricing Plan 01\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"pricing-style1\",\"padding\":\"\",\"margin\":\"90px 0\",\"fullscreen\":0},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-4\",\"settings\":{\"class\":\"\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"fadeInLeft\",\"padding\":\"\",\"color\":\"\",\"background\":\"\",\"sortableitem\":\"[object Object]\"},\"attr\":[{\"name\":\"pricing\",\"title\":\"Pricing Table\",\"atts\":{\"title\":\"Basic\",\"price\":\"<small>$</small>29\",\"duration\":\"\",\"pricing_content\":\"Lorem ipsum dolor sit amet, \\nconsectetur adipisicing\\nincididunt ut labore et dolore magna\\nUt enim ad minim veniam\\nquis nostrud\",\"button_text\":\"Buy Now\",\"button_url\":\"#\",\"button_size\":\"\",\"button_type\":\"default\",\"button_icon\":\"\",\"button_block\":\"\",\"background\":\"\",\"color\":\"\",\"featured\":\"\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-4\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInLeft\",\"animationduration\":\"\",\"animationdelay\":200,\"class\":\"\"},\"attr\":[{\"name\":\"pricing\",\"title\":\"Pricing Table\",\"atts\":{\"title\":\"Standard\",\"price\":\"<small>$</small>29\",\"duration\":\"\",\"pricing_content\":\"Lorem ipsum dolor sit amet, \\nconsectetur adipisicing\\nincididunt ut labore et dolore magna\\nUt enim ad minim veniam\\nquis nostrud\",\"button_text\":\"Buy Now\",\"button_url\":\"#\",\"button_size\":\"\",\"button_type\":\"success\",\"button_icon\":\"\",\"button_block\":\"\",\"background\":\"\",\"color\":\"\",\"featured\":\"sppb-pricing-featured\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-4\",\"settings\":{\"class\":\"\",\"animationdelay\":400,\"animationduration\":\"\",\"animation\":\"fadeInLeft\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"attr\":[{\"name\":\"pricing\",\"title\":\"Pricing Table\",\"atts\":{\"title\":\"Professional\",\"price\":\"<small>$</small>29\",\"duration\":\"\",\"pricing_content\":\"Lorem ipsum dolor sit amet, \\nconsectetur adipisicing\\nincididunt ut labore et dolore magna\\nUt enim ad minim veniam\\nquis nostrud\",\"button_text\":\"Buy Now\",\"button_url\":\"#\",\"button_size\":\"\",\"button_type\":\"default\",\"button_icon\":\"\",\"button_block\":\"\",\"background\":\"\",\"color\":\"\",\"featured\":\"\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"scontent\":[]}]}]},{\"type\":\"sp_row\",\"layout\":\"444\",\"disable\":false,\"settings\":{\"fullscreen\":0,\"margin\":\"90px 0\",\"padding\":\"50px 0 0 0 \",\"class\":\"pricing-style2\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_position\":\"0 0\",\"background_attachment\":\"fixed\",\"background_size\":\"cover\",\"background_repeat\":\"no-repeat\",\"background_image\":\"\",\"color\":\"\",\"background_color\":\"#f7f9fc\",\"title_position\":\"sppb-text-center\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontweight\":\"\",\"title_fontsize\":\"\",\"heading_selector\":\"h3\",\"title\":\"Pricing Plan 02\"},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-4\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInRight\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\"\",\"sortableitem\":\"[object Object]\"},\"attr\":[{\"name\":\"pricing\",\"title\":\"Pricing Table\",\"atts\":{\"title\":\"Basic\",\"price\":\"<small>$</small>29\",\"duration\":\"\",\"pricing_content\":\"Lorem ipsum dolor sit amet, \\nconsectetur adipisicing\\nincididunt ut labore et dolore magna\\nUt enim ad minim veniam\\nquis nostrud\",\"button_text\":\"Buy Now\",\"button_url\":\"#\",\"button_size\":\"\",\"button_type\":\"default\",\"button_icon\":\"\",\"button_block\":\"\",\"background\":\"\",\"color\":\"\",\"featured\":\"\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-4\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInRight\",\"animationduration\":\"\",\"animationdelay\":200,\"class\":\"\"},\"attr\":[{\"name\":\"pricing\",\"title\":\"Pricing Table\",\"atts\":{\"title\":\"Standard\",\"price\":\"<small>$</small>29\",\"duration\":\"\",\"pricing_content\":\"Lorem ipsum dolor sit amet, \\nconsectetur adipisicing\\nincididunt ut labore et dolore magna\\nUt enim ad minim veniam\\nquis nostrud\",\"button_text\":\"Buy Now\",\"button_url\":\"#\",\"button_size\":\"\",\"button_type\":\"default\",\"button_icon\":\"\",\"button_block\":\"\",\"background\":\"#0072bc\",\"color\":\"\",\"featured\":\"sppb-pricing-featured\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-4\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInRight\",\"animationduration\":\"\",\"animationdelay\":400,\"class\":\"\"},\"attr\":[{\"name\":\"pricing\",\"title\":\"Pricing Table\",\"atts\":{\"title\":\"Professional\",\"price\":\"<small>$</small>29\",\"duration\":\"\",\"pricing_content\":\"Lorem ipsum dolor sit amet, \\nconsectetur adipisicing\\nincididunt ut labore et dolore magna\\nUt enim ad minim veniam\\nquis nostrud\",\"button_text\":\"Buy Now\",\"button_url\":\"#\",\"button_size\":\"\",\"button_type\":\"default\",\"button_icon\":\"\",\"button_block\":\"\",\"background\":\"\",\"color\":\"\",\"featured\":\"\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"scontent\":[]}]}]},{\"type\":\"sp_row\",\"layout\":\"444\",\"disable\":false,\"settings\":{\"title\":\"Pricing Plan 03\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"pricing-style3\",\"padding\":\"\",\"margin\":\"90px 0\",\"fullscreen\":0},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-4\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInDown\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\"\",\"sortableitem\":\"[object Object]\"},\"attr\":[{\"name\":\"pricing\",\"title\":\"Pricing Table\",\"atts\":{\"title\":\"Basic\",\"price\":\"<small>$</small>29\",\"duration\":\"\",\"pricing_content\":\"Lorem ipsum dolor sit amet, \\nconsectetur adipisicing\\nincididunt ut labore et dolore magna\\nUt enim ad minim veniam\\nquis nostrud\",\"button_text\":\"Buy Now\",\"button_url\":\"#\",\"button_size\":\"\",\"button_type\":\"default\",\"button_icon\":\"\",\"button_block\":\"\",\"background\":\"\",\"color\":\"\",\"featured\":\"\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-4\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInDown\",\"animationduration\":\"\",\"animationdelay\":200,\"class\":\"\"},\"attr\":[{\"name\":\"pricing\",\"title\":\"Pricing Table\",\"atts\":{\"title\":\"Basic\",\"price\":\"<small>$</small>29\",\"duration\":\"\",\"pricing_content\":\"Lorem ipsum dolor sit amet, \\nconsectetur adipisicing\\nincididunt ut labore et dolore magna\\nUt enim ad minim veniam\\nquis nostrud\",\"button_text\":\"Buy Now\",\"button_url\":\"#\",\"button_size\":\"\",\"button_type\":\"default\",\"button_icon\":\"\",\"button_block\":\"\",\"background\":\"\",\"color\":\"\",\"featured\":\"sppb-pricing-featured\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-4 active-column-parent\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInDown\",\"animationduration\":\"\",\"animationdelay\":400,\"class\":\"\"},\"attr\":[{\"name\":\"pricing\",\"title\":\"Pricing Table\",\"atts\":{\"title\":\"Professional\",\"price\":\"<small>$</small>29\",\"duration\":\"\",\"pricing_content\":\"Lorem ipsum dolor sit amet, \\nconsectetur adipisicing\\nincididunt ut labore et dolore magna\\nUt enim ad minim veniam\\nquis nostrud\",\"button_text\":\"Buy Now\",\"button_url\":\"#\",\"button_size\":\"\",\"button_type\":\"default\",\"button_icon\":\"\",\"button_block\":\"\",\"background\":\"\",\"color\":\"\",\"featured\":\"\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"scontent\":[]}]}]}]', 'com_sppagebuilder', 'page', 0, 0, 1, 0, 1, 0, '2015-09-21 09:22:39', 270, '2015-09-30 12:32:10', 270, 0, '0000-00-00 00:00:00', '', '', '', '*', 0, ''),
(36, 0, 'Joomla Module', '[{\"type\":\"sp_row\",\"layout\":12,\"disable\":false,\"settings\":{\"fullscreen\":0,\"margin\":\"70px 0\",\"padding\":\"\",\"class\":\"\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":70,\"title_text_color\":\"\",\"title_fontweight\":\"\",\"title_fontsize\":\"\",\"title\":\"\"},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-12\",\"settings\":{},\"attr\":[{\"name\":\"module\",\"title\":\"Joomla Module\",\"atts\":{\"title\":\"Portfolio Module\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"600\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"30\",\"id\":\"107\",\"class\":\"\"},\"scontent\":[]}]}]}]', 'com_sppagebuilder', 'page', 0, 0, 1, 0, 1, 0, '2015-09-22 06:07:45', 270, '2015-09-30 11:00:28', 270, 0, '0000-00-00 00:00:00', '', '', '', '*', 0, ''),
(37, 0, 'Contact From', '[{\"type\":\"sp_row\",\"layout\":\"66\",\"disable\":false,\"settings\":{\"fullscreen\":0,\"margin\":\"\",\"padding\":\"90px 0 0\",\"class\":\"tixon-addons-list tixon-contact-from\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_position\":\"0 0\",\"background_attachment\":\"fixed\",\"background_size\":\"cover\",\"background_repeat\":\"no-repeat\",\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"title_position\":\"sppb-text-center\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontweight\":\"\",\"title_fontsize\":\"\",\"heading_selector\":\"h3\",\"title\":\"\"},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-6\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"\",\"animationduration\":300,\"animationdelay\":0,\"class\":\"\",\"sortableitem\":\"[object Object]\"},\"attr\":[{\"name\":\"ajax_contact\",\"title\":\"Contact Form\",\"atts\":{\"title\":\"Contact From With Captcha\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"600\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"30\",\"recipient_email\":\"email@yourdomain.com\",\"formcaptcha\":\"1\",\"captcha_question\":\"3 + 4 = ?\",\"captcha_answer\":\"7\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-6\",\"settings\":{},\"attr\":[{\"name\":\"ajax_contact\",\"title\":\"Contact Form\",\"atts\":{\"title\":\"Contact From Without Captcha\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"600\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"30\",\"recipient_email\":\"email@yourdomain.com\",\"formcaptcha\":\"0\",\"captcha_question\":\"3 + 4 = ?\",\"captcha_answer\":\"7\",\"class\":\"sppb-form-without-captcha\"},\"scontent\":[]}]}]},{\"type\":\"sp_row\",\"layout\":\"66\",\"disable\":false,\"settings\":{\"fullscreen\":0,\"margin\":\"\",\"padding\":\"90px 0\",\"class\":\"tixon-addons-list tixon-contact-from\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_position\":\"0 0\",\"background_attachment\":\"fixed\",\"background_size\":\"cover\",\"background_repeat\":\"no-repeat\",\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"title_position\":\"sppb-text-center\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontweight\":\"\",\"title_fontsize\":\"\",\"heading_selector\":\"h3\",\"title\":\"\"},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-6 active-column-parent\",\"settings\":{\"sortableitem\":\"[object Object]\",\"class\":\" sppb-form-fullwidth\",\"animationdelay\":0,\"animationduration\":300,\"animation\":\"\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"attr\":[{\"name\":\"ajax_contact\",\"title\":\"Contact Form\",\"atts\":{\"title\":\"Contact From Full width With Captcha\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"600\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"30\",\"recipient_email\":\"email@yourdomain.com\",\"formcaptcha\":\"1\",\"captcha_question\":\"3 + 4 = ?\",\"captcha_answer\":\"7\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-6\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\" sppb-form-fullwidth\"},\"attr\":[{\"name\":\"ajax_contact\",\"title\":\"Contact Form\",\"atts\":{\"title\":\"Contact From Full width Without Captcha\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"600\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"30\",\"recipient_email\":\"email@yourdomain.com\",\"formcaptcha\":\"0\",\"captcha_question\":\"3 + 4 = ?\",\"captcha_answer\":\"7\",\"class\":\"\"},\"scontent\":[]}]}]}]', 'com_sppagebuilder', 'page', 0, 0, 1, 0, 1, 0, '2015-09-22 06:21:03', 270, '2015-10-01 12:57:17', 270, 0, '0000-00-00 00:00:00', '', '', '', '*', 0, ''),
(38, 0, 'Button Group', '[{\"type\":\"sp_row\",\"layout\":12,\"disable\":false,\"settings\":{\"fullscreen\":0,\"margin\":\"\",\"padding\":\"90px 0\",\"class\":\"\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_position\":\"0 0\",\"background_attachment\":\"fixed\",\"background_size\":\"cover\",\"background_repeat\":\"no-repeat\",\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"title_position\":\"sppb-text-center\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontweight\":\"\",\"title_fontsize\":\"\",\"heading_selector\":\"h3\",\"title\":\"\"},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-12\",\"settings\":{\"class\":\"\",\"animationdelay\":0,\"animationduration\":300,\"animation\":\"\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"attr\":[{\"name\":\"button_group\",\"title\":\"Button Group\",\"atts\":{\"margin\":\"5\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"scontent\":[{\"type\":\"repeatable\",\"name\":\"sp_button_group_item\",\"atts\":{\"title\":\"Button 1\",\"url\":\"http://\",\"size\":\"\",\"type\":\"default\",\"icon\":\"\",\"target\":\"\",\"class\":\"\"}},{\"type\":\"repeatable\",\"name\":\"sp_button_group_item\",\"atts\":{\"title\":\"Button 2\",\"url\":\"http://\",\"size\":\"\",\"type\":\"primary\",\"icon\":\"\",\"target\":\"\",\"class\":\"\"}},{\"type\":\"repeatable\",\"name\":\"sp_button_group_item\",\"atts\":{\"title\":\"Button 3\",\"url\":\"http://\",\"size\":\"\",\"type\":\"success\",\"icon\":\"\",\"target\":\"\",\"class\":\"\"}},{\"type\":\"repeatable\",\"name\":\"sp_button_group_item\",\"atts\":{\"title\":\"Button 4\",\"url\":\"http://\",\"size\":\"\",\"type\":\"info\",\"icon\":\"\",\"target\":\"\",\"class\":\"\"}},{\"type\":\"repeatable\",\"name\":\"sp_button_group_item\",\"atts\":{\"title\":\"Button 5\",\"url\":\"http://\",\"size\":\"\",\"type\":\"warning\",\"icon\":\"\",\"target\":\"\",\"class\":\"\"}},{\"type\":\"repeatable\",\"name\":\"sp_button_group_item\",\"atts\":{\"title\":\"Button 6\",\"url\":\"http://\",\"size\":\"\",\"type\":\"danger\",\"icon\":\"\",\"target\":\"\",\"class\":\"\"}},{\"type\":\"repeatable\",\"name\":\"sp_button_group_item\",\"atts\":{\"title\":\"Button 7\",\"url\":\"http://\",\"size\":\"\",\"type\":\"link\",\"icon\":\"\",\"target\":\"\",\"class\":\"\"}}]},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"atts\":{\"gap\":\"30\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"button_group\",\"title\":\"Button Group\",\"atts\":{\"margin\":\"5\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"scontent\":[{\"type\":\"repeatable\",\"name\":\"sp_button_group_item\",\"atts\":{\"title\":\"Button 1\",\"url\":\"http://\",\"size\":\"lg\",\"type\":\"default\",\"icon\":\"\",\"target\":\"\",\"class\":\"\"}},{\"type\":\"repeatable\",\"name\":\"sp_button_group_item\",\"atts\":{\"title\":\"Button 2\",\"url\":\"http://\",\"size\":\"lg\",\"type\":\"primary\",\"icon\":\"\",\"target\":\"\",\"class\":\"\"}},{\"type\":\"repeatable\",\"name\":\"sp_button_group_item\",\"atts\":{\"title\":\"Button 3\",\"url\":\"http://\",\"size\":\"lg\",\"type\":\"success\",\"icon\":\"\",\"target\":\"\",\"class\":\"\"}},{\"type\":\"repeatable\",\"name\":\"sp_button_group_item\",\"atts\":{\"title\":\"Button 4\",\"url\":\"http://\",\"size\":\"lg\",\"type\":\"info\",\"icon\":\"\",\"target\":\"\",\"class\":\"\"}},{\"type\":\"repeatable\",\"name\":\"sp_button_group_item\",\"atts\":{\"title\":\"Button 5\",\"url\":\"http://\",\"size\":\"lg\",\"type\":\"warning\",\"icon\":\"\",\"target\":\"\",\"class\":\"\"}},{\"type\":\"repeatable\",\"name\":\"sp_button_group_item\",\"atts\":{\"title\":\"Button 6\",\"url\":\"http://\",\"size\":\"lg\",\"type\":\"danger\",\"icon\":\"\",\"target\":\"\",\"class\":\"\"}},{\"type\":\"repeatable\",\"name\":\"sp_button_group_item\",\"atts\":{\"title\":\"Button 7\",\"url\":\"http://\",\"size\":\"lg\",\"type\":\"link\",\"icon\":\"\",\"target\":\"\",\"class\":\"\"}}]},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"atts\":{\"gap\":\"30\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"button_group\",\"title\":\"Button Group\",\"atts\":{\"margin\":\"5\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"scontent\":[{\"type\":\"repeatable\",\"name\":\"sp_button_group_item\",\"atts\":{\"title\":\"Button 1\",\"url\":\"http://\",\"size\":\"sm\",\"type\":\"default\",\"icon\":\"\",\"target\":\"\",\"class\":\"\"}},{\"type\":\"repeatable\",\"name\":\"sp_button_group_item\",\"atts\":{\"title\":\"Button 2\",\"url\":\"http://\",\"size\":\"sm\",\"type\":\"primary\",\"icon\":\"\",\"target\":\"\",\"class\":\"\"}},{\"type\":\"repeatable\",\"name\":\"sp_button_group_item\",\"atts\":{\"title\":\"Button 3\",\"url\":\"http://\",\"size\":\"sm\",\"type\":\"success\",\"icon\":\"\",\"target\":\"\",\"class\":\"\"}},{\"type\":\"repeatable\",\"name\":\"sp_button_group_item\",\"atts\":{\"title\":\"Button 4\",\"url\":\"http://\",\"size\":\"sm\",\"type\":\"info\",\"icon\":\"\",\"target\":\"\",\"class\":\"\"}},{\"type\":\"repeatable\",\"name\":\"sp_button_group_item\",\"atts\":{\"title\":\"Button 5\",\"url\":\"http://\",\"size\":\"sm\",\"type\":\"warning\",\"icon\":\"\",\"target\":\"\",\"class\":\"\"}},{\"type\":\"repeatable\",\"name\":\"sp_button_group_item\",\"atts\":{\"title\":\"Button 6\",\"url\":\"http://\",\"size\":\"sm\",\"type\":\"danger\",\"icon\":\"\",\"target\":\"\",\"class\":\"\"}},{\"type\":\"repeatable\",\"name\":\"sp_button_group_item\",\"atts\":{\"title\":\"Button 7\",\"url\":\"http://\",\"size\":\"sm\",\"type\":\"link\",\"icon\":\"\",\"target\":\"\",\"class\":\"\"}}]}]}]}]', 'com_sppagebuilder', 'page', 0, 0, 1, 0, 1, 0, '2015-09-22 06:26:56', 270, '2015-10-01 12:06:31', 270, 0, '0000-00-00 00:00:00', '', '', '', '*', 0, ''),
(39, 0, 'Clients', '[{\"type\":\"sp_row\",\"layout\":12,\"disable\":false,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":\"\",\"margin\":\"100px 0\",\"fullscreen\":0},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-12\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"\",\"animationduration\":300,\"animationdelay\":0,\"class\":\"\"},\"attr\":[{\"name\":\"clients\",\"title\":\"Clients\",\"atts\":{\"title\":\"Our Clients\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"60\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"70\",\"count\":\"sppb-col-sm-3\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"scontent\":[{\"type\":\"repeatable\",\"name\":\"sp_clients_item\",\"atts\":{\"title\":\"Client 1\",\"image\":\"images/clients/client1.png\",\"url\":\"http://\"}},{\"type\":\"repeatable\",\"name\":\"sp_clients_item\",\"atts\":{\"title\":\"Client 2\",\"image\":\"images/clients/client2.png\",\"url\":\"http://\"}},{\"type\":\"repeatable\",\"name\":\"sp_clients_item\",\"atts\":{\"title\":\"Client 3\",\"image\":\"images/clients/client3.png\",\"url\":\"http://\"}},{\"type\":\"repeatable\",\"name\":\"sp_clients_item\",\"atts\":{\"title\":\"Client 4\",\"image\":\"images/clients/client4.png\",\"url\":\"http://\"}}]}]}]}]', 'com_sppagebuilder', 'page', 0, 0, 1, 0, 1, 0, '2015-09-22 06:47:45', 270, '2015-10-01 11:22:02', 270, 0, '0000-00-00 00:00:00', '', '', '', '*', 0, ''),
(40, 0, 'Divider', '[{\"type\":\"sp_row\",\"layout\":12,\"settings\":{\"title\":\"Divider\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-left\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":\"90px 0\",\"margin\":\"\",\"fullscreen\":0},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-12\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"\",\"animationduration\":300,\"animationdelay\":0,\"class\":\"\"},\"attr\":[{\"name\":\"divider\",\"title\":\"Divider\",\"atts\":{\"divider_type\":\"border\",\"divider_image\":\"\",\"background_repeat\":\"no-repeat\",\"divider_height\":\"10\",\"border_color\":\"#000000\",\"border_style\":\"solid\",\"border_width\":\"2\",\"margin_top\":\"30\",\"margin_bottom\":\"30\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"atts\":{\"gap\":\"40\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"divider\",\"title\":\"Divider\",\"atts\":{\"divider_type\":\"border\",\"divider_image\":\"\",\"background_repeat\":\"no-repeat\",\"divider_height\":\"10\",\"border_color\":\"#000000\",\"border_style\":\"dashed\",\"border_width\":\"2\",\"margin_top\":\"30\",\"margin_bottom\":\"30\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"atts\":{\"gap\":\"40\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"divider\",\"title\":\"Divider\",\"atts\":{\"divider_type\":\"border\",\"divider_image\":\"\",\"background_repeat\":\"no-repeat\",\"divider_height\":\"10\",\"border_color\":\"#000000\",\"border_style\":\"dotted\",\"border_width\":\"2\",\"margin_top\":\"30\",\"margin_bottom\":\"30\",\"class\":\"\"},\"scontent\":[]}]}]}]', 'com_sppagebuilder', 'page', 0, 0, 1, 0, 1, 0, '2015-09-22 06:55:20', 270, '2015-09-22 07:04:04', 270, 0, '0000-00-00 00:00:00', '', '', '', '*', 0, '');
INSERT INTO `#__sppagebuilder` (`id`, `asset_id`, `title`, `text`, `extension`, `extension_view`, `view_id`, `active`, `published`, `catid`, `access`, `ordering`, `created_on`, `created_by`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `og_title`, `og_image`, `og_description`, `language`, `hits`, `css`) VALUES
(41, 0, 'Dropcap', '[{\"type\":\"sp_row\",\"layout\":12,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":\"90px 0 0 0\",\"margin\":\"\",\"fullscreen\":0},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-12\",\"settings\":{\"class\":\"\",\"animationdelay\":0,\"animationduration\":300,\"animation\":\"\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"attr\":[{\"name\":\"dropcap\",\"title\":\"Drop Cap\",\"atts\":{\"title\":\"Dropcap\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"600\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"40\",\"text\":\"This is a magazine style drop cap. Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.\",\"class\":\"\"},\"scontent\":[]}]}]},{\"type\":\"sp_row\",\"layout\":\"66\",\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"bac