<?php
/**
 * @package SP Page Builder
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2016 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

//no direct accees
defined('_JEXEC') or die('resticted aceess');
require_once JPATH_ROOT . '/components/com_sppagebuilder/helpers/articles.php';

class SppagebuilderAddonLatest_post extends SppagebuilderAddons {
    public function render() {
      $class      = (isset($this->addon->settings->class) && $this->addon->settings->class) ? $this->addon->settings->class : '';
      $title      = (isset($this->addon->settings->title) && $this->addon->settings->title) ? $this->addon->settings->title : '';
      $heading_selector = (isset($this->addon->settings->heading_selector) && $this->addon->settings->heading_selector) ? $this->addon->settings->heading_selector : 'h3';
      $limit      = (isset($this->addon->settings->item_limit) && $this->addon->settings->item_limit) ? $this->addon->settings->item_limit : '';
      $ordering   = (isset($this->addon->settings->ordering) && $this->addon->settings->ordering) ? $this->addon->settings->ordering : '';
      $catid      = (isset($this->addon->settings->category) && $this->addon->settings->category) ? $this->addon->settings->category : '';
      $post_type  = (isset($this->addon->settings->post_type) && $this->addon->settings->post_type) ? $this->addon->settings->post_type : '';

      $items = SppagebuilderHelperArticles::getArticles($limit, $ordering, $catid, TRUE, $post_type);

      // Start output
  		$output   = '';
      $output .= '<div class="sppb-addon sppb-addon-latest-posts ' . $class . '">';
      $output .= '<div class="sppb-addon-content">';
      $output .= '<div class="latest-posts clearfix">';

      $output .= '<div class="sppb-row">';

      // Animation Delay
      $delay = 200;

      foreach ($items as $item) {

          $image = '';

          if(isset($item->image_thumbnail) && $item->image_thumbnail) {
              $image = $item->image_thumbnail;
          } elseif (isset($item->image_intro) && !empty($item->image_intro)) {
              $image = $item->image_intro;
          } elseif (isset($item->image_fulltext) && !empty($item->image_fulltext)) {
              $image = $item->image_fulltext;
          }

          $output .= '<div class="latest-post sppb-col-sm-12 sppb-wow fadeInUp" data-sppb-wow-delay="' . $delay . 'ms">';

          $output .= '<div class="sppb-latest-post" style="background-image: url(' . Juri::root() . $image . ');">';
          $output .= '<div class="sppb-row">';
          if ($image) {
              $output .= '<div class="latest-post-inner sppb-col-xs-offset-3 sppb-col-xs-9">';
          } else {
              $output .= '<div class="latest-post-inner sppb-col-sm-12">';
          }
          $output .= '<div class="latest-post-content">';
          $output .= '<p class="date"> ' . JHtml::_('date', $item->created, 'DATE_FORMAT_LC3') . '</p>';
          $output .= '<' . $heading_selector . ' class="entry-title"><a href="' . $item->link . '">' . $item->title . '</a></' . $heading_selector . '>';
          $output .= '<p class="info">';
          $output .= '<span class="author" itemprop="genre" data-toggle="tooltip" title=" ' . JText::_('COM_SPPAGEBUILDER_ADDON_LP_AUTHOR') . ' "><i class="fa fa-user"></i> ' . $item->username . '</span>';
          $output .= '<span class="category" itemprop="itemTags" data-toggle="tooltip" title=" ' . JText::_('COM_SPPAGEBUILDER_ADDON_LP_CATEGORY') . '"><i class="fa fa-folder-open-o"></i> ' . $item->category . '</span>';
          // $output .= '<span class="Tags">'.JText::_('SPBB_TAGS').': <a href="#">adventure</a>, <a href="#">courage</a></span>';
          // $output .= '<span class="Comments">'.JText::_('COMMENTS').' (2)</span>';
          $output .= '</p>';
          $output .= '</div>';
          $output .= '</div>';
          $output .= '</div>';
          $output .= '</div>'; //spbb-row
          $output .= '</div>'; //.sppb-latest-post
          $delay += 100;
      }
      $output .= '</div>'; //.sppb-row

      $output .= '</div>';
      $output .= '</div>';
      $output .= '</div>';

      return $output;
    }
}