<?php
/**
 *
 * Show the product details page
 *
 * @package	VirtueMart
 * @subpackage
 * @author Max Milbers, Eugen Stranz, Max Galt
 * @link http://www.virtuemart.net
 * @copyright Copyright (c) 2004 - 2014 VirtueMart Team. All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
 * VirtueMart is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * @version $Id: default.php 8842 2015-05-04 20:34:47Z Milbo $
 */
// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access');

/* Let's see if we found the product */
if (empty($this->product)) {
	echo vmText::_('COM_VIRTUEMART_PRODUCT_NOT_FOUND');
	echo '<br /><br />  ' . $this->continue_link_html;
	return;
}

echo shopFunctionsF::renderVmSubLayout('askrecomjs',array('product'=>$this->product));



if(vRequest::getInt('print',false)){ ?>
<body onload="javascript:print();">
<?php } ?>

<div class="productdetails-view productdetails">

    <div class="vm-product-wrap row">
		<div class="vm-product-media-img col-sm-5">
			<?php
			echo $this->loadTemplate('images');

			$count_images = count ($this->product->images);
			if ($count_images > 1) {
				echo $this->loadTemplate('images_additional');
			}
			?>
		</div> <!--/.col-sm-5-->

		<div class="vm-product-details-inner col-sm-7">
			<div class="vm-product-title">
				<div class="pull-left">
					<?php // Product Title   ?>
				    <h2><?php echo $this->product->product_name ?></h2>
				    <?php // Product Title END   ?>
				    <?php echo shopFunctionsF::renderVmSubLayout('rating',array('showRating'=>$this->showRating,'product'=>$this->product)); ?>
				</div> 
				<div class="pull-right">
				    <div class="price-right">
				    	<?php echo shopFunctionsF::renderVmSubLayout('prices',array('product'=>$this->product,'currency'=>$this->currency)); ?> 
				   	</div>
				</div>
				<div class="clearfix"></div>
			</div>

		    <?php echo $this->product->event->afterDisplayTitle ?>

			<?php
			if (is_array($this->productDisplayShipments)) {
				echo '<div class="vm-product-shipments">';
			    foreach ($this->productDisplayShipments as $productDisplayShipment) {
					echo '<div class="vm-product-shipment">';
					echo $productDisplayShipment . '<br />';
					echo '</div>';
			    }
				echo '</div>';
			}
			if (is_array($this->productDisplayPayments)) {
			    foreach ($this->productDisplayPayments as $productDisplayPayment) {
					echo $productDisplayPayment . '<br />';
			    }
			}

			//In case you are not happy using everywhere the same price display fromat, just create your own layout
			//in override /html/fields and use as first parameter the name of your file
			echo shopFunctionsF::renderVmSubLayout('prices',array('product'=>$this->product,'currency'=>$this->currency)); ?> 

			<?php

			echo shopFunctionsF::renderVmSubLayout('customfields',array('product'=>$this->product,'position'=>'ontop'));
		    ?>

    		<?php if (!empty($this->product->product_s_desc)) { ?>
		        <div class="product-short-description">
			       <h4> <?php echo JText::_('PRODUCT_SHORT_DESC');?> </h4>
				    <?php
				    /** @todo Test if content plugins modify the product description */
				    echo nl2br($this->product->product_s_desc);
				    ?>
		        </div>
		    <?php } // Product Short Description END ?>

		    <div class="spacer-buy-area">
				<?php
				// TODO in Multi-Vendor not needed at the moment and just would lead to confusion
				/* $link = JRoute::_('index2.php?option=com_virtuemart&view=virtuemart&task=vendorinfo&virtuemart_vendor_id='.$this->product->virtuemart_vendor_id);
				  $text = vmText::_('COM_VIRTUEMART_VENDOR_FORM_INFO_LBL');
				  echo '<span class="bold">'. vmText::_('COM_VIRTUEMART_PRODUCT_DETAILS_VENDOR_LBL'). '</span>'; ?><a class="modal" href="<?php echo $link ?>"><?php echo $text ?></a><br />
				 */
				?>

				<div class="clear"></div>
				<?php
				echo shopFunctionsF::renderVmSubLayout('addtocart',array('product'=>$this->product));

				echo shopFunctionsF::renderVmSubLayout('stockhandle',array('product'=>$this->product));

				// Ask a question about this product
				if (VmConfig::get('ask_question', 0) == 1) {
					$askquestion_url = JRoute::_('index.php?option=com_virtuemart&view=productdetails&task=askquestion&virtuemart_product_id=' . $this->product->virtuemart_product_id . '&virtuemart_category_id=' . $this->product->virtuemart_category_id . '&tmpl=component', FALSE);
					?>
					<div class="ask-a-question">
						<a class="ask-a-question" href="<?php echo $askquestion_url ?>" rel="nofollow" ><?php echo vmText::_('COM_VIRTUEMART_PRODUCT_ENQUIRY_LBL') ?></a>
					</div>
				<?php
				}
				?>

				<?php
				// Manufacturer of the Product
				if (VmConfig::get('show_manufacturers', 1) && !empty($this->product->virtuemart_manufacturer_id)) {
				    echo $this->loadTemplate('manufacturer');
				}
				?>
		    </div>

		    <?php
		    // Product Navigation
		    if (VmConfig::get('product_navigation', 1)) {
			?>
		        <div class="product-neighbours">
				    <?php
				    if (!empty($this->product->neighbours ['previous'][0])) {
					$prev_link = JRoute::_('index.php?option=com_virtuemart&view=productdetails&virtuemart_product_id=' . $this->product->neighbours ['previous'][0] ['virtuemart_product_id'] . '&virtuemart_category_id=' . $this->product->virtuemart_category_id, FALSE);
					echo JHtml::_('link', $prev_link, $this->product->neighbours ['previous'][0]
						['product_name'], array('rel'=>'prev', 'class' => 'previous-page','data-dynamic-update' => '1'));
				    }
				    if (!empty($this->product->neighbours ['next'][0])) {
					$next_link = JRoute::_('index.php?option=com_virtuemart&view=productdetails&virtuemart_product_id=' . $this->product->neighbours ['next'][0] ['virtuemart_product_id'] . '&virtuemart_category_id=' . $this->product->virtuemart_category_id, FALSE);
					echo JHtml::_('link', $next_link, $this->product->neighbours ['next'][0] ['product_name'], array('rel'=>'next','class' => 'next-page','data-dynamic-update' => '1'));
				    }
				    ?>
			    	<div class="clear"></div>
		        </div>
			    <?php } // Product Navigation END
			    ?>

				<?php // Back To Category Button
				if ($this->product->virtuemart_category_id) {
					$catURL =  JRoute::_('index.php?option=com_virtuemart&view=category&virtuemart_category_id='.$this->product->virtuemart_category_id, FALSE);
					$categoryName = vmText::_($this->product->category_name) ;
				} else {
					$catURL =  JRoute::_('index.php?option=com_virtuemart');
					$categoryName = vmText::_('COM_VIRTUEMART_SHOP_HOME') ;
				}
				?>
				<div class="back-to-category">
			    	<a href="<?php echo $catURL ?>" class="product-details" title="<?php echo $categoryName ?>"><?php echo vmText::sprintf('COM_VIRTUEMART_CATEGORY_BACK_TO',$categoryName) ?></a>
				</div>

			    <?php
			    // Product Edit Link
			    echo $this->edit_link;
			    // Product Edit Link END
			    ?>

			    <?php
			    // PDF - Print - Email Icon
			    if (VmConfig::get('show_emailfriend') || VmConfig::get('show_printicon') || VmConfig::get('pdf_icon')) {
				?>
			        <div class="icons">
				    <?php

				    $link = 'index.php?tmpl=component&option=com_virtuemart&view=productdetails&virtuemart_product_id=' . $this->product->virtuemart_product_id;

					echo $this->linkIcon($link . '&format=pdf', 'COM_VIRTUEMART_PDF', 'pdf_button', 'pdf_icon', false);
				    //echo $this->linkIcon($link . '&print=1', 'COM_VIRTUEMART_PRINT', 'printButton', 'show_printicon');
					echo $this->linkIcon($link . '&print=1', 'COM_VIRTUEMART_PRINT', 'printButton', 'show_printicon',false,true,false,'class="printModal"');
					$MailLink = 'index.php?option=com_virtuemart&view=productdetails&task=recommend&virtuemart_product_id=' . $this->product->virtuemart_product_id . '&virtuemart_category_id=' . $this->product->virtuemart_category_id . '&tmpl=component';
				    echo $this->linkIcon($MailLink, 'COM_VIRTUEMART_EMAIL', 'emailButton', 'show_emailfriend', false,true,false,'class="recommened-to-friend"');
				    ?>
			    	<div class="clear"></div>
			        </div>
			    <?php } // PDF - Print - Email Icon END
			    ?>

		</div> <!--/.col-sm-7-->
		<div class="clear"></div>
    </div> <!--/.row-->

    <div class="row">
	    <div class="col-sm-12">
			<?php
			// event onContentBeforeDisplay
			echo $this->product->event->beforeDisplayContent; ?>

			<div class="products-desc-tab">

				<ul id="myTab" class="nav nav-tabs">

					<?php if (!empty($this->product->product_desc)) { ?>
					<li class="active">
						<a href="#desc" data-toggle="tab">
							<?php echo vmText::_('COM_VIRTUEMART_PRODUCT_DESC_TITLE') ?>
						 </a>
					</li>
				    <?php } // Product Description END ?>

				 	<li>
					  	<a href="#review" data-toggle="tab">
						   <?php echo JText::_('PRODUCT_REVIEWS');?>
					  </a>
					</li>
				</ul>
			 
				<div id="myTabContent" class="tab-content">

					<?php if (!empty($this->product->product_desc)) { ?>
					    <div class="tab-pane fade active in" id="desc">
						    <div class="product-description">
								<?php /** @todo Test if content plugins modify the product description */ ?>
								<?php echo $this->product->product_desc; ?>
						    </div>
					    </div>
				    <?php } // Product Description END ?>


				    <div class="tab-pane fade" id="review">
				    	<?php echo $this->loadTemplate('reviews'); ?>
				 	 </div>
				</div>

			</div> <!--/. products-desc-tab-->

			<?php

			echo shopFunctionsF::renderVmSubLayout('customfields',array('product'=>$this->product,'position'=>'normal'));

		    // Product Packaging
		    $product_packaging = '';
		    if ($this->product->product_box) {
			?>
		        <div class="product-box">
			    <?php
			        echo vmText::_('COM_VIRTUEMART_PRODUCT_UNITS_IN_BOX') .$this->product->product_box;
			    ?>
		        </div>
		    <?php } // Product Packaging END ?>

		    <?php 
			echo shopFunctionsF::renderVmSubLayout('customfields',array('product'=>$this->product,'position'=>'onbot'));

		    echo shopFunctionsF::renderVmSubLayout('customfields',array('product'=>$this->product,'position'=>'related_products','class'=> 'product-related-products','customTitle' => true ));

			echo shopFunctionsF::renderVmSubLayout('customfields',array('product'=>$this->product,'position'=>'related_categories','class'=> 'product-related-categories'));

			?>

			<?php // onContentAfterDisplay event
			echo $this->product->event->afterDisplayContent;

			// Show child categories
			if (VmConfig::get('showCategory', 1)) {
				echo $this->loadTemplate('showcategory');
			} ?>

		</div> <!--/.col-sm-12-->
	</div> <!--/.row-->

	<?php

	$j = 'jQuery(document).ready(function($) {
		Virtuemart.product(jQuery("form.product"));

		$("form.js-recalculate").each(function(){
			if ($(this).find(".product-fields").length && !$(this).find(".no-vm-bind").length) {
				var id= $(this).find(\'input[name="virtuemart_product_id[]"]\').val();
				Virtuemart.setproducttype($(this),id);

			}
		});
	});';
	//vmJsApi::addJScript('recalcReady',$j);

	/** GALT
		 * Notice for Template Developers!
		 * Templates must set a Virtuemart.container variable as it takes part in
		 * dynamic content update.
		 * This variable points to a topmost element that holds other content.
		 */
	$j = "Virtuemart.container = jQuery('.productdetails-view');
	Virtuemart.containerSelector = '.productdetails-view';";

	vmJsApi::addJScript('ajaxContent',$j);

	echo vmJsApi::writeJS();
	?> 
</div> <!--/.productdetails-->



