
--
-- Database: `sp_newskit_v15`
--

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_action`
--

DROP TABLE IF EXISTS `#__acymailing_action`;
CREATE TABLE `#__acymailing_action` (
  `action_id` int(10) unsigned NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `frequency` int(10) unsigned NOT NULL,
  `nextdate` int(10) unsigned NOT NULL,
  `description` text,
  `server` varchar(255) NOT NULL,
  `port` varchar(50) NOT NULL,
  `connection_method` varchar(10) NOT NULL DEFAULT '0',
  `secure_method` varchar(10) NOT NULL DEFAULT '0',
  `self_signed` tinyint(4) NOT NULL DEFAULT '0',
  `username` varchar(255) NOT NULL,
  `password` varchar(50) NOT NULL,
  `userid` int(10) unsigned DEFAULT NULL,
  `conditions` text,
  `actions` text,
  `report` text,
  `delete_wrong_emails` tinyint(4) NOT NULL DEFAULT '0',
  `senderfrom` tinyint(4) NOT NULL DEFAULT '0',
  `senderto` tinyint(4) NOT NULL DEFAULT '0',
  `published` tinyint(4) NOT NULL DEFAULT '0',
  `ordering` smallint(5) unsigned DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_config`
--

DROP TABLE IF EXISTS `#__acymailing_config`;
CREATE TABLE `#__acymailing_config` (
  `namekey` varchar(200) NOT NULL,
  `value` text
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__acymailing_config`
--

INSERT INTO `#__acymailing_config` (`namekey`, `value`) VALUES
('add_names', '1'),
('allowedfiles', 'zip,doc,docx,pdf,xls,txt,gzip,rar,jpg,jpeg,gif,xlsx,pps,csv,bmp,ico,odg,odp,ods,odt,png,ppt,swf,xcf,mp3,wma'),
('allow_visitor', '1'),
('bootstrap_frontend', '0'),
('bounce_email', 'install@joomshaper.com'),
('Business', '2'),
('charset', 'UTF-8'),
('confirmation_message', '1'),
('confirm_redirect', ''),
('cron_frequency', '900'),
('cron_fromip', ''),
('cron_fullreport', '1'),
('cron_last', '0'),
('cron_next', '1251990901'),
('cron_report', ''),
('cron_savepath', 'media/com_acymailing/logs/report941363502.log'),
('cron_savereport', '2'),
('cron_sendreport', '2'),
('cron_sendto', 'install@joomshaper.com'),
('css_backend', ''),
('css_frontend', 'default'),
('css_module', 'default'),
('description_business', 'Joomla!® Mailing Extension'),
('description_enterprise', 'Joomla!® Marketing Campaign'),
('description_essential', 'Joomla!® Newsletter Extension'),
('description_sidekick', 'Joomla!® Newsletter System'),
('description_starter', 'Joomla!® E-mail Marketing'),
('editor', 'acyeditor'),
('embed_files', '1'),
('embed_images', '0'),
('encoding_format', '8bit'),
('Enterprise', '3'),
('Essential', '1'),
('expirationdate', '0'),
('forward', '0'),
('from_email', 'install@joomshaper.com'),
('from_name', 'Shaper Newskit'),
('hostname', ''),
('installcomplete', '1'),
('itemid', '0'),
('lastlicensecheck', '1512029450'),
('latestversion', '5.8.1'),
('level', 'Starter'),
('mailer_method', 'mail'),
('max_execution_time', '0'),
('multiple_part', '1'),
('notification_accept', ''),
('notification_created', ''),
('notification_refuse', ''),
('notification_unsuball', ''),
('priority_followup', '2'),
('priority_newsletter', '3'),
('queue_nbmail', '40'),
('queue_nbmail_auto', '70'),
('queue_pause', '120'),
('queue_try', '3'),
('queue_type', 'auto'),
('reply_email', 'install@joomshaper.com'),
('reply_name', 'Shaper Newskit'),
('require_confirmation', '0'),
('security_key', 'QObOgTEGgUN5Gh35JLOP73tGBguIBc'),
('sendmail_path', '/usr/sbin/sendmail'),
('Sidekick', '4'),
('smtp_auth', '0'),
('smtp_host', 'localhost'),
('smtp_password', ''),
('smtp_port', '25'),
('smtp_secured', ''),
('smtp_username', ''),
('Starter', '0'),
('subscription_message', '1'),
('unsub_message', '1'),
('unsub_reasons', 'a:2:{i:0;s:21:"UNSUB_SURVEY_FREQUENT";i:1;s:21:"UNSUB_SURVEY_RELEVANT";}'),
('unsub_redirect', ''),
('uploadfolder', 'media/com_acymailing/upload'),
('use_sef', '0'),
('version', '5.8.1'),
('website', 'http://localhost/work/update/spp3/newskit_quickstart_j3_v1.5/'),
('welcome_message', '1'),
('word_wrapping', '150');

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_fields`
--

DROP TABLE IF EXISTS `#__acymailing_fields`;
CREATE TABLE `#__acymailing_fields` (
  `fieldid` smallint(5) unsigned NOT NULL,
  `fieldname` varchar(250) NOT NULL,
  `namekey` varchar(50) NOT NULL,
  `type` varchar(50) DEFAULT NULL,
  `value` text NOT NULL,
  `published` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `ordering` smallint(5) unsigned DEFAULT '99',
  `options` text,
  `core` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `required` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `backend` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `frontcomp` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `frontform` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `default` varchar(250) DEFAULT NULL,
  `listing` tinyint(3) unsigned DEFAULT NULL,
  `frontlisting` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `frontjoomlaprofile` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `frontjoomlaregistration` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `joomlaprofile` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `access` varchar(250) NOT NULL DEFAULT 'all',
  `fieldcat` int(11) NOT NULL DEFAULT '0',
  `listingfilter` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `frontlistingfilter` tinyint(3) unsigned NOT NULL DEFAULT '0'
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__acymailing_fields`
--

INSERT INTO `#__acymailing_fields` (`fieldid`, `fieldname`, `namekey`, `type`, `value`, `published`, `ordering`, `options`, `core`, `required`, `backend`, `frontcomp`, `frontform`, `default`, `listing`, `frontlisting`, `frontjoomlaprofile`, `frontjoomlaregistration`, `joomlaprofile`, `access`, `fieldcat`, `listingfilter`, `frontlistingfilter`) VALUES
(1, 'NAMECAPTION', 'name', 'text', '', 1, 1, '', 1, 1, 1, 1, 1, '', 1, 1, 0, 0, 0, 'all', 0, 0, 0),
(2, 'EMAILCAPTION', 'email', 'text', '', 1, 2, '', 1, 1, 1, 1, 1, '', 1, 1, 0, 0, 0, 'all', 0, 0, 0),
(3, 'RECEIVE', 'html', 'radio', '0::JOOMEXT_TEXT\n1::HTML', 1, 3, '', 1, 1, 1, 1, 1, '1', 1, 0, 0, 0, 0, 'all', 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_filter`
--

DROP TABLE IF EXISTS `#__acymailing_filter`;
CREATE TABLE `#__acymailing_filter` (
  `filid` mediumint(8) unsigned NOT NULL,
  `name` varchar(250) DEFAULT NULL,
  `description` text,
  `published` tinyint(3) unsigned DEFAULT NULL,
  `lasttime` int(10) unsigned DEFAULT NULL,
  `trigger` text,
  `report` text,
  `action` text,
  `filter` text,
  `daycron` int(10) unsigned DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_forward`
--

DROP TABLE IF EXISTS `#__acymailing_forward`;
CREATE TABLE `#__acymailing_forward` (
  `subid` int(10) unsigned NOT NULL,
  `mailid` mediumint(8) unsigned NOT NULL,
  `date` int(10) unsigned NOT NULL,
  `ip` varchar(50) DEFAULT NULL,
  `nbforwarded` int(10) unsigned NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_geolocation`
--

DROP TABLE IF EXISTS `#__acymailing_geolocation`;
CREATE TABLE `#__acymailing_geolocation` (
  `geolocation_id` int(10) unsigned NOT NULL,
  `geolocation_subid` int(10) unsigned NOT NULL DEFAULT '0',
  `geolocation_type` varchar(255) NOT NULL DEFAULT 'subscription',
  `geolocation_ip` varchar(255) NOT NULL DEFAULT '',
  `geolocation_created` int(10) unsigned NOT NULL DEFAULT '0',
  `geolocation_latitude` decimal(9,6) NOT NULL DEFAULT '0.000000',
  `geolocation_longitude` decimal(9,6) NOT NULL DEFAULT '0.000000',
  `geolocation_postal_code` varchar(255) NOT NULL DEFAULT '',
  `geolocation_country` varchar(255) NOT NULL DEFAULT '',
  `geolocation_country_code` varchar(255) NOT NULL DEFAULT '',
  `geolocation_state` varchar(255) NOT NULL DEFAULT '',
  `geolocation_state_code` varchar(255) NOT NULL DEFAULT '',
  `geolocation_city` varchar(255) NOT NULL DEFAULT '',
  `geolocation_continent` varchar(255) NOT NULL DEFAULT '',
  `geolocation_timezone` varchar(255) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_history`
--

DROP TABLE IF EXISTS `#__acymailing_history`;
CREATE TABLE `#__acymailing_history` (
  `subid` int(10) unsigned NOT NULL,
  `date` int(10) unsigned NOT NULL,
  `ip` varchar(50) DEFAULT NULL,
  `action` varchar(50) NOT NULL COMMENT 'different actions: created,modified,confirmed',
  `data` text,
  `source` text,
  `mailid` mediumint(8) unsigned DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__acymailing_history`
--

INSERT INTO `#__acymailing_history` (`subid`, `date`, `ip`, `action`, `data`, `source`, `mailid`) VALUES
(2, 1497595359, '10.0.1.5', 'created', '', 'HTTP_REFERER::http://10.0.1.17/project/2017/newskit/index.php/component/acymailing/?ctrl=sub&task=display&autofocus=1&formid=131&tmpl=component\nHTTP_USER_AGENT::Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36\nHTTP_HOST::10.0.1.17\nSERVER_ADDR::10.0.1.17\nREMOTE_ADDR::10.0.1.5\nREQUEST_URI::/project/2017/newskit/index.php/component/acymailing/', 0),
(3, 1497850026, '10.0.1.5', 'created', '', 'HTTP_REFERER::http://10.0.1.17/project/2017/newskit/?tmpl=comingsoon\nHTTP_USER_AGENT::Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36\nHTTP_HOST::10.0.1.17\nSERVER_ADDR::10.0.1.17\nREMOTE_ADDR::10.0.1.5\nREQUEST_URI::/project/2017/newskit/index.php', 0),
(4, 1497850060, '10.0.1.5', 'created', '', 'HTTP_REFERER::http://10.0.1.17/project/2017/newskit/?tmpl=comingsoon\nHTTP_USER_AGENT::Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36\nHTTP_HOST::10.0.1.17\nSERVER_ADDR::10.0.1.17\nREMOTE_ADDR::10.0.1.5\nREQUEST_URI::/project/2017/newskit/index.php', 0),
(5, 1512630122, '', 'created', '', 'HTTP_REFERER::http://localhost/work/update/spp3/newskit_quickstart_j3_v1.5/\nHTTP_USER_AGENT::Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/62.0.3202.94 Safari/537.36\nHTTP_HOST::localhost\nSERVER_ADDR::::1\nREMOTE_ADDR::::1\nREQUEST_URI::/work/update/spp3/newskit_quickstart_j3_v1.5/index.php', 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_list`
--

DROP TABLE IF EXISTS `#__acymailing_list`;
CREATE TABLE `#__acymailing_list` (
  `name` varchar(250) NOT NULL,
  `description` text,
  `ordering` smallint(5) unsigned DEFAULT '0',
  `listid` smallint(5) unsigned NOT NULL,
  `published` tinyint(4) DEFAULT NULL,
  `userid` int(10) unsigned DEFAULT NULL,
  `alias` varchar(250) DEFAULT NULL,
  `color` varchar(30) DEFAULT NULL,
  `visible` tinyint(4) NOT NULL DEFAULT '1',
  `welmailid` mediumint(9) DEFAULT NULL,
  `unsubmailid` mediumint(9) DEFAULT NULL,
  `type` enum('list','campaign') NOT NULL DEFAULT 'list',
  `access_sub` varchar(250) NOT NULL DEFAULT 'all',
  `access_manage` varchar(250) NOT NULL DEFAULT 'none',
  `languages` varchar(250) NOT NULL DEFAULT 'all',
  `startrule` varchar(50) NOT NULL DEFAULT '0',
  `category` varchar(250) NOT NULL DEFAULT ''
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__acymailing_list`
--

INSERT INTO `#__acymailing_list` (`name`, `description`, `ordering`, `listid`, `published`, `userid`, `alias`, `color`, `visible`, `welmailid`, `unsubmailid`, `type`, `access_sub`, `access_manage`, `languages`, `startrule`, `category`) VALUES
('Newsletters', 'Receive our latest news', 1, 1, 1, 671, 'mailing_list', '#3366ff', 1, NULL, NULL, 'list', 'all', 'none', 'all', '0', '');

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_listcampaign`
--

DROP TABLE IF EXISTS `#__acymailing_listcampaign`;
CREATE TABLE `#__acymailing_listcampaign` (
  `campaignid` smallint(5) unsigned NOT NULL,
  `listid` smallint(5) unsigned NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_listmail`
--

DROP TABLE IF EXISTS `#__acymailing_listmail`;
CREATE TABLE `#__acymailing_listmail` (
  `listid` smallint(5) unsigned NOT NULL,
  `mailid` mediumint(8) unsigned NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_listsub`
--

DROP TABLE IF EXISTS `#__acymailing_listsub`;
CREATE TABLE `#__acymailing_listsub` (
  `listid` smallint(5) unsigned NOT NULL,
  `subid` int(10) unsigned NOT NULL,
  `subdate` int(10) unsigned DEFAULT NULL,
  `unsubdate` int(10) unsigned DEFAULT NULL,
  `status` tinyint(4) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__acymailing_listsub`
--

INSERT INTO `#__acymailing_listsub` (`listid`, `subid`, `subdate`, `unsubdate`, `status`) VALUES
(1, 1, 1496911619, NULL, 1),
(1, 2, 1497595359, NULL, 1),
(1, 3, 1497850026, NULL, 1),
(1, 4, 1497850060, NULL, 1),
(1, 5, 1512630122, NULL, 1);

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_mail`
--

DROP TABLE IF EXISTS `#__acymailing_mail`;
CREATE TABLE `#__acymailing_mail` (
  `mailid` mediumint(8) unsigned NOT NULL,
  `subject` varchar(250) NOT NULL,
  `body` longtext NOT NULL,
  `altbody` longtext NOT NULL,
  `published` tinyint(4) DEFAULT '1',
  `senddate` int(10) unsigned DEFAULT NULL,
  `created` int(10) unsigned DEFAULT NULL,
  `fromname` varchar(250) DEFAULT NULL,
  `fromemail` varchar(250) DEFAULT NULL,
  `replyname` varchar(250) DEFAULT NULL,
  `replyemail` varchar(250) DEFAULT NULL,
  `bccaddresses` varchar(250) DEFAULT NULL,
  `type` enum('news','autonews','followup','unsub','welcome','notification','joomlanotification','action') NOT NULL DEFAULT 'news',
  `visible` tinyint(4) NOT NULL DEFAULT '1',
  `userid` int(10) unsigned DEFAULT NULL,
  `alias` varchar(250) DEFAULT NULL,
  `attach` text,
  `favicon` text,
  `html` tinyint(4) NOT NULL DEFAULT '1',
  `tempid` smallint(6) NOT NULL DEFAULT '0',
  `key` varchar(200) DEFAULT NULL,
  `frequency` varchar(50) DEFAULT NULL,
  `params` text,
  `sentby` int(10) unsigned DEFAULT NULL,
  `metakey` text,
  `metadesc` text,
  `filter` text,
  `language` varchar(50) NOT NULL DEFAULT '',
  `abtesting` varchar(250) DEFAULT NULL,
  `thumb` varchar(250) DEFAULT NULL,
  `summary` text NOT NULL,
  `lastupdate` int(10) unsigned DEFAULT NULL,
  `userlastupdate` int(10) unsigned DEFAULT NULL
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__acymailing_mail`
--

INSERT INTO `#__acymailing_mail` (`mailid`, `subject`, `body`, `altbody`, `published`, `senddate`, `created`, `fromname`, `fromemail`, `replyname`, `replyemail`, `bccaddresses`, `type`, `visible`, `userid`, `alias`, `attach`, `favicon`, `html`, `tempid`, `key`, `frequency`, `params`, `sentby`, `metakey`, `metadesc`, `filter`, `language`, `abtesting`, `thumb`, `summary`, `lastupdate`, `userlastupdate`) VALUES
(1, 'New Subscriber on your website : {user:email}', '<p>Hello {subtag:name},</p><p>A new user has been created in AcyMailing : </p><blockquote><p>Name : {user:name}</p><p>Email : {user:email}</p><p>IP : {user:ip} </p><p>Subscription : {user:subscription}</p></blockquote>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'notification_created', NULL, NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL),
(2, 'A User unsubscribed from all your lists : {user:email}', '<p>Hello {subtag:name},</p><p>The user {user:name} : {user:email} unsubscribed from all your lists</p><p>Subscription : {user:subscription}</p><p>{survey}</p>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'notification_unsuball', NULL, NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL),
(3, 'A User unsubscribed : {user:email}', '<p>Hello {subtag:name},</p><p>The user {user:name} : {user:email} unsubscribed from your list</p><p>Subscription : {user:subscription}</p><p>{survey}</p>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'notification_unsub', NULL, NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL),
(4, 'A User refuses to receive e-mails from your website : {user:email}', '<p>The User {user:name} : {user:email} refuses to receive any e-mail anymore from your website.</p><p>Subscription : {user:subscription}</p><p>{survey}</p>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'notification_refuse', NULL, NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL),
(5, 'New contact from your website : {user:email}', '<p>Hello {subtag:name},</p><p>A user submitted the form : </p><blockquote><p>Name : {user:name}</p><p>Email : {user:email}</p><p>IP : {user:ip} </p><p>Subscription : {user:subscription}</p></blockquote>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'notification_contact', NULL, NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL),
(6, 'A user subscribed or modified his subscription : {user:email}', '<p>Hello {subtag:name},</p><p>A user submitted the form : </p><blockquote><p>Name : {user:name}</p><p>Email : {user:email}</p><p>IP : {user:ip} </p><p>Subscription : {user:subscription}</p></blockquote>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'notification_contact_menu', NULL, NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL),
(7, 'A user confirmed his subscription : {user:email}', '<p>Hello {subtag:name},</p><p>A user confirmed his subscription : </p><blockquote><p>Name : {user:name}</p><p>Email : {user:email}</p><p>IP : {user:ip} </p><p>Subscription : {user:subscription}</p></blockquote>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'notification_confirm', NULL, NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL),
(8, '{subtag:name|ucfirst}, {trans:PLEASE_CONFIRM_SUB}', '<div style="text-align: center; width: 100%; background-color:#ffffff;">\r\n		<table align="center" border="0" cellpadding="0" cellspacing="0" class="w600" style="text-align: justify; margin: auto; width: 600px;">\r\n			<tbody>\r\n				<tr class="acyeditor_delete" style="line-height: 0px;" id="zone_2">\r\n					<td class="w600" colspan="5" style="background-color: #69b4c0;" valign="bottom" width="600" id="zone_3"><img id="zone_29" alt=" - - - " border="0" src="media/com_acymailing/templates/newsletter-4/images/top.png"></td>\r\n				</tr>\r\n				<tr class="acyeditor_delete" id="zone_4">\r\n					<td class="w40" style="background-color: #ebebeb;" width="40" id="zone_5"></td>\r\n					<td class="w520 acyeditor_text" colspan="3" height="80" style="text-align: left; background-color: #ebebeb;" width="520" id="zone_6"><strong>​</strong>​​​​​​​​<img alt="-" border="0" src="media/com_acymailing/templates/newsletter-4/images/message_icon.png" style="float: left; margin-right: 10px;">\r\n		<h3>{subtag:name|ucfirst}, {trans:PLEASE_CONFIRM_SUB}<span style="display: none;">&nbsp;</span></h3>\r\n		</td>\r\n					<td class="acyeditor_picture w40" style="background-color: #ebebeb;" width="40" id="zone_7"></td>\r\n				</tr>\r\n				<tr class="acyeditor_delete" id="zone_8">\r\n					<td class="w40" style="background-color: #ebebeb;" width="40" id="zone_9"></td>\r\n					<td class="w20" style="background-color: #fff;" width="20" id="zone_10"></td>\r\n					<td class="w480" height="20" style="background-color: #fff;" width="480" id="zone_11"></td>\r\n					<td class="w20" style="background-color: #fff;" width="20" id="zone_12"></td>\r\n					<td class="w40" style="background-color: #ebebeb;" width="40" id="zone_13"></td>\r\n				</tr>\r\n				<tr class="acyeditor_delete" id="zone_14">\r\n					<td class="w40" style="background-color: #ebebeb;" width="40" id="zone_15"></td>\r\n					<td class="w20" style="background-color: #fff;" width="20" id="zone_16"></td>\r\n					<td class="w480 pict acyeditor_text" style="background-color: #fff; text-align: left;" width="480" id="zone_17"><h1>Hello {subtag:name|ucfirst},</h1>\r\n			<p>{trans:CONFIRM_MSG}<br /><br />{trans:CONFIRM_MSG_ACTIVATE}</p>\r\n			<br />\r\n			<p style="text-align:center;"><strong>{confirm}{trans:CONFIRM_SUBSCRIPTION}{/confirm}</strong></p></td>\r\n					<td class="w20" style="background-color: #fff;" width="20" id="zone_18"></td>\r\n					<td class="w40" style="background-color: #ebebeb;" width="40" id="zone_19"></td>\r\n				</tr>\r\n				<tr class="acyeditor_delete" id="zone_20">\r\n					<td class="w40" style="background-color: #ebebeb;" width="40" id="zone_21"></td>\r\n					<td class="w20" style="background-color: #fff;" width="20" id="zone_22"></td>\r\n					<td class="w480" height="20" style="background-color: #fff;" width="480" id="zone_23"></td>\r\n					<td class="w20" style="background-color: #fff;" width="20" id="zone_24"></td>\r\n					<td class="w40" style="background-color: #ebebeb;" width="40" id="zone_25"></td>\r\n				</tr>\r\n				<tr class="acyeditor_delete" style="line-height: 0px;" id="zone_26">\r\n					<td class="w600" colspan="5" style="background-color: #ebebeb;" width="600" id="zone_27"><img id="zone_31" alt=" - - - " border="0" src="media/com_acymailing/templates/newsletter-4/images/bottom.png"></td>\r\n				</tr>\r\n			</tbody>\r\n		</table>\r\n		</div>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'confirmation', NULL, NULL, 1, 1, NULL, NULL, 'a:3:{s:6:"action";s:7:"confirm";s:13:"actionbtntext";s:28:"{trans:CONFIRM_SUBSCRIPTION}";s:9:"actionurl";s:19:"{confirm}{/confirm}";}', NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL),
(9, 'AcyMailing Cron Report {mainreport}', '<p>{report}</p><p>{detailreport}</p>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'report', NULL, NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL),
(10, 'Modify your subscription', '<p>Hello {subtag:name}, </p><p>You requested some changes on your subscription,</p><p>Please {modify}click here{/modify} to be identified as the owner of this account and then modify your subscription.</p>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'modif', NULL, NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_queue`
--

DROP TABLE IF EXISTS `#__acymailing_queue`;
CREATE TABLE `#__acymailing_queue` (
  `senddate` int(10) unsigned NOT NULL,
  `subid` int(10) unsigned NOT NULL,
  `mailid` mediumint(8) unsigned NOT NULL,
  `priority` tinyint(3) unsigned DEFAULT '3',
  `try` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `paramqueue` varchar(250) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_rules`
--

DROP TABLE IF EXISTS `#__acymailing_rules`;
CREATE TABLE `#__acymailing_rules` (
  `ruleid` smallint(5) unsigned NOT NULL,
  `name` varchar(250) NOT NULL,
  `ordering` smallint(6) DEFAULT NULL,
  `regex` text NOT NULL,
  `executed_on` text NOT NULL,
  `action_message` text NOT NULL,
  `action_user` text NOT NULL,
  `published` tinyint(3) unsigned NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_stats`
--

DROP TABLE IF EXISTS `#__acymailing_stats`;
CREATE TABLE `#__acymailing_stats` (
  `mailid` mediumint(8) unsigned NOT NULL,
  `senthtml` int(10) unsigned NOT NULL DEFAULT '0',
  `senttext` int(10) unsigned NOT NULL DEFAULT '0',
  `senddate` int(10) unsigned NOT NULL,
  `openunique` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `opentotal` int(10) unsigned NOT NULL DEFAULT '0',
  `bounceunique` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `fail` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `clicktotal` int(10) unsigned NOT NULL DEFAULT '0',
  `clickunique` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `unsub` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `forward` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `bouncedetails` text
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_subscriber`
--

DROP TABLE IF EXISTS `#__acymailing_subscriber`;
CREATE TABLE `#__acymailing_subscriber` (
  `subid` int(10) unsigned NOT NULL,
  `email` varchar(200) NOT NULL,
  `userid` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(250) NOT NULL DEFAULT '',
  `created` int(10) unsigned DEFAULT NULL,
  `confirmed` tinyint(4) NOT NULL DEFAULT '0',
  `enabled` tinyint(4) NOT NULL DEFAULT '1',
  `accept` tinyint(4) NOT NULL DEFAULT '1',
  `ip` varchar(100) DEFAULT NULL,
  `html` tinyint(4) NOT NULL DEFAULT '1',
  `key` varchar(250) DEFAULT NULL,
  `confirmed_date` int(10) unsigned NOT NULL DEFAULT '0',
  `confirmed_ip` varchar(100) DEFAULT NULL,
  `lastopen_date` int(10) unsigned NOT NULL DEFAULT '0',
  `lastopen_ip` varchar(100) DEFAULT NULL,
  `lastclick_date` int(10) unsigned NOT NULL DEFAULT '0',
  `lastsent_date` int(10) unsigned NOT NULL DEFAULT '0',
  `source` varchar(250) NOT NULL DEFAULT ''
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__acymailing_subscriber`
--

INSERT INTO `#__acymailing_subscriber` (`subid`, `email`, `userid`, `name`, `created`, `confirmed`, `enabled`, `accept`, `ip`, `html`, `key`, `confirmed_date`, `confirmed_ip`, `lastopen_date`, `lastopen_ip`, `lastclick_date`, `lastsent_date`, `source`) VALUES
(1, 'install@joomshaper.com', 671, 'Super User', 1496361732, 1, 1, 1, NULL, 1, NULL, 0, NULL, 0, NULL, 0, 0, ''),
(2, 'agfdsfgf@gmail.com', 0, 'Agfdsfgf', 1497595359, 0, 1, 1, '10.0.1.5', 1, 'I1Zt2GLyqv4Ptf', 0, NULL, 0, NULL, 0, 0, 'module_131'),
(3, 'dfsd@gamil.com', 0, 'Dfsd', 1497850026, 0, 1, 1, '10.0.1.5', 1, 'r6x3QEYiaHUfEV', 0, NULL, 0, NULL, 0, 0, 'module_131'),
(4, 'esdf@gmail.com', 0, 'Esdf', 1497850060, 0, 1, 1, '10.0.1.5', 1, 'dLpRTjn2yX9kCx', 0, NULL, 0, NULL, 0, 0, 'module_131'),
(5, 'amjadssssrana05@gmail.com', 0, 'Amjadssssrana', 1512630122, 0, 1, 1, '', 1, 'kHp1qcNSGhi0hR', 0, NULL, 0, NULL, 0, 0, 'module_121');

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_tag`
--

DROP TABLE IF EXISTS `#__acymailing_tag`;
CREATE TABLE `#__acymailing_tag` (
  `tagid` smallint(5) unsigned NOT NULL,
  `name` varchar(250) NOT NULL,
  `userid` int(10) unsigned DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_tagmail`
--

DROP TABLE IF EXISTS `#__acymailing_tagmail`;
CREATE TABLE `#__acymailing_tagmail` (
  `tagid` smallint(5) unsigned NOT NULL,
  `mailid` mediumint(8) unsigned NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_template`
--

DROP TABLE IF EXISTS `#__acymailing_template`;
CREATE TABLE `#__acymailing_template` (
  `tempid` smallint(5) unsigned NOT NULL,
  `name` varchar(250) DEFAULT NULL,
  `description` text,
  `body` longtext,
  `altbody` longtext,
  `created` int(10) unsigned DEFAULT NULL,
  `published` tinyint(4) NOT NULL DEFAULT '1',
  `premium` tinyint(4) NOT NULL DEFAULT '0',
  `ordering` smallint(5) unsigned DEFAULT '0',
  `namekey` varchar(50) NOT NULL,
  `styles` text,
  `subject` varchar(250) DEFAULT NULL,
  `stylesheet` text,
  `fromname` varchar(250) DEFAULT NULL,
  `fromemail` varchar(250) DEFAULT NULL,
  `replyname` varchar(250) DEFAULT NULL,
  `replyemail` varchar(250) DEFAULT NULL,
  `thumb` varchar(250) DEFAULT NULL,
  `readmore` varchar(250) DEFAULT NULL,
  `access` varchar(250) NOT NULL DEFAULT 'all',
  `category` varchar(250) NOT NULL DEFAULT ''
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__acymailing_template`
--

INSERT INTO `#__acymailing_template` (`tempid`, `name`, `description`, `body`, `altbody`, `created`, `published`, `premium`, `ordering`, `namekey`, `styles`, `subject`, `stylesheet`, `fromname`, `fromemail`, `replyname`, `replyemail`, `thumb`, `readmore`, `access`, `category`) VALUES
(1, 'Notification template', '', '<div style="text-align: center; width: 100%; background-color:#ffffff;">\r\n<div class="acymailing_online acyeditor_delete acyeditor_text" style="text-align:center">{readonline}This email contains graphics, so if you don''t see them, view it in your browser{/readonline}</div>\r\n\r\n<table align="center" border="0" cellpadding="0" cellspacing="0" class="w600" style="text-align: justify; margin: auto; width:600px">\r\n	<tbody class="acyeditor_sortable">\r\n		<tr style="line-height: 0px;" class="acyeditor_delete">\r\n			<td class="w600" colspan="5" style="background-color: #69b4c0;" valign="bottom" width="600"><img alt=" - - - " src="media/com_acymailing/templates/newsletter-4/images/top.png" /></td>\r\n		</tr>\r\n		<tr class="acyeditor_delete">\r\n			<td class="w40" style="background-color: #ebebeb;" width="40"></td>\r\n			<td class="acyeditor_text w520" colspan="3" height="80" style="text-align: left; background-color: rgb(235, 235, 235);" width="520"><img alt="-" src="media/com_acymailing/templates/newsletter-4/images/message_icon.png" style="float:left; margin-right:10px;" />\r\n				<h3>Topic of your message</h3>\r\n\r\n				<h4>Subtitle for your message</h4>\r\n			</td>\r\n			<td class="acyeditor_picture w40" style="background-color: #ebebeb;" width="40"></td>\r\n		</tr>\r\n		<tr class="acyeditor_delete" >\r\n			<td class="w40" style="background-color: #ebebeb;" width="40"></td>\r\n			<td class="w20" style="background-color: #fff;" width="20"></td>\r\n			<td class="w480" height="20" style="background-color:#fff;" width="480"></td>\r\n			<td class="w20" style="background-color: #fff;" width="20"></td>\r\n			<td class="w40" style="background-color: #ebebeb;" width="40"></td>\r\n		</tr>\r\n		<tr class="acyeditor_delete" >\r\n			<td class="w40" style="background-color: #ebebeb;" width="40"></td>\r\n			<td class="w20" style="background-color: #fff;" width="20"></td>\r\n			<td class="acyeditor_text w480 pict" style="background-color:#fff; text-align: left;" width="480">\r\n			<h1>Dear {subtag:name},</h1>\r\n			Your message here...<br />\r\n			</td>\r\n			<td class="w20" style="background-color: #fff;" width="20"></td>\r\n			<td class="w40" style="background-color: #ebebeb;" width="40"></td>\r\n		</tr>\r\n		<tr class="acyeditor_delete" >\r\n			<td class="w40" style="background-color: #ebebeb;" width="40"></td>\r\n			<td class="w20" style="background-color: #fff;" width="20"></td>\r\n			<td class="w480" height="20" style="background-color:#fff;" width="480"></td>\r\n			<td class="w20" style="background-color: #fff;" width="20"></td>\r\n			<td class="w40" style="background-color: #ebebeb;" width="40"></td>\r\n		</tr>\r\n		<tr style="line-height: 0px;" class="acyeditor_delete">\r\n			<td class="w600" colspan="5" style="background-color:#ebebeb;" width="600"><img alt=" - - - " src="media/com_acymailing/templates/newsletter-4/images/bottom.png" /></td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n\r\n<div class="acyeditor_delete acyeditor_text" style="text-align:center">Not interested any more? {unsubscribe}Unsubscribe{/unsubscribe}</div>\r\n</div>', '', NULL, 1, 0, 1, 'newsletter-4', 'a:10:{s:6:"tag_h1";s:76:"color:#393939 !important; font-size:14px; font-weight:bold; margin:10px 0px;";s:6:"tag_h2";s:106:"color: #309fb3 !important; font-size: 14px; font-weight: normal; text-align:left; margin:0px; padding:0px;";s:6:"tag_h3";s:144:"color: #393939 !important; font-size: 18px; font-weight: bold; text-align:left; margin:0px; padding-bottom:5px; border-bottom:1px solid #bdbdbd;";s:6:"tag_h4";s:117:"color: #309fb3 !important; font-size: 14px; font-weight: bold; text-align:left; margin:0px; padding: 5px 0px 0px 0px;";s:5:"tag_a";s:71:"color:#309FB3; text-decoration:none; font-style:italic; cursor:pointer;";s:19:"acymailing_readmore";s:90:"font-size: 12px; color: #fff; background-color:#309fb3; font-weight:bold; padding:3px 5px;";s:17:"acymailing_online";s:52:"color:#a3a3a3; text-decoration:none; font-size:11px;";s:16:"acymailing_unsub";s:52:"color:#a3a3a3; text-decoration:none; font-size:11px;";s:8:"color_bg";s:7:"#ffffff";s:18:"acymailing_content";s:19:"text-align:justify;";}', NULL, 'div,table,p,td{font-family: Verdana, Arial, Helvetica, sans-serif; font-size:12px; text-align:justify; color:#8c8c8c; margin:0px}\r\ndiv.info{text-align:center;padding:10px;font-size:11px;color:#a3a3a3;}\r\n\r\n@media (min-width:10px){\r\n	.w600 { width: 320px !important;}\r\n	.w520 { width: 280px !important;}\r\n	.w480 { width: 260px !important;}\r\n	.w40 { width: 20px !important;}\r\n	.w20 { width: 10px !important;}\r\n	.w600 img {max-width:320px; height:auto !important}\r\n	.w480 img {max-width:260px; height:auto !important;}\r\n}\r\n\r\n@media (min-width:480px) {\r\n	.w600 { width: 480px !important;}\r\n	.w520 { width: 440px !important;}\r\n	.w480 { width: 420px !important;}\r\n	.w40 { width: 20px !important;}\r\n	.w20 { width: 10px !important;}\r\n	.w600 img {max-width:480px; height:auto !important}\r\n	.w480 img {max-width:420px;  height:auto !important;}\r\n}\r\n\r\n@media (min-width:600px){\r\n	.w600 { width: 600px !important;}\r\n	.w520 { width: 520px !important;}\r\n	.w480 { width: 480px !important;}\r\n	.w40 { width: 40px !important;}\r\n	.w20 { width: 20px !important;}\r\n	.w600 img {max-width:600px; height:auto !important}\r\n	.w480 img {max-width:480px;  height:auto !important;}\r\n}\r\n', NULL, NULL, NULL, NULL, 'media/com_acymailing/templates/newsletter-4/newsletter-4.png', '', 'all', ''),
(2, 'Newspaper', '', '<div align="center" style="width:100%; background-color:#454545; padding-bottom:20px; color:#ffffff;">\r\n<div class="acymailing_online acyeditor_delete acyeditor_text">{readonline}This e-mail contains graphics, if you don''t see them <strong>» view it online.</strong>{/readonline}</div>\r\n\r\n<table align="center" border="0" cellpadding="0" cellspacing="0" class="w600" style="margin:auto; background-color:#ffffff; color:#454545;" width="600">\r\n	<tbody  class="acyeditor_sortable">\r\n		<tr class="acyeditor_delete" >\r\n			<td class="w30" style="background-color:#ffffff" width="30"></td>\r\n			<td class="acyeditor_text w540" style="font-family:Times New Roman, Times, serif; background-color:#ffffff; text-align:left" width="540">&nbsp;\r\n			<h1><img alt="logo" src="media/com_acymailing/templates/newsletter-5/images/logo.png" style="float: right; width: 107px; height: 70px;" /></h1>\r\n\r\n			<h1>Your title here</h1>\r\n\r\n			<h3>your subtitle</h3>\r\n			</td>\r\n			<td class="w30" style="line-height:0px; background-color:#ffffff" width="30"></td>\r\n		</tr>\r\n		<tr class="acyeditor_delete">\r\n			<td class="w600" colspan="3" style="line-height:0px; background-color:#e4e4e4" valign="top" width="600"><img alt="---" src="media/com_acymailing/templates/newsletter-5/images/header.png" /></td>\r\n		</tr>\r\n		<tr class="acyeditor_delete">\r\n			<td class="acyeditor_picture w600" colspan="3" style="line-height:0px; background-color:#ffffff" valign="top" width="600"><img alt="banner" src="media/com_acymailing/templates/newsletter-5/images/banner.png" /></td>\r\n		</tr>\r\n		<tr class="acyeditor_delete">\r\n			<td class="w600" colspan="3" style="line-height:0px;" valign="top" width="600"><img alt="---" src="media/com_acymailing/templates/newsletter-5/images/separator.png" /></td>\r\n		</tr>\r\n		<tr>\r\n			<td class="w30" style="background-color:#ffffff" width="30"></td>\r\n			<td class="acyeditor_text w540" style="text-align:justify; color:#575757; font-family:Times New Roman, Times, serif; font-size:13px; background-color:#ffffff" width="540">\r\n				<div>This issue will present the 5 last articles.<br />\r\n				{tableofcontents}<br />\r\n				{autocontent:|max:5|order:id,DESC|type:intro|link|pict:1}</div>\r\n			</td>\r\n			<td class="w30" style="background-color:#ffffff" width="30"></td>\r\n		</tr>\r\n		<tr style="line-height: 0px;">\r\n			<td class="w600" colspan="3" style="background-color:#ffffff" width="600"><img alt="--" src="media/com_acymailing/templates/newsletter-5/images/footer1.png" width="600" /></td>\r\n		</tr>\r\n		<tr>\r\n			<td class="acyfooter acyeditor_text w600" colspan="3" height="25" style="text-align:center; background-color:#ebebeb;  color:#454545; font-family:Times New Roman, Times, serif; font-size:13px" width="600"><a href="#">www.mywebsite.com</a> | <a href="#">contact</a> | <a href="#">Facebook</a> | <a href="#">Twitter</a></td>\r\n		</tr>\r\n		<tr style="line-height: 0px;">\r\n			<td class="w600" colspan="3" style="background-color:#454545;" width="600"><img alt="--" src="media/com_acymailing/templates/newsletter-5/images/footer2.png" width="600" /></td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n\r\n<div class="acymailing_unsub acyeditor_delete acyeditor_text">{unsubscribe}If you''re not interested any more <strong>» unsubscribe</strong>{/unsubscribe}</div>\r\n</div>\r\n', '', NULL, 1, 0, 2, 'newsletter-5', 'a:10:{s:6:"tag_h1";s:71:"color:#454545 !important; font-size:24px; font-weight:bold; margin:0px;";s:6:"tag_h2";s:145:"color:#b20000 !important; font-size:18px; font-weight:bold; margin:0px; margin-bottom:10px; padding-bottom:4px; border-bottom: 1px solid #d6d6d6;";s:6:"tag_h3";s:76:"color:#b20101 !important; font-weight:bold; font-size:18px; margin:10px 0px;";s:6:"tag_h4";s:67:"color:#e52323 !important; font-weight:bold; margin:0px; padding:0px";s:5:"tag_a";s:65:"cursor:pointer; color:#9d0000; text-decoration:none; border:none;";s:19:"acymailing_readmore";s:152:"cursor:pointer; color:#ffffff; background-color:#9d0000; border-top:1px solid #9d0000; border-bottom:1px solid #9d0000; padding:3px 5px; font-size:13px;";s:17:"acymailing_online";s:148:"color:#dddddd; text-decoration:none; font-size:13px; margin:10px; text-align:center; font-family:Times New Roman, Times, serif; padding-bottom:10px;";s:8:"color_bg";s:7:"#454545";s:18:"acymailing_content";s:0:"";s:16:"acymailing_unsub";s:131:"color:#dddddd; text-decoration:none; font-size:13px; text-align:center; font-family:Times New Roman, Times, serif; padding-top:10px";}', NULL, '.acyfooter a{\r\n	color:#454545;\r\n}\r\n.dark{\r\n	color:#454545;\r\n	font-weight:bold;\r\n}\r\ndiv,table,p,td{font-family:"Times New Roman", Times, serif;font-size:13px;color:#575757;}\r\n\r\n\r\n\r\n@media (min-width:10px){\r\n	.w600 { width:320px !important; }\r\n	.w540 { width:260px !important; }\r\n	.w30 { width:30px !important; }\r\n	.w600 img {max-width:320px; height:auto !important; }\r\n	.w540 img {max-width:260px; height:auto !important; }\r\n}\r\n\r\n@media (min-width: 480px){\r\n	.w600 { width:480px !important; }\r\n	.w540 { width:420px !important; }\r\n	.w30 { width:30px !important; }\r\n	.w600 img {max-width:480px; height:auto !important; }\r\n	.w540 img {max-width:420px; height:auto !important; }\r\n}\r\n\r\n@media (min-width:600px){\r\n	.w600 { width:600px !important; }\r\n	.w540 { width:540px !important; }\r\n	.w30 { width:30px !important; }\r\n	.w600 img {max-width:600px; height:auto !important; }\r\n	.w540 img {max-width:540px; height:auto !important; }\r\n}\r\n', NULL, NULL, NULL, NULL, 'media/com_acymailing/templates/newsletter-5/newsletter-5.png', '', 'all', ''),
(3, 'Build Bio', '', '<div align="center" style="width:100%; background-color:#3c3c3c; padding-bottom:20px; color:#ffffff;">\r\n<div class="acymailing_online acyeditor_delete acyeditor_text">{readonline}This e-mail contains graphics, if you don''t see them <strong>» view it online.</strong>{/readonline}</div>\r\n\r\n<table align="center" border="0" cellpadding="0" cellspacing="0" class="w600" style="margin:auto; background-color:#ffffff; color:#575757;" width="600">\r\n	<tbody class="acyeditor_sortable">\r\n		<tr class="acyeditor_delete">\r\n			<td class="w600" colspan="3" style="line-height:0px; background-color:#eeeeee" valign="bottom" width="600"><img alt="mail" height="41" src="media/com_acymailing/templates/newsletter-6/images/header.png" width="600" /></td>\r\n		</tr>\r\n		<tr class="acyeditor_delete">\r\n			<td class="w30" style="color:#ffffff;" width="30"></td>\r\n			<td class="acyeditor_picture w540" style="line-height:0px; background-color:#ffffff; text-align:center" width="540"><img alt="" src="media/com_acymailing/templates/newsletter-6/images/banner.png" style="width: 540px; height: 122px;" /></td>\r\n			<td class="w30" height="122" style="background-color:#ffffff" width="30"></td>\r\n		</tr>\r\n		<tr class="acyeditor_delete">\r\n			<td class="w30" style="background-color:#b9cf00; color:#ffffff;" width="30"></td>\r\n			<td class="acyeditor_text w540" height="25" style="text-align:right; background-color:#b9cf00; color:#ffffff;" width="540"><span class="hide">Newsletter</span> {date:3}</td>\r\n			<td class="w30" style="background-color:#b9cf00; color:#ffffff;" width="30"></td>\r\n		</tr>\r\n		<tr class="acyeditor_delete">\r\n			<td class="w600" colspan="3" height="25" style="background-color:#ffffff" width="600"></td>\r\n		</tr>\r\n		<tr>\r\n			<td class="w30" style="background-color:#ffffff" width="30"></td>\r\n			<td class="acyeditor_text w540" style="text-align:justify; color:#575757; background-color:#ffffff" width="540"><span class="intro">Hello {subtag:name},</span><br />\r\n			<br />\r\n			Your introduction text here\r\n			<br />\r\n			<h2>Your title</h2>\r\n			<strong>Your catchphrase</strong><br />\r\n			Your content here <a href="#">with some link</a><br />\r\n			<br />\r\n			More content<br />\r\n			<br />\r\n			<span class="acymailing_readmore">Read More</span>\r\n\r\n			<h2>Another title</h2>\r\n			<img alt="picture" height="160" src="media/com_acymailing/templates/newsletter-6/images/picture.png" style="float:left;" width="193" /> <strong>Another catchphrase</strong> Some content and <a href="#">another link</a><br />\r\n			<br />\r\n			More content<br />\r\n			<br />\r\n			<span class="acymailing_readmore">Read More</span></td>\r\n			<td class="w30" style="background-color:#ffffff" width="30"></td>\r\n		</tr>\r\n		<tr style="line-height: 0px;" class="acyeditor_delete">\r\n			<td class="w600" colspan="3" style="line-height:0px; background-color:#efefef;" valign="top" width="600"><img alt="--" height="18" src="media/com_acymailing/templates/newsletter-6/images/footer1.png" width="600" /></td>\r\n		</tr>\r\n		<tr class="acyeditor_delete">\r\n			<td class="w30" height="20" style="line-height:0px; background-color:#efefef;" width="30"></td>\r\n			<td class="acyfooter acyeditor_text w540" style="text-align:right; background-color:#efefef; color:#575757;" width="540"><a href="#">www.mywebsite.com</a> | <a href="#">Contact</a><a href="#"><img alt="message" class="hide" src="media/com_acymailing/templates/newsletter-6/images/mail.png" style="border: medium none; width: 35px; height: 20px;" /></a></td>\r\n			<td class="w30" height="20" style="line-height:0px; background-color:#efefef;" width="30"></td>\r\n		</tr>\r\n		<tr style="line-height: 0px;" class="acyeditor_delete">\r\n			<td class="w600" colspan="3" style="background-color:#efefef; line-height:0px;" valign="top" width="600"><img alt="--" height="24" src="media/com_acymailing/templates/newsletter-6/images/footer2.png" width="600" /></td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n\r\n<div class="acymailing_unsub acyeditor_delete acyeditor_text" >{unsubscribe}If you''re not interested any more <strong>» unsubscribe</strong>{/unsubscribe}</div>\r\n</div>', '', NULL, 1, 0, 3, 'newsletter-6', 'a:9:{s:6:"tag_h1";s:69:"font-weight:bold; font-size:14px;color:#3c3c3c !important;margin:0px;";s:6:"tag_h2";s:129:"color:#b9cf00 !important; font-size:14px; font-weight:bold; margin-top:20px; border-bottom:1px solid #d6d6d6; padding-bottom:4px;";s:6:"tag_h3";s:149:"color:#7e7e7e !important; font-size:14px; font-weight:bold; margin:20px 0px 0px 0px; border-bottom:1px solid #d6d6d6; padding-bottom:0px 0px 4px 0px;";s:6:"tag_h4";s:84:"color:#879700 !important; font-size:12px; font-weight:bold; margin:0px; padding:0px;";s:8:"color_bg";s:7:"#3c3c3c";s:5:"tag_a";s:65:"cursor:pointer; color:#a2b500; text-decoration:none; border:none;";s:17:"acymailing_online";s:91:"color:#dddddd; text-decoration:none; font-size:11px; text-align:center; padding-bottom:10px";s:16:"acymailing_unsub";s:88:"color:#dddddd; text-decoration:none; font-size:11px; text-align:center; padding-top:10px";s:19:"acymailing_readmore";s:73:"cursor:pointer; color:#ffffff; background-color:#b9cf00; padding:3px 5px;";}', NULL, 'table, div, p,td{\r\n	font-family: Verdana, Arial, Helvetica, sans-serif;\r\n	font-size:11px;\r\n	color:#575757;\r\n}\r\n.intro{\r\n	font-weight:bold;\r\n	font-size:12px;}\r\n\r\n.acyfooter a{\r\n	color:#575757;}\r\n\r\n@media (min-width: 10px){\r\n	.w600  { width:320px !important; }\r\n	.w540  { width:260px !important; }\r\n	.w30 { width:30px !important; }\r\n	.w600 img{max-width:320px; height:auto !important}\r\n	.w540 img{max-width:260px; height:auto !important}\r\n}\r\n\r\n@media (min-width: 480px){\r\n	.w600  { width:480px !important; }\r\n	.w540  { width:420px !important; }\r\n	.w30 { width:30px !important; }\r\n	.w600 img{max-width:480px; height:auto !important}\r\n	.w540 img{max-width:420px; height:auto !important}\r\n}\r\n\r\n@media (min-width:600px){\r\n	.w600  { width:600px !important; }\r\n	.w540  { width:540px !important; }\r\n	.w30 { width:30px !important; }\r\n	.w600 img{max-width:600px; height:auto !important}\r\n	.w540 img{max-width:540px; height:auto !important}\r\n}\r\n', NULL, NULL, NULL, NULL, 'media/com_acymailing/templates/newsletter-6/newsletter-6.png', '', 'all', ''),
(4, 'Technology', '', '<div align="center" style="width:100%; background-color:#575757; padding-bottom:20px; color:#999999;">\r\n<table align="center" border="0" cellpadding="0" cellspacing="0" class="w600" style="background-color:#fff; color:#999999; margin:auto" width="600">\r\n	<tbody class="acyeditor_sortable">\r\n		<tr class="acyeditor_delete">\r\n			<td class="w30" style="background-color:#575757" width="30"></td>\r\n			<td class="acyeditor_text w540" style="text-align:right; color:#d2d1d1; background-color:#575757" width="540"><span class="acymailing_online">{readonline}If you can''t see this e-mail properly, <span style="text-decoration:underline">view it online</span>{/readonline}</span></td>\r\n			<td class="w30" style="background-color:#575757" width="30"></td>\r\n		</tr>\r\n		<tr class="acyeditor_delete">\r\n			<td class="acyeditor_picture w600" colspan="3" style="line-height:0px; background-color:#575757" valign="bottom" width="600"><img alt="--" src="media/com_acymailing/templates/technology_resp/images/shadowtop.jpg" /></td>\r\n		</tr>\r\n		<tr class="acyeditor_delete">\r\n			<td class="acyeditor_picture w600" colspan="3" style="line-height:0px; background-color:#f5f5f5" width="600"><img alt="--" src="media/com_acymailing/templates/technology_resp/images/top.jpg" /></td>\r\n		</tr>\r\n		<tr class="acyeditor_delete">\r\n			<td class="w30" height="32" style="background-color:#f5f5f5; border-bottom:1px solid #ddd" width="30"></td>\r\n			<td class="acyeditor_text links w540" style="background-color:#f5f5f5; border-bottom:1px solid #ddd; text-align:right; color:#ababab" width="540"><a href="#"><img alt="mail" src="media/com_acymailing/templates/technology_resp/images/mail.jpg" style="float:right; border:none" /></a> Newsletter {mailid} | {date:%B %Y} |&nbsp; <a href="#">www.acyba.com</a> |</td>\r\n			<td class="w30" height="32" style="background-color:#f5f5f5; border-bottom:1px solid #ddd" width="30"></td>\r\n		</tr>\r\n		<tr class="acyeditor_delete">\r\n			<td class="w600" colspan="3" height="16" width="600"></td>\r\n		</tr>\r\n		<tr class="acyeditor_delete">\r\n			<td class="w30" width="30"></td>\r\n			<td class="acyeditor_text w540" width="540"><img alt="picture" src="media/com_acymailing/templates/technology_resp/images/pic1.jpg" style="float:right" />\r\n			<h1>Your title !</h1>\r\n\r\n			<h3>Your catchphrase</h3>\r\n			Your introduction content here</td>\r\n			<td class="w30" width="30"></td>\r\n		</tr>\r\n		<tr class="acyeditor_delete">\r\n			<td class="w30" style="background-color:#fafafa" width="30"></td>\r\n			<td class="acyeditor_picture w540" style="background-color:#fafafa; line-height:0px" width="540"><img alt="---" src="media/com_acymailing/templates/technology_resp/images/separator1.jpg" /></td>\r\n			<td class="w30" style="background-color:#fafafa" width="30"></td>\r\n		</tr>\r\n		<tr class="acyeditor_delete">\r\n			<td class="w30" style="background-color:#fafafa" width="30"></td>\r\n			<td class="acyeditor_text w540" style="background-color:#fafafa; color:#999999" width="540">\r\n			<h2>Your subtitle</h2>\r\n			<img alt="picture" src="media/com_acymailing/templates/technology_resp/images/pic2.jpg" style="float:left" />\r\n			<h3>Your catchphrase</h3>\r\n			Your content here<br />\r\n			<a href="#">Some link</a> and some content<br />\r\n			<br />\r\n			<img alt="buy this product" src="media/com_acymailing/templates/technology_resp/images/buyproduct.jpg" /><br />\r\n			<br />\r\n			<br />\r\n			<br />\r\n			&nbsp;\r\n			<h2>Another subtitle</h2>\r\n			<img alt="picture" src="media/com_acymailing/templates/technology_resp/images/pic3.jpg" style="float:right" />\r\n			<h3>Another catchphrase</h3>\r\n			Other content<br />\r\n			<br />\r\n			<img alt="buy this product" src="media/com_acymailing/templates/technology_resp/images/buyproduct.jpg" /></td>\r\n			<td class="w30" style="background-color:#fafafa" width="30"></td>\r\n		</tr>\r\n		<tr class="acyeditor_delete" >\r\n			<td class="w30" style="background-color:#fafafa" width="30"></td>\r\n			<td class="acyeditor_picture w540" style="background-color:#fafafa; line-height:0px" width="540"><img alt="---" src="media/com_acymailing/templates/technology_resp/images/separator2.jpg" /></td>\r\n			<td class="w30" style="background-color:#fafafa" width="30"></td>\r\n		</tr>\r\n		<tr class="acyeditor_delete" >\r\n			<td class="w600" colspan="3" height="16" width="600"></td>\r\n		</tr>\r\n		<tr class="acyeditor_delete" >\r\n			<td class="w30" width="30"></td>\r\n			<td class="acyeditor_text special w540" style="color:#999999" width="540">\r\n			<h2>Best product of the month</h2>\r\n\r\n			<h3>Lorem ipsum dolor sit amet.</h3>\r\n			Liget, volutpat esvft sem. Praesent auctor posuere orci, sit amet molee. Integer nec scelerisque quam. Lore uctor posum ipsum doLiget, volutpat esvft sem. Praesent auctor posuere orci, sit amet molee. Integer nec scelerisque quam. Lore uctor posum ipsum dolor sit amesent.<br />\r\n			<br />\r\n			<img alt="read more" src="media/com_acymailing/templates/technology_resp/images/readmore.jpg" style="border:none" /></td>\r\n			<td class="w30" width="30"></td>\r\n		</tr>\r\n		<tr class="acyeditor_delete" >\r\n			<td class="w600" colspan="3" height="16" width="600"></td>\r\n		</tr>\r\n		<tr class="acyeditor_delete" >\r\n			<td class="w30" height="30" style="background-color:#f5f5f5; border-top:1px solid #ddd" width="30"></td>\r\n			<td class="acyeditor_text w540" height="30" style="background-color:#f5f5f5; border-top:1px solid #ddd; text-align:right; color:#ababab" valign="bottom" width="540">Follow us | <img alt="facebook" src="media/com_acymailing/templates/technology_resp/images/facebook.jpg" style="border:none" /> <img alt="twitter" src="media/com_acymailing/templates/technology_resp/images/twitter.jpg" style="border:none" /> <img alt="pinterest" src="media/com_acymailing/templates/technology_resp/images/pinterest.jpg" style="border:none" /> <img alt="rss" src="media/com_acymailing/templates/technology_resp/images/rss.jpg" style="border:none" /></td>\r\n			<td class="w30" height="30" style="background-color:#f5f5f5; border-top:1px solid #ddd" width="30"></td>\r\n		</tr>\r\n		<tr class="acyeditor_delete" >\r\n			<td class="acyeditor_picture w600" colspan="3" style="line-height:0px; background-color:#f5f5f5" width="600"><img alt="--" src="media/com_acymailing/templates/technology_resp/images/bottom.jpg" /></td>\r\n		</tr>\r\n		<tr class="acyeditor_delete" >\r\n			<td class="acyeditor_picture w600" colspan="3" style="line-height:0px; background-color:#575757" valign="bottom" width="600"><img alt="--" src="media/com_acymailing/templates/technology_resp/images/shadowbottom.jpg" /></td>\r\n		</tr>\r\n		<tr class="acyeditor_delete" >\r\n			<td class="w30" style="background-color:#575757" width="30"></td>\r\n			<td class="acyeditor_text w540" style="text-align:right; color:#d2d1d1; background-color:#575757" width="540"><span class="acymailing_unsub">{unsubscribe}If you don''t want to receive our news anymore, <span style="text-decoration:underline">unsubscribe</span>{/unsubscribe} </span></td>\r\n			<td class="w30" style="background-color:#575757" width="30"></td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n</div>', '', NULL, 1, 0, 4, 'technology_resp', 'a:9:{s:6:"tag_h1";s:104:"font-size:20px; margin:0px; margin-bottom:15px; padding:0px; font-weight:bold; color:#01bbe5 !important;";s:6:"tag_h2";s:165:"font-size:12px; font-weight:bold; color:#565656 !important; text-transform:uppercase; margin:10px 0px; padding:0px; padding-bottom:5px; border-bottom:1px solid #ddd;";s:6:"tag_h3";s:104:"color:#565656 !important; font-weight:bold; font-size:12px; margin:0px; margin-bottom:10px; padding:0px;";s:6:"tag_h4";s:0:"";s:8:"color_bg";s:7:"#575757";s:5:"tag_a";s:62:"cursor:pointer;color:#01bbe5;text-decoration:none;border:none;";s:17:"acymailing_online";s:30:"color:#d2d1d1; cursor:pointer;";s:16:"acymailing_unsub";s:30:"color:#d2d1d1; cursor:pointer;";s:19:"acymailing_readmore";s:88:"cursor:pointer; font-weight:bold; color:#fff; background-color:#01bbe5; padding:2px 5px;";}', NULL, 'table, div, p, td {\r\n	font-family:Arial, Helvetica, sans-serif;\r\n	font-size:12px;\r\n}\r\np{margin:0px; padding:0px}\r\n\r\n.special h2{font-size:18px;\r\n	margin:0px;\r\n	margin-bottom:15px;\r\n	padding:0px;\r\n	font-weight:bold;\r\n	color:#01bbe5 !important;\r\n	text-transform:none;\r\n	border:none}\r\n\r\n.links a{color:#ababab}\r\n\r\n@media (min-width:10px){\r\n	.w600 { width:320px !important;}\r\n	.w540 { width:260px !important;}\r\n	.w30 { width:30px !important;}\r\n	.w600 img {max-width:320px; height:auto !important}\r\n	.w540 img {max-width:260px; height:auto !important}\r\n}\r\n\r\n@media (min-width: 480px){\r\n	.w600 { width:480px !important;}\r\n	.w540 { width:420px !important;}\r\n	.w30 { width:30px !important;}\r\n	.w600 img {max-width:480px; height:auto !important}\r\n	.w540 img {max-width:420px; height:auto !important}\r\n}\r\n\r\n@media (min-width:600px){\r\n	.w600 { width:600px !important;}\r\n	.w540 { width:540px !important;}\r\n	.w30 { width:30px !important;}\r\n	.w600 img {max-width:600px; height:auto !important}\r\n	.w540 img {max-width:540px; height:auto !important}\r\n}\r\n', NULL, NULL, NULL, NULL, 'media/com_acymailing/templates/technology_resp/thumb.jpg', '', 'all', '');

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_url`
--

DROP TABLE IF EXISTS `#__acymailing_url`;
CREATE TABLE `#__acymailing_url` (
  `urlid` int(10) unsigned NOT NULL,
  `name` varchar(250) NOT NULL,
  `url` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_urlclick`
--

DROP TABLE IF EXISTS `#__acymailing_urlclick`;
CREATE TABLE `#__acymailing_urlclick` (
  `urlid` int(10) unsigned NOT NULL,
  `mailid` mediumint(8) unsigned NOT NULL,
  `click` smallint(5) unsigned NOT NULL DEFAULT '0',
  `subid` int(10) unsigned NOT NULL,
  `date` int(10) unsigned NOT NULL,
  `ip` varchar(100) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_userstats`
--

DROP TABLE IF EXISTS `#__acymailing_userstats`;
CREATE TABLE `#__acymailing_userstats` (
  `mailid` mediumint(8) unsigned NOT NULL,
  `subid` int(10) unsigned NOT NULL,
  `html` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `sent` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `senddate` int(10) unsigned NOT NULL,
  `open` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `opendate` int(11) NOT NULL,
  `bounce` tinyint(4) NOT NULL DEFAULT '0',
  `fail` tinyint(4) NOT NULL DEFAULT '0',
  `ip` varchar(100) DEFAULT NULL,
  `browser` varchar(255) DEFAULT NULL,
  `browser_version` tinyint(3) unsigned DEFAULT NULL,
  `is_mobile` tinyint(3) unsigned DEFAULT NULL,
  `mobile_os` varchar(255) DEFAULT NULL,
  `user_agent` varchar(255) DEFAULT NULL,
  `bouncerule` varchar(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__assets`
--

DROP TABLE IF EXISTS `#__assets`;
CREATE TABLE `#__assets` (
  `id` int(10) unsigned NOT NULL COMMENT 'Primary Key',
  `parent_id` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set parent.',
  `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `level` int(10) unsigned NOT NULL COMMENT 'The cached level in the nested tree.',
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The unique name for the asset.\n',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The descriptive title for the asset.',
  `rules` varchar(5120) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded access control.'
) ENGINE=InnoDB AUTO_INCREMENT=371 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__assets`
--

INSERT INTO `#__assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES
(1, 0, 1, 614, 0, 'root.1', 'Root Asset', '{"core.login.site":{"6":1,"2":1},"core.login.admin":{"6":1},"core.login.offline":[],"core.admin":{"8":1},"core.manage":{"7":1},"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(2, 1, 2, 3, 1, 'com_admin', 'com_admin', '{}'),
(3, 1, 4, 23, 1, 'com_banners', 'com_banners', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(4, 1, 24, 25, 1, 'com_cache', 'com_cache', '{"core.admin":{"7":1},"core.manage":{"7":1}}'),
(5, 1, 26, 27, 1, 'com_checkin', 'com_checkin', '{"core.admin":{"7":1},"core.manage":{"7":1}}'),
(6, 1, 28, 29, 1, 'com_config', 'com_config', '{}'),
(7, 1, 30, 99, 1, 'com_contact', 'com_contact', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(8, 1, 100, 405, 1, 'com_content', 'com_content', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(9, 1, 406, 407, 1, 'com_cpanel', 'com_cpanel', '{}'),
(10, 1, 408, 409, 1, 'com_installer', 'com_installer', '{"core.admin":[],"core.manage":{"7":0},"core.delete":{"7":0},"core.edit.state":{"7":0}}'),
(11, 1, 410, 411, 1, 'com_languages', 'com_languages', '{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(12, 1, 412, 413, 1, 'com_login', 'com_login', '{}'),
(13, 1, 414, 415, 1, 'com_mailto', 'com_mailto', '{}'),
(14, 1, 416, 417, 1, 'com_massmail', 'com_massmail', '{}'),
(15, 1, 418, 419, 1, 'com_media', 'com_media', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":{"5":1},"core.edit":[],"core.edit.state":[]}'),
(16, 1, 420, 427, 1, 'com_menus', 'com_menus', '{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(17, 1, 49, 50, 1, 'com_messages', 'com_messages', '{"core.admin":{"7":1},"core.manage":{"7":1}}'),
(18, 1, 430, 499, 1, 'com_modules', 'com_modules', '{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(19, 1, 500, 507, 1, 'com_newsfeeds', 'com_newsfeeds', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(20, 1, 508, 509, 1, 'com_plugins', 'com_plugins', '{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(21, 1, 510, 511, 1, 'com_redirect', 'com_redirect', '{"core.admin":{"7":1},"core.manage":[]}'),
(22, 1, 512, 513, 1, 'com_search', 'com_search', '{"core.admin":{"7":1},"core.manage":{"6":1}}'),
(23, 1, 514, 515, 1, 'com_templates', 'com_templates', '{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(24, 1, 516, 519, 1, 'com_users', 'com_users', '{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(26, 1, 520, 521, 1, 'com_wrapper', 'com_wrapper', '{}'),
(33, 1, 582, 583, 1, 'com_finder', 'com_finder', '{"core.admin":{"7":1},"core.manage":{"6":1}}'),
(34, 8, 117, 120, 2, 'com_content.category.9', 'Uncategorised', '{"core.create":{"10":0,"12":0},"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(35, 3, 7, 8, 2, 'com_banners.category.10', 'Uncategorised', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(36, 7, 35, 36, 2, 'com_contact.category.11', 'Uncategorised', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(37, 19, 503, 504, 2, 'com_newsfeeds.category.12', 'Uncategorised', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(40, 3, 9, 10, 2, 'com_banners.category.15', 'Sample Data-Banners', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(41, 7, 37, 98, 2, 'com_contact.category.16', 'Sample Data-Contact', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(42, 19, 505, 506, 2, 'com_newsfeeds.category.17', 'Sample Data-Newsfeeds', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(44, 8, 123, 164, 2, 'com_content.category.19', 'Joomla!', '{"core.create":{"10":0,"12":0},"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(46, 44, 150, 163, 3, 'com_content.category.21', 'Components', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(59, 41, 38, 39, 3, 'com_contact.category.34', 'Park Site', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(60, 41, 40, 97, 3, 'com_contact.category.35', 'Shop Site', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(61, 60, 41, 42, 4, 'com_contact.category.36', 'Staff', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(62, 60, 43, 96, 4, 'com_contact.category.37', 'Fruit Encyclopedia', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(63, 62, 44, 45, 5, 'com_contact.category.38', 'A', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(64, 62, 46, 47, 5, 'com_contact.category.39', 'B', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(65, 62, 48, 49, 5, 'com_contact.category.40', 'C', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(66, 62, 50, 51, 5, 'com_contact.category.41', 'D', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(67, 62, 52, 53, 5, 'com_contact.category.42', 'E', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(68, 62, 54, 55, 5, 'com_contact.category.43', 'F', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(69, 62, 56, 57, 5, 'com_contact.category.44', 'G', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(70, 62, 58, 59, 5, 'com_contact.category.45', 'H', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(71, 62, 60, 61, 5, 'com_contact.category.46', 'I', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(72, 62, 62, 63, 5, 'com_contact.category.47', 'J', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(73, 62, 64, 65, 5, 'com_contact.category.48', 'K', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(74, 62, 66, 67, 5, 'com_contact.category.49', 'L', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(75, 62, 68, 69, 5, 'com_contact.category.50', 'M', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(76, 62, 70, 71, 5, 'com_contact.category.51', 'N', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(77, 62, 72, 73, 5, 'com_contact.category.52', 'O', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(78, 62, 74, 75, 5, 'com_contact.category.53', 'P', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(79, 62, 76, 77, 5, 'com_contact.category.54', 'Q', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(80, 62, 78, 79, 5, 'com_contact.category.55', 'R', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(81, 62, 80, 81, 5, 'com_contact.category.56', 'S', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(82, 62, 82, 83, 5, 'com_contact.category.57', 'T', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(83, 62, 84, 85, 5, 'com_contact.category.58', 'U', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(84, 62, 86, 87, 5, 'com_contact.category.59', 'V', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(85, 62, 88, 89, 5, 'com_contact.category.60', 'W', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(86, 62, 90, 91, 5, 'com_contact.category.61', 'X', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(87, 62, 92, 93, 5, 'com_contact.category.62', 'Y', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(88, 62, 94, 95, 5, 'com_contact.category.63', 'Z', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(89, 46, 151, 152, 4, 'com_content.article.1', 'Administrator Components', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(100, 44, 126, 127, 3, 'com_content.category.71', 'Milky Way', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(104, 44, 128, 129, 3, 'com_content.article.8', 'Beginners', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(105, 46, 153, 154, 4, 'com_content.article.9', 'Contact', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(106, 46, 155, 156, 4, 'com_content.article.10', 'Content', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(119, 44, 130, 131, 3, 'com_content.article.21', 'Getting Help', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(120, 44, 132, 133, 3, 'com_content.article.22', 'Getting Started', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(122, 44, 134, 135, 3, 'com_content.article.24', 'Joomla!', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(130, 44, 136, 137, 3, 'com_content.article.32', 'Parameters', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(133, 44, 138, 139, 3, 'com_content.article.35', 'Professionals', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(136, 44, 140, 141, 3, 'com_content.article.38', 'Sample Sites', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(137, 46, 157, 158, 4, 'com_content.article.39', 'Search', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(145, 44, 142, 143, 3, 'com_content.article.47', 'The Joomla! Community', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(146, 44, 144, 145, 3, 'com_content.article.48', 'The Joomla! Project', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(148, 44, 146, 147, 3, 'com_content.article.50', 'Upgraders', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(150, 46, 159, 160, 4, 'com_content.article.52', 'Users', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(151, 44, 148, 149, 3, 'com_content.article.53', 'Using Joomla!', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(158, 46, 161, 162, 4, 'com_content.article.60', 'News Feeds', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(168, 34, 118, 119, 3, 'com_content.article.67', 'What''s New in 1.5?', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(169, 24, 517, 518, 2, 'com_users.category.77', 'Uncategorised', ''),
(173, 1, 584, 585, 1, 'com_joomlaupdate', 'com_joomlaupdate', '{"core.admin":[],"core.manage":[],"core.delete":[],"core.edit.state":[]}'),
(175, 1, 586, 587, 1, 'com_tags', 'com_tags', '{"core.admin":{"8":1},"core.manage":{"7":1},"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(176, 1, 588, 589, 1, 'com_contenthistory', 'com_contenthistory', '{}'),
(177, 1, 590, 591, 1, 'com_ajax', 'com_ajax', '{}'),
(178, 1, 592, 593, 1, 'com_postinstall', 'com_postinstall', '{}'),
(179, 8, 165, 188, 2, 'com_content.category.79', 'Blog', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(180, 1, 594, 601, 1, 'com_sppagebuilder', 'sppagebuilder', '{}'),
(181, 18, 431, 432, 2, 'com_modules.module.91', 'SP Page Builder', ''),
(182, 18, 433, 434, 2, 'com_modules.module.92', 'SP Page Builder Admin Menu', ''),
(185, 18, 435, 436, 2, 'com_modules.module.17', 'Breadcrumbs', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(186, 18, 437, 438, 2, 'com_modules.module.35', 'Search', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(189, 18, 439, 440, 2, 'com_modules.module.96', 'Bottom menu', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(190, 18, 441, 442, 2, 'com_modules.module.97', 'Primary Menu', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(191, 179, 166, 167, 3, 'com_content.category.80', 'News', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(192, 179, 168, 169, 3, 'com_content.category.81', 'Tutorial', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(193, 179, 170, 171, 3, 'com_content.category.82', 'Review', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(194, 179, 172, 173, 3, 'com_content.category.83', 'Updates', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(195, 179, 174, 175, 3, 'com_content.article.71', 'Doner spare ribs pastrami shank', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(196, 179, 176, 177, 3, 'com_content.article.72', 'Jerky shank chicken boudin', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(197, 179, 178, 179, 3, 'com_content.article.73', 'Pellentesque Habitant Morbi Tristique', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(198, 179, 180, 181, 3, 'com_content.article.74', 'Meatball kevin beef ribs shoulder', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(199, 179, 182, 183, 3, 'com_content.article.75', '5 Effective Email Unsubscribe Pages', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(200, 179, 184, 185, 3, 'com_content.article.76', 'Who Actually Clicks on Banner Ads?', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(201, 179, 186, 187, 3, 'com_content.article.77', 'See the new Miss Universe get her crown', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(206, 18, 443, 444, 2, 'com_modules.module.102', 'Search', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(207, 18, 445, 446, 2, 'com_modules.module.103', 'Latest News', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(208, 18, 447, 448, 2, 'com_modules.module.104', 'Information', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(209, 18, 449, 450, 2, 'com_modules.module.105', 'Off Canvas Menu', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(213, 1, 602, 603, 1, 'com_fields', 'com_fields', '{}'),
(214, 1, 604, 605, 1, 'com_associations', 'com_associations', '{}'),
(215, 18, 451, 452, 2, 'com_modules.module.109', 'Social & newsletter', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(217, 18, 453, 454, 2, 'com_modules.module.111', 'Top Search', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(218, 18, 455, 456, 2, 'com_modules.module.112', 'Login', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(220, 16, 421, 422, 2, 'com_menus.menu.8', 'Bottom menu', '{}'),
(221, 16, 423, 424, 2, 'com_menus.menu.9', 'Quick Info', '{}'),
(222, 16, 425, 426, 2, 'com_menus.menu.11', 'Company', '{}'),
(223, 18, 457, 458, 2, 'com_modules.module.113', 'Company', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(224, 18, 459, 460, 2, 'com_modules.module.114', 'Quick Info', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(225, 8, 189, 404, 2, 'com_content.category.84', 'Newskit', '{}'),
(226, 225, 190, 215, 3, 'com_content.category.85', 'World', '{}'),
(227, 225, 216, 241, 3, 'com_content.category.86', 'Sport', '{}'),
(228, 225, 242, 243, 3, 'com_content.category.87', 'Football ', '{}'),
(229, 225, 244, 269, 3, 'com_content.category.88', 'Technology', '{}'),
(230, 225, 270, 295, 3, 'com_content.category.89', 'Culture', '{}'),
(231, 225, 296, 321, 3, 'com_content.category.90', 'Business', '{}'),
(232, 225, 322, 357, 3, 'com_content.category.91', 'Lifestyle', '{}'),
(233, 225, 358, 383, 3, 'com_content.category.92', 'Fashion', '{}'),
(234, 225, 384, 391, 3, 'com_content.category.93', 'Environment', '{}'),
(235, 226, 191, 192, 4, 'com_content.article.78', 'Nullam eros mi, mollis in sollicitudin non, tincidunt.', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(236, 3, 11, 12, 2, 'com_banners.category.94', 'Blog details ad', '{}'),
(237, 18, 461, 462, 2, 'com_modules.module.115', 'Blog details ad', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(238, 227, 217, 218, 4, 'com_content.article.79', 'Tongue kielbasa ribeye meatball pork loin andouille', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(239, 229, 245, 246, 4, 'com_content.article.80', 'Facebooks Guidance For Moderators Makes More ', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(240, 231, 297, 298, 4, 'com_content.article.81', 'Short ribs strip steak meatloaf, pig ribeye cow turkey', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(241, 230, 271, 272, 4, 'com_content.article.82', 'Not Recognize Shaq As Their Lyft are in Driver?', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(242, 227, 225, 226, 4, 'com_content.article.83', 'Pork loin ball tip bresaola, hamburger swine shoulder', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(244, 3, 13, 14, 2, 'com_banners.category.95', 'Home page ad', '{}'),
(245, 18, 463, 464, 2, 'com_modules.module.117', 'Home ad 1', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(246, 225, 392, 403, 3, 'com_content.category.96', 'Video', '{}'),
(247, 246, 393, 394, 4, 'com_content.article.84', 'Fatback sausage pork loin bresaola tail sirloin Bresaola.', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(248, 246, 395, 396, 4, 'com_content.article.85', 'Pork belly corned beef bacon turkey doner chuck bresaola.', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(249, 246, 397, 398, 4, 'com_content.article.86', 'Jancetta sausage brisket leberkas shoulder tri-tip short.', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(250, 246, 399, 400, 4, 'com_content.article.87', 'Ham frankfurter jerky, ground round burgdoggen ball tip.', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(251, 226, 193, 194, 4, 'com_content.article.88', 'Across London as armed police step up patrols', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(252, 226, 195, 196, 4, 'com_content.article.89', 'Ut at magna leo. Suspendisse egestas est ac dolor', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(253, 226, 197, 198, 4, 'com_content.article.90', 'The Activists: The University of Missouri Football Team', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(254, 226, 199, 200, 4, 'com_content.article.91', 'Cras semper consectetur elementum, Nulla vel.', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(255, 226, 201, 202, 4, 'com_content.article.92', 'The Newest McDonald''s Location Only Serves', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(258, 232, 323, 324, 4, 'com_content.article.95', 'Here''s Why the Head of Nike''s Basketball Business', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(259, 232, 325, 326, 4, 'com_content.article.96', 'Phasellus ac magna non augue porttitor scelerisque', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(260, 232, 327, 328, 4, 'com_content.article.97', 'Sed nunc orci sed, ultricies congue vehicula quis', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(261, 232, 329, 330, 4, 'com_content.article.98', 'Proin ornare ligula eu tellus tempus elementum', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(262, 232, 331, 332, 4, 'com_content.article.99', 'Facebooks Guidance For Moderators Makes More Sense ', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(263, 227, 223, 224, 4, 'com_content.article.100', 'Fusce a metus eu diam varius congue nec nec.', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(265, 232, 333, 334, 4, 'com_content.article.102', 'Will Smith''s Awesome Tonight Show Entrance', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(266, 232, 335, 336, 4, 'com_content.article.103', 'Etiam feugiat dolor ac elit suscipit in elementum.', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(267, 232, 337, 338, 4, 'com_content.article.104', 'Praesent tempus dictum nibh ac ullamcorper.', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(268, 227, 221, 222, 4, 'com_content.article.105', 'The Newest McDonald''s Location Only Serves', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(269, 227, 219, 220, 4, 'com_content.article.106', 'Proin tristique rhoncus orci, eget vulputate nisi', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(270, 1, 606, 607, 1, 'com_sppolls', 'SP Polls', '{}'),
(271, 18, 465, 466, 2, 'com_modules.module.118', 'People''s Poll', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(272, 3, 15, 16, 2, 'com_banners.category.97', 'Sidebar ad1', '{}'),
(273, 18, 467, 468, 2, 'com_modules.module.119', 'Sidebar ad1', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(274, 18, 469, 470, 2, 'com_modules.module.120', 'Popular Post', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(275, 1, 608, 609, 1, 'com_acymailing', 'AcyMailing', '{}'),
(276, 18, 471, 472, 2, 'com_modules.module.121', 'Subscribe Our Newsletter ', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(277, 230, 273, 274, 4, 'com_content.article.107', 'Voicemail transcription  in Google Voice is getting better', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(278, 230, 275, 276, 4, 'com_content.article.108', 'Vestibulum ac leo vitae metus faucibus gravida.', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(279, 229, 247, 248, 4, 'com_content.article.109', 'Far far away, behind the word mountains', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(280, 229, 249, 250, 4, 'com_content.article.110', 'The European languages are members of the same family', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(281, 229, 251, 252, 4, 'com_content.article.111', 'But I must explain to you how all this mistaken idea', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(282, 231, 299, 300, 4, 'com_content.article.112', 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(283, 231, 301, 302, 4, 'com_content.article.113', 'One morning, when Gregor Samsa woke from troubled', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(284, 233, 359, 360, 4, 'com_content.article.114', 'I should be incapable of drawing a single stroke', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(285, 233, 361, 362, 4, 'com_content.article.115', 'I throw myself down among the tall grass by the trickling', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(286, 233, 363, 364, 4, 'com_content.article.116', 'I hear the buzz of the little world among the stalks', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(287, 234, 385, 386, 4, 'com_content.article.117', 'Everyone realizes why a new common language', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(288, 234, 387, 388, 4, 'com_content.article.118', 'If several languages coalesce, the grammar', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(289, 234, 389, 390, 4, 'com_content.article.119', 'Europe uses the same vocabulary', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(290, 18, 473, 474, 2, 'com_modules.module.122', 'Subscribe Our Newsletter', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(291, 18, 475, 476, 2, 'com_modules.module.123', 'Sidebar ad1', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(292, 18, 477, 478, 2, 'com_modules.module.124', 'Popular Post', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(293, 226, 203, 204, 4, 'com_content.article.120', 'Morbi rhoncus, sem laoreet tempus pulvinar leo ', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(294, 226, 205, 206, 4, 'com_content.article.121', 'Nunc sed ligula sed augue rutrum ultrices eget', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(295, 226, 207, 208, 4, 'com_content.article.122', 'Quisque iaculis ligula ut ipsum mattis viverra', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(296, 226, 209, 210, 4, 'com_content.article.123', 'Mauris molestie augue sed nunc adipiscing', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(297, 226, 211, 212, 4, 'com_content.article.124', 'Mauris elit velit, lobortis sed interdum at vestibulum', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(298, 226, 213, 214, 4, 'com_content.article.125', 'Phasellus ac magna non augue porttitor scelerisque', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(299, 3, 17, 18, 2, 'com_banners.category.98', 'Blog list ad', '{}'),
(300, 18, 479, 480, 2, 'com_modules.module.125', 'Bloglist ad', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(301, 18, 481, 482, 2, 'com_modules.module.126', 'Bloglist bottom ad', '{}'),
(302, 18, 483, 484, 2, 'com_modules.module.127', 'Follow Us', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(303, 3, 19, 20, 2, 'com_banners.category.99', 'Hero section ad', '{}'),
(304, 18, 485, 486, 2, 'com_modules.module.128', 'Hero section ad', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(306, 246, 401, 402, 4, 'com_content.article.127', 'Pancetta sausage brisket leberkas shoulder tri-tip short.', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(308, 18, 487, 488, 2, 'com_modules.module.130', 'SP Tabbed Articles', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(309, 18, 489, 490, 2, 'com_modules.module.131', 'Newsletter', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(310, 18, 491, 492, 2, 'com_modules.module.132', 'Contact Us', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(311, 1, 610, 611, 1, '#__ucm_content.1', '#__ucm_content.1', '[]'),
(312, 3, 21, 22, 2, 'com_banners.category.100', 'Home-Variation-2-Ad', '{}'),
(313, 18, 493, 494, 2, 'com_modules.module.133', 'Home-Variation-2-Ad', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(314, 18, 495, 496, 2, 'com_modules.module.134', 'My Account', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(315, 227, 227, 228, 4, 'com_content.article.128', 'Nisi proin tristique rhoncus orci, eget vulputate.', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(316, 227, 229, 230, 4, 'com_content.article.129', 'Newest McDonald''s Location Only Serves', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(317, 227, 231, 232, 4, 'com_content.article.130', 'Azusce a metus eu diam varius congue nec', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(318, 227, 233, 234, 4, 'com_content.article.131', 'Nam porttitor, erat sit amet venenatis luctus, augue.', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(319, 227, 235, 236, 4, 'com_content.article.132', 'Ut at magna leo. Suspendisse egestas est.', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(320, 227, 237, 238, 4, 'com_content.article.133', 'Vestibulum eget felis nec purus commodo convallis.', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(321, 227, 239, 240, 4, 'com_content.article.134', 'Cras semper consectetur elementum Nulla vel.', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(322, 229, 253, 254, 4, 'com_content.article.135', 'Proin suscipit luctus orci placerat fringilla Donec. ', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(323, 229, 255, 256, 4, 'com_content.article.136', 'Suscipit luctus orci placerat fringilla Donec Sodf', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(324, 229, 257, 258, 4, 'com_content.article.137', 'Luctus Proin suscipit orci placerat fringilla Donec.', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(325, 229, 259, 260, 4, 'com_content.article.138', 'Fringilla Proin suscipit luctus orci placerat  Donec. ', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(326, 229, 261, 262, 4, 'com_content.article.139', 'Proin suscipit luctus orci placerat fringilla Cho Donec.', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(327, 229, 263, 264, 4, 'com_content.article.140', 'Orci Proin suscipit luctus placerat fringilla Donec.', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(328, 229, 265, 266, 4, 'com_content.article.141', 'volutpat suscipit luctus orci placerat fringilla Donec.', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(329, 229, 267, 268, 4, 'com_content.article.142', 'Vivamus vel  luctus orci placerat fringilla Donec.', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(330, 230, 277, 278, 4, 'com_content.article.143', 'But I must explain to you how all this mistaken idea', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(331, 230, 279, 280, 4, 'com_content.article.144', 'Proin suscipit luctus orci placerat fringilla Donec. ', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(332, 230, 281, 282, 4, 'com_content.article.145', 'Suscipit luctus orci placerat fringilla Donec Sodf', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(333, 230, 283, 284, 4, 'com_content.article.146', 'Luctus Proin suscipit orci placerat fringilla Donec.', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(334, 230, 285, 286, 4, 'com_content.article.147', 'Fringilla Proin suscipit luctus orci placerat  Donec. ', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(335, 230, 287, 288, 4, 'com_content.article.148', 'Proin suscipit luctus orci placerat fringilla Cho Donec.', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(336, 230, 289, 290, 4, 'com_content.article.149', 'Orci Proin suscipit luctus placerat fringilla Donec.', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(337, 230, 291, 292, 4, 'com_content.article.150', 'volutpat suscipit luctus orci placerat fringilla Donec.', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(338, 230, 293, 294, 4, 'com_content.article.151', 'Vivamus vel  luctus orci placerat fringilla Donec.', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(339, 231, 303, 304, 4, 'com_content.article.152', 'But I must explain to you how all this mistaken idea', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(340, 231, 305, 306, 4, 'com_content.article.153', 'Proin suscipit luctus orci placerat fringilla Donec. ', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(341, 231, 307, 308, 4, 'com_content.article.154', 'Suscipit luctus orci placerat fringilla Donec Sodf', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(342, 231, 309, 310, 4, 'com_content.article.155', 'Luctus Proin suscipit orci placerat fringilla Donec.', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(343, 231, 311, 312, 4, 'com_content.article.156', 'Fringilla Proin suscipit luctus orci placerat  Donec. ', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(344, 231, 313, 314, 4, 'com_content.article.157', 'Proin suscipit luctus orci placerat fringilla Cho Donec.', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(345, 231, 315, 316, 4, 'com_content.article.158', 'Orci Proin suscipit luctus placerat fringilla Donec.', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(346, 231, 317, 318, 4, 'com_content.article.159', 'volutpat suscipit luctus orci placerat fringilla Donec.', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(347, 231, 319, 320, 4, 'com_content.article.160', 'Vivamus vel  luctus orci placerat fringilla Donec.', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(348, 232, 339, 340, 4, 'com_content.article.161', 'But I must explain to you how all this mistaken idea', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(349, 232, 341, 342, 4, 'com_content.article.162', 'Proin suscipit luctus orci placerat fringilla Donec. ', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(350, 232, 343, 344, 4, 'com_content.article.163', 'Suscipit luctus orci placerat fringilla Donec Sodf', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(351, 232, 345, 346, 4, 'com_content.article.164', 'Luctus Proin suscipit orci placerat fringilla Donec.', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(352, 232, 347, 348, 4, 'com_content.article.165', 'Fringilla Proin suscipit luctus orci placerat  Donec. ', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(353, 232, 349, 350, 4, 'com_content.article.166', 'Proin suscipit luctus orci placerat fringilla Cho Donec.', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(354, 232, 351, 352, 4, 'com_content.article.167', 'Orci Proin suscipit luctus placerat fringilla Donec.', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(355, 232, 353, 354, 4, 'com_content.article.168', 'volutpat suscipit luctus orci placerat fringilla Donec.', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(356, 232, 355, 356, 4, 'com_content.article.169', 'Vivamus vel  luctus orci placerat fringilla Donec.', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(357, 233, 365, 366, 4, 'com_content.article.170', 'But I must explain to you how all this mistaken idea', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(358, 233, 367, 368, 4, 'com_content.article.171', 'Proin suscipit luctus orci placerat fringilla Donec. ', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(359, 233, 369, 370, 4, 'com_content.article.172', 'Suscipit luctus orci placerat fringilla Donec Sodf', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(360, 233, 371, 372, 4, 'com_content.article.173', 'Luctus Proin suscipit orci placerat fringilla Donec.', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(361, 233, 373, 374, 4, 'com_content.article.174', 'Fringilla Proin suscipit luctus orci placerat  Donec. ', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(362, 233, 375, 376, 4, 'com_content.article.175', 'Proin suscipit luctus orci placerat fringilla Cho Donec.', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(363, 233, 377, 378, 4, 'com_content.article.176', 'Orci Proin suscipit luctus placerat fringilla Donec.', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(364, 233, 379, 380, 4, 'com_content.article.177', 'volutpat suscipit luctus orci placerat fringilla Donec.', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(365, 233, 381, 382, 4, 'com_content.article.178', 'Vivamus vel  luctus orci placerat fringilla Donec.', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(366, 1, 612, 613, 1, '#__languages.2', '#__languages.2', '{}'),
(367, 180, 595, 596, 2, 'com_sppagebuilder.page.56', 'Contact', '{}'),
(368, 180, 597, 598, 2, 'com_sppagebuilder.page.1', 'Home', '{}'),
(369, 18, 497, 498, 2, 'com_modules.module.135', 'SP Tweet', '{}'),
(370, 180, 599, 600, 2, 'com_sppagebuilder.page.46', 'Home Variation - 2', '{}');

-- --------------------------------------------------------

--
-- Table structure for table `#__associations`
--

DROP TABLE IF EXISTS `#__associations`;
CREATE TABLE `#__associations` (
  `id` int(11) NOT NULL COMMENT 'A reference to the associated item.',
  `context` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The context of the associated item.',
  `key` char(32) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The key for the association computed from an md5 on associated ids.'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__banners`
--

DROP TABLE IF EXISTS `#__banners`;
CREATE TABLE `#__banners` (
  `id` int(11) NOT NULL,
  `cid` int(11) NOT NULL DEFAULT '0',
  `type` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `imptotal` int(11) NOT NULL DEFAULT '0',
  `impmade` int(11) NOT NULL DEFAULT '0',
  `clicks` int(11) NOT NULL DEFAULT '0',
  `clickurl` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `catid` int(10) unsigned NOT NULL DEFAULT '0',
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `custombannercode` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sticky` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `own_prefix` tinyint(1) NOT NULL DEFAULT '0',
  `metakey_prefix` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `purchase_type` tinyint(4) NOT NULL DEFAULT '-1',
  `track_clicks` tinyint(4) NOT NULL DEFAULT '-1',
  `track_impressions` tinyint(4) NOT NULL DEFAULT '-1',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `reset` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `version` int(10) unsigned NOT NULL DEFAULT '1'
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__banners`
--

INSERT INTO `#__banners` (`id`, `cid`, `type`, `name`, `alias`, `imptotal`, `impmade`, `clicks`, `clickurl`, `state`, `catid`, `description`, `custombannercode`, `sticky`, `ordering`, `metakey`, `params`, `own_prefix`, `metakey_prefix`, `purchase_type`, `track_clicks`, `track_impressions`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `reset`, `created`, `language`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `version`) VALUES
(2, 3, 0, 'Shop 1', 'shop-1', 0, 0, 0, 'http://shop.joomla.org/amazoncom-bookstores.html', 1, 15, 'Get books about Joomla! at the Joomla! Book Shop.', '', 0, 1, '', '{"imageurl":"images\\/banners\\/white.png","width":"","height":"","alt":"Joomla! Books"}', 0, '', -1, 0, 0, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2017-11-30 08:02:42', 'en-GB', 343, 'Joomla', '0000-00-00 00:00:00', 0, 1),
(3, 2, 0, 'Shop 2', 'shop-2', 0, 0, 0, 'http://shop.joomla.org', 1, 15, 'T Shirts, caps and more from the Joomla! Shop.', '', 0, 2, '', '{"imageurl":"images\\/banners\\/white.png","width":"","height":"","alt":"Joomla! Shop"}', 0, '', -1, 0, 0, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2017-11-30 08:02:42', 'en-GB', 343, 'Joomla', '0000-00-00 00:00:00', 0, 1),
(4, 1, 0, 'Support Joomla!', 'support-joomla', 0, 0, 0, 'http://contribute.joomla.org', 1, 15, 'Your contributions of time, talent and money make Joomla possible.', '', 0, 3, '', '{"imageurl":"images\\/banners\\/white.png","width":"","height":"","alt":""}', 0, '', -1, 0, 0, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2017-11-30 08:02:42', 'en-GB', 343, 'Joomla', '0000-00-00 00:00:00', 0, 1),
(5, 4, 0, 'Blog Details ad', 'blog-details-ad', 0, 319, 0, 'javascript:void(0);', 1, 94, '', '', 0, 4, '', '{"imageurl":"images\\/banners\\/blog-details-ad.jpg","width":"","height":"","alt":""}', 0, '', -1, 1, 1, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2017-11-30 08:02:42', '2017-11-30 08:02:42', '*', 343, '', '2017-11-30 08:02:42', 343, 3),
(6, 4, 0, 'Home ad 1', 'home-ad-1', 0, 8743, 3, 'javascript:void(0);', 1, 95, '', '', 0, 5, '', '{"imageurl":"images\\/banners\\/home-ad1.jpg","width":"","height":"","alt":""}', 0, '', -1, 1, 1, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2017-11-30 08:02:42', '2017-11-30 08:02:42', '*', 343, '', '2017-11-30 08:02:42', 343, 2),
(7, 4, 0, 'Sidebar ad1', 'sidebar-ad1', 0, 5679, 1, 'javascript:void(0);', 1, 97, '', '', 0, 6, '', '{"imageurl":"images\\/banners\\/sidebar-ad1.jpg","width":"","height":"","alt":""}', 0, '', -1, 1, 1, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2017-11-30 08:02:42', '2017-11-30 08:02:42', '*', 343, '', '0000-00-00 00:00:00', 0, 1),
(8, 4, 0, 'Blog list ad', 'blog-list-ad', 0, 607, 0, '', 1, 98, '', '', 0, 7, '', '{"imageurl":"images\\/banners\\/blog-category-ad.jpg","width":"","height":"","alt":""}', 0, '', -1, 0, 0, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2017-11-30 08:02:42', '2017-11-30 08:02:42', '*', 343, '', '2017-11-30 08:02:42', 343, 3),
(9, 4, 0, 'Hero Section ad', 'hero-section-ad', 0, 2358, 1, 'javascript:void(0);', 1, 99, '', '', 0, 8, '', '{"imageurl":"images\\/banners\\/hero-section-ad.jpg","width":"","height":"","alt":""}', 0, '', -1, 0, 0, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2017-11-30 08:02:42', '2017-11-30 08:02:42', '*', 343, '', '2017-11-30 08:02:42', 343, 2),
(10, 4, 0, 'Home-2-ad', 'home-2-ad', 0, 565, 0, 'javascript:void(0);', 1, 100, '', '', 0, 9, '', '{"imageurl":"images\\/banners\\/variation-2-left-sidebar-add.jpg","width":"","height":"","alt":""}', 0, '', -1, 0, 0, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2017-11-30 08:02:42', '2017-11-30 08:02:42', '*', 343, '', '2017-11-30 08:02:42', 343, 2);

-- --------------------------------------------------------

--
-- Table structure for table `#__banner_clients`
--

DROP TABLE IF EXISTS `#__banner_clients`;
CREATE TABLE `#__banner_clients` (
  `id` int(11) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `contact` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extrainfo` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `own_prefix` tinyint(4) NOT NULL DEFAULT '0',
  `metakey_prefix` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `purchase_type` tinyint(4) NOT NULL DEFAULT '-1',
  `track_clicks` tinyint(4) NOT NULL DEFAULT '-1',
  `track_impressions` tinyint(4) NOT NULL DEFAULT '-1'
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__banner_clients`
--

INSERT INTO `#__banner_clients` (`id`, `name`, `contact`, `email`, `extrainfo`, `state`, `checked_out`, `checked_out_time`, `metakey`, `own_prefix`, `metakey_prefix`, `purchase_type`, `track_clicks`, `track_impressions`) VALUES
(1, 'Joomla!', 'Administrator', 'email@email.com', '', 1, 0, '0000-00-00 00:00:00', '', 0, '', -1, -1, -1),
(2, 'Shop', 'Example', 'example@example.com', '', 1, 0, '0000-00-00 00:00:00', '', 0, '', -1, 0, 0),
(3, 'Bookstore', 'Bookstore Example', 'example@example.com', '', 1, 0, '0000-00-00 00:00:00', '', 0, '', -1, 0, 0),
(4, 'Joomshaper', 'Joomshaper', 'install@joomshaper.com', '', 1, 0, '0000-00-00 00:00:00', '', 0, '', -1, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `#__banner_tracks`
--

DROP TABLE IF EXISTS `#__banner_tracks`;
CREATE TABLE `#__banner_tracks` (
  `track_date` datetime NOT NULL,
  `track_type` int(10) unsigned NOT NULL,
  `banner_id` int(10) unsigned NOT NULL,
  `count` int(10) unsigned NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__categories`
--

DROP TABLE IF EXISTS `#__categories`;
CREATE TABLE `#__categories` (
  `id` int(11) NOT NULL,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `lft` int(11) NOT NULL DEFAULT '0',
  `rgt` int(11) NOT NULL DEFAULT '0',
  `level` int(10) unsigned NOT NULL DEFAULT '0',
  `path` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extension` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'The meta keywords for the page.',
  `metadata` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `version` int(10) unsigned NOT NULL DEFAULT '1'
) ENGINE=InnoDB AUTO_INCREMENT=101 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__categories`
--

INSERT INTO `#__categories` (`id`, `asset_id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `extension`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `modified_user_id`, `modified_time`, `hits`, `language`, `version`) VALUES
(1, 0, 0, 0, 125, 0, '', 'system', 'ROOT', 'root', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{}', '', '', '', 343, '2017-11-30 08:02:42', 0, '0000-00-00 00:00:00', 0, '*', 1),
(9, 34, 1, 5, 6, 1, 'uncategorised', 'com_content', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '0000-00-00 00:00:00', 0, '*', 1),
(10, 35, 1, 77, 78, 1, 'uncategorised', 'com_banners', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":"","foobar":""}', '', '', '{"page_title":"","author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '0000-00-00 00:00:00', 0, '*', 1),
(11, 36, 1, 73, 74, 1, 'uncategorised', 'com_contact', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '0000-00-00 00:00:00', 0, '*', 1),
(12, 37, 1, 9, 10, 1, 'uncategorised', 'com_newsfeeds', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '0000-00-00 00:00:00', 0, '*', 1),
(15, 40, 1, 75, 76, 1, 'sample-data-banners', 'com_banners', 'Sample Data-Banners', 'sample-data-banners', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":"","foobar":""}', '', '', '{"page_title":"","author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '0000-00-00 00:00:00', 0, '*', 1),
(16, 41, 1, 11, 72, 1, 'sample-data-contact', 'com_contact', 'Sample Data-Contact', 'sample-data-contact', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '0000-00-00 00:00:00', 0, '*', 1),
(17, 42, 1, 7, 8, 1, 'sample-data-newsfeeds', 'com_newsfeeds', 'Sample Data-Newsfeeds', 'sample-data-newsfeeds', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '0000-00-00 00:00:00', 0, '*', 1),
(19, 44, 1, 1, 4, 1, 'joomla', 'com_content', 'Joomla!', 'joomla', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 343, '2017-11-30 08:02:42', 343, '2017-11-30 08:02:42', 0, '*', 1),
(21, 46, 19, 2, 3, 2, 'joomla/components', 'com_content', 'Components', 'components', '', '<p>Components are larger extensions that produce the major content for your site. Each component has one or more "views" that control how content is displayed. In the Joomla administrator there are additional extensions such as Menus, Redirection, and the extension managers.</p>', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 343, '2017-11-30 08:02:42', 343, '2017-11-30 08:02:42', 0, '*', 1),
(34, 59, 16, 12, 13, 2, 'sample-data-contact/park-site', 'com_contact', 'Park Site', 'park-site', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '0000-00-00 00:00:00', 0, 'en-GB', 1),
(35, 60, 16, 14, 71, 2, 'sample-data-contact/shop-site', 'com_contact', 'Shop Site', 'shop-site', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '0000-00-00 00:00:00', 0, '*', 1),
(36, 61, 35, 15, 16, 3, 'sample-data-contact/shop-site/staff', 'com_contact', 'Staff', 'staff', '', '<p>Please feel free to contact our staff at any time should you need assistance.</p>', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '0000-00-00 00:00:00', 0, '*', 1),
(37, 62, 35, 17, 70, 3, 'sample-data-contact/shop-site/fruit-encyclopedia', 'com_contact', 'Fruit Encyclopedia', 'fruit-encyclopedia', '', '<p> </p><p>Our directory of information about different kinds of fruit.</p><p>We love fruit and want the world to know more about all of its many varieties.</p><p>Although it is small now, we work on it whenever we have a chance.</p><p>All of the images can be found in <a href="http://commons.wikimedia.org/wiki/Main_Page">Wikimedia Commons</a>.</p><p><img src="images/sampledata/fruitshop/apple.jpg" border="0" alt="Apples" title="Apples" /></p><p><em>This encyclopedia is implemented using the contact component, each fruit a separate contact and a category for each letter. A CSS style is used to create the horizontal layout of the alphabet headings. </em></p><p><em>If you wanted to, you could allow some users (such as your growers) to have access to just this category in the contact component and let them help you to create new content for the encyclopedia.</em></p><p> </p>', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '0000-00-00 00:00:00', 0, '*', 1),
(38, 63, 37, 18, 19, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/a', 'com_contact', 'A', 'a', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '0000-00-00 00:00:00', 0, '*', 1),
(39, 64, 37, 20, 21, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/b', 'com_contact', 'B', 'b', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '0000-00-00 00:00:00', 0, '*', 1),
(40, 65, 37, 22, 23, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/c', 'com_contact', 'C', 'c', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '0000-00-00 00:00:00', 0, '*', 1),
(41, 66, 37, 24, 25, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/d', 'com_contact', 'D', 'd', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '0000-00-00 00:00:00', 0, '*', 1),
(42, 67, 37, 26, 27, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/e', 'com_contact', 'E', 'e', '', '', 0, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '0000-00-00 00:00:00', 0, '*', 1),
(43, 68, 37, 28, 29, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/f', 'com_contact', 'F', 'f', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '0000-00-00 00:00:00', 0, '*', 1),
(44, 69, 37, 30, 31, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/g', 'com_contact', 'G', 'g', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '0000-00-00 00:00:00', 0, '*', 1),
(45, 70, 37, 32, 33, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/h', 'com_contact', 'H', 'h', '', '', 0, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '0000-00-00 00:00:00', 0, '*', 1),
(46, 71, 37, 34, 35, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/i', 'com_contact', 'I', 'i', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '0000-00-00 00:00:00', 0, '*', 1),
(47, 72, 37, 36, 37, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/j', 'com_contact', 'J', 'j', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '0000-00-00 00:00:00', 0, '*', 1),
(48, 73, 37, 38, 39, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/k', 'com_contact', 'K', 'k', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '0000-00-00 00:00:00', 0, '*', 1),
(49, 74, 37, 40, 41, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/l', 'com_contact', 'L', 'l', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '0000-00-00 00:00:00', 0, '*', 1),
(50, 75, 37, 42, 43, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/m', 'com_contact', 'M', 'm', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '0000-00-00 00:00:00', 0, '*', 1),
(51, 76, 37, 44, 45, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/n', 'com_contact', 'N', 'n', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '0000-00-00 00:00:00', 0, '*', 1),
(52, 77, 37, 46, 47, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/o', 'com_contact', 'O', 'o', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '0000-00-00 00:00:00', 0, '*', 1),
(53, 78, 37, 48, 49, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/p', 'com_contact', 'P', 'p', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '0000-00-00 00:00:00', 0, '*', 1),
(54, 79, 37, 50, 51, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/q', 'com_contact', 'Q', 'q', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '0000-00-00 00:00:00', 0, '*', 1),
(55, 80, 37, 52, 53, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/r', 'com_contact', 'R', 'r', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '0000-00-00 00:00:00', 0, '*', 1),
(56, 81, 37, 54, 55, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/s', 'com_contact', 'S', 's', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '0000-00-00 00:00:00', 0, '*', 1),
(57, 82, 37, 56, 57, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/t', 'com_contact', 'T', 't', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '0000-00-00 00:00:00', 0, '*', 1),
(58, 83, 37, 58, 59, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/u', 'com_contact', 'U', 'u', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '0000-00-00 00:00:00', 0, '*', 1),
(59, 84, 37, 60, 61, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/v', 'com_contact', 'V', 'v', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '0000-00-00 00:00:00', 0, '*', 1),
(60, 85, 37, 62, 63, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/w', 'com_contact', 'W', 'w', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '0000-00-00 00:00:00', 0, '*', 1),
(61, 86, 37, 64, 65, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/x', 'com_contact', 'X', 'x', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '0000-00-00 00:00:00', 0, '*', 1),
(62, 87, 37, 66, 67, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/y', 'com_contact', 'Y', 'y', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '0000-00-00 00:00:00', 0, '*', 1),
(63, 88, 37, 68, 69, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/z', 'com_contact', 'Z', 'z', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '0000-00-00 00:00:00', 0, '*', 1),
(77, 169, 1, 79, 80, 1, 'uncategorised', 'com_users', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '0000-00-00 00:00:00', 0, '*', 1),
(79, 179, 1, 81, 90, 1, 'blog', 'com_content', 'Blog', 'blog', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '0000-00-00 00:00:00', 0, '*', 1),
(80, 191, 79, 82, 83, 2, 'blog/news', 'com_content', 'News', 'news', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 343, '2017-11-30 08:02:42', 343, '2017-11-30 08:02:42', 0, '*', 1),
(81, 192, 79, 84, 85, 2, 'blog/tutorial', 'com_content', 'Tutorial', 'tutorial', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '0000-00-00 00:00:00', 0, '*', 1),
(82, 193, 79, 86, 87, 2, 'blog/review', 'com_content', 'Review', 'review', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '0000-00-00 00:00:00', 0, '*', 1),
(83, 194, 79, 88, 89, 2, 'blog/updates', 'com_content', 'Updates', 'updates', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '0000-00-00 00:00:00', 0, '*', 1),
(84, 225, 1, 91, 112, 1, 'newskit', 'com_content', 'Newskit', 'newskit', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":"","image_alt":""}', '', '', '{"author":"","robots":""}', 343, '2017-11-30 08:02:42', 343, '2017-11-30 08:02:42', 0, '*', 1),
(85, 226, 84, 92, 93, 2, 'newskit/world', 'com_content', 'World', 'world', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":"","image_alt":""}', '', '', '{"author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '2017-11-30 08:02:42', 0, '*', 1),
(86, 227, 84, 94, 95, 2, 'newskit/sport', 'com_content', 'Sport', 'sport', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":"","image_alt":""}', '', '', '{"author":"","robots":""}', 343, '2017-11-30 08:02:42', 343, '2017-11-30 08:02:42', 0, '*', 1),
(87, 228, 84, 96, 97, 2, 'newskit/football', 'com_content', 'Football ', 'football', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":"","image_alt":""}', '', '', '{"author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '2017-11-30 08:02:42', 0, '*', 1),
(88, 229, 84, 98, 99, 2, 'newskit/technology', 'com_content', 'Technology', 'technology', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":"","image_alt":""}', '', '', '{"author":"","robots":""}', 343, '2017-11-30 08:02:42', 343, '2017-11-30 08:02:42', 0, '*', 1),
(89, 230, 84, 100, 101, 2, 'newskit/culture', 'com_content', 'Culture', 'culture', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":"","image_alt":""}', '', '', '{"author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '2017-11-30 08:02:42', 0, '*', 1),
(90, 231, 84, 102, 103, 2, 'newskit/business', 'com_content', 'Business', 'business', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":"","image_alt":""}', '', '', '{"author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '2017-11-30 08:02:42', 0, '*', 1),
(91, 232, 84, 104, 105, 2, 'newskit/lifestyle', 'com_content', 'Lifestyle', 'lifestyle', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":"","image_alt":""}', '', '', '{"author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '2017-11-30 08:02:42', 0, '*', 1),
(92, 233, 84, 106, 107, 2, 'newskit/fashion', 'com_content', 'Fashion', 'fashion', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":"","image_alt":""}', '', '', '{"author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '2017-11-30 08:02:42', 0, '*', 1),
(93, 234, 84, 108, 109, 2, 'newskit/environment', 'com_content', 'Environment', 'environment', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":"","image_alt":""}', '', '', '{"author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '2017-11-30 08:02:42', 0, '*', 1),
(94, 236, 1, 113, 114, 1, 'blog-details-ad', 'com_banners', 'Blog details ad', 'blog-details-ad', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":"","image_alt":""}', '', '', '{"author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '2017-11-30 08:02:42', 0, '*', 1),
(95, 244, 1, 115, 116, 1, 'home-page-ad', 'com_banners', 'Home page ad', 'home-page-ad', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":"","image_alt":""}', '', '', '{"author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '2017-11-30 08:02:42', 0, '*', 1),
(96, 246, 84, 110, 111, 2, 'newskit/video', 'com_content', 'Video', 'video', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":"","image_alt":""}', '', '', '{"author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '2017-11-30 08:02:42', 0, '*', 1),
(97, 272, 1, 117, 118, 1, 'sidebar-ad1', 'com_banners', 'Sidebar ad1', 'sidebar-ad1', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":"","image_alt":""}', '', '', '{"author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '2017-11-30 08:02:42', 0, '*', 1),
(98, 299, 1, 119, 120, 1, 'blog-list-ad', 'com_banners', 'Blog list ad', 'blog-list-ad', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":"","image_alt":""}', '', '', '{"author":"","robots":""}', 343, '2017-11-30 08:02:42', 343, '2017-11-30 08:02:42', 0, '*', 1),
(99, 303, 1, 121, 122, 1, 'hero-section-ad', 'com_banners', 'Hero section ad', 'hero-section-ad', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":"","image_alt":""}', '', '', '{"author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '2017-11-30 08:02:42', 0, '*', 1),
(100, 312, 1, 123, 124, 1, 'home-variation-2-ad', 'com_banners', 'Home-Variation-2-Ad', 'home-variation-2-ad', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":"","image_alt":""}', '', '', '{"author":"","robots":""}', 343, '2017-11-30 08:02:42', 0, '2017-11-30 08:02:42', 0, '*', 1);

-- --------------------------------------------------------

--
-- Table structure for table `#__contact_details`
--

DROP TABLE IF EXISTS `#__contact_details`;
CREATE TABLE `#__contact_details` (
  `id` int(11) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `con_position` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` mediumtext COLLATE utf8mb4_unicode_ci,
  `suburb` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `postcode` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telephone` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fax` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `misc` longtext COLLATE utf8mb4_unicode_ci,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_to` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `default_con` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `catid` int(11) NOT NULL DEFAULT '0',
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `mobile` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `webpage` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname1` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname2` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname3` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `language` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `featured` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',
  `xreference` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'A reference to enable linkages to external data sets.',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  `hits` int(10) unsigned NOT NULL DEFAULT '0'
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__contact_details`
--

INSERT INTO `#__contact_details` (`id`, `name`, `alias`, `con_position`, `address`, `suburb`, `state`, `country`, `postcode`, `telephone`, `fax`, `misc`, `image`, `email_to`, `default_con`, `published`, `checked_out`, `checked_out_time`, `ordering`, `params`, `user_id`, `catid`, `access`, `mobile`, `webpage`, `sortname1`, `sortname2`, `sortname3`, `language`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `metakey`, `metadesc`, `metadata`, `featured`, `xreference`, `publish_up`, `publish_down`, `version`, `hits`) VALUES
(1, 'Contact Name Here', 'name', 'Position', 'Street Address', 'Suburb', 'State', 'Country', 'Zip Code', 'Telephone', 'Fax', '<p>Information about or by the contact.</p>', 'images/powered_by.png', 'email@example.com', 1, 1, 0, '0000-00-00 00:00:00', 1, '{"show_contact_category":"","show_contact_list":"","presentation_style":"","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_profile":"","show_links":"1","linka_name":"Twitter","linka":"http:\\/\\/twitter.com\\/joomla","linkb_name":"YouTube","linkb":"http:\\/\\/www.youtube.com\\/user\\/joomla","linkc_name":"Facebook","linkc":"http:\\/\\/www.facebook.com\\/joomla","linkd_name":"FriendFeed","linkd":"http:\\/\\/friendfeed.com\\/joomla","linke_name":"Scribed","linke":"http:\\/\\/www.scribd.com\\/people\\/view\\/504592-joomla","contact_layout":"","show_email_form":"","show_email_copy":"","banned_email":"","banned_subject":"","banned_text":"","validate_session":"","custom_reply":"","redirect":""}', 0, 16, 1, '', '', 'last', 'first', 'middle', 'en-GB', '2017-11-30 08:02:42', 343, 'Joomla', '0000-00-00 00:00:00', 0, '', '', '{"robots":"","rights":""}', 1, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 11),
(2, 'Webmaster', 'webmaster', '', '', '', '', '', '', '', '', '', '', 'webmaster@example.com', 0, 1, 0, '0000-00-00 00:00:00', 1, '{"show_contact_category":"","show_contact_list":"","presentation_style":"","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_profile":"","show_links":"","linka_name":"","linka":"","linkb_name":"","linkb":"","linkc_name":"","linkc":"","linkd_name":"","linkd":"","linke_name":"","linke":"","show_email_form":"1","show_email_copy":"1","banned_email":"","banned_subject":"","banned_text":"","validate_session":"1","custom_reply":"","redirect":""}', 0, 34, 1, '', '', '', '', '', 'en-GB', '2017-11-30 08:02:42', 343, 'Joomla', '0000-00-00 00:00:00', 0, '', '', '{"robots":"","rights":""}', 1, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 1),
(3, 'Owner', 'owner', '', '', '', '', '', '', '', '', '<p>I''m the owner of this store.</p>', '', '', 0, 1, 0, '0000-00-00 00:00:00', 2, '{"show_contact_category":"","show_contact_list":"","presentation_style":"","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_profile":"","show_links":"","linka_name":"","linka":"","linkb_name":"","linkb":"","linkc_name":"","linkc":"","linkd_name":"","linkd":"","linke_name":"","linke":"","show_email_form":"","show_email_copy":"","banned_email":"","banned_subject":"","banned_text":"","validate_session":"","custom_reply":"","redirect":""}', 0, 36, 1, '', '', '', '', '', '*', '2017-11-30 08:02:42', 343, 'Joomla', '0000-00-00 00:00:00', 0, '', '', '{"robots":"","rights":""}', 1, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0),
(4, 'Buyer', 'buyer', '', '', '', '', '', '', '', '', '<p>I am in charge of buying fruit. If you sell good fruit, contact me.</p>', '', '', 0, 1, 0, '0000-00-00 00:00:00', 1, '{"show_contact_category":"","show_contact_list":"","presentation_style":"","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_profile":"","show_links":"0","linka_name":"","linka":"","linkb_name":"","linkb":"","linkc_name":"","linkc":"","linkd_name":"","linkd":"","linke_name":"","linke":"","show_email_form":"","show_email_copy":"","banned_email":"","banned_subject":"","banned_text":"","validate_session":"","custom_reply":"","redirect":""}', 0, 36, 1, '', '', '', '', '', '*', '2017-11-30 08:02:42', 343, 'Joomla', '0000-00-00 00:00:00', 0, '', '', '{"robots":"","rights":""}', 1, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 2),
(5, 'Bananas', 'bananas', 'Scientific Name: Musa', 'Image Credit: Enzik\r\nRights: Creative Commons Share Alike Unported 3.0\r\nSource: http://commons.wikimedia.org/wiki/File:Bananas_-_Morocco.jpg', '', 'Type: Herbaceous', 'Large Producers: India, China, Brasil', '', '', '', '<p>Bananas are a great source of potassium.</p>\r\n<p> </p>', 'images/sampledata/fruitshop/bananas_2.jpg', '', 0, 1, 0, '0000-00-00 00:00:00', 1, '{"show_contact_category":"show_with_link","show_contact_list":"","presentation_style":"plain","show_name":"","show_position":"1","show_email":"","show_street_address":"","show_suburb":"","show_state":"1","show_postcode":"","show_country":"1","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_profile":"","show_links":"1","linka_name":"Wikipedia: Banana English","linka":"http:\\/\\/en.wikipedia.org\\/wiki\\/Banana","linkb_name":"Wikipedia:  \\u0939\\u093f\\u0928\\u094d\\u0926\\u0940 \\u0915\\u0947\\u0932\\u093e","linkb":"http:\\/\\/hi.wikipedia.org\\/wiki\\/%E0%A4%95%E0%A5%87%E0%A4%B2%E0%A4%BE","linkc_name":"Wikipedia:Banana Portugu\\u00eas","linkc":"http:\\/\\/pt.wikipedia.org\\/wiki\\/Banana","linkd_name":"Wikipedia: \\u0411\\u0430\\u043d\\u0430\\u043d  \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","linkd":"http:\\/\\/ru.wikipedia.org\\/\\u0411\\u0430\\u043d\\u0430\\u043d","linke_name":"","linke":"","contact_layout":"beez5:encyclopedia"}', 0, 39, 1, '', '', '', '', '', '*', '2017-11-30 08:02:42', 343, 'Joomla', '0000-00-00 00:00:00', 0, '', '', '{"robots":"","rights":""}', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0),
(6, 'Apples', 'apples', 'Scientific Name: Malus domestica', 'Image Credit: Fievet\r\nRights: Public Domain\r\nSource: http://commons.wikimedia.org/wiki/File:Pommes_vertes.JPG', '', 'Family: Rosaceae', 'Large: Producers: China, United States', '', '', '', '<p>Apples are a versatile fruit, used for eating, cooking, and preserving.</p>\r\n<p>There are more that 7500 different kinds of apples grown around the world.</p>', 'images/sampledata/fruitshop/apple.jpg', '', 0, 1, 0, '0000-00-00 00:00:00', 1, '{"show_contact_category":"","show_contact_list":"","presentation_style":"plain","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_profile":"","show_links":"1","linka_name":"Wikipedia: Apples English","linka":"http:\\/\\/en.wikipedia.org\\/wiki\\/Apple","linkb_name":"Wikipedia: Manzana Espa\\u00f1ol ","linkb":"http:\\/\\/es.wikipedia.org\\/wiki\\/Manzana","linkc_name":"Wikipedia: \\u82f9\\u679c \\u4e2d\\u6587","linkc":"http:\\/\\/zh.wikipedia.org\\/zh\\/\\u82f9\\u679c","linkd_name":"Wikipedia: Tofaa Kiswahili","linkd":"http:\\/\\/sw.wikipedia.org\\/wiki\\/Tofaa","linke_name":"","linke":"","contact_layout":"beez5:encyclopedia"}', 0, 38, 1, '', '', '', '', '', '*', '2017-11-30 08:02:42', 343, 'Joomla', '0000-00-00 00:00:00', 0, '', '', '{"robots":"","rights":""}', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 1),
(7, 'Tamarind', 'tamarind', 'Scientific Name: Tamarindus indica', 'Image Credit: Franz Eugen Köhler, Köhler''s Medizinal-Pflanzen \r\nRights: Public Domain\r\nSource:http://commons.wikimedia.org/wiki/File:Koeh-134.jpg', '', 'Family: Fabaceae', 'Large Producers: India, United States', '', '', '', '<p>Tamarinds are a versatile fruit used around the world. In its young form it is used in hot sauces; ripened it is the basis for many refreshing drinks.</p>\r\n<p> </p>', 'images/sampledata/fruitshop/tamarind.jpg', '', 0, 1, 0, '0000-00-00 00:00:00', 1, '{"show_contact_category":"","show_contact_list":"","presentation_style":"plain","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_profile":"","show_links":"1","linka_name":"Wikipedia: Tamarind English","linka":"http:\\/\\/en.wikipedia.org\\/wiki\\/Tamarind","linkb_name":"Wikipedia: \\u09a4\\u09c7\\u0981\\u09a4\\u09c1\\u09b2  \\u09ac\\u09be\\u0982\\u09b2\\u09be  ","linkb":"http:\\/\\/bn.wikipedia.org\\/wiki\\/\\u09a4\\u09c7\\u0981\\u09a4\\u09c1\\u09b2 ","linkc_name":"Wikipedia: Tamarinier Fran\\u00e7ais","linkc":"http:\\/\\/fr.wikipedia.org\\/wiki\\/Tamarinier","linkd_name":"Wikipedia:Tamaline lea faka-Tonga","linkd":"http:\\/\\/to.wikipedia.org\\/wiki\\/Tamaline","linke_name":"","linke":"","contact_layout":"beez5:encyclopedia"}', 0, 57, 1, '', '', '', '', '', '*', '2017-11-30 08:02:42', 343, 'Joomla', '0000-00-00 00:00:00', 0, '', '', '{"robots":"","rights":""}', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0),
(8, 'Shop Address', 'shop-address', '', '', 'Our City', 'Our Province', 'Our Country', '', '555-555-5555', '', '<p>Here are directions for how to get to our shop.</p>', '', '', 0, 1, 0, '0000-00-00 00:00:00', 1, '{"show_contact_category":"","show_contact_list":"","presentation_style":"","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_profile":"","show_links":"","linka_name":"","linka":"","linkb_name":"","linkb":"","linkc_name":"","linkc":"","linkd_name":"","linkd":"","linke_name":"","linke":"","show_email_form":"","show_email_copy":"","banned_email":"","banned_subject":"","banned_text":"","validate_session":"","custom_reply":"","redirect":""}', 0, 35, 1, '', '', '', '', '', '*', '2017-11-30 08:02:42', 343, 'Joomla', '0000-00-00 00:00:00', 0, '', '', '{"robots":"","rights":""}', 1, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `#__content`
--

DROP TABLE IF EXISTS `#__content`;
CREATE TABLE `#__content` (
  `id` int(10) unsigned NOT NULL,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `introtext` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `fulltext` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `catid` int(10) unsigned NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `images` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `urls` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribs` varchar(5120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `featured` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The language code for the article.',
  `xreference` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT ''
) ENGINE=InnoDB AUTO_INCREMENT=179 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__content`
--

INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES
(1, 89, 'Administrator Components', 'administrator-components', '<p>All components are also used in the administrator area of your website. In addition to the ones listed here, there are components in the administrator that do not have direct front end displays, but do help shape your site. The most important ones for most users are</p>\r\n<ul>\r\n<li>Media Manager</li>\r\n<li>Extensions Manager</li>\r\n<li>Menu Manager</li>\r\n<li>Global Configuration</li>\r\n<li>Banners</li>\r\n<li>Redirect</li>\r\n</ul>\r\n<hr title="Media Manager" alt="Media Manager" class="system-pagebreak" style="color: gray; border: 1px dashed gray;" />\r\n<p> </p>\r\n<h3>Media Manager</h3>\r\n<p>The media manager component lets you upload and insert images into content throughout your site. Optionally, you can enable the flash uploader which will allow you to to upload multiple images. <a href="http://help.joomla.org/proxy/index.php?option=com_help&amp;keyref=Help31:Content_Media_Manager">Help</a></p>\r\n<hr title="Extensions Manager" alt="Extensions Manager" class="system-pagebreak" style="color: gray; border: 1px dashed gray;" />\r\n<h3>Extensions Manager</h3>\r\n<p>The extensions manager lets you install, update, uninstall and manage all of your extensions. The extensions manager has been extensively redesigned, although the core install and uninstall functionality remains the same as in Joomla! 1.5. <a href="http://help.joomla.org/proxy/index.php?option=com_help&amp;keyref=Help31:Extensions_Extension_Manager_Install">Help</a></p>\r\n<hr title="Menu Manager" alt="Menu Manager" class="system-pagebreak" style="color: gray; border: 1px dashed gray;" />\r\n<h3>Menu Manager</h3>\r\n<p>The menu manager lets you create the menus you see displayed on your site. It also allows you to assign modules and template styles to specific menu links. <a href="http://help.joomla.org/proxy/index.php?option=com_help&amp;keyref=Help31:Menus_Menu_Manager">Help</a></p>\r\n<hr title="Global Configuration" alt="Global Configuration" class="system-pagebreak" style="color: gray; border: 1px dashed gray;" />\r\n<h3>Global Configuration</h3>\r\n<p>The global configuration is where the site administrator configures things such as whether search engine friendly urls are enabled, the site meta data (descriptive text used by search engines and indexers) and other functions. For many beginning users simply leaving the settings on default is a good way to begin, although when your site is ready for the public you will want to change the meta data to match its content. <a href="http://help.joomla.org/proxy/index.php?option=com_help&amp;keyref=Help31:Site_Global_Configuration">Help</a></p>\r\n<hr title="Banners" alt="Banners" class="system-pagebreak" style="color: gray; border: 1px dashed gray;" />\r\n<h3>Banners</h3>\r\n<p>The banners component provides a simple way to display a rotating image in a module and, if you wish to have advertising, a way to track the number of times an image is viewed and clicked. <a href="http://help.joomla.org/proxy/index.php?option=com_help&amp;keyref=Help31:Components_Banners_Banners_Edit">Help</a></p>\r\n<hr title="Redirect" class="system-pagebreak" />\r\n<h3><br />Redirect</h3>\r\n<p>The redirect component is used to manage broken links that produce Page Not Found (404) errors. If enabled it will allow you to redirect broken links to specific pages. It can also be used to manage migration related URL changes. <a href="http://help.joomla.org/proxy/index.php?option=com_help&amp;keyref=Help31:Components_Redirect_Manager">Help</a></p>', '', 1, 21, '2017-11-30 08:02:42', 343, 'Joomla', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":"","urlatext":"","targeta":"","urlb":"","urlbtext":"","targetb":"","urlc":"","urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 7, '', '', 1, 7, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(8, 104, 'Beginners', 'beginners', '<p>If this is your first Joomla! site or your first web site, you have come to the right place. Joomla will help you get your website up and running quickly and easily.</p>\r\n<p>Start off using your site by logging in using the administrator account you created when you installed Joomla.</p>\r\n', '\r\n<p>Explore the articles and other resources right here on your site data to learn more about how Joomla works. (When you''re done reading, you can delete or archive all of this.) You will also probably want to visit the Beginners'' Areas of the <a href="http://docs.joomla.org/Beginners">Joomla documentation</a> and <a href="http://forum.joomla.org">support forums</a>.</p>\r\n<p>You''ll also want to sign up for the Joomla Security Mailing list and the Announcements mailing list. For inspiration visit the <a href="http://community.joomla.org/showcase/">Joomla! Site Showcase</a> to see an amazing array of ways people use Joomla to tell their stories on the web.</p>\r\n<p>The basic Joomla installation will let you get a great site up and running, but when you are ready for more features the power of Joomla is in the creative ways that developers have extended it to do all kinds of things. Visit the <a href="http://extensions.joomla.org/">Joomla! Extensions Directory</a> to see thousands of extensions that can do almost anything you could want on a website. Can''t find what you need? You may want to find a Joomla professional in the <a href="http://resources.joomla.org/">Joomla! Resource Directory</a>.</p>\r\n<p>Want to learn more? Consider attending a <a href="http://community.joomla.org/events.html">Joomla! Day</a> or other event or joining a local <a href="http://community.joomla.org/user-groups.html">Joomla! Users Group</a>. Can''t find one near you? Start one yourself.</p>', 1, 19, '2017-11-30 08:02:42', 343, 'Joomla', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":"","urlatext":"","targeta":"","urlb":"","urlbtext":"","targetb":"","urlc":"","urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 4, '', '', 1, 3, '{"robots":"","author":"","rights":"","xreference":""}', 1, '*', ''),
(9, 105, 'Contacts', 'contact', '<p>The contact component provides a way to provide contact forms and information for your site or to create a complex directory that can be used for many different purposes. <a href="http://help.joomla.org/proxy/index.php?option=com_help&amp;keyref=Help31:Components_Contacts_Contacts">Help</a></p>', '', 1, 21, '2017-11-30 08:02:42', 343, 'Joomla', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","alternative_readmore":"","article_layout":""}', 1, 2, '', '', 1, 1, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(10, 106, 'Content', 'content', '<p>The content component (com_content) is what you use to write articles. It is extremely flexible and has the largest number of built in views. Articles can be created and edited from the front end, making content the easiest component to use to create your site content. <a href="http://help.joomla.org/proxy/index.php?option=com_help&amp;keyref=Help31:Content_Article_Manager">Help</a></p>', '', 1, 21, '2017-11-30 08:02:42', 343, 'Joomla', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","alternative_readmore":"","article_layout":""}', 1, 1, '', '', 1, 3, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(21, 119, 'Getting Help', 'getting-help', '<p> There are lots of places you can get help with Joomla!. In many places in your site administrator you will see the help icon. Click on this for more information about the options and functions of items on your screen. Other places to get help are:</p>\r\n<ul>\r\n<li><a href="http://forum.joomla.org">Support Forums</a></li>\r\n<li><a href="http://docs.joomla.org">Documentation</a></li>\r\n<li><a href="http://resources.joomla.org">Professionals</a></li>\r\n<li><a href="http://shop.joomla.org/amazoncom-bookstores.html">Books</a></li>\r\n</ul>', '', 1, 19, '2017-11-30 08:02:42', 343, 'Joomla', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","info_block_position":"0","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 2, 8, '', '', 1, 5, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(22, 120, 'Getting Started', 'getting-started', '<p>It''s easy to get started creating your website. Knowing some of the basics will help.</p>\r\n<h3>What is a Content Management System?</h3>\r\n<p>A content management system is software that allows you to create and manage webpages easily by separating the creation of your content from the mechanics required to present it on the web.</p>\r\n<p>In this site, the content is stored in a <em>database</em>. The look and feel are created by a <em>template</em>. The Joomla! software brings together the template and the content to create web pages.</p>\r\n<h3>Site and Administrator</h3>\r\n<p>Your site actually has two separate sites. The site (also called the front end) is what visitors to your site will see. The administrator (also called the back end) is only used by people managing your site. You can access the administrator by clicking the "Site Administrator" link on the "This Site" menu or by adding /administrator to the end of you domain name.</p>\r\n<p>Log in to the administrator using the username and password created during the installation of Joomla.</p>\r\n<h3>Logging in</h3>\r\n<p>To login to the front end of your site use the login form or the login menu link on the "This Site" menu. Use the user name and password that were created as part of the installation process. Once logged-in you will be able to create and edit articles.</p>\r\n<p>In managing your site, you will be able to create content that only logged-in users are able to see.</p>\r\n<h3>Creating an article</h3>\r\n<p>Once you are logged-in, a new menu will be visible. To create a new article, click on the "submit article" link on that menu.</p>\r\n<p>The new article interface gives you a lot of options, but all you need to do is add a title and put something in the content area. To make it easy to find, set the state to published and put it in the Joomla category.</p>\r\n<div>You can edit an existing article by clicking on the edit icon (this only displays to users who have the right to edit).</div>\r\n<h3>Learn more</h3>\r\n<p>There is much more to learn about how to use Joomla! to create the web site you envision. You can learn much more at the <a href="http://docs.joomla.org">Joomla! documentation site</a> and on the<a href="http://forum.joomla.org"> Joomla! forums</a>.</p>', '', 1, 19, '2017-11-30 08:02:42', 343, 'Joomla', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":"","urlatext":"","targeta":"","urlb":"","urlbtext":"","targetb":"","urlc":"","urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 9, '', '', 1, 68, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(24, 122, 'Joomla!', 'joomla', '<p>Congratulations! You have a Joomla site! Joomla makes it easy to build a website just the way you want it and keep it simple to update and maintain.</p>\r\n<p>Joomla is a flexible and powerful platform, whether you are building a small site for yourself or a huge site with hundreds of thousands of visitors. Joomla is open source, which means you can make it work just the way you want it to.</p>\r\n<p>The content in this installation of Joomla has been designed to give you an in depth tour of Joomla''s features.</p>', '', 1, 19, '2017-11-30 08:02:42', 343, 'Joomla', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","info_block_position":"0","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 3, 2, '', '', 1, 10, '{"robots":"","author":"","rights":"","xreference":""}', 1, '*', ''),
(32, 130, 'Options', 'options', '<p>As you make your Joomla! site you will control the details of the display using <em>options</em> also referred to as <em>parameter</em><strong>s</strong>. Options control everything from whether the author''s name is displayed to who can view what to the number of items shown on a list.</p>\r\n<p>Default options for each component are changed using the Options button on the component toolbar.</p>\r\n<p>Options can also be set on an individual item, such as an article or contact and in menu links.</p>\r\n<p>If you are happy with how your site looks, it is fine to leave all of the options set to the defaults that were created when your site was installed. As you become more experienced with Joomla you will use options more.</p>\r\n<p> </p>', '', 1, 19, '2017-11-30 08:02:42', 343, 'Joomla', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":"","urlatext":"","targeta":"","urlb":"","urlbtext":"","targetb":"","urlc":"","urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 10, '', '', 1, 8, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(35, 133, 'Professionals', 'professionals', '<p>Joomla! 3 continues development of the Joomla Platform and CMS as a powerful and flexible way to bring your vision of the web to reality. With the new administrator interface and adoption of Twitter Bootstrap, the ability to control its look and the management of extensions is now complete.</p>\r\n', '\r\n<p>Working with multiple template styles and overrides for the same views, creating the design you want is easier than it has ever been. Limiting support to PHP 5.3.10 and above makes Joomla lighter and faster than ever. </p>\r\n<p>The separation of the Joomla! Platform project from the Joomla! CMS project makes continuous development of new, powerful APIs and continuous improvement of existing APIs possible while maintaining the stability of the CMS that millions of webmasters and professionals rely upon.</p>', 1, 19, '2017-11-30 08:02:42', 343, 'Joomla', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","info_block_position":"0","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 2, 5, '', '', 1, 44, '{"robots":"","author":"","rights":"","xreference":""}', 1, '*', ''),
(38, 136, 'Sample Sites', 'sample-sites', '<p>Your installation includes sample data, designed to show you some of the options you have for building your website. In addition to information about Joomla! there are two sample "sites within a site" designed to help you get started with building your own site.</p>\r\n<p>The first site is a simple site about <a href="index.php?Itemid=243">Australian Parks</a>. It shows how you can quickly and easily build a personal site with just the building blocks that are part of Joomla. It includes a personal blog, weblinks, and a very simple image gallery.</p>\r\n<p>The second site is slightly more complex and represents what you might do if you are building a site for a small business, in this case a <a href="index.php/welcome.html"></a><a href="index.php?Itemid=429">Fruit Shop</a>.</p>\r\n<p>In building either style site, or something completely different, you will probably want to add <a href="http://extensions.joomla.org">extensions</a> and either create or purchase your own template. Many Joomla users start by modifying the <a href="http://docs.joomla.org/How_do_you_modify_a_template%3F">templates</a> that come with the core distribution so that they include special images and other design elements that relate to their site''s focus.</p>', '', 1, 19, '2017-11-30 08:02:42', 343, 'Joomla', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":"","urlatext":"","targeta":"","urlb":"","urlbtext":"","targetb":"","urlc":"","urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 11, '', '', 1, 15, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(39, 137, 'Search', 'search-component', '<p>Joomla! 2.5 offers two search options.</p>\r\n<p>The Basic Search component provides basic search functionality for the information contained in your core components. Many extensions can also be searched by the search component. <a href="http://help.joomla.org/proxy/index.php?option=com_help&amp;keyref=Help31:Components_Search">Help</a></p>\r\n<p>The Smart Search component offers searching similar to that found in major search engines. Smart Search is disabled by default. If you choose to enable it you will need to take several steps. First, enable the Smart Search Plugin in the plugin manager. Then, if you are using the Basic Search Module replace it with the Smart Search Module. Finally, if you have already created content, go to the Smart Search component in your site administrator and click the Index icon. Once indexing of your content is complete, Smart Search will be ready to use. Help.</p>', '', 1, 21, '2017-11-30 08:02:42', 343, 'Joomla', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":"","urlatext":"","targeta":"","urlb":"","urlbtext":"","targetb":"","urlc":"","urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 3, '', '', 1, 17, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(47, 145, 'The Joomla! Community', 'the-joomla-community', '<p>Joomla means All Together, and it is a community of people all working and having fun together that makes Joomla possible. Thousands of people each year participate in the Joomla community, and we hope you will be one of them.</p>\r\n<p>People with all kinds of skills, of all skill levels and from around the world are welcome to join in. Participate in the <a href="http://joomla.org">Joomla.org</a> family of websites (the<a href="http://forum.joomla.org"> forum </a>is a great place to start). Come to a <a href="http://community.joomla.org/events.html">Joomla! event</a>. Join or start a <a href="http://community.joomla.org/user-groups.html">Joomla! Users Group</a>. Whether you are a developer, site administrator, designer, end user or fan, there are ways for you to participate and contribute.</p>', '', 1, 19, '2017-11-30 08:02:42', 343, 'Joomla', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":"","urlatext":"","targeta":"","urlb":"","urlbtext":"","targetb":"","urlc":"","urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 3, '', '', 1, 2, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(48, 146, 'The Joomla! Project', 'the-joomla-project', '<p>The Joomla Project consists of all of the people who make and support the Joomla Web Platform and Content Management System.</p>\r\n<p>Our mission is to provide a flexible platform for digital publishing and collaboration.</p>\r\n<p>The core values are:</p>\r\n<ul>\r\n<li>Freedom</li>\r\n<li>Equality</li>\r\n<li>Trust</li>\r\n<li>Community</li>\r\n<li>Collaboration</li>\r\n<li>Usability</li>\r\n</ul>\r\n<p>In our vision, we see:</p>\r\n<ul>\r\n<li>People publishing and collaborating in their communities and around the world</li>\r\n<li>Software that is free, secure, and high-quality</li>\r\n<li>A community that is enjoyable and rewarding to participate in</li>\r\n<li>People around the world using their preferred languages</li>\r\n<li>A project that acts autonomously</li>\r\n<li>A project that is socially responsible</li>\r\n<li>A project dedicated to maintaining the trust of its users</li>\r\n</ul>\r\n<p>There are millions of users around the world and thousands of people who contribute to the Joomla Project. They work in three main groups: the Production Working Group, responsible for everything that goes into software and documentation; the Community Working Group, responsible for creating a nurturing the community; and Open Source Matters, the non profit organization responsible for managing legal, financial and organizational issues.</p>\r\n<p>Joomla is a free and open source project, which uses the GNU General Public License version 2 or later.</p>', '', 1, 19, '2017-11-30 08:02:42', 343, 'Joomla', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":"","urlatext":"","targeta":"","urlb":"","urlbtext":"","targetb":"","urlc":"","urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 1, '', '', 1, 4, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(50, 148, 'Upgraders', 'upgraders', '<p>If you are an experienced Joomla! user, this Joomla site will seem very familiar but also very different. The biggest change is the new administrator interface and the adoption of responsive design. Hundreds of other improvements have been made.</p>\r\n<p> </p>\r\n<p> </p>', '', 1, 19, '2017-11-30 08:02:42', 343, 'Joomla', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","info_block_position":"0","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 3, 6, '', '', 1, 3, '{"robots":"","author":"","rights":"","xreference":""}', 1, '*', ''),
(52, 150, 'Users', 'users-component', '<p>The users extension lets your site visitors register, login and logout, change their passwords and other information, and recover lost passwords. In the administrator it allows you to create, block and manage users and create user groups and access levels. <a href="http://help.joomla.org/proxy/index.php?option=com_help&amp;keyref=Help31:Users_User_Manager">Help</a></p>\r\n<p>Please note that some of the user views will not display if you are not logged-in to the site.</p>', '', 1, 21, '2017-11-30 08:02:42', 343, 'Joomla', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","alternative_readmore":"","article_layout":""}', 1, 5, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(53, 151, 'Using Joomla!', 'using-joomla', '<p>With Joomla you can create anything from a simple personal website to a complex ecommerce or social site with millions of visitors.</p>\r\n<p>This section of the sample data provides you with a brief introduction to Joomla concepts and reference material to help you understand how Joomla works.</p>\r\n<p><em>When you no longer need the sample data, you can can simply unpublish the sample data category found within each extension in the site administrator or you may completely delete each item and all of the categories. </em></p>', '', 1, 19, '2017-11-30 08:02:42', 343, 'Joomla', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":"","urlatext":"","targeta":"","urlb":"","urlbtext":"","targetb":"","urlc":"","urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 7, '', '', 1, 9, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(60, 158, 'News Feeds', 'news-feeds', '<p>News Feeds (com_newsfeeds) provides a way to organize and present news feeds. News feeds are a way that you present information from another site on your site. For example, the joomla.org website has numerous feeds that you can incorporate on your site. You an use menus to present a single feed, a list of feeds in a category, or a list of all feed categories. <a href="http://help.joomla.org/proxy/index.php?option=com_help&amp;keyref=Help31:Components_Newsfeeds_Feeds">Help</a></p>', '', 1, 21, '2017-11-30 08:02:42', 343, 'Joomla', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":"","urlatext":"","targeta":"","urlb":"","urlbtext":"","targetb":"","urlc":"","urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 4, '', '', 1, 8, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(67, 168, 'What''s New in 1.5?', 'whats-new-in-15', '<p>This article deliberately archived as an example.</p><p>As with previous releases, Joomla! provides a unified and easy-to-use framework for delivering content for Web sites of all kinds. To support the changing nature of the Internet and emerging Web technologies, Joomla! required substantial restructuring of its core functionality and we also used this effort to simplify many challenges within the current user interface. Joomla! 1.5 has many new features.</p>\r\n<p style="margin-bottom: 0in;">In Joomla! 1.5, you''''ll notice:</p>\r\n<ul>\r\n<li>Substantially improved usability, manageability, and scalability far beyond the original Mambo foundations</li>\r\n<li>Expanded accessibility to support internationalisation, double-byte characters and right-to-left support for Arabic, Farsi, and Hebrew languages among others</li>\r\n<li>Extended integration of external applications through Web services</li>\r\n<li>Enhanced content delivery, template and presentation capabilities to support accessibility standards and content delivery to any destination</li>\r\n<li>A more sustainable and flexible framework for Component and Extension developers</li>\r\n<li>Backward compatibility with previous releases of Components, Templates, Modules, and other Extensions</li>\r\n</ul>', '', 2, 9, '2017-11-30 08:02:42', 343, 'Joomla', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 1, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(71, 195, 'Doner spare ribs pastrami shank', 'doner-spare-ribs-pastrami-shank', '<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.</p>\r\n', '\r\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus</p>', 1, 79, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","post_format":"status","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":"<blockquote class=\\"twitter-tweet\\" lang=\\"en\\"><p>Published a new blog entry One Month Extra for all JoomShaper Members in News. <a href=\\"http:\\/\\/t.co\\/2pQYdykKy8\\">http:\\/\\/t.co\\/2pQYdykKy8<\\/a><\\/p>&mdash; JoomShaper (@joomshaper) <a href=\\"https:\\/\\/twitter.com\\/joomshaper\\/status\\/562210375480139777\\">February 2, 2015<\\/a><\\/blockquote>\\r\\n<script async src=\\"\\/\\/platform.twitter.com\\/widgets.js\\" charset=\\"utf-8\\"><\\/script>"}', 4, 6, '', '', 1, 20, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(72, 196, 'Jerky shank chicken boudin', 'jerky-shank-chicken-boudin', '<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.</p>\r\n', '\r\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus</p>', 1, 79, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","post_format":"video","gallery":"","audio":"","video":"http:\\/\\/vimeo.com\\/43426940","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 4, 5, '', '', 1, 50, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(73, 197, 'Pellentesque Habitant Morbi Tristique', 'leberkas-tail-swine-pork', '<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.</p>\r\n', '\r\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus</p>', 1, 79, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"images\\/blog\\/blog01.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/blog\\/blog01.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 5, 4, '', '', 1, 148, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(74, 198, 'Meatball kevin beef ribs shoulder', 'meatball-kevin-beef-ribs-shoulder', '<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.</p>\r\n', '\r\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus</p>', 1, 79, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","post_format":"gallery","gallery":"{\\"gallery_images\\":[\\"images\\/blog\\/blog06.jpg\\",\\"images\\/blog\\/blog05.jpg\\",\\"images\\/blog\\/blog04.jpg\\"]}","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 3, 3, '', '', 1, 46, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES
(75, 199, '5 Effective Email Unsubscribe Pages', '5-effective-email-unsubscribe-pages', '<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.</p>\r\n', '\r\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus</p>', 1, 79, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","post_format":"audio","gallery":"","audio":"<iframe width=\\"100%\\" height=\\"450\\" scrolling=\\"no\\" frameborder=\\"no\\" src=\\"https:\\/\\/w.soundcloud.com\\/player\\/?url=https%3A\\/\\/api.soundcloud.com\\/tracks\\/28830162&amp;auto_play=false&amp;hide_related=false&amp;show_comments=true&amp;show_user=true&amp;show_reposts=false&amp;visual=true\\"><\\/iframe>","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 4, 2, '', '', 1, 22, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(76, 200, 'Who Actually Clicks on Banner Ads?', 'who-actually-clicks-on-banner-ads', '<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.</p>\r\n', '\r\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus</p>', 1, 79, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","post_format":"link","gallery":"","audio":"","video":"","link_title":"Responive Joomla Templates","link_url":"http:\\/\\/www.joomshaper.com\\/joomla-templates","quote_text":"","quote_author":"","post_status":""}', 3, 1, '', '', 1, 38, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(77, 201, 'See the new Miss Universe get her crown', 'see-the-new-miss-universe-get-her-crown', '<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.</p>\r\n', '\r\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus</p>', 1, 79, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","post_format":"quote","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"Pork meatball ground round prosciutto. Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami. Filet mignon bresaola pork boudin capicola prosciutto. Frankfurter chicken leberkas drumstick ball tip turducken rump spare ribs meatball. Tail salami pork loin ham. Drumstick flank porchetta, hamburger ham swine biltong chicken pancetta. Spare ribs prosciutto t-bone.","quote_author":"- John Doe","post_status":""}', 2, 0, '', '', 1, 44, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(78, 235, 'Nullam eros mi, mollis in sollicitudin non, tincidunt.', 'nullam-eros-mi-mollis-in-sollicitudin-non-tincidunt', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 85, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/22\\/Newskit-images_0026_man-505353_1920.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 13, 8, '', '', 1, 127, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(79, 238, 'Tongue kielbasa ribeye meatball pork loin andouille', 'tongue-kielbasa-ribeye-meatball-pork-loin-andouille', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 86, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/23\\/Newskit-images_0002_sun-ball-tennis-court.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 4, 4, '', '', 1, 7, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(80, 239, 'Facebooks Guidance For Moderators Makes More ', 'facebooks-guidance-for-moderators-makes-more', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 88, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/22\\/Newskit-images_0019_pexels-photo-67699.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 6, 11, '', '', 1, 6, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(81, 240, 'Short ribs strip steak meatloaf, pig ribeye cow turkey', 'short-ribs-strip-steak-meatloaf-pig-ribeye-cow-turkey', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 90, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/09\\/Newskit-images_0023_pexels-photo (2).jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 4, 3, '', '', 1, 2, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(82, 241, 'Not Recognize Shaq As Their Lyft are in Driver?', 'not-recognize-shaq-as-their-lyft-driver', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 89, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/22\\/Newskit-images_0031_frog-2240764_1920.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 14, 2, '', '', 1, 11, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(83, 242, 'Pork loin ball tip bresaola, hamburger swine shoulder', 'pork-loin-ball-tip-bresaola-hamburger-swine-shoulder', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 86, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/23\\/Newskit-images_0030_gabriel-sanchez-23439.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 14, 0, '', '', 1, 4, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(84, 247, 'Fatback sausage pork loin bresaola tail sirloin Bresaola.', 'fatback-sausage-pork-loin-bresaola-tail-sirloin-bresaola', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 96, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/22\\/Newskit-images_0021_pexels-photo-53935.jpg","post_format":"video","gallery":"","audio":"","video":"https:\\/\\/vimeo.com\\/125468677","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 5, 5, '', '', 1, 22, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(85, 248, 'Pork belly corned beef bacon turkey doner chuck bresaola.', 'pork-belly-corned-beef-bacon-turkey-doner-chuck-bresaola', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 96, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/07\\/Newskit-images_0030_gabriel-sanchez-23439.jpg","post_format":"video","gallery":"","audio":"","video":"https:\\/\\/vimeo.com\\/125468677","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 3, 4, '', '', 1, 6, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(86, 249, 'Jancetta sausage brisket leberkas shoulder tri-tip short.', 'pancetta-sausage-brisket-leberkas-shoulder-tri-tip-short', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 96, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/22\\/Newskit-images_0003_surfer-2212948_1920.jpg","post_format":"video","gallery":"","audio":"","video":"https:\\/\\/vimeo.com\\/125468677","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 6, 3, '', '', 1, 2, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(87, 250, 'Ham frankfurter jerky, ground round burgdoggen ball tip.', 'ham-frankfurter-jerky-ground-round-burgdoggen-ball-tip', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 96, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/22\\/Newskit-images_0036_pexels-photo-352611.jpg","post_format":"video","gallery":"","audio":"","video":"https:\\/\\/vimeo.com\\/125468677","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 5, 2, '', '', 1, 1, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(88, 251, 'Across London as armed police step up patrols', 'across-london-as-armed-police-step-up-patrols', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 85, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/07\\/Newskit-images_0025_matt-palmer-254999.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 3, 7, '', '', 1, 44, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(89, 252, 'Ut at magna leo. Suspendisse egestas est ac dolor', 'ut-at-magna-leo-suspendisse-egestas-est-ac-dolor', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 85, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/07\\/Newskit-images_0008_pexels-photo-346392.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 4, 6, '', '', 1, 8, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(90, 253, 'The Activists: The University of Missouri Football Team', 'the-activists-the-university-of-missouri-football-team-2', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 85, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/23\\/Bitmap.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 6, 5, '', '', 1, 30, '{"robots":"","author":"","rights":"","xreference":""}', 1, '*', ''),
(91, 254, 'Cras semper consectetur elementum, Nulla vel.', 'cras-semper-consectetur-elementum-nulla-vel-aliquet', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 85, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/22\\/Newskit-images_0007_pexels-photo-379493.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 7, 4, '', '', 1, 5, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES
(92, 255, 'The Newest McDonald''s Location Only Serves', 'the-newest-mcdonald-s-location-only-serves', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 85, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/22\\/Newskit-images_0006_pexels-photo-393477.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 5, 3, '', '', 1, 12, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(95, 258, 'Here''s Why the Head of Nike''s Basketball Business', 'here-s-why-the-head-of-nike-s-basketball-business', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 91, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/22\\/Newskit-images_0024_meditation-2214532_1280.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 5, 11, '', '', 1, 4, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(96, 259, 'Phasellus ac magna non augue porttitor scelerisque', 'phasellus-ac-magna-non-augue-porttitor-scelerisque', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 91, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/22\\/Newskit-images_0020_pexels-photo-58592.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 4, 10, '', '', 1, 1, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(97, 260, 'Sed nunc orci sed, ultricies congue vehicula quis', 'sed-nunc-orci-ultricies-congue-vehicula-quis', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 91, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/22\\/Newskit-images_0013_pexels-photo-235462.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 5, 9, '', '', 1, 1, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(98, 261, 'Proin ornare ligula eu tellus tempus elementum', 'proin-ornare-ligula-eu-tellus-tempus-elementum', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 91, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/22\\/Newskit-images_0012_pexels-photo-297933.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 4, 8, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(99, 262, 'Facebooks Guidance For Moderators Makes More Sense ', 'facebooks-guidance-for-moderators-makes-more-sense', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 91, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/07\\/Newskit-images_0019_pexels-photo-67699.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 3, 7, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(100, 263, 'Fusce a metus eu diam varius congue nec nec.', 'fusce-a-metus-eu-diam-varius-congue-nec-nec', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 86, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/22\\/Newskit-images_0032_dirt-bike-motorcycle-jump-autumn-636131.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 6, 6, '', '', 1, 2, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(102, 265, 'Will Smith''s Awesome Tonight Show Entrance', 'will-smith-s-awesome-tonight-show-entrance', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 91, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/07\\/Newskit-images_0040_pexels-photo-173358.jpg","post_format":"video","gallery":"","audio":"","video":"https:\\/\\/www.youtube.com\\/watch?v=SnDd-yNEidY","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 2, 4, '', '', 1, 1, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(103, 266, 'Etiam feugiat dolor ac elit suscipit in elementum.', 'etiam-feugiat-dolor-ac-elit-suscipit-in-elementum', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 91, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/07\\/Newskit-images_0008_pexels-photo-346392.jpg","post_format":"video","gallery":"","audio":"","video":"https:\\/\\/www.youtube.com\\/watch?v=SnDd-yNEidY","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 3, 3, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(104, 267, 'Praesent tempus dictum nibh ac ullamcorper.', 'praesent-tempus-dictum-nibh-ac-ullamcorper', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 91, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/08\\/Newskit-images_0010_pexels-photo-325924.jpg","post_format":"video","gallery":"","audio":"","video":"https:\\/\\/www.youtube.com\\/watch?v=SnDd-yNEidY","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 4, 2, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(105, 268, 'The Newest McDonald''s Location Only Serves', 'the-newest-mcdonald-s-location-only-serves-2', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 86, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/07\\/Newskit-images_0009_pexels-photo-342361.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 6, 1, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(106, 269, 'Proin tristique rhoncus orci, eget vulputate nisi', 'proin-tristique-rhoncus-orci-eget-vulputate-nisi', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 86, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/22\\/Newskit-images_0029_ice-hockey-goal-sport-team-38551.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 4, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(107, 277, 'Voicemail transcription  in Google Voice is getting better', 'voicemail-transcription-in-google-voice-is-getting-better', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 89, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/09\\/Newskit-images_0034_smile-color-laugh-black-157907.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 3, 1, '', '', 1, 1, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(108, 278, 'Vestibulum ac leo vitae metus faucibus gravida.', 'vestibulum-ac-leo-vitae-metus-faucibus-gravida', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 89, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/08\\/Newskit-images_0028_hands-people-woman-working.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 3, 0, '', '', 1, 19, '{"robots":"","author":"","rights":"","xreference":""}', 1, '*', ''),
(109, 279, 'Far far away, behind the word mountains', 'far-far-away-behind-the-word-mountains', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 88, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/23\\/Newskit-images_0005_pexels-photo-401684.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 5, 10, '', '', 1, 8, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(110, 280, 'The European languages are members of the same family', 'the-european-languages-are-members-of-the-same-family', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 88, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/09\\/Newskit-images_0010_pexels-photo-3259241.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 3, 9, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES
(111, 281, 'But I must explain to you how all this mistaken idea', 'but-i-must-explain-to-you-how-all-this-mistaken-idea', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 88, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/09\\/Newskit-images_0008_pexels-photo-346392.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 2, 8, '', '', 1, 2, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(112, 282, 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem', 'sed-ut-perspiciatis-unde-omnis-iste-natus-error-sit-voluptatem', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 90, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/22\\/Newskit-images_0005_pexels-photo-401684.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 3, 2, '', '', 1, 3, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(113, 283, 'One morning, when Gregor Samsa woke from troubled', 'one-morning-when-gregor-samsa-woke-from-troubled-dreams', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 90, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/09\\/Newskit-images_0010_pexels-photo-325924.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 3, 1, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(114, 284, 'I should be incapable of drawing a single stroke', 'i-should-be-incapable-of-drawing-a-single-stroke', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 92, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/09\\/Newskit-images_0039_pexels-photo-206470.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 3, 3, '', '', 1, 1, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(115, 285, 'I throw myself down among the tall grass by the trickling', 'i-throw-myself-down-among-the-tall-grass-by-the-trickling', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 92, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/09\\/Newskit-images_0034_smile-color-laugh-black-157907.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 2, 2, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(116, 286, 'I hear the buzz of the little world among the stalks', 'i-hear-the-buzz-of-the-little-world-among-the-stalks', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 92, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/09\\/Newskit-images_0038_pexels-photo-298863.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 3, 1, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(117, 287, 'Everyone realizes why a new common language', 'everyone-realizes-why-a-new-common-language', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 93, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/09\\/Newskit-images_0003_surfer-2212948_1920.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 3, 2, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(118, 288, 'If several languages coalesce, the grammar', 'if-several-languages-coalesce-the-grammar', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 93, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/09\\/Newskit-images_0008_pexels-photo-3463922.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 3, 1, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 1, '*', ''),
(119, 289, 'Europe uses the same vocabulary', 'europe-uses-the-same-vocabulary', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 93, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/09\\/Newskit-images_0008_pexels-photo-3463921.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 2, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(120, 293, 'Morbi rhoncus, sem laoreet tempus pulvinar leo ', 'morbi-rhoncus-sem-laoreet-tempus-pulvinar-leo', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 85, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/22\\/Newskit-images_0017_pexels-photo-207178.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 6, 3, '', '', 1, 2, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(121, 294, 'Nunc sed ligula sed augue rutrum ultrices eget', 'nunc-sed-ligula-sed-augue-rutrum-ultrices-eget', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 85, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/22\\/Newskit-images_0004_pexels-photo-418283.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 7, 4, '', '', 1, 4, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(122, 295, 'Quisque iaculis ligula ut ipsum mattis viverra', 'quisque-iaculis-ligula-ut-ipsum-mattis-viverra', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 85, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/07\\/05\\/world-blog.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 6, 5, '', '', 1, 4, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(123, 296, 'Mauris molestie augue sed nunc adipiscing', 'mauris-molestie-augue-sed-nunc-adipiscing', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 85, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/07\\/Newskit-images_0008_pexels-photo-346392.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 4, 6, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(124, 297, 'Mauris elit velit, lobortis sed interdum at vestibulum', 'mauris-elit-velit-lobortis-sed-interdum-at-vestibulum', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 85, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/07\\/Newskit-images_0025_matt-palmer-254999.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 4, 7, '', '', 1, 1, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(125, 298, 'Phasellus ac magna non augue porttitor scelerisque', 'phasellus-ac-magna-non-augue-porttitor-scelerisque', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 85, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/22\\/Newskit-images_0033_bogdan-dada-156739 (1).jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 11, 8, '', '', 1, 8, '{"robots":"","author":"","rights":"","xreference":""}', 1, '*', ''),
(127, 306, 'Pancetta sausage brisket leberkas shoulder tri-tip short.', 'pancetta-sausage-brisket-leberkas-shoulder-tri-tip-short-2', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 96, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/22\\/Newskit-images_0032_dirt-bike-motorcycle-jump-autumn-63613.jpg","post_format":"video","gallery":"","audio":"","video":"https:\\/\\/vimeo.com\\/125468677","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 3, 0, '', '', 1, 2, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES
(128, 315, 'Nisi proin tristique rhoncus orci, eget vulputate.', 'nisi-proin-tristique-rhoncus-orci-eget-vulputate', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 86, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/22\\/Newskit-images_0029_ice-hockey-goal-sport-team-38551.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 5, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(129, 316, 'Newest McDonald''s Location Only Serves', 'newest-mcdonald-s-location-only-serves', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 86, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/07\\/Newskit-images_0009_pexels-photo-342361.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 7, 1, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(130, 317, 'Azusce a metus eu diam varius congue nec', 'azusce-a-metus-eu-diam-varius-congue-nec', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 86, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/22\\/Newskit-images_0032_dirt-bike-motorcycle-jump-autumn-636131.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 7, 6, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(131, 318, 'Nam porttitor, erat sit amet venenatis luctus, augue.', 'nam-porttitor-erat-sit-amet-venenatis-luctus-augue', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 86, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/23\\/Newskit-images_0015_pexels-photo-281587.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 14, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(132, 319, 'Ut at magna leo. Suspendisse egestas est.', 'ut-at-magna-leo-suspendisse-egestas-est', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 86, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/23\\/Newskit-images_0027_pexels-photo-101584.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 5, 4, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(133, 320, 'Vestibulum eget felis nec purus commodo convallis.', 'vestibulum-eget-felis-nec-purus-commodo-convallis', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 86, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/23\\/Newskit-images_0035_pexels-photo-407188.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 14, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(134, 321, 'Cras semper consectetur elementum Nulla vel.', 'cras-semper-consectetur-elementum-nulla-vel', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 86, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/23\\/Newskit-images_0016_pexels-photo-261109.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 4, 4, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(135, 322, 'Proin suscipit luctus orci placerat fringilla Donec. ', 'proin-suscipit-luctus-orci-placerat-fringilla-donec', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 88, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/23\\/Newskit-images_0014_pexels-photo-296878.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 4, 7, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(136, 323, 'Suscipit luctus orci placerat fringilla Donec Sodf', 'suscipit-luctus-orci-placerat-fringilla-donec-sodf', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 88, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/23\\/Newskit-images_0022_pexels-photo-40120.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 2, 6, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(137, 324, 'Luctus Proin suscipit orci placerat fringilla Donec.', 'luctus-proin-suscipit-orci-placerat-fringilla-donec', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 88, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/23\\/Newskit-images_0043_jeff-sessions-task-force.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 2, 5, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(138, 325, 'Fringilla Proin suscipit luctus orci placerat  Donec. ', 'fringilla-proin-suscipit-luctus-orci-placerat-donec', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 88, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/23\\/Newskit-images_0037_pexels-photo-308798.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 2, 4, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(139, 326, 'Proin suscipit luctus orci placerat fringilla Cho Donec.', 'proin-suscipit-luctus-orci-placerat-fringilla-cho-donec', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 88, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/23\\/Newskit-images_0035_pexels-photo-4071881.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 2, 3, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(140, 327, 'Orci Proin suscipit luctus placerat fringilla Donec.', 'orci-proin-suscipit-luctus-placerat-fringilla-donec', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 88, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/23\\/Newskit-images_0034_smile-color-laugh-black-157907.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 2, 2, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(141, 328, 'volutpat suscipit luctus orci placerat fringilla Donec.', 'volutpat-suscipit-luctus-orci-placerat-fringilla-donec', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 88, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/23\\/Newskit-images_0004_pexels-photo-418283.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 2, 1, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(142, 329, 'Vivamus vel  luctus orci placerat fringilla Donec.', 'vivamus-vel-luctus-orci-placerat-fringilla-donec', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 88, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/23\\/Newskit-images_0039_pexels-photo-206470.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 2, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(143, 330, 'But I must explain to you how all this mistaken idea', 'but-i-must-explain-to-you-how-all-this-mistaken-idea', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 89, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/09\\/Newskit-images_0008_pexels-photo-346392.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 2, 8, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES
(144, 331, 'Proin suscipit luctus orci placerat fringilla Donec. ', 'proin-suscipit-luctus-orci-placerat-fringilla-donec', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 89, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/23\\/Newskit-images_0014_pexels-photo-296878.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 4, 7, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(145, 332, 'Suscipit luctus orci placerat fringilla Donec Sodf', 'suscipit-luctus-orci-placerat-fringilla-donec-sodf', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 89, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/23\\/Newskit-images_0022_pexels-photo-40120.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 2, 6, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(146, 333, 'Luctus Proin suscipit orci placerat fringilla Donec.', 'luctus-proin-suscipit-orci-placerat-fringilla-donec', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 89, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/23\\/Newskit-images_0043_jeff-sessions-task-force.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 2, 5, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(147, 334, 'Fringilla Proin suscipit luctus orci placerat  Donec. ', 'fringilla-proin-suscipit-luctus-orci-placerat-donec', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 89, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/23\\/Newskit-images_0037_pexels-photo-308798.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 2, 4, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(148, 335, 'Proin suscipit luctus orci placerat fringilla Cho Donec.', 'proin-suscipit-luctus-orci-placerat-fringilla-cho-donec', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 89, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/23\\/Newskit-images_0035_pexels-photo-4071881.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 2, 3, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(149, 336, 'Orci Proin suscipit luctus placerat fringilla Donec.', 'orci-proin-suscipit-luctus-placerat-fringilla-donec', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 89, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/23\\/Newskit-images_0034_smile-color-laugh-black-157907.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 2, 2, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(150, 337, 'volutpat suscipit luctus orci placerat fringilla Donec.', 'volutpat-suscipit-luctus-orci-placerat-fringilla-donec', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 89, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/23\\/Newskit-images_0004_pexels-photo-418283.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 2, 1, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(151, 338, 'Vivamus vel  luctus orci placerat fringilla Donec.', 'vivamus-vel-luctus-orci-placerat-fringilla-donec', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 89, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/23\\/Newskit-images_0039_pexels-photo-206470.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 2, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(152, 339, 'But I must explain to you how all this mistaken idea', 'but-i-must-explain-to-you-how-all-this-mistaken-idea', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 90, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/09\\/Newskit-images_0008_pexels-photo-346392.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 2, 8, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(153, 340, 'Proin suscipit luctus orci placerat fringilla Donec. ', 'proin-suscipit-luctus-orci-placerat-fringilla-donec', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 90, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/23\\/Newskit-images_0014_pexels-photo-296878.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 4, 7, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(154, 341, 'Suscipit luctus orci placerat fringilla Donec Sodf', 'suscipit-luctus-orci-placerat-fringilla-donec-sodf', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 90, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/23\\/Newskit-images_0022_pexels-photo-40120.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 2, 6, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(155, 342, 'Luctus Proin suscipit orci placerat fringilla Donec.', 'luctus-proin-suscipit-orci-placerat-fringilla-donec', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 90, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/23\\/Newskit-images_0043_jeff-sessions-task-force.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 2, 5, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(156, 343, 'Fringilla Proin suscipit luctus orci placerat  Donec. ', 'fringilla-proin-suscipit-luctus-orci-placerat-donec', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 90, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/23\\/Newskit-images_0037_pexels-photo-308798.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 2, 4, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(157, 344, 'Proin suscipit luctus orci placerat fringilla Cho Donec.', 'proin-suscipit-luctus-orci-placerat-fringilla-cho-donec', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 90, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/23\\/Newskit-images_0035_pexels-photo-4071881.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 2, 3, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(158, 345, 'Orci Proin suscipit luctus placerat fringilla Donec.', 'orci-proin-suscipit-luctus-placerat-fringilla-donec', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 90, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/23\\/Newskit-images_0034_smile-color-laugh-black-157907.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 2, 2, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(159, 346, 'volutpat suscipit luctus orci placerat fringilla Donec.', 'volutpat-suscipit-luctus-orci-placerat-fringilla-donec', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 90, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/23\\/Newskit-images_0004_pexels-photo-418283.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 2, 1, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES
(160, 347, 'Vivamus vel  luctus orci placerat fringilla Donec.', 'vivamus-vel-luctus-orci-placerat-fringilla-donec', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 90, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/23\\/Newskit-images_0039_pexels-photo-206470.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 2, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(161, 348, 'But I must explain to you how all this mistaken idea', 'but-i-must-explain-to-you-how-all-this-mistaken-idea', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 91, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/09\\/Newskit-images_0008_pexels-photo-346392.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 2, 8, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(162, 349, 'Proin suscipit luctus orci placerat fringilla Donec. ', 'proin-suscipit-luctus-orci-placerat-fringilla-donec', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 91, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/23\\/Newskit-images_0014_pexels-photo-296878.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 4, 7, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(163, 350, 'Suscipit luctus orci placerat fringilla Donec Sodf', 'suscipit-luctus-orci-placerat-fringilla-donec-sodf', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 91, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/23\\/Newskit-images_0022_pexels-photo-40120.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 2, 6, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(164, 351, 'Luctus Proin suscipit orci placerat fringilla Donec.', 'luctus-proin-suscipit-orci-placerat-fringilla-donec', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 91, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/23\\/Newskit-images_0043_jeff-sessions-task-force.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 2, 5, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(165, 352, 'Fringilla Proin suscipit luctus orci placerat  Donec. ', 'fringilla-proin-suscipit-luctus-orci-placerat-donec', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 91, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/23\\/Newskit-images_0037_pexels-photo-308798.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 2, 4, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(166, 353, 'Proin suscipit luctus orci placerat fringilla Cho Donec.', 'proin-suscipit-luctus-orci-placerat-fringilla-cho-donec', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 91, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/23\\/Newskit-images_0035_pexels-photo-4071881.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 2, 3, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(167, 354, 'Orci Proin suscipit luctus placerat fringilla Donec.', 'orci-proin-suscipit-luctus-placerat-fringilla-donec', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 91, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/23\\/Newskit-images_0034_smile-color-laugh-black-157907.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 2, 2, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(168, 355, 'volutpat suscipit luctus orci placerat fringilla Donec.', 'volutpat-suscipit-luctus-orci-placerat-fringilla-donec', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 91, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/23\\/Newskit-images_0004_pexels-photo-418283.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 2, 1, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(169, 356, 'Vivamus vel  luctus orci placerat fringilla Donec.', 'vivamus-vel-luctus-orci-placerat-fringilla-donec', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 91, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/23\\/Newskit-images_0039_pexels-photo-206470.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 2, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(170, 357, 'But I must explain to you how all this mistaken idea', 'but-i-must-explain-to-you-how-all-this-mistaken-idea', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 92, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/09\\/Newskit-images_0008_pexels-photo-346392.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 2, 8, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(171, 358, 'Proin suscipit luctus orci placerat fringilla Donec. ', 'proin-suscipit-luctus-orci-placerat-fringilla-donec', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 92, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/23\\/Newskit-images_0014_pexels-photo-296878.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 4, 7, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(172, 359, 'Suscipit luctus orci placerat fringilla Donec Sodf', 'suscipit-luctus-orci-placerat-fringilla-donec-sodf', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 92, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/23\\/Newskit-images_0022_pexels-photo-40120.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 2, 6, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(173, 360, 'Luctus Proin suscipit orci placerat fringilla Donec.', 'luctus-proin-suscipit-orci-placerat-fringilla-donec', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 92, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/23\\/Newskit-images_0043_jeff-sessions-task-force.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 2, 5, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(174, 361, 'Fringilla Proin suscipit luctus orci placerat  Donec. ', 'fringilla-proin-suscipit-luctus-orci-placerat-donec', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 92, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/23\\/Newskit-images_0037_pexels-photo-308798.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 2, 4, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(175, 362, 'Proin suscipit luctus orci placerat fringilla Cho Donec.', 'proin-suscipit-luctus-orci-placerat-fringilla-cho-donec', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 92, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/23\\/Newskit-images_0035_pexels-photo-4071881.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 2, 3, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES
(176, 363, 'Orci Proin suscipit luctus placerat fringilla Donec.', 'orci-proin-suscipit-luctus-placerat-fringilla-donec', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 92, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/23\\/Newskit-images_0034_smile-color-laugh-black-157907.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 2, 2, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(177, 364, 'volutpat suscipit luctus orci placerat fringilla Donec.', 'volutpat-suscipit-luctus-orci-placerat-fringilla-donec', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 92, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/23\\/Newskit-images_0004_pexels-photo-418283.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 2, 1, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(178, 365, 'Vivamus vel  luctus orci placerat fringilla Donec.', 'vivamus-vel-luctus-orci-placerat-fringilla-donec', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s.</p>\r\n', '\r\n<p>when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>', 1, 92, '2017-11-30 08:02:42', 343, '', '2017-11-30 08:02:42', 343, 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"article_layout":"","show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_page_title":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":"","spfeatured_image":"images\\/2017\\/06\\/23\\/Newskit-images_0039_pexels-photo-206470.jpg","post_format":"standard","gallery":"","audio":"","video":"","link_title":"","link_url":"","quote_text":"","quote_author":"","post_status":""}', 2, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '');

-- --------------------------------------------------------

--
-- Table structure for table `#__contentitem_tag_map`
--

DROP TABLE IF EXISTS `#__contentitem_tag_map`;
CREATE TABLE `#__contentitem_tag_map` (
  `type_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_content_id` int(10) unsigned NOT NULL COMMENT 'PK from the core content table',
  `content_item_id` int(11) NOT NULL COMMENT 'PK from the content type table',
  `tag_id` int(10) unsigned NOT NULL COMMENT 'PK from the tag table',
  `tag_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Date of most recent save for this tag-item',
  `type_id` mediumint(8) NOT NULL COMMENT 'PK from the content_type table'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Maps items from content tables to tags';

--
-- Dumping data for table `#__contentitem_tag_map`
--

INSERT INTO `#__contentitem_tag_map` (`type_alias`, `core_content_id`, `content_item_id`, `tag_id`, `tag_date`, `type_id`) VALUES
('com_content.article', 1, 78, 6, '2017-11-30 02:02:42', 1),
('com_content.article', 1, 78, 7, '2017-11-30 02:02:42', 1),
('com_content.article', 1, 78, 8, '2017-11-30 02:02:42', 1);

-- --------------------------------------------------------

--
-- Table structure for table `#__content_frontpage`
--

DROP TABLE IF EXISTS `#__content_frontpage`;
CREATE TABLE `#__content_frontpage` (
  `content_id` int(11) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__content_frontpage`
--

INSERT INTO `#__content_frontpage` (`content_id`, `ordering`) VALUES
(8, 6),
(24, 5),
(35, 8),
(50, 7),
(90, 1),
(108, 3),
(118, 4),
(125, 2);

-- --------------------------------------------------------

--
-- Table structure for table `#__content_rating`
--

DROP TABLE IF EXISTS `#__content_rating`;
CREATE TABLE `#__content_rating` (
  `content_id` int(11) NOT NULL DEFAULT '0',
  `rating_sum` int(10) unsigned NOT NULL DEFAULT '0',
  `rating_count` int(10) unsigned NOT NULL DEFAULT '0',
  `lastip` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__content_rating`
--

INSERT INTO `#__content_rating` (`content_id`, `rating_sum`, `rating_count`, `lastip`) VALUES
(72, 5, 1, '::1'),
(73, 5, 1, '::1'),
(74, 9, 2, '14.1.100.85'),
(75, 4, 1, '::1'),
(77, 5, 1, '::1');

-- --------------------------------------------------------

--
-- Table structure for table `#__content_types`
--

DROP TABLE IF EXISTS `#__content_types`;
CREATE TABLE `#__content_types` (
  `type_id` int(10) unsigned NOT NULL,
  `type_title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type_alias` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `table` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `rules` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_mappings` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `router` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `content_history_options` varchar(5120) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'JSON string for com_contenthistory options'
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__content_types`
--

INSERT INTO `#__content_types` (`type_id`, `type_title`, `type_alias`, `table`, `rules`, `field_mappings`, `router`, `content_history_options`) VALUES
(1, 'Article', 'com_content.article', '{"special":{"dbtable":"#__content","key":"id","type":"Content","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"state","core_alias":"alias","core_created_time":"created","core_modified_time":"modified","core_body":"introtext", "core_hits":"hits","core_publish_up":"publish_up","core_publish_down":"publish_down","core_access":"access", "core_params":"attribs", "core_featured":"featured", "core_metadata":"metadata", "core_language":"language", "core_images":"images", "core_urls":"urls", "core_version":"version", "core_ordering":"ordering", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"catid", "core_xreference":"xreference", "asset_id":"asset_id"}, "special":{"fulltext":"fulltext"}}', 'ContentHelperRoute::getArticleRoute', '{"formFile":"administrator\\/components\\/com_content\\/models\\/forms\\/article.xml", "hideFields":["asset_id","checked_out","checked_out_time","version"],"ignoreChanges":["modified_by", "modified", "checked_out", "checked_out_time", "version", "hits"],"convertToInt":["publish_up", "publish_down", "featured", "ordering"],"displayLookup":[{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"created_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"} ]}'),
(2, 'Weblink', 'com_weblinks.weblink', '{"special":{"dbtable":"#__weblinks","key":"id","type":"Weblink","prefix":"WeblinksTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"state","core_alias":"alias","core_created_time":"created","core_modified_time":"modified","core_body":"description", "core_hits":"hits","core_publish_up":"publish_up","core_publish_down":"publish_down","core_access":"access", "core_params":"params", "core_featured":"featured", "core_metadata":"metadata", "core_language":"language", "core_images":"images", "core_urls":"urls", "core_version":"version", "core_ordering":"ordering", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"catid", "core_xreference":"xreference", "asset_id":"null"}, "special":{}}', 'WeblinksHelperRoute::getWeblinkRoute', '{"formFile":"administrator\\/components\\/com_weblinks\\/models\\/forms\\/weblink.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","featured","images"], "ignoreChanges":["modified_by", "modified", "checked_out", "checked_out_time", "version", "hits"], "convertToInt":["publish_up", "publish_down", "featured", "ordering"], "displayLookup":[{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"created_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"} ]}'),
(3, 'Contact', 'com_contact.contact', '{"special":{"dbtable":"#__contact_details","key":"id","type":"Contact","prefix":"ContactTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"name","core_state":"published","core_alias":"alias","core_created_time":"created","core_modified_time":"modified","core_body":"address", "core_hits":"hits","core_publish_up":"publish_up","core_publish_down":"publish_down","core_access":"access", "core_params":"params", "core_featured":"featured", "core_metadata":"metadata", "core_language":"language", "core_images":"image", "core_urls":"webpage", "core_version":"version", "core_ordering":"ordering", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"catid", "core_xreference":"xreference", "asset_id":"null"}, "special":{"con_position":"con_position","suburb":"suburb","state":"state","country":"country","postcode":"postcode","telephone":"telephone","fax":"fax","misc":"misc","email_to":"email_to","default_con":"default_con","user_id":"user_id","mobile":"mobile","sortname1":"sortname1","sortname2":"sortname2","sortname3":"sortname3"}}', 'ContactHelperRoute::getContactRoute', '{"formFile":"administrator\\/components\\/com_contact\\/models\\/forms\\/contact.xml","hideFields":["default_con","checked_out","checked_out_time","version","xreference"],"ignoreChanges":["modified_by", "modified", "checked_out", "checked_out_time", "version", "hits"],"convertToInt":["publish_up", "publish_down", "featured", "ordering"], "displayLookup":[ {"sourceColumn":"created_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"} ] }'),
(4, 'Newsfeed', 'com_newsfeeds.newsfeed', '{"special":{"dbtable":"#__newsfeeds","key":"id","type":"Newsfeed","prefix":"NewsfeedsTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"name","core_state":"published","core_alias":"alias","core_created_time":"created","core_modified_time":"modified","core_body":"description", "core_hits":"hits","core_publish_up":"publish_up","core_publish_down":"publish_down","core_access":"access", "core_params":"params", "core_featured":"featured", "core_metadata":"metadata", "core_language":"language", "core_images":"images", "core_urls":"link", "core_version":"version", "core_ordering":"ordering", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"catid", "core_xreference":"xreference", "asset_id":"null"}, "special":{"numarticles":"numarticles","cache_time":"cache_time","rtl":"rtl"}}', 'NewsfeedsHelperRoute::getNewsfeedRoute', '{"formFile":"administrator\\/components\\/com_newsfeeds\\/models\\/forms\\/newsfeed.xml","hideFields":["asset_id","checked_out","checked_out_time","version"],"ignoreChanges":["modified_by", "modified", "checked_out", "checked_out_time", "version", "hits"],"convertToInt":["publish_up", "publish_down", "featured", "ordering"],"displayLookup":[{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"created_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"} ]}'),
(5, 'User', 'com_users.user', '{"special":{"dbtable":"#__users","key":"id","type":"User","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"name","core_state":"null","core_alias":"username","core_created_time":"registerdate","core_modified_time":"lastvisitDate","core_body":"null", "core_hits":"null","core_publish_up":"null","core_publish_down":"null","access":"null", "core_params":"params", "core_featured":"null", "core_metadata":"null", "core_language":"null", "core_images":"null", "core_urls":"null", "core_version":"null", "core_ordering":"null", "core_metakey":"null", "core_metadesc":"null", "core_catid":"null", "core_xreference":"null", "asset_id":"null"}, "special":{}}', 'UsersHelperRoute::getUserRoute', ''),
(6, 'Article Category', 'com_content.category', '{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}, "special":{"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}}', 'ContentHelperRoute::getCategoryRoute', '{"formFile":"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"],"convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}'),
(7, 'Contact Category', 'com_contact.category', '{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}, "special":{"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}}', 'ContactHelperRoute::getCategoryRoute', '{"formFile":"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"],"convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}'),
(8, 'Newsfeeds Category', 'com_newsfeeds.category', '{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}, "special":{"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}}', 'NewsfeedsHelperRoute::getCategoryRoute', '{"formFile":"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"],"convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}'),
(9, 'Weblinks Category', 'com_weblinks.category', '{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}, "special":{"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}}', 'WeblinksHelperRoute::getCategoryRoute', '{"formFile":"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"],"convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}'),
(10, 'Tag', 'com_tags.tag', '{"special":{"dbtable":"#__tags","key":"tag_id","type":"Tag","prefix":"TagsTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"featured", "core_metadata":"metadata", "core_language":"language", "core_images":"images", "core_urls":"urls", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"null", "core_xreference":"null", "asset_id":"null"}, "special":{"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path"}}', 'TagsHelperRoute::getTagRoute', '{"formFile":"administrator\\/components\\/com_tags\\/models\\/forms\\/tag.xml", "hideFields":["checked_out","checked_out_time","version", "lft", "rgt", "level", "path", "urls", "publish_up", "publish_down"],"ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"],"convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}, {"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"}, {"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}]}'),
(11, 'Banner', 'com_banners.banner', '{"special":{"dbtable":"#__banners","key":"id","type":"Banner","prefix":"BannersTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"name","core_state":"published","core_alias":"alias","core_created_time":"created","core_modified_time":"modified","core_body":"description", "core_hits":"null","core_publish_up":"publish_up","core_publish_down":"publish_down","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"images", "core_urls":"link", "core_version":"version", "core_ordering":"ordering", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"catid", "core_xreference":"null", "asset_id":"null"}, "special":{"imptotal":"imptotal", "impmade":"impmade", "clicks":"clicks", "clickurl":"clickurl", "custombannercode":"custombannercode", "cid":"cid", "purchase_type":"purchase_type", "track_impressions":"track_impressions", "track_clicks":"track_clicks"}}', '', '{"formFile":"administrator\\/components\\/com_banners\\/models\\/forms\\/banner.xml", "hideFields":["checked_out","checked_out_time","version", "reset"],"ignoreChanges":["modified_by", "modified", "checked_out", "checked_out_time", "version", "imptotal", "impmade", "reset"], "convertToInt":["publish_up", "publish_down", "ordering"], "displayLookup":[{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}, {"sourceColumn":"cid","targetTable":"#__banner_clients","targetColumn":"id","displayColumn":"name"}, {"sourceColumn":"created_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"modified_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"} ]}'),
(12, 'Banners Category', 'com_banners.category', '{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}, "special": {"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}}', '', '{"formFile":"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"], "convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}'),
(13, 'Banner Client', 'com_banners.client', '{"special":{"dbtable":"#__banner_clients","key":"id","type":"Client","prefix":"BannersTable"}}', '', '', '', '{"formFile":"administrator\\/components\\/com_banners\\/models\\/forms\\/client.xml", "hideFields":["checked_out","checked_out_time"], "ignoreChanges":["checked_out", "checked_out_time"], "convertToInt":[], "displayLookup":[]}'),
(14, 'User Notes', 'com_users.note', '{"special":{"dbtable":"#__user_notes","key":"id","type":"Note","prefix":"UsersTable"}}', '', '', '', '{"formFile":"administrator\\/components\\/com_users\\/models\\/forms\\/note.xml", "hideFields":["checked_out","checked_out_time", "publish_up", "publish_down"],"ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time"], "convertToInt":["publish_up", "publish_down"],"displayLookup":[{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}, {"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}, {"sourceColumn":"user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}, {"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}]}'),
(15, 'User Notes Category', 'com_users.category', '{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}, "special":{"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}}', '', '{"formFile":"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml", "hideFields":["checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"], "convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}, {"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}');

-- --------------------------------------------------------

--
-- Table structure for table `#__core_log_searches`
--

DROP TABLE IF EXISTS `#__core_log_searches`;
CREATE TABLE `#__core_log_searches` (
  `search_term` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `hits` int(10) unsigned NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__extensions`
--

DROP TABLE IF EXISTS `#__extensions`;
CREATE TABLE `#__extensions` (
  `extension_id` int(11) NOT NULL,
  `package_id` int(11) NOT NULL DEFAULT '0' COMMENT 'Parent package ID for extensions installed as a package.',
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `element` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `folder` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_id` tinyint(3) NOT NULL,
  `enabled` tinyint(3) NOT NULL DEFAULT '0',
  `access` int(10) unsigned NOT NULL DEFAULT '1',
  `protected` tinyint(3) NOT NULL DEFAULT '0',
  `manifest_cache` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `custom_data` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `system_data` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) DEFAULT '0',
  `state` int(11) DEFAULT '0'
) ENGINE=InnoDB AUTO_INCREMENT=10052 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__extensions`
--

INSERT INTO `#__extensions` (`extension_id`, `package_id`, `name`, `type`, `element`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `system_data`, `checked_out`, `checked_out_time`, `ordering`, `state`) VALUES
(1, 0, 'com_mailto', 'component', 'com_mailto', '', 0, 1, 1, 1, '{"name":"com_mailto","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_MAILTO_XML_DESCRIPTION","group":"","filename":"mailto"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(2, 0, 'com_wrapper', 'component', 'com_wrapper', '', 0, 1, 1, 1, '{"name":"com_wrapper","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.\\n\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_WRAPPER_XML_DESCRIPTION","group":"","filename":"wrapper"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(3, 0, 'com_admin', 'component', 'com_admin', '', 1, 1, 1, 1, '{"name":"com_admin","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_ADMIN_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(4, 0, 'com_banners', 'component', 'com_banners', '', 1, 1, 1, 0, '{"name":"com_banners","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_BANNERS_XML_DESCRIPTION","group":"","filename":"banners"}', '{"purchase_type":"3","track_impressions":"0","track_clicks":"0","metakey_prefix":"","save_history":"1","history_limit":10}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(5, 0, 'com_cache', 'component', 'com_cache', '', 1, 1, 1, 1, '{"name":"com_cache","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CACHE_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(6, 0, 'com_categories', 'component', 'com_categories', '', 1, 1, 1, 1, '{"name":"com_categories","type":"component","creationDate":"December 2007","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CATEGORIES_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(7, 0, 'com_checkin', 'component', 'com_checkin', '', 1, 1, 1, 1, '{"name":"com_checkin","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CHECKIN_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(8, 0, 'com_contact', 'component', 'com_contact', '', 1, 1, 1, 0, '{"name":"com_contact","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CONTACT_XML_DESCRIPTION","group":"","filename":"contact"}', '{"show_contact_category":"hide","save_history":"1","history_limit":10,"show_contact_list":"0","presentation_style":"sliders","show_name":"1","show_position":"1","show_email":"0","show_street_address":"1","show_suburb":"1","show_state":"1","show_postcode":"1","show_country":"1","show_telephone":"1","show_mobile":"1","show_fax":"1","show_webpage":"1","show_misc":"1","show_image":"1","image":"","allow_vcard":"0","show_articles":"0","show_profile":"0","show_links":"0","linka_name":"","linkb_name":"","linkc_name":"","linkd_name":"","linke_name":"","contact_icons":"0","icon_address":"","icon_email":"","icon_telephone":"","icon_mobile":"","icon_fax":"","icon_misc":"","show_headings":"1","show_position_headings":"1","show_email_headings":"0","show_telephone_headings":"1","show_mobile_headings":"0","show_fax_headings":"0","allow_vcard_headings":"0","show_suburb_headings":"1","show_state_headings":"1","show_country_headings":"1","show_email_form":"1","show_email_copy":"1","banned_email":"","banned_subject":"","banned_text":"","validate_session":"1","custom_reply":"0","redirect":"","show_category_crumb":"0","metakey":"","metadesc":"","robots":"","author":"","rights":"","xreference":""}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(9, 0, 'com_cpanel', 'component', 'com_cpanel', '', 1, 1, 1, 1, '{"name":"com_cpanel","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CPANEL_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10, 0, 'com_installer', 'component', 'com_installer', '', 1, 1, 1, 1, '{"name":"com_installer","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_INSTALLER_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(11, 0, 'com_languages', 'component', 'com_languages', '', 1, 1, 1, 1, '{"name":"com_languages","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_LANGUAGES_XML_DESCRIPTION","group":""}', '{"administrator":"en-GB","site":"en-GB"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(12, 0, 'com_login', 'component', 'com_login', '', 1, 1, 1, 1, '{"name":"com_login","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_LOGIN_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(13, 0, 'com_media', 'component', 'com_media', '', 1, 1, 0, 1, '{"name":"com_media","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_MEDIA_XML_DESCRIPTION","group":"","filename":"media"}', '{"upload_extensions":"bmp,csv,doc,gif,ico,jpg,jpeg,odg,odp,ods,odt,pdf,png,ppt,swf,txt,xcf,xls,BMP,CSV,DOC,GIF,ICO,JPG,JPEG,ODG,ODP,ODS,ODT,PDF,PNG,PPT,SWF,TXT,XCF,XLS","upload_maxsize":"10","file_path":"images","image_path":"images","restrict_uploads":"1","allowed_media_usergroup":"3","check_mime":"1","image_extensions":"bmp,gif,jpg,png","ignore_extensions":"","upload_mime":"image\\/jpeg,image\\/gif,image\\/png,image\\/bmp,application\\/x-shockwave-flash,application\\/msword,application\\/excel,application\\/pdf,application\\/powerpoint,text\\/plain,application\\/x-zip","upload_mime_illegal":"text\\/html"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(14, 0, 'com_menus', 'component', 'com_menus', '', 1, 1, 1, 1, '{"name":"com_menus","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_MENUS_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(15, 0, 'com_messages', 'component', 'com_messages', '', 1, 1, 1, 1, '{"name":"com_messages","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_MESSAGES_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(16, 0, 'com_modules', 'component', 'com_modules', '', 1, 1, 1, 1, '{"name":"com_modules","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_MODULES_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(17, 0, 'com_newsfeeds', 'component', 'com_newsfeeds', '', 1, 1, 1, 0, '{"name":"com_newsfeeds","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_NEWSFEEDS_XML_DESCRIPTION","group":"","filename":"newsfeeds"}', '{"newsfeed_layout":"_:default","save_history":"1","history_limit":5,"show_feed_image":"1","show_feed_description":"1","show_item_description":"1","feed_character_count":"0","feed_display_order":"des","float_first":"right","float_second":"right","show_tags":"1","category_layout":"_:default","show_category_title":"1","show_description":"1","show_description_image":"1","maxLevel":"-1","show_empty_categories":"0","show_subcat_desc":"1","show_cat_items":"1","show_cat_tags":"1","show_base_description":"1","maxLevelcat":"-1","show_empty_categories_cat":"0","show_subcat_desc_cat":"1","show_cat_items_cat":"1","filter_field":"1","show_pagination_limit":"1","show_headings":"1","show_articles":"0","show_link":"1","show_pagination":"1","show_pagination_results":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(18, 0, 'com_plugins', 'component', 'com_plugins', '', 1, 1, 1, 1, '{"name":"com_plugins","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_PLUGINS_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(19, 0, 'com_search', 'component', 'com_search', '', 1, 1, 1, 0, '{"name":"com_search","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_SEARCH_XML_DESCRIPTION","group":"","filename":"search"}', '{"enabled":"0","show_date":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(20, 0, 'com_templates', 'component', 'com_templates', '', 1, 1, 1, 1, '{"name":"com_templates","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_TEMPLATES_XML_DESCRIPTION","group":""}', '{"template_positions_display":"0","upload_limit":"2","image_formats":"gif,bmp,jpg,jpeg,png","source_formats":"txt,less,ini,xml,js,php,css","font_formats":"woff,ttf,otf","compressed_formats":"zip"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(22, 0, 'com_content', 'component', 'com_content', '', 1, 1, 0, 1, '{"name":"com_content","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CONTENT_XML_DESCRIPTION","group":"","filename":"content"}', '{"article_layout":"_:default","show_title":"1","link_titles":"1","show_intro":"0","info_block_position":"0","info_block_show_title":"1","show_category":"1","link_category":"1","show_parent_category":"0","link_parent_category":"0","show_associations":"0","flags":"1","show_author":"1","link_author":"1","show_create_date":"0","show_modify_date":"0","show_publish_date":"1","show_item_navigation":"1","show_vote":"0","show_readmore":"0","show_readmore_title":"0","readmore_limit":"100","show_tags":"1","show_icons":"0","show_print_icon":"0","show_email_icon":"0","show_hits":"1","show_noauth":"0","urls_position":"0","captcha":"","show_publishing_options":"1","show_article_options":"1","save_history":"1","history_limit":10,"show_urls_images_frontend":"0","show_urls_images_backend":"1","targeta":0,"targetb":0,"targetc":0,"float_intro":"left","float_fulltext":"left","category_layout":"_:blog","show_category_heading_title_text":"1","show_category_title":"0","show_description":"0","show_description_image":"0","maxLevel":"0","show_empty_categories":"0","show_no_articles":"1","show_subcat_desc":"0","show_cat_num_articles":"0","show_cat_tags":"1","show_base_description":"1","maxLevelcat":"-1","show_empty_categories_cat":"0","show_subcat_desc_cat":"0","show_cat_num_articles_cat":"1","num_leading_articles":"3","num_intro_articles":"12","num_columns":"3","num_links":"0","multi_column_order":"0","show_subcategory_content":"0","show_pagination_limit":"1","filter_field":"hide","show_headings":"1","list_show_date":"0","date_format":"","list_show_hits":"1","list_show_author":"1","list_show_votes":"0","list_show_ratings":"0","orderby_pri":"order","orderby_sec":"rdate","order_date":"published","show_pagination":"2","show_pagination_results":"0","show_featured":"show","show_feed_link":"1","feed_summary":"0","feed_show_readmore":"0","custom_fields_enable":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(23, 0, 'com_config', 'component', 'com_config', '', 1, 1, 0, 1, '{"name":"com_config","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CONFIG_XML_DESCRIPTION","group":""}', '{"filters":{"1":{"filter_type":"NH","filter_tags":"","filter_attributes":""},"9":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"6":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"7":{"filter_type":"NONE","filter_tags":"","filter_attributes":""},"2":{"filter_type":"NH","filter_tags":"","filter_attributes":""},"3":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"4":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"5":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"8":{"filter_type":"NONE","filter_tags":"","filter_attributes":""}}}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(24, 0, 'com_redirect', 'component', 'com_redirect', '', 1, 1, 0, 1, '{"name":"com_redirect","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_REDIRECT_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(25, 0, 'com_users', 'component', 'com_users', '', 1, 1, 0, 1, '{"name":"com_users","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_USERS_XML_DESCRIPTION","group":"","filename":"users"}', '{"allowUserRegistration":"1","new_usertype":"2","guest_usergroup":"13","sendpassword":"1","useractivation":"1","mail_to_admin":"0","captcha":"","frontend_userparams":"1","site_language":"0","change_login_name":"0","reset_count":"10","reset_time":"1","mailSubjectPrefix":"","mailBodySuffix":"","save_history":"1","history_limit":5}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(27, 0, 'com_finder', 'component', 'com_finder', '', 1, 1, 0, 0, '{"name":"com_finder","type":"component","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_FINDER_XML_DESCRIPTION","group":"","filename":"finder"}', '{"show_description":"1","description_length":255,"allow_empty_query":"0","show_url":"1","show_advanced":"1","expand_advanced":"0","show_date_filters":"0","highlight_terms":"1","opensearch_name":"","opensearch_description":"","batch_size":"50","memory_table_limit":30000,"title_multiplier":"1.7","text_multiplier":"0.7","meta_multiplier":"1.2","path_multiplier":"2.0","misc_multiplier":"0.3","stemmer":"snowball"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(28, 0, 'com_joomlaupdate', 'component', 'com_joomlaupdate', '', 1, 1, 0, 1, '{"name":"com_joomlaupdate","type":"component","creationDate":"February 2012","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.6.2","description":"COM_JOOMLAUPDATE_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(29, 0, 'com_tags', 'component', 'com_tags', '', 1, 1, 1, 1, '{"name":"com_tags","type":"component","creationDate":"December 2013","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.1.0","description":"COM_TAGS_XML_DESCRIPTION","group":"","filename":"tags"}', '{"tag_layout":"_:default","save_history":"1","history_limit":5,"show_tag_title":"0","tag_list_show_tag_image":"0","tag_list_show_tag_description":"0","tag_list_image":"","show_tag_num_items":"0","tag_list_orderby":"title","tag_list_orderby_direction":"ASC","show_headings":"0","tag_list_show_date":"0","tag_list_show_item_image":"0","tag_list_show_item_description":"0","tag_list_item_maximum_characters":0,"return_any_or_all":"1","include_children":"0","maximum":200,"tag_list_language_filter":"all","tags_layout":"_:default","all_tags_orderby":"title","all_tags_orderby_direction":"ASC","all_tags_show_tag_image":"0","all_tags_show_tag_descripion":"0","all_tags_tag_maximum_characters":20,"all_tags_show_tag_hits":"0","filter_field":"1","show_pagination_limit":"1","show_pagination":"2","show_pagination_results":"1","tag_field_ajax_mode":"1","show_feed_link":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(30, 0, 'com_contenthistory', 'component', 'com_contenthistory', '', 1, 1, 1, 0, '{"name":"com_contenthistory","type":"component","creationDate":"May 2013","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.0","description":"COM_CONTENTHISTORY_XML_DESCRIPTION","group":"","filename":"contenthistory"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(31, 0, 'com_ajax', 'component', 'com_ajax', '', 1, 1, 1, 1, '{"name":"com_ajax","type":"component","creationDate":"August 2013","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.0","description":"COM_AJAX_XML_DESCRIPTION","group":"","filename":"ajax"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(32, 0, 'com_postinstall', 'component', 'com_postinstall', '', 1, 1, 1, 1, '{"name":"com_postinstall","type":"component","creationDate":"September 2013","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.0","description":"COM_POSTINSTALL_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(33, 0, 'com_fields', 'component', 'com_fields', '', 1, 1, 1, 0, '{"name":"com_fields","type":"component","creationDate":"March 2016","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"COM_FIELDS_XML_DESCRIPTION","group":"","filename":"fields"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(34, 0, 'com_associations', 'component', 'com_associations', '', 1, 1, 1, 0, '{"name":"com_associations","type":"component","creationDate":"Januar 2017","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"COM_ASSOCIATIONS_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(102, 0, 'LIB_PHPUTF8', 'library', 'phputf8', '', 0, 1, 1, 1, '{"name":"LIB_PHPUTF8","type":"library","creationDate":"2006","author":"Harry Fuecks","copyright":"Copyright various authors","authorEmail":"hfuecks@gmail.com","authorUrl":"http:\\/\\/sourceforge.net\\/projects\\/phputf8","version":"0.5","description":"LIB_PHPUTF8_XML_DESCRIPTION","group":"","filename":"phputf8"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(103, 0, 'LIB_JOOMLA', 'library', 'joomla', '', 0, 1, 1, 1, '{"name":"LIB_JOOMLA","type":"library","creationDate":"2008","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"https:\\/\\/www.joomla.org","version":"13.1","description":"LIB_JOOMLA_XML_DESCRIPTION","group":"","filename":"joomla"}', '{"mediaversion":"e58a5c7cb787db5c6d9935d64f7ce6bc"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(104, 0, 'LIB_IDNA', 'library', 'idna_convert', '', 0, 1, 1, 1, '{"name":"LIB_IDNA","type":"library","creationDate":"2004","author":"phlyLabs","copyright":"2004-2011 phlyLabs Berlin, http:\\/\\/phlylabs.de","authorEmail":"phlymail@phlylabs.de","authorUrl":"http:\\/\\/phlylabs.de","version":"0.8.0","description":"LIB_IDNA_XML_DESCRIPTION","group":"","filename":"idna_convert"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(105, 0, 'FOF', 'library', 'fof', '', 0, 1, 1, 1, '{"name":"FOF","type":"library","creationDate":"2015-04-22 13:15:32","author":"Nicholas K. Dionysopoulos \\/ Akeeba Ltd","copyright":"(C)2011-2015 Nicholas K. Dionysopoulos","authorEmail":"nicholas@akeebabackup.com","authorUrl":"https:\\/\\/www.akeebabackup.com","version":"2.4.3","description":"LIB_FOF_XML_DESCRIPTION","group":"","filename":"fof"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(106, 0, 'LIB_PHPASS', 'library', 'phpass', '', 0, 1, 1, 1, '{"name":"LIB_PHPASS","type":"library","creationDate":"2004-2006","author":"Solar Designer","copyright":"","authorEmail":"solar@openwall.com","authorUrl":"http:\\/\\/www.openwall.com\\/phpass\\/","version":"0.3","description":"LIB_PHPASS_XML_DESCRIPTION","group":"","filename":"phpass"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(200, 0, 'mod_articles_archive', 'module', 'mod_articles_archive', '', 0, 1, 1, 0, '{"name":"mod_articles_archive","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_ARTICLES_ARCHIVE_XML_DESCRIPTION","group":"","filename":"mod_articles_archive"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(201, 0, 'mod_articles_latest', 'module', 'mod_articles_latest', '', 0, 1, 1, 0, '{"name":"mod_articles_latest","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_LATEST_NEWS_XML_DESCRIPTION","group":"","filename":"mod_articles_latest"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(202, 0, 'mod_articles_popular', 'module', 'mod_articles_popular', '', 0, 1, 1, 0, '{"name":"mod_articles_popular","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_POPULAR_XML_DESCRIPTION","group":"","filename":"mod_articles_popular"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(203, 0, 'mod_banners', 'module', 'mod_banners', '', 0, 1, 1, 0, '{"name":"mod_banners","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_BANNERS_XML_DESCRIPTION","group":"","filename":"mod_banners"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(204, 0, 'mod_breadcrumbs', 'module', 'mod_breadcrumbs', '', 0, 1, 1, 1, '{"name":"mod_breadcrumbs","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_BREADCRUMBS_XML_DESCRIPTION","group":"","filename":"mod_breadcrumbs"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(205, 0, 'mod_custom', 'module', 'mod_custom', '', 0, 1, 1, 1, '{"name":"mod_custom","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_CUSTOM_XML_DESCRIPTION","group":"","filename":"mod_custom"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(206, 0, 'mod_feed', 'module', 'mod_feed', '', 0, 1, 1, 0, '{"name":"mod_feed","type":"module","creationDate":"July 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_FEED_XML_DESCRIPTION","group":"","filename":"mod_feed"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(207, 0, 'mod_footer', 'module', 'mod_footer', '', 0, 1, 1, 0, '{"name":"mod_footer","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_FOOTER_XML_DESCRIPTION","group":"","filename":"mod_footer"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(208, 0, 'mod_login', 'module', 'mod_login', '', 0, 1, 1, 1, '{"name":"mod_login","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_LOGIN_XML_DESCRIPTION","group":"","filename":"mod_login"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(209, 0, 'mod_menu', 'module', 'mod_menu', '', 0, 1, 1, 1, '{"name":"mod_menu","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_MENU_XML_DESCRIPTION","group":"","filename":"mod_menu"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(210, 0, 'mod_articles_news', 'module', 'mod_articles_news', '', 0, 1, 1, 0, '{"name":"mod_articles_news","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_ARTICLES_NEWS_XML_DESCRIPTION","group":"","filename":"mod_articles_news"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(211, 0, 'mod_random_image', 'module', 'mod_random_image', '', 0, 1, 1, 0, '{"name":"mod_random_image","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_RANDOM_IMAGE_XML_DESCRIPTION","group":"","filename":"mod_random_image"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(212, 0, 'mod_related_items', 'module', 'mod_related_items', '', 0, 1, 1, 0, '{"name":"mod_related_items","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_RELATED_XML_DESCRIPTION","group":"","filename":"mod_related_items"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(213, 0, 'mod_search', 'module', 'mod_search', '', 0, 1, 1, 0, '{"name":"mod_search","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_SEARCH_XML_DESCRIPTION","group":"","filename":"mod_search"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(214, 0, 'mod_stats', 'module', 'mod_stats', '', 0, 1, 1, 0, '{"name":"mod_stats","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_STATS_XML_DESCRIPTION","group":"","filename":"mod_stats"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(215, 0, 'mod_syndicate', 'module', 'mod_syndicate', '', 0, 1, 1, 1, '{"name":"mod_syndicate","type":"module","creationDate":"May 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_SYNDICATE_XML_DESCRIPTION","group":"","filename":"mod_syndicate"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(216, 0, 'mod_users_latest', 'module', 'mod_users_latest', '', 0, 1, 1, 0, '{"name":"mod_users_latest","type":"module","creationDate":"December 2009","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_USERS_LATEST_XML_DESCRIPTION","group":"","filename":"mod_users_latest"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(218, 0, 'mod_whosonline', 'module', 'mod_whosonline', '', 0, 1, 1, 0, '{"name":"mod_whosonline","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_WHOSONLINE_XML_DESCRIPTION","group":"","filename":"mod_whosonline"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(219, 0, 'mod_wrapper', 'module', 'mod_wrapper', '', 0, 1, 1, 0, '{"name":"mod_wrapper","type":"module","creationDate":"October 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_WRAPPER_XML_DESCRIPTION","group":"","filename":"mod_wrapper"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(220, 0, 'mod_articles_category', 'module', 'mod_articles_category', '', 0, 1, 1, 0, '{"name":"mod_articles_category","type":"module","creationDate":"February 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_ARTICLES_CATEGORY_XML_DESCRIPTION","group":"","filename":"mod_articles_category"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(221, 0, 'mod_articles_categories', 'module', 'mod_articles_categories', '', 0, 1, 1, 0, '{"name":"mod_articles_categories","type":"module","creationDate":"February 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_ARTICLES_CATEGORIES_XML_DESCRIPTION","group":"","filename":"mod_articles_categories"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(222, 0, 'mod_languages', 'module', 'mod_languages', '', 0, 1, 1, 1, '{"name":"mod_languages","type":"module","creationDate":"February 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.5.0","description":"MOD_LANGUAGES_XML_DESCRIPTION","group":"","filename":"mod_languages"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(223, 0, 'mod_finder', 'module', 'mod_finder', '', 0, 1, 0, 0, '{"name":"mod_finder","type":"module","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_FINDER_XML_DESCRIPTION","group":"","filename":"mod_finder"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(300, 0, 'mod_custom', 'module', 'mod_custom', '', 1, 1, 1, 1, '{"name":"mod_custom","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_CUSTOM_XML_DESCRIPTION","group":"","filename":"mod_custom"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(301, 0, 'mod_feed', 'module', 'mod_feed', '', 1, 1, 1, 0, '{"name":"mod_feed","type":"module","creationDate":"July 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_FEED_XML_DESCRIPTION","group":"","filename":"mod_feed"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(302, 0, 'mod_latest', 'module', 'mod_latest', '', 1, 1, 1, 0, '{"name":"mod_latest","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_LATEST_XML_DESCRIPTION","group":"","filename":"mod_latest"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(303, 0, 'mod_logged', 'module', 'mod_logged', '', 1, 1, 1, 0, '{"name":"mod_logged","type":"module","creationDate":"January 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_LOGGED_XML_DESCRIPTION","group":"","filename":"mod_logged"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(304, 0, 'mod_login', 'module', 'mod_login', '', 1, 1, 1, 1, '{"name":"mod_login","type":"module","creationDate":"March 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_LOGIN_XML_DESCRIPTION","group":"","filename":"mod_login"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(305, 0, 'mod_menu', 'module', 'mod_menu', '', 1, 1, 1, 0, '{"name":"mod_menu","type":"module","creationDate":"March 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_MENU_XML_DESCRIPTION","group":"","filename":"mod_menu"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(307, 0, 'mod_popular', 'module', 'mod_popular', '', 1, 1, 1, 0, '{"name":"mod_popular","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_POPULAR_XML_DESCRIPTION","group":"","filename":"mod_popular"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(308, 0, 'mod_quickicon', 'module', 'mod_quickicon', '', 1, 1, 1, 1, '{"name":"mod_quickicon","type":"module","creationDate":"Nov 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_QUICKICON_XML_DESCRIPTION","group":"","filename":"mod_quickicon"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(309, 0, 'mod_status', 'module', 'mod_status', '', 1, 1, 1, 0, '{"name":"mod_status","type":"module","creationDate":"Feb 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_STATUS_XML_DESCRIPTION","group":"","filename":"mod_status"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(310, 0, 'mod_submenu', 'module', 'mod_submenu', '', 1, 1, 1, 0, '{"name":"mod_submenu","type":"module","creationDate":"Feb 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_SUBMENU_XML_DESCRIPTION","group":"","filename":"mod_submenu"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(311, 0, 'mod_title', 'module', 'mod_title', '', 1, 1, 1, 0, '{"name":"mod_title","type":"module","creationDate":"Nov 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_TITLE_XML_DESCRIPTION","group":"","filename":"mod_title"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(312, 0, 'mod_toolbar', 'module', 'mod_toolbar', '', 1, 1, 1, 1, '{"name":"mod_toolbar","type":"module","creationDate":"Nov 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_TOOLBAR_XML_DESCRIPTION","group":"","filename":"mod_toolbar"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(313, 0, 'mod_multilangstatus', 'module', 'mod_multilangstatus', '', 1, 1, 1, 0, '{"name":"mod_multilangstatus","type":"module","creationDate":"September 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_MULTILANGSTATUS_XML_DESCRIPTION","group":"","filename":"mod_multilangstatus"}', '{"cache":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(314, 0, 'mod_version', 'module', 'mod_version', '', 1, 1, 1, 0, '{"name":"mod_version","type":"module","creationDate":"January 2012","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_VERSION_XML_DESCRIPTION","group":"","filename":"mod_version"}', '{"format":"short","product":"1","cache":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(315, 0, 'mod_stats_admin', 'module', 'mod_stats_admin', '', 1, 1, 1, 0, '{"name":"mod_stats_admin","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_STATS_XML_DESCRIPTION","group":"","filename":"mod_stats_admin"}', '{"serverinfo":"0","siteinfo":"0","counter":"0","increase":"0","cache":"1","cache_time":"900","cachemode":"static"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(316, 0, 'mod_tags_popular', 'module', 'mod_tags_popular', '', 0, 1, 1, 0, '{"name":"mod_tags_popular","type":"module","creationDate":"January 2013","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.1.0","description":"MOD_TAGS_POPULAR_XML_DESCRIPTION","group":"","filename":"mod_tags_popular"}', '{"maximum":"5","timeframe":"alltime","owncache":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(317, 0, 'mod_tags_similar', 'module', 'mod_tags_similar', '', 0, 1, 1, 0, '{"name":"mod_tags_similar","type":"module","creationDate":"January 2013","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.1.0","description":"MOD_TAGS_SIMILAR_XML_DESCRIPTION","group":"","filename":"mod_tags_similar"}', '{"maximum":"5","matchtype":"any","owncache":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(318, 0, 'mod_sampledata', 'module', 'mod_sampledata', '', 1, 0, 1, 0, '{"name":"mod_sampledata","type":"module","creationDate":"July 2017","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.8.0","description":"MOD_SAMPLEDATA_XML_DESCRIPTION","group":"","filename":"mod_sampledata"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(400, 0, 'plg_authentication_gmail', 'plugin', 'gmail', 'authentication', 0, 0, 1, 0, '{"name":"plg_authentication_gmail","type":"plugin","creationDate":"February 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_GMAIL_XML_DESCRIPTION","group":"","filename":"gmail"}', '{"applysuffix":"0","suffix":"","verifypeer":"1","user_blacklist":""}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(401, 0, 'plg_authentication_joomla', 'plugin', 'joomla', 'authentication', 0, 1, 1, 1, '{"name":"plg_authentication_joomla","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_AUTH_JOOMLA_XML_DESCRIPTION","group":"","filename":"joomla"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(402, 0, 'plg_authentication_ldap', 'plugin', 'ldap', 'authentication', 0, 0, 1, 0, '{"name":"plg_authentication_ldap","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_LDAP_XML_DESCRIPTION","group":"","filename":"ldap"}', '{"host":"","port":"389","use_ldapV3":"0","negotiate_tls":"0","no_referrals":"0","auth_method":"bind","base_dn":"","search_string":"","users_dn":"","username":"admin","password":"bobby7","ldap_fullname":"fullName","ldap_email":"mail","ldap_uid":"uid"}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(403, 0, 'plg_content_contact', 'plugin', 'contact', 'content', 0, 1, 1, 0, '{"name":"plg_content_contact","type":"plugin","creationDate":"January 2014","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.2","description":"PLG_CONTENT_CONTACT_XML_DESCRIPTION","group":"","filename":"contact"}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(404, 0, 'plg_content_emailcloak', 'plugin', 'emailcloak', 'content', 0, 1, 1, 0, '{"name":"plg_content_emailcloak","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CONTENT_EMAILCLOAK_XML_DESCRIPTION","group":"","filename":"emailcloak"}', '{"mode":"1"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(406, 0, 'plg_content_loadmodule', 'plugin', 'loadmodule', 'content', 0, 1, 1, 0, '{"name":"plg_content_loadmodule","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_LOADMODULE_XML_DESCRIPTION","group":"","filename":"loadmodule"}', '{"style":"xhtml"}', '', '', 0, '2011-09-18 15:22:50', 0, 0),
(407, 0, 'plg_content_pagebreak', 'plugin', 'pagebreak', 'content', 0, 1, 1, 0, '{"name":"plg_content_pagebreak","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CONTENT_PAGEBREAK_XML_DESCRIPTION","group":"","filename":"pagebreak"}', '{"title":"1","multipage_toc":"1","showall":"1"}', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(408, 0, 'plg_content_pagenavigation', 'plugin', 'pagenavigation', 'content', 0, 1, 1, 0, '{"name":"plg_content_pagenavigation","type":"plugin","creationDate":"January 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_PAGENAVIGATION_XML_DESCRIPTION","group":"","filename":"pagenavigation"}', '{"position":"1"}', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(409, 0, 'plg_content_vote', 'plugin', 'vote', 'content', 0, 1, 1, 0, '{"name":"plg_content_vote","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_VOTE_XML_DESCRIPTION","group":"","filename":"vote"}', '', '', '', 0, '0000-00-00 00:00:00', 6, 0),
(410, 0, 'plg_editors_codemirror', 'plugin', 'codemirror', 'editors', 0, 1, 1, 1, '{"name":"plg_editors_codemirror","type":"plugin","creationDate":"28 March 2011","author":"Marijn Haverbeke","copyright":"Copyright (C) 2014 - 2017 by Marijn Haverbeke <marijnh@gmail.com> and others","authorEmail":"marijnh@gmail.com","authorUrl":"http:\\/\\/codemirror.net\\/","version":"5.30.0","description":"PLG_CODEMIRROR_XML_DESCRIPTION","group":"","filename":"codemirror"}', '{"lineNumbers":"1","lineWrapping":"1","matchTags":"1","matchBrackets":"1","marker-gutter":"1","autoCloseTags":"1","autoCloseBrackets":"1","autoFocus":"1","theme":"default","tabmode":"indent"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(411, 0, 'plg_editors_none', 'plugin', 'none', 'editors', 0, 1, 1, 1, '{"name":"plg_editors_none","type":"plugin","creationDate":"September 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_NONE_XML_DESCRIPTION","group":"","filename":"none"}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(412, 0, 'plg_editors_tinymce', 'plugin', 'tinymce', 'editors', 0, 1, 1, 0, '{"name":"plg_editors_tinymce","type":"plugin","creationDate":"2005-2017","author":"Ephox Corporation","copyright":"Ephox Corporation","authorEmail":"N\\/A","authorUrl":"http:\\/\\/www.tinymce.com","version":"4.5.7","description":"PLG_TINY_XML_DESCRIPTION","group":"","filename":"tinymce"}', '{"mode":"1","skin":"0","mobile":"0","entity_encoding":"raw","lang_mode":"1","text_direction":"ltr","content_css":"1","content_css_custom":"","relative_urls":"1","newlines":"0","invalid_elements":"script,applet,iframe","extended_elements":"","html_height":"550","html_width":"750","resizing":"1","element_path":"1","fonts":"1","paste":"1","searchreplace":"1","insertdate":"1","colors":"1","table":"1","smilies":"1","hr":"1","link":"1","media":"1","print":"1","directionality":"1","fullscreen":"1","alignment":"1","visualchars":"1","visualblocks":"1","nonbreaking":"1","template":"1","blockquote":"1","wordcount":"1","advlist":"1","autosave":"1","contextmenu":"1","inlinepopups":"1","custom_plugin":"","custom_button":""}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(413, 0, 'plg_editors-xtd_article', 'plugin', 'article', 'editors-xtd', 0, 1, 1, 0, '{"name":"plg_editors-xtd_article","type":"plugin","creationDate":"October 2009","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_ARTICLE_XML_DESCRIPTION","group":"","filename":"article"}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0);
INSERT INTO `#__extensions` (`extension_id`, `package_id`, `name`, `type`, `element`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `system_data`, `checked_out`, `checked_out_time`, `ordering`, `state`) VALUES
(414, 0, 'plg_editors-xtd_image', 'plugin', 'image', 'editors-xtd', 0, 1, 1, 0, '{"name":"plg_editors-xtd_image","type":"plugin","creationDate":"August 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_IMAGE_XML_DESCRIPTION","group":"","filename":"image"}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(415, 0, 'plg_editors-xtd_pagebreak', 'plugin', 'pagebreak', 'editors-xtd', 0, 1, 1, 0, '{"name":"plg_editors-xtd_pagebreak","type":"plugin","creationDate":"August 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_EDITORSXTD_PAGEBREAK_XML_DESCRIPTION","group":"","filename":"pagebreak"}', '', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(416, 0, 'plg_editors-xtd_readmore', 'plugin', 'readmore', 'editors-xtd', 0, 1, 1, 0, '{"name":"plg_editors-xtd_readmore","type":"plugin","creationDate":"March 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_READMORE_XML_DESCRIPTION","group":"","filename":"readmore"}', '', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(417, 0, 'plg_search_categories', 'plugin', 'categories', 'search', 0, 1, 1, 0, '{"name":"plg_search_categories","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEARCH_CATEGORIES_XML_DESCRIPTION","group":"","filename":"categories"}', '{"search_limit":"50","search_content":"1","search_archived":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(418, 0, 'plg_search_contacts', 'plugin', 'contacts', 'search', 0, 1, 1, 0, '{"name":"plg_search_contacts","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEARCH_CONTACTS_XML_DESCRIPTION","group":"","filename":"contacts"}', '{"search_limit":"50","search_content":"1","search_archived":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(419, 0, 'plg_search_content', 'plugin', 'content', 'search', 0, 1, 1, 0, '{"name":"plg_search_content","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEARCH_CONTENT_XML_DESCRIPTION","group":"","filename":"content"}', '{"search_limit":"50","search_content":"1","search_archived":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(420, 0, 'plg_search_newsfeeds', 'plugin', 'newsfeeds', 'search', 0, 1, 1, 0, '{"name":"plg_search_newsfeeds","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEARCH_NEWSFEEDS_XML_DESCRIPTION","group":"","filename":"newsfeeds"}', '{"search_limit":"50","search_content":"1","search_archived":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(422, 0, 'plg_system_languagefilter', 'plugin', 'languagefilter', 'system', 0, 0, 1, 1, '{"name":"plg_system_languagefilter","type":"plugin","creationDate":"July 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SYSTEM_LANGUAGEFILTER_XML_DESCRIPTION","group":"","filename":"languagefilter"}', '{"detect_browser":"0","automatic_change":"1","item_associations":"1","remove_default_prefix":"0","lang_cookie":"0","alternate_meta":"1"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(423, 0, 'plg_system_p3p', 'plugin', 'p3p', 'system', 0, 1, 1, 0, '{"name":"plg_system_p3p","type":"plugin","creationDate":"September 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_P3P_XML_DESCRIPTION","group":"","filename":"p3p"}', '{"headers":"NOI ADM DEV PSAi COM NAV OUR OTRo STP IND DEM"}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(424, 0, 'plg_system_cache', 'plugin', 'cache', 'system', 0, 0, 1, 1, '{"name":"plg_system_cache","type":"plugin","creationDate":"February 2007","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CACHE_XML_DESCRIPTION","group":"","filename":"cache"}', '{"browsercache":"0","cachetime":"15"}', '', '', 0, '0000-00-00 00:00:00', 9, 0),
(425, 0, 'plg_system_debug', 'plugin', 'debug', 'system', 0, 1, 1, 0, '{"name":"plg_system_debug","type":"plugin","creationDate":"December 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_DEBUG_XML_DESCRIPTION","group":"","filename":"debug"}', '{"profile":"1","queries":"1","memory":"1","language_files":"1","language_strings":"1","strip-first":"1","strip-prefix":"","strip-suffix":""}', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(426, 0, 'plg_system_log', 'plugin', 'log', 'system', 0, 1, 1, 1, '{"name":"plg_system_log","type":"plugin","creationDate":"April 2007","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_LOG_XML_DESCRIPTION","group":"","filename":"log"}', '', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(427, 0, 'plg_system_redirect', 'plugin', 'redirect', 'system', 0, 0, 1, 1, '{"name":"plg_system_redirect","type":"plugin","creationDate":"April 2009","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SYSTEM_REDIRECT_XML_DESCRIPTION","group":"","filename":"redirect"}', '', '', '', 0, '0000-00-00 00:00:00', 6, 0),
(428, 0, 'plg_system_remember', 'plugin', 'remember', 'system', 0, 1, 1, 1, '{"name":"plg_system_remember","type":"plugin","creationDate":"April 2007","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_REMEMBER_XML_DESCRIPTION","group":"","filename":"remember"}', '', '', '', 0, '0000-00-00 00:00:00', 7, 0),
(429, 0, 'plg_system_sef', 'plugin', 'sef', 'system', 0, 1, 1, 0, '{"name":"plg_system_sef","type":"plugin","creationDate":"December 2007","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEF_XML_DESCRIPTION","group":"","filename":"sef"}', '', '', '', 0, '0000-00-00 00:00:00', 8, 0),
(430, 0, 'plg_system_logout', 'plugin', 'logout', 'system', 0, 1, 1, 1, '{"name":"plg_system_logout","type":"plugin","creationDate":"April 2009","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SYSTEM_LOGOUT_XML_DESCRIPTION","group":"","filename":"logout"}', '', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(431, 0, 'plg_user_contactcreator', 'plugin', 'contactcreator', 'user', 0, 0, 1, 0, '{"name":"plg_user_contactcreator","type":"plugin","creationDate":"August 2009","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CONTACTCREATOR_XML_DESCRIPTION","group":"","filename":"contactcreator"}', '{"autowebpage":"","category":"34","autopublish":"0"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(432, 0, 'plg_user_joomla', 'plugin', 'joomla', 'user', 0, 1, 1, 0, '{"name":"plg_user_joomla","type":"plugin","creationDate":"December 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_USER_JOOMLA_XML_DESCRIPTION","group":"","filename":"joomla"}', '{"strong_passwords":"1","autoregister":"1"}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(433, 0, 'plg_user_profile', 'plugin', 'profile', 'user', 0, 0, 1, 0, '{"name":"plg_user_profile","type":"plugin","creationDate":"January 2008","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_USER_PROFILE_XML_DESCRIPTION","group":"","filename":"profile"}', '{"register-require_address1":"1","register-require_address2":"1","register-require_city":"1","register-require_region":"1","register-require_country":"1","register-require_postal_code":"1","register-require_phone":"1","register-require_website":"1","register-require_favoritebook":"1","register-require_aboutme":"1","register-require_tos":"1","register-require_dob":"1","profile-require_address1":"1","profile-require_address2":"1","profile-require_city":"1","profile-require_region":"1","profile-require_country":"1","profile-require_postal_code":"1","profile-require_phone":"1","profile-require_website":"1","profile-require_favoritebook":"1","profile-require_aboutme":"1","profile-require_tos":"1","profile-require_dob":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(434, 0, 'plg_extension_joomla', 'plugin', 'joomla', 'extension', 0, 1, 1, 1, '{"name":"plg_extension_joomla","type":"plugin","creationDate":"May 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_EXTENSION_JOOMLA_XML_DESCRIPTION","group":"","filename":"joomla"}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(435, 0, 'plg_content_joomla', 'plugin', 'joomla', 'content', 0, 1, 1, 0, '{"name":"plg_content_joomla","type":"plugin","creationDate":"November 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CONTENT_JOOMLA_XML_DESCRIPTION","group":"","filename":"joomla"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(436, 0, 'plg_system_languagecode', 'plugin', 'languagecode', 'system', 0, 0, 1, 0, '{"name":"plg_system_languagecode","type":"plugin","creationDate":"November 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SYSTEM_LANGUAGECODE_XML_DESCRIPTION","group":"","filename":"languagecode"}', '{"ar-aa":"","en-gb":""}', '', '', 0, '0000-00-00 00:00:00', 10, 0),
(437, 0, 'plg_quickicon_joomlaupdate', 'plugin', 'joomlaupdate', 'quickicon', 0, 1, 1, 1, '{"name":"plg_quickicon_joomlaupdate","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_QUICKICON_JOOMLAUPDATE_XML_DESCRIPTION","group":"","filename":"joomlaupdate"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(438, 0, 'plg_quickicon_extensionupdate', 'plugin', 'extensionupdate', 'quickicon', 0, 1, 1, 1, '{"name":"plg_quickicon_extensionupdate","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_QUICKICON_EXTENSIONUPDATE_XML_DESCRIPTION","group":"","filename":"extensionupdate"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(439, 0, 'plg_captcha_recaptcha', 'plugin', 'recaptcha', 'captcha', 0, 0, 1, 0, '{"name":"plg_captcha_recaptcha","type":"plugin","creationDate":"December 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.4.0","description":"PLG_CAPTCHA_RECAPTCHA_XML_DESCRIPTION","group":"","filename":"recaptcha"}', '{"public_key":"","private_key":"","theme":"clean"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(440, 0, 'plg_system_highlight', 'plugin', 'highlight', 'system', 0, 1, 1, 0, '{"name":"plg_system_highlight","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SYSTEM_HIGHLIGHT_XML_DESCRIPTION","group":"","filename":"highlight"}', '', '', '', 0, '0000-00-00 00:00:00', 7, 0),
(441, 0, 'plg_content_finder', 'plugin', 'finder', 'content', 0, 0, 1, 0, '{"name":"plg_content_finder","type":"plugin","creationDate":"December 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CONTENT_FINDER_XML_DESCRIPTION","group":"","filename":"finder"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(442, 0, 'plg_finder_categories', 'plugin', 'categories', 'finder', 0, 1, 1, 0, '{"name":"plg_finder_categories","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_FINDER_CATEGORIES_XML_DESCRIPTION","group":"","filename":"categories"}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(443, 0, 'plg_finder_contacts', 'plugin', 'contacts', 'finder', 0, 1, 1, 0, '{"name":"plg_finder_contacts","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_FINDER_CONTACTS_XML_DESCRIPTION","group":"","filename":"contacts"}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(444, 0, 'plg_finder_content', 'plugin', 'content', 'finder', 0, 1, 1, 0, '{"name":"plg_finder_content","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_FINDER_CONTENT_XML_DESCRIPTION","group":"","filename":"content"}', '', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(445, 0, 'plg_finder_newsfeeds', 'plugin', 'newsfeeds', 'finder', 0, 1, 1, 0, '{"name":"plg_finder_newsfeeds","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_FINDER_NEWSFEEDS_XML_DESCRIPTION","group":"","filename":"newsfeeds"}', '', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(447, 0, 'plg_finder_tags', 'plugin', 'tags', 'finder', 0, 1, 1, 0, '{"name":"plg_finder_tags","type":"plugin","creationDate":"February 2013","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_FINDER_TAGS_XML_DESCRIPTION","group":"","filename":"tags"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(448, 0, 'plg_twofactorauth_totp', 'plugin', 'totp', 'twofactorauth', 0, 0, 1, 0, '{"name":"plg_twofactorauth_totp","type":"plugin","creationDate":"August 2013","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.0","description":"PLG_TWOFACTORAUTH_TOTP_XML_DESCRIPTION","group":"","filename":"totp"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(449, 0, 'plg_authentication_cookie', 'plugin', 'cookie', 'authentication', 0, 1, 1, 0, '{"name":"plg_authentication_cookie","type":"plugin","creationDate":"July 2013","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_AUTH_COOKIE_XML_DESCRIPTION","group":"","filename":"cookie"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(450, 0, 'plg_twofactorauth_yubikey', 'plugin', 'yubikey', 'twofactorauth', 0, 0, 1, 0, '{"name":"plg_twofactorauth_yubikey","type":"plugin","creationDate":"September 2013","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.0","description":"PLG_TWOFACTORAUTH_YUBIKEY_XML_DESCRIPTION","group":"","filename":"yubikey"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(451, 0, 'plg_search_tags', 'plugin', 'tags', 'search', 0, 1, 1, 0, '{"name":"plg_search_tags","type":"plugin","creationDate":"March 2014","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEARCH_TAGS_XML_DESCRIPTION","group":"","filename":"tags"}', '{"search_limit":"50","show_tagged_items":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(452, 0, 'plg_system_updatenotification', 'plugin', 'updatenotification', 'system', 0, 1, 1, 0, '{"name":"plg_system_updatenotification","type":"plugin","creationDate":"May 2015","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.5.0","description":"PLG_SYSTEM_UPDATENOTIFICATION_XML_DESCRIPTION","group":"","filename":"updatenotification"}', '{"lastrun":1512629427}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(453, 0, 'plg_editors-xtd_module', 'plugin', 'module', 'editors-xtd', 0, 1, 1, 0, '{"name":"plg_editors-xtd_module","type":"plugin","creationDate":"October 2015","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.5.0","description":"PLG_MODULE_XML_DESCRIPTION","group":"","filename":"module"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(454, 0, 'plg_system_stats', 'plugin', 'stats', 'system', 0, 1, 1, 0, '{"name":"plg_system_stats","type":"plugin","creationDate":"November 2013","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.5.0","description":"PLG_SYSTEM_STATS_XML_DESCRIPTION","group":"","filename":"stats"}', '{"mode":1,"lastrun":1512629461,"unique_id":"67e29b79898ccbf829924b216a424e0d993c5547","interval":12}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(455, 0, 'plg_installer_packageinstaller', 'plugin', 'packageinstaller', 'installer', 0, 1, 1, 1, '{"name":"plg_installer_packageinstaller","type":"plugin","creationDate":"May 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.6.0","description":"PLG_INSTALLER_PACKAGEINSTALLER_PLUGIN_XML_DESCRIPTION","group":"","filename":"packageinstaller"}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(456, 0, 'PLG_INSTALLER_FOLDERINSTALLER', 'plugin', 'folderinstaller', 'installer', 0, 1, 1, 1, '{"name":"PLG_INSTALLER_FOLDERINSTALLER","type":"plugin","creationDate":"May 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.6.0","description":"PLG_INSTALLER_FOLDERINSTALLER_PLUGIN_XML_DESCRIPTION","group":"","filename":"folderinstaller"}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(457, 0, 'PLG_INSTALLER_URLINSTALLER', 'plugin', 'urlinstaller', 'installer', 0, 1, 1, 1, '{"name":"PLG_INSTALLER_URLINSTALLER","type":"plugin","creationDate":"May 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.6.0","description":"PLG_INSTALLER_URLINSTALLER_PLUGIN_XML_DESCRIPTION","group":"","filename":"urlinstaller"}', '', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(458, 0, 'plg_quickicon_phpversioncheck', 'plugin', 'phpversioncheck', 'quickicon', 0, 1, 1, 1, '{"name":"plg_quickicon_phpversioncheck","type":"plugin","creationDate":"August 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_QUICKICON_PHPVERSIONCHECK_XML_DESCRIPTION","group":"","filename":"phpversioncheck"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(459, 0, 'plg_editors-xtd_menu', 'plugin', 'menu', 'editors-xtd', 0, 1, 1, 0, '{"name":"plg_editors-xtd_menu","type":"plugin","creationDate":"August 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_EDITORS-XTD_MENU_XML_DESCRIPTION","group":"","filename":"menu"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(460, 0, 'plg_editors-xtd_contact', 'plugin', 'contact', 'editors-xtd', 0, 1, 1, 0, '{"name":"plg_editors-xtd_contact","type":"plugin","creationDate":"October 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_EDITORS-XTD_CONTACT_XML_DESCRIPTION","group":"","filename":"contact"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(461, 0, 'plg_system_fields', 'plugin', 'fields', 'system', 0, 1, 1, 0, '{"name":"plg_system_fields","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_SYSTEM_FIELDS_XML_DESCRIPTION","group":"","filename":"fields"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(462, 0, 'plg_fields_calendar', 'plugin', 'calendar', 'fields', 0, 1, 1, 0, '{"name":"plg_fields_calendar","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_CALENDAR_XML_DESCRIPTION","group":"","filename":"calendar"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(463, 0, 'plg_fields_checkboxes', 'plugin', 'checkboxes', 'fields', 0, 1, 1, 0, '{"name":"plg_fields_checkboxes","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_CHECKBOXES_XML_DESCRIPTION","group":"","filename":"checkboxes"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(464, 0, 'plg_fields_color', 'plugin', 'color', 'fields', 0, 1, 1, 0, '{"name":"plg_fields_color","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_COLOR_XML_DESCRIPTION","group":"","filename":"color"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(465, 0, 'plg_fields_editor', 'plugin', 'editor', 'fields', 0, 1, 1, 0, '{"name":"plg_fields_editor","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_EDITOR_XML_DESCRIPTION","group":"","filename":"editor"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(466, 0, 'plg_fields_imagelist', 'plugin', 'imagelist', 'fields', 0, 1, 1, 0, '{"name":"plg_fields_imagelist","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_IMAGELIST_XML_DESCRIPTION","group":"","filename":"imagelist"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(467, 0, 'plg_fields_integer', 'plugin', 'integer', 'fields', 0, 1, 1, 0, '{"name":"plg_fields_integer","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_INTEGER_XML_DESCRIPTION","group":"","filename":"integer"}', '{"multiple":"0","first":"1","last":"100","step":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(468, 0, 'plg_fields_list', 'plugin', 'list', 'fields', 0, 1, 1, 0, '{"name":"plg_fields_list","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_LIST_XML_DESCRIPTION","group":"","filename":"list"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(469, 0, 'plg_fields_media', 'plugin', 'media', 'fields', 0, 1, 1, 0, '{"name":"plg_fields_media","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_MEDIA_XML_DESCRIPTION","group":"","filename":"media"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(470, 0, 'plg_fields_radio', 'plugin', 'radio', 'fields', 0, 1, 1, 0, '{"name":"plg_fields_radio","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_RADIO_XML_DESCRIPTION","group":"","filename":"radio"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(471, 0, 'plg_fields_sql', 'plugin', 'sql', 'fields', 0, 1, 1, 0, '{"name":"plg_fields_sql","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_SQL_XML_DESCRIPTION","group":"","filename":"sql"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(472, 0, 'plg_fields_text', 'plugin', 'text', 'fields', 0, 1, 1, 0, '{"name":"plg_fields_text","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_TEXT_XML_DESCRIPTION","group":"","filename":"text"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(473, 0, 'plg_fields_textarea', 'plugin', 'textarea', 'fields', 0, 1, 1, 0, '{"name":"plg_fields_textarea","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_TEXTAREA_XML_DESCRIPTION","group":"","filename":"textarea"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(474, 0, 'plg_fields_url', 'plugin', 'url', 'fields', 0, 1, 1, 0, '{"name":"plg_fields_url","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_URL_XML_DESCRIPTION","group":"","filename":"url"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(475, 0, 'plg_fields_user', 'plugin', 'user', 'fields', 0, 1, 1, 0, '{"name":"plg_fields_user","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_USER_XML_DESCRIPTION","group":"","filename":"user"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(476, 0, 'plg_fields_usergrouplist', 'plugin', 'usergrouplist', 'fields', 0, 1, 1, 0, '{"name":"plg_fields_usergrouplist","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_USERGROUPLIST_XML_DESCRIPTION","group":"","filename":"usergrouplist"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(477, 0, 'plg_content_fields', 'plugin', 'fields', 'content', 0, 1, 1, 0, '{"name":"plg_content_fields","type":"plugin","creationDate":"February 2017","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_CONTENT_FIELDS_XML_DESCRIPTION","group":"","filename":"fields"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(478, 0, 'plg_editors-xtd_fields', 'plugin', 'fields', 'editors-xtd', 0, 1, 1, 0, '{"name":"plg_editors-xtd_fields","type":"plugin","creationDate":"February 2017","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_EDITORS-XTD_FIELDS_XML_DESCRIPTION","group":"","filename":"fields"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(479, 0, 'plg_sampledata_blog', 'plugin', 'blog', 'sampledata', 0, 0, 1, 0, '{"name":"plg_sampledata_blog","type":"plugin","creationDate":"July 2017","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.8.0","description":"PLG_SAMPLEDATA_BLOG_XML_DESCRIPTION","group":"","filename":"blog"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(503, 0, 'beez3', 'template', 'beez3', '', 0, 1, 1, 0, '{"name":"beez3","type":"template","creationDate":"25 November 2009","author":"Angie Radtke","copyright":"Copyright (C) 2005 - 2017 Open Source Matters, Inc. All rights reserved.","authorEmail":"a.radtke@derauftritt.de","authorUrl":"http:\\/\\/www.der-auftritt.de","version":"3.1.0","description":"TPL_BEEZ3_XML_DESCRIPTION","group":"","filename":"templateDetails"}', '{"wrapperSmall":"53","wrapperLarge":"72","sitetitle":"","sitedescription":"","navposition":"center","templatecolor":"nature"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(504, 0, 'hathor', 'template', 'hathor', '', 1, 1, 1, 0, '{"name":"hathor","type":"template","creationDate":"May 2010","author":"Andrea Tarr","copyright":"Copyright (C) 2005 - 2017 Open Source Matters, Inc. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"","version":"3.0.0","description":"TPL_HATHOR_XML_DESCRIPTION","group":"","filename":"templateDetails"}', '{"showSiteName":"0","colourChoice":"0","boldText":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(506, 0, 'protostar', 'template', 'protostar', '', 0, 1, 1, 0, '{"name":"protostar","type":"template","creationDate":"4\\/30\\/2012","author":"Kyle Ledbetter","copyright":"Copyright (C) 2005 - 2017 Open Source Matters, Inc. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"","version":"1.0","description":"TPL_PROTOSTAR_XML_DESCRIPTION","group":"","filename":"templateDetails"}', '{"templateColor":"","logoFile":"","googleFont":"1","googleFontName":"Open+Sans","fluidContainer":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(507, 0, 'isis', 'template', 'isis', '', 1, 1, 1, 0, '{"name":"isis","type":"template","creationDate":"3\\/30\\/2012","author":"Kyle Ledbetter","copyright":"Copyright (C) 2005 - 2017 Open Source Matters, Inc. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"","version":"1.0","description":"TPL_ISIS_XML_DESCRIPTION","group":"","filename":"templateDetails"}', '{"templateColor":"","logoFile":""}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(600, 802, 'English (en-GB)', 'language', 'en-GB', '', 0, 1, 1, 1, '{"name":"English (en-GB)","type":"language","creationDate":"November 2017","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.8.2","description":"en-GB site language","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(601, 802, 'English (en-GB)', 'language', 'en-GB', '', 1, 1, 1, 1, '{"name":"English (en-GB)","type":"language","creationDate":"November 2017","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.8.2","description":"en-GB administrator language","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(700, 0, 'files_joomla', 'file', 'joomla', '', 0, 1, 1, 1, '{"name":"files_joomla","type":"file","creationDate":"November 2017","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.8.2","description":"FILES_JOOMLA_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(802, 0, 'English (en-GB) Language Pack', 'package', 'pkg_en-GB', '', 0, 1, 1, 1, '{"name":"English (en-GB) Language Pack","type":"package","creationDate":"November 2017","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters, Inc. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.8.2.1","description":"en-GB language pack","group":"","filename":"pkg_en-GB"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10001, 0, 'Helix3 - Ajax', 'plugin', 'helix3', 'ajax', 0, 1, 1, 0, '{"name":"Helix3 - Ajax","type":"plugin","creationDate":"Jan 2015","author":"JoomShaper.com","copyright":"Copyright (C) 2010 - 2017 JoomShaper. All rights reserved.","authorEmail":"support@joomshaper.com","authorUrl":"www.joomshaper.com","version":"2.4","description":"Helix3 Framework - Joomla Template Framework by JoomShaper","group":"","filename":"helix3"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10002, 0, 'System - Helix3 Framework', 'plugin', 'helix3', 'system', 0, 1, 1, 0, '{"name":"System - Helix3 Framework","type":"plugin","creationDate":"Jan 2015","author":"JoomShaper.com","copyright":"Copyright (C) 2010 - 2017 JoomShaper. All rights reserved.","authorEmail":"support@joomshaper.com","authorUrl":"www.joomshaper.com","version":"2.4","description":"Helix3 Framework - Joomla Template Framework by JoomShaper","group":"","filename":"helix3"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10004, 0, 'SP Page Builder', 'component', 'com_sppagebuilder', '', 1, 1, 0, 0, '{"name":"SP Page Builder","type":"component","creationDate":"Sep 2014","author":"JoomShaper","copyright":"Copyright @ 2010 - 2017 JoomShaper. All rights reserved.","authorEmail":"support@joomshaper.com","authorUrl":"http:\\/\\/www.joomshaper.com","version":"3.0.3","description":"","group":"","filename":"sppagebuilder"}', '{"addcontainer":"1","gmap_api":"","fontawesome":"1","disableanimatecss":"0","disablecss":"0","joomshaper_email":"","joomshaper_license_key":""}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10005, 0, 'mod_sppagebuilder_icons', 'module', 'mod_sppagebuilder_icons', '', 1, 1, 2, 0, '{"name":"mod_sppagebuilder_icons","type":"module","creationDate":"August 2014","author":"JoomShaper","copyright":"Copyright (C) 2010 - 2016 JoomShaper. All rights reserved.","authorEmail":"support@joomshaper.com","authorUrl":"www.joomshaper.com","version":"1.0.2","description":"MOD_SPPAGEBUILDER_ICONS_XML_DESCRIPTION","group":"","filename":"mod_sppagebuilder_icons"}', '[]', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10006, 0, 'mod_sppagebuilder_admin_menu', 'module', 'mod_sppagebuilder_admin_menu', '', 1, 1, 2, 0, '{"name":"mod_sppagebuilder_admin_menu","type":"module","creationDate":"August 2014","author":"JoomShaper","copyright":"Copyright (C) 2010 - 2017 JoomShaper. All rights reserved.","authorEmail":"support@joomshaper.com","authorUrl":"www.joomshaper.com","version":"1.3","description":"MOD_SPPAGEBUILDER_MENU_XML_DESCRIPTION","group":"","filename":"mod_sppagebuilder_admin_menu"}', '[]', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10012, 0, 'plg_installer_webinstaller', 'plugin', 'webinstaller', 'installer', 0, 1, 1, 0, '{"name":"plg_installer_webinstaller","type":"plugin","creationDate":"28 April 2017","author":"Joomla! Project","copyright":"Copyright (C) 2013-2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"1.1.1","description":"PLG_INSTALLER_WEBINSTALLER_XML_DESCRIPTION","group":"","filename":"webinstaller"}', '{"tab_position":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10019, 0, 'shaper_newskit', 'template', 'shaper_newskit', '', 0, 1, 1, 0, '{"name":"shaper_newskit","type":"template","creationDate":"July 2017","author":"JoomShaper.com","copyright":"Copyright (C) 2010 - 2017 JoomShaper.com. All rights reserved.","authorEmail":"support@joomshaper.com","authorUrl":"http:\\/\\/www.joomshaper.com","version":"1.5","description":"Shaper Newskit - Responsive Joomla! 3.7+ news\\/magazine template.","group":"","filename":"templateDetails"}', '{"preloader":"0","preloader_animation":"circle","preloader_bg":"#f5f5f5","preloader_tx":"#333333","goto_top":"0","sticky_header":"1","boxed_layout":"0","logo_type":"image","logo_position":"logo","logo_load_pos":"default","body_bg_repeat":"inherit","body_bg_size":"inherit","body_bg_attachment":"inherit","body_bg_position":"0 0","enabled_copyright":"1","copyright_position":"footer1","copyright_load_pos":"default","copyright":"\\u00a9 2015 Your Company. All Rights Reserved. Designed By JoomShaper","show_social_icons":"1","social_position":"top1","social_load_pos":"default","enable_contactinfo":"1","contact_position":"top2","comingsoon_mode":"0","comingsoon_title":"Coming Soon Title","comingsoon_date":"5-10-2018","comingsoon_content":"Coming soon content","preset":"preset1","preset1_bg":"#ffffff","preset1_text":"#000000","preset1_major":"#26aae1","preset1_megabg":"#ffffff","preset1_megatx":"#333333","preset2_bg":"#ffffff","preset2_text":"#000000","preset2_major":"#3d449a","preset2_megabg":"#ffffff","preset2_megatx":"#333333","preset3_bg":"#ffffff","preset3_text":"#000000","preset3_major":"#2bb673","preset3_megabg":"#ffffff","preset3_megatx":"#333333","preset4_bg":"#ffffff","preset4_text":"#000000","preset4_major":"#eb4947","preset4_megabg":"#ffffff","preset4_megatx":"#333333","menu":"mainmenu","menu_type":"mega_offcanvas","menu_animation":"menu-fade","offcanvas_animation":"default","enable_body_font":"1","body_font":"{\\"fontFamily\\":\\"Open Sans\\",\\"fontWeight\\":\\"300\\",\\"fontSubset\\":\\"latin\\",\\"fontSize\\":\\"\\"}","enable_h1_font":"1","h1_font":"{\\"fontFamily\\":\\"Open Sans\\",\\"fontWeight\\":\\"800\\",\\"fontSubset\\":\\"latin\\",\\"fontSize\\":\\"\\"}","enable_h2_font":"1","h2_font":"{\\"fontFamily\\":\\"Open Sans\\",\\"fontWeight\\":\\"600\\",\\"fontSubset\\":\\"latin\\",\\"fontSize\\":\\"\\"}","enable_h3_font":"1","h3_font":"{\\"fontFamily\\":\\"Open Sans\\",\\"fontWeight\\":\\"regular\\",\\"fontSubset\\":\\"latin\\",\\"fontSize\\":\\"\\"}","enable_h4_font":"1","h4_font":"{\\"fontFamily\\":\\"Open Sans\\",\\"fontWeight\\":\\"regular\\",\\"fontSubset\\":\\"latin\\",\\"fontSize\\":\\"\\"}","enable_h5_font":"1","h5_font":"{\\"fontFamily\\":\\"Open Sans\\",\\"fontWeight\\":\\"600\\",\\"fontSubset\\":\\"latin\\",\\"fontSize\\":\\"\\"}","enable_h6_font":"1","h6_font":"{\\"fontFamily\\":\\"Open Sans\\",\\"fontWeight\\":\\"600\\",\\"fontSubset\\":\\"latin\\",\\"fontSize\\":\\"\\"}","enable_navigation_font":"0","enable_custom_font":"0","compress_css":"0","compress_js":"0","lessoption":"0","show_post_format":"1","commenting_engine":"disabled","disqus_devmode":"0","intensedebate_acc":"","fb_width":"500","fb_cpp":"10","comments_count":"0","social_share":"1","image_small":"0","image_small_size":"100X100","image_thumbnail":"1","image_thumbnail_size":"200X200","image_medium":"0","image_medium_size":"300X300","image_large":"0","image_large_size":"600X600","blog_list_image":"default"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10020, 0, 'System - SP PageBuilder', 'plugin', 'sppagebuilder', 'system', 0, 1, 1, 0, '{"name":"System - SP PageBuilder","type":"plugin","creationDate":"Sep 2016","author":"JoomShaper.com","copyright":"Copyright (C) 2010 - 2016 JoomShaper. All rights reserved.","authorEmail":"support@joomshaper.com","authorUrl":"www.joomshaper.com","version":"1.3","description":"SP Page Builder System plugin to add support for 3rd party components","group":"","filename":"sppagebuilder"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10021, 0, 'System - SP Page Builder Pro Updater', 'plugin', 'sppagebuilderproupdater', 'system', 0, 1, 1, 0, '{"name":"System - SP Page Builder Pro Updater","type":"plugin","creationDate":"Jul 2015","author":"JoomShaper.com","copyright":"Copyright (C) 2010 - 2016 JoomShaper. All rights reserved.","authorEmail":"support@joomshaper.com","authorUrl":"www.joomshaper.com","version":"1.1","description":"SP Page Builder Pro Updater Plugin","group":"","filename":"sppagebuilderproupdater"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10022, 0, 'plg_search_sppagebuilder', 'plugin', 'sppagebuilder', 'search', 0, 1, 1, 0, '{"name":"plg_search_sppagebuilder","type":"plugin","creationDate":"July 2015","author":"JoomShaper","copyright":"Copyright (C) 2015 Open Source Matters. All rights reserved.","authorEmail":"support@joomshaper.com","authorUrl":"www.joomshaper.com","version":"1.3","description":"PLG_SEARCH_SPPAGEBUILDER_DESCRIPTION","group":"","filename":"sppagebuilder"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10023, 0, 'SP Page Builder', 'module', 'mod_sppagebuilder', '', 0, 1, 0, 0, '{"name":"SP Page Builder","type":"module","creationDate":"Oct 2016","author":"JoomShaper","copyright":"Copyright (C) 2010 - 2016 JoomShaper.com. All rights reserved.","authorEmail":"support@joomshaper.com","authorUrl":"www.joomshaper.com","version":"1.2","description":"Module to display content from SP Page Builder","group":"","filename":"mod_sppagebuilder"}', '{"cache":"1","cache_time":"900","cachemode":"itemid"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10024, 0, 'Content - SP Page Builder', 'plugin', 'sppagebuilder', 'content', 0, 1, 1, 0, '{"name":"Content - SP Page Builder","type":"plugin","creationDate":"Sep 2016","author":"Joomla! Project","copyright":"Copyright (C) 2010 - 2016 JoomShaper. All rights reserved.","authorEmail":"support@joomshaper.com","authorUrl":"www.joomshaper.com","version":"1.2","description":"SP Page Builder System plugin to add support for 3rd party components","group":"","filename":"sppagebuilder"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10026, 0, 'SP Polls', 'component', 'com_sppolls', '', 1, 1, 0, 0, '{"name":"SP Polls","type":"component","creationDate":"Nov 2015","author":"JoomShaper","copyright":"Copyright (c) 2010- 2015 JoomShaper. All rights reserved.","authorEmail":"support@joomshaper.com","authorUrl":"http:\\/\\/www.joomshaper.com","version":"1.3","description":"Ajax poll component for Joomla","group":"","filename":"sppolls"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10027, 0, 'SP Poll', 'module', 'mod_sp_poll', '', 0, 1, 0, 0, '{"name":"SP Poll","type":"module","creationDate":"Nov 2015","author":"JoomShaper","copyright":"Copyright (C) 2010 - 2015 JoomShaper. All rights reserved.","authorEmail":"","authorUrl":"http:\\/\\/joomshaper.com","version":"1.1","description":"SP Poll - Module to show poll form and result for SP Polls component.","group":"","filename":"mod_sp_poll"}', '{"poll_type":"latest","lag":"12"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10028, 0, 'AcyMailing', 'component', 'com_acymailing', '', 1, 1, 0, 0, '{"name":"AcyMailing","type":"component","creationDate":"septembre 2017","author":"Acyba","copyright":"Copyright (C) 2009-2017 ACYBA SAS - All rights reserved.","authorEmail":"dev@acyba.com","authorUrl":"http:\\/\\/www.acyba.com","version":"5.8.1","description":"Manage your Mailing lists, Newsletters, e-mail marketing campaigns","group":"","filename":"acymailing_j3"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10029, 0, 'AcyMailing : trigger Joomla Content plugins', 'plugin', 'contentplugin', 'acymailing', 0, 0, 1, 0, '{"version":"3.7.0","author":"Acyba","creationDate":"November 2009"}', '', '', '', 0, '0000-00-00 00:00:00', 15, 0),
(10030, 0, 'AcyMailing Manage text', 'plugin', 'managetext', 'acymailing', 0, 1, 1, 0, '{"version":"1.0.0","author":"Acyba","creationDate":"October 2010"}', '', '', '', 0, '0000-00-00 00:00:00', 10, 0),
(10031, 0, 'AcyMailing Tag : Website links', 'plugin', 'online', 'acymailing', 0, 1, 1, 0, '{"version":"3.7.0","author":"Acyba","creationDate":"September 2009"}', '', '', '', 0, '0000-00-00 00:00:00', 6, 0),
(10032, 0, 'AcyMailing : share on social networks', 'plugin', 'share', 'acymailing', 0, 1, 1, 0, '{"version":"1.0.0","author":"Acyba","creationDate":"August 2010"}', '', '', '', 0, '0000-00-00 00:00:00', 20, 0),
(10033, 0, 'AcyMailing : Statistics Plugin', 'plugin', 'stats', 'acymailing', 0, 1, 1, 0, '{"version":"3.7.0","author":"Acyba","creationDate":"September 2009"}', '', '', '', 0, '0000-00-00 00:00:00', 50, 0),
(10034, 0, 'AcyMailing table of contents generator', 'plugin', 'tablecontents', 'acymailing', 0, 1, 1, 0, '{"version":"1.0.0","author":"Acyba","creationDate":"January 2011"}', '', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(10035, 0, 'AcyMailing Tag : content insertion', 'plugin', 'tagcontent', 'acymailing', 0, 1, 1, 0, '{"version":"3.7.0","author":"Acyba","creationDate":"September 2009"}', '', '', '', 0, '0000-00-00 00:00:00', 11, 0),
(10036, 0, 'AcyMailing Tag : Subscriber information', 'plugin', 'tagsubscriber', 'acymailing', 0, 1, 1, 0, '{"version":"5.8.1","author":"Acyba","creationDate":"septembre 2017"}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(10037, 0, 'AcyMailing Tag : Manage the Subscription', 'plugin', 'tagsubscription', 'acymailing', 0, 1, 1, 0, '{"version":"5.8.1","author":"Acyba","creationDate":"septembre 2017"}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(10038, 0, 'AcyMailing Tag : Date / Time', 'plugin', 'tagtime', 'acymailing', 0, 1, 1, 0, '{"version":"5.8.1","author":"Acyba","creationDate":"septembre 2017"}', '', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(10039, 0, 'AcyMailing Tag : Joomla User Information', 'plugin', 'taguser', 'acymailing', 0, 1, 1, 0, '{"version":"5.8.1","author":"Acyba","creationDate":"septembre 2017"}', '', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(10040, 0, 'AcyMailing Template Class Replacer', 'plugin', 'template', 'acymailing', 0, 1, 1, 0, '{"version":"5.8.1","author":"Acyba","creationDate":"septembre 2017"}', '', '', '', 0, '0000-00-00 00:00:00', 25, 0),
(10041, 0, 'AcyMailing Editor', 'plugin', 'acyeditor', 'editors', 0, 1, 1, 0, '{"version":"5.8.1","author":"Acyba","creationDate":"septembre 2017"}', '', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(10042, 0, 'AcyMailing : (auto)Subscribe during Joomla registration', 'plugin', 'regacymailing', 'system', 0, 1, 1, 0, '{"version":"5.8.1","author":"Acyba","creationDate":"septembre 2017"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10043, 0, 'AcyMailing Module', 'module', 'mod_acymailing', '', 0, 1, 1, 0, '{"version":"3.7.0","author":"Acyba","creationDate":"September 2009"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0);
INSERT INTO `#__extensions` (`extension_id`, `package_id`, `name`, `type`, `element`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `system_data`, `checked_out`, `checked_out_time`, `ordering`, `state`) VALUES
(10045, 0, 'SP Tabbed Articles', 'module', 'mod_sp_tabbed_articles', '', 0, 1, 0, 0, '{"name":"SP Tabbed Articles","type":"module","creationDate":"Nov 2015","author":"Joomla! Project","copyright":"Copyright (C) 2010 - 2015 JoomShaper. All rights reserved.","authorEmail":"support@joomshaper.com","authorUrl":"www.joomshaper.com","version":"1.0","description":"Module to display articles from subcategories in tab.","group":"","filename":"mod_sp_tabbed_articles"}', '{"limit":"3","columns":"3","ordering":"latest","cache":"1","cache_time":"900","cachemode":"itemid"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10046, 0, 'Helix3 Preset Option', 'module', 'mod_helix3_options', '', 0, 1, 0, 0, '{"name":"Helix3 Preset Option","type":"module","creationDate":"Feb 2015","author":"JoomShaper","copyright":"Copyright (C) 20010 - 2017 JoomShaper. All rights reserved.","authorEmail":"support@joomshaper.com","authorUrl":"www.joomshaper.com","version":"1.0.0","description":"Preset manager for Helix 3 based template.","group":"","filename":"mod_helix3_options"}', '{"presets":"4","cache":"1","cache_time":"900","cachemode":"static"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10047, 10049, 'ArabicUnitag', 'language', 'ar-AA', '', 0, 1, 0, 0, '{"name":"Arabic Unitag (\\u0627\\u0644\\u0639\\u0631\\u0628\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0648\\u062d\\u062f\\u0629)","type":"language","creationDate":"22\\/08\\/2017","author":"Ashraf Damra","copyright":"Joomla! in Arabic","authorEmail":"dr.d.ashraf@gmail.com","authorUrl":"https:\\/\\/www.jarabic.com\\/","version":"3.7.5.1","description":"ar-AA - Site language","group":"","filename":"install"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10048, 10049, 'ArabicUnitag', 'language', 'ar-AA', '', 1, 1, 0, 0, '{"name":"Arabic Unitag (\\u0627\\u0644\\u0639\\u0631\\u0628\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0648\\u062d\\u062f\\u0629)","type":"language","creationDate":"22\\/08\\/2017","author":"Ashraf Damra","copyright":"Joomla! in Arabic","authorEmail":"dr.d.ashraf@gmail.com","authorUrl":"https:\\/\\/www.jarabic.com\\/","version":"3.7.5.1","description":"ar-AA - Administration language","group":"","filename":"install"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10049, 0, 'Arabic', 'package', 'pkg_ar-AA', '', 0, 1, 1, 0, '{"name":"Arabic","type":"package","creationDate":"22\\/08\\/2017","author":"Ashraf Damra","copyright":"Joomla! in Arabic","authorEmail":"dr.d.ashraf@gmail.com","authorUrl":"https:\\/\\/www.jarabic.com\\/","version":"3.7.5.1","description":"<h3>\\u062d\\u0632\\u0645\\u0629 \\u0627\\u0644\\u0644\\u063a\\u0629 \\u0627\\u0644\\u0639\\u0631\\u0628\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0648\\u062d\\u062f\\u0629 \\u0644\\u0646\\u0638\\u0627\\u0645 \\u062c\\u0648\\u0645\\u0644\\u0627! 3.7.5 \\u0627\\u0644\\u0627\\u0635\\u062f\\u0627\\u0631 1<\\/h3>","group":"","filename":"pkg_ar-AA"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10050, 0, 'AcyMailing JCE integration', 'plugin', 'jceacymailing', 'system', 0, 1, 1, 0, '{"version":"5.8.1","author":"Acyba","creationDate":"septembre 2017"}', '', '', '', 0, '0000-00-00 00:00:00', 23, 0),
(10051, 0, 'SP Tweet', 'module', 'mod_sp_tweet', '', 0, 1, 0, 0, '{"name":"SP Tweet","type":"module","creationDate":"Sep 2012","author":"JoomShaper.com","copyright":"Copyright (C) 2010 - 2012 JoomShaper.com. All rights reserved.","authorEmail":"support@joomshaper.com","authorUrl":"www.joomshaper.com","version":"2.3.1","description":"Twitter module for Joomla by JoomShaper.com","group":"","filename":"mod_sp_tweet"}', '{"username":"joomshaper","layout_style":"1","tweets":"4","avatar":"1","avatar_width":"48","linked_avatar":"1","linked_search":"1","linked_mention":"1","email_linked":"0","tweet_time":"1","tweet_time_linked":"1","tweet_src":"1","follow_us":"1","target":"_blank","consumer_key":"","consumer_key_secret":"","access_token":"","access_token_secret":"","animation":"none","morph_duration":"300","animation_periodical_time":"8000","moduleclass_sfx":"","cache":"0","module_cache":"1","cache_time":"900","cachemode":"static"}', '', '', 0, '0000-00-00 00:00:00', 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__fields`
--

DROP TABLE IF EXISTS `#__fields`;
CREATE TABLE `#__fields` (
  `id` int(10) unsigned NOT NULL,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0',
  `context` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `group_id` int(10) unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `label` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `default_value` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'text',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `fieldparams` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `access` int(11) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__fields_categories`
--

DROP TABLE IF EXISTS `#__fields_categories`;
CREATE TABLE `#__fields_categories` (
  `field_id` int(11) NOT NULL DEFAULT '0',
  `category_id` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__fields_groups`
--

DROP TABLE IF EXISTS `#__fields_groups`;
CREATE TABLE `#__fields_groups` (
  `id` int(10) unsigned NOT NULL,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0',
  `context` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `access` int(11) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__fields_values`
--

DROP TABLE IF EXISTS `#__fields_values`;
CREATE TABLE `#__fields_values` (
  `field_id` int(10) unsigned NOT NULL,
  `item_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Allow references to items which have strings as ids, eg. none db systems.',
  `value` text COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__languages`
--

DROP TABLE IF EXISTS `#__languages`;
CREATE TABLE `#__languages` (
  `lang_id` int(11) unsigned NOT NULL,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0',
  `lang_code` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `title` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title_native` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sef` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL,
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `sitename` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `published` int(11) NOT NULL DEFAULT '0',
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__languages`
--

INSERT INTO `#__languages` (`lang_id`, `asset_id`, `lang_code`, `title`, `title_native`, `sef`, `image`, `description`, `metakey`, `metadesc`, `sitename`, `published`, `access`, `ordering`) VALUES
(1, 0, 'en-GB', 'English (UK)', 'English (UK)', 'en', 'en', '', '', '', '', 1, 1, 2),
(2, 366, 'ar-AA', 'Arabic Unitag (العربية الموحدة)', 'Arabic (اللغة العربية)', 'ar', 'ar_aa', '', '', '', '', 0, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `#__menu`
--

DROP TABLE IF EXISTS `#__menu`;
CREATE TABLE `#__menu` (
  `id` int(11) NOT NULL,
  `menutype` varchar(24) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The type of menu this item belongs to. FK to #__menu_types.menutype',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The display title of the menu item.',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL COMMENT 'The SEF alias of the menu item.',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `path` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The computed path of the menu item based on the alias field.',
  `link` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The actually link the menu item refers to.',
  `type` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The type of link: Component, URL, Alias, Separator',
  `published` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'The published state of the menu link.',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '1' COMMENT 'The parent menu item in the menu tree.',
  `level` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The relative level in the tree.',
  `component_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to #__extensions.id',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to #__users.id',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'The time the menu item was checked out.',
  `browserNav` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'The click behaviour of the link.',
  `access` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The access level required to view the menu item.',
  `img` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The image of the menu item.',
  `template_style_id` int(10) unsigned NOT NULL DEFAULT '0',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded data for the menu item.',
  `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `home` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Indicates if this menu item is the home or default page.',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` tinyint(4) NOT NULL DEFAULT '0'
) ENGINE=InnoDB AUTO_INCREMENT=592 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__menu`
--

INSERT INTO `#__menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES
(1, '', 'Menu_Item_Root', 'root', '', '', '', '', 1, 0, 0, 0, 0, '0000-00-00 00:00:00', 0, 0, '', 0, '', 0, 139, 0, '*', 0),
(2, 'main', 'com_banners', 'Banners', '', 'Banners', 'index.php?option=com_banners', 'component', 1, 1, 1, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners', 0, '', 21, 30, 0, '*', 1),
(3, 'main', 'com_banners', 'Banners', '', 'Banners/Banners', 'index.php?option=com_banners', 'component', 1, 2, 2, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners', 0, '', 22, 23, 0, '*', 1),
(4, 'main', 'com_banners_categories', 'Categories', '', 'Banners/Categories', 'index.php?option=com_categories&extension=com_banners', 'component', 1, 2, 2, 6, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners-cat', 0, '', 24, 25, 0, '*', 1),
(5, 'main', 'com_banners_clients', 'Clients', '', 'Banners/Clients', 'index.php?option=com_banners&view=clients', 'component', 1, 2, 2, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners-clients', 0, '', 26, 27, 0, '*', 1),
(6, 'main', 'com_banners_tracks', 'Tracks', '', 'Banners/Tracks', 'index.php?option=com_banners&view=tracks', 'component', 1, 2, 2, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners-tracks', 0, '', 28, 29, 0, '*', 1),
(7, 'main', 'com_contact', 'Contacts', '', 'Contacts', 'index.php?option=com_contact', 'component', 1, 1, 1, 8, 0, '0000-00-00 00:00:00', 0, 0, 'class:contact', 0, '', 31, 36, 0, '*', 1),
(8, 'main', 'com_contact_contacts', 'Contacts', '', 'Contacts/Contacts', 'index.php?option=com_contact', 'component', 1, 7, 2, 8, 0, '0000-00-00 00:00:00', 0, 0, 'class:contact', 0, '', 32, 33, 0, '*', 1),
(9, 'main', 'com_contact_categories', 'Categories', '', 'Contacts/Categories', 'index.php?option=com_categories&extension=com_contact', 'component', 1, 7, 2, 6, 0, '0000-00-00 00:00:00', 0, 0, 'class:contact-cat', 0, '', 34, 35, 0, '*', 1),
(10, 'main', 'com_messages', 'Messaging', '', 'Messaging', 'index.php?option=com_messages', 'component', 1, 1, 1, 15, 0, '0000-00-00 00:00:00', 0, 0, 'class:messages', 0, '', 37, 40, 0, '*', 1),
(11, 'main', 'com_messages_add', 'New Private Message', '', 'Messaging/New Private Message', 'index.php?option=com_messages&task=message.add', 'component', 1, 10, 2, 15, 0, '0000-00-00 00:00:00', 0, 0, 'class:messages-add', 0, '', 38, 39, 0, '*', 1),
(13, 'main', 'com_newsfeeds', 'News Feeds', '', 'News Feeds', 'index.php?option=com_newsfeeds', 'component', 1, 1, 1, 17, 0, '0000-00-00 00:00:00', 0, 0, 'class:newsfeeds', 0, '', 41, 46, 0, '*', 1),
(14, 'main', 'com_newsfeeds_feeds', 'Feeds', '', 'News Feeds/Feeds', 'index.php?option=com_newsfeeds', 'component', 1, 13, 2, 17, 0, '0000-00-00 00:00:00', 0, 0, 'class:newsfeeds', 0, '', 42, 43, 0, '*', 1),
(15, 'main', 'com_newsfeeds_categories', 'Categories', '', 'News Feeds/Categories', 'index.php?option=com_categories&extension=com_newsfeeds', 'component', 1, 13, 2, 6, 0, '0000-00-00 00:00:00', 0, 0, 'class:newsfeeds-cat', 0, '', 44, 45, 0, '*', 1),
(16, 'main', 'com_redirect', 'Redirect', '', 'Redirect', 'index.php?option=com_redirect', 'component', 1, 1, 1, 24, 0, '0000-00-00 00:00:00', 0, 0, 'class:redirect', 0, '', 51, 52, 0, '*', 1),
(17, 'main', 'com_search', 'Basic Search', '', 'Basic Search', 'index.php?option=com_search', 'component', 1, 1, 1, 19, 0, '0000-00-00 00:00:00', 0, 0, 'class:search', 0, '', 49, 50, 0, '*', 1),
(21, 'main', 'com_finder', 'Smart Search', '', 'Smart Search', 'index.php?option=com_finder', 'component', 1, 1, 1, 27, 0, '0000-00-00 00:00:00', 0, 0, 'class:finder', 0, '', 47, 48, 0, '*', 1),
(201, 'usermenu', 'Your Profile', 'your-profile', '', 'your-profile', 'index.php?option=com_users&view=profile', 'component', 1, 1, 1, 25, 0, '0000-00-00 00:00:00', 0, 2, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 53, 54, 0, '*', 0),
(437, 'mainmenu', 'Home', 'home', '', 'home', 'index.php?option=com_sppagebuilder&view=page&id=1', 'component', 1, 1, 1, 10004, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"menu_show":1,"page_title":"","show_page_heading":"0","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"menulayout":"{\\"width\\":600,\\"menuItem\\":1,\\"menuAlign\\":\\"right\\",\\"layout\\":[{\\"type\\":\\"row\\",\\"attr\\":[{\\"type\\":\\"column\\",\\"colGrid\\":12,\\"menuParentId\\":\\"\\",\\"moduleId\\":\\"\\"}]}]}","megamenu":"0","showmenutitle":"1","icon":"","class":"","enable_page_title":"0","page_title_alt":"","page_subtitle":"","page_title_bg_color":"","page_title_bg_image":""}', 1, 4, 1, '*', 0),
(449, 'usermenu', 'Submit an Article', 'submit-an-article', '', 'submit-an-article', 'index.php?option=com_content&view=form&layout=edit', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 3, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 55, 56, 0, '*', 0),
(450, 'usermenu', 'Submit a Web Link', 'submit-a-web-link', '', 'submit-a-web-link', 'index.php?option=com_weblinks&view=form&layout=edit', 'component', -2, 1, 1, 21, 0, '0000-00-00 00:00:00', 0, 3, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 57, 58, 0, '*', 0),
(471, 'main', 'com_tags', 'com-tags', '', 'com-tags', 'index.php?option=com_tags', 'component', 1, 1, 1, 29, 0, '0000-00-00 00:00:00', 0, 1, 'class:tags', 0, '', 59, 60, 0, '', 1),
(472, 'main', 'com_postinstall', 'Post-installation messages', '', 'Post-installation messages', 'index.php?option=com_postinstall', 'component', 1, 1, 1, 32, 0, '0000-00-00 00:00:00', 0, 1, 'class:postinstall', 0, '', 61, 62, 0, '*', 1),
(475, 'bottom-menu', 'JoomShaper', 'joomshaper', '', 'joomshaper', 'http://www.joomshaper.com/', 'url', -2, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"dropdown_position":"right","showmenutitle":"1","icon":"","class":"","enable_page_title":"0","page_title_alt":"","page_subtitle":"","page_title_bg_color":"","page_title_bg_image":""}', 63, 64, 0, '*', 0),
(476, 'bottom-menu', 'Themeum', 'themeum', '', 'themeum', 'http://www.themeum.com/', 'url', -2, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"dropdown_position":"right","showmenutitle":"1","icon":"","class":"","enable_page_title":"0","page_title_alt":"","page_subtitle":"","page_title_bg_color":"","page_title_bg_image":""}', 65, 66, 0, '*', 0),
(477, 'bottom-menu', 'ShapeBootstrap', 'shapebootstrap', '', 'shapebootstrap', 'http://shapebootstrap.net/', 'url', -2, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"dropdown_position":"right","showmenutitle":"1","icon":"","class":"","enable_page_title":"0","page_title_alt":"","page_subtitle":"","page_title_bg_color":"","page_title_bg_image":""}', 67, 68, 0, '*', 0),
(479, 'bottom-menu', 'Page Builder', 'page-builder', '', 'page-builder', 'http://www.joomshaper.com/page-builder', 'url', -2, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"dropdown_position":"right","showmenutitle":"1","icon":"","class":"","enable_page_title":"0","page_title_alt":"","page_subtitle":"","page_title_bg_color":"","page_title_bg_image":""}', 69, 70, 0, '*', 0),
(481, 'quickinfo', 'Helix 3 Framework', 'helix-framework', '', 'helix-framework', 'http://www.joomshaper.com/helix3', 'url', -2, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"menulayout":"{\\"width\\":600,\\"menuItem\\":1,\\"menuAlign\\":\\"right\\",\\"layout\\":[{\\"type\\":\\"row\\",\\"attr\\":[{\\"type\\":\\"column\\",\\"colGrid\\":12,\\"menuParentId\\":\\"481\\",\\"moduleId\\":\\"\\"}]}]}","megamenu":"0","showmenutitle":"1","icon":"","class":"","enable_page_title":"0","page_title_alt":"","page_subtitle":"","page_title_bg_color":"","page_title_bg_image":""}', 71, 72, 0, '*', 0),
(482, 'quickinfo', 'Documentation', 'documentation', '', 'documentation', 'http://www.joomshaper.com/documentation/', 'url', -2, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"dropdown_position":"right","showmenutitle":"1","icon":"","class":"","enable_page_title":"0","page_title_alt":"","page_subtitle":"","page_title_bg_color":"","page_title_bg_image":""}', 73, 74, 0, '*', 0),
(483, 'quickinfo', 'Demo Page Builder ', 'demo-pagebuilder', '', 'demo-pagebuilder', 'http://demo.joomshaper.com/page-builder/', 'url', -2, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"dropdown_position":"right","showmenutitle":"1","icon":"","class":"","enable_page_title":"0","page_title_alt":"","page_subtitle":"","page_title_bg_color":"","page_title_bg_image":""}', 75, 76, 0, '*', 0),
(484, 'quickinfo', 'Plans & Pricing', 'plan-pricing', '', 'plan-pricing', 'http://www.joomshaper.com/join-now', 'url', -2, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"dropdown_position":"right","showmenutitle":"1","icon":"","class":"","enable_page_title":"0","page_title_alt":"","page_subtitle":"","page_title_bg_color":"","page_title_bg_image":""}', 77, 78, 0, '*', 0),
(487, 'company', 'Coming Soon', 'coming-soon', '', 'coming-soon', '?tmpl=comingsoon', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu-anchor_rel":"","menu_image":"","menu_text":1,"menu_show":1,"menulayout":"{\\"width\\":600,\\"menuItem\\":1,\\"menuAlign\\":\\"right\\",\\"layout\\":[{\\"type\\":\\"row\\",\\"attr\\":[{\\"type\\":\\"column\\",\\"colGrid\\":12,\\"menuParentId\\":\\"487\\",\\"moduleId\\":\\"\\"}]}]}","megamenu":"0","showmenutitle":"1","icon":"","class":"","enable_page_title":"0","page_title_alt":"","page_subtitle":"","page_title_bg_color":"","page_title_bg_image":""}', 115, 116, 0, '*', 0),
(488, 'company', '404 Page', '404-page', '', '404-page', 'index.php?option=com_404', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu-anchor_rel":"","menu_image":"","menu_text":1,"menu_show":1,"dropdown_position":"right","showmenutitle":"1","icon":"","class":"","enable_page_title":"0","page_title_alt":"","page_subtitle":"","page_title_bg_color":"","page_title_bg_image":""}', 117, 118, 0, '*', 0),
(515, 'main', 'com_joomlaupdate', 'com-joomlaupdate', '', 'com-joomlaupdate', 'index.php?option=com_joomlaupdate', 'component', 1, 1, 1, 28, 0, '0000-00-00 00:00:00', 0, 1, 'class:joomlaupdate', 0, '{}', 79, 80, 0, '', 1),
(521, 'main', 'com_associations', 'multilingual-associations', '', 'multilingual-associations', 'index.php?option=com_associations', 'component', 1, 1, 1, 34, 0, '0000-00-00 00:00:00', 0, 1, 'class:associations', 0, '{}', 81, 82, 0, '*', 1),
(528, 'bottom-menu', 'Advertisement', 'advertisement', '', 'advertisement', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu-anchor_rel":"","menu_image":"","menu_text":1,"menu_show":1,"dropdown_position":"right","showmenutitle":"1","icon":"","class":"","enable_page_title":"0","page_title_alt":"","page_subtitle":"","page_title_bg_color":"","page_title_bg_image":""}', 83, 84, 0, '*', 0),
(529, 'bottom-menu', 'Categories', 'categories', '', 'categories', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu-anchor_rel":"","menu_image":"","menu_text":1,"menu_show":1,"menulayout":"{\\"width\\":600,\\"menuItem\\":1,\\"menuAlign\\":\\"right\\",\\"layout\\":[{\\"type\\":\\"row\\",\\"attr\\":[{\\"type\\":\\"column\\",\\"colGrid\\":12,\\"menuParentId\\":\\"528\\",\\"moduleId\\":\\"\\"}]}]}","megamenu":"0","showmenutitle":"1","icon":"","class":"","enable_page_title":"0","page_title_alt":"","page_subtitle":"","page_title_bg_color":"","page_title_bg_image":""}', 85, 86, 0, '*', 0),
(530, 'bottom-menu', 'Contact us', 'contact-us', '', 'contact-us', 'index.php?option=com_sppagebuilder&view=page&id=56', 'component', 1, 1, 1, 10004, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"menu_show":1,"page_title":"","show_page_heading":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"menulayout":"{\\"width\\":600,\\"menuItem\\":1,\\"menuAlign\\":\\"right\\",\\"layout\\":[{\\"type\\":\\"row\\",\\"attr\\":[{\\"type\\":\\"column\\",\\"colGrid\\":12,\\"menuParentId\\":\\"528\\",\\"moduleId\\":\\"\\"}]}]}","megamenu":"0","showmenutitle":"1","icon":"","class":"","enable_page_title":"1","page_title_alt":"Contact Us","page_subtitle":"","page_title_bg_color":"","page_title_bg_image":""}', 87, 88, 0, '*', 0),
(531, 'bottom-menu', 'Help', 'help', '', 'help', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu-anchor_rel":"","menu_image":"","menu_text":1,"menu_show":1,"menulayout":"{\\"width\\":600,\\"menuItem\\":1,\\"menuAlign\\":\\"right\\",\\"layout\\":[{\\"type\\":\\"row\\",\\"attr\\":[{\\"type\\":\\"column\\",\\"colGrid\\":12,\\"menuParentId\\":\\"528\\",\\"moduleId\\":\\"\\"}]}]}","megamenu":"0","showmenutitle":"1","icon":"","class":"","enable_page_title":"0","page_title_alt":"","page_subtitle":"","page_title_bg_color":"","page_title_bg_image":""}', 89, 90, 0, '*', 0),
(532, 'quickinfo', 'Advertising Guide', 'advertising-guide', '', 'advertising-guide', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu-anchor_rel":"","menu_image":"","menu_text":1,"menu_show":1,"dropdown_position":"right","showmenutitle":"1","icon":"","class":"","enable_page_title":"0","page_title_alt":"","page_subtitle":"","page_title_bg_color":"","page_title_bg_image":""}', 91, 92, 0, '*', 0),
(533, 'quickinfo', 'User Policies', 'user-policies', '', 'user-policies', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu-anchor_rel":"","menu_image":"","menu_text":1,"menu_show":1,"menulayout":"{\\"width\\":600,\\"menuItem\\":1,\\"menuAlign\\":\\"right\\",\\"layout\\":[{\\"type\\":\\"row\\",\\"attr\\":[{\\"type\\":\\"column\\",\\"colGrid\\":12,\\"menuParentId\\":\\"532\\",\\"moduleId\\":\\"\\"}]}]}","megamenu":"0","showmenutitle":"1","icon":"","class":"","enable_page_title":"0","page_title_alt":"","page_subtitle":"","page_title_bg_color":"","page_title_bg_image":""}', 93, 94, 0, '*', 0),
(534, 'quickinfo', 'Privacy Policy', 'privacy-policy', '', 'privacy-policy', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu-anchor_rel":"","menu_image":"","menu_text":1,"menu_show":1,"menulayout":"{\\"width\\":600,\\"menuItem\\":1,\\"menuAlign\\":\\"right\\",\\"layout\\":[{\\"type\\":\\"row\\",\\"attr\\":[{\\"type\\":\\"column\\",\\"colGrid\\":12,\\"menuParentId\\":\\"532\\",\\"moduleId\\":\\"\\"}]}]}","megamenu":"0","showmenutitle":"1","icon":"","class":"","enable_page_title":"0","page_title_alt":"","page_subtitle":"","page_title_bg_color":"","page_title_bg_image":""}', 95, 96, 0, '*', 0),
(535, 'quickinfo', 'Cookie Policy', 'cookie-policy', '', 'cookie-policy', '#', 'url', -2, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu-anchor_rel":"","menu_image":"","menu_text":1,"menu_show":1,"menulayout":"{\\"width\\":600,\\"menuItem\\":1,\\"menuAlign\\":\\"right\\",\\"layout\\":[{\\"type\\":\\"row\\",\\"attr\\":[{\\"type\\":\\"column\\",\\"colGrid\\":12,\\"menuParentId\\":\\"532\\",\\"moduleId\\":\\"\\"}]}]}","megamenu":"0","showmenutitle":"1","icon":"","class":"","enable_page_title":"0","page_title_alt":"","page_subtitle":"","page_title_bg_color":"","page_title_bg_image":""}', 97, 98, 0, '*', 0),
(536, 'company', 'About Us', 'about-us-bottom', '', 'about-us-bottom', '#', 'url', -2, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu-anchor_rel":"","menu_image":"","menu_text":1,"menu_show":1,"menulayout":"{\\"width\\":600,\\"menuItem\\":1,\\"menuAlign\\":\\"right\\",\\"layout\\":[{\\"type\\":\\"row\\",\\"attr\\":[{\\"type\\":\\"column\\",\\"colGrid\\":12,\\"menuParentId\\":\\"536\\",\\"moduleId\\":\\"\\"}]}]}","megamenu":"0","showmenutitle":"1","icon":"","class":"","enable_page_title":"0","page_title_alt":"","page_subtitle":"","page_title_bg_color":"","page_title_bg_image":""}', 99, 100, 0, '*', 0),
(537, 'company', 'Blog', 'blog-bottom', '', 'blog-bottom', 'index.php?option=com_content&view=category&layout=blog&id=79', 'component', -2, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"layout_type":"blog","show_category_heading_title_text":"","show_category_title":"","show_description":"","show_description_image":"","maxLevel":"","show_empty_categories":"","show_no_articles":"","show_subcat_desc":"","show_cat_num_articles":"","show_cat_tags":"","page_subheading":"","num_leading_articles":"","num_intro_articles":"","num_columns":"","num_links":"","multi_column_order":"","show_subcategory_content":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","show_featured":"","show_title":"1","link_titles":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"menu_show":1,"page_title":"","show_page_heading":"0","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"menulayout":"{\\"width\\":600,\\"menuItem\\":1,\\"menuAlign\\":\\"right\\",\\"layout\\":[{\\"type\\":\\"row\\",\\"attr\\":[{\\"type\\":\\"column\\",\\"colGrid\\":12,\\"menuParentId\\":\\"278\\",\\"moduleId\\":\\"\\"}]}]}","megamenu":"0","showmenutitle":"1","icon":"","class":"","enable_page_title":"1","page_title_alt":"","page_subtitle":"","page_title_bg_color":"","page_title_bg_image":""}', 101, 108, 0, '*', 0),
(538, 'company', 'Careers', 'careers-bottom', '', 'careers-bottom', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu-anchor_rel":"","menu_image":"","menu_text":1,"menu_show":1,"menulayout":"{\\"width\\":600,\\"menuItem\\":1,\\"menuAlign\\":\\"right\\",\\"layout\\":[{\\"type\\":\\"row\\",\\"attr\\":[{\\"type\\":\\"column\\",\\"colGrid\\":12,\\"menuParentId\\":\\"525\\",\\"moduleId\\":\\"\\"}]}]}","megamenu":"0","showmenutitle":"1","icon":"","class":"","enable_page_title":"0","page_title_alt":"","page_subtitle":"","page_title_bg_color":"","page_title_bg_image":""}', 109, 110, 0, '*', 0),
(539, 'company', 'Contact Us', 'contact-bottom', '', 'contact-bottom', 'index.php?option=com_sppagebuilder&view=page&id=56', 'component', 1, 1, 1, 10004, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"menu_show":1,"page_title":"","show_page_heading":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"menulayout":"{\\"width\\":600,\\"menuItem\\":1,\\"menuAlign\\":\\"right\\",\\"layout\\":[{\\"type\\":\\"row\\",\\"attr\\":[{\\"type\\":\\"column\\",\\"colGrid\\":12,\\"menuParentId\\":\\"525\\",\\"moduleId\\":\\"\\"}]}]}","megamenu":"0","showmenutitle":"1","icon":"","class":"","enable_page_title":"1","page_title_alt":"","page_subtitle":"","page_title_bg_color":"","page_title_bg_image":""}', 111, 112, 0, '*', 0),
(540, 'company', 'Blog With Right Sidebar', 'blog-with-right-sidebar', '', 'blog-bottom/blog-with-right-sidebar', 'index.php?option=com_content&view=category&layout=blog&id=79', 'component', -2, 537, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"layout_type":"blog","show_category_heading_title_text":"","show_category_title":"","show_description":"","show_description_image":"","maxLevel":"","show_empty_categories":"","show_no_articles":"","show_subcat_desc":"","show_cat_num_articles":"","show_cat_tags":"","page_subheading":"","num_leading_articles":"","num_intro_articles":"","num_columns":"","num_links":"","multi_column_order":"","show_subcategory_content":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","show_title":"1","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"dropdown_position":"right","showmenutitle":"1","icon":"","class":"","enable_page_title":"1","page_title_alt":"","page_subtitle":"","page_title_bg_color":"","page_title_bg_image":""}', 102, 103, 0, '*', 0),
(541, 'company', 'Blog With Left Sidebar', 'blog-with-left-sidebar', '', 'blog-bottom/blog-with-left-sidebar', 'index.php?option=com_content&view=category&layout=blog&id=79', 'component', -2, 537, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"layout_type":"blog","show_category_heading_title_text":"","show_category_title":"","show_description":"","show_description_image":"","maxLevel":"","show_empty_categories":"","show_no_articles":"","show_subcat_desc":"","show_cat_num_articles":"","show_cat_tags":"","page_subheading":"","num_leading_articles":"","num_intro_articles":"","num_columns":"","num_links":"","multi_column_order":"","show_subcategory_content":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","show_title":"1","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"dropdown_position":"right","showmenutitle":"1","icon":"","class":"","enable_page_title":"1","page_title_alt":"","page_subtitle":"","page_title_bg_color":"","page_title_bg_image":""}', 104, 105, 0, '*', 0),
(542, 'company', 'Article Category Blog', 'article-category-blog-2', '', 'blog-bottom/article-category-blog-2', 'index.php?option=com_content&view=category&layout=blog&id=79', 'component', -2, 537, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"layout_type":"blog","show_category_heading_title_text":"","show_category_title":"","show_description":"0","show_description_image":"0","maxLevel":"","show_empty_categories":"","show_no_articles":"","show_subcat_desc":"","show_cat_num_articles":"","show_cat_tags":"","page_subheading":"","num_leading_articles":"1","num_intro_articles":"4","num_columns":"2","num_links":"4","multi_column_order":"","show_subcategory_content":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"2","show_pagination_results":"","show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","show_feed_link":"1","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"dropdown_position":"right","showmenutitle":"1","icon":"","class":"","enable_page_title":"1","page_title_alt":"","page_subtitle":"","page_title_bg_color":"","page_title_bg_image":""}', 106, 107, 0, '*', 0),
(543, 'main', 'COM_SPPOLLS', 'com-sppolls', '', 'com-sppolls', 'index.php?option=com_sppolls', 'component', 1, 1, 1, 10026, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 113, 114, 0, '', 1),
(544, 'mainmenu', 'World', 'world', '', 'world', 'index.php?option=com_content&view=category&layout=blog&id=85', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"layout_type":"blog","show_category_heading_title_text":"","show_category_title":"","show_description":"","show_description_image":"","maxLevel":"","show_empty_categories":"","show_no_articles":"","show_subcat_desc":"","show_cat_num_articles":"","show_cat_tags":"","page_subheading":"","num_leading_articles":"","num_intro_articles":"","num_columns":"","num_links":"","multi_column_order":"","show_subcategory_content":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","show_featured":"","show_title":"","link_titles":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"menu_show":1,"page_title":"","show_page_heading":"","page_heading":"Around The World","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"menulayout":"{\\"width\\":600,\\"menuItem\\":1,\\"menuAlign\\":\\"right\\",\\"layout\\":[{\\"type\\":\\"row\\",\\"attr\\":[{\\"type\\":\\"column\\",\\"colGrid\\":12,\\"menuParentId\\":\\"544\\",\\"moduleId\\":\\"\\"}]}]}","megamenu":"0","showmenutitle":"1","icon":"","class":"","enable_page_title":"1","page_title_alt":"Business","page_subtitle":"","page_title_bg_color":"","page_title_bg_image":""}', 5, 6, 0, '*', 0),
(545, 'mainmenu', 'Sport', 'sport', '', 'sport', 'index.php?option=com_content&view=category&layout=blog&id=86', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"layout_type":"blog","show_category_heading_title_text":"","show_category_title":"","show_description":"","show_description_image":"","maxLevel":"","show_empty_categories":"","show_no_articles":"","show_subcat_desc":"","show_cat_num_articles":"","show_cat_tags":"","page_subheading":"","num_leading_articles":"","num_intro_articles":"","num_columns":"","num_links":"","multi_column_order":"","show_subcategory_content":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","show_featured":"","show_title":"","link_titles":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"menu_show":1,"page_title":"","show_page_heading":"0","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"menulayout":"{\\"width\\":1050,\\"menuItem\\":1,\\"menuAlign\\":\\"full\\",\\"layout\\":[{\\"type\\":\\"row\\",\\"attr\\":[{\\"type\\":\\"column\\",\\"colGrid\\":12,\\"menuParentId\\":\\"544\\",\\"moduleId\\":\\"130\\"}]}]}","megamenu":"0","showmenutitle":"1","icon":"","class":"menu-article-tabbed-wrap","enable_page_title":"0","page_title_alt":"","page_subtitle":"","page_title_bg_color":"","page_title_bg_image":""}', 7, 8, 0, '*', 0),
(546, 'mainmenu', 'Technology', 'technology', '', 'technology', 'index.php?option=com_content&view=category&layout=blog&id=88', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"layout_type":"blog","show_category_heading_title_text":"","show_category_title":"","show_description":"","show_description_image":"","maxLevel":"","show_empty_categories":"","show_no_articles":"","show_subcat_desc":"","show_cat_num_articles":"","show_cat_tags":"","page_subheading":"","num_leading_articles":"","num_intro_articles":"","num_columns":"","num_links":"","multi_column_order":"","show_subcategory_content":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","show_featured":"","show_title":"","link_titles":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"menu_show":1,"page_title":"","show_page_heading":"0","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"menulayout":"{\\"width\\":600,\\"menuItem\\":1,\\"menuAlign\\":\\"right\\",\\"layout\\":[{\\"type\\":\\"row\\",\\"attr\\":[{\\"type\\":\\"column\\",\\"colGrid\\":12,\\"menuParentId\\":\\"544\\",\\"moduleId\\":\\"\\"}]}]}","megamenu":"0","showmenutitle":"1","icon":"","class":"","enable_page_title":"0","page_title_alt":"","page_subtitle":"","page_title_bg_color":"","page_title_bg_image":""}', 9, 10, 0, '*', 0),
(556, 'mainmenu', 'Culture', 'culture', '', 'culture', 'index.php?option=com_content&view=category&layout=blog&id=89', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"layout_type":"blog","show_category_heading_title_text":"","show_category_title":"","show_description":"","show_description_image":"","maxLevel":"","show_empty_categories":"","show_no_articles":"","show_subcat_desc":"","show_cat_num_articles":"","show_cat_tags":"","page_subheading":"","num_leading_articles":"","num_intro_articles":"","num_columns":"","num_links":"","multi_column_order":"","show_subcategory_content":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","show_featured":"","show_title":"","link_titles":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"menu_show":1,"page_title":"","show_page_heading":"0","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"menulayout":"{\\"width\\":600,\\"menuItem\\":1,\\"menuAlign\\":\\"right\\",\\"layout\\":[{\\"type\\":\\"row\\",\\"attr\\":[{\\"type\\":\\"column\\",\\"colGrid\\":12,\\"menuParentId\\":\\"544\\",\\"moduleId\\":\\"\\"}]}]}","megamenu":"0","showmenutitle":"1","icon":"","class":"","enable_page_title":"0","page_title_alt":"","page_subtitle":"","page_title_bg_color":"","page_title_bg_image":""}', 11, 12, 0, '*', 0),
(559, 'mainmenu', 'Fashion', 'fashion', '', 'fashion', 'index.php?option=com_content&view=category&layout=blog&id=92', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"layout_type":"blog","show_category_heading_title_text":"","show_category_title":"","show_description":"","show_description_image":"","maxLevel":"","show_empty_categories":"","show_no_articles":"","show_subcat_desc":"","show_cat_num_articles":"","show_cat_tags":"","page_subheading":"","num_leading_articles":"","num_intro_articles":"","num_columns":"","num_links":"","multi_column_order":"","show_subcategory_content":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","show_featured":"","show_title":"","link_titles":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"menu_show":1,"page_title":"","show_page_heading":"0","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"menulayout":"{\\"width\\":600,\\"menuItem\\":1,\\"menuAlign\\":\\"right\\",\\"layout\\":[{\\"type\\":\\"row\\",\\"attr\\":[{\\"type\\":\\"column\\",\\"colGrid\\":12,\\"menuParentId\\":\\"544\\",\\"moduleId\\":\\"\\"}]}]}","megamenu":"0","showmenutitle":"1","icon":"","class":"","enable_page_title":"0","page_title_alt":"","page_subtitle":"","page_title_bg_color":"","page_title_bg_image":""}', 17, 18, 0, '*', 0),
(563, 'mainmenu', 'Video', 'video', '', 'video', 'index.php?option=com_content&view=category&layout=blog&id=96', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"layout_type":"blog","show_category_heading_title_text":"","show_category_title":"","show_description":"","show_description_image":"","maxLevel":"","show_empty_categories":"","show_no_articles":"","show_subcat_desc":"","show_cat_num_articles":"","show_cat_tags":"","page_subheading":"","num_leading_articles":"","num_intro_articles":"","num_columns":"","num_links":"","multi_column_order":"","show_subcategory_content":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","show_featured":"","show_title":"","link_titles":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"menu_show":1,"page_title":"","show_page_heading":"0","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"menulayout":"{\\"width\\":600,\\"menuItem\\":1,\\"menuAlign\\":\\"right\\",\\"layout\\":[{\\"type\\":\\"row\\",\\"attr\\":[{\\"type\\":\\"column\\",\\"colGrid\\":12,\\"menuParentId\\":\\"544\\",\\"moduleId\\":\\"\\"}]}]}","megamenu":"0","showmenutitle":"1","icon":"","class":"","enable_page_title":"0","page_title_alt":"","page_subtitle":"","page_title_bg_color":"","page_title_bg_image":""}', 19, 20, 0, '*', 0),
(566, 'mainmenu', 'Variation 2', 'variation-2', '', 'home/variation-2', 'index.php?option=com_sppagebuilder&view=page&id=46', 'component', 1, 437, 2, 10004, 0, '0000-00-00 00:00:00', 0, 1, ' ', 13, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"menu_show":1,"page_title":"","show_page_heading":"","page_heading":"","pageclass_sfx":"newskit-v2","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"dropdown_position":"right","showmenutitle":"1","icon":"","class":"","enable_page_title":"0","page_title_alt":"","page_subtitle":"","page_title_bg_color":"","page_title_bg_image":""}', 2, 3, 0, '*', 0),
(567, 'usermenu', 'Logout', 'logout', '', 'logout', 'index.php?option=com_users&view=login', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu-anchor_rel":"","menu_image":"","menu_text":1,"menu_show":1,"dropdown_position":"right","showmenutitle":"1","icon":"","class":"","enable_page_title":"0","page_title_alt":"","page_subtitle":"","page_title_bg_color":"","page_title_bg_image":""}', 119, 120, 0, '*', 0),
(568, 'mainmenu', 'Lifestyle', 'lifestyle', '', 'lifestyle', 'index.php?option=com_content&view=category&layout=blog&id=91', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"layout_type":"blog","show_category_heading_title_text":"","show_category_title":"","show_description":"","show_description_image":"","maxLevel":"","show_empty_categories":"","show_no_articles":"","show_subcat_desc":"","show_cat_num_articles":"","show_cat_tags":"","page_subheading":"","num_leading_articles":"","num_intro_articles":"","num_columns":"","num_links":"","multi_column_order":"","show_subcategory_content":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","show_featured":"","show_title":"","link_titles":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"menu_show":1,"page_title":"","show_page_heading":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"dropdown_position":"right","showmenutitle":"1","icon":"","class":"","enable_page_title":"0","page_title_alt":"","page_subtitle":"","page_title_bg_color":"","page_title_bg_image":""}', 15, 16, 0, '*', 0),
(569, 'mainmenu', 'Business', 'business', '', 'business', 'index.php?option=com_content&view=category&layout=blog&id=90', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"layout_type":"blog","show_category_heading_title_text":"","show_category_title":"","show_description":"","show_description_image":"","maxLevel":"","show_empty_categories":"","show_no_articles":"","show_subcat_desc":"","show_cat_num_articles":"","show_cat_tags":"","page_subheading":"","num_leading_articles":"","num_intro_articles":"","num_columns":"","num_links":"","multi_column_order":"","show_subcategory_content":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","show_featured":"","show_title":"","link_titles":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_associations":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"menu_show":1,"page_title":"","show_page_heading":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"dropdown_position":"right","showmenutitle":"1","icon":"","class":"","enable_page_title":"0","page_title_alt":"","page_subtitle":"","page_title_bg_color":"","page_title_bg_image":""}', 13, 14, 0, '*', 0),
(582, 'main', 'AcyMailing', 'acymailing', '', 'acymailing', 'index.php?option=com_acymailing', 'component', 1, 1, 1, 10028, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_acymailing/images/icons/icon-16-acymailing.png', 0, '{}', 121, 136, 0, '', 1),
(583, 'main', 'Users', 'users', '', 'acymailing/users', 'index.php?option=com_acymailing&ctrl=subscriber', 'component', 1, 582, 2, 10028, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_acymailing/images/icons/icon-16-users.png', 0, '{}', 122, 123, 0, '', 1),
(584, 'main', 'Lists', 'lists', '', 'acymailing/lists', 'index.php?option=com_acymailing&ctrl=list', 'component', 1, 582, 2, 10028, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_acymailing/images/icons/icon-16-acylist.png', 0, '{}', 124, 125, 0, '', 1),
(585, 'main', 'Newsletters', 'newsletters', '', 'acymailing/newsletters', 'index.php?option=com_acymailing&ctrl=newsletter', 'component', 1, 582, 2, 10028, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_acymailing/images/icons/icon-16-newsletter.png', 0, '{}', 126, 127, 0, '', 1),
(586, 'main', 'Templates', 'templates', '', 'acymailing/templates', 'index.php?option=com_acymailing&ctrl=template', 'component', 1, 582, 2, 10028, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_acymailing/images/icons/icon-16-acytemplate.png', 0, '{}', 128, 129, 0, '', 1),
(587, 'main', 'Queue', 'queue', '', 'acymailing/queue', 'index.php?option=com_acymailing&ctrl=queue', 'component', 1, 582, 2, 10028, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_acymailing/images/icons/icon-16-process.png', 0, '{}', 130, 131, 0, '', 1),
(588, 'main', 'Statistics', 'statistics', '', 'acymailing/statistics', 'index.php?option=com_acymailing&ctrl=stats', 'component', 1, 582, 2, 10028, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_acymailing/images/icons/icon-16-stats.png', 0, '{}', 132, 133, 0, '', 1),
(589, 'main', 'Configuration', 'configuration', '', 'acymailing/configuration', 'index.php?option=com_acymailing&ctrl=cpanel', 'component', 1, 582, 2, 10028, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_acymailing/images/icons/icon-16-acyconfig.png', 0, '{}', 134, 135, 0, '', 1),
(591, 'main', 'COM_SPPAGEBUILDER', 'com-sppagebuilder', '', 'com-sppagebuilder', 'index.php?option=com_sppagebuilder', 'component', 1, 1, 1, 10004, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 137, 138, 0, '', 1);

-- --------------------------------------------------------

--
-- Table structure for table `#__menu_types`
--

DROP TABLE IF EXISTS `#__menu_types`;
CREATE TABLE `#__menu_types` (
  `id` int(10) unsigned NOT NULL,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0',
  `menutype` varchar(24) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(48) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__menu_types`
--

INSERT INTO `#__menu_types` (`id`, `asset_id`, `menutype`, `title`, `description`, `client_id`) VALUES
(2, 0, 'usermenu', 'User Menu', 'A Menu for logged-in Users', 0),
(4, 0, 'mainmenu', 'Main Menu', 'Main Menu', 0),
(8, 220, 'bottom-menu', 'Bottom menu', '', 0),
(9, 221, 'quickinfo', 'Quick Info', '', 0),
(11, 222, 'company', 'Company', '', 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__messages`
--

DROP TABLE IF EXISTS `#__messages`;
CREATE TABLE `#__messages` (
  `message_id` int(10) unsigned NOT NULL,
  `user_id_from` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id_to` int(10) unsigned NOT NULL DEFAULT '0',
  `folder_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `date_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `priority` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `subject` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `message` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__messages_cfg`
--

DROP TABLE IF EXISTS `#__messages_cfg`;
CREATE TABLE `#__messages_cfg` (
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `cfg_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `cfg_value` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__modules`
--

DROP TABLE IF EXISTS `#__modules`;
CREATE TABLE `#__modules` (
  `id` int(11) NOT NULL,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `position` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `module` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `showtitle` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_id` tinyint(4) NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB AUTO_INCREMENT=136 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__modules`
--

INSERT INTO `#__modules` (`id`, `asset_id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES
(2, 0, 'Login', '', '', 1, 'login', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_login', 1, 1, '', 1, '*'),
(3, 0, 'Popular Articles', '', '', 3, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_popular', 3, 1, '{"count":"5","catid":"","user_id":"0","layout":"_:default","moduleclass_sfx":"","cache":"0","automatic_title":"1"}', 1, '*'),
(4, 0, 'Recently Added Articles', '', '', 4, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_latest', 3, 1, '{"count":"5","ordering":"c_dsc","catid":"","user_id":"0","layout":"_:default","moduleclass_sfx":"","cache":"0","automatic_title":"1"}', 1, '*'),
(8, 0, 'Toolbar', '', '', 1, 'toolbar', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_toolbar', 3, 1, '', 1, '*'),
(9, 0, 'Quick Icons', '', '', 1, 'icon', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_quickicon', 3, 1, '', 1, '*'),
(10, 0, 'Logged-in Users', '', '', 2, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_logged', 3, 1, '{"count":"5","name":"1","layout":"_:default","moduleclass_sfx":"","cache":"0","automatic_title":"1"}', 1, '*'),
(12, 0, 'Admin Menu', '', '', 1, 'menu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 3, 1, '{"layout":"","moduleclass_sfx":"","shownew":"1","showhelp":"1","cache":"0"}', 1, '*'),
(13, 0, 'Admin Submenu', '', '', 1, 'submenu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_submenu', 3, 1, '', 1, '*'),
(14, 0, 'User Status', '', '', 2, 'status', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_status', 3, 1, '', 1, '*'),
(15, 0, 'Title', '', '', 1, 'title', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_title', 3, 1, '', 1, '*'),
(17, 185, 'Breadcrumbs', '', '', 1, 'breadcrumb', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_breadcrumbs', 1, 1, '{"showHere":"1","showHome":"1","homeText":"","showLast":"1","separator":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0","icon":"","background_color":"","color":"","padding":"","margin":""}', 0, '*'),
(35, 186, 'Search', '', '', 1, 'offcanvas', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_search', 1, 1, '{"label":"","width":"20","text":"","button":"0","button_pos":"right","imagebutton":"0","button_text":"","opensearch":"1","opensearch_title":"","set_itemid":"0","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0","icon":"","background_color":"","color":"","padding":"","margin":""}', 0, '*'),
(79, 0, 'Multilanguage status', '', '', 1, 'status', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 'mod_multilangstatus', 3, 1, '{"layout":"_:default","moduleclass_sfx":"","cache":"0"}', 1, '*'),
(86, 0, 'Joomla Version', '', '', 1, 'footer', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_version', 3, 1, '{"format":"short","product":"1","layout":"_:default","moduleclass_sfx":"","cache":"0"}', 1, '*'),
(91, 181, 'SP Page Builder', '', '', 0, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_sppagebuilder_icons', 1, 1, '', 1, '*'),
(92, 182, 'SP Page Builder Admin Menu', '', '', 1, 'menu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_sppagebuilder_admin_menu', 1, 1, '', 1, '*'),
(96, 189, 'Bottom menu', '', '', 1, 'bottom1', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 0, '{"menutype":"bottom-menu","base":"","startLevel":"1","endLevel":"0","showAllChildren":"1","tag_id":"","class_sfx":"","window_open":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(102, 206, 'Search', '', '', 1, 'left', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_search', 1, 1, '{"label":"","width":"20","text":"","button":"0","button_pos":"right","imagebutton":"0","button_text":"","opensearch":"1","opensearch_title":"","set_itemid":"0","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0","icon":"","background_color":"","color":"","padding":"","margin":""}', 0, '*'),
(103, 207, 'Latest News', '', '', 2, 'pagebuilder', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_latest', 1, 1, '{"catid":["85","86","88","89","90","91","92","93","96"],"count":"10","show_featured":"","ordering":"c_dsc","user_id":"0","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(104, 208, 'Information', '', '', 3, 'left', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 1, '{"menutype":"bottom-menu","base":"","startLevel":"1","endLevel":"0","showAllChildren":"1","tag_id":"","class_sfx":"","window_open":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0","icon":"","background_color":"","color":"","padding":"","margin":""}', 0, '*'),
(105, 209, 'Off Canvas Menu', '', '', 1, 'offcanvas', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 0, '{"menutype":"mainmenu","base":"","startLevel":"1","endLevel":"0","showAllChildren":"1","tag_id":"","class_sfx":"","window_open":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(109, 215, 'Social & newsletter', '', '', 1, 'bottom2', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_sppagebuilder', 1, 1, '{"content":"[{\\"id\\":1496647276547,\\"visibility\\":true,\\"collapse\\":false,\\"settings\\":{\\"padding\\":\\"50px 0px 50px 0px\\",\\"margin\\":\\"0px 0px 0px 0px\\"},\\"layout\\":\\"12\\",\\"columns\\":[{\\"id\\":1496647276548,\\"class_name\\":\\"col-md-12\\",\\"visibility\\":true,\\"settings\\":{},\\"addons\\":[{\\"id\\":1496647276551,\\"name\\":\\"text_block\\",\\"visibility\\":true,\\"settings\\":{\\"admin_label\\":\\"\\",\\"title\\":\\"\\",\\"heading_selector\\":\\"h3\\",\\"title_fontsize\\":\\"\\",\\"title_lineheight\\":\\"\\",\\"title_fontstyle\\":null,\\"title_letterspace\\":\\"0\\",\\"title_fontweight\\":\\"\\",\\"title_text_color\\":\\"\\",\\"title_margin_top\\":\\"\\",\\"title_margin_bottom\\":\\"\\",\\"text\\":\\"<ul>\\\\n<li><a href=\\\\\\"#\\\\\\"><span class=\\\\\\"fa fa-twitter\\\\\\"><span class=\\\\\\"dummy\\\\\\">Twitter<\\/span><\\/span><\\/a><\\/li>\\\\n<li><a href=\\\\\\"#\\\\\\"><span class=\\\\\\"fa fa-facebook-square\\\\\\"><span class=\\\\\\"dummy\\\\\\">Facebook<\\/span><\\/span><\\/a><\\/li>\\\\n<li><a href=\\\\\\"#\\\\\\"><span class=\\\\\\"fa fa-linkedin\\\\\\"><span class=\\\\\\"dummy\\\\\\">LinkedIn<\\/span><\\/span><\\/a><\\/li>\\\\n<li><a href=\\\\\\"#\\\\\\"><span class=\\\\\\"fa fa-google-plus\\\\\\"><span class=\\\\\\"dummy\\\\\\">Google Plus<\\/span><\\/span><\\/a><\\/li>\\\\n<li><a href=\\\\\\"#\\\\\\"><span class=\\\\\\"fa fa-envelope-o\\\\\\"><span class=\\\\\\"dummy\\\\\\">Contact us via email<\\/span><\\/span><\\/a><\\/li>\\\\n<\\/ul>\\",\\"alignment\\":\\"sppb-text-left\\",\\"class\\":\\"\\",\\"global_text_color\\":\\"\\",\\"global_link_color\\":\\"\\",\\"global_link_hover_color\\":\\"\\",\\"global_use_background\\":\\"0\\",\\"global_background_color\\":\\"\\",\\"global_background_image\\":\\"\\",\\"global_background_repeat\\":\\"no-repeat\\",\\"global_background_size\\":\\"cover\\",\\"global_background_attachment\\":\\"inherit\\",\\"global_user_border\\":\\"0\\",\\"global_border_width\\":\\"\\",\\"global_border_color\\":\\"\\",\\"global_boder_style\\":\\"none\\",\\"global_border_radius\\":\\"\\",\\"global_margin\\":\\"\\",\\"global_padding\\":\\"\\",\\"global_use_animation\\":\\"0\\",\\"global_animation\\":\\"\\",\\"global_animationduration\\":\\"300\\",\\"global_animationdelay\\":\\"0\\",\\"hidden_md\\":\\"0\\",\\"hidden_sm\\":\\"0\\",\\"hidden_xs\\":\\"0\\",\\"acl\\":null}}]}]}]","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(111, 217, 'Top Search', '', '', 1, 'top1', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_search', 1, 0, '{"label":"","width":"20","text":"","button":"1","button_pos":"right","imagebutton":"0","button_text":"test","opensearch":"1","opensearch_title":"","set_itemid":"0","layout":"shaper_newskit:topsearch","moduleclass_sfx":"top-search","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(112, 218, 'Login', '', '', 1, 'top1', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_login', 1, 0, '{"pretext":"","posttext":"","login":"","logout":"","greeting":"1","profilelink":"0","name":"0","usesecure":"0","usetext":"0","layout":"_:default","moduleclass_sfx":"sp-top-login","cache":"0","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(113, 223, 'Company', '', '', 1, 'bottom3', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 1, '{"menutype":"company","base":"","startLevel":"1","endLevel":"0","showAllChildren":"1","tag_id":"","class_sfx":"","window_open":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(114, 224, 'Quick Info', '', '', 1, 'bottom4', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 1, '{"menutype":"quickinfo","base":"","startLevel":"1","endLevel":"0","showAllChildren":"1","tag_id":"","class_sfx":"","window_open":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(115, 237, 'Blog details ad', '', '', 1, 'blog-details-add', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_banners', 1, 0, '{"target":"1","count":1,"cid":"4","catid":["94"],"tag_search":"0","ordering":"0","header_text":"","footer_text":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(117, 245, 'Home ad 1', '', '', 1, 'pagebuilder', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_banners', 1, 0, '{"target":"1","count":5,"cid":"0","catid":["95"],"tag_search":"0","ordering":"0","header_text":"","footer_text":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(118, 271, 'People''s Poll', 'For articles category only', '', 5, 'right', 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', 1, 'mod_sp_poll', 1, 1, '{"poll_type":"single","poll_id":"1","lag":"12","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(119, 273, 'Sidebar ad1', '', '', 1, 'pagebuilder', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_banners', 1, 0, '{"target":"1","count":5,"cid":"4","catid":["97"],"tag_search":"0","ordering":"0","header_text":"","footer_text":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(120, 274, 'Popular Post', '', '', 1, 'pagebuilder', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_popular', 1, 0, '{"catid":["85"],"count":"3","show_front":"1","date_filtering":"off","date_field":"a.created","start_date_range":"","end_date_range":"","relative_date":"30","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(121, 276, 'Subscribe Our Newsletter ', '', '', 1, 'pagebuilder', 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', 1, 'mod_acymailing', 1, 0, '{"effect":"normal","lists":"None","hiddenlists":"All","displaymode":"tableless","listschecked":"All","checkmode":"0","dropdown":"0","overlay":"0","link":"1","listposition":"before","customfields":"email","nametext":"","emailtext":"Your email id","fieldsize":"100%","displayfields":"0","introtext":"<p class=\\"icon\\"><span class=\\"newskit newskit-envelope\\"><\\/span><\\/p>\\r\\nSubscribe Our Newsletter <p>Amazing Deals, Updates & Freebies In Your Inbox<\\/p>","finaltext":"","showsubscribe":"1","subscribetext":"","subscribetextreg":"","showunsubscribe":"0","unsubscribetext":"","redirectmode":"3","redirectlink":"","redirectlinkunsub":"","showterms":"0","showtermspopup":"1","termscontent":"0","mootoolsintro":"","mootoolsbutton":"","boxwidth":"250","boxheight":"200","moduleclass_sfx":"","textalign":"none","loggedin":"1","cache":"0","cache_time":"15","includejs":"header","itemid":"","loadmootools":"1","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(122, 290, 'Subscribe Our Newsletter', 'For articles category only', '', 2, 'right', 0, '0000-00-00 00:00:00', '2017-11-30 08:02:42', '0000-00-00 00:00:00', 1, 'mod_acymailing', 1, 0, '{"effect":"normal","lists":"None","hiddenlists":"All","displaymode":"tableless","listschecked":"All","checkmode":"0","dropdown":"1","overlay":"0","link":"1","listposition":"before","customfields":"email","nametext":"","emailtext":"Your email id","fieldsize":"100%","displayfields":"0","introtext":"<p class=\\"icon\\"><span class=\\"newskit newskit-envelope\\"><\\/span><\\/p>\\r\\nSubscribe Our Newsletter <p>Amazing Deals, Updates & Freebies In Your Inbox<\\/p>","finaltext":"","showsubscribe":"1","subscribetext":"","subscribetextreg":"","showunsubscribe":"0","unsubscribetext":"","redirectmode":"3","redirectlink":"","redirectlinkunsub":"","showterms":"0","showtermspopup":"1","termscontent":"0","mootoolsintro":"","mootoolsbutton":"","boxwidth":"250","boxheight":"200","moduleclass_sfx":"","textalign":"none","loggedin":"1","cache":"0","cache_time":"15","includejs":"header","itemid":"","loadmootools":"1","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(123, 291, 'Sidebar ad1', 'For articles category only', '', 4, 'right', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_banners', 1, 0, '{"target":"1","count":5,"cid":"4","catid":["97"],"tag_search":"0","ordering":"0","header_text":"","footer_text":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(124, 292, 'Popular Post', 'For articles category only', '', 3, 'right', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_popular', 1, 1, '{"catid":["85"],"count":"3","show_front":"1","date_filtering":"off","date_field":"a.created","start_date_range":"","end_date_range":"","relative_date":"30","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(125, 300, 'Bloglist ad', '', '', 1, 'bloglist-ad', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_banners', 1, 0, '{"target":"1","count":5,"cid":"4","catid":["98"],"tag_search":"0","ordering":"0","header_text":"","footer_text":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(126, 301, 'Bloglist bottom ad', '', '', 1, 'blog-bottom', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_sppagebuilder', 1, 0, '{"content":"[{\\"id\\":1497257206877,\\"visibility\\":true,\\"collapse\\":false,\\"settings\\":{\\"admin_label\\":\\"Newskit App Download\\",\\"title\\":\\"\\",\\"heading_selector\\":\\"h3\\",\\"title_fontsize\\":\\"\\",\\"title_fontweight\\":\\"\\",\\"title_text_color\\":\\"\\",\\"title_margin_top\\":\\"\\",\\"title_margin_bottom\\":\\"\\",\\"subtitle\\":\\"\\",\\"subtitle_fontsize\\":\\"\\",\\"title_position\\":\\"sppb-text-center\\",\\"columns_equal_height\\":\\"0\\",\\"fullscreen\\":\\"0\\",\\"no_gutter\\":\\"0\\",\\"id\\":\\"\\",\\"class\\":\\"newskit-app-download-section\\",\\"padding\\":\\"50px 0px 50px 0px\\",\\"margin\\":\\"0px 0px 0px 0px\\",\\"color\\":\\"\\",\\"background_color\\":\\"\\",\\"background_image\\":\\"\\",\\"overlay\\":\\"\\",\\"background_repeat\\":\\"no-repeat\\",\\"background_size\\":\\"cover\\",\\"background_attachment\\":\\"fixed\\",\\"background_position\\":\\"0 0\\",\\"background_video\\":\\"0\\",\\"background_video_mp4\\":\\"\\",\\"background_video_ogv\\":\\"\\",\\"hidden_xs\\":\\"\\",\\"hidden_sm\\":\\"\\",\\"hidden_md\\":\\"\\",\\"animation\\":\\"\\",\\"animationduration\\":\\"300\\",\\"animationdelay\\":\\"0\\"},\\"layout\\":\\"7,5\\",\\"columns\\":[{\\"id\\":1496724695921,\\"class_name\\":\\"col-md-7\\",\\"visibility\\":true,\\"settings\\":{\\"color\\":\\"rgba(255, 255, 255, 1)\\",\\"background\\":\\"\\",\\"background_image\\":\\"images\\/2017\\/06\\/06\\/ad-bg.jpg\\",\\"overlay\\":\\"\\",\\"background_repeat\\":\\"no-repeat\\",\\"background_size\\":\\"cover\\",\\"background_attachment\\":\\"inherit\\",\\"background_position\\":\\"50% 50%\\",\\"padding\\":{\\"md\\":\\"30px 30px 30px 30px\\",\\"sm\\":\\"   \\",\\"xs\\":\\"   \\"},\\"class\\":\\"left-ad\\",\\"sm_col\\":\\"col-sm-7\\",\\"xs_col\\":\\"\\",\\"hidden_xs\\":0,\\"hidden_sm\\":0,\\"hidden_md\\":0,\\"animation\\":\\"\\",\\"animationduration\\":\\"300\\",\\"animationdelay\\":\\"0\\",\\"items_align_center\\":0},\\"addons\\":[{\\"id\\":1496724695925,\\"name\\":\\"image\\",\\"visibility\\":true,\\"settings\\":{\\"admin_label\\":\\"\\",\\"title\\":\\"\\",\\"heading_selector\\":\\"h3\\",\\"title_fontsize\\":\\"\\",\\"title_lineheight\\":\\"\\",\\"title_fontstyle\\":null,\\"title_letterspace\\":\\"0\\",\\"title_fontweight\\":\\"\\",\\"title_text_color\\":\\"\\",\\"title_margin_top\\":\\"\\",\\"title_margin_bottom\\":\\"\\",\\"image\\":\\"images\\/2017\\/06\\/06\\/white-logo.png\\",\\"alt_text\\":\\"logo\\",\\"position\\":\\"sppb-text-left\\",\\"open_lightbox\\":\\"0\\",\\"overlay_color\\":\\"rgba(119, 219, 31, 0.5)\\",\\"link\\":\\"\\",\\"target\\":\\"\\",\\"class\\":\\"\\",\\"global_text_color\\":\\"\\",\\"global_link_color\\":\\"\\",\\"global_link_hover_color\\":\\"\\",\\"global_use_background\\":\\"0\\",\\"global_background_color\\":\\"\\",\\"global_background_image\\":\\"\\",\\"global_background_repeat\\":\\"no-repeat\\",\\"global_background_size\\":\\"cover\\",\\"global_background_attachment\\":\\"inherit\\",\\"global_user_border\\":\\"0\\",\\"global_border_width\\":\\"\\",\\"global_border_color\\":\\"\\",\\"global_boder_style\\":\\"none\\",\\"global_border_radius\\":\\"\\",\\"global_margin\\":\\"\\",\\"global_padding\\":\\"\\",\\"global_use_animation\\":\\"0\\",\\"global_animation\\":\\"\\",\\"global_animationduration\\":\\"300\\",\\"global_animationdelay\\":\\"0\\",\\"hidden_md\\":\\"0\\",\\"hidden_sm\\":\\"0\\",\\"hidden_xs\\":\\"0\\",\\"acl\\":null}},{\\"id\\":1496724695928,\\"name\\":\\"heading\\",\\"visibility\\":true,\\"settings\\":{\\"admin_label\\":\\"Download Newskit App\\",\\"title\\":\\"Download Newskit App\\",\\"heading_selector\\":\\"h2\\",\\"use_link\\":\\"0\\",\\"title_link\\":\\"\\",\\"link_new_tab\\":\\"0\\",\\"title_fontsize\\":\\"22\\",\\"title_fontstyle\\":null,\\"title_fontweight\\":\\"700\\",\\"title_lineheight\\":\\"\\",\\"title_letterspace\\":\\"0\\",\\"title_margin\\":\\"15px 0px 10px 0px\\",\\"title_padding\\":\\"0px 0px 0px 0px\\",\\"alignment\\":\\"sppb-text-left\\",\\"class\\":\\"\\",\\"global_text_color\\":\\"\\",\\"global_link_color\\":\\"\\",\\"global_link_hover_color\\":\\"\\",\\"global_use_background\\":\\"0\\",\\"global_background_color\\":\\"\\",\\"global_background_image\\":\\"\\",\\"global_background_repeat\\":\\"no-repeat\\",\\"global_background_size\\":\\"cover\\",\\"global_background_attachment\\":\\"inherit\\",\\"global_user_border\\":\\"0\\",\\"global_border_width\\":\\"\\",\\"global_border_color\\":\\"\\",\\"global_boder_style\\":\\"none\\",\\"global_border_radius\\":\\"\\",\\"global_margin\\":\\"\\",\\"global_padding\\":\\"\\",\\"global_use_animation\\":\\"0\\",\\"global_animation\\":\\"\\",\\"global_animationduration\\":\\"300\\",\\"global_animationdelay\\":\\"0\\",\\"hidden_md\\":\\"0\\",\\"hidden_sm\\":\\"0\\",\\"hidden_xs\\":\\"0\\",\\"acl\\":null}},{\\"id\\":1496724695931,\\"name\\":\\"text_block\\",\\"visibility\\":true,\\"settings\\":{\\"admin_label\\":\\"\\",\\"title\\":\\"\\",\\"heading_selector\\":\\"h3\\",\\"title_fontsize\\":\\"\\",\\"title_lineheight\\":\\"\\",\\"title_fontstyle\\":null,\\"title_letterspace\\":\\"0\\",\\"title_fontweight\\":\\"\\",\\"title_text_color\\":\\"\\",\\"title_margin_top\\":\\"\\",\\"title_margin_bottom\\":\\"\\",\\"text\\":\\"<p style=\\\\\\"font-size: 12px; line-height: 1.5;\\\\\\">Lorem Ipsum is simply dummy text of the printing and<br \\/> typesetting industry.<\\/p>\\",\\"alignment\\":\\"sppb-text-left\\",\\"class\\":\\"\\",\\"global_text_color\\":\\"\\",\\"global_link_color\\":\\"\\",\\"global_link_hover_color\\":\\"\\",\\"global_use_background\\":\\"0\\",\\"global_background_color\\":\\"\\",\\"global_background_image\\":\\"\\",\\"global_background_repeat\\":\\"no-repeat\\",\\"global_background_size\\":\\"cover\\",\\"global_background_attachment\\":\\"inherit\\",\\"global_user_border\\":\\"0\\",\\"global_border_width\\":\\"\\",\\"global_border_color\\":\\"\\",\\"global_boder_style\\":\\"none\\",\\"global_border_radius\\":\\"\\",\\"global_margin\\":\\"0 0 25px 0\\",\\"global_padding\\":\\"\\",\\"global_use_animation\\":\\"0\\",\\"global_animation\\":\\"\\",\\"global_animationduration\\":\\"300\\",\\"global_animationdelay\\":\\"0\\",\\"hidden_md\\":\\"0\\",\\"hidden_sm\\":\\"0\\",\\"hidden_xs\\":\\"0\\",\\"acl\\":null}},{\\"id\\":1496988583427,\\"name\\":\\"clients\\",\\"visibility\\":true,\\"settings\\":{\\"admin_label\\":\\"\\",\\"title\\":\\"\\",\\"heading_selector\\":\\"h3\\",\\"title_fontsize\\":\\"\\",\\"title_lineheight\\":\\"\\",\\"title_fontstyle\\":null,\\"title_letterspace\\":\\"0\\",\\"title_fontweight\\":\\"\\",\\"title_text_color\\":\\"\\",\\"title_margin_top\\":\\"\\",\\"title_margin_bottom\\":\\"\\",\\"count\\":\\"sppb-col-sm-6\\",\\"alignment\\":\\"sppb-text-left\\",\\"class\\":\\"\\",\\"sp_clients_item\\":[{\\"title\\":\\"\\",\\"image\\":\\"images\\/2017\\/06\\/06\\/app-store.png\\",\\"url\\":\\"#\\"},{\\"title\\":\\"\\",\\"image\\":\\"images\\/2017\\/06\\/06\\/google-play.png\\",\\"url\\":\\"#\\"}],\\"global_text_color\\":\\"\\",\\"global_link_color\\":\\"\\",\\"global_link_hover_color\\":\\"\\",\\"global_use_background\\":\\"0\\",\\"global_background_color\\":\\"\\",\\"global_background_image\\":\\"\\",\\"global_background_repeat\\":\\"no-repeat\\",\\"global_background_size\\":\\"cover\\",\\"global_background_attachment\\":\\"inherit\\",\\"global_user_border\\":\\"0\\",\\"global_border_width\\":\\"\\",\\"global_border_color\\":\\"\\",\\"global_boder_style\\":\\"none\\",\\"global_border_radius\\":\\"\\",\\"global_margin\\":\\"\\",\\"global_padding\\":\\"\\",\\"global_use_animation\\":\\"0\\",\\"global_animation\\":\\"\\",\\"global_animationduration\\":\\"300\\",\\"global_animationdelay\\":\\"0\\",\\"hidden_md\\":\\"0\\",\\"hidden_sm\\":\\"0\\",\\"hidden_xs\\":\\"0\\",\\"acl\\":null}}]},{\\"id\\":1496724695922,\\"class_name\\":\\"col-md-5\\",\\"visibility\\":true,\\"settings\\":{\\"color\\":\\"\\",\\"background\\":\\"\\",\\"background_image\\":\\"\\",\\"overlay\\":\\"\\",\\"background_repeat\\":\\"no-repeat\\",\\"background_size\\":\\"cover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"0 0\\",\\"padding\\":\\"\\",\\"class\\":\\"\\",\\"sm_col\\":\\"col-sm-5\\",\\"xs_col\\":\\"\\",\\"hidden_xs\\":\\"\\",\\"hidden_sm\\":\\"\\",\\"hidden_md\\":\\"\\",\\"animation\\":\\"\\",\\"animationduration\\":\\"300\\",\\"animationdelay\\":\\"0\\"},\\"addons\\":[{\\"id\\":1496724695955,\\"name\\":\\"image\\",\\"visibility\\":true,\\"settings\\":{\\"admin_label\\":\\"\\",\\"title\\":\\"\\",\\"heading_selector\\":\\"h3\\",\\"title_fontsize\\":\\"\\",\\"title_lineheight\\":\\"\\",\\"title_fontstyle\\":null,\\"title_letterspace\\":\\"0\\",\\"title_fontweight\\":\\"\\",\\"title_text_color\\":\\"\\",\\"title_margin_top\\":\\"\\",\\"title_margin_bottom\\":\\"\\",\\"image\\":\\"images\\/2017\\/06\\/06\\/ad-bg2.jpg\\",\\"alt_text\\":\\"banner\\",\\"position\\":\\"sppb-text-center\\",\\"open_lightbox\\":\\"0\\",\\"overlay_color\\":\\"rgba(119, 219, 31, 0.5)\\",\\"link\\":\\"\\",\\"target\\":\\"\\",\\"class\\":\\"\\",\\"global_text_color\\":\\"\\",\\"global_link_color\\":\\"\\",\\"global_link_hover_color\\":\\"\\",\\"global_use_background\\":\\"0\\",\\"global_background_color\\":\\"\\",\\"global_background_image\\":\\"\\",\\"global_background_repeat\\":\\"no-repeat\\",\\"global_background_size\\":\\"cover\\",\\"global_background_attachment\\":\\"inherit\\",\\"global_user_border\\":\\"0\\",\\"global_border_width\\":\\"\\",\\"global_border_color\\":\\"\\",\\"global_boder_style\\":\\"none\\",\\"global_border_radius\\":\\"\\",\\"global_margin\\":\\"\\",\\"global_padding\\":\\"\\",\\"global_use_animation\\":\\"0\\",\\"global_animation\\":\\"\\",\\"global_animationduration\\":\\"300\\",\\"global_animationdelay\\":\\"0\\",\\"hidden_md\\":\\"0\\",\\"hidden_sm\\":\\"0\\",\\"hidden_xs\\":\\"0\\",\\"acl\\":null}}]}]}]","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(127, 302, 'Follow Us', '', '', 1, 'right', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_sppagebuilder', 1, 1, '{"content":"[{\\"id\\":1497258236246,\\"visibility\\":true,\\"collapse\\":false,\\"settings\\":{\\"admin_label\\":\\"\\",\\"title\\":\\"\\",\\"heading_selector\\":\\"h3\\",\\"title_fontsize\\":\\"\\",\\"title_fontweight\\":\\"\\",\\"title_text_color\\":\\"\\",\\"title_margin_top\\":\\"\\",\\"title_margin_bottom\\":\\"\\",\\"subtitle\\":\\"\\",\\"subtitle_fontsize\\":\\"\\",\\"title_position\\":\\"sppb-text-center\\",\\"columns_equal_height\\":\\"0\\",\\"fullscreen\\":\\"0\\",\\"no_gutter\\":\\"0\\",\\"id\\":\\"\\",\\"class\\":\\"\\",\\"padding\\":\\"0px 0px 0px 0px\\",\\"margin\\":\\"0px 0px 0px 0px\\",\\"color\\":\\"\\",\\"background_color\\":\\"\\",\\"background_image\\":\\"\\",\\"overlay\\":\\"\\",\\"background_repeat\\":\\"no-repeat\\",\\"background_size\\":\\"cover\\",\\"background_attachment\\":\\"fixed\\",\\"background_position\\":\\"0 0\\",\\"background_video\\":\\"0\\",\\"background_video_mp4\\":\\"\\",\\"background_video_ogv\\":\\"\\",\\"hidden_xs\\":\\"\\",\\"hidden_sm\\":\\"\\",\\"hidden_md\\":\\"\\",\\"animation\\":\\"\\",\\"animationduration\\":\\"300\\",\\"animationdelay\\":\\"0\\"},\\"layout\\":\\"12\\",\\"columns\\":[{\\"id\\":1497258236247,\\"class_name\\":\\"col-md-12\\",\\"visibility\\":true,\\"settings\\":{},\\"addons\\":[{\\"id\\":1497866534372,\\"name\\":\\"social_media\\",\\"visibility\\":true,\\"settings\\":{\\"admin_label\\":\\"Follow US\\",\\"class\\":\\"\\",\\"sp_social_media_items\\":[{\\"faicon\\":\\"fa-facebook\\",\\"url\\":\\"https:\\/\\/www.facebook.com\\/joomshaper\\",\\"class\\":\\"facebook\\"},{\\"faicon\\":\\"fa-twitter\\",\\"url\\":\\"https:\\/\\/twitter.com\\/joomshaper\\",\\"class\\":\\"twitter\\"},{\\"faicon\\":\\"fa-google-plus\\",\\"url\\":\\"https:\\/\\/plus.google.com\\/+Joomshapers\\",\\"class\\":\\"googleplus\\"},{\\"faicon\\":\\"fa-linkedin-square\\",\\"url\\":\\"https:\\/\\/www.linkedin.com\\/company\\/joomshaper\\",\\"class\\":\\"linkedin\\"},{\\"faicon\\":\\"fa-pinterest\\",\\"url\\":\\"https:\\/\\/www.pinterest.com\\/joomshaper\\/\\",\\"class\\":\\"pinterest\\"}],\\"global_text_color\\":\\"\\",\\"global_link_color\\":\\"\\",\\"global_link_hover_color\\":\\"\\",\\"global_use_background\\":\\"0\\",\\"global_background_color\\":\\"\\",\\"global_background_image\\":\\"\\",\\"global_background_repeat\\":\\"no-repeat\\",\\"global_background_size\\":\\"cover\\",\\"global_background_attachment\\":\\"inherit\\",\\"global_user_border\\":\\"0\\",\\"global_border_width\\":\\"\\",\\"global_border_color\\":\\"\\",\\"global_boder_style\\":\\"none\\",\\"global_border_radius\\":\\"\\",\\"global_margin\\":\\"\\",\\"global_padding\\":\\"\\",\\"global_use_animation\\":\\"0\\",\\"global_animation\\":\\"\\",\\"global_animationduration\\":\\"300\\",\\"global_animationdelay\\":\\"0\\",\\"hidden_md\\":\\"0\\",\\"hidden_sm\\":\\"0\\",\\"hidden_xs\\":\\"0\\",\\"acl\\":null}}]}]}]","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(128, 304, 'Hero section ad', '', '', 1, 'pagebuilder', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_banners', 1, 0, '{"target":"1","count":5,"cid":"0","catid":["99"],"tag_search":"0","ordering":"0","header_text":"","footer_text":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(130, 308, 'SP Tabbed Articles', '', '', 1, 'menu-module', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_sp_tabbed_articles', 1, 0, '{"catid":"84","limit":"3","columns":"3","ordering":"latest","layout":"_:default","moduleclass_sfx":" menu-article-tabbed","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(131, 309, 'Newsletter', 'For coming soon page', '', 1, 'comingsoon', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_acymailing', 1, 0, '{"effect":"normal","lists":"None","hiddenlists":"All","displaymode":"tableless","listschecked":"All","checkmode":"0","dropdown":"0","overlay":"0","link":"1","listposition":"before","customfields":"email","nametext":"","emailtext":"Email...","fieldsize":"100%","displayfields":"0","introtext":"<p class=\\"icon\\"><span class=\\"newskit newskit-envelope\\"><\\/span><\\/p>\\r\\nGet Notify Me <p>Amazing Deals, Updates & Freebies In Your Inbox<\\/p>","finaltext":"","showsubscribe":"1","subscribetext":"Submit","subscribetextreg":"","showunsubscribe":"0","unsubscribetext":"","redirectmode":"3","redirectlink":"","redirectlinkunsub":"","showterms":"0","showtermspopup":"1","termscontent":"0","mootoolsintro":"","mootoolsbutton":"","boxwidth":"250","boxheight":"200","moduleclass_sfx":"acymailing-module-modal","textalign":"none","loggedin":"1","cache":"0","cache_time":"15","includejs":"header","itemid":"","loadmootools":"1","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(132, 310, 'Contact Us', 'For coming soon page only', '', 1, 'comingsoon', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_sppagebuilder', 1, 0, '{"content":"[{\\"id\\":1497591319646,\\"visibility\\":true,\\"collapse\\":false,\\"settings\\":{\\"admin_label\\":\\"\\",\\"title\\":\\"\\",\\"heading_selector\\":\\"h3\\",\\"title_fontsize\\":\\"\\",\\"title_fontweight\\":\\"\\",\\"title_text_color\\":\\"\\",\\"title_margin_top\\":\\"\\",\\"title_margin_bottom\\":\\"\\",\\"subtitle\\":\\"\\",\\"subtitle_fontsize\\":\\"\\",\\"title_position\\":\\"sppb-text-center\\",\\"columns_equal_height\\":\\"0\\",\\"fullscreen\\":\\"0\\",\\"no_gutter\\":\\"0\\",\\"id\\":\\"\\",\\"class\\":\\"\\",\\"padding\\":\\"0 0 0 0\\",\\"margin\\":\\"0px 0px 0px 0px\\",\\"color\\":\\"\\",\\"background_color\\":\\"\\",\\"background_image\\":\\"\\",\\"overlay\\":\\"\\",\\"background_repeat\\":\\"no-repeat\\",\\"background_size\\":\\"cover\\",\\"background_attachment\\":\\"fixed\\",\\"background_position\\":\\"0 0\\",\\"background_video\\":\\"0\\",\\"background_video_mp4\\":\\"\\",\\"background_video_ogv\\":\\"\\",\\"hidden_xs\\":\\"\\",\\"hidden_sm\\":\\"\\",\\"hidden_md\\":\\"\\",\\"animation\\":\\"\\",\\"animationduration\\":\\"300\\",\\"animationdelay\\":\\"0\\"},\\"layout\\":\\"12\\",\\"columns\\":[{\\"id\\":1497591319647,\\"class_name\\":\\"col-md-12\\",\\"visibility\\":true,\\"settings\\":{},\\"addons\\":[{\\"id\\":1497591319650,\\"name\\":\\"ajax_contact\\",\\"visibility\\":true,\\"settings\\":{\\"admin_label\\":\\"Contact Us\\",\\"title\\":\\"Contact Us\\",\\"heading_selector\\":\\"h3\\",\\"title_fontsize\\":\\"36\\",\\"title_lineheight\\":\\"\\",\\"title_fontstyle\\":null,\\"title_letterspace\\":\\"0\\",\\"title_fontweight\\":\\"600\\",\\"title_text_color\\":\\"rgba(0, 0, 0, 1)\\",\\"title_margin_top\\":\\"\\",\\"title_margin_bottom\\":\\"\\",\\"recipient_email\\":\\"hello@gmail.com\\",\\"from_name\\":\\"\\",\\"from_email\\":\\"\\",\\"formcaptcha\\":\\"0\\",\\"captcha_type\\":\\"default\\",\\"captcha_question\\":\\"3 + 4 = ?\\",\\"captcha_answer\\":\\"7\\",\\"use_custom_button\\":\\"0\\",\\"button_text\\":\\"Send Message\\",\\"button_fontstyle\\":null,\\"button_letterspace\\":\\"0\\",\\"button_type\\":\\"success\\",\\"button_appearance\\":\\"\\",\\"button_background_color\\":\\"#444444\\",\\"button_color\\":\\"#ffffff\\",\\"button_background_color_hover\\":\\"#222222\\",\\"button_color_hover\\":\\"#ffffff\\",\\"button_size\\":\\"\\",\\"button_shape\\":\\"rounded\\",\\"button_block\\":\\"\\",\\"button_icon\\":\\"\\",\\"button_icon_position\\":\\"left\\",\\"class\\":\\"myModal\\",\\"global_text_color\\":\\"\\",\\"global_link_color\\":\\"\\",\\"global_link_hover_color\\":\\"\\",\\"global_use_background\\":\\"0\\",\\"global_background_color\\":\\"\\",\\"global_background_image\\":\\"\\",\\"global_background_repeat\\":\\"no-repeat\\",\\"global_background_size\\":\\"cover\\",\\"global_background_attachment\\":\\"inherit\\",\\"global_user_border\\":\\"0\\",\\"global_border_width\\":\\"\\",\\"global_border_color\\":\\"\\",\\"global_boder_style\\":\\"none\\",\\"global_border_radius\\":\\"\\",\\"global_margin\\":\\"\\",\\"global_padding\\":\\"\\",\\"global_use_animation\\":\\"0\\",\\"global_animation\\":\\"\\",\\"global_animationduration\\":\\"300\\",\\"global_animationdelay\\":\\"0\\",\\"hidden_md\\":\\"0\\",\\"hidden_sm\\":\\"0\\",\\"hidden_xs\\":\\"0\\",\\"acl\\":null}}]}]}]","layout":"_:default","moduleclass_sfx":"contact-us-modal","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(133, 313, 'Home-Variation-2-Ad', '', '', 1, 'pagebuilder', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_banners', 1, 1, '{"target":"1","count":5,"cid":"4","catid":["100"],"tag_search":"0","ordering":"0","header_text":"","footer_text":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(134, 314, 'My Account', '', '', 1, 'myaccount', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 0, '{"menutype":"usermenu","base":"","startLevel":"1","endLevel":"0","showAllChildren":"1","tag_id":"","class_sfx":"","window_open":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(135, 369, 'SP Tweet', '', '', 1, 'pagebuilder', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_sp_tweet', 1, 1, '{"username":"joomshaper","layout_style":"default","tweets":"3","avatar":"1","avatar_width":"48","linked_avatar":"1","linked_search":"1","linked_mention":"1","email_linked":"0","tweet_time":"1","tweet_time_linked":"1","tweet_src":"0","follow_us":"0","target":"_blank","consumer_key":"","consumer_key_secret":"","access_token":"","access_token_secret":"","animation":"none","morph_duration":"300","animation_periodical_time":"8000","moduleclass_sfx":"","cache":"0","module_cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*');

-- --------------------------------------------------------

--
-- Table structure for table `#__modules_menu`
--

DROP TABLE IF EXISTS `#__modules_menu`;
CREATE TABLE `#__modules_menu` (
  `moduleid` int(11) NOT NULL DEFAULT '0',
  `menuid` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__modules_menu`
--

INSERT INTO `#__modules_menu` (`moduleid`, `menuid`) VALUES
(1, 101),
(2, 0),
(3, 0),
(4, 0),
(6, 0),
(7, 0),
(8, 0),
(9, 0),
(10, 0),
(12, 0),
(13, 0),
(14, 0),
(15, 0),
(17, 0),
(20, 0),
(22, 234),
(22, 238),
(22, 242),
(22, 243),
(22, 244),
(22, 296),
(22, 399),
(22, 400),
(25, 294),
(26, -463),
(26, -462),
(26, -433),
(26, -432),
(26, -431),
(26, -430),
(26, -429),
(26, -427),
(26, -400),
(26, -399),
(26, -296),
(26, -244),
(26, -243),
(26, -242),
(26, -238),
(26, -234),
(32, 309),
(35, 0),
(45, 303),
(57, 238),
(57, 427),
(57, 429),
(57, 430),
(57, 431),
(57, 432),
(57, 433),
(57, 462),
(57, 463),
(79, 0),
(86, 0),
(87, 238),
(87, 427),
(87, 429),
(87, 430),
(87, 431),
(87, 432),
(87, 433),
(87, 462),
(87, 463),
(91, 0),
(92, 0),
(96, 0),
(97, 0),
(103, 0),
(105, 0),
(109, 0),
(111, 0),
(112, 0),
(113, 0),
(114, 0),
(115, 0),
(117, 0),
(118, 544),
(118, 545),
(118, 546),
(118, 556),
(118, 559),
(118, 563),
(118, 568),
(118, 569),
(119, 0),
(120, 0),
(121, 0),
(122, 544),
(122, 545),
(122, 546),
(122, 556),
(122, 559),
(122, 563),
(122, 568),
(122, 569),
(123, 544),
(123, 545),
(123, 546),
(123, 556),
(123, 559),
(123, 563),
(123, 568),
(123, 569),
(124, 544),
(124, 545),
(124, 546),
(124, 556),
(124, 559),
(124, 563),
(124, 568),
(124, 569),
(125, 0),
(126, 544),
(126, 545),
(126, 546),
(126, 556),
(126, 559),
(126, 563),
(126, 568),
(126, 569),
(127, 544),
(127, 545),
(127, 546),
(127, 556),
(127, 559),
(127, 563),
(127, 568),
(127, 569),
(128, 0),
(130, 0),
(131, 0),
(132, 0),
(133, 0),
(134, 0),
(135, 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__newsfeeds`
--

DROP TABLE IF EXISTS `#__newsfeeds`;
CREATE TABLE `#__newsfeeds` (
  `catid` int(11) NOT NULL DEFAULT '0',
  `id` int(10) unsigned NOT NULL,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `link` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `numarticles` int(10) unsigned NOT NULL DEFAULT '1',
  `cache_time` int(10) unsigned NOT NULL DEFAULT '3600',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `rtl` tinyint(4) NOT NULL DEFAULT '0',
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `xreference` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `images` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__newsfeeds`
--

INSERT INTO `#__newsfeeds` (`catid`, `id`, `name`, `alias`, `link`, `published`, `numarticles`, `cache_time`, `checked_out`, `checked_out_time`, `ordering`, `rtl`, `access`, `language`, `params`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `metakey`, `metadesc`, `metadata`, `xreference`, `publish_up`, `publish_down`, `description`, `version`, `hits`, `images`) VALUES
(17, 1, 'Joomla! Announcements', 'joomla-announcements', 'http://feeds.joomla.org/JoomlaAnnouncements', 1, 5, 3600, 0, '0000-00-00 00:00:00', 1, 1, 1, 'en-GB', '{"show_feed_image":"","show_feed_description":"","show_item_description":"","feed_character_count":"0","newsfeed_layout":"","feed_display_order":""}', '2017-11-30 08:02:42', 343, 'Joomla', '0000-00-00 00:00:00', 0, '', '', '{"robots":"","rights":""}', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 1, 1, ''),
(17, 2, 'New Joomla! Extensions', 'new-joomla-extensions', 'http://feeds.joomla.org/JoomlaExtensions', 1, 5, 3600, 0, '0000-00-00 00:00:00', 4, 1, 1, 'en-GB', '{"show_feed_image":"","show_feed_description":"","show_item_description":"","feed_character_count":"0","newsfeed_layout":"","feed_display_order":""}', '2017-11-30 08:02:42', 343, 'Joomla', '0000-00-00 00:00:00', 0, '', '', '{"robots":"","rights":""}', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 1, 0, ''),
(17, 3, 'Joomla! Security News', 'joomla-security-news', 'http://feeds.joomla.org/JoomlaSecurityNews', 1, 5, 3600, 0, '0000-00-00 00:00:00', 2, 1, 1, 'en-GB', '{"show_feed_image":"","show_feed_description":"","show_item_description":"","feed_character_count":"0","newsfeed_layout":"","feed_display_order":""}', '2017-11-30 08:02:42', 343, 'Joomla', '0000-00-00 00:00:00', 0, '', '', '{"robots":"","rights":""}', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 1, 0, ''),
(17, 4, 'Joomla! Connect', 'joomla-connect', 'http://feeds.joomla.org/JoomlaConnect', 1, 5, 3600, 0, '0000-00-00 00:00:00', 3, 1, 1, 'en-GB', '{"show_feed_image":"","show_feed_description":"","show_item_description":"","feed_character_count":"0","newsfeed_layout":"","feed_display_order":""}', '2017-11-30 08:02:42', 343, 'Joomla', '0000-00-00 00:00:00', 0, '', '', '{"robots":"","rights":""}', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 1, 2, '');

-- --------------------------------------------------------

--
-- Table structure for table `#__overrider`
--

DROP TABLE IF EXISTS `#__overrider`;
CREATE TABLE `#__overrider` (
  `id` int(10) NOT NULL COMMENT 'Primary Key',
  `constant` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `string` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__postinstall_messages`
--

DROP TABLE IF EXISTS `#__postinstall_messages`;
CREATE TABLE `#__postinstall_messages` (
  `postinstall_message_id` bigint(20) unsigned NOT NULL,
  `extension_id` bigint(20) NOT NULL DEFAULT '700' COMMENT 'FK to #__extensions',
  `title_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Lang key for the title',
  `description_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Lang key for description',
  `action_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `language_extension` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'com_postinstall' COMMENT 'Extension holding lang keys',
  `language_client_id` tinyint(3) NOT NULL DEFAULT '1',
  `type` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'link' COMMENT 'Message type - message, link, action',
  `action_file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT 'RAD URI to the PHP file containing action method',
  `action` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT 'Action method name or URL',
  `condition_file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'RAD URI to file holding display condition method',
  `condition_method` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Display condition method, must return boolean',
  `version_introduced` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '3.2.0' COMMENT 'Version when this message was introduced',
  `enabled` tinyint(3) NOT NULL DEFAULT '1'
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__postinstall_messages`
--

INSERT INTO `#__postinstall_messages` (`postinstall_message_id`, `extension_id`, `title_key`, `description_key`, `action_key`, `language_extension`, `language_client_id`, `type`, `action_file`, `action`, `condition_file`, `condition_method`, `version_introduced`, `enabled`) VALUES
(1, 700, 'PLG_TWOFACTORAUTH_TOTP_POSTINSTALL_TITLE', 'PLG_TWOFACTORAUTH_TOTP_POSTINSTALL_BODY', 'PLG_TWOFACTORAUTH_TOTP_POSTINSTALL_ACTION', 'plg_twofactorauth_totp', 1, 'action', 'site://plugins/twofactorauth/totp/postinstall/actions.php', 'twofactorauth_postinstall_action', 'site://plugins/twofactorauth/totp/postinstall/actions.php', 'twofactorauth_postinstall_condition', '3.2.0', 1),
(2, 700, 'COM_CPANEL_MSG_EACCELERATOR_TITLE', 'COM_CPANEL_MSG_EACCELERATOR_BODY', 'COM_CPANEL_MSG_EACCELERATOR_BUTTON', 'com_cpanel', 1, 'action', 'admin://components/com_admin/postinstall/eaccelerator.php', 'admin_postinstall_eaccelerator_action', 'admin://components/com_admin/postinstall/eaccelerator.php', 'admin_postinstall_eaccelerator_condition', '3.2.0', 1),
(3, 700, 'COM_CPANEL_WELCOME_BEGINNERS_TITLE', 'COM_CPANEL_WELCOME_BEGINNERS_MESSAGE', '', 'com_cpanel', 1, 'message', '', '', '', '', '3.2.0', 1),
(5, 700, 'COM_CPANEL_MSG_HTACCESS_TITLE', 'COM_CPANEL_MSG_HTACCESS_BODY', '', 'com_cpanel', 1, 'message', '', '', 'admin://components/com_admin/postinstall/htaccess.php', 'admin_postinstall_htaccess_condition', '3.4.0', 1),
(6, 700, 'COM_CPANEL_MSG_ROBOTS_TITLE', 'COM_CPANEL_MSG_ROBOTS_BODY', '', 'com_cpanel', 1, 'message', '', '', '', '', '3.3.0', 1),
(7, 700, 'COM_CPANEL_MSG_LANGUAGEACCESS340_TITLE', 'COM_CPANEL_MSG_LANGUAGEACCESS340_BODY', '', 'com_cpanel', 1, 'message', '', '', 'admin://components/com_admin/postinstall/languageaccess340.php', 'admin_postinstall_languageaccess340_condition', '3.4.1', 1),
(8, 700, 'COM_CPANEL_MSG_STATS_COLLECTION_TITLE', 'COM_CPANEL_MSG_STATS_COLLECTION_BODY', '', 'com_cpanel', 1, 'message', '', '', 'admin://components/com_admin/postinstall/statscollection.php', 'admin_postinstall_statscollection_condition', '3.5.0', 1),
(9, 700, 'PLG_SYSTEM_UPDATENOTIFICATION_POSTINSTALL_UPDATECACHETIME', 'PLG_SYSTEM_UPDATENOTIFICATION_POSTINSTALL_UPDATECACHETIME_BODY', 'PLG_SYSTEM_UPDATENOTIFICATION_POSTINSTALL_UPDATECACHETIME_ACTION', 'plg_system_updatenotification', 1, 'action', 'site://plugins/system/updatenotification/postinstall/updatecachetime.php', 'updatecachetime_postinstall_action', 'site://plugins/system/updatenotification/postinstall/updatecachetime.php', 'updatecachetime_postinstall_condition', '3.6.3', 1),
(10, 700, 'COM_CPANEL_MSG_JOOMLA40_PRE_CHECKS_TITLE', 'COM_CPANEL_MSG_JOOMLA40_PRE_CHECKS_BODY', '', 'com_cpanel', 1, 'message', '', '', 'admin://components/com_admin/postinstall/joomla40checks.php', 'admin_postinstall_joomla40checks_condition', '3.7.0', 1),
(11, 700, 'TPL_HATHOR_MESSAGE_POSTINSTALL_TITLE', 'TPL_HATHOR_MESSAGE_POSTINSTALL_BODY', 'TPL_HATHOR_MESSAGE_POSTINSTALL_ACTION', 'tpl_hathor', 1, 'action', 'admin://templates/hathor/postinstall/hathormessage.php', 'hathormessage_postinstall_action', 'admin://templates/hathor/postinstall/hathormessage.php', 'hathormessage_postinstall_condition', '3.7.0', 1);

-- --------------------------------------------------------

--
-- Table structure for table `#__schemas`
--

DROP TABLE IF EXISTS `#__schemas`;
CREATE TABLE `#__schemas` (
  `extension_id` int(11) NOT NULL,
  `version_id` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__schemas`
--

INSERT INTO `#__schemas` (`extension_id`, `version_id`) VALUES
(700, '3.8.2-2017-10-14'),
(10004, '3.0-2017-11-13');

-- --------------------------------------------------------

--
-- Table structure for table `#__spmedia`
--

DROP TABLE IF EXISTS `#__spmedia`;
CREATE TABLE `#__spmedia` (
  `id` bigint(20) unsigned NOT NULL,
  `title` varchar(255) NOT NULL,
  `path` varchar(255) NOT NULL,
  `thumb` varchar(255) NOT NULL,
  `alt` varchar(255) NOT NULL,
  `caption` varchar(2048) NOT NULL,
  `description` mediumtext NOT NULL,
  `type` varchar(100) NOT NULL DEFAULT 'image',
  `extension` varchar(100) NOT NULL,
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` bigint(20) NOT NULL DEFAULT '0',
  `modified_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) NOT NULL DEFAULT '0'
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__spmedia`
--

INSERT INTO `#__spmedia` (`id`, `title`, `path`, `thumb`, `alt`, `caption`, `description`, `type`, `extension`, `created_on`, `created_by`, `modified_on`, `modified_by`) VALUES
(1, 'img01', 'images/2017/06/05/img01.jpg', 'images/2017/06/05/_spmedia_thumbs/img01.jpg', 'img01', '', '', 'image', 'com_sppagebuilder', '2017-06-05 09:33:31', 671, '0000-00-00 00:00:00', 0),
(2, 'img02', 'images/2017/06/05/img02.jpg', 'images/2017/06/05/_spmedia_thumbs/img02.jpg', 'img02', '', '', 'image', 'com_sppagebuilder', '2017-06-05 09:33:49', 671, '0000-00-00 00:00:00', 0),
(3, 'app-store', 'images/2017/06/06/app-store.png', '', 'app-store', '', '', 'image', 'com_sppagebuilder', '2017-06-06 05:29:47', 671, '0000-00-00 00:00:00', 0),
(4, 'google-play', 'images/2017/06/06/google-play.png', '', 'google-play', '', '', 'image', 'com_sppagebuilder', '2017-06-06 05:29:47', 671, '0000-00-00 00:00:00', 0),
(5, 'white-logo', 'images/2017/06/06/white-logo.png', '', 'white-logo', '', '', 'image', 'com_sppagebuilder', '2017-06-06 05:29:47', 671, '0000-00-00 00:00:00', 0),
(6, 'ad-bg', 'images/2017/06/06/ad-bg.jpg', 'images/2017/06/06/_spmedia_thumbs/ad-bg.jpg', 'ad-bg', '', '', 'image', 'com_sppagebuilder', '2017-06-06 05:29:47', 671, '0000-00-00 00:00:00', 0),
(7, 'ad-bg2', 'images/2017/06/06/ad-bg2.jpg', 'images/2017/06/06/_spmedia_thumbs/ad-bg2.jpg', 'ad-bg2', '', '', 'image', 'com_sppagebuilder', '2017-06-06 05:29:47', 671, '0000-00-00 00:00:00', 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__sppagebuilder`
--

DROP TABLE IF EXISTS `#__sppagebuilder`;
CREATE TABLE `#__sppagebuilder` (
  `id` bigint(20) unsigned NOT NULL,
  `asset_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `text` mediumtext NOT NULL,
  `extension` varchar(255) NOT NULL DEFAULT 'com_sppagebuilder',
  `extension_view` varchar(255) NOT NULL DEFAULT 'page',
  `view_id` bigint(20) NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `published` tinyint(3) NOT NULL DEFAULT '1',
  `catid` int(10) NOT NULL,
  `access` int(10) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL,
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` bigint(20) NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) NOT NULL DEFAULT '0',
  `checked_out` int(10) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `og_title` varchar(255) NOT NULL,
  `og_image` varchar(255) NOT NULL,
  `og_description` varchar(255) NOT NULL,
  `language` char(7) NOT NULL,
  `hits` bigint(20) NOT NULL DEFAULT '0',
  `css` longtext NOT NULL
) ENGINE=InnoDB AUTO_INCREMENT=72 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__sppagebuilder`
--

INSERT INTO `#__sppagebuilder` (`id`, `asset_id`, `title`, `text`, `extension`, `extension_view`, `view_id`, `active`, `published`, `catid`, `access`, `ordering`, `created_on`, `created_by`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `og_title`, `og_image`, `og_description`, `language`, `hits`, `css`) VALUES
(1, 368, 'Home', '[{"id":1496655473054,"visibility":true,"collapse":false,"settings":{"admin_label":"Articles Headline","title":"","heading_selector":"h3","title_fontsize":"","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","subtitle":"","subtitle_fontsize":"","title_position":"sppb-text-center","columns_equal_height":"0","fullscreen":"1","no_gutter":"0","id":"","class":"newskit-top-post-slider max-width","padding":"0px 0px 0px 0px","margin":"0px 0px 0px 0px","color":"","background_color":"rgba(255, 255, 255, 1)","background_image":"","overlay":"","background_repeat":"no-repeat","background_size":"cover","background_attachment":"fixed","background_position":"0 0","background_video":"0","background_video_mp4":"","background_video_ogv":"","hidden_xs":"","hidden_sm":"","hidden_md":"","animation":"","animationduration":"300","animationdelay":"0"},"layout":"12","columns":[{"id":1496655473055,"class_name":"col-md-12","visibility":true,"settings":{},"addons":[{"id":1496655473058,"name":"articles_headline","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","catid":"84","ordering":"latest","limit":"","hide_thumbnail":"0","show_category":"1","show_date":"1","show_readmore":"1","readmore_text":"readmore","autoplay":"1","arrows":"0","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]},{"id":1496983464992,"visibility":true,"collapse":false,"settings":{"admin_label":"Hero Section","title":"","heading_selector":"h3","title_fontsize":"","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","subtitle":"","subtitle_fontsize":"","title_position":"sppb-text-center","columns_equal_height":"0","fullscreen":"1","no_gutter":"0","id":"","class":"newskit-hero-section max-width","padding":"30px 0px 0px 0px","margin":"0px 0px 0px 0px","color":"","background_color":"","background_image":"","overlay":"","background_repeat":"no-repeat","background_size":"cover","background_attachment":"fixed","background_position":"0 0","background_video":"0","background_video_mp4":"","background_video_ogv":"","hidden_xs":"","hidden_sm":"","hidden_md":"","animation":"","animationduration":"300","animationdelay":"0"},"layout":"7,5","columns":[{"id":1496983464993,"class_name":"col-md-7","visibility":true,"settings":{"color":"","background":"","background_image":"","overlay":"","background_repeat":"no-repeat","background_size":"cover","background_attachment":"scroll","background_position":"0 0","padding":"","class":"","sm_col":"col-sm-12","xs_col":"","hidden_xs":"","hidden_sm":"","hidden_md":"","animation":"","animationduration":"300","animationdelay":"0"},"addons":[{"id":1496985206641,"name":"articles_slider","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","catid":"84","ordering":"featured","limit":"6","social_share":"1","show_socials":["facebook","gplus","linkedin"],"hide_thumbnail":"0","show_category":"1","show_date":"1","show_readmore":"0","readmore_text":"Continue Reading","autoplay":"1","arrows":"0","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]},{"id":1496983464994,"class_name":"col-md-5","visibility":true,"settings":{"color":"","background":"","background_image":"","overlay":"","background_repeat":"no-repeat","background_size":"cover","background_attachment":"scroll","background_position":"0 0","padding":"","class":"","sm_col":"col-sm-12","xs_col":"","hidden_xs":"","hidden_sm":"","hidden_md":"","animation":"","animationduration":"300","animationdelay":"0"},"addons":[{"id":1497249684271,"type":"inner_row","settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","subtitle":"","subtitle_fontsize":"","title_position":"sppb-text-center","columns_equal_height":"0","fullscreen":"0","no_gutter":"0","id":"","class":"","padding":"0 0px 0 0px","margin":"0px 0px 0px 0px","color":"","background_color":"","background_image":"","overlay":"","background_repeat":"no-repeat","background_size":"cover","background_attachment":"fixed","background_position":"0 0","background_video":"0","background_video_mp4":"","background_video_ogv":"","hidden_xs":"","hidden_sm":"","hidden_md":"","animation":"","animationduration":"300","animationdelay":"0"},"layout":"6,6","visibility":true,"columns":[{"id":1497249684272,"class_name":"col-md-6","visibility":true,"settings":{},"addons":[{"id":1496985206644,"name":"articles","visibility":true,"settings":{"admin_label":"Culture category","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","resource":"article","catid":["89"],"include_subcat":"0","post_type":"","ordering":"latest","limit":"1","layout":"default","columns":"1","social_share":"1","show_socials":["facebook","twitter","gplus"],"show_leading_intro":"1","leading_intro_limit":"200","show_intro_item_intro":"1","intro_intro_limit":"100","leading_item":"","hide_thumbnail":"0","show_author":"0","show_category":"1","show_date":"1","show_readmore":"0","readmore_text":"Read More","link_articles":"0","all_articles_btn_text":"See all posts","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]},{"id":1497249684275,"class_name":"col-md-6","visibility":true,"settings":{},"addons":[{"id":1496985206647,"name":"articles","visibility":true,"settings":{"admin_label":"Video category","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","resource":"article","catid":["96"],"include_subcat":"0","post_type":"","ordering":"latest","limit":"1","layout":"simple","columns":"1","social_share":"0","show_socials":["facebook","twitter","gplus"],"show_leading_intro":"0","leading_intro_limit":"200","show_intro_item_intro":"0","intro_intro_limit":"200","leading_item":"1","hide_thumbnail":"0","show_author":"0","show_category":"1","show_date":"1","show_readmore":"0","readmore_text":"Read More","link_articles":"0","all_articles_btn_text":"See all posts","class":" single-video-post index-single-video-post ","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null,"instFormId":1496985206647}},{"id":1496985206652,"name":"module","visibility":true,"settings":{"admin_label":"Advertisment","title":"","heading_selector":"h3","title_fontsize":"18","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","module_type":"module","id":"128","position":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"30px 0 0 0","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]}]}]},{"id":1496826235107,"visibility":true,"collapse":false,"settings":{"admin_label":"Main Content Wrapper","title":"","heading_selector":"h3","title_fontsize":"","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","subtitle":"","subtitle_fontsize":"","title_position":"sppb-text-center","columns_equal_height":"0","fullscreen":"0","no_gutter":"0","id":"","class":"","padding":"48px 0px 20px 0px","margin":"0px 0px 0px 0px","color":"","background_color":"rgba(239, 239, 239, 1)","background_image":"","overlay":"","background_repeat":"no-repeat","background_size":"cover","background_attachment":"fixed","background_position":"0 0","background_video":"0","background_video_mp4":"","background_video_ogv":"","hidden_xs":"","hidden_sm":"","hidden_md":"","animation":"","animationduration":"300","animationdelay":"0"},"layout":"9,3","columns":[{"id":1496826235108,"class_name":"col-md-9","visibility":true,"settings":{"color":"","background":"","background_image":"","overlay":"","background_repeat":"no-repeat","background_size":"cover","background_attachment":"scroll","background_position":"0 0","padding":"","class":"","sm_col":"col-sm-8","xs_col":"","hidden_xs":"","hidden_sm":"","hidden_md":"","animation":"","animationduration":"300","animationdelay":"0"},"addons":[{"id":1496827463494,"type":"inner_row","settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","subtitle":"","subtitle_fontsize":"","title_position":"sppb-text-center","columns_equal_height":"0","fullscreen":"0","no_gutter":"1","id":"","class":"","padding":"0px 0px 20px 0px","margin":"0px 0px 0px 0px","color":"","background_color":"","background_image":"","overlay":"","background_repeat":"no-repeat","background_size":"cover","background_attachment":"fixed","background_position":"0 0","background_video":"0","background_video_mp4":"","background_video_ogv":"","hidden_xs":"","hidden_sm":"","hidden_md":"","animation":"","animationduration":"300","animationdelay":"0"},"layout":"12","visibility":true,"columns":[{"id":1496827463495,"class_name":"col-md-12","visibility":true,"settings":{},"addons":[{"id":1496827463496,"name":"heading","visibility":true,"settings":{"admin_label":"Around The World","title":"Around The World","heading_selector":"h3","use_link":"1","title_link":"#","link_new_tab":"0","title_fontsize":"18","title_fontstyle":null,"title_fontweight":"","title_lineheight":"","title_letterspace":"0","title_margin":"0px 0px 22px 0px","title_padding":"0px 0px 0px 0px","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496827463497,"name":"articles","visibility":true,"settings":{"admin_label":"Around The World","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","resource":"article","catid":["85"],"include_subcat":"0","post_type":"","ordering":"latest","limit":"7","layout":"creative","columns":"3","social_share":"1","show_socials":["facebook","twitter","gplus"],"show_leading_intro":"1","leading_intro_limit":"200","show_intro_item_intro":"1","intro_intro_limit":"200","leading_item":"4","hide_thumbnail":"0","show_author":"0","show_category":"0","show_date":"1","show_readmore":"0","readmore_text":"","link_articles":"0","all_articles_btn_text":"See all posts","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null,"instFormId":1496827463497}}]}]},{"id":1496900903679,"type":"inner_row","settings":{"admin_label":"Advertisement","title":"","heading_selector":"h3","title_fontsize":"","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","subtitle":"","subtitle_fontsize":"","title_position":"sppb-text-center","columns_equal_height":"0","fullscreen":"0","no_gutter":"0","id":"","class":"","padding":"0px 0px 20px 0px","margin":"0px 0px 0px 0px","color":"","background_color":"","background_image":"","overlay":"","background_repeat":"no-repeat","background_size":"cover","background_attachment":"fixed","background_position":"0 0","background_video":"0","background_video_mp4":"","background_video_ogv":"","hidden_xs":"","hidden_sm":"","hidden_md":"","animation":"","animationduration":"300","animationdelay":"0"},"layout":"12","visibility":true,"columns":[{"id":1496900903680,"class_name":"col-md-12","visibility":true,"settings":{},"addons":[{"id":1496744314440,"name":"module","visibility":true,"settings":{"admin_label":"Ad 1","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","module_type":"module","id":"117","position":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]},{"id":1496827463486,"type":"inner_row","settings":{"admin_label":"Life Style","title":"","heading_selector":"h3","title_fontsize":"","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","subtitle":"","subtitle_fontsize":"","title_position":"sppb-text-center","columns_equal_height":"0","fullscreen":"0","no_gutter":"0","id":"","class":"newskit-life-style","padding":"0px 0px 20px 0px","margin":"0px 0px 0px 0px","color":"","background_color":"","background_image":"","overlay":"","background_repeat":"no-repeat","background_size":"cover","background_attachment":"fixed","background_position":"0 0","background_video":"0","background_video_mp4":"","background_video_ogv":"","hidden_xs":"","hidden_sm":"","hidden_md":"","animation":"","animationduration":"300","animationdelay":"0"},"layout":"12","visibility":true,"columns":[{"id":1496827463487,"class_name":"col-md-12","visibility":true,"settings":{},"addons":[{"id":1496826235111,"name":"heading","visibility":true,"settings":{"admin_label":"Life Style","title":"Life Style","heading_selector":"h3","use_link":"1","title_link":"#","link_new_tab":"0","title_fontsize":"18","title_fontstyle":null,"title_fontweight":"","title_lineheight":"","title_letterspace":"0","title_margin":"0px 0px 30px 0px","title_padding":"0px 0px 0px 0px","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496826505460,"name":"articles","visibility":true,"settings":{"admin_label":"Life Style","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","resource":"article","catid":["91"],"include_subcat":"1","post_type":"","ordering":"latest","limit":"4","layout":"classic","columns":"3","social_share":"1","show_socials":["facebook","twitter","gplus"],"show_leading_intro":"1","leading_intro_limit":"98","show_intro_item_intro":"0","intro_intro_limit":"200","leading_item":"1","hide_thumbnail":"0","show_author":"0","show_category":"0","show_date":"1","show_readmore":"0","readmore_text":"Read More","link_articles":"0","all_articles_btn_text":"See all posts","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]},{"id":1496830178618,"type":"inner_row","settings":{},"layout":"12","visibility":true,"columns":[{"id":1496830178619,"class_name":"col-md-12","visibility":true,"settings":{},"addons":[{"id":1496830178620,"name":"heading","visibility":true,"settings":{"admin_label":"Technology","title":"Technology","heading_selector":"h3","use_link":"1","title_link":"#","link_new_tab":"0","title_fontsize":"18","title_fontstyle":null,"title_fontweight":"","title_lineheight":"","title_letterspace":"0","title_margin":"0px 0px 30px 0px","title_padding":"0px 0px 0px 0px","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496830178621,"name":"articles","visibility":true,"settings":{"admin_label":"Technology","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","resource":"article","catid":["88"],"include_subcat":"1","post_type":"","ordering":"latest","limit":"2","layout":"simple","columns":"3","social_share":"1","show_socials":["facebook","twitter","gplus"],"show_leading_intro":"1","leading_intro_limit":"99","show_intro_item_intro":"0","intro_intro_limit":"200","leading_item":"1","hide_thumbnail":"0","show_author":"0","show_category":"0","show_date":"1","show_readmore":"0","readmore_text":"Read More","link_articles":"0","all_articles_btn_text":"See all posts","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]}]},{"id":1496827463485,"class_name":"col-md-3","visibility":true,"settings":{"color":"","background":"","background_image":"","overlay":"","background_repeat":"no-repeat","background_size":"cover","background_attachment":"scroll","background_position":"0 0","padding":"","class":"newskit-sidebar","sm_col":"col-sm-4","xs_col":"","hidden_xs":"","hidden_sm":"","hidden_md":"","animation":"","animationduration":"300","animationdelay":"0"},"addons":[{"id":1497866534379,"name":"heading","visibility":true,"settings":{"admin_label":"Follow US","title":"Follow US","heading_selector":"h3","use_link":"1","title_link":"#","link_new_tab":"0","title_fontsize":"18","title_fontstyle":null,"title_fontweight":"","title_lineheight":"","title_letterspace":"0","title_margin":"0px 0px 22px 0px","title_padding":"0px 0px 0px 0px","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1497866534372,"name":"social_media","visibility":true,"settings":{"admin_label":"Follow US","class":"","sp_social_media_items":[{"faicon":"fa-facebook","url":"https://www.facebook.com/joomshaper","class":"facebook"},{"faicon":"fa-twitter","url":"https://twitter.com/joomshaper","class":"twitter"},{"faicon":"fa-google-plus","url":"https://plus.google.com/+Joomshapers","class":"googleplus"},{"faicon":"fa-linkedin-square","url":"https://www.linkedin.com/company/joomshaper","class":"linkedin"},{"faicon":"fa-pinterest","url":"https://www.pinterest.com/joomshaper/","class":"pinterest"}],"global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496902215528,"name":"module","visibility":true,"settings":{"admin_label":"Subscribe Our Newsletter ","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","module_type":"module","id":"121","position":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496902215521,"name":"module","visibility":true,"settings":{"admin_label":"Popular Post","title":"Popular Post","heading_selector":"h3","title_fontsize":"18","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","module_type":"module","id":"120","position":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496902215516,"name":"module","visibility":true,"settings":{"admin_label":"Advertisment","title":"","heading_selector":"h3","title_fontsize":"18","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","module_type":"module","id":"119","position":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496902215511,"name":"module","visibility":true,"settings":{"admin_label":"","title":"People''s Poll","heading_selector":"h3","title_fontsize":"18","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","module_type":"module","id":"118","position":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]},{"id":1496823979685,"visibility":true,"collapse":false,"settings":{"admin_label":"Watch Video","title":"","heading_selector":"h3","title_fontsize":"","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","subtitle":"","subtitle_fontsize":"","title_position":"sppb-text-center","columns_equal_height":"0","fullscreen":"0","no_gutter":"0","id":"","class":"newskit-watch-video","padding":"50px 0px 10px 0px","margin":"0px 0px 0px 0px","color":"","background_color":"rgba(255, 255, 255, 1)","background_image":"","overlay":"","background_repeat":"no-repeat","background_size":"cover","background_attachment":"fixed","background_position":"0 0","background_video":"0","background_video_mp4":"","background_video_ogv":"","hidden_xs":"","hidden_sm":"","hidden_md":"","animation":"","animationduration":"300","animationdelay":"0"},"layout":"12","columns":[{"id":1496823979686,"class_name":"col-md-12","visibility":true,"settings":{"color":"","background":"","background_image":"","overlay":"","background_repeat":"no-repeat","background_size":"cover","background_attachment":"scroll","background_position":"0 0","padding":"","class":"","sm_col":"col-sm-8","xs_col":"","hidden_xs":"","hidden_sm":"","hidden_md":"","animation":"","animationduration":"300","animationdelay":"0"},"addons":[{"id":1496825682064,"name":"heading","visibility":true,"settings":{"admin_label":"Watch Video","title":"Watch Video","heading_selector":"h3","use_link":"1","title_link":"#","link_new_tab":"0","title_fontsize":"18","title_fontstyle":null,"title_fontweight":"","title_lineheight":"","title_letterspace":"0","title_margin":"0px 0px 30px 0px","title_padding":"0px 0px 0px 0px","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496824132824,"name":"articles","visibility":true,"settings":{"admin_label":"Video","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","resource":"article","catid":["96"],"include_subcat":"1","post_type":"video","ordering":"latest","limit":"5","layout":"modern","columns":"6","social_share":"1","show_socials":["facebook","twitter","gplus"],"show_leading_intro":"0","leading_intro_limit":"200","show_intro_item_intro":"0","intro_intro_limit":"200","leading_item":"1","hide_thumbnail":"0","show_author":"0","show_category":"0","show_date":"0","show_readmore":"0","readmore_text":"Read More","link_articles":"0","all_articles_btn_text":"See all posts","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]},{"id":1496813502779,"visibility":true,"collapse":false,"settings":{"admin_label":"Sports","title":"","heading_selector":"h3","title_fontsize":"","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","subtitle":"","subtitle_fontsize":"","title_position":"sppb-text-center","columns_equal_height":"0","fullscreen":"0","no_gutter":"0","id":"dsfsdf","class":"","padding":"50px 0px 20px 0px","margin":"0px 0px 0px 0px","color":"","background_color":"rgba(239, 239, 239, 1)","background_image":"","overlay":"","background_repeat":"no-repeat","background_size":"cover","background_attachment":"fixed","background_position":"0 0","background_video":"0","background_video_mp4":"","background_video_ogv":"","hidden_xs":"","hidden_sm":"","hidden_md":"","animation":"","animationduration":"300","animationdelay":"0"},"layout":"12","columns":[{"id":1496813502780,"class_name":"col-md-12","visibility":true,"settings":{"color":"","background":"","background_image":"","overlay":"","background_repeat":"no-repeat","background_size":"cover","background_attachment":"scroll","background_position":"0 0","padding":"","class":"","sm_col":"col-sm-8","xs_col":"","hidden_xs":"","hidden_sm":"","hidden_md":"","animation":"","animationduration":"300","animationdelay":"0"},"addons":[{"id":1496825793918,"name":"heading","visibility":true,"settings":{"admin_label":"Sports","title":"Sports","heading_selector":"h3","use_link":"1","title_link":"#","link_new_tab":"0","title_fontsize":"18","title_fontstyle":null,"title_fontweight":"","title_lineheight":"","title_letterspace":"0","title_margin":"0px 0px 30px 0px","title_padding":"0px 0px 0px 0px","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496823665742,"name":"articles","visibility":true,"settings":{"admin_label":"Sports","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","resource":"article","catid":["86"],"include_subcat":"1","post_type":"standard","ordering":"latest","limit":"4","layout":"default","columns":"4","social_share":"1","show_socials":["facebook","twitter","gplus"],"show_leading_intro":"0","leading_intro_limit":"100","show_intro_item_intro":"0","intro_intro_limit":"200","leading_item":"","hide_thumbnail":"0","show_author":"0","show_category":"0","show_date":"1","show_readmore":"0","readmore_text":"Read More","link_articles":"0","all_articles_btn_text":"See all posts","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]},{"id":1496744314436,"visibility":true,"collapse":false,"settings":{"admin_label":"Advertisement","title":"","heading_selector":"h3","title_fontsize":"","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","subtitle":"","subtitle_fontsize":"","title_position":"sppb-text-center","columns_equal_height":"0","fullscreen":"0","no_gutter":"0","id":"","class":"","padding":"0px 0px 0px 0px","margin":"0px 0px 0px 0px","color":"","background_color":"rgba(239, 239, 239, 1)","background_image":"","overlay":"","background_repeat":"no-repeat","background_size":"cover","background_attachment":"fixed","background_position":"0 0","background_video":"0","background_video_mp4":"","background_video_ogv":"","hidden_xs":"","hidden_sm":"","hidden_md":"","animation":"","animationduration":"300","animationdelay":"0"},"layout":"12","columns":[{"id":1496744314437,"class_name":"col-md-12","visibility":true,"settings":{"color":"","background":"","background_image":"","overlay":"","background_repeat":"no-repeat","background_size":"cover","background_attachment":"scroll","background_position":"0 0","padding":"","class":"","sm_col":"col-sm-8","xs_col":"","hidden_xs":"","hidden_sm":"","hidden_md":"","animation":"","animationduration":"300","animationdelay":"0"},"addons":[{"id":1496900903683,"name":"module","visibility":true,"settings":{"admin_label":"Ad 1","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","module_type":"module","id":"117","position":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]},{"id":1496724695920,"visibility":true,"collapse":false,"settings":{"admin_label":"Newskit App Download","title":"","heading_selector":"h3","title_fontsize":"","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","subtitle":"","subtitle_fontsize":"","title_position":"sppb-text-center","columns_equal_height":"0","fullscreen":"0","no_gutter":"0","id":"","class":"newskit-app-download-section","padding":"20px 0px 0px 0px","margin":"0px 0px 0px 0px","color":"","background_color":"rgba(239, 239, 239, 1)","background_image":"","overlay":"","background_repeat":"no-repeat","background_size":"cover","background_attachment":"fixed","background_position":"0 0","background_video":"0","background_video_mp4":"","background_video_ogv":"","hidden_xs":"","hidden_sm":"","hidden_md":"","animation":"","animationduration":"300","animationdelay":"0"},"layout":"7,5","columns":[{"id":1496724695921,"class_name":"col-md-7","visibility":true,"settings":{"color":"rgba(255, 255, 255, 1)","background":"","background_image":"images/2017/06/06/ad-bg.jpg","overlay":"","background_repeat":"no-repeat","background_size":"cover","background_attachment":"inherit","background_position":"50% 50%","padding":"30px 30px 34px 30px","class":"responsive-margin-fix","sm_col":"col-sm-6","xs_col":"","hidden_xs":"","hidden_sm":"","hidden_md":"","animation":"","animationduration":"300","animationdelay":"0"},"addons":[{"id":1496724695925,"name":"image","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","image":"images/2017/06/06/white-logo.png","alt_text":"logo","position":"sppb-text-left","open_lightbox":"0","overlay_color":"rgba(119, 219, 31, 0.5)","link":"","target":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496724695928,"name":"heading","visibility":true,"settings":{"admin_label":"Download Newskit App","title":"Download Newskit App","heading_selector":"h2","use_link":"0","title_link":"","link_new_tab":"0","title_fontsize":"22","title_fontstyle":null,"title_fontweight":"700","title_lineheight":"","title_letterspace":"0","title_margin":"15px 0px 10px 0px","title_padding":"0px 0px 0px 0px","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496724695931,"name":"text_block","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"<p style=\\"font-size: 12px; line-height: 1.5;\\">Lorem Ipsum is simply dummy text of the printing and<br /> typesetting industry.</p>","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"0 0 25px 0","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496988583427,"name":"clients","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","count":"sppb-col-sm-6","alignment":"sppb-text-left","class":"","sp_clients_item":[{"title":"","image":"images/2017/06/06/app-store.png","url":"#"},{"title":"","image":"images/2017/06/06/google-play.png","url":"#"}],"global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]},{"id":1496724695922,"class_name":"col-md-5","visibility":true,"settings":{"color":"","background":"","background_image":"","overlay":"","background_repeat":"no-repeat","background_size":"cover","background_attachment":"scroll","background_position":"0 0","padding":"","class":"","sm_col":"col-sm-6","xs_col":"","hidden_xs":"","hidden_sm":"","hidden_md":"","animation":"","animationduration":"300","animationdelay":"0"},"addons":[{"id":1496724695955,"name":"image","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","image":"images/2017/06/06/ad-bg2.jpg","alt_text":"banner","position":"sppb-text-center","open_lightbox":"0","overlay_color":"rgba(119, 219, 31, 0.5)","link":"","target":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]},{"id":1496728060151,"visibility":true,"collapse":false,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","subtitle":"","subtitle_fontsize":"","title_position":"sppb-text-center","columns_equal_height":"0","fullscreen":"0","no_gutter":"0","id":"","class":"","padding":"50px 0px 75px 0px","margin":"0px 0px 0px 0px","color":"","background_color":"rgba(239, 239, 239, 1)","background_image":"","overlay":"","background_repeat":"no-repeat","background_size":"cover","background_attachment":"fixed","background_position":"0 0","background_video":"0","background_video_mp4":"","background_video_ogv":"","hidden_xs":"","hidden_sm":"","hidden_md":"","animation":"","animationduration":"300","animationdelay":"0"},"layout":"7,5","columns":[{"id":1496728060152,"class_name":"col-md-7","visibility":true,"settings":{"color":"","background":"","background_image":"","overlay":"","background_repeat":"no-repeat","background_size":"cover","background_attachment":"scroll","background_position":"0 0","padding":"","class":"","sm_col":"col-sm-6","xs_col":"","hidden_xs":"","hidden_sm":"","hidden_md":"","animation":"","animationduration":"300","animationdelay":"0"},"addons":[{"id":1496728060162,"name":"heading","visibility":true,"settings":{"admin_label":"Image Gallery","title":"Image Gallery","heading_selector":"h3","use_link":"0","title_link":"","link_new_tab":"0","title_fontsize":"18","title_fontstyle":null,"title_fontweight":"","title_lineheight":"","title_letterspace":"0","title_margin":"0px 0px 30px 0px","title_padding":"0px 0px 0px 0px","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"1","global_background_color":"rgba(255, 255, 255, 1)","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"20px 25px 0px 25px","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496740169734,"name":"thumb_gallery","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_text_color":"","category":"84","order_by":"latest","item_limit":"8","autoplay":"1","arrows":"1","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]},{"id":1496728060153,"class_name":"col-md-5","visibility":true,"settings":{"color":"","background":"","background_image":"","overlay":"","background_repeat":"no-repeat","background_size":"cover","background_attachment":"scroll","background_position":"0 0","padding":"","class":"newskit-twitter","sm_col":"col-sm-6","xs_col":"","hidden_xs":"","hidden_sm":"","hidden_md":"","animation":"","animationduration":"300","animationdelay":"0"},"addons":[{"id":1496728499576,"name":"heading","visibility":true,"settings":{"admin_label":"Twitter Feed","title":"Twitter Feed","heading_selector":"h3","use_link":0,"title_link":"","link_new_tab":"0","title_fontsize":"18","title_fontstyle":null,"title_fontweight":"","title_lineheight":"","title_letterspace":"0","title_margin":{"md":"0px 0px 30px 0px","sm":"   ","xs":"   "},"title_padding":{"md":"0px 0px 0px 0px","sm":"   ","xs":"   "},"alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null,"instFormId":1496728499576}},{"id":1512103754676,"name":"module","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_letterspace":"0","module_type":"module","class":"","global_margin":{"md":"   ","sm":"  20px ","xs":"  10px "},"global_padding":{"md":"   ","sm":"   ","xs":"   "},"use_global_width":0,"hidden_md":0,"hidden_sm":0,"hidden_xs":0,"id":"135","instFormId":1512103754676,"global_use_background":0,"global_user_border":0,"global_use_animation":0}}]}]}]', 'com_sppagebuilder', 'page', 0, 0, 1, 0, 1, 0, '2015-01-22 07:12:35', 343, '2017-12-01 09:05:35', 343, 0, '0000-00-00 00:00:00', '', '', '', '*', 6116, 'body{\r\nbackground: #E1E1E1;\r\n}');
INSERT INTO `#__sppagebuilder` (`id`, `asset_id`, `title`, `text`, `extension`, `extension_view`, `view_id`, `active`, `published`, `catid`, `access`, `ordering`, `created_on`, `created_by`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `og_title`, `og_image`, `og_description`, `language`, `hits`, `css`) VALUES
(2, 0, 'Nullam eros mi, mollis in sollicitudin non, tincidunt.', '[{"id":1496654701110,"visibility":true,"collapse":false,"settings":{"padding":"50px 0px 50px 0px","margin":"0px 0px 0px 0px"},"layout":"12","columns":[{"id":1496654701111,"class_name":"col-md-12","visibility":true,"settings":{},"addons":[{"id":1496654701114,"name":"text_block","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of \\"de Finibus Bonorum et Malorum\\" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, \\"Lorem ipsum dolor sit amet..\\", comes from a line in section 1.10.32.</p>\\n<br />\\n<p>The standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from \\"de Finibus Bonorum et Malorum\\" by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.</p>","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496654701117,"name":"module","visibility":true,"settings":{"admin_label":"Advertisement","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","module_type":"module","id":"115","position":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"35px 0 0 0","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]},{"id":1496654701118,"visibility":true,"collapse":false,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","subtitle":"","subtitle_fontsize":"","title_position":"sppb-text-center","columns_equal_height":"0","fullscreen":"0","no_gutter":"0","id":"","class":"","padding":"5px 0px 0 0px","margin":"0px 0px 0px 0px","color":"","background_color":"","background_image":"","overlay":"","background_repeat":"no-repeat","background_size":"cover","background_attachment":"fixed","background_position":"0 0","background_video":"0","background_video_mp4":"","background_video_ogv":"","hidden_xs":"","hidden_sm":"","hidden_md":"","animation":"","animationduration":"300","animationdelay":"0"},"layout":"6,6","columns":[{"id":1496654701119,"class_name":"col-md-6","visibility":true,"settings":{},"addons":[{"id":1496654701123,"name":"image","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","image":"images/2017/06/05/img01.jpg","alt_text":"image","position":"sppb-text-center","open_lightbox":"0","overlay_color":"rgba(119, 219, 31, 0.5)","link":"","target":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]},{"id":1496654701120,"class_name":"col-md-6","visibility":true,"settings":{},"addons":[{"id":1496654701126,"name":"image","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","image":"images/2017/06/05/img02.jpg","alt_text":"image","position":"sppb-text-center","open_lightbox":"0","overlay_color":"rgba(119, 219, 31, 0.5)","link":"","target":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]},{"id":1496654701129,"visibility":true,"collapse":false,"settings":{"padding":"50px 0px 50px 0px","margin":"0px 0px 0px 0px"},"layout":"12","columns":[{"id":1496654701130,"class_name":"col-md-12","visibility":true,"settings":{},"addons":[{"id":1496654701133,"name":"text_block","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of \\"de Finibus Bonorum et Malorum\\" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, \\"Lorem ipsum dolor sit amet..\\", comes from a line in section 1.10.32.</p>\\n<br />\\n<p>The standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from \\"de Finibus Bonorum et Malorum\\" by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.</p>","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496654701136,"name":"blockquote","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"I believe that a simple and unassuming manner of life is best for everyone, best both for the body and the mind.","footer":"Albert Einstein","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496654701139,"name":"text_block","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem.</p>","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]}]', 'com_content', 'article', 78, 1, 1, 0, 0, 0, '2017-06-05 09:37:36', 671, '2017-06-22 09:46:57', 671, 0, '0000-00-00 00:00:00', '', '', '', '*', 0, ''),
(3, 0, 'Tongue kielbasa ribeye meatball pork loin andouille', '[{"id":1496654701110,"visibility":true,"collapse":false,"settings":{"padding":"50px 0px 50px 0px","margin":"0px 0px 0px 0px"},"layout":"12","columns":[{"id":1496654701111,"class_name":"col-md-12","visibility":true,"settings":{},"addons":[{"id":1496654701114,"name":"text_block","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of \\"de Finibus Bonorum et Malorum\\" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, \\"Lorem ipsum dolor sit amet..\\", comes from a line in section 1.10.32.</p>\\n<br />\\n<p>The standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from \\"de Finibus Bonorum et Malorum\\" by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.</p>","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496654701117,"name":"module","visibility":true,"settings":{"admin_label":"Advertisement","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","module_type":"module","id":"115","position":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"35px 0 0 0","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]},{"id":1496654701118,"visibility":true,"collapse":false,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","subtitle":"","subtitle_fontsize":"","title_position":"sppb-text-center","columns_equal_height":"0","fullscreen":"0","no_gutter":"0","id":"","class":"","padding":"5px 0px 0 0px","margin":"0px 0px 0px 0px","color":"","background_color":"","background_image":"","overlay":"","background_repeat":"no-repeat","background_size":"cover","background_attachment":"fixed","background_position":"0 0","background_video":"0","background_video_mp4":"","background_video_ogv":"","hidden_xs":"","hidden_sm":"","hidden_md":"","animation":"","animationduration":"300","animationdelay":"0"},"layout":"6,6","columns":[{"id":1496654701119,"class_name":"col-md-6","visibility":true,"settings":{},"addons":[{"id":1496654701123,"name":"image","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","image":"images/2017/06/05/img01.jpg","alt_text":"image","position":"sppb-text-center","open_lightbox":"0","overlay_color":"rgba(119, 219, 31, 0.5)","link":"","target":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]},{"id":1496654701120,"class_name":"col-md-6","visibility":true,"settings":{},"addons":[{"id":1496654701126,"name":"image","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","image":"images/2017/06/05/img02.jpg","alt_text":"image","position":"sppb-text-center","open_lightbox":"0","overlay_color":"rgba(119, 219, 31, 0.5)","link":"","target":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]},{"id":1496654701129,"visibility":true,"collapse":false,"settings":{"padding":"50px 0px 50px 0px","margin":"0px 0px 0px 0px"},"layout":"12","columns":[{"id":1496654701130,"class_name":"col-md-12","visibility":true,"settings":{},"addons":[{"id":1496654701133,"name":"text_block","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of \\"de Finibus Bonorum et Malorum\\" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, \\"Lorem ipsum dolor sit amet..\\", comes from a line in section 1.10.32.</p>\\n<br />\\n<p>The standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from \\"de Finibus Bonorum et Malorum\\" by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.</p>","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496654701136,"name":"blockquote","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"I believe that a simple and unassuming manner of life is best for everyone, best both for the body and the mind.","footer":"Albert Einstein","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496654701139,"name":"text_block","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem.</p>","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]}]', 'com_content', 'article', 79, 1, 1, 0, 0, 0, '2017-06-05 09:37:36', 671, '2017-06-23 06:30:29', 671, 0, '0000-00-00 00:00:00', '', '', '', '*', 0, ''),
(4, 0, 'Facebooks Guidance For Moderators Makes More ', '[{"id":1496654701110,"visibility":true,"collapse":false,"settings":{"padding":"50px 0px 50px 0px","margin":"0px 0px 0px 0px"},"layout":"12","columns":[{"id":1496654701111,"class_name":"col-md-12","visibility":true,"settings":{},"addons":[{"id":1496654701114,"name":"text_block","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of \\"de Finibus Bonorum et Malorum\\" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, \\"Lorem ipsum dolor sit amet..\\", comes from a line in section 1.10.32.</p>\\n<br />\\n<p>The standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from \\"de Finibus Bonorum et Malorum\\" by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.</p>","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496654701117,"name":"module","visibility":true,"settings":{"admin_label":"Advertisement","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","module_type":"module","id":"115","position":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"35px 0 0 0","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]},{"id":1496654701118,"visibility":true,"collapse":false,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","subtitle":"","subtitle_fontsize":"","title_position":"sppb-text-center","columns_equal_height":"0","fullscreen":"0","no_gutter":"0","id":"","class":"","padding":"5px 0px 0 0px","margin":"0px 0px 0px 0px","color":"","background_color":"","background_image":"","overlay":"","background_repeat":"no-repeat","background_size":"cover","background_attachment":"fixed","background_position":"0 0","background_video":"0","background_video_mp4":"","background_video_ogv":"","hidden_xs":"","hidden_sm":"","hidden_md":"","animation":"","animationduration":"300","animationdelay":"0"},"layout":"6,6","columns":[{"id":1496654701119,"class_name":"col-md-6","visibility":true,"settings":{},"addons":[{"id":1496654701123,"name":"image","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","image":"images/2017/06/05/img01.jpg","alt_text":"image","position":"sppb-text-center","open_lightbox":"0","overlay_color":"rgba(119, 219, 31, 0.5)","link":"","target":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]},{"id":1496654701120,"class_name":"col-md-6","visibility":true,"settings":{},"addons":[{"id":1496654701126,"name":"image","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","image":"images/2017/06/05/img02.jpg","alt_text":"image","position":"sppb-text-center","open_lightbox":"0","overlay_color":"rgba(119, 219, 31, 0.5)","link":"","target":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]},{"id":1496654701129,"visibility":true,"collapse":false,"settings":{"padding":"50px 0px 50px 0px","margin":"0px 0px 0px 0px"},"layout":"12","columns":[{"id":1496654701130,"class_name":"col-md-12","visibility":true,"settings":{},"addons":[{"id":1496654701133,"name":"text_block","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of \\"de Finibus Bonorum et Malorum\\" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, \\"Lorem ipsum dolor sit amet..\\", comes from a line in section 1.10.32.</p>\\n<br />\\n<p>The standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from \\"de Finibus Bonorum et Malorum\\" by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.</p>","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496654701136,"name":"blockquote","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"I believe that a simple and unassuming manner of life is best for everyone, best both for the body and the mind.","footer":"Albert Einstein","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496654701139,"name":"text_block","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem.</p>","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]}]', 'com_content', 'article', 80, 1, 1, 0, 0, 0, '2017-06-05 09:37:36', 671, '2017-06-23 08:18:57', 671, 0, '0000-00-00 00:00:00', '', '', '', '*', 0, '');
INSERT INTO `#__sppagebuilder` (`id`, `asset_id`, `title`, `text`, `extension`, `extension_view`, `view_id`, `active`, `published`, `catid`, `access`, `ordering`, `created_on`, `created_by`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `og_title`, `og_image`, `og_description`, `language`, `hits`, `css`) VALUES
(5, 0, 'Short ribs strip steak meatloaf, pig ribeye cow turkey', '[{"id":1496654701110,"visibility":true,"collapse":false,"settings":{"padding":"50px 0px 50px 0px","margin":"0px 0px 0px 0px"},"layout":"12","columns":[{"id":1496654701111,"class_name":"col-md-12","visibility":true,"settings":{},"addons":[{"id":1496654701114,"name":"text_block","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of \\"de Finibus Bonorum et Malorum\\" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, \\"Lorem ipsum dolor sit amet..\\", comes from a line in section 1.10.32.</p>\\n<br />\\n<p>The standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from \\"de Finibus Bonorum et Malorum\\" by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.</p>","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496654701117,"name":"module","visibility":true,"settings":{"admin_label":"Advertisement","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","module_type":"module","id":"115","position":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"35px 0 0 0","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]},{"id":1496654701118,"visibility":true,"collapse":false,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","subtitle":"","subtitle_fontsize":"","title_position":"sppb-text-center","columns_equal_height":"0","fullscreen":"0","no_gutter":"0","id":"","class":"","padding":"5px 0px 0 0px","margin":"0px 0px 0px 0px","color":"","background_color":"","background_image":"","overlay":"","background_repeat":"no-repeat","background_size":"cover","background_attachment":"fixed","background_position":"0 0","background_video":"0","background_video_mp4":"","background_video_ogv":"","hidden_xs":"","hidden_sm":"","hidden_md":"","animation":"","animationduration":"300","animationdelay":"0"},"layout":"6,6","columns":[{"id":1496654701119,"class_name":"col-md-6","visibility":true,"settings":{},"addons":[{"id":1496654701123,"name":"image","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","image":"images/2017/06/05/img01.jpg","alt_text":"image","position":"sppb-text-center","open_lightbox":"0","overlay_color":"rgba(119, 219, 31, 0.5)","link":"","target":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]},{"id":1496654701120,"class_name":"col-md-6","visibility":true,"settings":{},"addons":[{"id":1496654701126,"name":"image","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","image":"images/2017/06/05/img02.jpg","alt_text":"image","position":"sppb-text-center","open_lightbox":"0","overlay_color":"rgba(119, 219, 31, 0.5)","link":"","target":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]},{"id":1496654701129,"visibility":true,"collapse":false,"settings":{"padding":"50px 0px 50px 0px","margin":"0px 0px 0px 0px"},"layout":"12","columns":[{"id":1496654701130,"class_name":"col-md-12","visibility":true,"settings":{},"addons":[{"id":1496654701133,"name":"text_block","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of \\"de Finibus Bonorum et Malorum\\" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, \\"Lorem ipsum dolor sit amet..\\", comes from a line in section 1.10.32.</p>\\n<br />\\n<p>The standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from \\"de Finibus Bonorum et Malorum\\" by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.</p>","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496654701136,"name":"blockquote","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"I believe that a simple and unassuming manner of life is best for everyone, best both for the body and the mind.","footer":"Albert Einstein","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496654701139,"name":"text_block","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem.</p>","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]}]', 'com_content', 'article', 81, 1, 1, 0, 0, 0, '2017-06-05 09:37:36', 671, '2017-06-09 05:04:14', 671, 0, '0000-00-00 00:00:00', '', '', '', '*', 0, ''),
(6, 0, 'Not Recognize Shaq As Their Lyft are in Driver?', '[{"id":1496654701110,"visibility":true,"collapse":false,"settings":{"padding":"50px 0px 50px 0px","margin":"0px 0px 0px 0px"},"layout":"12","columns":[{"id":1496654701111,"class_name":"col-md-12","visibility":true,"settings":{},"addons":[{"id":1496654701114,"name":"text_block","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of \\"de Finibus Bonorum et Malorum\\" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, \\"Lorem ipsum dolor sit amet..\\", comes from a line in section 1.10.32.</p>\\n<br />\\n<p>The standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from \\"de Finibus Bonorum et Malorum\\" by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.</p>","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496654701117,"name":"module","visibility":true,"settings":{"admin_label":"Advertisement","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","module_type":"module","id":"115","position":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"35px 0 0 0","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]},{"id":1496654701118,"visibility":true,"collapse":false,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","subtitle":"","subtitle_fontsize":"","title_position":"sppb-text-center","columns_equal_height":"0","fullscreen":"0","no_gutter":"0","id":"","class":"","padding":"5px 0px 0 0px","margin":"0px 0px 0px 0px","color":"","background_color":"","background_image":"","overlay":"","background_repeat":"no-repeat","background_size":"cover","background_attachment":"fixed","background_position":"0 0","background_video":"0","background_video_mp4":"","background_video_ogv":"","hidden_xs":"","hidden_sm":"","hidden_md":"","animation":"","animationduration":"300","animationdelay":"0"},"layout":"6,6","columns":[{"id":1496654701119,"class_name":"col-md-6","visibility":true,"settings":{},"addons":[{"id":1496654701123,"name":"image","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","image":"images/2017/06/05/img01.jpg","alt_text":"image","position":"sppb-text-center","open_lightbox":"0","overlay_color":"rgba(119, 219, 31, 0.5)","link":"","target":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]},{"id":1496654701120,"class_name":"col-md-6","visibility":true,"settings":{},"addons":[{"id":1496654701126,"name":"image","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","image":"images/2017/06/05/img02.jpg","alt_text":"image","position":"sppb-text-center","open_lightbox":"0","overlay_color":"rgba(119, 219, 31, 0.5)","link":"","target":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]},{"id":1496654701129,"visibility":true,"collapse":false,"settings":{"padding":"50px 0px 50px 0px","margin":"0px 0px 0px 0px"},"layout":"12","columns":[{"id":1496654701130,"class_name":"col-md-12","visibility":true,"settings":{},"addons":[{"id":1496654701133,"name":"text_block","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of \\"de Finibus Bonorum et Malorum\\" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, \\"Lorem ipsum dolor sit amet..\\", comes from a line in section 1.10.32.</p>\\n<br />\\n<p>The standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from \\"de Finibus Bonorum et Malorum\\" by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.</p>","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496654701136,"name":"blockquote","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"I believe that a simple and unassuming manner of life is best for everyone, best both for the body and the mind.","footer":"Albert Einstein","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496654701139,"name":"text_block","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem.</p>","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]}]', 'com_content', 'article', 82, 1, 1, 0, 0, 0, '2017-06-05 09:37:36', 671, '2017-06-23 07:11:53', 671, 0, '0000-00-00 00:00:00', '', '', '', '*', 0, ''),
(7, 0, 'Pork loin ball tip bresaola, hamburger swine shoulder', '[{"id":1496654701110,"visibility":true,"collapse":false,"settings":{"padding":"50px 0px 50px 0px","margin":"0px 0px 0px 0px"},"layout":"12","columns":[{"id":1496654701111,"class_name":"col-md-12","visibility":true,"settings":{},"addons":[{"id":1496654701114,"name":"text_block","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of \\"de Finibus Bonorum et Malorum\\" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, \\"Lorem ipsum dolor sit amet..\\", comes from a line in section 1.10.32.</p>\\n<br />\\n<p>The standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from \\"de Finibus Bonorum et Malorum\\" by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.</p>","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496654701117,"name":"module","visibility":true,"settings":{"admin_label":"Advertisement","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","module_type":"module","id":"115","position":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"35px 0 0 0","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]},{"id":1496654701118,"visibility":true,"collapse":false,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","subtitle":"","subtitle_fontsize":"","title_position":"sppb-text-center","columns_equal_height":"0","fullscreen":"0","no_gutter":"0","id":"","class":"","padding":"5px 0px 0 0px","margin":"0px 0px 0px 0px","color":"","background_color":"","background_image":"","overlay":"","background_repeat":"no-repeat","background_size":"cover","background_attachment":"fixed","background_position":"0 0","background_video":"0","background_video_mp4":"","background_video_ogv":"","hidden_xs":"","hidden_sm":"","hidden_md":"","animation":"","animationduration":"300","animationdelay":"0"},"layout":"6,6","columns":[{"id":1496654701119,"class_name":"col-md-6","visibility":true,"settings":{},"addons":[{"id":1496654701123,"name":"image","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","image":"images/2017/06/05/img01.jpg","alt_text":"image","position":"sppb-text-center","open_lightbox":"0","overlay_color":"rgba(119, 219, 31, 0.5)","link":"","target":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]},{"id":1496654701120,"class_name":"col-md-6","visibility":true,"settings":{},"addons":[{"id":1496654701126,"name":"image","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","image":"images/2017/06/05/img02.jpg","alt_text":"image","position":"sppb-text-center","open_lightbox":"0","overlay_color":"rgba(119, 219, 31, 0.5)","link":"","target":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]},{"id":1496654701129,"visibility":true,"collapse":false,"settings":{"padding":"50px 0px 50px 0px","margin":"0px 0px 0px 0px"},"layout":"12","columns":[{"id":1496654701130,"class_name":"col-md-12","visibility":true,"settings":{},"addons":[{"id":1496654701133,"name":"text_block","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of \\"de Finibus Bonorum et Malorum\\" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, \\"Lorem ipsum dolor sit amet..\\", comes from a line in section 1.10.32.</p>\\n<br />\\n<p>The standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from \\"de Finibus Bonorum et Malorum\\" by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.</p>","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496654701136,"name":"blockquote","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"I believe that a simple and unassuming manner of life is best for everyone, best both for the body and the mind.","footer":"Albert Einstein","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496654701139,"name":"text_block","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem.</p>","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]}]', 'com_content', 'article', 83, 1, 1, 0, 0, 0, '2017-06-05 09:37:36', 671, '2017-06-23 06:30:54', 671, 0, '0000-00-00 00:00:00', '', '', '', '*', 0, '');
INSERT INTO `#__sppagebuilder` (`id`, `asset_id`, `title`, `text`, `extension`, `extension_view`, `view_id`, `active`, `published`, `catid`, `access`, `ordering`, `created_on`, `created_by`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `og_title`, `og_image`, `og_description`, `language`, `hits`, `css`) VALUES
(8, 0, 'Fatback sausage pork loin bresaola tail sirloin Bresaola.', '[{"id":1496654701110,"visibility":true,"collapse":false,"settings":{"padding":"50px 0px 50px 0px","margin":"0px 0px 0px 0px"},"layout":"12","columns":[{"id":1496654701111,"class_name":"col-md-12","visibility":true,"settings":{},"addons":[{"id":1496654701114,"name":"text_block","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of \\"de Finibus Bonorum et Malorum\\" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, \\"Lorem ipsum dolor sit amet..\\", comes from a line in section 1.10.32.</p>\\n<br />\\n<p>The standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from \\"de Finibus Bonorum et Malorum\\" by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.</p>","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496654701117,"name":"module","visibility":true,"settings":{"admin_label":"Advertisement","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","module_type":"module","id":"115","position":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"35px 0 0 0","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]},{"id":1496654701118,"visibility":true,"collapse":false,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","subtitle":"","subtitle_fontsize":"","title_position":"sppb-text-center","columns_equal_height":"0","fullscreen":"0","no_gutter":"0","id":"","class":"","padding":"5px 0px 0 0px","margin":"0px 0px 0px 0px","color":"","background_color":"","background_image":"","overlay":"","background_repeat":"no-repeat","background_size":"cover","background_attachment":"fixed","background_position":"0 0","background_video":"0","background_video_mp4":"","background_video_ogv":"","hidden_xs":"","hidden_sm":"","hidden_md":"","animation":"","animationduration":"300","animationdelay":"0"},"layout":"6,6","columns":[{"id":1496654701119,"class_name":"col-md-6","visibility":true,"settings":{},"addons":[{"id":1496654701123,"name":"image","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","image":"images/2017/06/05/img01.jpg","alt_text":"image","position":"sppb-text-center","open_lightbox":"0","overlay_color":"rgba(119, 219, 31, 0.5)","link":"","target":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]},{"id":1496654701120,"class_name":"col-md-6","visibility":true,"settings":{},"addons":[{"id":1496654701126,"name":"image","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","image":"images/2017/06/05/img02.jpg","alt_text":"image","position":"sppb-text-center","open_lightbox":"0","overlay_color":"rgba(119, 219, 31, 0.5)","link":"","target":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]},{"id":1496654701129,"visibility":true,"collapse":false,"settings":{"padding":"50px 0px 50px 0px","margin":"0px 0px 0px 0px"},"layout":"12","columns":[{"id":1496654701130,"class_name":"col-md-12","visibility":true,"settings":{},"addons":[{"id":1496654701133,"name":"text_block","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of \\"de Finibus Bonorum et Malorum\\" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, \\"Lorem ipsum dolor sit amet..\\", comes from a line in section 1.10.32.</p>\\n<br />\\n<p>The standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from \\"de Finibus Bonorum et Malorum\\" by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.</p>","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496654701136,"name":"blockquote","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"I believe that a simple and unassuming manner of life is best for everyone, best both for the body and the mind.","footer":"Albert Einstein","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496654701139,"name":"text_block","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem.</p>","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]}]', 'com_content', 'article', 84, 1, 1, 0, 0, 0, '2017-06-05 09:37:36', 671, '2017-06-22 10:03:09', 671, 0, '0000-00-00 00:00:00', '', '', '', '*', 0, ''),
(9, 0, 'Pork belly corned beef bacon turkey doner chuck bresaola.', '[{"id":1496654701110,"visibility":true,"collapse":false,"settings":{"padding":"50px 0px 50px 0px","margin":"0px 0px 0px 0px"},"layout":"12","columns":[{"id":1496654701111,"class_name":"col-md-12","visibility":true,"settings":{},"addons":[{"id":1496654701114,"name":"text_block","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of \\"de Finibus Bonorum et Malorum\\" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, \\"Lorem ipsum dolor sit amet..\\", comes from a line in section 1.10.32.</p>\\n<br />\\n<p>The standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from \\"de Finibus Bonorum et Malorum\\" by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.</p>","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496654701117,"name":"module","visibility":true,"settings":{"admin_label":"Advertisement","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","module_type":"module","id":"115","position":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"35px 0 0 0","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]},{"id":1496654701118,"visibility":true,"collapse":false,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","subtitle":"","subtitle_fontsize":"","title_position":"sppb-text-center","columns_equal_height":"0","fullscreen":"0","no_gutter":"0","id":"","class":"","padding":"5px 0px 0 0px","margin":"0px 0px 0px 0px","color":"","background_color":"","background_image":"","overlay":"","background_repeat":"no-repeat","background_size":"cover","background_attachment":"fixed","background_position":"0 0","background_video":"0","background_video_mp4":"","background_video_ogv":"","hidden_xs":"","hidden_sm":"","hidden_md":"","animation":"","animationduration":"300","animationdelay":"0"},"layout":"6,6","columns":[{"id":1496654701119,"class_name":"col-md-6","visibility":true,"settings":{},"addons":[{"id":1496654701123,"name":"image","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","image":"images/2017/06/05/img01.jpg","alt_text":"image","position":"sppb-text-center","open_lightbox":"0","overlay_color":"rgba(119, 219, 31, 0.5)","link":"","target":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]},{"id":1496654701120,"class_name":"col-md-6","visibility":true,"settings":{},"addons":[{"id":1496654701126,"name":"image","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","image":"images/2017/06/05/img02.jpg","alt_text":"image","position":"sppb-text-center","open_lightbox":"0","overlay_color":"rgba(119, 219, 31, 0.5)","link":"","target":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]},{"id":1496654701129,"visibility":true,"collapse":false,"settings":{"padding":"50px 0px 50px 0px","margin":"0px 0px 0px 0px"},"layout":"12","columns":[{"id":1496654701130,"class_name":"col-md-12","visibility":true,"settings":{},"addons":[{"id":1496654701133,"name":"text_block","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of \\"de Finibus Bonorum et Malorum\\" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, \\"Lorem ipsum dolor sit amet..\\", comes from a line in section 1.10.32.</p>\\n<br />\\n<p>The standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from \\"de Finibus Bonorum et Malorum\\" by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.</p>","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496654701136,"name":"blockquote","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"I believe that a simple and unassuming manner of life is best for everyone, best both for the body and the mind.","footer":"Albert Einstein","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496654701139,"name":"text_block","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem.</p>","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]}]', 'com_content', 'article', 85, 1, 1, 0, 0, 0, '2017-06-05 09:37:36', 671, '2017-06-07 10:13:53', 671, 0, '0000-00-00 00:00:00', '', '', '', '*', 0, ''),
(10, 0, 'Jancetta sausage brisket leberkas shoulder tri-tip short.', '[{"id":1496654701110,"visibility":true,"collapse":false,"settings":{"padding":"50px 0px 50px 0px","margin":"0px 0px 0px 0px"},"layout":"12","columns":[{"id":1496654701111,"class_name":"col-md-12","visibility":true,"settings":{},"addons":[{"id":1496654701114,"name":"text_block","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of \\"de Finibus Bonorum et Malorum\\" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, \\"Lorem ipsum dolor sit amet..\\", comes from a line in section 1.10.32.</p>\\n<br />\\n<p>The standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from \\"de Finibus Bonorum et Malorum\\" by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.</p>","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496654701117,"name":"module","visibility":true,"settings":{"admin_label":"Advertisement","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","module_type":"module","id":"115","position":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"35px 0 0 0","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]},{"id":1496654701118,"visibility":true,"collapse":false,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","subtitle":"","subtitle_fontsize":"","title_position":"sppb-text-center","columns_equal_height":"0","fullscreen":"0","no_gutter":"0","id":"","class":"","padding":"5px 0px 0 0px","margin":"0px 0px 0px 0px","color":"","background_color":"","background_image":"","overlay":"","background_repeat":"no-repeat","background_size":"cover","background_attachment":"fixed","background_position":"0 0","background_video":"0","background_video_mp4":"","background_video_ogv":"","hidden_xs":"","hidden_sm":"","hidden_md":"","animation":"","animationduration":"300","animationdelay":"0"},"layout":"6,6","columns":[{"id":1496654701119,"class_name":"col-md-6","visibility":true,"settings":{},"addons":[{"id":1496654701123,"name":"image","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","image":"images/2017/06/05/img01.jpg","alt_text":"image","position":"sppb-text-center","open_lightbox":"0","overlay_color":"rgba(119, 219, 31, 0.5)","link":"","target":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]},{"id":1496654701120,"class_name":"col-md-6","visibility":true,"settings":{},"addons":[{"id":1496654701126,"name":"image","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","image":"images/2017/06/05/img02.jpg","alt_text":"image","position":"sppb-text-center","open_lightbox":"0","overlay_color":"rgba(119, 219, 31, 0.5)","link":"","target":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]},{"id":1496654701129,"visibility":true,"collapse":false,"settings":{"padding":"50px 0px 50px 0px","margin":"0px 0px 0px 0px"},"layout":"12","columns":[{"id":1496654701130,"class_name":"col-md-12","visibility":true,"settings":{},"addons":[{"id":1496654701133,"name":"text_block","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of \\"de Finibus Bonorum et Malorum\\" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, \\"Lorem ipsum dolor sit amet..\\", comes from a line in section 1.10.32.</p>\\n<br />\\n<p>The standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from \\"de Finibus Bonorum et Malorum\\" by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.</p>","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496654701136,"name":"blockquote","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"I believe that a simple and unassuming manner of life is best for everyone, best both for the body and the mind.","footer":"Albert Einstein","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496654701139,"name":"text_block","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem.</p>","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]}]', 'com_content', 'article', 86, 1, 1, 0, 0, 0, '2017-06-05 09:37:36', 671, '2017-06-22 10:04:21', 671, 0, '0000-00-00 00:00:00', '', '', '', '*', 0, '');
INSERT INTO `#__sppagebuilder` (`id`, `asset_id`, `title`, `text`, `extension`, `extension_view`, `view_id`, `active`, `published`, `catid`, `access`, `ordering`, `created_on`, `created_by`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `og_title`, `og_image`, `og_description`, `language`, `hits`, `css`) VALUES
(11, 0, 'Ham frankfurter jerky, ground round burgdoggen ball tip.', '[{"id":1496654701110,"visibility":true,"collapse":false,"settings":{"padding":"50px 0px 50px 0px","margin":"0px 0px 0px 0px"},"layout":"12","columns":[{"id":1496654701111,"class_name":"col-md-12","visibility":true,"settings":{},"addons":[{"id":1496654701114,"name":"text_block","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of \\"de Finibus Bonorum et Malorum\\" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, \\"Lorem ipsum dolor sit amet..\\", comes from a line in section 1.10.32.</p>\\n<br />\\n<p>The standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from \\"de Finibus Bonorum et Malorum\\" by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.</p>","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496654701117,"name":"module","visibility":true,"settings":{"admin_label":"Advertisement","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","module_type":"module","id":"115","position":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"35px 0 0 0","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]},{"id":1496654701118,"visibility":true,"collapse":false,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","subtitle":"","subtitle_fontsize":"","title_position":"sppb-text-center","columns_equal_height":"0","fullscreen":"0","no_gutter":"0","id":"","class":"","padding":"5px 0px 0 0px","margin":"0px 0px 0px 0px","color":"","background_color":"","background_image":"","overlay":"","background_repeat":"no-repeat","background_size":"cover","background_attachment":"fixed","background_position":"0 0","background_video":"0","background_video_mp4":"","background_video_ogv":"","hidden_xs":"","hidden_sm":"","hidden_md":"","animation":"","animationduration":"300","animationdelay":"0"},"layout":"6,6","columns":[{"id":1496654701119,"class_name":"col-md-6","visibility":true,"settings":{},"addons":[{"id":1496654701123,"name":"image","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","image":"images/2017/06/05/img01.jpg","alt_text":"image","position":"sppb-text-center","open_lightbox":"0","overlay_color":"rgba(119, 219, 31, 0.5)","link":"","target":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]},{"id":1496654701120,"class_name":"col-md-6","visibility":true,"settings":{},"addons":[{"id":1496654701126,"name":"image","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","image":"images/2017/06/05/img02.jpg","alt_text":"image","position":"sppb-text-center","open_lightbox":"0","overlay_color":"rgba(119, 219, 31, 0.5)","link":"","target":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]},{"id":1496654701129,"visibility":true,"collapse":false,"settings":{"padding":"50px 0px 50px 0px","margin":"0px 0px 0px 0px"},"layout":"12","columns":[{"id":1496654701130,"class_name":"col-md-12","visibility":true,"settings":{},"addons":[{"id":1496654701133,"name":"text_block","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of \\"de Finibus Bonorum et Malorum\\" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, \\"Lorem ipsum dolor sit amet..\\", comes from a line in section 1.10.32.</p>\\n<br />\\n<p>The standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from \\"de Finibus Bonorum et Malorum\\" by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.</p>","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496654701136,"name":"blockquote","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"I believe that a simple and unassuming manner of life is best for everyone, best both for the body and the mind.","footer":"Albert Einstein","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496654701139,"name":"text_block","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem.</p>","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]}]', 'com_content', 'article', 87, 1, 1, 0, 0, 0, '2017-06-05 09:37:36', 671, '2017-06-22 10:05:28', 671, 0, '0000-00-00 00:00:00', '', '', '', '*', 0, ''),
(12, 0, 'Across London as armed police step up patrols', '[{"id":1496654701110,"visibility":true,"collapse":false,"settings":{"padding":"50px 0px 50px 0px","margin":"0px 0px 0px 0px"},"layout":"12","columns":[{"id":1496654701111,"class_name":"col-md-12","visibility":true,"settings":{},"addons":[{"id":1496654701114,"name":"text_block","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of \\"de Finibus Bonorum et Malorum\\" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, \\"Lorem ipsum dolor sit amet..\\", comes from a line in section 1.10.32.</p>\\n<br />\\n<p>The standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from \\"de Finibus Bonorum et Malorum\\" by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.</p>","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496654701117,"name":"module","visibility":true,"settings":{"admin_label":"Advertisement","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","module_type":"module","id":"115","position":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"35px 0 0 0","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]},{"id":1496654701118,"visibility":true,"collapse":false,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","subtitle":"","subtitle_fontsize":"","title_position":"sppb-text-center","columns_equal_height":"0","fullscreen":"0","no_gutter":"0","id":"","class":"","padding":"5px 0px 0 0px","margin":"0px 0px 0px 0px","color":"","background_color":"","background_image":"","overlay":"","background_repeat":"no-repeat","background_size":"cover","background_attachment":"fixed","background_position":"0 0","background_video":"0","background_video_mp4":"","background_video_ogv":"","hidden_xs":"","hidden_sm":"","hidden_md":"","animation":"","animationduration":"300","animationdelay":"0"},"layout":"6,6","columns":[{"id":1496654701119,"class_name":"col-md-6","visibility":true,"settings":{},"addons":[{"id":1496654701123,"name":"image","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","image":"images/2017/06/05/img01.jpg","alt_text":"image","position":"sppb-text-center","open_lightbox":"0","overlay_color":"rgba(119, 219, 31, 0.5)","link":"","target":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]},{"id":1496654701120,"class_name":"col-md-6","visibility":true,"settings":{},"addons":[{"id":1496654701126,"name":"image","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","image":"images/2017/06/05/img02.jpg","alt_text":"image","position":"sppb-text-center","open_lightbox":"0","overlay_color":"rgba(119, 219, 31, 0.5)","link":"","target":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]},{"id":1496654701129,"visibility":true,"collapse":false,"settings":{"padding":"50px 0px 50px 0px","margin":"0px 0px 0px 0px"},"layout":"12","columns":[{"id":1496654701130,"class_name":"col-md-12","visibility":true,"settings":{},"addons":[{"id":1496654701133,"name":"text_block","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of \\"de Finibus Bonorum et Malorum\\" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, \\"Lorem ipsum dolor sit amet..\\", comes from a line in section 1.10.32.</p>\\n<br />\\n<p>The standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from \\"de Finibus Bonorum et Malorum\\" by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.</p>","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496654701136,"name":"blockquote","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"I believe that a simple and unassuming manner of life is best for everyone, best both for the body and the mind.","footer":"Albert Einstein","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496654701139,"name":"text_block","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem.</p>","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]}]', 'com_content', 'article', 88, 1, 1, 0, 0, 0, '2017-06-05 09:37:36', 671, '2017-06-07 10:08:29', 671, 0, '0000-00-00 00:00:00', '', '', '', '*', 0, ''),
(13, 0, 'Ut at magna leo. Suspendisse egestas est ac dolor', '[{"id":1496654701110,"visibility":true,"collapse":false,"settings":{"padding":"50px 0px 50px 0px","margin":"0px 0px 0px 0px"},"layout":"12","columns":[{"id":1496654701111,"class_name":"col-md-12","visibility":true,"settings":{},"addons":[{"id":1496654701114,"name":"text_block","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of \\"de Finibus Bonorum et Malorum\\" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, \\"Lorem ipsum dolor sit amet..\\", comes from a line in section 1.10.32.</p>\\n<br />\\n<p>The standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from \\"de Finibus Bonorum et Malorum\\" by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.</p>","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496654701117,"name":"module","visibility":true,"settings":{"admin_label":"Advertisement","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","module_type":"module","id":"115","position":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"35px 0 0 0","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]},{"id":1496654701118,"visibility":true,"collapse":false,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","subtitle":"","subtitle_fontsize":"","title_position":"sppb-text-center","columns_equal_height":"0","fullscreen":"0","no_gutter":"0","id":"","class":"","padding":"5px 0px 0 0px","margin":"0px 0px 0px 0px","color":"","background_color":"","background_image":"","overlay":"","background_repeat":"no-repeat","background_size":"cover","background_attachment":"fixed","background_position":"0 0","background_video":"0","background_video_mp4":"","background_video_ogv":"","hidden_xs":"","hidden_sm":"","hidden_md":"","animation":"","animationduration":"300","animationdelay":"0"},"layout":"6,6","columns":[{"id":1496654701119,"class_name":"col-md-6","visibility":true,"settings":{},"addons":[{"id":1496654701123,"name":"image","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","image":"images/2017/06/05/img01.jpg","alt_text":"image","position":"sppb-text-center","open_lightbox":"0","overlay_color":"rgba(119, 219, 31, 0.5)","link":"","target":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]},{"id":1496654701120,"class_name":"col-md-6","visibility":true,"settings":{},"addons":[{"id":1496654701126,"name":"image","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","image":"images/2017/06/05/img02.jpg","alt_text":"image","position":"sppb-text-center","open_lightbox":"0","overlay_color":"rgba(119, 219, 31, 0.5)","link":"","target":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]},{"id":1496654701129,"visibility":true,"collapse":false,"settings":{"padding":"50px 0px 50px 0px","margin":"0px 0px 0px 0px"},"layout":"12","columns":[{"id":1496654701130,"class_name":"col-md-12","visibility":true,"settings":{},"addons":[{"id":1496654701133,"name":"text_block","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of \\"de Finibus Bonorum et Malorum\\" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, \\"Lorem ipsum dolor sit amet..\\", comes from a line in section 1.10.32.</p>\\n<br />\\n<p>The standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from \\"de Finibus Bonorum et Malorum\\" by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.</p>","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496654701136,"name":"blockquote","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"I believe that a simple and unassuming manner of life is best for everyone, best both for the body and the mind.","footer":"Albert Einstein","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496654701139,"name":"text_block","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem.</p>","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]}]', 'com_content', 'article', 89, 1, 1, 0, 0, 0, '2017-06-05 09:37:36', 671, '2017-06-22 09:47:35', 671, 0, '0000-00-00 00:00:00', '', '', '', '*', 0, '');
INSERT INTO `#__sppagebuilder` (`id`, `asset_id`, `title`, `text`, `extension`, `extension_view`, `view_id`, `active`, `published`, `catid`, `access`, `ordering`, `created_on`, `created_by`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `og_title`, `og_image`, `og_description`, `language`, `hits`, `css`) VALUES
(14, 0, 'The Activists: The University of Missouri Football Team', '[{"id":1496654701110,"visibility":true,"collapse":false,"settings":{"padding":"50px 0px 50px 0px","margin":"0px 0px 0px 0px"},"layout":"12","columns":[{"id":1496654701111,"class_name":"col-md-12","visibility":true,"settings":{},"addons":[{"id":1496654701114,"name":"text_block","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of \\"de Finibus Bonorum et Malorum\\" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, \\"Lorem ipsum dolor sit amet..\\", comes from a line in section 1.10.32.</p>\\n<br />\\n<p>The standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from \\"de Finibus Bonorum et Malorum\\" by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.</p>","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496654701117,"name":"module","visibility":true,"settings":{"admin_label":"Advertisement","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","module_type":"module","id":"115","position":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"35px 0 0 0","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]},{"id":1496654701118,"visibility":true,"collapse":false,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","subtitle":"","subtitle_fontsize":"","title_position":"sppb-text-center","columns_equal_height":"0","fullscreen":"0","no_gutter":"0","id":"","class":"","padding":"5px 0px 0 0px","margin":"0px 0px 0px 0px","color":"","background_color":"","background_image":"","overlay":"","background_repeat":"no-repeat","background_size":"cover","background_attachment":"fixed","background_position":"0 0","background_video":"0","background_video_mp4":"","background_video_ogv":"","hidden_xs":"","hidden_sm":"","hidden_md":"","animation":"","animationduration":"300","animationdelay":"0"},"layout":"6,6","columns":[{"id":1496654701119,"class_name":"col-md-6","visibility":true,"settings":{},"addons":[{"id":1496654701123,"name":"image","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","image":"images/2017/06/05/img01.jpg","alt_text":"image","position":"sppb-text-center","open_lightbox":"0","overlay_color":"rgba(119, 219, 31, 0.5)","link":"","target":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]},{"id":1496654701120,"class_name":"col-md-6","visibility":true,"settings":{},"addons":[{"id":1496654701126,"name":"image","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","image":"images/2017/06/05/img02.jpg","alt_text":"image","position":"sppb-text-center","open_lightbox":"0","overlay_color":"rgba(119, 219, 31, 0.5)","link":"","target":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]},{"id":1496654701129,"visibility":true,"collapse":false,"settings":{"padding":"50px 0px 50px 0px","margin":"0px 0px 0px 0px"},"layout":"12","columns":[{"id":1496654701130,"class_name":"col-md-12","visibility":true,"settings":{},"addons":[{"id":1496654701133,"name":"text_block","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of \\"de Finibus Bonorum et Malorum\\" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, \\"Lorem ipsum dolor sit amet..\\", comes from a line in section 1.10.32.</p>\\n<br />\\n<p>The standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from \\"de Finibus Bonorum et Malorum\\" by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.</p>","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496654701136,"name":"blockquote","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"I believe that a simple and unassuming manner of life is best for everyone, best both for the body and the mind.","footer":"Albert Einstein","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496654701139,"name":"text_block","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem.</p>","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]}]', 'com_content', 'article', 90, 1, 1, 0, 0, 0, '2017-06-05 09:37:36', 671, '2017-06-23 08:32:30', 671, 0, '0000-00-00 00:00:00', '', '', '', '*', 0, ''),
(15, 0, 'Cras semper consectetur elementum, Nulla vel.', '[{"id":1496654701110,"visibility":true,"collapse":false,"settings":{"padding":"50px 0px 50px 0px","margin":"0px 0px 0px 0px"},"layout":"12","columns":[{"id":1496654701111,"class_name":"col-md-12","visibility":true,"settings":{},"addons":[{"id":1496654701114,"name":"text_block","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of \\"de Finibus Bonorum et Malorum\\" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, \\"Lorem ipsum dolor sit amet..\\", comes from a line in section 1.10.32.</p>\\n<br />\\n<p>The standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from \\"de Finibus Bonorum et Malorum\\" by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.</p>","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496654701117,"name":"module","visibility":true,"settings":{"admin_label":"Advertisement","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","module_type":"module","id":"115","position":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"35px 0 0 0","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]},{"id":1496654701118,"visibility":true,"collapse":false,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","subtitle":"","subtitle_fontsize":"","title_position":"sppb-text-center","columns_equal_height":"0","fullscreen":"0","no_gutter":"0","id":"","class":"","padding":"5px 0px 0 0px","margin":"0px 0px 0px 0px","color":"","background_color":"","background_image":"","overlay":"","background_repeat":"no-repeat","background_size":"cover","background_attachment":"fixed","background_position":"0 0","background_video":"0","background_video_mp4":"","background_video_ogv":"","hidden_xs":"","hidden_sm":"","hidden_md":"","animation":"","animationduration":"300","animationdelay":"0"},"layout":"6,6","columns":[{"id":1496654701119,"class_name":"col-md-6","visibility":true,"settings":{},"addons":[{"id":1496654701123,"name":"image","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","image":"images/2017/06/05/img01.jpg","alt_text":"image","position":"sppb-text-center","open_lightbox":"0","overlay_color":"rgba(119, 219, 31, 0.5)","link":"","target":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]},{"id":1496654701120,"class_name":"col-md-6","visibility":true,"settings":{},"addons":[{"id":1496654701126,"name":"image","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","image":"images/2017/06/05/img02.jpg","alt_text":"image","position":"sppb-text-center","open_lightbox":"0","overlay_color":"rgba(119, 219, 31, 0.5)","link":"","target":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]},{"id":1496654701129,"visibility":true,"collapse":false,"settings":{"padding":"50px 0px 50px 0px","margin":"0px 0px 0px 0px"},"layout":"12","columns":[{"id":1496654701130,"class_name":"col-md-12","visibility":true,"settings":{},"addons":[{"id":1496654701133,"name":"text_block","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of \\"de Finibus Bonorum et Malorum\\" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, \\"Lorem ipsum dolor sit amet..\\", comes from a line in section 1.10.32.</p>\\n<br />\\n<p>The standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from \\"de Finibus Bonorum et Malorum\\" by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.</p>","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496654701136,"name":"blockquote","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"I believe that a simple and unassuming manner of life is best for everyone, best both for the body and the mind.","footer":"Albert Einstein","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496654701139,"name":"text_block","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem.</p>","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]}]', 'com_content', 'article', 91, 1, 1, 0, 0, 0, '2017-06-05 09:37:36', 671, '2017-06-22 09:49:40', 671, 0, '0000-00-00 00:00:00', '', '', '', '*', 0, ''),
(16, 0, 'The Newest McDonald''s Location Only Serves', '[{"id":1496654701110,"visibility":true,"collapse":false,"settings":{"padding":"50px 0px 50px 0px","margin":"0px 0px 0px 0px"},"layout":"12","columns":[{"id":1496654701111,"class_name":"col-md-12","visibility":true,"settings":{},"addons":[{"id":1496654701114,"name":"text_block","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of \\"de Finibus Bonorum et Malorum\\" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, \\"Lorem ipsum dolor sit amet..\\", comes from a line in section 1.10.32.</p>\\n<br />\\n<p>The standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from \\"de Finibus Bonorum et Malorum\\" by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.</p>","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496654701117,"name":"module","visibility":true,"settings":{"admin_label":"Advertisement","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","module_type":"module","id":"115","position":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"35px 0 0 0","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]},{"id":1496654701118,"visibility":true,"collapse":false,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","subtitle":"","subtitle_fontsize":"","title_position":"sppb-text-center","columns_equal_height":"0","fullscreen":"0","no_gutter":"0","id":"","class":"","padding":"5px 0px 0 0px","margin":"0px 0px 0px 0px","color":"","background_color":"","background_image":"","overlay":"","background_repeat":"no-repeat","background_size":"cover","background_attachment":"fixed","background_position":"0 0","background_video":"0","background_video_mp4":"","background_video_ogv":"","hidden_xs":"","hidden_sm":"","hidden_md":"","animation":"","animationduration":"300","animationdelay":"0"},"layout":"6,6","columns":[{"id":1496654701119,"class_name":"col-md-6","visibility":true,"settings":{},"addons":[{"id":1496654701123,"name":"image","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","image":"images/2017/06/05/img01.jpg","alt_text":"image","position":"sppb-text-center","open_lightbox":"0","overlay_color":"rgba(119, 219, 31, 0.5)","link":"","target":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]},{"id":1496654701120,"class_name":"col-md-6","visibility":true,"settings":{},"addons":[{"id":1496654701126,"name":"image","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","image":"images/2017/06/05/img02.jpg","alt_text":"image","position":"sppb-text-center","open_lightbox":"0","overlay_color":"rgba(119, 219, 31, 0.5)","link":"","target":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]},{"id":1496654701129,"visibility":true,"collapse":false,"settings":{"padding":"50px 0px 50px 0px","margin":"0px 0px 0px 0px"},"layout":"12","columns":[{"id":1496654701130,"class_name":"col-md-12","visibility":true,"settings":{},"addons":[{"id":1496654701133,"name":"text_block","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of \\"de Finibus Bonorum et Malorum\\" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, \\"Lorem ipsum dolor sit amet..\\", comes from a line in section 1.10.32.</p>\\n<br />\\n<p>The standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from \\"de Finibus Bonorum et Malorum\\" by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.</p>","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496654701136,"name":"blockquote","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"I believe that a simple and unassuming manner of life is best for everyone, best both for the body and the mind.","footer":"Albert Einstein","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496654701139,"name":"text_block","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem.</p>","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]}]', 'com_content', 'article', 92, 1, 1, 0, 0, 0, '2017-06-05 09:37:36', 671, '2017-06-22 09:50:02', 671, 0, '0000-00-00 00:00:00', '', '', '', '*', 0, '');
INSERT INTO `#__sppagebuilder` (`id`, `asset_id`, `title`, `text`, `extension`, `extension_view`, `view_id`, `active`, `published`, `catid`, `access`, `ordering`, `created_on`, `created_by`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `og_title`, `og_image`, `og_description`, `language`, `hits`, `css`) VALUES
(17, 0, 'The Newest McDonald''s Location Only Serves', '[{"id":1496654701110,"visibility":true,"collapse":false,"settings":{"padding":"50px 0px 50px 0px","margin":"0px 0px 0px 0px"},"layout":"12","columns":[{"id":1496654701111,"class_name":"col-md-12","visibility":true,"settings":{},"addons":[{"id":1496654701114,"name":"text_block","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of \\"de Finibus Bonorum et Malorum\\" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, \\"Lorem ipsum dolor sit amet..\\", comes from a line in section 1.10.32.</p>\\n<br />\\n<p>The standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from \\"de Finibus Bonorum et Malorum\\" by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.</p>","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496654701117,"name":"module","visibility":true,"settings":{"admin_label":"Advertisement","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","module_type":"module","id":"115","position":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"35px 0 0 0","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]},{"id":1496654701118,"visibility":true,"collapse":false,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","subtitle":"","subtitle_fontsize":"","title_position":"sppb-text-center","columns_equal_height":"0","fullscreen":"0","no_gutter":"0","id":"","class":"","padding":"5px 0px 0 0px","margin":"0px 0px 0px 0px","color":"","background_color":"","background_image":"","overlay":"","background_repeat":"no-repeat","background_size":"cover","background_attachment":"fixed","background_position":"0 0","background_video":"0","background_video_mp4":"","background_video_ogv":"","hidden_xs":"","hidden_sm":"","hidden_md":"","animation":"","animationduration":"300","animationdelay":"0"},"layout":"6,6","columns":[{"id":1496654701119,"class_name":"col-md-6","visibility":true,"settings":{},"addons":[{"id":1496654701123,"name":"image","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","image":"images/2017/06/05/img01.jpg","alt_text":"image","position":"sppb-text-center","open_lightbox":"0","overlay_color":"rgba(119, 219, 31, 0.5)","link":"","target":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]},{"id":1496654701120,"class_name":"col-md-6","visibility":true,"settings":{},"addons":[{"id":1496654701126,"name":"image","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","image":"images/2017/06/05/img02.jpg","alt_text":"image","position":"sppb-text-center","open_lightbox":"0","overlay_color":"rgba(119, 219, 31, 0.5)","link":"","target":"","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]},{"id":1496654701129,"visibility":true,"collapse":false,"settings":{"padding":"50px 0px 50px 0px","margin":"0px 0px 0px 0px"},"layout":"12","columns":[{"id":1496654701130,"class_name":"col-md-12","visibility":true,"settings":{},"addons":[{"id":1496654701133,"name":"text_block","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of \\"de Finibus Bonorum et Malorum\\" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, \\"Lorem ipsum dolor sit amet..\\", comes from a line in section 1.10.32.</p>\\n<br />\\n<p>The standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from \\"de Finibus Bonorum et Malorum\\" by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.</p>","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496654701136,"name":"blockquote","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"I believe that a simple and unassuming manner of life is best for everyone, best both for the body and the mind.","footer":"Albert Einstein","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}},{"id":1496654701139,"name":"text_block","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem.</p>","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation":"0","global_animation":"","global_animationduration":"300","global_animationdelay":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":null}}]}]}]', 'com_content', 'article', 93, 1, 1, 0, 0, 0, '2017-06-05 09:37:36', 671, '2017-06-07 10:17:53', 671, 0, '0000-00-00 00:00:00', '', '', '', '*', 0, ''),
(18, 0, 'The Newest McDonald''s Location Only Serves', '[{"id":1496654701110,"visibility":true,"collapse":false,"settings":{"padding":"50px 0px 50px 0px","margin":"0px 0px 0px 0px"},"layout":"12","columns":[{"id":1496654701111,"class_name":"col-md-12","visibility":true,"settings":{},"addons":[{"id":1496654701114,"name":"text_block","visibility":true,"settings":{"admin_label":"","title":"","heading_selector":"h3","title_fontsize":"","title_lineheight":"","title_fontstyle":null,"title_letterspace":"0","title_fontweight":"","title_text_color":"","title_margin_top":"","title_margin_bottom":"","text":"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of \\"de Finibus Bonorum et Malorum\\" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, \\"Lorem ipsum dolor sit amet..\\", comes from a line in section 1.10.32.</p>\\n<br />\\n<p>The standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from \\"de Finibus Bonorum et Malorum\\" by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.</p>","alignment":"sppb-text-left","class":"","global_text_color":"","global_link_color":"","global_link_hover_color":"","global_use_background":"0","global_background_color":"","global_background_image":"","global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_user_border":"0","global_border_width":"","global_border_color":"","global_boder_style":"none","global_border_radius":"","global_margin":"","global_padding":"","global_use_animation"