/* Icon Picker */

(function ($) {

    $.fn.iconPicker = function (options) {
        var options = ['fas', 'fa']; // default font set
        var icons;
        $list = $('');

        function font_set() {
          if (options[0] == 'fas') {
               icons = [
                    // Mail
                    "inbox",
                    "envelope",
                    "envelope-square",
                    "envelope-open",
                    "envelope-open-text",
                    "paperclip",
                    "reply-all",                    
                    "reply",
                    "mail-bulk",
                    // Media
                    "music",
                    "film",
                    "step-backward",
                    "fast-backward",
                    "backward",
                    "play",
                    "play-circle",                    
                    "pause",
                    "stop",
                    "forward",
                    "fast-forward",
                    "step-forward",
                    "eject",
                    "redo",
                    "redo-alt",
                    "random",
                    "sync",
                    "sync-alt",
                    "headphones",
                    "volume-off",
                    "volume-down",
                    "volume-up",
                    // Arrows
                    "angle-double-left",
                    "angle-double-right",
                    "angle-double-up",
                    "angle-double-down",
                    "angle-left",
                    "angle-right",
                    "angle-up",
                    "angle-down",
                    "arrow-left",
                    "arrow-right",
                    "arrow-up",
                    "arrow-down",
                    "arrows-alt",
                    "arrows-alt-v",
                    "arrows-alt-h",
                    "arrow-circle-left",
                    "arrow-circle-right",
                    "arrow-circle-up",
                    "arrow-circle-down",
                    "arrow-alt-circle-down",
                    "arrow-alt-circle-up",
                    "arrow-alt-circle-right",
                    "arrow-alt-circle-left",
                    "caret-down",
                    "caret-up",
                    "caret-left",
                    "caret-right",
                    "chevron-left",
                    "chevron-right",
                    "chevron-up",
                    "chevron-down",
                    "chevron-circle-left",
                    "chevron-circle-right",
                    "chevron-circle-up",
                    "chevron-circle-down",
                    "expand",
                    "compress",
                    "hands",
                    "handshake",
                    "handshake-slash",
                    "handshake-alt-slash",
                    "hands-wash",
                    "hands-helping",
                    "hand-spock",
                    "hand-sparkles",
                    "hand-scissors",
                    "hand-rock",
                    "hand-pointer",
                    "hand-point-up",
                    "hand-point-right",
                    "hand-point-left",
                    "hand-point-down",
                    "hand-peace",
                    "hand-paper",
                    "hand-middle-finger",
                    "hand-lizard",
                    "hand-holding-water",
                    "hand-holding-usd",
                    "hand-holding-medical",
                    "hand-holding-heart",
                    "hand-holding",
                    "praying-hands",
                    "level-up-alt",
                    "level-down-alt",
                    "long-arrow-alt-down",
                    "long-arrow-alt-up",
                    "long-arrow-alt-left",
                    "long-arrow-alt-right",
                    "toggle-on",
                    "toggle-off",
                    // Search
                    "search",
                    "search-plus",
                    "search-minus",
                    // File Editing
                    "cut",
                    "crop",
                    "copy",
                    "paste",
                    "font",
                    "bold",
                    "italic",
                    "anchor",
                    "link",
                    "unlink",
                    "external-link-alt",
                    "external-link-square-alt",
                    "text-height",
                    "text-width",
                    "align-left",
                    "align-center",
                    "align-right",
                    "align-justify",
                    "list",
                    "quote-left",
                    "quote-right",
                    "outdent",
                    "indent",
                    "undo",
                    "adjust",
                    "tint",
                    "edit",
                    "list-ul",
                    "list-ol",
                    "list-alt",
                    "th-large",
                    "th",
                    "th-list",
                    "strikethrough",
                    "underline",
                    "magic",
                    "superscript",
                    "subscript",
                    "eraser",                    
                    // Punctuation
                    "asterisk",
                    "question",
                    "info",
                    "exclamation",
                    // Emoticons
                    "smile",
                    "frown",
                    "frown-open",
                    "meh",
                    "meh-rolling-eyes",
                    "meh-blank",
                    // Math + Geometry
                    "check",
                    "check-circle",
                    "check-square",
                    "check-double",                    
                    "spell-check",
                    "user-check",
                    "user-shield",
                    "clipboard-check",                    
                    "times",
                    "times-circle",
                    "user-times",                    
                    "business-time",
                    "plus",
                    "minus",
                    "crosshairs",
                    "spinner",
                    "circle",
                    "circle-notch",
                    "dot-circle",
                    "minus-circle",                                        
                    "exclamation-circle",
                    "question-circle",
                    "info-circle",
                    "plus-circle",
                    "plus-square",
                    "square",
                    "h-square",
                    "share",
                    "share-square",
                    "share-alt",
                    "share-alt-square",
                    "ellipsis-h",
                    "ellipsis-v",
                    "minus-square",                    
                    "bullseye",
                    // Rate
                    "thumbs-up",
                    "thumbs-down",
                    "thumbtack",
                    "star",
                    "star-of-life",
                    "star-of-david",
                    "star-half",
                    "star-half-alt",
                    "star-and-crescent",
                    "heart",
                    "heartbeat",
                    "heart-broken",
                    "lemon",
                    "trophy",                    
                    // Accounts
                    "user",
                    "user-md",
                    "user-edit",
                    "user-friends",
                    "users-cog",
                    "user-lock",
                    "object-group",
                    "object-ungroup",
                    "layer-group",
                    "sign-in-alt",
                    "sign-out-alt",
                    "key",
                    "lock",
                    "unlock",
                    "unlock-alt",
                    "ban",
                    "female",
                    "male",
                    "comment",
                    "comments",
                    "ticket-alt",
                    "tasks",
                    "calendar",
                    "calendar-check",
                    "calendar-times",
                    "calendar-plus",
                    "calendar-minus",
                    "calendar-alt",
                    "calendar-day",
                    "calendar-week",
                    // Time
                    "poo-storm",
                    "bolt",
                    "sun",
                    "moon",
                    "clock",
                    "user-clock",
                    "history",
                    "stopwatch",
                    "cloud-meatball",
                    "cloud-moon",
                    "cloud-moon-rain",
                    "cloud-sun",
                    "cloud-rain",
                    "cloud-sun-rain",
                    "cloud-showers-heavy",                    
                    // Site
                    "home",
                    "comment-alt",
                    "comment-slash",
                    "comment-medical",
                    "comment-dots",
                    "sitemap",
                    // File Operations
                    "upload",
                    "download",
                    "exchange-alt",                    
                    "file-word",
                    "file-video",
                    "file-powerpoint",
                    "file-pdf",
                    "file-image",
                    "file-excel",
                    "file-code",
                    "file-audio",
                    "file-archive",
                    "file-upload",
                    "file-signature",
                    "file-prescription",
                    "file-medical-alt",
                    "file-alt",
                    "file",
                    "file-contract",
                    "file-csv",
                    "file-export",
                    "file-import",
                    "file-invoice",
                    "file-medical",
                    "folder",
                    "folder-plus",
                    "folder-minus",
                    "folder-open",
                    "hdd",
                    "cloud",
                    "cloud-download-alt",
                    "cloud-upload-alt",
                    "save",
                    "trash",
                    "trash-alt",
                    "trash-restore",
                    "trash-restore-alt",
                    "print",
                    // Social Networks
                    "rss",
                    "rss-square",                    
                    // Computer
                    "desktop",
                    "laptop",
                    "tablet",
                    "mobile",
                    "mobile-alt",
                    "sms",
                    "phone",
                    "phone-square",
                    "microphone",
                    "microphone-slash",                    
                    "window-close",
                    "window-maximize",
                    "window-restore",
                    "gamepad",
                    "keyboard",
                    "chalkboard",
                    "chalkboard-teacher",
                    "signal",
                    "power-off",
                    "terminal",
                    "code",
                    "laptop-code",
                    "code-branch",
                    "bug",
                    // Maps
                    "glasses",
                    "globe",
                    "map-marker",
                    "building",
                    "warehouse",
                    "monument",
                    "city",
                    "school",
                    "store-alt",
                    "synagogue",
                    "church",
                    "university",
                    "mosque",
                    "landmark",
                    "hotel",
                    "place-of-worship",
                    "torii-gate",
                    "hospital",
                    "hospital-alt",
                    "location-arrow",
                    "compass",
                    "road",
                    // Tools & Objects
                    "bell",
                    "bell-slash",
                    "concierge-bell",
                    "book",
                    "bookmark",
                    "bullhorn",
                    "camera",
                    "camera-retro",
                    "video",
                    "video-slash",
                    "portrait",
                    "image",
                    "images",
                    "pencil-alt",
                    "pencil-ruler",
                    "pen-square",
                    "flask",
                    "briefcase",
                    "table",
                    "truck",
                    "wrench",
                    "plane",
                    "lightbulb",
                    "traffic-light",
                    "stethoscope",
                    "suitcase",
                    "coffee",
                    "utensils",
                    "utensil-spoon",
                    "umbrella",
                    "ambulance",
                    "medkit",
                    "fighter-jet",
                    "beer",
                    "wheelchair",
                    "gift",
                    "leaf",
                    "fire",
                    "eye",
                    "eye-slash",
                    "exclamation-triangle",
                    "radiation",
                    "skull-crossbones",
                    "magnet",
                    "flag",
                    "flag-usa",
                    "flag-checkered",
                    "fire-extinguisher",
                    "rocket",
                    "bomb",
                    "retweet",
                    "shield-alt",
                    "shield-virus",
                    "puzzle-piece",
                    "balance-scale",
                    "balance-scale-right",
                    "balance-scale-left",
                    "tachometer-alt",
                    "bars",
                    // Sorting
                    "columns",
                    "filter",
                    "sort",
                    "sort-down",
                    "sort-up",
                    "sort-alpha-up",
                    "sort-alpha-up-alt",
                    "sort-alpha-down",
                    "sort-alpha-down-alt",
                    "sort-amount-up",
                    "sort-amount-up-alt",
                    "sort-amount-down-alt",
                    "sort-amount-down",
                    "sort-numeric-up",
                    "sort-numeric-up-alt",
                    "sort-numeric-down",
                    "sort-numeric-down-alt",
                    // e-Commerce
                    "money-check",
                    "money-check-alt",
                    "money-bill-wave-alt",
                    "money-bill-wave",
                    "money-bill-alt",
                    "ruble-sign",
                    "lira-sign",
                    "hryvnia",
                    "dollar-sign",
                    "euro-sign",
                    "rupee-sign",
                    "pound-sign",
                    "tenge",
                    "shekel-sign",
                    "won-sign",
                    "yen-sign",
                    "funnel-dollar",
                    "certificate",
                    "wallet",                    
                    "comments-dollar",
                    "comment-dollar",
                    "file-invoice-dollar",
                    "search-dollar",
                    "credit-card",
                    "shopping-cart",
                    "tag",
                    "tags",
                    "qrcode",
                    "barcode"
                ];
                options[1] = "fa";
          } else if (options[0] == 'fab') {
               icons = [
                    'windows',
                    'css3',
                    'css3-alt',
                    'html5',
                    'linux',
                    'android',
                    'apple',
                    'behance',
                    'bitbucket',
                    'codepen',
                    'delicious',
                    'deviantart',
                    'digg',
                    'dribbble',
                    'elementor',
                    'facebook',
                    'flickr',
                    'foursquare',
                    'free-code-camp',
                    'github',
                    'gitlab',
                    'houzz',
                    'instagram',
                    'jsfiddle',
                    'linkedin',
                    'medium',
                    'meetup',
                    'mix',
                    'mixcloud',
                    'odnoklassniki',
                    'pinterest',
                    'product-hunt',
                    'reddit',
                    'skype',
                    'slideshare',
                    'snapchat',
                    'soundcloud',
                    'mixcloud',
                    'spotify',
                    'stack-overflow',
                    'steam',
                    'telegram',
                    'tripadvisor',
                    'tumblr',
                    'twitch',
                    'twitter',
                    'viber',
                    'vimeo',
                    'vk',
                    'weibo',
                    'weixin',
                    'whatsapp',
                    'wordpress',
                    'xing',
                    'yelp',
                    'youtube',
                    '500px',
                    'bitcoin',
                    'monero',
                    'centercode',
                    'creative-commons-share',
                    'font-awesome-flag',
                    'playstation',
                    'pagelines',
                    'cloudsmith',
                    'cloudscale',
                    'cloudversify',
                    "ussunnah",
                    "stack-exchange"
               ];
               options[1] = 'fa';
          } else if(options[0] == 'dashicons') {
               icons = [
                    "blank",	// there is no "blank" but we need the option
                    "menu",
                    "admin-site",
                    "dashboard",
                    "admin-media",
                    "admin-page",
                    "admin-comments",
                    "admin-appearance",
                    "admin-plugins",
                    "admin-users",
                    "admin-tools",
                    "admin-settings",
                    "admin-network",
                    "admin-generic",
                    "admin-home",
                    "admin-collapse",
                    "admin-links",
                    "format-links",
                    "admin-post",
                    "format-standard",
                    "format-image",
                    "format-gallery",
                    "format-audio",
                    "format-video",
                    "format-chat",
                    "format-status",
                    "format-aside",
                    "format-quote",
                    "welcome-write-blog",
                    "welcome-edit-page",
                    "welcome-add-page",
                    "welcome-view-site",
                    "welcome-widgets-menus",
                    "welcome-comments",
                    "welcome-learn-more",
                    "image-crop",
                    "image-rotate-left",
                    "image-rotate-right",
                    "image-flip-vertical",
                    "image-flip-horizontal",
                    "undo",
                    "redo",
                    "editor-bold",
                    "editor-italic",
                    "editor-ul",
                    "editor-ol",
                    "editor-quote",
                    "editor-alignleft",
                    "editor-aligncenter",
                    "editor-alignright",
                    "editor-insertmore",
                    "editor-spellcheck",
                    "editor-distractionfree",
                    "editor-kitchensink",
                    "editor-underline",
                    "editor-justify",
                    "editor-textcolor",
                    "editor-paste-word",
                    "editor-paste-text",
                    "editor-removeformatting",
                    "editor-video",
                    "editor-customchar",
                    "editor-outdent",
                    "editor-indent",
                    "editor-help",
                    "editor-strikethrough",
                    "editor-unlink",
                    "editor-rtl",
                    "align-left",
                    "align-right",
                    "align-center",
                    "align-none",
                    "lock",
                    "calendar",
                    "visibility",
                    "post-status",
                    "post-trash",
                    "edit",
                    "trash",
                    "arrow-up",
                    "arrow-down",
                    "arrow-left",
                    "arrow-right",
                    "arrow-up-alt",
                    "arrow-down-alt",
                    "arrow-left-alt",
                    "arrow-right-alt",
                    "arrow-up-alt2",
                    "arrow-down-alt2",
                    "arrow-left-alt2",
                    "arrow-right-alt2",
                    "leftright",
                    "sort",
                    "list-view",
                    "exerpt-view",
                    "share",
                    "share1",
                    "share-alt",
                    "share-alt2",
                    "twitter",
                    "rss",
                    "facebook",
                    "facebook-alt",
                    "networking",
                    "googleplus",
                    "hammer",
                    "art",
                    "migrate",
                    "performance",
                    "wordpress",
                    "wordpress-alt",
                    "pressthis",
                    "update",
                    "screenoptions",
                    "info",
                    "cart",
                    "feedback",
                    "cloud",
                    "translation",
                    "tag",
                    "category",
                    "yes",
                    "no",
                    "no-alt",
                    "plus",
                    "minus",
                    "dismiss",
                    "marker",
                    "star-filled",
                    "star-half",
                    "star-empty",
                    "flag",
                    "location",
                    "location-alt",
                    "camera",
                    "images-alt",
                    "images-alt2",
                    "video-alt",
                    "video-alt2",
                    "video-alt3",
                    "vault",
                    "shield",
                    "shield-alt",
                    "search",
                    "slides",
                    "analytics",
                    "chart-pie",
                    "chart-bar",
                    "chart-line",
                    "chart-area",
                    "groups",
                    "businessman",
                    "id",
                    "id-alt",
                    "products",
                    "awards",
                    "forms",
                    "portfolio",
                    "book",
                    "book-alt",
                    "download",
                    "upload",
                    "backup",
                    "lightbulb",
                    "smiley"
               ];
               options[1] = 'dashicons';
          } else {
                icons = [
                    "blank",
                    "standard",
                    "aside",
                    "image",
                    "gallery",
                    "video",
                    "status",
                    "quote",
                    "link",
                    "chat",
                    "audio",

                    /* Social icons */
                    "github",
                    "dribbble",
                    "twitter",
                    "facebook",
                    "facebook-alt",
                    "wordpress",
                    "googleplus",
                    "linkedin",
                    "linkedin-alt",
                    "pinterest",
                    "pinterest-alt",
                    "flickr",
                    "vimeo",
                    "youtube",
                    "tumblr",
                    "instagram",
                    "codepen",
                    "polldaddy",
                    "googleplus-alt",
                    "path",
                    "skype",
                    "digg",
                    "reddit",
                    "stumbleupon",
                    "pocket",

                    /* Meta icons */
                    "comment",
                    "category",
                    "tag",
                    "time",
                    "user",
                    "day",
                    "week",
                    "month",
                    "pinned",

                    /* Other icons */
                    "search",
                    "unzoom",
                    "zoom",
                    "show",
                    "hide",
                    "close",
                    "close-alt",
                    "trash",
                    "star",
                    "home",
                    "mail",
                    "edit",
                    "reply",
                    "feed",
                    "warning",
                    "share",
                    "attachment",
                    "location",
                    "checkmark",
                    "menu",
                    "refresh",
                    "minimize",
                    "maximize",
                    "404",
                    "spam",
                    "summary",
                    "cloud",
                    "key",
                    "dot",
                    "next",
                    "previous",
                    "expand",
                    "collapse",
                    "dropdown",
                    "dropdown-left",
                    "top",
                    "draggable",
                    "phone",
                    "send-to-phone",
                    "plugin",
                    "cloud-download",
                    "cloud-upload",
                    "cloud-upload-alt",
                    "external",
                    "document",
                    "book",
                    "cog",
                    "unapprove",
                    "cart",
                    "pause",
                    "stop",
                    "skip-back",
                    "skip-ahead",
                    "play",
                    "tablet",
                    "send-to-tablet",
                    "info",
                    "notice",
                    "help",
                    "fastforward",
                    "rewind",
                    "portfolio",
                    "heart",
                    "code",
                    "subscribe",
                    "unsubscribe",
                    "subscribed",
                    "reply-alt",
                    "reply-single",
                    "flag",
                    "print",
                    "lock",
                    "bold",
                    "italic",
                    "picture",

                    /* Generic shapes */
                    "uparrow",
                    "rightarrow",
                    "downarrow",
                    "leftarrow"
               ];
               options[1] = 'genericon';
            }
            ;
        };
        font_set();

        function build_list($popup, $button, clear) {
            $list = $popup.find('.icon-picker-list');
            if (clear == 1) {
                $list.empty(); // clear list //
            }
            for (var i in icons) {
                $list.append('<li data-icon="' + icons[i] + '"><a href="#" title="' + icons[i] + '"><span class="' + options[0] + ' ' + options[1] + '-' + icons[i] + '"></span></a></li>');
            };
            $('a', $list).on('click',function (e) {
                e.preventDefault();
                var title = $(this).attr("title");
                $target.val(options[0] + "|" + options[1] + "-" + title);
                $button.removeClass().addClass("button icon-picker " + options[0] + " " + options[1] + "-" + title);
                removePopup();
            });
        };

        function removePopup() {
            $(".icon-picker-container").remove();
        }


        $button = $('.icon-picker');
        $button.each(function () {
            $(this).on('click.iconPicker', function () {
                createPopup($(this));
            });
        });


        function createPopup($button) {
            $target = $($button.data('target'));
            $popup = $('<div class="icon-picker-container"><div class="icon-picker-control"></div><ul class="icon-picker-list"><ul></div>')
                .css({
                    'top': $button.offset().top,
                    'left': $button.offset().left
                });
            build_list($popup, $button, 0);
            var $control = $popup.find('.icon-picker-control');
            $control.html('<p><select><option value="fas">Font Awesome Solid</option><option value="fab">Font Awesome Brand</option><option value="dashicons">Dashicons</option><option value="genericon">Genericons</option></select></p>' +
                '<a data-direction="back" href="#"><span class="dashicons dashicons-arrow-left-alt2"></span></a> ' +
                '<input type="text" class="" placeholder="Search" />' +
                '<a data-direction="forward" href="#"><span class="dashicons dashicons-arrow-right-alt2"></span></a>' +
                '');

            $('select', $control).on('change', function (e) {
                e.preventDefault();
                if (this.value != options[0]) {
                    options[0] = this.value;
                    font_set();
                    build_list($popup, $button, 1);
                }
                ;
            });

            $('a', $control).on('click',function (e) {
                e.preventDefault();
                if ($(this).data('direction') === 'back') {
                    //move last 25 elements to front
                    $('li:gt(' + (icons.length - 26) + ')', $list).each(function () {
                        $(this).prependTo($list);
                    });
                } else {
                    //move first 25 elements to the end
                    $('li:lt(25)', $list).each(function () {
                        $(this).appendTo($list);
                    });
                }
            });

            $popup.appendTo('body').show();

            $('input', $control).on('keyup', function (e) {
                var search = $(this).val();
                if (search === '') {
                    //show all again
                    $('li:lt(25)', $list).show();
                } else {
                    $('li', $list).each(function () {
                        if ($(this).data('icon').toString().toLowerCase().indexOf(search.toLowerCase()) !== -1) {
                            $(this).show();
                        } else {
                            $(this).hide();
                        }
                    });
                }
            });


            $(document).on('mouseup',function (e) {
                if (!$popup.is(e.target) && $popup.has(e.target).length === 0) {
                    removePopup();
                }
            });
        }
    }


    $(function () {
        $('.icon-picker').iconPicker();
    });

}(jQuery));
