<?php
/**
 * Show error messages
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/notices/error.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.3.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! $messages ) {
	return;
}

?>

<div class="sh-alert sh-alert-error sh-alert-with-line">
	<div class="sh-alert-data sh-table">
		<div class="sh-alert-icon-container sh-table-cell sh-alert-data-icon">
			<i class="icon-info sh-alert-icon"></i>
		</div>
		<div class="sh-alert-title-container sh-table-cell width-full">
			<h3 class="sh-alert-title">
				<?php foreach ( $messages as $message ) : ?>
				<div><?php echo wp_kses_post( $message ); ?></div>
				<?php endforeach; ?>
			</h3>
		</div>
	</div>
</div>
