<?php
/**
 * Block Layout - Mini
 *
 * This template can be overridden by copying it to your-child-theme/templates/loops/loop-mini.php.
 *
 * HOWEVER, on occasion TieLabs will need to update template files and you
 * will need to copy the new files to your child theme to maintain compatibility.
 *
 * @author   TieLabs
 * @version  2.1.0
 */

defined( 'ABSPATH' ) || exit; // Exit if accessed directly


# Set custom class for the post without thumb
$no_thumb = ( ! has_post_thumbnail() || ! empty( $block['thumb_all'] )) ? 'no-small-thumbs' : '';

?>

<li <?php tie_post_class( 'post-item '.$no_thumb ); ?>>

	<?php

		# Get the Post Meta info
		if( ! empty( $block['post_meta'] )){
			tie_the_post_meta( array( 'trending' => true, 'author' => false, 'comments' => false, 'review' => true ) );
		}

	?>

	<h3 class="post-title"><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php tie_the_title( $block['title_length'] ); ?></a></h3>

	<?php

		# Get the post thumbnail
		if ( has_post_thumbnail() && empty( $block['thumb_all'] ) ){

			tie_post_thumbnail( TIELABS_THEME_SLUG.'-image-small', false );
		}


		if( ! empty( $block['excerpt'] )){ ?>
			<div class="post-details">
				<p class="post-excerpt"><?php tie_the_excerpt( $block['excerpt_length'] ) ?></p>
			</div>
			<?php
		}

	?>

</li>
