<?php
/**
 * Dashboard Notices
 *
 */

defined( 'ABSPATH' ) || exit; // Exit if accessed directly

//Debug
//update_user_meta( get_current_user_id(), 'dismissed_wp_pointers', '' );
//delete_transient( 'tie_milestone_check' );


/*-----------------------------------------------------------------------------------*/
# Enqueue the pointers styles and scripts
/*-----------------------------------------------------------------------------------*/
add_action( 'admin_enqueue_scripts', 'tie_add_theme_notices' );
function tie_add_theme_notices(){

	# Check if current page is the theme options page
	$current_page = ! empty( get_current_screen()->tiebase ) ? get_current_screen()->tiebase : '';

	if ( $current_page != 'toplevel_page_tie-theme-options' ){
		return;
	}


	# Need Help pointer
	if( ! tie_notice_is_dismissed( 'tie_need_help_'. TIELABS_THEME_SLUG ) ){

		add_action( 'admin_print_footer_scripts', 'tie_pointer_need_help_script' );
		wp_enqueue_style ( 'wp-pointer' );
		wp_enqueue_script( 'wp-pointer' );
	}


	# Happy New Year
	add_action( 'admin_notices', 'tie_notice_happy_new_year', 105 );

	# Happy Customer Day
	add_action( 'admin_notices', 'tie_notice_happy_anniversary', 105 );

	# New Theme Update
	add_action( 'admin_notices', 'tie_notice_new_update', 105 );

	# New Milestone
	add_action( 'admin_notices', 'tie_notice_new_milestone', 105 );

	# Rate The Theme
	add_action( 'admin_notices', 'tie_notice_rate_theme', 105 );

	# Share the theme translations
	add_action( 'admin_notices', 'tie_notice_theme_translation', 105 );

	# Live Message
	add_action( 'admin_notices', 'tie_notice_live_message', 105 );
}





/*-----------------------------------------------------------------------------------*/
# Rate the theme
/*-----------------------------------------------------------------------------------*/
function tie_pointer_need_help_script(){
	$pointer_content  = '<h3>'. esc_html__( 'Need Help?', TIELABS_TEXTDOMAIN ) .'</h3>';
	$pointer_content .= '<p>'. sprintf( esc_html__( 'Click on the help icon %s if you need help.', TIELABS_TEXTDOMAIN ), '<span class="dashicons dashicons-editor-help"></span>' ) .'</p>'; ?>

	<script>
		//<![CDATA[
		jQuery(document).ready( function($){
			$('#help-icon-general-settings-tab').pointer({
				content: '<?php echo wp_kses_post( $pointer_content ); ?>',
				pointerWidth:	350,
				position: {
					edge : 'top',
					align: 'middle',
				},
				close: function(){
					$.post( ajaxurl, {
						pointer: 'tie_need_help_<?php echo esc_js( TIELABS_THEME_SLUG ) ?>',
						action : 'dismiss-wp-pointer',
					});
				}
			}).pointer('open');
		});
		//]]>
	</script>
	<?php
}





/*-----------------------------------------------------------------------------------*/
# Happy New Year :)
/*-----------------------------------------------------------------------------------*/
function tie_notice_happy_new_year(){

	$new_year_dates  = tie_get_new_year_number();
	$notice_id = 'tie_happy_new_year_'.$new_year_dates['the_new_year'];

	if ( ! tie_notice_is_dismissed( $notice_id ) && ( $new_year_dates['today_date'] >= $new_year_dates['first_congrats_day'] || $new_year_dates['today_date'] < $new_year_dates['last_congrats_day'] ) ){

		if( tie_notice_is_hooked() ){
			return false;
		}

		$notice_content  = '<h4>'. esc_html__( 'Happy New Year!', TIELABS_TEXTDOMAIN ) .'</h4>';
		$notice_content .= '<p>'. esc_html__( 'To our client who have made our progress possible, All of us at TieLabs join in wishing you a Happy New Year with the best of everything in your life for you and your family and we look forward to serving you in the new year :)', TIELABS_TEXTDOMAIN ) .'</p>';
		$notice_content .= '<p>'. sprintf(
			esc_html__( 'Follow us on %1$sTwitter%3$s or %2$sFacebook%3$s.', TIELABS_TEXTDOMAIN ),
			'<a href="http://twitter.com/tielabs" target="_blank">',
			'<a href="https://www.facebook.com/tielabs" target="_blank">',
			'</a>'
		) .'</p>';

		echo '<div id="tie-page-overlay" class="is-notice-dismissible" data-id="'. $notice_id .'" style="bottom: 0; opacity: 0.8;"></div>';

		tie_admin_notice_message( array(
			'notice_id' => $notice_id,
			'title'     => '&#x1f38a;',
			'message'   => $notice_content,
			'class'     => 'sucess tie-popup-block tie-popup-window tie-notice-popup tie-yay',
		));
	}
}





/*-----------------------------------------------------------------------------------*/
# Rate the Theme
/*-----------------------------------------------------------------------------------*/
function tie_notice_rate_theme(){

	$notice_id = 'tie_install_date_'. TIELABS_THEME_ID;

	if ( tie_notice_is_dismissed( $notice_id ) || tie_is_theme_rated() ){
		return false;
	}

	# There is any popup ? if no set it to TRUE
	if( tie_pop_notice_is_hooked() ){
		return false;
	}


	if( ! get_option( $notice_id ) ){

		update_option( $notice_id, time() );
	}
	else{

		if( ( time() - get_option( $notice_id ) ) < ( 2 * MONTH_IN_SECONDS ) ){
			return false;
		}

		$notice_content  = '<h4>'. sprintf( esc_html__( 'Like %s?', TIELABS_TEXTDOMAIN ), apply_filters( 'TieLabs/theme_name', 'TieLabs' ) ) .'</h4>';
		$notice_content .= sprintf(
			esc_html__( 'We\'ve noticed you\'ve been using %1$s for some time now; we hope you love it! We\'d be thrilled if you could %2$sgive us a 5* rating on themeforest.net!%4$s If you are experiencing issues, please %3$sopen a support ticket%4$s and we\'ll do our best to help you out.', TIELABS_TEXTDOMAIN ),
			apply_filters( 'TieLabs/theme_name', 'TieLabs' ),
			'<a href="'. tie_get_purchase_link( array( 'utm_medium' => 'rate-popup' ) ) .'" target="_blank">',
			'<a href="'. apply_filters( 'TieLabs/External/open_ticket', '' ) .'" target="_blank">',
			'</a>'
		);

		echo '<div id="tie-page-overlay" class="is-notice-dismissible" data-id="'. $notice_id .'" style="bottom: 0; opacity: 0.8;"></div>';

		tie_admin_notice_message( array(
			'notice_id' => $notice_id,
			'title'     => '&#x2b50;',
			'message'   => $notice_content,
			'class'     => 'sucess tie-popup-block tie-popup-window tie-notice-popup tie-yay',
		));
	}


}





/*-----------------------------------------------------------------------------------*/
# Share the Theme Translations
/*-----------------------------------------------------------------------------------*/
function tie_notice_theme_translation(){

	$locale = get_locale();
	$notice_id = 'tie_translate_'.$locale.'_'.TIELABS_THEME_ID;

	// Don't show the message if the site's language is English
	if( strpos( $locale, 'en_' ) !== false ){
		return false;
	}

	// Show the Message after 3 days of installing the theme
	if( get_option( 'tie_install_date_'. TIELABS_THEME_ID ) && ( time() - get_option( 'tie_install_date_'. TIELABS_THEME_ID) ) < ( 3 * DAY_IN_SECONDS ) ){
		return false;
	}

	$remote_languages  = tie_get_latest_theme_data( 'translations' );
	$translation_meter = ! empty( $remote_languages[ $locale ] ) ? str_replace( '%', '', $remote_languages[ $locale ] ) : 0;

	if( empty( $remote_languages ) || $translation_meter > 95 ){
		return false;
	}

	if ( tie_notice_is_dismissed( $notice_id ) ){
		return false;
	}

	// Prepare the Meter
	if( ! function_exists( 'wp_get_available_translations' ) ){
		require_once( ABSPATH . 'wp-admin/includes/translation-install.php' );
	}

	$translations = wp_get_available_translations();
	$native_name  = ! empty( $translations[ $locale ]['native_name'] ) ? $translations[ $locale ]['native_name'] : $translations[ $locale ]['english_name'];

	// The Message
	$notice_content = '<p>'.
	sprintf(
		esc_html__( '%1s comes localization-ready out of the box. All that’s needed is a translation file for your language, Contribute in our translation portal to complete the %2s translation, In exchange, we offer %3sExtra 6 Months FREE TieLabs Support*%4s to the most 3 contributors for each completed translation. Thank you very much for your contribution.', TIELABS_TEXTDOMAIN ),
		apply_filters( 'TieLabs/theme_name', 'TieLabs' ),
		$native_name,
		'<strong>',
		'</strong>'
	) .'</p>';


	$notice_content .= '
		<div class="translations-meter-outer">
			<span style="width:'. $translation_meter .'%"></span>'.
			sprintf( esc_html__( '%1s Translation Status: %2s Done', TIELABS_TEXTDOMAIN ), $native_name, '<strong>'. $translation_meter .'%</strong>') .'
		</div>
	';

	$notice_content .= '<em><small>'. esc_html__( '* The extra support will appear in your profile on our website, support center and in the theme dashboared only. it will not appear on ThemeForest.', TIELABS_TEXTDOMAIN ) .'</small></em><div class="clearfix"></div>';

	tie_admin_notice_message( array(
		'notice_id'   => $notice_id,
		'title'       => esc_html__( 'Get Extra FREE 6 Months Support period', TIELABS_TEXTDOMAIN ),
		'message'     => $notice_content,
		'color'       => '#A770EF',
		'button_text' => esc_html__( 'Go to the Translation Portal', TIELABS_TEXTDOMAIN ),
		'button_url'  => apply_filters( 'TieLabs/translations_panel_url', '' ),
	));
}





/*-----------------------------------------------------------------------------------*/
# New Theme Update
/*-----------------------------------------------------------------------------------*/
function tie_notice_new_update(){

	$notice_id = 'tie_new_updates_'. TIELABS_THEME_ID;

	if ( ! tie_notice_is_dismissed( $notice_id ) && $changelog = get_option( 'tie_chnagelog_'. TIELABS_THEME_ID ) ){


		# There is any popup ? if no set it to TRUE
		if( tie_pop_notice_is_hooked() ){
			return false;
		}

		$changelog       = array_filter( explode( PHP_EOL, $changelog ),  'strlen' );
		$notice_content  = '<h4>'. esc_html__( 'YAY, New Features', TIELABS_TEXTDOMAIN ) .'</h4>';
		$notice_content .= '<ul><li><span class="dashicons dashicons-yes"></span> '. implode( '</li><li> <span class="dashicons dashicons-yes"></span> ', $changelog ) . '</li></ul>';


		# If the Customer already rated the theme and the rate is > 3 hide the rate button
		if( ! tie_is_theme_rated() ){

			$notice_content .= '<span class="awesome">'. esc_html__( 'Awesome, isn\'t it? Give us some love :)', TIELABS_TEXTDOMAIN ) .'</span>';
			$button_text     = sprintf( esc_html__( 'Rate %s', TIELABS_TEXTDOMAIN ), apply_filters( 'TieLabs/theme_name', 'TieLabs' ) );
		}

		echo '<div id="tie-page-overlay" class="is-notice-dismissible" data-id="'. $notice_id .'" style="bottom: 0; opacity: 0.8;"></div>';

		tie_admin_notice_message( array(
			'notice_id'   => $notice_id,
			'title'       => '&#x1F389;',
			'message'     => $notice_content,
			'class'       => 'sucess tie-popup-block tie-popup-window tie-notice-popup tie-yay',
			'button_text' => ! empty( $button_text ) ? $button_text : false,
			'button_url'  => tie_get_purchase_link( array( 'utm_source' => 'theme-update', 'utm_medium' => 'button' ) ),
			'button_class'=> 'green',
		));
	}

}





/*-----------------------------------------------------------------------------------*/
# New Theme Update
/*-----------------------------------------------------------------------------------*/
function tie_notice_new_milestone(){

	# Let's make this check every 2 weeks
	if( false !== get_transient( 'tie_milestone_check' ) ){
		return false;
	}

	# There is any popup ? if no set it to TRUE
	if( tie_pop_notice_is_hooked() ){
		return false;
	}

	$miles_range = array( 10000000, 5000000, 2000000, 1000000, 500000, 100000, 25000, 10000 );
	$notice_base = 'tie_milestones';
	$milestone   = false;

	# Check the number of follwers
	if( class_exists( 'ARQAM_LITE_COUNTERS' ) || function_exists( 'arq_counters_data' ) ){

		$milestone_type = 'followers';
		$notice_title   = '&#x1F3C6;';
		$notice_desc    = esc_html__( 'Followers', TIELABS_TEXTDOMAIN );

		# Get the followers data
		$arq_counters = get_option( 'arq_options' );

		if( ! empty( $arq_counters['data'] ) && is_array( $arq_counters['data'] ) ){

			$number = array_sum( $arq_counters['data'] );

			# Do we get a number? Let's check if it is a milestone
			if( ! empty( $number ) && ! is_wp_error( $number ) ){
				foreach ( $miles_range as $value ) {
					if( $number >= $value ){

						$milestone = ( $value >= 1000000 ) ? ( $value/1000000 ).'M' : ( $value/1000 ).'K';
						break;
					}
				}
			}

			# Let's check if we showed this before
			if( ! empty( $milestone ) ){

				$the_number = sprintf( esc_html__( '%s Followers', TIELABS_TEXTDOMAIN ), $milestone );

				$notice_id = strtolower( $notice_base .'_'. $milestone_type .'_'. $milestone );

				if( tie_notice_is_dismissed( $notice_id ) ){
					$milestone = false;
				}
			}
		}
	}


	# Check if the Post Views is active
	if( tie_get_option( 'tie_post_views' ) == 'theme' && ! $milestone ){

		$milestone_type = 'views';
		$notice_title   = '&#128079;';
		$notice_desc    = esc_html__( 'Total Articles\' Views!', TIELABS_TEXTDOMAIN );

		# Let's Sum all post views for all posts
		global $wpdb;
		$number = $wpdb->get_var( $wpdb->prepare( " SELECT sum(meta_value) FROM $wpdb->postmeta WHERE meta_key = %s", apply_filters( 'TieLabs/views_meta_field', 'tie_views' ) ) );

		# Do we get a number? Let's check if it is a milestone
		if( ! empty( $number ) && ! is_wp_error( $number ) ){
			foreach ( $miles_range as $value ) {
				if( $number >= $value ){
					$milestone = ( $value > 1000000 ) ? ( $value/1000000 ).'M' : ( $value/1000 ).'K';
					break;
				}
			}
		}

		# Let's check if we showed this before
		if( ! empty( $milestone ) ){

			$the_number = sprintf( esc_html__( '%s articles views', TIELABS_TEXTDOMAIN ), $milestone );

			$notice_id = strtolower( $notice_base .'_'. $milestone_type .'_'. $milestone );

			if( tie_notice_is_dismissed( $notice_id ) ){
				$milestone = false;
			}
		}
	}


	# Let's make this check every 2 weeks
	set_transient( 'tie_milestone_check', 'true', 2 * WEEK_IN_SECONDS );


	# No Milestones yet :(
	if( ! $milestone ){
		return;
	}

	# The Notice message
	$the_message     = sprintf( esc_html__( 'We just reached the %s milestone! We are taking this moment to give YOU a big THANK YOU for all the support and confidence you gave us.', TIELABS_TEXTDOMAIN ), $the_number ) .' #milestone';
	$notice_content  = '<h4>'. esc_html__( 'New Milestone', TIELABS_TEXTDOMAIN ) .'</h4>';
	$notice_content .= '<div class="milestone-number">'. $milestone .'</div>';
	$notice_content .= '<div class="milestone-desc">'. $notice_desc .'</div>';
	$notice_content .= '<a class="tie-primary-button button button-primary tweet-milestone button-hero" target="_blank" href="https://twitter.com/intent/tweet?text='. urlencode( $the_message ).'&amp;url='. esc_url(home_url( '/' )) .'"><span class="dashicons dashicons-twitter"></span> '. esc_html__( 'Spread The Word', TIELABS_TEXTDOMAIN ) .'</a>';

	# If the Customer already rated the theme and the rate is > 3 hide the rate button
	if( ! tie_is_theme_rated() ){
		$notice_content .= '<span class="awesome">'. esc_html__( 'Awesome, isn\'t it? Give us some love :)', TIELABS_TEXTDOMAIN ) .'</span>';
		$button_text     = sprintf( esc_html__( 'Rate %s', TIELABS_TEXTDOMAIN ), apply_filters( 'TieLabs/theme_name', 'TieLabs' ) );
	}

	echo '
		<div id="tie-page-overlay" class="is-notice-dismissible" data-id="'. $notice_id .'" style="bottom: 0; opacity: 0.8;">
			<div class="snowflakes" aria-hidden="true">
				<div class="snowflake"></div><div class="snowflake"></div><div class="snowflake"></div><div class="snowflake"></div><div class="snowflake"></div>
				<div class="snowflake"></div><div class="snowflake"></div><div class="snowflake"></div><div class="snowflake"></div><div class="snowflake"></div>
			</div>
		</div>
	';

	tie_admin_notice_message( array(
		'notice_id'   => $notice_id,
		'title'       => $notice_title,
		'message'     => $notice_content,
		'class'       => 'sucess tie-popup-block tie-popup-window tie-notice-popup tie-yay',
		'button_text' => ! empty( $button_text ) ? $button_text : false,
		'button_url'  => tie_get_purchase_link( array( 'utm_source' => 'theme-milestone', 'utm_medium' => 'button' ) ),
		'button_class'=> 'green',
	));

}





/*-----------------------------------------------------------------------------------*/
# Happy Customer
/*-----------------------------------------------------------------------------------*/
function tie_notice_happy_anniversary(){

	$current_year = date( 'y' );
	$notice_id    = 'tie_happy_anniversary_'.$current_year;

	if ( tie_notice_is_dismissed( $notice_id ) ){
		return false;
	}

	$customer_since = tie_get_latest_theme_data( 'customer_since' );

	if( ! empty( $customer_since )){
		$customer_month = date( 'n', strtotime( $customer_since ) );
		$customer_year  = date( 'y', strtotime( $customer_since ) );
		$current_month  = date( 'n' );

		if( $current_month == $customer_month && $customer_year < $current_year ){

			if( tie_notice_is_hooked() !== false ){
				return false;
			}

			$number_of_years = $current_year - $customer_year;
			$years_text = sprintf( _n( '%d year', '%d years', $number_of_years, TIELABS_TEXTDOMAIN ), $number_of_years );

			$notice_content  = '<h4>'. esc_html__( 'Happy Anniversary with TieLabs!', TIELABS_TEXTDOMAIN ) .'</h4>';
			$notice_content .= '<p>'. sprintf( esc_html__( 'Woohoo! We are so happy You have been with us for %s We are looking forward to providing an awesome WordPress theme and plugins for you for many more. Thanks for being an awesome customer!', TIELABS_TEXTDOMAIN ), $years_text ) .'</p>';
			$notice_content .= '<p>'. esc_html__( 'Your friends at TieLabs', TIELABS_TEXTDOMAIN ) .'</p>';

			echo '<div id="tie-page-overlay" class="is-notice-dismissible" data-id="'. $notice_id .'" style="bottom: 0; opacity: 0.8;"></div>';

			tie_admin_notice_message( array(
				'notice_id' => $notice_id,
				'title'     => '<img src="'.TIELABS_TEMPLATE_URL. '/framework/admin/assets/images/badges/'. $number_of_years .'.png" alt="" />',
				'class'     => 'sucess tie-popup-block tie-popup-window tie-notice-popup tie-yay',
				'message'   => $notice_content,
			));
		}
	}
}





/*-----------------------------------------------------------------------------------*/
# Live Message
/*-----------------------------------------------------------------------------------*/
function tie_notice_live_message(){

	$data  = tie_get_latest_theme_data( 'message' );
	$today = strtotime( date('Y-m-d') );

	if( ! empty( $data ) && is_array( $data ) && ! empty( $data['notice_id'] ) && ! tie_notice_is_dismissed( $data['notice_id'] ) ){

		if( tie_notice_is_hooked() ){
			return false;
		}

		// Start date
		if( ! empty( $data['start_date'] )){
			$start_date = strtotime( $data['start_date'] );

			if( $start_date > $today ){
				return false;
			}
		}


		// Expire date
		if( ! empty( $data['expire_date'] )){
			$expire_date = strtotime( $data['expire_date'] );

			if( $expire_date <= $today ){
				return false;
			}
		}

		tie_admin_notice_message( $data );
	}

}





/*-----------------------------------------------------------------------------------*/
# Get the new year dates
/*-----------------------------------------------------------------------------------*/
function tie_get_new_year_number(){

	$dates = array(
		'today_date'         => time(),
		'first_congrats_day' => mktime( 0, 0, 0, 12, 25 ),
		'last_congrats_day'  => mktime( 0, 0, 0, 1, 5 ),
		'first_dat_new_year' => mktime( 0, 0, 0, 1, 1 ),
		'the_new_year'       => date( 'Y' )+1,
	);

	if( $dates['today_date'] >= $dates['first_dat_new_year'] && $dates['today_date'] < $dates['last_congrats_day'] ){
		$dates['the_new_year'] = date( 'Y' );
	}

	return $dates;
}





/*-----------------------------------------------------------------------------------*/
# Check dismissed notices
/*-----------------------------------------------------------------------------------*/
function tie_notice_is_dismissed( $name ){

	$dismissed_pointers = explode( ',', get_user_meta( get_current_user_id(), 'dismissed_wp_pointers', true ));

	if( in_array( $name, $dismissed_pointers ) ){
		return true;
	}

	return false;
}





/*-----------------------------------------------------------------------------------*/
# Check if already there is a notice message
/*-----------------------------------------------------------------------------------*/
function tie_notice_is_hooked(){

	if( isset( $GLOBALS['tie_page_has_notice'] ) ){
		return true;
	}

	$GLOBALS['tie_page_has_notice'] = true;

	return false;
}





/*-----------------------------------------------------------------------------------*/
# Check if already there is a pop notice message
/*-----------------------------------------------------------------------------------*/
function tie_pop_notice_is_hooked(){

	if( isset( $GLOBALS['tie_page_has_pop_notice'] ) ){
		return true;
	}

	$GLOBALS['tie_page_has_pop_notice'] = true;

	return false;
}





/*-----------------------------------------------------------------------------------*/
# Notices
/*-----------------------------------------------------------------------------------*/
function tie_admin_notice_message( $args = array() ){

	$defaults = array(
		'notice_id'      => '',
		'title'          => esc_html__( 'Howdy', TIELABS_TEXTDOMAIN ),
		'img'            => false,
		'message'        => '',
		'dismissible'    => true,
		'color'          => '',
		'class'          => '',
		'standard'       => true,
		'button_text'    => '',
		'button_class'   => '',
		'button_url'     => '',
		'button_2_text'  => '',
		'button_2_class' => '',
		'button_2_url'   => '',
	);

	$args = wp_parse_args( $args, $defaults );


	if( ! empty( $args['color'] ) ){
		$args['color'] = 'background-color:'. $args['color'];
	}

	if( $args['class'] ){
		$args['class'] = 'tie-'. $args['class'];
	}

	if( $args['standard'] ){
		$args['class'] .= ' notice';
	}

	if( $args['dismissible'] ){
		$args['class'] .= ' is-dismissible';
	}

	if( ! empty( $args['button_class'] ) ){
		$args['button_class'] = 'tie-button-'. $args['button_class'];
	}

	if( ! empty( $args['button_2_class'] ) ){
		$args['button_2_class'] = 'tie-button-'. $args['button_2_class'];
	}

	?>

	<div id="<?php echo esc_attr( $args['notice_id'] ) ?>" class="tie-notice <?php echo esc_attr( $args['class'] ); ?>">
		<h3 style="<?php echo esc_attr( $args['color'] ); ?>"><?php echo wp_kses_post( $args['title'] ) ?></h3>

		<div class="tie-notice-content">

			<?php
			if( ! empty( $args['img'] ) ){ ?>
				<img src="<?php echo esc_attr( $args['img'] ); ?>" class="tie-notice-img" alt="">
				<?php
			}
			?>

			<?php

				if( strpos( $args['message'], '<p>' ) === false ){
					$args['message'] = '<p>'. $args['message'] .'</p>';
				}

				echo wp_kses_post( $args['message'] );

			?>

			<?php
			if( ! empty( $args['button_text'] ) ){ ?>
				<a class="tie-primary-button button button-primary button-hero <?php echo esc_attr( $args['button_class'] ) ?>" href="<?php echo esc_url( $args['button_url'] ) ?>"><?php echo esc_html( $args['button_text'] ) ?></a>
				<?php
			}
			?>

			<?php
			if( ! empty( $args['button_2_text'] ) ){ ?>
				<a class="tie-primary-button button button-primary button-hero <?php echo esc_attr( $args['button_2_class'] ) ?>" href="<?php echo esc_url( $args['button_2_url'] ) ?>"><?php echo esc_html( $args['button_2_text'] ) ?></a>
				<?php
			}
			?>

		</div>
	</div>

	<?php
}
