<?php

if( ! class_exists( 'TIE_LOGIN_WIDGET' )){

	/**
	 * Widget API: TIE_LOGIN_WIDGET class
	 */
	 class TIE_LOGIN_WIDGET extends WP_Widget {


		public function __construct(){
			$widget_ops = array( 'classname' => 'login-widget'  );
			parent::__construct( 'login-widget', JANNAH_THEME_NAME .' - '.esc_html__( 'Log In', 'jannah'), $widget_ops );
		}

		/**
		 * Outputs the content for the widget instance.
		 */
		public function widget( $args, $instance ){

			/** This filter is documented in wp-includes/widgets/class-wp-widget-pages.php */
			$instance['title'] = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );

			echo ( $args['before_widget'] );

			if ( ! empty($instance['title']) ){
				echo ( $args['before_title'] . $instance['title'] . $args['after_title'] );
			}

			jannah_login_form();

			echo ( $args['after_widget'] );
		}

		/**
		 * Handles updating settings for widget instance.
		 */
		public function update( $new_instance, $old_instance ){
			$instance             = $old_instance;
			$instance['title']    = sanitize_text_field( $new_instance['title'] );
			return $instance;
		}

		/**
		 * Outputs the settings form for the widget.
		 */
		public function form( $instance ){
			$defaults = array( 'title' => esc_html__('Log In', 'jannah')  );
			$instance = wp_parse_args( (array) $instance, $defaults );
			$title    = isset( $instance['title'] ) ? $instance['title'] : '';

			?>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title:', 'jannah') ?></label>
				<input id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" value="<?php echo esc_attr( $title ); ?>" class="widefat" type="text" />
			</p>

		<?php
		}
	}



	/**
	 * Register the widget.
	 */
	add_action( 'widgets_init', 'tie_login_widget_register' );
	function tie_login_widget_register(){
		register_widget( 'TIE_LOGIN_WIDGET' );
	}

}
?>
