<?php
/**
 * Database updates
 *
 * @package Jannah
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


if( $current_version = get_option( 'tie_jannah_ver' ) ){
	if( version_compare( $current_version, JANNAH_DB_VERSION, '<' ) ){


		# ChangeLog ----------
		$changelog = '';


	  # Custom Versions updates ------------------------------------------ */
	  $updated_options = $original_options = get_option( 'tie_jannah_options' );







	  /*
	   * Update to version 1.0.3
	   *
	   * New Option for the AMP
	   */
	  if( version_compare( $current_version, '1.0.3', '<' ) ){

			$updated_options['amp_active'] = 'true';
		}


		/*
	   * Update to version 1.1.0
	   *
	   * Store the total puplished posts number
	   */
	  if( version_compare( $current_version, '1.1.0', '<' ) ){

	  	# Store the posts number needed for th switcher -----------
	  	$count_posts     = wp_count_posts();
			$published_posts = ! empty( $count_posts->publish ) ? $count_posts->publish : 0;
			update_option( 'jannah_published_posts', $published_posts, false );

			# Delete the stored cache to re-update it needed for the switcher ----------
			delete_transient( 'tie-data-'.JANNAH_THEME_FOLDER );

			# Chnagelog ----------
			$changelog .= '
				NEW: Introducing our Jannah Switcher Plugin now you can migrating your posts from 17 themes to Jannah.
				NEW: Option to set a custom RSS feed URL.
				NEW: Option to embed Audio code.
				NEW: Unlimited Source and Via options.
				NEW: Facebook Videos support.
				NEW: Twitter Videos support.
				NEW: Option to set the page as a front page directly from the edit page.
			';
		}


	  /*
	   * Update to version 1.2.0
	   *
	   * Update some options
	   */
	  if( version_compare( $current_version, '1.2.0', '<' ) ){

			$updated_options['schema_type']        = 'Article';
			$updated_options['responsive_tables']  = 'true';

			if( jannah_get_option( 'header_layout' ) == 1 ){

				$updated_options['sticky_logo_type'] = 'true';
				unset( $updated_options['custom_logo_sticky'] );
			}

			# Chnagelog ----------
			$changelog .= "
				New: 3 typography options to customize the posts titles in the sliders.
				NEW: LazyLoad for the Sliders images.
				NEW: LazyLoad for Videos images in the Videos Playlist.
				NEW: Show/Hide the Automatic Featured Image for the standard posts now works on the AMP pages.
				NEW: Added More texts to translations panel.
				NEW: Integration with the Jetpack Stats module.
				NEW: Integration with the WordPress Social Login plugin, now you can use the login social buttons with the theme's Login sections.
				NEW: Integration with the Google Captcha (reCAPTCHA) plugin, now you can add the reCAPTCHA to the theme's Login sections.
				NEW: Responsive in-post tables with an option to disable it in case you want to use a custom plugin.
				NEW: AMP WhatsApp share button.
				NEW: AMP Tumblr share button.
				NEW: AMP SMS share button.
				NEW: The new Audio, Video and Image widgets are now available in the TieLabs Page builder Widgets section.
				NEW: Export and Import module for the theme options.
				NEW: Logo in the Sticky menu for all headers layouts.
				NEW: Option to set a custom sticky logo image.
				NEW: Option to set the number of posts in the Check Also block.
				NEW: 7 Arabic fonts added from FontFace.me.
				NEW: Most viewed Posts for 7 days option in the posts widget.
				NEW: Most viewed Posts for 30 days option in the posts widget.
				NEW: Option to show/hide the MENU text for the mobile menu icon.
				NEW: Help links in the theme options.
				NEW: Add supports for the Private posts in the blocks.
				NEW: Now the theme highlights the primary category only in the main nav.
				NEW: Recommended Plugins section in the Install plugins page.
				NEW: Notice message when a new update is available for a bundled plugin.
				NEW: Add shortcode support for the featured image's caption.
				NEW: Page builder Blocks now shows the child categories posts.
				NEW: Now terms descriptions supports Shortcodes.
				IMPROVED: Changed the Schema default type value of the posts to Article.
				IMPROVED: Tabs Widget backend sortable function.
				IMPROVED: BuddyPress form styles.
				IMPROVED: WooCommerce styles.
				IMPROVED: The LazyLoad image feature of the Avatars.
				IMPROVED: BreadCrumbs support for the CPT.
				IMPROVED: Post views system excludes the bots visits.
			";

		}


	  /*
	   * Update to version 1.3.0
	   *
	   * Update some options
	   */
	  if( version_compare( $current_version, '1.3.0', '<' ) ){

			# Chnagelog ----------
			$changelog .= "
				New: Automatic theme update feature.
				New: Edit Post link in the end of the post.
				New: Button to revoke the theme validation in order to use the license on another domain.
				New: Animated appearance for the Sticky Logo.
				IMPROVED: Lazy Load for in-post images.
				IMPROVED: Mega menu functions.
				IMPROVED: Mega menu and footer custom colors.
				IMPROVED: Sections custom margins in the responsive version.
				IMPROVED: Default Logo margins in the Header Layout 3.
			";

		}





		# Update if the Changelog has items ------------------------------ */
		if( ! empty( $changelog ) ){

			# Store the new data ----------
			update_option( 'jannah_chnagelog', trim( $changelog ), false );

			# Remove the pointer from the dismissed array ----------
			$dismissed = array_filter( explode( ',', (string) get_user_meta( get_current_user_id(), 'dismissed_wp_pointers', true ) ) );
			$pointer   = 'tie_jannah_new_updates';

			if ( in_array( $pointer, $dismissed ) ){
				unset( $dismissed[ array_search( $pointer, $dismissed )] );
			}
			$dismissed = implode( ',', $dismissed );

			update_user_meta( get_current_user_id(), 'dismissed_wp_pointers', $dismissed );
		}


		# Update the New options if it changed ------------------------------ */
		if( $updated_options != $original_options ){
			update_option( 'tie_jannah_options', $updated_options );
		}


		# Update the DB version number ----------
	  update_option( 'tie_jannah_ver', JANNAH_DB_VERSION );


		# Use this action to run functions after updating the theme version ----------
	  do_action( 'jannah_after_db_update' );



	}
}

