<?php

	jannah_theme_option(
		array(
			'title' =>	esc_html__( 'Social Networks', 'jannah' ),
			'id'    => 'social-networks-tab',
			'type'  => 'tab-title',
		));

	jannah_theme_option(
		array(
			'title' => esc_html__( 'Social Networks', 'jannah' ),
			'id'    => 'social-networks',
			'type'  => 'header',
		));

	jannah_theme_option(
		array(
			'name'   => esc_html__( 'RSS', 'jannah' ),
			'id'     => 'rss_icon',
			'type'   => 'checkbox',
			'toggle' => '#social-rss-item'
		));


	$social_array	= jannah_social_networks();

	foreach ( $social_array as $network => $data ){

		$social_data = array(
			'name' => $data['title'],
			'id'   => 'social',
			'key'  => $network,
			'type' => 'arrayText',
		);

		$social_data['hint'] = ! empty( $data['hint'] ) ? $data['hint'] : '';

		jannah_theme_option( $social_data );
	}

	for( $i = 1; $i <= 5; $i++ ){

		jannah_theme_option(
			array(
				'title' => esc_html__( 'Custom Social Network', 'jannah' ),
				'id'    => 'custom-social-network-' . $i ,
				'type'  => 'header',
			));

		jannah_theme_option(
			array(
				'name' => esc_html__( 'Title', 'jannah' ),
				'id'   => 'custom_social_title_'.$i,
				'type' => 'text',
			));

		jannah_theme_option(
			array(
				'name'        => esc_html__( 'Icon', 'jannah' ),
				'id'          => 'custom_social_icon_'.$i,
				'hint'        => '<a href="'. esc_url( 'http://fontawesome.io/icons/' ) .'" target="_blank">'. esc_html__( 'Use the full Font Awesome icon name', 'jannah' ) .'</a>',
				'type'        => 'text',
				'placeholder' => 'fa fa-icon',
			));

		jannah_theme_option(
			array(
				'name'        => esc_html__( 'URL', 'jannah' ),
				'id'          => 'custom_social_url_'.$i,
				'placeholder' => 'https://',
				'type'        => 'text',
			));

		jannah_theme_option(
			array(
				'name' => esc_html__( 'Color', 'jannah' ),
				'id'   => 'custom_social_color_'.$i,
				'type' => 'color',
			));
	}

?>
