<?php get_header(); ?>

<?php if ( have_posts() ) : while ( have_posts() ) : the_post();

	if ( get_post_meta( get_the_ID(), 'template', true ) == 'gp-hub-post' ) { 
		get_template_part( 'lib/sections/hub/hub-template' );
	} elseif ( get_post_meta( get_the_ID(), 'template', true ) == 'gp-review-post' ) { 
		get_template_part( 'lib/sections/review/review-template' );
	} elseif ( get_post_meta( get_the_ID(), 'template', true ) == 'gp-preview-post' ) { 
		get_template_part( 'lib/sections/preview/preview-template' );
	} else {

		// Get post or hub association ID
		$a_post_id = get_hub_association_id( get_the_ID() );

		// Page options
		$header = ghostpool_option( 'page_header' ) == 'default' ? ghostpool_option( 'page_page_header' ) : ghostpool_option( 'page_header' );
		
		?>

		<?php if ( ( ghostpool_option( 'hub_header_associated_content' ) == 'enabled' && $a_post_id != get_the_ID() ) OR get_post_meta( get_the_ID(), 'custom_hub_tab_ids', true ) ) {

			$page_header_height = redux_post_meta( 'ghostpool_huber', $a_post_id, 'page_header_height' );
	
			ghostpool_hub_header( 
				$post_id = $a_post_id, 
				$type = redux_post_meta( 'ghostpool_huber', $a_post_id, 'page_header' ) == 'default' ? ghostpool_option( 'hub_page_header' ) : redux_post_meta( 'ghostpool_huber', $a_post_id, 'page_header' ),
				$bg = redux_post_meta( 'ghostpool_huber', $a_post_id, 'page_header_bg' ),
				$height = $page_header_height && $page_header_height['padding-bottom'] != '' ? $page_header_height['padding-bottom'] : ghostpool_option( 'hub_page_header_height', 'padding-bottom' )
			);
	
		} else {

			ghostpool_page_title( '', $header );
			
			$page_header_height = redux_post_meta( 'ghostpool_huber', get_the_ID(), 'page_header_height' );
	
			ghostpool_page_header( 
				$post_id = get_the_ID(), 
				$type = redux_post_meta( 'ghostpool_huber', get_the_ID(), 'page_header' ) == 'default' ? ghostpool_option( 'page_page_header' ) : redux_post_meta( 'ghostpool_huber', get_the_ID(), 'page_header' ),  
				$bg = redux_post_meta( 'ghostpool_huber', get_the_ID(), 'page_header_bg' ),
				$height = $page_header_height && $page_header_height['padding-bottom'] != '' ? $page_header_height['padding-bottom'] : ghostpool_option( 'page_page_header_height', 'padding-bottom' )
			);
	
		} ?>
		
		<?php if ( ( ghostpool_option( 'hub_tab_associated_content' ) == 'enabled' && $a_post_id != get_the_ID() ) OR get_post_meta( get_the_ID(), 'custom_hub_tab_ids', true ) ) { get_template_part( 'lib/sections/hub/hub-tabs' ); } ?>

		<div id="gp-content-wrapper" class="gp-container">
		
			<?php do_action( 'ghostpool_begin_content_wrapper' ); ?>
	
			<div id="gp-inner-container">
	
				<div id="gp-left-column">

					<div id="gp-content">
			
						<?php if ( ( ghostpool_option( 'hub_header_associated_content' ) == 'enabled' && $a_post_id != get_the_ID() ) OR get_post_meta( get_the_ID(), 'custom_hub_tab_ids', true ) OR $header == 'gp-fullwidth-page-header' OR $header == 'gp-full-page-page-header' ) { ?>	
							<?php ghostpool_breadcrumbs(); ?>
							<header class="gp-entry-header">
								<h1 class="gp-entry-title">
									<?php if ( ghostpool_option( 'custom_title' ) ) { echo esc_attr( ghostpool_option( 'custom_title' ) ); } else { the_title(); } ?>
								</h1>
								<?php if ( ghostpool_option( 'subtitle' ) ) { ?>
									<div class="gp-subtitle"><?php echo esc_attr( ghostpool_option( 'subtitle' ) ); ?></div>
								<?php } ?>
							</header>
						<?php } ?>
						
						<?php if ( isset( $_GET['post_submission'] ) && $_GET['post_submission'] == '1' && isset( $_REQUEST['_wpnonce'] ) && wp_verify_nonce( $_REQUEST['_wpnonce'], 'ghostpool_post_submission_action' ) ) {		
					
							get_template_part( 'lib/sections/hub/post-submission-form' );
	
						} elseif ( isset( $_GET['post_edit'] ) && $_GET['post_edit'] == 1 && isset( $_REQUEST['_wpnonce'] ) && wp_verify_nonce( $_REQUEST['_wpnonce'], 'ghostpool_post_edit_action' ) ) { 
					
							get_template_part( 'lib/sections/hub/post-edit-form' );
				
						} elseif ( isset( $_GET['post_preview'] ) && $_GET['post_preview'] == 1 && isset( $_REQUEST['_wpnonce'] ) && wp_verify_nonce( $_REQUEST['_wpnonce'], 'ghostpool_post_preview_action' ) ) { 
				
							get_template_part( 'lib/sections/user-review/post-preview' );	
				
						} elseif ( ghostpool_option( 'post_submission_page' ) && is_page( ghostpool_option( 'post_submission_page' ) ) ) {
				
							get_template_part( 'lib/sections/hub/post-list' );
		
						} elseif ( ghostpool_option( 'following_page' ) && is_page( ghostpool_option( 'following_page' ) ) ) {
				
							get_template_part( 'lib/sections/page/following' );
		
						} else {
						
							get_template_part( 'lib/sections/page/page-content' ); 
						
						} ?>
						
					</div>
			
					<?php get_sidebar( 'left' ); ?>

				</div>

				<?php get_sidebar( 'right' ); ?>

			</div>
	
			<?php do_action( 'ghostpool_end_content_wrapper' ); ?>
	
			<div class="gp-clear"></div>

		</div>

	<?php } ?>

<?php endwhile; endif; ?>

<?php get_footer(); ?>