<?php

if ( ! function_exists( 'ghostpool_rating_box' ) ) {
	function ghostpool_rating_box() {
		register_widget( 'GhostPool_Rating_Box' );
	}
}
add_action( 'widgets_init', 'ghostpool_rating_box' );

if ( ! class_exists( 'GhostPool_Rating_Box' ) ) {
	class GhostPool_Rating_Box extends WP_Widget {
	
		function __construct() {
			$widget_ops = array( 'classname' => 'gp-rating-box-widget', 'description' => esc_html__( 'Display a rating box with hub fields.', 'huber' ) );
			parent::__construct( 'gp-rating-box-widget', esc_html__( 'GP Rating Box', 'huber' ), $widget_ops );
		}

		function widget( $args, $instance ) {

			extract( $args );

			$display_featured_image = isset( $instance['display_featured_image'] ) ? $instance['display_featured_image'] : 'enabled';
			$display_hub_synopsis = isset( $instance['display_hub_synopsis'] ) ? $instance['display_hub_synopsis'] : 'enabled';
			$display_user_rating = isset( $instance['display_user_rating'] ) ? $instance['display_user_rating'] : 'enabled';
			$display_hub_fields = isset( $instance['display_hub_fields'] ) ? $instance['display_hub_fields'] : 'enabled';
			$display_write_a_review_button = isset( $instance['display_write_a_review_button'] ) ? $instance['display_write_a_review_button'] : 'enabled';
			$your_rating_title = isset( $instance['your_rating_title'] ) ? esc_attr( $instance['your_rating_title'] ) : esc_html__( 'Have Your Say!', 'huber' );
		
			echo html_entity_decode( $before_widget );	

			global $ratings; 
		
			// Get post or hub association ID
			$a_post_id = get_hub_association_id( get_the_ID() );
			
			// Release date
			if ( get_post_meta( $a_post_id, 'release_date', true ) ) {
				$new_release_date = date_i18n( 'U', strtotime( get_post_meta( $a_post_id, 'release_date', true ) ) );
			} else {
				$new_release_date = '';
			}

			if ( $display_user_rating == 'enabled' ) {

				// Get average user rating
				if ( get_post_meta( $a_post_id, 'ghostpool_user_rating', true ) ) { 
					$user_rating = number_format( get_post_meta( $a_post_id, 'ghostpool_user_rating', true ), 1 ) + 0;
				} else {
					$user_rating = 0;
				}

				// Get total votes
				$user_votes = get_post_meta( $a_post_id, 'ghostpool_user_votes', true );
				if ( ! $user_votes ) {
					$user_votes = 0;
				}
				if ( ! $user_votes ) {
					$user_votes_text = esc_html__( ' votes', 'huber');
				} elseif ( $user_votes == 1 ) {
					$user_votes_text = esc_html__( ' vote', 'huber');
				} else {
					$user_votes_text = esc_html__( ' votes', 'huber');	
				}
		
			}
		
			// Post submission URL
			if ( $display_write_a_review_button == 'enabled' ) { 
				if ( get_option( 'permalink_structure' ) ) {
					$post_submission_url = get_permalink( ghostpool_option( 'post_submission_page' ) ) . '?post_submission=1&hub_id=' . $a_post_id . '&_wpnonce=' . wp_create_nonce( 'ghostpool_post_submission_action' );
				} else { 
					$post_submission_url = get_permalink( ghostpool_option( 'post_submission_page' ) ) . '&post_submission=1&hub_id=' . $a_post_id . '&_wpnonce=' . wp_create_nonce( 'ghostpool_post_submission_action' );
				}
			}
							
			?>

			<div class="gp-rating-box">

				<?php if ( has_post_thumbnail( $a_post_id ) && $display_featured_image == 'enabled' ) { ?>		
					<div class="gp-post-thumbnail">
						<a href="<?php echo get_permalink( $a_post_id ); ?>"><?php echo get_the_post_thumbnail( $a_post_id, 'ghostpool-rating-box-image' ); ?></a>
					</div>
				<?php } ?>
						
				<div class="gp-rating-box-details">

					<h3 class="gp-rating-box-title">
						<a href="<?php echo get_permalink( $a_post_id ); ?>"><?php echo get_the_title( $a_post_id ); ?></a>
					</h3>
				
					<?php if ( get_post_meta( $a_post_id, 'release_date', true ) ) {
						echo '<div class="gp-rating-box-date">';
						if ( $new_release_date > date( 'U' ) ) {
							echo esc_attr( ghostpool_option( 'upcoming_date_text' ) ) . ': ';
						} else {
							echo esc_attr( ghostpool_option( 'release_date_text' ) ) . ': ';
						}
						echo date_i18n( ghostpool_option( 'release_date_format' ), strtotime( get_post_meta( $a_post_id, 'release_date', true ) ) );
						echo '</div>';
					} ?>

					<?php if ( $display_hub_synopsis == 'enabled' ) { ?>
						<div class="gp-rating-box-synopsis">
							<?php if ( get_post_meta( $a_post_id, 'synopsis', true ) ) {
								echo get_post_meta( $a_post_id, 'synopsis', true );
							} else {
								$the_post = get_post( $a_post_id );
								if ( $the_post ) {
									$excerpt = strip_tags( $the_post->post_content );
									if ( function_exists( 'mb_strlen' ) && function_exists( 'mb_substr' ) ) { 
										if ( mb_strlen( $excerpt ) > 240 ) {
											$excerpt = mb_substr( $excerpt, 0, 240 ) . '...';
										}
									} else {
										if ( strlen( $excerpt ) > 240 ) {
											$excerpt = substr( $excerpt, 0, 240 ) . '...';
										}	
									}
									echo esc_attr( $excerpt );
								}	
							} ?>
						</div>
					<?php } ?>
				
				</div>
							
				<?php if ( ghostpool_option( 'release_date' ) ) {
					$release_date = new DateTime( ghostpool_option( 'release_date' ) );
				} else {
					$release_date = '';
				}
				if ( $display_user_rating == 'enabled'  && ( ! ghostpool_option( 'release_date' ) OR $release_date->format( 'U' ) <= date( 'U' ) ) && $new_release_date <= date( 'U' ) ) { ?>
			
					<div class="gp-rating-box-average-rating">
						<div class="gp-average-rating-score<?php echo ghostpool_rating_color( $user_rating ); ?>">
							<?php echo floatval( $user_rating ); ?>
						</div>
						<div class="gp-average-rating-info">
							<div class="gp-average-rating-text"><?php esc_html_e( 'Average User Rating', 'huber' ); ?></div>		
							<div class="gp-total-votes gp-current-rating">
								<span class="gp-count"><?php echo absint( $user_votes ); ?></span> <?php echo esc_attr( $user_votes_text ); ?>
							</div>
						</div>	
					</div>
			
					<div class="gp-your-rating">
										
						<?php if ( ( ghostpool_option( 'visitor_voting' ) == 'enabled' && ! is_user_logged_in() ) OR is_user_logged_in() ) { ?>
		
							<?php if ( $your_rating_title ) { ?><div class="gp-your-rating-title"><?php echo esc_attr( $your_rating_title ); ?></div><?php } ?>
				
							<div class="gp-your-rating-text gp-current-rating">	
								<?php esc_html_e( 'Your Rating:', 'huber' ); ?> <span class="gp-score">0</span>
							</div>

							<div class="gp-rating-slider-wrapper" style="width: <?php echo absint( apply_filters( 'ghostpool_custom_rating_width', 23.3 ) * ghostpool_option( 'rating_number' ) ); ?>px;">
								<div class="gp-rating-unrated">
									<div class="gp-rating-selection"></div>
								</div>
							</div>
		
							<div class="gp-submit-your-rating button"><?php esc_html_e( 'Submit', 'huber' ); ?></div>
				
							<?php if ( $display_write_a_review_button == 'enabled' ) { ?><a href="<?php echo esc_url( $post_submission_url ); ?>" class="gp-write-a-review-button button"><?php esc_html_e( 'Write A Review', 'huber' ); ?></a><?php } ?>
				

						<?php } else { ?>
			 
							 <div class="gp-sign-in-to-rate"><?php esc_html_e( 'Please', 'huber' ); ?> <a href="<?php if ( ghostpool_option( 'popup_box' ) == 'enabled' ) { echo '#login'; } else { wp_login_url( apply_filters( 'the_permalink', get_permalink() ) ); } ?>" id="gp-login-link" title="<?php esc_html_e( 'Sign In', 'huber' ); ?>"><?php esc_html_e( 'sign in', 'huber' ); ?></a> <?php esc_html_e( 'to rate.', 'huber' ); ?></div>

						<?php }
					
						$page_bg = get_post_meta( $a_post_id, 'page_header_bg', true ); 
					
						if ( $page_bg && $page_bg['url'] ) { ?>
							<div class="gp-standard-bg" style="background-image: url(<?php echo esc_url( $page_bg['url'] ); ?>);"></div>
						<?php } ?>
					
					</div>	
					
				<?php } ?>
				
				<?php if ( $display_hub_fields == 'enabled' ) { 				
						
					// Support for foreign characters	
					$char_table = array();
					if ( function_exists( 'ghostpool_hub_field_characters' ) ) {
						$char_table = ghostpool_hub_field_characters();
					}	
			
					?>
			
					<div class="gp-hub-fields">
	
						<?php $hub_fields = ghostpool_option( 'hub_fields' );
					
						if ( $hub_fields[0] ) {
					
							foreach( $hub_fields as $hub_field ) {
					
								$hub_field_slug = strtr( $hub_field, $char_table );
								if ( function_exists( 'iconv' ) ) {
									$hub_field_slug = iconv( 'UTF-8', 'UTF-8//TRANSLIT//IGNORE', $hub_field_slug );
								}
				
								$hub_field_slug = sanitize_title( $hub_field_slug );
								$hub_field_slug = mb_substr( $hub_field_slug, 0, 32 );
								$term_list = get_the_term_list( $a_post_id, $hub_field_slug, '<div class="gp-hub-field"><span class="gp-hub-field-name">' . $hub_field . ':</span><span class="gp-hub-field-list">', ', ', '</span></div>' );
								if ( ! $term_list OR is_wp_error( $term_list ) ) {
									continue;
								}	
								if ( ghostpool_option( 'hub_field_links' ) == 'disabled' ) {
									$term_list = preg_replace( '/<\/?a[^>]*>/', '', $term_list );
								}
								echo wp_kses_post( $term_list );
				
							} 
					
						} ?>
					
					</div>

				<?php } ?>
		
			</div>

			<?php echo html_entity_decode( $after_widget );

		}

		function update( $new_instance, $old_instance ) {
			$instance = $old_instance;
			$instance['display_featured_image'] = isset( $new_instance['display_featured_image'] ) ? $new_instance['display_featured_image'] : 'enabled';
			$instance['display_hub_synopsis'] = isset( $new_instance['display_hub_synopsis'] ) ? $new_instance['display_hub_synopsis'] : 'enabled';
			$instance['display_user_rating'] = isset( $new_instance['display_user_rating'] ) ? $new_instance['display_user_rating'] : 'enabled';
			$instance['display_hub_fields'] = isset( $new_instance['display_hub_fields'] ) ? $new_instance['display_hub_fields'] : 'enabled';
			$instance['display_write_a_review_button'] = isset( $new_instance['display_write_a_review_button'] ) ? $new_instance['display_write_a_review_button'] : 'enabled';				
			$instance['your_rating_title'] = isset( $new_instance['your_rating_title'] ) ? sanitize_text_field( $new_instance['your_rating_title'] ) : esc_html__( 'Have your say!', 'huber' );
			return $instance;
		}

		function form( $instance ) {
	
			// Defaults
			$display_featured_image = isset( $instance['display_featured_image'] ) ? esc_attr( $instance['display_featured_image'] ) : 'enabled';
			$display_hub_synopsis = isset( $instance['display_hub_synopsis'] ) ? esc_attr( $instance['display_hub_synopsis'] ) : 'enabled';
			$display_user_rating = isset( $instance['display_user_rating'] ) ? esc_attr( $instance['display_user_rating'] ) : 'enabled';
			$display_hub_fields = isset( $instance['display_hub_fields'] ) ? esc_attr( $instance['display_hub_fields'] ) : 'enabled';
			$display_write_a_review_button = isset( $instance['display_write_a_review_button'] ) ? esc_attr( $instance['display_write_a_review_button'] ) : 'enabled';
			$your_rating_title = isset( $instance['your_rating_title'] ) ? esc_attr( $instance['your_rating_title'] ) : esc_html__( 'Have Your Say!', 'huber' );
		
			?>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'display_featured_image' ) ); ?>"><?php esc_html_e( 'Featured Image:', 'huber' ); ?></label>
				<select id="<?php echo esc_attr( $this->get_field_id( 'display_featured_image' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'display_featured_image' ) ); ?>">
					<option value="enabled"<?php selected( $display_featured_image, 'enabled' ); ?>><?php esc_html_e( 'Enabled', 'huber' ); ?></option>
					<option value="disabled"<?php selected( $display_featured_image, 'disabled' ); ?>><?php esc_html_e( 'Disabled', 'huber' ); ?></option>
				</select>	
			</p>	
		
		
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'display_hub_synopsis' ) ); ?>"><?php esc_html_e( 'Hub Synopsis:', 'huber' ); ?></label>
				<select id="<?php echo esc_attr( $this->get_field_id( 'display_hub_synopsis' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'display_hub_synopsis' ) ); ?>">
					<option value="enabled"<?php selected( $display_hub_synopsis, 'enabled' ); ?>><?php esc_html_e( 'Enabled', 'huber' ); ?></option>
					<option value="disabled"<?php selected( $display_hub_synopsis, 'disabled' ); ?>><?php esc_html_e( 'Disabled', 'huber' ); ?></option>
				</select>	
			</p>	

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'display_user_rating' ) ); ?>"><?php esc_html_e( 'User Rating:', 'huber' ); ?></label>
				<select id="<?php echo esc_attr( $this->get_field_id( 'display_user_rating' ) ); ?>" name="<?php echo esc_attr( $this->get_field_id( 'display_user_rating' ) ); ?>">
					<option value="enabled"<?php selected( $display_user_rating, 'enabled' ); ?>><?php esc_html_e( 'Enabled', 'huber' ); ?></option>
					<option value="disabled"<?php selected( $display_user_rating, 'disabled' ); ?>><?php esc_html_e( 'Disabled', 'huber' ); ?></option>
				</select>	
			</p>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'display_hub_fields' ) ); ?>"><?php esc_html_e( 'Hub Fields:', 'huber' ); ?></label>
				<select id="<?php echo esc_attr( $this->get_field_id( 'display_hub_fields' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'display_hub_fields' ) ); ?>">
					<option value="enabled"<?php selected( $display_hub_fields, 'enabled' ); ?>><?php esc_html_e( 'Enabled', 'huber' ); ?></option>
					<option value="disabled"<?php selected( $display_hub_fields, 'disabled' ); ?>><?php esc_html_e( 'Disabled', 'huber' ); ?></option>
				</select>	
			</p>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'display_write_a_review_button' ) ); ?>"><?php esc_html_e( 'Write A Review Button:', 'huber' ); ?></label>
				<select id="<?php echo esc_attr( $this->get_field_id( 'display_write_a_review_button' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'display_write_a_review_button' ) ); ?>">
					<option value="enabled"<?php selected( $display_write_a_review_button, 'enabled' ); ?>><?php esc_html_e( 'Enabled', 'huber' ); ?></option>
					<option value="disabled"<?php selected( $display_write_a_review_button, 'disabled' ); ?>><?php esc_html_e( 'Disabled', 'huber' ); ?></option>
				</select>	
			</p>
						
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'your_rating_title' ) ); ?>"><?php esc_html_e( 'Your Rating Title:', 'huber' ); ?></label>
				<br/><input type="text" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'your_rating_title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'your_rating_title' ) ); ?>" value="<?php echo esc_attr( $your_rating_title ); ?>" />
			</p>
									
			<?php

		}
	}
}

?>