<?php if ( ! function_exists( 'ghostpool_custom_popular_posts_html_list' ) ) {
	function ghostpool_custom_popular_posts_html_list( $mostpopular, $instance ) {
		$output = '<div class="gp-showcase-wrapper gp-blog-vertical gp-ranking"><div class="gp-section-loop"><div class="gp-section-loop-inner">';

		$counter = 0;

		// Count number of posts
		$post_count = count( $mostpopular );
		
		
		// loop the array of popular posts objects
		foreach( $mostpopular as $popular ) {
		
			$counter++;
			
			if ( $counter > 1 ) {
				$trending_small = '<div class="gp-ranking-counter">' . $counter . '</div>';
				$trending_large = '';
			} else {
				$trending_large = '<div class="gp-ranking-counter">' . $counter . '</div>';
				$trending_small = '';
			}
			
			$stats = array(); // placeholder for the stats tag

			// Author option checked
			if ( $instance['stats_tag']['author'] ) {
				$stats[] = '<span class="gp-post-meta gp-meta-author">' . ghostpool_author_name( $popular->uid ). '</span>';
			}

			// Date option checked
			if ( $instance['stats_tag']['date']['active'] ) {
				$date = date_i18n( $instance['stats_tag']['date']['format'], strtotime( $popular->date ) );
				$stats[] = '<a href=\"#\" class="gp-post-meta gp-meta-date"><time itemprop="datePublished" datetime="">' . the_time( get_option( 'date_format' ) ) . '</time></a>';
			}

			// Comment count option active, display comments
			if ( $instance['stats_tag']['comment_count'] ) {
				// display text in singular or plural, according to comments count
				$stats[] = '<span class="gp-post-meta gp-meta-comments">' . sprintf(
					_n( '1 comment', '%s comments', $popular->comment_count, 'huber' ),
					number_format_i18n( $popular->comment_count )
				) . '</span>';
			}

			// Pageviews option checked, display views
			if ( $instance['stats_tag']['views'] ) {

				// If sorting posts by average views
				if ($instance['order_by'] == 'avg') {
					// display text in singular or plural, according to views count
					$stats[] = '<span class="gp-post-meta gp-meta-views">' . sprintf(
						_n( '1 view per day', '%s views per day', intval( $popular->pageviews ), 'huber' ),
						number_format_i18n( $popular->pageviews, 2 )
					) . '</span>';
				} else { // Sorting posts by views
					// display text in singular or plural, according to views count
					$stats[] = '<span class="gp-post-meta gp-meta-views">' . sprintf(
						_n( '1 view', '%s views', intval( $popular->pageviews ), 'huber' ),
						number_format_i18n( $popular->pageviews )
					) . '</span>';
				}
			}
		
			// Category option checked
			if ( $instance['stats_tag']['category'] ) {
				$post_cat = get_the_category( $popular->id );
				$post_cat = ( isset( $post_cat[0] ) )
				  ? '<a href="' . get_category_link( $post_cat[0]->term_id ) . '">' . $post_cat[0]->cat_name . '</a>'
				  : '';

				if ( $post_cat != '' ) {
					$stats[] = '<span class="gp-post-meta gp-meta-cats">' . sprintf( esc_html__( '%s', 'huber' ), $post_cat ) . '</span>';
				}
			}

			// Build stats tag
			if ( ! empty( $stats ) ) {
				$stats = '<div class="gp-loop-meta">' . join( '', $stats ) . '</div>';
			} else {
				$stats = '';
			}

			$excerpt = ''; // Excerpt placeholder

			// Excerpt option checked, build excerpt tag
			if ( $instance['post-excerpt']['active'] ) {

				$excerpt = get_excerpt_by_id( $popular->id, $instance );
				if ( ! empty( $excerpt ) ) {
					$excerpt = '<div class="wpp-excerpt">' . $excerpt . '</div>';
				}

			}

			$thumb = '';
			
			// Thumbnail
			if ( $instance['thumbnail']['active'] ) {
										
				$thumb = '<div class="gp-post-thumbnail gp-loop-featured">' .
					$trending_large .
					'<a href="' . get_the_permalink( $popular->id ) . '" title="' . esc_attr( $popular->title ) . '">' .
						get_the_post_thumbnail( $popular->id, apply_filters( 'ghostpool_popular_posts_image_size', 'ghostpool-col-category-image' ) ) .
					'</a>					
				</div>';

			}
						
			if ( isset( $counter ) && $counter == 2 ) { 
				$output .= '</div><div class="gp-small-posts">';
			} elseif ( isset( $counter ) && $counter == 1 ) {
				$output .= '<div class="gp-large-post">';
			}
			
			$output .= "<section class=\"gp-post-item\" itemscope itemtype=\"https://schema.org/Blog\">";
			$output .= $thumb;
			if ( $counter > 1 ) {
				$output .= $trending_small;
			}
			$output .= "<div class=\"gp-loop-content\"><h3 class=\"gp-loop-title\"><a href=\"" . get_the_permalink( $popular->id ) . "\" title=\"" . $popular->title . "\">" . get_title_sub_by_id( $popular->id, $instance ) . "</a></h3>";
			$output .= $stats;
			$output .= $excerpt;
			$output .= "</div></section>" . "\n";
			
			if ( isset( $counter ) && $counter == $post_count ) {
				$output .= '</div>';
			}
						
			/*if ( isset( $counter ) && $counter % $instance['limit'] == 0 ) {
				$output .= '</div>';
			}*/

		}

		$output .= '</div></div></div>';

		return $output;
	}
}
add_filter( 'wpp_custom_html', 'ghostpool_custom_popular_posts_html_list', 10, 2 );

/*
 * Get custom title
 *
 */
function get_title_sub_by_id($id, $instance) {
	/*$cache = &$this->__cache(__FUNCTION__, array());
	if ( isset($cache[$id]) ) {
		return $cache[$id];
	}*/
	// TITLE
	$title_sub = get_the_title( $id );
	// truncate title
	if ($instance['shorten_title']['active']) {
		// by words
		if (isset($instance['shorten_title']['words']) && $instance['shorten_title']['words']) {
			$words = explode(" ", $title_sub, $instance['shorten_title']['length'] + 1);
			if (count($words) > $instance['shorten_title']['length']) {
				array_pop($words);
				$title_sub = rtrim( implode(" ", $words), ",." ) . " ...";
			}
		}
		elseif (strlen($title_sub) > $instance['shorten_title']['length']) {
			$title_sub = rtrim( mb_substr($title_sub, 0, $instance['shorten_title']['length'], get_bloginfo( 'charset' ) ), " ,." ) . "...";
		}
	}
	return $title_sub;
}
		
/*
 * Get custom excerpt
 *
 */
function get_excerpt_by_id($id, $instance){

	$excerpt = "";
	// WPML support, get excerpt for current language
	if ( defined('ICL_LANGUAGE_CODE') && function_exists('icl_object_id') ) {
		$current_id = icl_object_id( $id, get_post_type( $id ), true, ICL_LANGUAGE_CODE );
		$the_post = get_post( $current_id );
		$excerpt = ( empty($the_post->post_excerpt) )
		  ? $the_post->post_content
		  : $the_post->post_excerpt;
	} // Use ol' plain excerpt
	else {
		$the_post = get_post( $id );
		$excerpt = ( empty($the_post->post_excerpt) )
		  ? $the_post->post_content
		  : $the_post->post_excerpt;
		// RRR added call to the_content filters, allows qTranslate to hook in.
		if ( function_exists('qtrans_useCurrentLanguageIfNotFoundUseDefaultLanguage') )
			$excerpt = qtrans_useCurrentLanguageIfNotFoundUseDefaultLanguage( $excerpt );
	}
	// remove caption tags
	$excerpt = preg_replace( "/\[caption.*\[\/caption\]/", "", $excerpt );
	// remove Flash objects
	$excerpt = preg_replace( "/<object[0-9 a-z_?*=\":\-\/\.#\,\\n\\r\\t]+/smi", "", $excerpt );
	// remove Iframes
	$excerpt = preg_replace( "/<iframe.*?\/iframe>/i", "", $excerpt);
	// remove WP shortcodes
	$excerpt = strip_shortcodes( $excerpt );
	
	// remove style/script tags
	$excerpt = preg_replace( '@<(script|style)[^>]*?>.*?</\\1>@si', '', $excerpt );
	// remove HTML tags if requested
	if ( $instance['post-excerpt']['keep_format'] ) {
		$excerpt = strip_tags($excerpt, '<a><b><i><em><strong>');
	} else {
		$excerpt = strip_tags($excerpt);
		// remove URLs, too
		$excerpt = preg_replace( '_^(?:(?:https?|ftp)://)(?:\S+(?::\S*)?@)?(?:(?!10(?:\.\d{1,3}){3})(?!127(?:\.\d{1,3}){3})(?!169\.254(?:\.\d{1,3}){2})(?!192\.168(?:\.\d{1,3}){2})(?!172\.(?:1[6-9]|2\d|3[0-1])(?:\.\d{1,3}){2})(?:[1-9]\d?|1\d\d|2[01]\d|22[0-3])(?:\.(?:1?\d{1,2}|2[0-4]\d|25[0-5])){2}(?:\.(?:[1-9]\d?|1\d\d|2[0-4]\d|25[0-4]))|(?:(?:[a-z\x{00a1}-\x{ffff}0-9]+-?)*[a-z\x{00a1}-\x{ffff}0-9]+)(?:\.(?:[a-z\x{00a1}-\x{ffff}0-9]+-?)*[a-z\x{00a1}-\x{ffff}0-9]+)*(?:\.(?:[a-z\x{00a1}-\x{ffff}]{2,})))(?::\d{2,5})?(?:/[^\s]*)?$_iuS', '', $excerpt );
	}
	// Fix RSS CDATA tags
	$excerpt = str_replace( ']]>', ']]&gt;', $excerpt );
	// do we still have something to display?
	if ( !empty($excerpt) ) {
		// truncate excerpt
		if ( isset($instance['post-excerpt']['words']) && $instance['post-excerpt']['words'] ) { // by words
			$words = explode(" ", $excerpt, $instance['post-excerpt']['length'] + 1);
			if ( count($words) > $instance['post-excerpt']['length'] ) {
				array_pop($words);
				$excerpt = rtrim( implode(" ", $words), ".," ) . " ...";
			}
		} else { // by characters
			if ( strlen($excerpt) > $instance['post-excerpt']['length'] ) {
				$excerpt = rtrim( mb_substr( $excerpt, 0, $instance['post-excerpt']['length'], get_bloginfo('charset') ), ".," ) . "...";
			}
		}
	}
	// Balance tags, if needed
	if ( $instance['post-excerpt']['keep_format'] ) {
		$excerpt = force_balance_tags($excerpt);
	}
	return $excerpt;
}

?>