<?php

if ( ! function_exists( 'ghostpool_category_filters' ) ) {
	function ghostpool_category_filters() {
		register_widget( 'GhostPool_Category_Filters' );
	}
}
add_action( 'widgets_init', 'ghostpool_category_filters' );


if ( ! class_exists( 'GhostPool_Category_Filters' ) ) {
	class GhostPool_Category_Filters extends WP_Widget {
	
		function __construct() {
			$widget_ops = array( 'classname' => 'gp-category-filters-widget', 'description' => esc_html__( 'Display content in a variety of ways.', 'huber' ) );
			parent::__construct( 'gp-category-filters-widget', esc_html__( 'GP Category Filters', 'huber' ), $widget_ops );
		}

		function widget( $args, $instance ) {
		
			extract( $args );
				
			$title = isset( $instance['title'] ) ? $instance['title'] : esc_html__( 'Filters', 'huber' );
			$parent_category = isset( $instance['parent_category'] ) ? $instance['parent_category'] : '';
			$parent_category_text = isset( $instance['parent_category_text'] ) ? $instance['parent_category_text'] : esc_html__( 'Categories', 'huber' );
			$release_date = isset( $instance['release_date'] ) ? $instance['release_date'] : 'enabled';
			$release_date_text = isset( $instance['release_date_text'] ) ? $instance['release_date_text'] : esc_html__( 'Release Date', 'huber' );
			$hub_fields = isset( $instance['hub_fields'] ) ? $instance['hub_fields'] : '';
			$submit_button_text = isset( $instance['submit_button_text'] ) ? $instance['submit_button_text'] : esc_html__( 'Filter Items', 'huber' );
			$bg_color = isset( $instance['bg_color'] ) ? $instance['bg_color'] : '';
			$border_color = isset( $instance['border_color'] ) ? $instance['border_color'] : '';

			if ( ! is_archive() )
				return;
				
			if ( is_numeric( $parent_category ) ) {
				$parent_category = (int) $parent_category;
			}
			
			// Get parent cat ID and/or slug
			if ( $parent_category && term_exists( $parent_category, 'category' ) !== 0 && term_exists( $parent_category, 'category' ) !== null ) {
			
				if ( is_numeric( $parent_category ) ) { // ID
					$parent_cat_slug = get_term_by( 'id', $parent_category, 'category' );
					$parent_cat_slug = $parent_cat_slug->slug;	
					$parent_cat_id = $parent_category;
				} else { // Slug
					$parent_cat_slug = $parent_category;
					$parent_cat_id = get_term_by( 'slug', $parent_category, 'category' );
					if ( is_object( $parent_cat_id ) ) { // Make sure ID exists as well
						$parent_cat_id = $parent_cat_id->term_id;
					}	
				}
			}
				
			echo html_entity_decode( $before_widget );
			
				if ( $bg_color ) {
					echo '<style>.gp-category-filters-widget{background: ' . $bg_color . ';}</style>';
				}				

				if ( $border_color ) {
					echo '<style>.gp-category-filters-widget{border: 1px solid '. $border_color . ';}</style>';
				}			
			
				if ( $title ) { echo html_entity_decode( $before_title . $title . $after_title ); } ?>
				
				<form name="ghostpool_category_filter_form" method="post" enctype="multipart/form-data">
			
					<?php if ( $parent_category && term_exists( $parent_category, 'category' ) !== 0 && term_exists( $parent_category, 'category' ) !== null ) { ?>						
						<p>
							<span class="gp-filter-title"><?php echo esc_attr( $parent_category_text ); ?></span>
							<select name="category" class="gp-filter-select">
								<option value="<?php echo sanitize_html_class( $parent_cat_slug ); ?>"<?php if ( isset( $_POST['category'] ) && $_POST['category'] == $parent_cat_slug ) { ?>selected="selected"<?php } ?>><?php esc_html_e( 'All', 'huber' ); ?></option>
								<?php 
								$args = array(
									'parent'     => (int) $parent_cat_id,
									'hide_empty' => false,
								);
								$cats = get_terms( 'category', $args );				
								foreach( $cats as $cat ) {
									$cat_slug = $cat->slug;
									$cat_name = $cat->name; ?>
									<option value="<?php echo esc_attr( $cat_slug ); ?>"<?php if ( isset( $_POST['category'] ) && $_POST['category'] == $cat_slug ) { echo ' selected="selected"'; } ?>><?php echo esc_attr( $cat_name ); ?></option>
								<?php } ?>
							</select>
						</p>
					<?php } ?>

					<?php if ( $release_date == 'enabled' ) { ?>
						<p>
							<span class="gp-filter-title"><?php echo esc_attr( $release_date_text ); ?></span>
							<select name="release_date" id="gp-filter-release-date" class="gp-filter-select">
								<option value="all"<?php if ( isset( $_POST['release_date'] ) && $_POST['release_date'] == 'all' ) { echo ' selected="selected"'; } ?>><?php esc_html_e( 'All time', 'huber' ); ?></option>
								<option value="12months"<?php if ( isset( $_POST['release_date'] ) && $_POST['release_date'] == '12months' ) { echo ' selected="selected"'; } ?>><?php esc_html_e( 'Last 12 months', 'huber' ); ?></option>
								<option value="6months"<?php if ( isset( $_POST['release_date'] ) && $_POST['release_date'] == '6months' ) { echo ' selected="selected"'; } ?>><?php esc_html_e( 'Last 6 months', 'huber' ); ?></option>
								<option value="3months"<?php if ( isset( $_POST['release_date'] ) && $_POST['release_date'] == '3months' ) { echo ' selected="selected"'; } ?>><?php esc_html_e( 'Last 3 months', 'huber' ); ?></option>
								<option value="date_range"<?php if ( isset( $_POST['release_date'] ) && $_POST['release_date'] == 'date_range' ) { echo ' selected="selected"'; } ?>><?php esc_html_e( 'Date Range', 'huber' ); ?></option>
							</select>
						</p>
					
						<p class="gp-filter-release-date-range<?php if ( isset( $_POST['release_date'] ) && $_POST['release_date'] == 'date_range' ) { ?> gp-selected<?php } ?>">
							<input type="text" name="from" value="<?php if ( isset( $_POST['from'] ) && $_POST['from'] != '' ) { $from_date = date( get_option( 'date_format' ), strtotime( $_POST['from'] ) ); echo esc_attr( $from_date ); } ?>" placeholder="<?php esc_html_e( 'Beginning Date', 'huber' ); ?>" class="gp-filter-input gp-datepicker">
							<input type="text" name="to" value="<?php if ( isset( $_POST['to'] ) && $_POST['to'] != '' ) { $to_date = date( get_option( 'date_format' ), strtotime( $_POST['to'] ) ); echo esc_attr( $to_date ); } ?>" placeholder="<?php esc_html_e( 'Ending Date', 'huber' ); ?>" class="gp-filter-input gp-datepicker">	
						</p>
						
					<?php } ?>
														
					<?php if ( $hub_fields ) {
					
						// Hub fields to add to filter
						$filters = explode( ',', $hub_fields );
						
						foreach( $filters as $filter ) {
						
							// Get taxonomy name from slug                    
							$taxonomy = get_taxonomy( $filter );
							if ( ! $taxonomy ) {
								continue;
							}
							$name = $taxonomy->labels->singular_name;
							
							// Get terms for given taxonomy
							$terms = get_terms( $filter );
							if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) { ?>
								<p>
									<span class="gp-filter-title"><?php echo esc_attr( $name ); ?></span>
									<select name="<?php echo esc_attr( $filter ); ?>" class="gp-filter-select">
										<option value=""><?php esc_html_e( 'All', 'huber' ); ?></option>
										<?php foreach( $terms as $term ) {
											$term_slug = $term->slug;
											$term_name = $term->name; ?>
											<option value="<?php echo esc_attr( $term_slug ); ?>"<?php if ( isset( $_POST[$filter] ) && $_POST[$filter] == $term_slug ) { echo ' selected="selected"'; } ?>><?php echo esc_attr( $term_name ); ?></option>
										<?php } ?>
									</select>
								</p>
							<?php }
						} ?>				
						<input type="hidden" name="ghostpool_hub_fields" value="<?php echo esc_attr( $hub_fields ); ?>" />	
					<?php } ?>
			
					<input type="submit" value="<?php echo esc_attr( $submit_button_text ); ?>" tabindex="40" name="submit" class="gp-filter-button button" />
				
					<?php wp_nonce_field( 'ghostpool_category_filter_action', 'ghostpool_category_filter_nonce' ); ?>
	
				</form>		
	
			<?php echo html_entity_decode( $after_widget );

		}

		function update( $new_instance, $old_instance ) {
			$instance = $old_instance;
			$instance['title'] = isset( $new_instance['title'] ) ? sanitize_text_field( $new_instance['title'] ) : esc_html__( 'Filters', 'huber' );
			$instance['parent_category'] = isset( $new_instance['parent_category'] ) ? $new_instance['parent_category'] : '';
			$instance['parent_category_text'] = isset( $new_instance['parent_category_text'] ) ? $new_instance['parent_category_text'] : esc_html__( 'Categories', 'huber' );
			$instance['release_date'] = isset( $new_instance['release_date'] ) ? $new_instance['release_date'] : 'enabled';
			$instance['release_date_text'] = isset( $new_instance['release_date_text'] ) ? $new_instance['release_date_text'] : esc_html__( 'Release Date', 'huber' );
			$instance['hub_fields'] = isset( $new_instance['hub_fields'] ) ? $new_instance['hub_fields'] : '';	
			$instance['submit_button_text'] = isset( $new_instance['submit_button_text'] ) ? $new_instance['submit_button_text'] : esc_html__( 'Filter Items', 'huber' );
			$instance['bg_color'] = isset( $new_instance['bg_color'] ) ? $new_instance['bg_color'] : '';
			$instance['border_color'] = isset( $new_instance['border_color'] ) ? $new_instance['border_color'] : '';
			return $instance;
		}

		function form( $instance ) {
		
			// Defaults
			$title = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : esc_html__( 'Filters', 'huber' );
			$parent_category = isset( $instance['parent_category'] ) ? esc_attr( $instance['parent_category'] ) : '';
			$parent_category_text = isset( $instance['parent_category_text'] ) ? esc_attr( $instance['parent_category_text'] ) : esc_html__( 'Categories', 'huber' );
			$release_date = isset( $instance['release_date'] ) ? esc_attr( $instance['release_date'] ) : 'enabled';
			$release_date_text = isset( $instance['release_date_text'] ) ? esc_attr( $instance['release_date_text'] ) : esc_html__( 'Release Date', 'huber' );
			$hub_fields = isset( $instance['hub_fields'] ) ? esc_attr( $instance['hub_fields'] ) : '';
			$submit_button_text = isset( $instance['submit_button_text'] ) ? esc_attr( $instance['submit_button_text'] ) : esc_html__( 'Filter Items', 'huber' );
			$bg_color = isset( $instance['bg_color'] ) ? esc_attr( $instance['bg_color'] ) : '';
			$border_color = isset( $instance['border_color'] ) ? esc_attr( $instance['border_color'] ) : '';

			// Load color picker
			wp_enqueue_style( 'wp-color-picker' );
			wp_enqueue_script( 'wp-color-picker' );
		
			?>
				
			<script>
				jQuery( document ).ready( function( $ ) {
					jQuery( '.gp-colorpicker' ).wpColorPicker();
				});
			</script>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title:', 'huber' ); ?></label>
				<br/><input type="text" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" value="<?php echo esc_attr( $title ); ?>" />
			</p>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'parent_category' ) ); ?>"><?php esc_html_e( 'Parent Category:', 'huber' ); ?></label> 
				<br/><input type="text" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'parent_category' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'parent_category' ) ) ?>" value="<?php echo esc_attr( $parent_category ); ?>" />
				<br/><small><?php esc_html_e( 'Enter the slug or ID of the parent category you want your filters based on.', 'huber' ); ?></small>
			</p>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'parent_category_text' ) ); ?>"><?php esc_html_e( 'Parent Category Text:', 'huber' ); ?></label> 
				<br/><input type="text" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'parent_category_text' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'parent_category_text' ) ) ?>" value="<?php echo esc_attr( $parent_category_text ); ?>" />
			</p>
		
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'release_date' ) ); ?>"><?php esc_html_e( 'Release Date:', 'huber' ); ?></label>
				<select id="<?php echo esc_attr( $this->get_field_id( 'release_date' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'release_date' ) ) ?>">
					<option value="enabled"<?php selected( $release_date, 'enabled' ); ?>><?php esc_html_e( 'Enabled', 'huber' ); ?></option>
					<option value="disabled"<?php selected( $release_date, 'disabled' ); ?>><?php esc_html_e( 'Disabled', 'huber' ); ?></option>
				</select>	
			</p>
		
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'release_date_text' ) ); ?>"><?php esc_html_e( 'Release Date Text:', 'huber' ); ?></label> 
				<br/><input type="text" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'release_date_text' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'release_date_text' ) ) ?>" value="<?php echo esc_attr( $release_date_text ); ?>" />
			</p>
				
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'hub_fields' ) ); ?>"><?php esc_html_e( 'Hub Fields:', 'huber' ); ?></label> 
				<br/><input type="text" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'hub_fields' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'hub_fields' ) ) ?>" value="<?php echo esc_attr( $hub_fields ); ?>" />
				<br/><small><?php esc_html_e( 'Enter the slugs of the hub fields you want to add to the filter options, separating each with a comma e.g. genre,developed-by,publisher.', 'huber' ); ?></small>
			</p>
		
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'submit_button_text' ) ); ?>"><?php esc_html_e( 'Submit Button Text:', 'huber' ); ?></label> 
				<br/><input type="text" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'submit_button_text' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'submit_button_text' ) ) ?>" value="<?php echo esc_attr( $submit_button_text ); ?>" />
			</p>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'bg_color' ) ); ?>"><?php esc_html_e( 'Background Color:', 'huber' ); ?></label>
				<br/><input type="text" class="gp-colorpicker" id="<?php echo esc_attr( $this->get_field_id( 'bg_color' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'bg_color' ) ); ?>" value="<?php echo esc_attr( $bg_color ); ?>" />
			</p>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'border_color' ) ); ?>"><?php esc_html_e( 'Border Color:', 'huber' ); ?></label>
				<br/><input type="text" class="gp-colorpicker" id="<?php echo esc_attr( $this->get_field_id( 'border_color' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'border_color' ) ); ?>" value="<?php echo esc_attr( $border_color ); ?>" />
			</p>
			
			<?php

		}
	}
}

?>