<?php

if ( ! function_exists( 'ghostpool_blog_posts' ) ) {
	function ghostpool_blog_posts() {
		if ( is_admin() ) {
			wp_enqueue_script( 'jquery-ui-datepicker' );
			wp_enqueue_style( 'style-ui-datepicker', 'https://ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/themes/smoothness/jquery-ui.css' );
		}
		register_widget( 'GhostPool_Blog_Posts' );
	}
}
add_action( 'widgets_init', 'ghostpool_blog_posts' );

if ( ! class_exists( 'GhostPool_Blog_Posts' ) ) {
	class GhostPool_Blog_Posts extends WP_Widget {
	
		function __construct() {
			$widget_ops = array( 'classname' => 'gp-blog-posts-widget', 'description' => esc_html__( 'Display content in a variety of ways.', 'huber' ) );
			parent::__construct( 'gp-blog-posts-widget', esc_html__( 'GP Blog Posts', 'huber' ), $widget_ops );
		}

		function widget( $args, $instance ) {
		
			extract( $args );
				
			$title = isset( $instance['title'] ) ? $instance['title'] : esc_html__( 'Blog Posts', 'huber' );
			$cats = isset( $instance['cats'] ) ? $instance['cats'] : '';
			$hub_fields = isset( $instance['hub_fields'] ) ? $instance['hub_fields'] : '';
			$page_ids = isset( $instance['page_ids'] ) ? $instance['page_ids'] : '';
			$post_types = isset( $instance['post_types'] ) ? $instance['post_types'] : 'post';
			$post_association = isset( $instance['post_association'] ) ? $instance['post_association'] : 'disabled';
			$ranking = isset( $instance['ranking'] ) ? $instance['ranking'] : 'gp-no-ranking';
			$format = isset( $instance['format'] ) ? $instance['format'] : 'gp-blog-list';
			$orderby = isset( $instance['orderby'] ) ? $instance['orderby'] : 'newest';
			$release_date_from = isset( $instance['release_date_from'] ) ? $instance['release_date_from'] : '';
			$release_date_to = isset( $instance['release_date_to'] ) ? $instance['release_date_to'] : '';
			$filter_cats = isset( $instance['filter_cats'] ) ? (bool) $instance['filter_cats'] : 0;
			$filter_date = isset( $instance['filter_date'] ) ? (bool) $instance['filter_date'] : 0;
			$filter_title = isset( $instance['filter_title'] ) ? (bool) $instance['filter_title'] : 0;
			$filter_comment_count = isset( $instance['filter_comment_count'] ) ? (bool) $instance['filter_comment_count'] : 0;
			$filter_likes = isset( $instance['filter_likes'] ) ? (bool) $instance['filter_likes'] : 0;
			$filter_release_date = isset( $instance['filter_release_date'] ) ? (bool) $instance['filter_release_date'] : 0;
			$filter_release_date_asc = isset( $instance['filter_release_date_asc'] ) ? (bool) $instance['filter_release_date_asc'] : 0;
			$filter_site_rating = isset( $instance['filter_site_rating'] ) ? (bool) $instance['filter_site_rating'] : 0;
			$filter_user_rating = isset( $instance['filter_user_rating'] ) ? (bool) $instance['filter_user_rating'] : 0;
			$filter_cat_id = isset( $instance['filter_cat_id'] ) ? $instance['filter_cat_id'] : '';
			$per_page = isset( $instance['per_page'] ) ? absint( $instance['per_page'] ) : '5';
			$offset =  isset( $instance['offset'] ) ? absint( $instance['offset'] ) : '';
			$image_size_standard = isset( $instance['image_size_standard'] ) ? $instance['image_size_standard'] : 'default';
			$image_size_hub = isset( $instance['image_size_hub'] ) ? $instance['image_size_hub'] : 'default';
			$image_size_review = isset( $instance['image_size_review'] ) ? $instance['image_size_review'] : 'default';
			$image_size_preview = isset( $instance['image_size_preview'] ) ? $instance['image_size_preview'] : 'default';
			$excerpt_length = isset( $instance['excerpt_length'] ) ? absint( $instance['excerpt_length'] ) : 0;
			$meta_release_date = isset( $instance['meta_release_date'] ) ? (bool) $instance['meta_release_date'] : 0;
			$meta_author = isset( $instance['meta_author'] ) ? (bool) $instance['meta_author'] : 0;
			$meta_date = isset( $instance['meta_date'] ) ? (bool) $instance['meta_date'] : 0;
			$meta_comment_count = isset( $instance['meta_comment_count'] ) ? (bool) $instance['meta_comment_count'] : 0;
			$meta_views = isset( $instance['meta_views'] ) ? (bool) $instance['meta_views'] : 0;
			$meta_likes = isset( $instance['meta_likes'] ) ? (bool) $instance['meta_likes'] : 0;
			$meta_cats = isset( $instance['meta_cats'] ) ? (bool) $instance['meta_cats'] : 0;
			$meta_tags = isset( $instance['meta_tags'] ) ? (bool) $instance['meta_tags'] : 0;
			$meta_hub_fields = isset( $instance['meta_hub_fields'] ) ? (bool) $instance['meta_hub_fields'] : 0;
			$meta_site_rating = isset( $instance['meta_site_rating'] ) ? (bool) $instance['meta_site_rating'] : 0;
			$meta_user_rating = isset( $instance['meta_user_rating'] ) ? (bool) $instance['meta_user_rating'] : 0;	
			$read_more_link = isset( $instance['read_more_link'] ) ? $instance['read_more_link'] : 'disabled';
				
			echo html_entity_decode( $before_widget );
	
				echo do_shortcode( '[blog 
				widget_title="' . $title . '"
				cats="' . $cats .'" 
				hub_fields="' . $hub_fields . '"
				page_ids="' . $page_ids . '" 
				post_types="' . $post_types . '" 
				post_association="' . $post_association . '"
				ranking="' . $ranking . '"
				format="' . $format . '" 
				orderby="' . $orderby . '"
				release_date_from="' . $release_date_from . '"
				release_date_to="' . $release_date_to . '"
				filter_cats="' . $filter_cats . '"
				filter_date="' . $filter_date . '"
				filter_title="' . $filter_title . '"
				filter_comment_count="' . $filter_comment_count . '"
				filter_likes="' . $filter_likes . '"
				filter_release_date="' . $filter_release_date . '"
				filter_release_date_asc="' . $filter_release_date_asc . '"
				filter_site_rating="' . $filter_site_rating . '"
				filter_user_rating="' . $filter_user_rating . '"
				filter_cat_id="' . $filter_cat_id . '"
				per_page="' . $per_page . '" 
				offset="' . $offset . '" 
				image_size_standard="' . $image_size_standard . '"
				image_siz_hub="' . $image_size_hub . '"
				image_size_review="' . $image_size_review . '"
				image_size_preview="' . $image_size_preview . '"
				excerpt_length="' . $excerpt_length . '"
				meta_release_date="' . $meta_release_date . '"
				meta_author="' . $meta_author . '" 
				meta_date="' . $meta_date . '" 
				meta_comment_count="' . $meta_comment_count . '" 
				meta_views="' . $meta_views . '" 
				meta_likes="' . $meta_likes . '" 
				meta_cats="' . $meta_cats . '" 
				meta_tags="' . $meta_tags . '" 
				meta_hub_fields="' . $meta_hub_fields . '"
				meta_site_rating="' . $meta_site_rating . '"
				meta_user_rating="' . $meta_user_rating . '"
				read_more_link="' . $read_more_link . '"
				page_arrows="disabled" 
				pagination="disabled" 
				see_all="disabled"
				see_all_link="" 
				see_all_text=""
				classes="" 
				icon=""]' );
		
			echo html_entity_decode( $after_widget );

		}

		function update( $new_instance, $old_instance ) {
			$instance = $old_instance;
			$instance['title'] = isset( $new_instance['title'] ) ? sanitize_text_field( $new_instance['title'] ) : esc_html__( 'Blog Posts', 'huber' );
			$instance['cats'] = isset( $new_instance['cats'] ) ? $new_instance['cats'] : '';
			$instance['hub_fields'] = isset( $new_instance['hub_fields'] ) ? $new_instance['hub_fields'] : '';
			$instance['page_ids'] = isset( $new_instance['page_ids'] ) ? $new_instance['page_ids'] : '';
			$instance['post_types'] = isset( $new_instance['post_types'] ) ? $new_instance['post_types'] : 'post';
			$instance['post_association'] = isset( $new_instance['post_association'] ) ? $new_instance['post_association'] : 'disabled';	
			$instance['ranking'] = isset( $new_instance['ranking'] ) ? $new_instance['ranking'] : 'gp-no-ranking';
			$instance['format'] = isset( $new_instance['format'] ) ? $new_instance['format'] : 'gp-blog-list';
			$instance['orderby'] = isset( $new_instance['orderby'] ) ? $new_instance['orderby'] : 'newest';
			$instance['release_date_from'] = isset( $new_instance['release_date_from'] ) ? $new_instance['release_date_from'] : '';
			$instance['release_date_to'] = isset( $new_instance['release_date_to'] ) ? $new_instance['release_date_to'] : '';
			$instance['filter_cats'] = isset( $new_instance['filter_cats'] ) ? $new_instance['filter_cats'] : '';
			$instance['filter_date'] = isset( $new_instance['filter_date'] ) ? $new_instance['filter_date'] : '';
			$instance['filter_title'] = isset( $new_instance['filter_title'] ) ? $new_instance['filter_title'] : '';
			$instance['filter_comment_count'] = isset( $new_instance['filter_comment_count'] ) ? $new_instance['filter_comment_count'] : '';
			$instance['filter_likes'] = isset( $new_instance['filter_likes'] ) ? $new_instance['filter_likes'] : '';
			$instance['filter_release_date'] = isset( $new_instance['filter_release_date'] ) ? $new_instance['filter_release_date'] : '';
			$instance['filter_release_date_asc'] = isset( $new_instance['filter_release_date_asc'] ) ? $new_instance['filter_release_date_asc'] : '';
			$instance['filter_site_rating'] = isset( $new_instance['filter_site_rating'] ) ? $new_instance['filter_site_rating'] : '';
			$instance['filter_user_rating'] = isset( $new_instance['filter_user_rating'] ) ? $new_instance['filter_user_rating'] : '';
			$instance['filter_cat_id'] = isset( $new_instance['filter_cat_id'] ) ? $new_instance['filter_cat_id'] : '';
			$instance['per_page'] = isset( $new_instance['per_page'] ) ? absint( $new_instance['per_page'] ) : '5';
			$instance['offset'] = isset( $new_instance['offset'] ) ? absint( $new_instance['offset'] ) : '';
			$instance['image_size_standard'] = isset( $new_instance['image_size_standard'] ) ? $new_instance['image_size_standard'] : 'default';
			$instance['image_size_hub'] = isset( $new_instance['image_size_hub'] ) ? $new_instance['image_size_hub'] : 'default';
			$instance['image_size_review'] = isset( $new_instance['image_size_review'] ) ? $new_instance['image_size_review'] : 'default';
			$instance['image_size_preview'] = isset( $new_instance['image_size_preview'] ) ? $new_instance['image_size_preview'] : 'default';
			$instance['excerpt_length'] = isset( $new_instance['excerpt_length'] ) ? absint( $new_instance['excerpt_length'] ) : 0;
			$instance['meta_release_date'] = isset( $new_instance['meta_release_date'] ) ? (bool) $new_instance['meta_release_date'] : 0;
			$instance['meta_author'] = isset( $new_instance['meta_author'] ) ? (bool) $new_instance['meta_author'] : 0;
			$instance['meta_date'] = isset( $new_instance['meta_date'] ) ? (bool) $new_instance['meta_date'] : 0;
			$instance['meta_comment_count'] = isset( $new_instance['meta_comment_count'] ) ? (bool) $new_instance['meta_comment_count'] : 0;
			$instance['meta_views'] = isset( $new_instance['meta_views'] ) ? (bool) $new_instance['meta_views'] : 0;
			$instance['meta_likes'] = isset( $new_instance['meta_likes'] ) ? (bool) $new_instance['meta_likes'] : 0;
			$instance['meta_cats'] = isset( $new_instance['meta_cats'] ) ? (bool) $new_instance['meta_cats'] : 0;
			$instance['meta_tags'] = isset( $new_instance['meta_tags'] ) ? (bool) $new_instance['meta_tags'] : 0;
			$instance['meta_hub_fields'] = isset( $new_instance['meta_hub_fields'] ) ? (bool) $new_instance['meta_hub_fields'] : 0;
			$instance['meta_site_rating'] = isset( $new_instance['meta_site_rating'] ) ? (bool) $new_instance['meta_site_rating'] : 0;
			$instance['meta_user_rating'] = isset( $new_instance['meta_user_rating'] ) ? (bool) $new_instance['meta_user_rating'] : 0;
			$instance['read_more_link'] = isset( $new_instance['read_more_link'] ) ? $new_instance['read_more_link'] : 'disabled';	
			return $instance;
		}

		function form( $instance ) {
		
			// Defaults
			$title = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : esc_html__( 'Blog Posts', 'huber' );
			$cats = isset( $instance['cats'] ) ? esc_attr( $instance['cats'] ) : '';
			$hub_fields = isset( $instance['hub_fields'] ) ? esc_attr( $instance['hub_fields'] ) : '';
			$page_ids = isset( $instance['page_ids'] ) ? esc_attr( $instance['page_ids'] ) : '';
			$post_types = isset( $instance['post_types'] ) ? esc_attr( $instance['post_types'] ) : 'post';
			$post_association = isset( $instance['post_association'] ) ? esc_attr( $instance['post_association'] ) : 'disabled';
			$ranking = isset( $instance['ranking'] ) ? esc_attr( $instance['ranking'] ) : 'gp-no-ranking';
			$format = isset( $instance['format'] ) ? esc_attr( $instance['format'] ) : 'gp-blog-list';
			$orderby = isset( $instance['orderby'] ) ? esc_attr( $instance['orderby'] ) : 'newest';
			$release_date_from = isset( $instance['release_date_from'] ) ? esc_attr( $instance['release_date_from'] ) : '';
			$release_date_to = isset( $instance['release_date_to'] ) ? esc_attr( $instance['release_date_to'] ) : '';	
			$filter_cats = isset( $instance['filter_cats'] ) ? (bool) $instance['filter_cats'] : 0;
			$filter_date = isset( $instance['filter_date'] ) ? (bool) $instance['filter_date'] : 0;
			$filter_title = isset( $instance['filter_title'] ) ? (bool) $instance['filter_title'] : 0;
			$filter_comment_count = isset( $instance['filter_comment_count'] ) ? (bool) $instance['filter_comment_count'] : 0;
			$filter_likes = isset( $instance['filter_likes'] ) ? (bool) $instance['filter_likes'] : 0;
			$filter_release_date = isset( $instance['filter_release_date'] ) ? (bool) $instance['filter_release_date'] : 0;
			$filter_release_date_asc = isset( $instance['filter_release_date_asc'] ) ? (bool) $instance['filter_release_date_asc'] : 0;
			$filter_site_rating = isset( $instance['filter_site_rating'] ) ? (bool) $instance['filter_site_rating'] : 0;
			$filter_user_rating = isset( $instance['filter_user_rating'] ) ? (bool) $instance['filter_user_rating'] : 0;
			$filter_cat_id = isset( $instance['filter_cat_id'] ) ? esc_attr( $instance['filter_cat_id'] ) : '';				
			$per_page = isset( $instance['per_page'] ) ? absint( $instance['per_page'] ) : '5';
			$offset =  isset( $instance['offset'] ) ? absint( $instance['offset'] ) : '';
			$image_size_standard = isset( $instance['image_size_standard'] ) ? esc_attr( $instance['image_size_standard'] ) : 'default';
			$image_size_hub = isset( $instance['image_size_hub'] ) ? esc_attr( $instance['image_size_hub'] ) : 'default';
			$image_size_review = isset( $instance['image_size_review'] ) ? esc_attr( $instance['image_size_review'] ) : 'default';
			$image_size_preview = isset( $instance['image_size_preview'] ) ? esc_attr( $instance['image_size_preview'] ) : 'default';
			$excerpt_length = isset( $instance['excerpt_length'] ) ? absint( $instance['excerpt_length'] ) : 0;
			$meta_release_date = isset( $instance['meta_release_date'] ) ? (bool) $instance['meta_release_date'] : 0;
			$meta_author = isset( $instance['meta_author'] ) ? (bool) $instance['meta_author'] : 0;
			$meta_date = isset( $instance['meta_date'] ) ? (bool) $instance['meta_date'] : 0;
			$meta_comment_count = isset( $instance['meta_comment_count'] ) ? (bool) $instance['meta_comment_count'] : 0;
			$meta_views = isset( $instance['meta_views'] ) ? (bool) $instance['meta_views'] : 0;
			$meta_likes = isset( $instance['meta_likes'] ) ? (bool) $instance['meta_likes'] : 0;
			$meta_cats = isset( $instance['meta_cats'] ) ? (bool) $instance['meta_cats'] : 0;
			$meta_tags = isset( $instance['meta_tags'] ) ? (bool) $instance['meta_tags'] : 0;		
			$meta_hub_fields = isset( $instance['meta_hub_fields'] ) ? (bool) $instance['meta_hub_fields'] : 0;
			$meta_site_rating = isset( $instance['meta_site_rating'] ) ? (bool) $instance['meta_site_rating'] : 0;
			$meta_user_rating = isset( $instance['meta_user_rating'] ) ? (bool) $instance['meta_user_rating'] : 0;	
			$read_more_link = isset( $instance['read_more_link'] ) ? esc_attr( $instance['read_more_link'] ) : 'disabled';
		
			?>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title:', 'huber' ); ?></label>
				<br/><input type="text" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" value="<?php echo esc_attr( $title ); ?>" />
			</p>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'cats' ) ); ?>"><?php esc_html_e( 'Categories:', 'huber' ); ?></label> 
				<br/><input type="text" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'cats' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'cats' ) ) ?>" value="<?php echo esc_attr( $cats ); ?>" />
				<br/><small><?php esc_html_e( 'Enter the slugs or IDs separating each one with a comma e.g. xbox,ps3,pc.', 'huber' ); ?></small>
			</p>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'hub_fields' ) ); ?>"><?php esc_html_e( 'Hub Fields:', 'huber' ); ?></label> 
				<br/><input type="text" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'hub_fields' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'hub_fields' ) ) ?>" value="<?php echo esc_attr( $hub_fields ); ?>" />
				<br/><small><?php wp_kses( _e( 'Enter the hub fields you want to filter by. Add the taxonomy slug followed by a colon. Next enter the terms separating each by a colon also. Next add a comma and then enter the next taxonomy and so on e.g. <code>taxonomy-1:term-1:term-2,taxonomy-2:term-1,taxonomy-3:term-1:term-2</code>, this would translate to <code>genre:action:role-playing,publisher:namco,developed-by:namco:bluepoint-games</code>', 'huber' ), array( 'code' => array() ) ); ?></small>
			</p>
		
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'page_ids' ) ); ?>"><?php esc_html_e( 'Page IDs:', 'huber' ); ?></label> 
				<br/><input type="text" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'page_ids' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'page_ids' ) ) ?>" value="<?php echo esc_attr( $page_ids ); ?>" />
				<br/><small><?php esc_html_e( 'Enter the IDs of the pages you want to include, separating each with a comma e.g. 48,142.', 'huber' ); ?></small>
			</p>
		
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'post_types' ) ); ?>"><?php esc_html_e( 'Post Types:', 'huber' ); ?></label> 
				<br/><input type="text" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'post_types' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'post_types' ) ) ?>" value="<?php echo esc_attr( $post_types ); ?>" />
				<br/><small><?php esc_html_e( 'Separate each post type with a comma e.g. post, page.', 'huber' ); ?></small>
			</p>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'post_association' ) ); ?>"><?php esc_html_e( 'Post Association:', 'huber' ); ?></label>
				<select id="<?php echo esc_attr( $this->get_field_id( 'post_association' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'post_association' ) ) ?>">
					<option value="enabled"<?php selected( $post_association, 'enabled' ); ?>><?php esc_html_e( 'Enabled', 'huber' ); ?></option>
					<option value="disabled"<?php selected( $post_association, 'disabled' ); ?>><?php esc_html_e( 'Disabled', 'huber' ); ?></option>
				</select>	
			</p>
		
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'ranking' ) ); ?>"><?php esc_html_e( 'Ranking:', 'huber' ); ?></label>
				<select id="<?php echo esc_attr( $this->get_field_id( 'ranking' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'ranking' ) ) ?>">
					<option value="gp-ranking"<?php selected( $ranking, 'gp-ranking' ); ?>><?php esc_html_e( 'Enabled', 'huber' ); ?></option>
					<option value="gp-no-ranking"<?php selected( $ranking, 'gp-no-ranking' ); ?>><?php esc_html_e( 'Disabled', 'huber' ); ?></option>
				</select>	
			</p>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'format' ) ); ?>"><?php esc_html_e( 'Format:', 'huber' ); ?></label>
				<select id="<?php echo esc_attr( $this->get_field_id( 'format' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'format' ) ) ?>">
					<option value="gp-blog-list"<?php selected( $format, 'gp-blog-list' ); ?>><?php esc_html_e( 'List', 'huber' ); ?></option>
					<option value="gp-blog-minimal"<?php selected( $format, 'gp-blog-minimal' ); ?>><?php esc_html_e( 'Minimal', 'huber' ); ?></option>
				</select>	
			</p>
								
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'orderby' ) ); ?>"><?php esc_html_e( 'Order By:', 'huber' ); ?></label>
				<select id="<?php echo esc_attr( $this->get_field_id( 'orderby' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'orderby' ) ) ?>">
					<option value="newest"<?php selected( $orderby, 'newest' ); ?>><?php esc_html_e( 'Newest', 'huber' ); ?></option>			
					<option value="oldest"<?php selected( $orderby, 'oldest' ); ?>><?php esc_html_e( 'Oldest', 'huber' ); ?></option> 			
					<option value="title_az"<?php selected( $orderby, 'title_az' ); ?>><?php esc_html_e( 'Title (A-Z)', 'huber' ); ?></option>
					<option value="title_za"<?php selected( $orderby, 'title_za' ); ?>><?php esc_html_e( 'Title (Z-A)', 'huber' ); ?></option>
					<option value="comment_count"<?php selected( $orderby, 'comment_count' ); ?>><?php esc_html_e( 'Most Comments', 'huber' ); ?></option>
					<option value="views"<?php selected( $orderby, 'views' ); ?>><?php esc_html_e( 'Most Views', 'huber' ); ?></option>
					<option value="likes"<?php selected( $orderby, 'likes' ); ?>><?php esc_html_e( 'Most Likes', 'huber' ); ?></option>
					<option value="menu_order"<?php selected( $orderby, 'menu_order' ); ?>><?php esc_html_e( 'Menu Order', 'huber' ); ?></option>
					<option value="rand"<?php selected( $orderby, 'rand' ); ?>><?php esc_html_e( 'Random', 'huber' ); ?></option>
					<option value="release_date"<?php selected( $orderby, 'release_date' ); ?>><?php esc_html_e( 'Latest Releases', 'huber' ); ?></option>
					<option value="release_date_asc"<?php selected( $orderby, 'disabled' ); ?>><?php esc_html_e( 'Oldest Releases', 'huber' ); ?></option>
					<option value="site_rating"<?php selected( $orderby, 'disabled' ); ?>><?php esc_html_e( 'Top Site Rated', 'huber' ); ?></option>
					<option value="user_rating"<?php selected( $orderby, 'disabled' ); ?>><?php esc_html_e( 'Top User Rated', 'huber' ); ?></option>
				</select>
			</p>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'release_date_from' ) ); ?>"><?php esc_html_e( 'Release Date From:', 'huber' ); ?></label> 
				<br/><input type="text" class="widefat gp-datepicker" id="<?php echo esc_attr( $this->get_field_id( 'release_date_from' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'release_date_from' ) ) ?>" value="<?php echo esc_attr( $release_date_from ); ?>" />
				<br/><small><?php esc_html_e( 'Enter "today" to use today\'s date e.g. only displays items with a release date later than today\'s date.', 'huber' ); ?></small>
			</p>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'release_date_to' ) ); ?>"><?php esc_html_e( 'Release Date To:', 'huber' ); ?></label> 
				<br/><input type="text" class="widefat gp-datepicker" id="<?php echo esc_attr( $this->get_field_id( 'release_date_to' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'release_date_to' ) ) ?>" value="<?php echo esc_attr( $release_date_to ); ?>" />
				<br/><small><?php esc_html_e( 'Enter "today" to use today\'s date e.g. only displays items with a release date with today\'s date and earlier.', 'huber' ); ?></small>
			</p>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'filters' ) ); ?>"><?php esc_html_e( 'Filters:', 'huber' ); ?></label><br/>
				<input type="checkbox" id="<?php echo esc_attr( $this->get_field_id( 'filter_cats' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'filter_cats' ) ); ?>" value="1" <?php checked( $filter_cats, 1 ); ?> /><label for="<?php echo esc_attr( $this->get_field_id( 'filter_cats' ) ); ?>"><?php esc_html_e( 'Categories', 'huber' ); ?></label>
				<input type="checkbox" id="<?php echo esc_attr( $this->get_field_id( 'filter_date' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'filter_date' ) ); ?>" value="1" <?php checked( $filter_date, 1 ); ?> /><label for="<?php echo esc_attr( $this->get_field_id( 'filter_date' ) ); ?>"><?php esc_html_e( 'Date', 'huber' ); ?></label>
				<input type="checkbox" id="<?php echo esc_attr( $this->get_field_id( 'filter_title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'filter_title' ) ); ?>" value="1" <?php checked( $filter_title, 1 ); ?> /><label for="<?php echo esc_attr( $this->get_field_id( 'filter_title' ) ); ?>"><?php esc_html_e( 'Title', 'huber' ); ?></label>
				<input type="checkbox" id="<?php echo esc_attr( $this->get_field_id( 'filter_comment_count' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'filter_comment_count' ) ); ?>" value="1" <?php checked( $filter_comment_count, 1 ); ?> /><label for="<?php echo esc_attr( $this->get_field_id( 'filter_comment_count' ) ); ?>"><?php esc_html_e( 'Comment Count', 'huber' ); ?></label>
				<input type="checkbox" id="<?php echo esc_attr( $this->get_field_id( 'filter_likes' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'filter_likes' ) ); ?>" value="1" <?php checked( $filter_likes, 1 ); ?> /><label for="<?php echo esc_attr( $this->get_field_id( 'filter_likes' ) ); ?>"><?php esc_html_e( 'Likes', 'huber' ); ?></label>
				<input type="checkbox" id="<?php echo esc_attr( $this->get_field_id( 'filter_release_date' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'filter_release_date' ) ); ?>" value="1" <?php checked( $filter_release_date, 1 ); ?> /><label for="<?php echo esc_attr( $this->get_field_id( 'filter_release_date' ) ); ?>"><?php esc_html_e( 'Latest Releases', 'huber' ); ?></label>
				<input type="checkbox" id="<?php echo esc_attr( $this->get_field_id( 'filter_release_date_asc' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'filter_release_date_asc' ) ); ?>" value="1" <?php checked( $filter_release_date_asc, 1 ); ?> /><label for="<?php echo esc_attr( $this->get_field_id( 'filter_release_date_asc' ) ); ?>"><?php esc_html_e( 'Oldest Releases', 'huber' ); ?></label>
				<input type="checkbox" id="<?php echo esc_attr( $this->get_field_id( 'filter_site_rating' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'filter_site_rating' ) ); ?>" value="1" <?php checked( $filter_site_rating, 1 ); ?> /><label for="<?php echo esc_attr( $this->get_field_id( 'filter_site_rating' ) ); ?>"><?php esc_html_e( 'Site Rating', 'huber' ); ?></label>
				<input type="checkbox" id="<?php echo esc_attr( $this->get_field_id( 'filter_user_rating' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'filter_user_rating' ) ); ?>" value="1" <?php checked( $filter_user_rating, 1 ); ?> /><label for="<?php echo esc_attr( $this->get_field_id( 'filter_user_rating' ) ); ?>"><?php esc_html_e( 'User Rating', 'huber' ); ?></label>
			</p>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'filter_cat_id' ) ); ?>"><?php esc_html_e( 'Filter Category:', 'huber' ); ?></label> 
				<br/><input type="text" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'filter_cat_id' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'filter_cat_id' ) ) ?>" value="<?php echo esc_attr( $filter_cat_id ); ?>" />
				<br/><small><?php esc_html_e( 'Enter the slug or ID of the category you want to filter by, leave blank to display all categories - the sub categories of this category will also be displayed.', 'huber' ); ?></small>
			</p>
										
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'per_page' ) ); ?>"><?php esc_html_e( 'Per Page:', 'huber' ); ?></label> <input type="text" id="<?php echo esc_attr( $this->get_field_id( 'per_page' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'per_page' ) ) ?>" value="<?php echo esc_attr( $per_page ); ?>" size="3" />
			</p>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'offset' ) ); ?>"><?php esc_html_e( 'Offset:', 'huber' ); ?></label> <input type="text" id="<?php echo esc_attr( $this->get_field_id( 'offset' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'offset' ) ) ?>" value="<?php echo esc_attr( $offset ); ?>" size="3" />
			</p>
				
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'image_size_standard' ) ); ?>"><?php esc_html_e( 'Standard Post Image Size:', 'huber' ); ?></label>
				<select id="<?php echo esc_attr( $this->get_field_id( 'image_size_standard' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'image_size_standard' ) ) ?>" class="widefat">
					<option value="default"<?php selected( $image_size_standard, 'disabled' ); ?>><?php esc_html_e( 'Default', 'huber' ); ?></option>
					<?php global $_wp_additional_image_sizes;
					$sizes = array();
					foreach ( get_intermediate_image_sizes() as $_size ) {
						if ( in_array( $_size, array( 'thumbnail', 'medium', 'medium_large', 'large' ) ) ) {
							$sizes[ $_size ]['width']  = get_option( "{$_size}_size_w" );
							$sizes[ $_size ]['height'] = get_option( "{$_size}_size_h" );
							$sizes[ $_size ]['crop']   = (bool) get_option( "{$_size}_crop" );
						} elseif ( isset( $_wp_additional_image_sizes[ $_size ] ) ) {
							$sizes[ $_size ] = array(
								'width'  => $_wp_additional_image_sizes[ $_size ]['width'],
								'height' => $_wp_additional_image_sizes[ $_size ]['height'],
								'crop'   => $_wp_additional_image_sizes[ $_size ]['crop'],
							);
						}
					
						/*if ( $image_size_standard == $_size ) {
							$selected = ' selected';
						} else {
							$selected = '';
						}*/
						echo '<option value="'. $_size . '"' . selected( $image_size_standard, $_size ) . '>' . $_size . ' (' . $sizes[ $_size ]['width'] . ' x ' . $sizes[ $_size ]['height'] . ')</option>';		
					} ?>
				</select>
				<br/><small><?php echo esc_html__( 'Choose from one of the default image sizes or you can register your own image size as explained', 'huber' ) . ' <a href="' . esc_url( 'https://ghostpool.ticksy.com/article/10923' ) . '">'. esc_html__( 'here', 'huber' ) . '</a>.'; ?></small>
			</p>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'image_size_hub' ) ); ?>"><?php esc_html_e( 'Standard Hub Image Size:', 'huber' ); ?></label>
				<select id="<?php echo esc_attr( $this->get_field_id( 'image_size_hub' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'image_size_hub' ) ) ?>" class="widefat">
					<option value="default"<?php if ( $image_size_hub == 'default' ) { echo ' selected="selected"'; } ?>><?php esc_html_e( 'Default', 'huber' ); ?></option>
					<?php global $_wp_additional_image_sizes;
					$sizes = array();
					foreach ( get_intermediate_image_sizes() as $_size ) {
						if ( in_array( $_size, array( 'thumbnail', 'medium', 'medium_large', 'large' ) ) ) {
							$sizes[ $_size ]['width']  = get_option( "{$_size}_size_w" );
							$sizes[ $_size ]['height'] = get_option( "{$_size}_size_h" );
							$sizes[ $_size ]['crop']   = (bool) get_option( "{$_size}_crop" );
						} elseif ( isset( $_wp_additional_image_sizes[ $_size ] ) ) {
							$sizes[ $_size ] = array(
								'width'  => $_wp_additional_image_sizes[ $_size ]['width'],
								'height' => $_wp_additional_image_sizes[ $_size ]['height'],
								'crop'   => $_wp_additional_image_sizes[ $_size ]['crop'],
							);
						}
						
						echo '<option value="'. $_size . '"' . selected( $image_size_hub, $_size ) . '>' . $_size . ' (' . $sizes[ $_size ]['width'] . ' x ' . $sizes[ $_size ]['height'] . ')</option>';		
					} ?>
				</select>
				<br/><small><?php echo esc_html__( 'Choose from one of the default image sizes or you can register your own image size as explained', 'huber' ) . ' <a href="' . esc_url( 'https://ghostpool.ticksy.com/article/10923' ) . '">'. esc_html__( 'here', 'huber' ) . '</a>.'; ?></small>
			</p>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'image_size_review' ) ); ?>"><?php esc_html_e( 'Standard Review Image Size:', 'huber' ); ?></label>
				<select id="<?php echo esc_attr( $this->get_field_id( 'image_size_review' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'image_size_review' ) ) ?>" class="widefat">
					<option value="default"<?php if ( $image_size_review == 'default' ) { echo ' selected="selected"'; } ?>><?php esc_html_e( 'Default', 'huber' ); ?></option>
					<?php global $_wp_additional_image_sizes;
					$sizes = array();
					foreach ( get_intermediate_image_sizes() as $_size ) {
						if ( in_array( $_size, array( 'thumbnail', 'medium', 'medium_large', 'large' ) ) ) {
							$sizes[ $_size ]['width']  = get_option( "{$_size}_size_w" );
							$sizes[ $_size ]['height'] = get_option( "{$_size}_size_h" );
							$sizes[ $_size ]['crop']   = (bool) get_option( "{$_size}_crop" );
						} elseif ( isset( $_wp_additional_image_sizes[ $_size ] ) ) {
							$sizes[ $_size ] = array(
								'width'  => $_wp_additional_image_sizes[ $_size ]['width'],
								'height' => $_wp_additional_image_sizes[ $_size ]['height'],
								'crop'   => $_wp_additional_image_sizes[ $_size ]['crop'],
							);
						}
						
						echo '<option value="'. $_size . '"' . selected( $image_size_review, $_size ) . '>' . $_size . ' (' . $sizes[ $_size ]['width'] . ' x ' . $sizes[ $_size ]['height'] . ')</option>';		
					} ?>
				</select>
				<br/><small><?php echo esc_html__( 'Choose from one of the default image sizes or you can register your own image size as explained', 'huber' ) . ' <a href="' . esc_url( 'https://ghostpool.ticksy.com/article/10923' ) . '">'. esc_html__( 'here', 'huber' ) . '</a>.'; ?></small>
			</p>
		
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'image_size_preview' ) ); ?>"><?php esc_html_e( 'Standard Preview Image Size:', 'huber' ); ?></label>
				<select id="<?php echo esc_attr( $this->get_field_id( 'image_size_preview' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'image_size_preview' ) ) ?>" class="widefat">
					<option value="default"<?php if ( $image_size_preview == 'default' ) { echo ' selected="selected"'; } ?>><?php esc_html_e( 'Default', 'huber' ); ?></option>
					<?php global $_wp_additional_image_sizes;
					$sizes = array();
					foreach ( get_intermediate_image_sizes() as $_size ) {
						if ( in_array( $_size, array( 'thumbnail', 'medium', 'medium_large', 'large' ) ) ) {
							$sizes[ $_size ]['width']  = get_option( "{$_size}_size_w" );
							$sizes[ $_size ]['height'] = get_option( "{$_size}_size_h" );
							$sizes[ $_size ]['crop']   = (bool) get_option( "{$_size}_crop" );
						} elseif ( isset( $_wp_additional_image_sizes[ $_size ] ) ) {
							$sizes[ $_size ] = array(
								'width'  => $_wp_additional_image_sizes[ $_size ]['width'],
								'height' => $_wp_additional_image_sizes[ $_size ]['height'],
								'crop'   => $_wp_additional_image_sizes[ $_size ]['crop'],
							);
						}
						
						echo '<option value="'. $_size . '"' . selected( $image_size_preview, $_size ) . '>' . $_size . ' (' . $sizes[ $_size ]['width'] . ' x ' . $sizes[ $_size ]['height'] . ')</option>';		
					} ?>
				</select>
				<br/><small><?php echo esc_html__( 'Choose from one of the default image sizes or you can register your own image size as explained', 'huber' ) . ' <a href="' . esc_url( 'https://ghostpool.ticksy.com/article/10923' ) . '">'. esc_html__( 'here', 'huber' ) . '</a>.'; ?></small>
			</p>
								
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'excerpt_length' ) ); ?>"><?php esc_html_e( 'Excerpt Length:', 'huber' ); ?></label> <input type="text" id="<?php echo esc_attr( $this->get_field_id( 'excerpt_length' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'excerpt_length' ) ) ?>" value="<?php echo esc_attr( $excerpt_length ); ?>" size="3" />
			</p>
															
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'post_meta' ) ); ?>"><?php esc_html_e( 'Post Meta:', 'huber' ); ?></label><br/>
			
				<input type="checkbox" id="<?php echo esc_attr( $this->get_field_id( 'meta_release_date' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'meta_release_date' ) ); ?>" value="1" <?php checked( $meta_release_date, 1 ); ?> /><label for="<?php echo esc_attr( $this->get_field_id( 'meta_release_date' ) ); ?>"><?php esc_html_e( 'Release Date', 'huber' ); ?></label>
			
				<input type="checkbox" id="<?php echo esc_attr( $this->get_field_id( 'meta_author' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'meta_author' ) ); ?>" value="1" <?php checked( $meta_author, 1 ); ?> /><label for="<?php echo esc_attr( $this->get_field_id( 'meta_author' ) ); ?>"><?php esc_html_e( 'Author Name', 'huber' ); ?></label>
			
				<input type="checkbox" id="<?php echo esc_attr( $this->get_field_id( 'meta_date' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'meta_date' ) ); ?>" value="1" <?php checked( $meta_date, 1 ); ?> /><label for="<?php echo esc_attr( $this->get_field_id( 'meta_date' ) ); ?>"><?php esc_html_e( 'Post Date', 'huber' ); ?></label>
			
				<input type="checkbox" id="<?php echo esc_attr( $this->get_field_id( 'meta_comment_count' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'meta_comment_count' ) ); ?>" value="1" <?php checked( $meta_comment_count, 1 ); ?> /><label for="<?php echo esc_attr( $this->get_field_id( 'meta_comment_count' ) ); ?>"><?php esc_html_e( 'Comment Count', 'huber' ); ?></label>
			
				<input type="checkbox" id="<?php echo esc_attr( $this->get_field_id( 'meta_views' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'meta_views' ) ); ?>" value="1" <?php checked( $meta_views, 1 ); ?> /><label for="<?php echo esc_attr( $this->get_field_id( 'meta_views' ) ); ?>"><?php esc_html_e( 'Views', 'huber' ); ?></label>
			
				<input type="checkbox" id="<?php echo esc_attr( $this->get_field_id( 'meta_likes' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'meta_likes' ) ); ?>" value="1" <?php checked( $meta_likes, 1 ); ?> /><label for="<?php echo esc_attr( $this->get_field_id( 'meta_likes' ) ); ?>"><?php esc_html_e( 'Likes', 'huber' ); ?></label>
			
				<input type="checkbox" id="<?php echo esc_attr( $this->get_field_id( 'meta_cats' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'meta_cats' ) ); ?>" value="1" <?php checked( $meta_cats, 1 ); ?> /><label for="<?php echo esc_attr( $this->get_field_id( 'meta_cats' ) ); ?>"><?php esc_html_e( 'Post Categories', 'huber' ); ?></label>
			
				<input type="checkbox" id="<?php echo esc_attr( $this->get_field_id( 'meta_tags' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'meta_tags' ) ); ?>" value="1" <?php checked( $meta_tags, 1 ); ?> /><label for="<?php echo esc_attr( $this->get_field_id( 'meta_tags' ) ); ?>"><?php esc_html_e( 'Post Tags', 'huber' ); ?></label>
			
				<input type="checkbox" id="<?php echo esc_attr( $this->get_field_id( 'meta_hub_fields' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'meta_hub_fields' ) ); ?>" value="1" <?php checked( $meta_hub_fields, 1 ); ?> /><label for="<?php echo esc_attr( $this->get_field_id( 'meta_hub_fields' ) ); ?>"><?php esc_html_e( 'Hub Fields', 'huber' ); ?></label>
			
				<input type="checkbox" id="<?php echo esc_attr( $this->get_field_id( 'meta_site_rating' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'meta_site_rating' ) ); ?>" value="1" <?php checked( $meta_site_rating, 1 ); ?> /><label for="<?php echo esc_attr( $this->get_field_id( 'meta_site_rating' ) ); ?>"><?php esc_html_e( 'Site Rating', 'huber' ); ?></label>
			
				<input type="checkbox" id="<?php echo esc_attr( $this->get_field_id( 'meta_user_rating' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'meta_user_rating' ) ); ?>" value="1" <?php checked( $meta_user_rating, 1 ); ?> /><label for="<?php echo esc_attr( $this->get_field_id( 'meta_user_rating' ) ); ?>"><?php esc_html_e( 'User Rating', 'huber' ); ?></label>
			</p>
		
			<p>	
				<label for="<?php echo esc_attr( $this->get_field_id( 'read_more_link' ) ); ?>"><?php esc_html_e( 'Read More Link:', 'huber' ); ?></label>
				<select id="<?php echo esc_attr( $this->get_field_id( 'read_more_link' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'read_more_link' ) ) ?>">
					<option value="enabled"<?php selected( $read_more_link, 'enabled' ); ?>><?php esc_html_e( 'Enabled', 'huber' ); ?></option>
					<option value="disabled"<?php selected( $read_more_link, 'disabled' ); ?>><?php esc_html_e( 'Disabled', 'huber' ); ?></option>
				</select>	
			</p>

			<script>
			jQuery( document ).ready( function( $ ) {
				$( function() {
					$( '.gp-datepicker' ).datepicker({ constrainInput: false });
				});
			});
			</script>

			<?php

		}
	}
}

?>