<?php if ( ! function_exists( 'ghostpool_affiliates' ) ) {
	function ghostpool_affiliates() {
		register_widget( 'GhostPool_Affiliates' );
	}
}
add_action( 'widgets_init', 'ghostpool_affiliates' );

if ( ! class_exists( 'GhostPool_Affiliates' ) ) {
	class GhostPool_Affiliates extends WP_Widget {
	
		function __construct() {
			$widget_ops = array( 'classname' => 'gp-affiliates-box-widget', 'description' => esc_html__( 'Display the affiliate links you have set from your posts/pages.', 'huber' ) );
			parent::__construct( 'gp-affiliates-widget', esc_html__( 'GP Affiliates', 'huber' ), $widget_ops );
		}

		function widget( $args, $instance ) {

			extract( $args );

			$title = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : esc_html__( 'Where To Buy', 'huber' );
			$buy_button_text = isset( $instance['buy_button_text'] ) ? esc_attr( $instance['buy_button_text'] ) : esc_html__( 'Buy', 'huber' );

			// Get post or hub association ID
			$a_post_id = get_hub_association_id( get_the_ID() );	
			
			// Get all affiliates for this post
			$affiliates = get_post_meta( $a_post_id, 'affiliates', true );

			if ( isset( $affiliates[0] ) && $affiliates[0] != '' ) {
		
				echo html_entity_decode( $before_widget ); ?>

					<?php if ( $title ) { ?>
						<h3 class="gp-affiliates-box-title"><?php echo esc_attr( $title ); ?></h3>
					<?php } ?>	
		
					<div class="gp-affiliates-box-post-title">
						<?php echo get_the_title( $a_post_id ); ?>
					</div>
		
					<div class="gp-affiliates">
		
						<?php if ( is_array( $affiliates ) ) {

							foreach( $affiliates as $affiliate ) { 
					
								if ( strpos( $affiliate, '|' ) === false ) {
						
									$affiliate_array[0] = '';
									$affiliate_array[1] = '';
									$affiliate_array[2] = $affiliate;
									$affiliate_array[3] = $buy_button_text;
					
								} else {
	
									// Remove any spaces either side of |
									$affiliate = str_replace( ' |', '|', $affiliate );
									$affiliate = str_replace( '| ', '|', $affiliate );
			
									// Split affiliate info between | into arrays
									$affiliate_array = explode( '|', $affiliate );
							
								}

								?>
		
								<div class="gp-affiliate">
									<?php if ( isset( $affiliate_array[0] ) ) { ?>
										<div class="gp-affiliates-name"><?php echo esc_attr( $affiliate_array[0] ); ?><?php if ( isset( $affiliate_array[1] ) && $affiliate_array[1] != '' ) { ?>:<?php } ?></div>
									<?php } ?>	
									<?php if ( isset( $affiliate_array[1] ) ) { ?>
										<div class="gp-affiliates-price"><?php echo esc_attr( $affiliate_array[1] ); ?></div>
									<?php } ?>
									<?php if ( isset( $affiliate_array[2] ) ) { ?>
										<a href="<?php echo esc_url( $affiliate_array[2] ); ?>" class="gp-affiliates-link button" target="_blank" rel="nofollow"><?php if ( isset( $affiliate_array[3] ) ) { echo esc_attr( $affiliate_array[3] ); } else { echo $buy_button_text; } ?></a>
									<?php } ?>
								</div>
		
							<?php } 
						
						} else { ?>
					
							<div class="gp-affiliate">
								<a href="<?php echo esc_url( $affiliates ); ?>" class="gp-affiliates-link button" target="_blank" rel="nofollow"><?php echo esc_attr( $buy_button_text ); ?></a>
							</div>
						
						<?php } ?>
		
					</div>	
		
					<?php 
		
					$page_bg = get_post_meta( $a_post_id, 'page_header_bg', true ); 
		
					if ( $page_bg['url'] ) { ?>
						<div class="gp-standard-bg" style="background-image: url(<?php echo esc_url( $page_bg['url'] ); ?>);"></div>
					<?php } ?>

				<?php echo html_entity_decode( $after_widget );
			
			}	

		}

		function update( $new_instance, $old_instance ) {
			$instance = $old_instance;				
			$instance['title'] = isset( $new_instance['title'] ) ? sanitize_text_field( $new_instance['title'] ) : esc_html__( 'Where To Buy', 'huber' );
			$instance['buy_button_text'] = isset( $new_instance['buy_button_text'] ) ? sanitize_text_field( $new_instance['buy_button_text'] ) : esc_html__( 'Buy', 'huber' );
			return $instance;
		}

		function form( $instance ) {
	
			// Defaults
			$title = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : esc_html__( 'Where To Buy', 'huber' );
			$buy_button_text = isset( $instance['buy_button_text'] ) ? esc_attr( $instance['buy_button_text'] ) : esc_html__( 'Buy', 'huber' );
		
			?>
						
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title:', 'huber' ); ?></label>
				<br/><input type="text" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" value="<?php echo esc_attr( $title ); ?>" />
			</p>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'buy_button_text' ) ); ?>"><?php esc_html_e( 'Buy Button Text:', 'huber' ); ?></label>
				<br/><input type="text" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'buy_button_text' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'buy_button_text' ) ); ?>" value="<?php echo esc_attr( $buy_button_text ); ?>" <br/><small><?php esc_html_e( 'Can overwrite this and change the button text for each link from the Affiliates option.', 'huber' ); ?></small>
			</p>
											
			<?php

		}
	}
}

?>