<?php if ( ghostpool_option( 'following_items' ) !== 'disabled' ) {

	if ( ghostpool_list_follow_items( get_current_user_id() ) && is_user_logged_in() ) {

		$args = array(
			'post_status' => 'publish',
			'post_type'   => array( 'post', 'page' ), 
			'post__in'    => ghostpool_list_follow_items( get_current_user_id() ),
			'orderby'     => 'post__in',
			'per_page'    => -1,
		);

		$args = apply_filters( 'ghostpool_following_query', $args );

		$gp_query = new wp_query( $args ); ?>	

		<div class="gp-blog-wrapper gp-following-wrapper gp-blog-list">

			<?php if ( $gp_query->have_posts() ) : ?>
	
				<div class="gp-section-loop">
		
					<div class="gp-section-loop-inner">		

						<?php while ( $gp_query->have_posts() ) : $gp_query->the_post(); 
	
							// Display modified items
							if ( ghostpool_option( 'following_items_modified' ) == 'enabled' ) {
								$modified = array( 'column' => 'post_modified_gmt', 'after' =>  ghostpool_option( 'following_items_days_ago' ) . ' days ago' );
							} else {
								$modified = '';
							}
						
							?>
						
							<section <?php post_class( 'gp-post-item' ); ?>>

								<?php if ( has_post_thumbnail() ) { ?>
									<div class="gp-post-thumbnail gp-loop-featured">
										<a href="<?php if ( get_post_format() == 'link' ) { echo esc_url( get_post_meta( get_the_ID(), 'link', true ) ); } else { the_permalink(); } ?>" title="<?php the_title_attribute(); ?>"<?php if ( get_post_format() == 'link' ) { ?> target="<?php echo get_post_meta( get_the_ID(), 'link_target', true ); ?>"<?php } ?>><?php the_post_thumbnail( apply_filters( 'ghostpool_following_image_size', 'thumbnail' ) ); ?></a>					
									</div>
								<?php } ?>

								<div class="gp-loop-content">	
									<h2 class="gp-loop-title"><a href="<?php if ( get_post_format() == 'link' ) { echo esc_url( get_post_meta( get_the_ID(), 'link', true ) ); } else { the_permalink(); } ?>" title="<?php the_title_attribute(); ?>"<?php if ( get_post_format() == 'link' ) { ?> target="<?php echo get_post_meta( get_the_ID(), 'link_target', true ); ?>"<?php } ?>><?php the_title(); ?></a></h2>
								</div>
								
								<?php ghostpool_remove_follow_button( get_the_ID() ); ?>
						
								<?php
		
								// Hub posts and child pages that have been created in the last X days
								$args = array(
									'post_status' => 'publish',
									'post_type'   => ghostpool_option( 'following_items_post_types' ),
									'posts_per_page' => ghostpool_option( 'following_items_per_page' ),
									'paged' => 1,
									'meta_query'  => array( 
										'relation' => 'OR',
										array( 'key' => 'hub_association_ids', 'value' => sprintf( ' "%s" ', get_the_ID() ), 'compare' => 'LIKE' ),										
										array( 'key' => 'hub_association_ids', 'value' => get_the_ID(), 'compare' => '=' ),
									),	
									'date_query' => array(
										'relation' => 'OR',
										array(
											'column' => 'post_date_gmt', 
											'after' => ghostpool_option( 'following_items_days_ago' ) . ' days ago',
										), 
										$modified
									),	
								);
					
								$args = apply_filters( 'ghostpool_following_items_query', $args );

								$i_query = new wp_query( $args ); ?>	

								<?php if ( $i_query->have_posts() ) : ?>
		
									<div class="gp-followed-content">
			
										<div class="gp-last-updated-title"><?php echo sprintf( esc_html__( 'Last %s updates from the last %s days', 'huber' ), ghostpool_option( 'following_items_per_page' ), ghostpool_option( 'following_items_days_ago' ) ); ?></div>
			
										<?php while ( $i_query->have_posts() ) : $i_query->the_post(); ?>
			
											<section <?php post_class( 'gp-post-item' ); ?>>

												<h2 class="gp-loop-title"><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></h3>
																				
												<div class="gp-loop-meta">	
													<span class="gp-post-meta gp-meta-date"><?php the_time( get_option( 'date_format' ) ); ?><?php if ( ghostpool_option( 'following_items_modified' ) == 'enabled' && ( get_the_modified_date( get_option( 'date_format' ) ) != get_the_time( get_option( 'date_format' ) ) ) ) { ?> (<?php esc_html_e( 'Updated on' , 'huber' ); ?> <?php the_modified_date( get_option( 'date_format' ) ); ?>)<?php } ?></span>
												</div>
					
											</section>
			
										<?php endwhile; ?>
						
									</div>
			
								<?php endif; wp_reset_postdata(); ?>

							</section>	

						<?php endwhile; ?>
			
					</div>	

				</div>

				<?php echo ghostpool_clear_list_link(); ?>

				<?php echo ghostpool_pagination( $gp_query->max_num_pages ); ?>

			<?php else : ?>

				<strong class="gp-no-items-found"><?php esc_html_e( 'No items found.', 'huber' ); ?></strong>

			<?php endif; wp_reset_postdata(); ?>
	
		</div>	

	<?php } else { ?>

		<?php if ( is_user_logged_in() ) { ?>

			<strong class="gp-no-items-found"><?php esc_html_e( 'You are not currently following any items.', 'huber' ); ?></strong>

		<?php } else { ?>

			<strong class="gp-no-items-found"><?php esc_html_e( 'Please login to follow items.', 'huber' ); ?></strong>

		<?php } ?>

	<?php }

}