<?php if ( ghostpool_option( 'reviews_tab' ) == 'enabled' ) { 

	$format = ghostpool_option( 'reviews_tab_format' );
	$image_size_standard = ghostpool_option( 'reviews_tab_standard_post_image_size' );
	$image_size_hub = ghostpool_option( 'reviews_tab_hub_image_size' );
	$image_size_review = ghostpool_option( 'reviews_tab_review_image_size' );
	$image_size_preview = ghostpool_option( 'reviews_tab_preview_image_size' );
	$content_display = ghostpool_option( 'reviews_tab_content_display' );
	$excerpt_length = ghostpool_option( 'reviews_tab_excerpt_length' );
	$meta_release_date = ghostpool_option( 'reviews_tab_meta', 'release_date' );
	$meta_author = ghostpool_option( 'reviews_tab_meta', 'author' );
	$meta_date = ghostpool_option( 'reviews_tab_meta', 'date' );
	$meta_comment_count = ghostpool_option( 'reviews_tab_meta', 'comment_count' );
	$meta_views = ghostpool_option( 'reviews_tab_meta', 'views' );
	$meta_likes = ghostpool_option( 'reviews_tab_meta', 'likes' );
	$meta_followers = ghostpool_option( 'reviews_tab_meta', 'followers' );
	$meta_cats = ghostpool_option( 'reviews_tab_meta', 'cats' );
	$meta_tags = ghostpool_option( 'reviews_tab_meta', 'tags' );
	$meta_hub_fields = ghostpool_option( 'reviews_tab_meta', 'hub_fields' );
	$meta_site_rating = ghostpool_option( 'reviews_tab_meta', 'site_rating' );
	$meta_user_rating = ghostpool_option( 'reviews_tab_meta', 'user_rating' );
	$read_more_link = ghostpool_option( 'reviews_tab_read_more_link' );
	
	?>

	<div id="gp-reviews-tab-page" class="gp-hub-tab-page">

		<?php
		
		// Get post or hub association ID
		$a_post_id = get_hub_association_id( get_the_ID() );

		$args = array(
			'post_status'    => 'publish',
			'post_type'      => array( 'post', 'page' ),		
			'orderby'        => ghostpool_orderby( ghostpool_option( 'reviews_tab_orderby' ), 'orderby' ),
			'order'          => ghostpool_orderby( ghostpool_option( 'reviews_tab_orderby' ), 'order' ),
			'meta_key'       => ghostpool_orderby( ghostpool_option( 'reviews_tab_orderby' ), 'meta_key' ),
			'meta_query' 	 => array( 
				'relation' => 'AND', 
				array(
					'relation' => 'OR', 
					array( 'key' => 'hub_association_ids', 'value' => sprintf( ' "%s" ', get_the_ID() ), 'compare' => 'LIKE' ),
					array( 'key' => 'hub_association_ids', 'value' => get_the_ID(), 'compare' => '=' ),
				),	
				array( 'key' => 'template', 'value' => 'gp-review-post', 'compare' => '=' ),
			),
			'posts_per_page' => ghostpool_option( 'reviews_tab_per_page' ),
			'paged'          => ghostpool_paged(),
			'ignore_sticky_posts' => 1,
		);
		$args = apply_filters( 'ghostpool_reviews_tab_query', $args );

		$gp_query = new WP_Query( $args );
		
		if ( $gp_query->have_posts() ) : ?>
			
			<?php if ( ghostpool_option( 'reviews_tab_page_title' ) ) { ?><h3 class="gp-hub-sub-header"><?php echo esc_attr( ghostpool_option( 'reviews_tab_page_title' ) ); ?></h3><?php } ?>

			<div class="gp-blog-wrapper <?php echo sanitize_html_class( ghostpool_option( 'reviews_tab_format' ) ); ?>" data-type="reviews-tab-page" data-postid="<?php echo $a_post_id; ?>" data-format="<?php echo esc_attr( ghostpool_option( 'reviews_tab_format' ) ); ?>" data-orderby="<?php echo esc_attr( ghostpool_option( 'reviews_tab_orderby' ) ); ?>" data-perpage="<?php echo absint( ghostpool_option( 'reviews_tab_per_page' ) ); ?>" data-offset="<?php echo esc_attr( ghostpool_option( 'reviews_tab_offset' ) ); ?>" data-imagesizestandard="<?php echo esc_attr( $image_size_standard ); ?>" data-imagesizehub="<?php echo esc_attr( $image_size_hub ); ?>" data-imagesizereview="<?php echo esc_attr( $image_size_review ); ?>" data-imagesizepreview="<?php echo esc_attr( $image_size_preview ); ?>" data-contentdisplay="<?php echo esc_attr( ghostpool_option( 'reviews_tab_content_display' ) ); ?>" data-excerptlength="<?php echo absint( ghostpool_option( 'reviews_tab_excerpt_length' ) ); ?>" data-metareleasedate="<?php echo esc_attr( ghostpool_option( 'reviews_tab_meta', 'release_date' ) ); ?>"  data-metaauthor="<?php echo esc_attr( ghostpool_option( 'reviews_tab_meta', 'author' ) ); ?>" data-metadate="<?php echo esc_attr( ghostpool_option( 'reviews_tab_meta', 'date' ) ); ?>" data-metacommentcount="<?php echo esc_attr( ghostpool_option( 'reviews_tab_meta', 'comment_count' ) ); ?>" data-metaviews="<?php echo esc_attr( ghostpool_option( 'reviews_tab_meta', 'views' ) ); ?>" data-metalikes="<?php echo esc_attr( ghostpool_option( 'reviews_tab_meta', 'likes' ) ); ?>" data-metafollowers="<?php echo esc_attr( ghostpool_option( 'reviews_tab_meta', 'followers' ) ); ?>" data-metacats="<?php echo esc_attr( ghostpool_option( 'reviews_tab_meta', 'cats' ) ); ?>" data-metatags="<?php echo esc_attr( ghostpool_option( 'reviews_tab_meta', 'tags' ) ); ?>" data-metahubfields="<?php echo esc_attr( ghostpool_option( 'reviews_tab_meta', 'hub_fields' ) ); ?>" data-metasiterating="<?php echo esc_attr( ghostpool_option( 'reviews_tab_meta', 'site_rating' ) ); ?>" data-metauserrating="<?php echo esc_attr( ghostpool_option( 'reviews_tab_meta', 'user_rating' ) ); ?>" data-readmorelink="<?php echo esc_attr( ghostpool_option( 'reviews_tab_read_more_link' ) ); ?>" data-pagination="page-numbers">
						
				<?php ghostpool_filter(
					ghostpool_option( 'reviews_tab_filters' ),
					'',
					ghostpool_option( 'reviews_tab_orderby' ),
					'page-numbers'
				); ?>	
				
				<div class="gp-section-loop <?php echo sanitize_html_class( ghostpool_option( 'ajax' ) ); ?>">

					<div class="gp-section-loop-inner">			
						<?php if ( ghostpool_option( 'reviews_tab_format' ) == 'blog-masonry' ) { ?><div class="gp-gutter-size"></div><?php } ?>
						<?php while ( $gp_query->have_posts() ) : $gp_query->the_post(); ?>
							<?php if ( function_exists( 'ghostpool_post_loop' ) ) { ghostpool_post_loop( $format, $image_size_standard, $image_size_hub, $image_size_review, $image_size_preview, $content_display, $excerpt_length, $meta_release_date, $meta_author, $meta_date, $meta_comment_count, $meta_views, $meta_likes, $meta_followers, $meta_cats, $meta_tags, $meta_hub_fields, $meta_site_rating, $meta_user_rating, $read_more_link ); } ?>
						<?php endwhile; ?>
					</div>

					<?php echo ghostpool_pagination( $gp_query->max_num_pages, 'page-numbers' ); ?>

				</div>

			</div>

		<?php endif; wp_reset_postdata(); ?>


		<?php
		
		$args = array(
			'post_status' => 'publish',
			'post_type' => 'post',		
			'orderby'        => ghostpool_orderby( ghostpool_option( 'reviews_tab_orderby' ), 'orderby' ),
			'order'          => ghostpool_orderby( ghostpool_option( 'reviews_tab_orderby' ), 'order' ),
			'meta_key'       => ghostpool_orderby( ghostpool_option( 'reviews_tab_orderby' ), 'meta_key' ),
			'meta_query' 	 => array( 
				'relation' => 'AND', 
				array( 'key' => 'ghostpool_hub_page_id', 'value' => get_the_ID(), 'compare' => '=' ),
			),
			'posts_per_page' => ghostpool_option( 'reviews_tab_per_page' ),	
			'paged'          => ghostpool_paged(),
			'ignore_sticky_posts' => 1,
		);
		
		$args = apply_filters( 'ghostpool_user_reviews_tab_query', $args );

		$gp_query = new WP_Query( $args );
		
		if ( $gp_query->have_posts() ) : ?>
		
			<?php if ( ghostpool_option( 'user_reviews_tab_page_title' ) ) { ?><h3 class="gp-hub-sub-header"><?php echo esc_attr( ghostpool_option( 'user_reviews_tab_page_title' ) ); ?></h3><?php } ?>	

			<div class="gp-blog-wrapper <?php echo sanitize_html_class( ghostpool_option( 'reviews_tab_format' ) ); ?>" data-type="user-reviews-tab-page" data-postid="<?php echo $a_post_id; ?>" data-format="<?php echo esc_attr( ghostpool_option( 'reviews_tab_format' ) ); ?>" data-orderby="<?php echo esc_attr( ghostpool_option( 'reviews_tab_orderby' ) ); ?>" data-perpage="<?php echo absint( ghostpool_option( 'reviews_tab_per_page' ) ); ?>" data-offset="<?php echo esc_attr( ghostpool_option( 'reviews_tab_offset' ) ); ?>" data-imagesizestandard="<?php echo esc_attr( $image_size_standard ); ?>" data-imagesizehub="<?php echo esc_attr( $image_size_hub ); ?>" data-imagesizereview="<?php echo esc_attr( $image_size_review ); ?>" data-imagesizepreview="<?php echo esc_attr( $image_size_preview ); ?>" data-contentdisplay="<?php echo esc_attr( ghostpool_option( 'reviews_tab_content_display' ) ); ?>" data-excerptlength="<?php echo absint( ghostpool_option( 'reviews_tab_excerpt_length' ) ); ?>" data-metareleasedate="<?php echo esc_attr( ghostpool_option( 'reviews_tab_meta', 'release_date' ) ); ?>"  data-metaauthor="<?php echo esc_attr( ghostpool_option( 'reviews_tab_meta', 'author' ) ); ?>" data-metadate="<?php echo esc_attr( ghostpool_option( 'reviews_tab_meta', 'date' ) ); ?>" data-metacommentcount="<?php echo esc_attr( ghostpool_option( 'reviews_tab_meta', 'comment_count' ) ); ?>" data-metaviews="<?php echo esc_attr( ghostpool_option( 'reviews_tab_meta', 'views' ) ); ?>" data-metalikes="<?php echo esc_attr( ghostpool_option( 'reviews_tab_meta', 'likes' ) ); ?>" data-metafollowers="<?php echo esc_attr( ghostpool_option( 'reviews_tab_meta', 'followers' ) ); ?>" data-metacats="<?php echo esc_attr( ghostpool_option( 'reviews_tab_meta', 'cats' ) ); ?>" data-metatags="<?php echo esc_attr( ghostpool_option( 'reviews_tab_meta', 'tags' ) ); ?>" data-metahubfields="<?php echo esc_attr( ghostpool_option( 'reviews_tab_meta', 'hub_fields' ) ); ?>" data-metasiterating="<?php echo esc_attr( ghostpool_option( 'reviews_tab_meta', 'site_rating' ) ); ?>" data-metauserrating="<?php echo esc_attr( ghostpool_option( 'reviews_tab_meta', 'user_rating' ) ); ?>" data-readmorelink="<?php echo esc_attr( ghostpool_option( 'reviews_tab_read_more_link' ) ); ?>" data-pagination="page-numbers">
							
				<?php ghostpool_filter(
					ghostpool_option( 'reviews_tab_filters' ),
					'',
					ghostpool_option( 'reviews_tab_orderby' ),
					'page-numbers'
				); ?>	
					
				<div class="gp-section-loop <?php echo sanitize_html_class( ghostpool_option( 'ajax' ) ); ?>">

					<div class="gp-section-loop-inner">				
						<?php if ( ghostpool_option( 'reviews_tab_format' ) == 'blog-masonry' ) { ?><div class="gp-gutter-size"></div><?php } ?>
						<?php while ( $gp_query->have_posts() ) : $gp_query->the_post(); ?>
							<?php ghostpool_post_loop( $format, $image_size_standard, $image_size_hub, $image_size_review, $image_size_preview, $content_display, $excerpt_length, $meta_release_date, $meta_author, $meta_date, $meta_comment_count, $meta_views, $meta_likes, $meta_followers, $meta_cats, $meta_tags, $meta_hub_fields, $meta_site_rating, $meta_user_rating, $read_more_link ); ?>
						<?php endwhile; ?>
					</div>

					<?php echo ghostpool_pagination( $gp_query->max_num_pages, 'page-numbers' ); ?>

				</div>

			</div>
		
		<?php endif; wp_reset_postdata(); ?>
	
	</div>
	
<?php } ?>	