<?php if ( isset( $_GET['post_submitted'] ) && $_GET['post_submitted'] == '1' ) { ?>

	<div class="gp-post-submission-success">
		<span class="gp-post-submission-success-icon"></span>
		<h4><?php esc_html_e( 'Thanks for submitting your post!', 'huber' ); ?></h4>
		<h5><?php if ( ghostpool_option( 'post_submission_status' ) == 'approved' ) {
			echo esc_html__( 'Your post was succesfully added. You can view your post', 'huber' ) . ' <span class="gp-view-post-link"><a href="' . get_permalink( $_GET['post_id'] ) . '">' . esc_html__( 'here', 'huber' ) . '</a>.</span>';
		} else {
			if ( get_option( 'permalink_structure' ) ) {
				$permalink_structure = '?';
			} else { 
				$permalink_structure = '&';
			}
			esc_html_e( 'Your post is currently being reviewed. ', 'huber' );
			if ( is_user_logged_in() ) {
				echo esc_html__( 'You can check the status of your post', 'huber' ) . ' <span class="gp-view-post-link"><a href="' . get_permalink( ghostpool_option( 'post_submission_page' ) ) . '">' . esc_html__( 'here', 'huber' ) . '</a>.</span>';
			}	
		} ?></h5>
	</div>
	
	
<?php } else { ?>

	<?php if ( ( ghostpool_option( 'post_submission_visitors' ) == 'enabled' && ! is_user_logged_in() ) OR is_user_logged_in() ) { ?>

		<?php if ( isset( $_GET['hub_id'] ) ) { ?>
			<div id="post-submission-notice"><?php esc_html_e( 'You are posting a review for', 'huber' ); ?> <?php echo get_the_title( $_GET['hub_id'] ); ?>.</div>
		<?php } ?>

		<form id="gp-post-submission-form" name="ghostpool_post_submission_form" method="post" enctype="multipart/form-data">	

			<p class="gp-post-submission-title">
				<input type="text" name="ghostpool_post_title" value="<?php if ( isset( $_POST['ghostpool_post_title'] ) ) { echo esc_attr( $_POST['ghostpool_post_title'] ); } ?>" placeholder="<?php esc_html_e( 'Enter title', 'huber' ); ?>" required>
			</p>

			<p class="gp-post-submission-image">
				<img src="" alt="" class="gp-add-image" />
				<input type="file" name="ghostpool_post_image" id="gp-post-image" data-image-added="<?php esc_html_e( 'Image added', 'huber' ); ?>" data-image-not-added="<?php esc_html_e( 'Invalid image format', 'huber' ); ?>" />
				<label for="gp-post-image" class="button"><?php esc_html_e( 'Add image', 'huber' ); ?></label>					
			</p>
		
			<?php if ( ! is_user_logged_in() ) { ?>
				<p class="gp-post-submission-name">
					<input type="text" name="ghostpool_post_username" value="<?php if ( isset( $_POST['ghostpool_post_username'] ) ) { echo esc_attr( $_POST['ghostpool_post_username'] ); } ?>" placeholder="<?php esc_html_e( 'Enter name', 'huber' ); ?>" required>
				</p>
			<?php } else { ?>
				<input type="hidden" name="ghostpool_username" value="">
			<?php } ?>

			<?php if ( ! is_user_logged_in() ) { ?>
				<p class="gp-post-submission-email">
					<input type="text" name="ghostpool_post_email" value="<?php if ( isset( $_POST['ghostpool_post_email'] ) ) { echo esc_attr( $_POST['ghostpool_post_email'] ); } ?>" placeholder="<?php esc_html_e( 'Enter email', 'huber' ); ?>" required>
				</p>
			<?php } else { ?>
				<input type="hidden" name="ghostpool_email" value="">
			<?php } ?>

			<p class="gp-post-submission-rating">
				<input type="text" name="ghostpool_post_user_rating" value="<?php if ( isset( $_POST['ghostpool_post_user_rating'] ) ) { echo floatval( $_POST['ghostpool_post_user_rating'] ); } ?>"  maxlength="3" size="3" placeholder="<?php esc_html_e( 'Enter rating', 'huber' ); ?>" required>		
				<?php if ( isset( $_POST['ghostpool_post_user_rating'] ) && ( trim( $_POST['ghostpool_post_user_rating'] ) === '' OR $_POST['ghostpool_post_user_rating'] < 1 OR $_POST['ghostpool_post_user_rating'] > ghostpool_option( 'rating_number' ) OR ! is_numeric( $_POST['ghostpool_post_user_rating'] ) ) ) { ?>
					<span class="gp-post-submission-inline-error"><?php esc_html_e( 'Invalid rating', 'huber' ); ?></span>
				<?php } ?>							                       
			</p>
						
			<?php if ( ghostpool_option( 'post_submission_categories' ) == 'enabled' ) { ?>
				<p class="gp-post-submission-categories">
					<?php 
					
					if ( ghostpool_option( 'post_submission_parent_category' ) ) {					
						$cat_id = (int) ghostpool_option( 'post_submission_parent_category' )[0];
					} else {
						$cat_id = '';
					}	
					
					$args = array(
						'parent'     => $cat_id,
						'hide_empty' => false,
					);
					$term = term_exists( $cat_id, 'category' );
					if ( $term !== 0 && $term !== null ) {
						$terms = get_terms( 'category', $args );
					} else {
						$terms = get_terms( 'category' );
					}
					if ( ! empty( $terms ) ) { ?>
						<select name="ghostpool_post_categories" required>	
							<option value=""><?php esc_html_e( 'Select a category', 'huber' ); ?></option>							
							<?php foreach ( $terms as $term ) { 
								if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) { ?>
									<option value="<?php echo esc_attr( $term->term_id ); ?>"><?php echo esc_attr( $term->name ); ?></option>
								<?php }
							} ?>
						</select>
					<?php } ?>
				</p>
			<?php } ?>
		
			<?php if ( ghostpool_option( 'post_submission_formats' ) == 'enabled' ) { ?>
				<p class="gp-post-submission-formats">
					<input type="radio" name="ghostpool_post_formats" value="0" required checked><label><?php esc_html_e( 'Standard', 'huber' ); ?></label>
					<?php $post_formats = get_theme_support( 'post-formats' ); ?>
					<?php foreach ( $post_formats[0] as $post_format ) { ?>
						<input type="radio" name="ghostpool_post_formats" value="<?php echo esc_attr( $post_format ); ?>"><label><?php echo esc_attr( ucfirst( $post_format ) ); ?></label>
					<?php } ?>
				</p>
			<?php } ?>	
										
			<p class="gp-post-submission-content">
				<textarea name="ghostpool_post_content" placeholder="<?php esc_html_e( 'Enter text', 'huber' ); ?>" required><?php if ( isset( $_POST['ghostpool_post_content'] ) ) { echo stripslashes( html_entity_decode( $_POST['ghostpool_post_content'] ) ); } ?></textarea>
			</p>
	
			<p class="gp-post-submission-tags">
				<input type="text" name="ghostpool_post_tags" value="<?php if ( isset( $_POST['ghostpool_post_tags'] ) ) { echo esc_attr( $_POST['ghostpool_post_tags'] ); } ?>" placeholder="<?php esc_html_e( 'Separate tags with commas', 'huber' ); ?>">
			</p>
	
			<?php if ( ghostpool_option( 'post_submission_toc_url' ) ) { ?>
				<p class="gp-post-submission-toc">
					<input type="checkbox" name="ghostpool_post_toc" value="1"<?php if ( isset( $_POST['ghostpool_post_toc'] ) ) { ?> checked<?php } ?> required><?php esc_html_e( 'I agree with the', 'huber' ); ?> <a href="<?php echo esc_url( ghostpool_option( 'post_submission_toc_url' ) ); ?>" target="_blank"><?php esc_html_e( 'terms and conditions', 'huber' ); ?></a>
				</p>
			<?php } ?>	
			
			<?php if ( function_exists( 'ghostpool_custom_captcha_display' ) ) {
				echo ghostpool_custom_captcha_display();
			} elseif ( function_exists( 'gglcptch_display' ) ) { 
				echo gglcptch_display(); 
			} elseif ( has_filter( 'hctpc_verify' ) ) {
				echo apply_filters( 'hctpc_display', '' );
			} elseif ( has_filter( 'cptch_verify' ) ) {
				echo apply_filters( 'cptch_display', '' ); 
			} ?>

			<p class="gp-post-submission-submit">
				<input type="submit" value="<?php esc_attr_e( 'Submit Post', 'huber' ); ?>" tabindex="40" id="submit" name="submit" />
			</p>

			<?php if ( ghostpool_option( 'post_submission_gdpr' ) == 'enabled' ) { ?>
				<p class="gp-gdpr"><input name="gdpr" class="gdpr" type="checkbox" value="1" required /> <label><?php echo wp_kses_post( ghostpool_option( 'post_submission_gdpr_text' ) ); ?></label></p>
			<?php } ?>
					
			<input type="hidden" name="ghostpool_action" value="ghostpool_submit_post" />

			<?php wp_nonce_field( 'ghostpool_post_submission_action', '_wpnonce' ); ?>

		</form>

	<?php } else {			
	
		if ( ghostpool_option( 'popup_box' ) == 'enabled' ) {
			$login_link = '#login';
		} else {
			$login_link = wp_login_url( apply_filters( 'the_permalink', get_permalink() ) );
		} ?>

		<div id="gp-post-submission-fail">
			<?php echo sprintf( wp_kses( __( 'You must be <a href="%s">logged in to submit a post</a>.', 'huber' ), array( 'a' => array( 'href' => array() ) ) ), apply_filters( 'ghostpool_login_link', $login_link ) ); ?>
		</div>
		
	<?php } ?>
	
<?php } ?>	