<?php if ( is_user_logged_in() ) {

	if ( get_option( 'permalink_structure' ) ) {
		$permalink_structure = '?';
	} else { 
		$permalink_structure = '&';
	}
					
	$current_user = wp_get_current_user();

	$args = array(
		'post_status' 	 => 'publish',
		'author' 		 => $current_user->ID,
		'post_type' => 'post',
		'meta_key' => 'ghostpool_hub_page_id',
		'paged' => 1,
		'posts_per_page' => -1,
	);
	
	$args = apply_filters( 'ghostpool_published_posts_query', $args, $current_user->ID );

	$gp_query = new WP_Query( $args ); ?>

	<div class="gp-blog-wrapper gp-approved-posts-wrapper <?php if ( ghostpool_option( 'post_submission_status' ) != 'pending' && ghostpool_option( 'post_editing_status' ) != 'pending' ) { ?> gp-approved-posts-fullwidth<?php } ?>">

		<h3><?php esc_html_e( 'Approved Posts', 'huber' ); ?></h3>

		<?php if ( $gp_query->have_posts() ) : ?>
			
			<div class="gp-section-loop">
			
				<div class="gp-section-loop-inner">
			
					<?php while ( $gp_query->have_posts() ) : $gp_query->the_post(); ?>

					   <section <?php post_class( 'gp-post-item' ); ?>>

							<div class="gp-loop-title"><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></div>	
					
							<div class="gp-loop-meta">
								<?php if ( ghostpool_option( 'post_editing_status' ) != 'disabled' ) { ?><span class="gp-post-meta"><a href="<?php echo get_permalink( ghostpool_option( 'post_submission_page' ) ) . $permalink_structure; ?>post_edit=1&post_id=<?php the_ID(); ?>&_wpnonce=<?php echo wp_create_nonce( 'ghostpool_post_edit_action' ); ?>"><?php esc_html_e( 'Edit', 'huber' ); ?></a></span><?php } ?>
								<?php if ( ghostpool_option( 'post_deleting' ) == 'enabled' && current_user_can( 'delete_posts' ) ) { ?><span class="gp-post-meta"><a href="<?php echo get_delete_post_link( get_the_ID() ); ?>" onClick="if ( confirm( '<?php esc_html_e( 'Are you sure you want to delete this post?', 'huber' ); ?>' ) ) return true; else return false;"><?php esc_html_e( 'Delete', 'huber' ); ?></a></span><?php } ?>
							</div>
					
						</section>
								
					<?php endwhile; ?>
					
				</div>	

			</div>

		<?php else : ?>

			<strong class="gp-no-items-found"><?php esc_html_e( 'No items found.', 'huber' ); ?></strong>

		<?php endif; wp_reset_postdata(); ?>

	</div>

	<?php if ( ghostpool_option( 'post_submission_status' ) == 'pending' OR ghostpool_option( 'post_editing_status' ) == 'pending' ) {

		$args = array(
			'post_status' => 'pending',
			'author' => $current_user->ID,
			'post_type' => 'post',
			'meta_key' => 'ghostpool_hub_page_id',
			'paged' => 1,
			'posts_per_page' => -1,
		);
		
		$args = apply_filters( 'ghostpool_pending_posts_query', $args, $current_user->ID );

		$gp_query = new WP_Query( $args ); ?>

		<div class="gp-blog-wrapper gp-pending-posts-wrapper">

			<h3><?php esc_html_e( 'Pending Posts', 'huber' ); ?></h3>

			<?php if ( $gp_query->have_posts() ) : ?>
			
				<div class="gp-section-loop">
			
					<div class="gp-section-loop-inner">
					
						<?php while ( $gp_query->have_posts() ) : $gp_query->the_post(); ?>
		   
							<section <?php post_class( 'gp-post-item' ); ?>>
						
								<div class="gp-loop-title"><a href="<?php echo get_permalink( ghostpool_option( 'post_submission_page' ) ) . $permalink_structure; ?>post_preview=1&id=<?php the_ID(); ?>&_wpnonce=<?php echo wp_create_nonce( 'ghostpool_post_preview_action' ); ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></div>	
							
							</section>	

						<?php endwhile; ?>
						
					</div>	

				</div>

			<?php else : ?>

				<strong class="gp-no-items-found"><?php esc_html_e( 'No items found.', 'huber' ); ?></strong>

			<?php endif; wp_reset_postdata(); ?>

		</div>

	<?php } ?>

<?php } else { ?>

	<strong class="gp-no-items-found"><?php esc_html_e( 'You must be logged in to view your posts.', 'huber' ); ?></strong>

<?php } ?>