<?php 

$custom_tabs = ghostpool_option( 'global_custom_tabs' );

if ( isset( $custom_tabs ) && '' !== $custom_tabs[0] ) {

	global $wp_query;

	foreach( $custom_tabs as $custom_tab ) {
	
		preg_match_all( "/(.*):(.*)/", $custom_tab, $matches );
		$endpoint = isset( $matches[1][0] ) ? $matches[1][0] : $custom_tab;
		
		if ( ghostpool_option( 'hub_tabs' ) == 'enabled' && isset( $wp_query->query[$endpoint] ) ) {	
		
			if ( '' !== locate_template( 'lib/sections/hub/' . $endpoint . '.php' ) ) {

				get_template_part( 'lib/sections/hub/' . $endpoint );
			
			} else {
		
				$page = get_posts( array( 
					'name' => $endpoint,
					'post_type' => 'any',
				) );
			
				if ( $page ) { ?>
			
					<div id="gp-<?php echo esc_attr( $endpoint ); ?>-tab-page" class="gp-hub-tab-page">

						<h3 class="gp-hub-sub-header"><?php echo $page[0]->post_title; ?></h3>
				
						<?php echo do_shortcode( $page[0]->post_content ); ?>
				
					</div>
					
				<?php }
		
			}
		
			break;	

		}	

	}

}