<?php 

global $post_id;
	
if ( has_post_thumbnail() ) { 

	global $gp_counter;
	
	// Image type
	if ( $gp_counter % 3 == 1 OR ( get_post_meta( $post_id, 'featured_box_format', true ) != 'gp-featured-box-3' && $gp_counter % 3 == 2 ) ) {
		$image = wp_get_attachment_image_src( get_post_thumbnail_id(), 'ghostpool-featured-box-large-image' );
	} else {
		$image = wp_get_attachment_image_src( get_post_thumbnail_id(), 'ghostpool-featured-box-small-image' );
	}	
	
	// Background position
	if ( get_post_meta( $post_id, 'featured_box_image_position', true ) == 'top-left' ) {
		$position = 'left top';
	} elseif ( get_post_meta( $post_id, 'featured_box_image_position', true ) == 'top-center' ) {
		$position = 'center top';
	} elseif ( get_post_meta( $post_id, 'featured_box_image_position', true ) == 'top-right' ) {
		$position = 'right top';
	} else {
		$position = 'center center';
	}
	
} else {
	$image = '';
}

// Ratings class
if ( ( get_post_meta( $post_id, 'featured_box_site_rating', true ) == 'enabled' && ghostpool_site_rating( get_the_ID() ) ) && ( get_post_meta( $post_id, 'featured_box_user_rating', true ) == 'enabled' && get_post_meta( get_the_ID(), 'ghostpool_user_rating', true ) ) ) { 
	$ratings_class = 'gp-has-both-ratings';
} else {
	$ratings_class = '';
}

// Caption class
if ( get_post_meta( $post_id, 'featured_box_caption_text', true ) == 'enabled' ) {
	$caption_class = 'gp-has-caption-text';
} else {
	$caption_class = '';
}

?>

<a href="<?php if ( get_post_format() == 'link' ) { echo esc_url( get_post_meta( get_the_ID(), 'link', true ) ); } else { the_permalink(); } ?>" title="<?php the_title_attribute(); ?>"<?php if ( get_post_format() == 'link' ) { ?> target="<?php echo get_post_meta( get_the_ID(), 'link_target', true ); ?>"<?php } ?><?php if ( has_post_thumbnail() ) { ?> style="background-image: url(<?php echo esc_url( $image[0] ); ?>); background-position: <?php echo esc_attr( $position ); ?>;"<?php } ?>>

	<?php if ( get_post_meta( $post_id, 'featured_box_caption_title', true ) == 'enabled' OR get_post_meta( $post_id, 'featured_box_caption_text', true ) == 'enabled' OR get_post_meta( $post_id, 'featured_box_site_rating', true ) == 'enabled' OR get_post_meta( $post_id, 'featured_box_user_rating', true ) == 'enabled' ) { ?>
		<div class="gp-featured-caption<?php if ( $ratings_class ) { echo ' ' . sanitize_html_class( $ratings_class ); } if ( $caption_class ) { echo ' ' . sanitize_html_class( $caption_class ); } ?>">
			<div class="gp-featured-caption-inner">
				<?php if ( get_post_meta( $post_id, 'featured_box_caption_title', true ) == 'enabled' ) {
					$limit = get_post_meta( $post_id, 'featured_box_caption_title_length', true );
					$featured_caption_title = get_the_title();
					if ( strlen( $featured_caption_title ) > $limit ) { 
						$featured_caption_title = mb_substr( $featured_caption_title, 0, (int) $limit ) . '...';
					} ?>	
					<h3 class="gp-featured-caption-title"><?php echo esc_attr( $featured_caption_title ); ?></h3>	
				<?php } ?>
				<?php if ( get_post_meta( $post_id, 'featured_box_caption_text', true ) == 'enabled' ) { ?>
					<div class="gp-featured-caption-text"><?php echo ghostpool_excerpt( get_post_meta( $post_id, 'featured_box_caption_text_length', true ) ); ?></div>	
				<?php } ?>	
			</div>
			
			<?php if ( ( get_post_meta( $post_id, 'featured_box_site_rating', true ) == 'enabled' && ghostpool_site_rating() ) OR ( get_post_meta( $post_id, 'featured_box_user_rating', true ) == 'enabled' && get_post_meta( $post_id, 'ghostpool_user_rating', true ) ) ) { ?>
				<span class="gp-header-ratings">
					<?php if ( get_post_meta( $post_id, 'featured_box_site_rating', true ) == 'enabled' ) {
						get_template_part( 'lib/sections/taxonomies/loop-site-rating' );
					}
					if ( get_post_meta( $post_id, 'featured_box_user_rating', true ) == 'enabled' ) {
						get_template_part( 'lib/sections/taxonomies/loop-user-rating' );
					} ?>
				</span>
			<?php } ?>
			
		</div>
	<?php } ?>
						
</a>