function ghostpool_vote( ID, type ) {

	// For the LocalStorage 
	var itemName = "gpvoting" + ID;
	var container = '#gp-voting-' + ID;

	// Check if the LocalStorage value exist. If do nothing.
	if ( ! localStorage.getItem( itemName ) ) {

		// Set HTML5 LocalStorage so the user can not vote again unless he clears it.							   
		localStorage.setItem( itemName, true );

		// Set the localStorage type as well
		var typeItemName = "gpvoting" + ID + "-" + type;
		localStorage.setItem( typeItemName, true );

		// Data for the Ajax Request
		var data = {
			action: 'ghostpool_add_vote',
			postid: ID,
			type: type,
			nonce: ghostpool_voting.nonce
		};
	
		jQuery.post( ghostpool_voting.ajaxurl, data, function( response ) {			
	
			var object = jQuery( container );
	
			jQuery(container).html( '' );
	
			jQuery(container).append( response );
	
			// Remove the class and ID so we don't have 2 DIVs with the same ID
			jQuery( object ).removeClass( 'gp-voting-container' );
			jQuery( object ).attr( 'id', '' );
	
			// Add the class to the clicked element
			var new_container = '#gp-voting-' + ID;
	
			// Check the type
			if ( type == 1 ) { 
				voting_class = ".gp-voting-up"; 
			} else { 
				voting_class = ".gp-voting-down";
			}
	
			jQuery( new_container +  voting_class ).addClass( 'gp-voted' );

		});
		
	} else {

		// Display message if we detect LocalStorage
		jQuery( '#gp-voting-' + ID + ' .gp-already-voted' ).fadeIn().css( 'display', 'block' );
		
	}
}