jQuery( function( $ ) {
	
	/*--------------------------------------------------------------
	Default values
	--------------------------------------------------------------*/

	var cats_filtered = 0;
	var templates_filtered = 0;
	var orderby_filtered = 0;
	var tab_cat_filtered = 0;
	var pagenumber = 1;
	
	
	/*--------------------------------------------------------------
	Get current value
	--------------------------------------------------------------*/

	function gpCurrentValue( parent ) {
		cats_filtered = parent.find( 'select[name="gp-filter-cats"]' ).val();
		if ( parent.find( '.gp-template-type' ).length  > 0 ) {
			templates_filtered = parent.find( '.gp-template-type:checked' ).map( function() {return this.value;} ).get().join( ',' );
		}	
		orderby_filtered = parent.find( 'select[name="gp-filter-orderby"]' ).val();
		pagenumber = 1;
	}
		
			   			
	/*--------------------------------------------------------------
	Load posts
	--------------------------------------------------------------*/
	
	function gpLoadPosts( element ) { 	

		var ajaxLoop = element.find( '.gp-ajax-loop' );	
		var filterWrapper = element.find( '.gp-filter-wrapper' );

		// Ajax query
		$.ajax({
			type: 'GET',
			data: {
				action: 'ghostpool_ajax_loop_action',
				ghostpool_ajax_loop_nonce: ghostpool_ajax_loop.nonce,
				querystring: ghostpool_ajax_loop.querystring,			
				cats_filtered: cats_filtered,
				templates_filtered: templates_filtered,
				orderby_filtered: orderby_filtered,
				tab_cat_filtered: tab_cat_filtered,
				pagenumber: pagenumber,			
				type: element.data('type'),
				postid: element.data('postid'),
				cats: element.data('cats'),
				hubfields: element.data('hubfields'),
				pageids: element.data('pageids'),
				posttypes: element.data('posttypes'),
				postassociation: element.data('postassociation'),
				ranking: element.data('ranking'),
				format: element.data('format'),
				templates: element.data('templates'),
				orderby: element.data('orderby'),
				releasedatefrom: element.data('releasedatefrom'),
				releasedateto: element.data('releasedateto'),
				perpage: element.data('perpage'),
				offset: element.data('offset'),
				imagesizestandard: element.data('imagesizestandard'),
				imagesizehub: element.data('imagesizehub'),
				imagesizereview: element.data('imagesizereview'),
				imagesizepreview: element.data('imagesizepreview'),
				contentdisplay: element.data('contentdisplay'),
				excerptlength: element.data('excerptlength'),
				metareleasedate: element.data('metareleasedate'),
				metaauthor: element.data('metaauthor'),
				metadate: element.data('metadate'),
				metacommentcount: element.data('metacommentcount'),
				metaviews: element.data('metaviews'),
				metalikes: element.data('metalikes'),
				metafollowers: element.data('metafollowers'),
				metacats: element.data('metacats'),
				metatags: element.data('metatags'),
				metahubfields: element.data('metahubfields'),
				metasiterating: element.data('metasiterating'),
				metauserrating: element.data('metauserrating'),
				readmorelink: element.data('readmorelink'),
				pagearrows: element.data('pagearrows'),
				pagination: element.data('pagination'),
				largeexcerptlength: element.data('largeexcerptlength'),
				smallexcerptlength: element.data('smallexcerptlength'),
				largemetareleasedate: element.data('largemetareleasedate'),
				smallmetareleasedate: element.data('smallmetareleasedate'),
				largemetaauthor: element.data('largemetaauthor'),
				smallmetaauthor: element.data('smallmetaauthor'),
				largemetadate: element.data('largemetadate'),
				smallmetadate: element.data('smallmetadate'),
				largemetacommentcount: element.data('largemetacommentcount'),
				smallmetacommentcount: element.data('smallmetacommentcount'),
				largemetaviews: element.data('largemetaviews'),
				smallmetaviews: element.data('smallmetaviews'),
				largemetalikes: element.data('largemetalikes'),
				smallmetalikes: element.data('smallmetalikes'),
				largemetafollowers: element.data('largemetafollowers'),
				smallmetafollowers: element.data('smallmetafollowers'),
				largemetacats: element.data('largemetacats'),
				smallmetacats: element.data('smallmetacats'),
				largemetatags: element.data('largemetatags'),
				smallmetatags: element.data('smallmetatags'),
				largemetahubfields: element.data('largemetahubfields'),
				smallmetahubfields: element.data('smallmetahubfields'),
				largemetasiterating: element.data('largemetasiterating'),
				smallmetasiterating: element.data('smallmetasiterating'),
				largemetauserating: element.data('largemetauserrating'),
				smallmetauserrating: element.data('smallmetauserrating'),
				largereadmorelink: element.data('largereadmorelink'),
				smallreadmorelink: element.data('smallreadmorelink'),
				release_date: element.data('release_date'),		
				release_date_from: element.data('release_date_from'),	
				release_date_to: element.data('release_date_to')	
			},
			dataType: 'html',
			url: ghostpool_ajax_loop.ajaxurl,
			success: function( data ) {	

				$( 'section:last-child .gp-post-image' ).promise().done( function() {
					ajaxLoop.html( data ).removeClass( 'gp-filter-loading' ).find( 'section' ).fadeIn();
					element.find( '.gp-standard-pagination' ).hide();
				});

				// Needed for blog masonry positioning of page numbers
				ajaxLoop.after( $( '.gp-blog-masonry .gp-ajax-pagination.gp-pagination-numbers' ) );
				$( '.gp-blog-masonry .gp-ajax-pagination.gp-pagination-numbers:not(:first)' ).remove();

				// If clicking ajax pagination numbers
				element.find( '.gp-ajax-pagination.gp-pagination-numbers a' ).click( function() {
					
					if ( $( this ).hasClass( 'page-numbers' ) ) {
						var parentElement = $( this ).parent().parent().parent().parent().parent().parent();
					} else {
						var parentElement = $( this ).parent().parent().parent().parent();	
					}		
					gpCurrentValue( parentElement );
					
					// Get page numbers from page links
					var ajaxPagination = $( this );	
						
					if ( ajaxPagination.hasClass( 'prev' ) ) {
						var pagelink = ajaxPagination.attr( 'href' );
						if ( pagelink.match( 'pagenumber=2' ) ) {
							pagenumber = 1;
						} else {
							var prev = pagelink.match(/\d+/);
							pagenumber = prev[0];
						}	
					} else if ( ajaxPagination.hasClass( 'next' ) ) {
						var next = ajaxPagination.attr( 'href' ).match(/\d+/);
						pagenumber = next[0];
					} else {
						pagenumber = ajaxPagination.text();
					}
					
					gpLoadPosts( element );

					if ( ! element.is( '.gp-vc-element' ) ) {
						$( 'html, body' ).animate({ scrollTop : 0 }, 0);
					} else {
						$( 'html, body' ).animate({ scrollTop: ( parentElement.offset().top - 200 ) }, 0);
					}
					
					return false;
				});
				
				// If clicking ajax pagination arrows
				element.find( '.gp-ajax-pagination.gp-pagination-arrows a' ).click( function() {
					
					if ( $( this ).hasClass( 'page-numbers' ) ) {
						var parentElement = $( this ).parent().parent().parent().parent().parent().parent();
					} else {
						var parentElement = $( this ).parent().parent().parent().parent();	
					}		
					gpCurrentValue( parentElement );
					
					// Get page numbers from page links
					var ajaxPagination = $( this );	
					
					pagenumber = ajaxPagination.data( 'pagelink' );	
					
					gpLoadPosts( element );

					if ( ! element.is( '.gp-vc-element' ) ) {
						$( 'html, body' ).animate({ scrollTop : 0 }, 0);
					} else {
						$( 'html, body' ).animate({ scrollTop: ( parentElement.offset().top - 200 ) }, 0);
					}
					
					return false;
				});			
				
				// Load WordPress media players	
				if ( element.find( '.wp-audio-shortcode' ).length > 0 ) {
					element.find( '.wp-audio-shortcode' ).mediaelementplayer({
						alwaysShowControls: true
					});
				}
				if ( element.find( '.wp-video-shortcode' ).length > 0 ) {		
					element.find( '.wp-video-shortcode' ).mediaelementplayer({
						alwaysShowControls: true
					});
				}
				
			},
			error: function( jqXHR, textStatus, errorThrown ) {
				//alert( jqXHR + " :: " + textStatus + " :: " + errorThrown );
			}
		});	

		// Add loading class
		ajaxLoop.addClass( 'gp-filter-loading' );
					
		return false;
		
	}	
	
	
	/*--------------------------------------------------------------
	Filter options
	--------------------------------------------------------------*/
		
	// If selecting category filter	
	$( 'select[name="gp-filter-cats"]' ).change( function() {
		var filterCats = $( this );
		var parentElement = filterCats.parent().parent().parent();
		gpCurrentValue( parentElement );
		cats_filtered = filterCats.val();	
		gpLoadPosts( parentElement );		
	});
						
	// If selecting orderby filter		
	$( 'select[name="gp-filter-orderby"]' ).change( function() {
		var filterOrderby = $( this );
		var parentElement = filterOrderby.parent().parent().parent();
		gpCurrentValue( parentElement );
		orderby_filtered = filterOrderby.val();
		gpLoadPosts( parentElement );
	});

	// Post types
	/*REMOVE$( 'input[name="post_types[]"]' ).change( function() {
		var filterPostTypes = $( this );
		var parentElement = filterPostTypes.parent().parent();
		gpCurrentValue( parentElement );	
		posttypes_filtered = $( '.gp-post-type:checked' ).map( function() {return this.value;} ).get().join( ',' );
		//console.log( templates_filtered );
		gpLoadPosts( parentElement );			
	});*/
		
	// Template types
	$( 'input[name="templates[]"]' ).change( function() {
		var filterTemplates = $( this );
		var parentElement = filterTemplates.parent().parent().parent().parent();
		gpCurrentValue( parentElement );	
		templates_filtered = $( '.gp-template-type:checked' ).map( function() {return this.value;} ).get().join( ',' );
		gpLoadPosts( parentElement );			
	});
		
	// If clicking menu categories
	$( '.gp-menu-tabs:not(.gp-mobile-menu-tabs) li' ).hover( function() {
		var filterMenuCats = $( this );
		var parentElement = filterMenuCats.parent().parent();
		gpCurrentValue( parentElement );
		tab_cat_filtered = filterMenuCats.attr( 'id' );
		$( 'li.gp-selected' ).removeClass( 'gp-selected' );
		filterMenuCats.addClass( 'gp-selected' );	
		gpLoadPosts( parentElement );
	}, function() {
  	});
	$( '.gp-menu-tabs.gp-mobile-menu-tabs li' ).click( function() {
		var filterMenuCats = $( this );
		var parentElement = filterMenuCats.parent().parent();
		gpCurrentValue( parentElement );
		tab_cat_filtered = filterMenuCats.attr( 'id' );
		$( 'li.gp-selected' ).removeClass( 'gp-selected' );
		filterMenuCats.addClass( 'gp-selected' );	
		gpLoadPosts( parentElement );	
		return false;	
	});

	// If clicking original pagination (numbers)
	$( '#gp-content-wrapper .gp-ajax-loop .gp-pagination ul.page-numbers a' ).click( function() {
		// Get page numbers from page links
		var filterPagination = $( this );
		var parentElement = filterPagination.parent().parent().parent().parent().parent();
		gpCurrentValue( parentElement );
		if ( filterPagination.hasClass( 'prev' ) ) {
			var prev = filterPagination.attr('href').match(/(\d+)\D*$/);
			pagenumber = prev[0];
		} else if ( filterPagination.hasClass( 'next' ) ) {
			var next = filterPagination.attr( 'href' ).match(/(\d+)\D*$/);
			pagenumber = next[0];
		} else {
			pagenumber = filterPagination.text();
		}
		gpLoadPosts( parentElement );
		if ( ! parentElement.hasClass( 'gp-vc-element' ) ) {
			$( 'html, body' ).animate({ scrollTop : 0 }, 0);
		} else {
			$( 'html, body' ).animate({ scrollTop: ( parentElement.offset().top - 200 ) }, 0);
		}
		return false;
	});	

	// If clicking original pagination (arrows)
	$( '#gp-content-wrapper .gp-pagination-arrows a' ).click( function() {
		var filterPagination = $( this );
		var parentElement = filterPagination.parent().parent().parent();
		gpCurrentValue( parentElement );
		pagenumber = filterPagination.data( 'pagelink' );
		gpLoadPosts( parentElement );
		return false;
	});

	// If clicking original menu pagination
	$( '.gp-nav .gp-ajax-loop .gp-pagination-arrows a' ).click( function() {
		cats_filtered = 0;
		orderby_filtered = 0;
		var filterPagination = $( this );
		var parentElement = filterPagination.parent().parent().parent();
		pagenumber = filterPagination.data( 'pagelink' );
		gpLoadPosts( parentElement );
		return false;
	});


	/*--------------------------------------------------------------
	Load scripts within ajax
	--------------------------------------------------------------*/
	
	$( document ).ajaxComplete( function( e, xhr, settings ) {
			
		// Load Isotope
		if ( $( '.gp-blog-wrapper' ).hasClass( 'gp-blog-masonry' ) ) {
		
			var container = $( '.gp-blog-masonry .gp-section-loop-inner' ),
				element = container;

			// Destroy previous isotope
			container.isotope( 'destroy' );
			container.css( 'opacity', 0 );

			if ( container.find( 'img' ).length == 0 ) {
				element = $( '<img />' );
			}	

			imagesLoaded( element, function( instance ) {

				container.isotope({
					itemSelector: 'section',
					percentPosition: true,
					masonry: {
						columnWidth: container.find( 'section' )[0],
						gutter: '.gp-gutter-size'
					}
				});

				container.animate( { 'opacity': 1 }, 1300 );
				$( '.gp-pagination' ).animate( { 'opacity': 1 }, 1300 );
				$( '.gp-load-more' ).animate( { 'opacity': 1 }, 1300 );
				
			});
			
		}	
				
		// Load Advanced Responsive Video Embedder
		var arve_iframe_btns = document.getElementsByClassName( 'arve-iframe-btn' );

		for ( var i=0; i < arve_iframe_btns.length; i++ ) {

			arve_iframe_btns[i].onclick = function() {

				var target = document.getElementById( this.getAttribute( 'data-target' ) );
				target.setAttribute( 'src', target.getAttribute( 'data-src' ) );
				target.className = 'arve-inner';
				this.parentNode.removeChild( this );
			};
		};
		
		// Get height of first image
		$( '.gp-ajax-loop .flex-viewport' ).each( function() {
			var firstImageHeight = $( this ).find( 'ul.slides li:first-child img' ).css( 'height' );
			$( this ).css( 'height', firstImageHeight );
		});
  		
  		// Gallery category post slider
		$( '.gp-blog-wrapper:not(.gp-blog-masonry) .gp-post-format-gallery-slider, .gp-showcase-wrapper .gp-post-format-gallery-slider' ).flexslider( { 
			animation: 'fade',
			slideshowSpeed: 9999999,
			animationSpeed: 600,
			directionNav: true,			
			controlNav: false,			
			pauseOnAction: true, 
			pauseOnHover: false,
			prevText: '',
			nextText: '',
			smoothHeight: true
		});

		$( '.gp-blog-masonry .gp-post-format-gallery-slider' ).flexslider( { 
			animation: 'fade',
			slideshowSpeed: 9999999,
			animationSpeed: 600,
			directionNav: true,			
			controlNav: false,			
			pauseOnAction: true, 
			pauseOnHover: false,
			prevText: '',
			nextText: ''
		});
							
	}); 

});