<?php

/**
 * Enqueues scripts and styles.
 *
 */	
if ( ! function_exists( 'ghostpool_wc_scripts' ) ) {	
	function ghostpool_wc_scripts() {
		wp_enqueue_style( 'ghostpool-woocommerce', get_template_directory_uri() . '/lib/css/woocommerce.css', array( 'woocommerce-general' ) );						
	}
}
add_action( 'wp_enqueue_scripts', 'ghostpool_wc_scripts' );

/**
 * Disable activation redirect
 *
 */
if ( ! function_exists( 'ghostpool_wc_disable_redirect' ) ) {
	function ghostpool_wc_disable_redirect() {
		return true;
	}
}
add_filter( 'woocommerce_prevent_automatic_wizard_redirect', 'ghostpool_wc_disable_redirect' );

/**
 * Remove default WooCommerce content wrappers
 *
 */
remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10 );
remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10 );
remove_action( 'woocommerce_sidebar', 'woocommerce_get_sidebar', 10 );

/**
 * Remove shop/category titles and descriptions
 *
 */
function ghostpool_wc_remove_page_title() {
	return false;
}
add_filter( 'woocommerce_show_page_title', 'ghostpool_wc_remove_page_title', 20 );
remove_action( 'woocommerce_archive_description', 'woocommerce_taxonomy_archive_description', 10 );

/**
 * Remove breadcrumbs
 *
 */
remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0 );

/**
 * Use custom pagination for product categories 
 *
 */
remove_action( 'woocommerce_pagination', 'woocommerce_pagination', 10 );
if ( ! function_exists( 'woocommerce_pagination' ) ) {
	function woocommerce_pagination() {
		global $wp_query;
		echo ghostpool_pagination( $wp_query->max_num_pages, 'page-numbers' );
	}
}	
add_action( 'woocommerce_pagination', 'woocommerce_pagination', 10 );

/**
 * Opening WooCommerce content wrappers 
 *
 */
if ( ! function_exists( 'ghostpool_wc_page_wrapper_start' ) ) {
	function ghostpool_wc_page_wrapper_start() {
		
		// Page options
		if ( is_shop() ) {
			$header = ghostpool_option( 'wc_shop_page_header' );
			$bg = ghostpool_option( 'wc_shop_page_header_bg' );
			$height = ghostpool_option( 'wc_shop_page_header_height', 'padding-bottom' );
		} elseif ( is_archive() ) {
			// Get category options
			$term_data = null;
			if ( isset( get_queried_object()->term_id ) ) {
				$term_id = get_queried_object()->term_id;
				$term_data = get_option( "taxonomy_$term_id" );
			}
			$header = ! isset( $term_data['page_header'] ) || $term_data['page_header'] == 'default' ? ghostpool_option( 'wc_product_cat_page_header' ) : $term_data['page_header'];
			$bg = isset( $term_data['page_header_bg'] ) ? $term_data['page_header_bg'] : '';
			$height = ghostpool_option( 'wc_product_cat_page_header_height', 'padding-bottom' );
		} elseif ( is_singular( 'product' ) ) {
			$header = ghostpool_option( 'page_header' ) == 'default' ? ghostpool_option( 'wc_product_page_header' ) : ghostpool_option( 'page_header' );
			$bg = get_post_meta( get_the_ID(), 'page_header_bg', true );
			$height = ghostpool_option( 'page_header_height', 'padding-bottom' ) != '' ? ghostpool_option( 'page_header_height', 'padding-bottom' ) : ghostpool_option( 'wc_product_page_header_height', 'padding-bottom' );
		} ?>

		<?php if ( ! is_singular( 'product' ) ) { ghostpool_page_title( '', $header ); } ?>

		<?php ghostpool_page_header( 
			$post_id = '', 
			$type = $header,
			$bg = $bg,
			$height = $height
		); ?>
		
		<div id="gp-content-wrapper" class="gp-container">
		
			<?php do_action( 'ghostpool_begin_content_wrapper' ); ?>
		
			<div id="gp-inner-container">
			
				<div id="gp-left-column">
		
					<div id="gp-content">
					
						<?php if ( $header == 'gp-fullwidth-page-header' OR $header == 'gp-full-page-page-header' ) { ?>
							<?php ghostpool_breadcrumbs(); ?>
							<header class="gp-entry-header">
								<h1 class="gp-entry-title">
									<?php if ( is_shop() ) {
										$post_id = get_option( 'woocommerce_shop_page_id' );
										if ( ghostpool_option( 'custom_title' ) ) { echo esc_attr( ghostpool_option( 'custom_title' ) ); } else { echo get_the_title( $post_id ); }
									} elseif ( is_archive() ) {
										single_cat_title();
									} elseif ( is_singular( 'product' ) ) {
										if ( ghostpool_option( 'custom_title' ) ) { echo esc_attr( ghostpool_option( 'custom_title' ) ); } else { the_title(); }
									} ?>
								</h1>
								<?php if ( category_description() ) { ?>
									<div class="gp-subtitle"><?php echo str_replace( array( '<p>', '</p>' ), '', category_description() ); ?></div>
								<?php } ?>
							</header>
						<?php } ?>
					
	<?php }
}
add_action( 'woocommerce_before_main_content', 'ghostpool_wc_page_wrapper_start', 10 );

/**
 * Closing WooCommerce content wrappers 
 *
 */
if ( ! function_exists( 'ghostpool_wc_page_wrapper_end' ) ) {
	function ghostpool_wc_page_wrapper_end() { ?>
				
					</div>
			
					<?php get_sidebar( 'left' ); ?>
	
				</div>
	
				<?php get_sidebar( 'right' ); ?>

			</div>
	
			<?php do_action( 'ghostpool_begin_content_wrapper' ); ?>

		   <div class="gp-clear"></div>

		</div>

	<?php }
}
add_action( 'woocommerce_after_main_content', 'ghostpool_wc_page_wrapper_end', 10 );

/**
 * WooCommerce standard dropdown cart
 *
 */
if ( ! function_exists( 'ghostpool_dropdown_cart' ) ) {														
	function ghostpool_dropdown_cart() {
		if ( ! is_cart() && ! is_checkout() ) { ?>	
			<div id="gp-cart-nav" class="gp-nav">
				<ul class="menu">
					<li class="gp-standard-menu menu-item-has-children gp-cart-link">
						<a href="<?php echo wc_get_cart_url(); ?>" id="gp-cart-button" title="<?php esc_html_e( 'View your shopping cart', 'huber' ); ?>">
							<span id="gp-cart-counter"><?php echo sprintf( _n( '%d', '%d', WC()->cart->get_cart_contents_count(), 'huber' ), WC()->cart->get_cart_contents_count() ); ?></span>
						</a>
						<ul class="sub-menu">
							<?php the_widget( 'WC_Widget_Cart', 'title=' ); ?>		
						</ul>
					</li>
				</ul>		
			</div>
	<?php }
	}
}

/**
 * WooCommerce ajax dropdown cart
 *
 */
if ( ! function_exists( 'ghostpool_woocommerce_add_to_cart_fragment' ) ) {
	function ghostpool_woocommerce_add_to_cart_fragment( $fragments ) {
		ob_start(); ?>
			<span id="gp-cart-counter"><?php echo sprintf( _n( '%d', '%d', WC()->cart->get_cart_contents_count(), 'huber' ), WC()->cart->get_cart_contents_count() ); ?></span>
		<?php $fragments['#gp-cart-button #gp-cart-counter'] = ob_get_clean();
		return $fragments;
	}
}
add_filter( 'woocommerce_add_to_cart_fragments', 'ghostpool_woocommerce_add_to_cart_fragment' );

?>