<?php

/*--------------------------------------------------------------
Add the voting panel to the page
--------------------------------------------------------------*/

if  ( ! function_exists( 'ghostpool_voting' ) ) {

	function ghostpool_voting( $post_id = '', $type_of_vote = '' ) {

		// Sanatize params
		$post_id = intval( sanitize_text_field( $post_id ) );
		$type_of_vote = intval ( sanitize_text_field( $type_of_vote ) );

		$voting_link = '';

		if ( $post_id == '' ) {
			$post_id = get_the_ID();
		}	
					
		$voting_up_count = get_post_meta( $post_id, 'ghostpool_voting_up', true ) != '' ? get_post_meta( $post_id, 'ghostpool_voting_up', true ) : '0';
	
		$voting_down_count = get_post_meta( $post_id, 'ghostpool_voting_down', true ) != '' ? get_post_meta( $post_id, 'ghostpool_voting_down', true ) : '0';

		$link_up = '<span class="gp-voting-up' . ( ( isset( $voting_up_count ) && intval( $voting_up_count ) > 0 ) ? ' gp-voted' : '' ) .'" onclick="ghostpool_vote(' . $post_id . ', 1);" data-text="' . esc_html__( 'Vote Up', 'huber' ) . ' +">' . $voting_up_count . '</span>';
	
		$link_down = '<span class="gp-voting-down' . ( ( isset( $voting_down_count ) && intval( $voting_down_count ) > 0 ) ? ' gp-voted' : '' ) .'" onclick="ghostpool_vote(' . $post_id . ', 2);" data-text="' . esc_html__( 'Vote Down', 'huber' ) . ' -">' . $voting_down_count . '</span>';

		$voting_link = '<div class="gp-voting-container" id="gp-voting-' . $post_id . '" data-content-id="' . $post_id . '"><div class="gp-voting-container-inner">';
		$voting_link .= $link_up;
		$voting_link .= ' ';
		$voting_link .= $link_down;
		$voting_link .= '</div><span class="gp-already-voted" data-text="' . esc_html__( 'You already voted!', 'huber' ) . '"></span>';
		$voting_link .= '</div>';

		return $voting_link;
		
	}
}


/*--------------------------------------------------------------
Handle ajax request for up and down votes
--------------------------------------------------------------*/

if  ( ! function_exists( 'ghostpool_add_vote_callback' ) ) {

	function ghostpool_add_vote_callback() {

		// Check the nonce - security
		check_ajax_referer( 'ghostpool_voting_action', 'nonce' );

		global $wpdb;

		// Get the POST values
		$post_id = intval( $_POST['postid'] );
		$type_of_vote = intval( $_POST['type'] );

		// Check the type and retrieve the meta values
		if ( $type_of_vote == 1 ) {

			$meta_name = "ghostpool_voting_up";

		} elseif ( $type_of_vote == 2 ) {

			$meta_name = "ghostpool_voting_down";

		}

		// Retrieve the meta value from the DB
		$voting_count = get_post_meta( $post_id, $meta_name, true ) != '' ? get_post_meta( $post_id, $meta_name, true ) : '0';
		$voting_count = $voting_count + 1;

		// Update the meta value
		update_post_meta( $post_id, $meta_name, $voting_count );

		$results = ghostpool_voting( $post_id, $type_of_vote );

		die( $results );
	}

	add_action( 'wp_ajax_ghostpool_add_vote', 'ghostpool_add_vote_callback' );
	add_action( 'wp_ajax_nopriv_ghostpool_add_vote', 'ghostpool_add_vote_callback' );

}


/*--------------------------------------------------------------
Add votes column to admin
--------------------------------------------------------------*/

if  ( ! function_exists( 'ghostpool_voting_columns' ) ) {

	function ghostpool_voting_columns( $columns ) {
	    return array_merge( $columns, 
	    	array( 
	    		'ghostpool_voting_up_count' =>  esc_html__( 'Up Votes', 'huber' ), 
	    		'ghostpool_voting_down_count' => esc_html__( 'Down Votes', 'huber' ) 
	    	)
	    );
	}
	add_filter( 'manage_posts_columns' , 'ghostpool_voting_columns' );
	add_filter( 'manage_pages_columns' , 'ghostpool_voting_columns' );

}


/*--------------------------------------------------------------
Add voting values to admin columns
--------------------------------------------------------------*/

if  ( ! function_exists( 'ghostpool_voting_column_values' ) ) {

	function ghostpool_voting_column_values( $column, $post_id ) {
	    switch ( $column ) {
		case 'ghostpool_voting_up_count' :
		   	echo get_post_meta( $post_id, 'ghostpool_voting_up', true) != '' ? "+" . get_post_meta( $post_id, 'ghostpool_voting_up', true ) : '0';
		   break;

		case 'ghostpool_voting_down_count' :
		      echo get_post_meta( $post_id, 'ghostpool_voting_down', true) != '' ? "-" . get_post_meta( $post_id, 'ghostpool_voting_down', true ) : '0';
		    break;
	    }
	}
	add_action( 'manage_posts_custom_column', 'ghostpool_voting_column_values', 10, 2 );
	add_action( 'manage_pages_custom_column', 'ghostpool_voting_column_values', 10, 2 );

}


/*--------------------------------------------------------------
Make voting columns sortables
--------------------------------------------------------------*/

if  ( ! function_exists( 'ghostpool_voting_sortable_columns' ) ) {

	function ghostpool_voting_sortable_columns( $columns ) {
		$columns[ 'ghostpool_voting_up_count' ] = 'ghostpool_voting_up_count';
		$columns[ 'ghostpool_voting_down_count' ] = 'ghostpool_voting_down_count';
		return $columns;
	}

	// Apply this to all public post types
	add_action( 'admin_init', 'ghostpool_voting_sort_all_public_post_types' );

	function ghostpool_voting_sort_all_public_post_types() {
		foreach ( get_post_types( array( 'public' => true ), 'names' ) as $post_type_name ) {
			add_action( 'manage_edit-' . $post_type_name . '_sortable_columns', 'ghostpool_voting_sortable_columns' );
		}
		add_filter( 'request', 'ghostpool_voting_column_sort_orderby' );
	}

	// Tell WordPress our fields are numeric
	function ghostpool_voting_column_sort_orderby( $vars ) {
		if ( isset( $vars['orderby'] ) && 'ghostpool_voting_up_count' == $vars['orderby'] ) {
			$vars = array_merge( $vars, array(
				'meta_key' => 'ghostpool_voting_up',
				'orderby'  => 'meta_value_num'
			) );
		}
		if ( isset( $vars['orderby'] ) && 'ghostpool_voting_down_count' == $vars['orderby'] ) {
			$vars = array_merge( $vars, array(
				'meta_key' => 'ghostpool_voting_down',
				'orderby'  => 'meta_value_num'
			) );
		}
		return $vars;
	}

}


/*--------------------------------------------------------------
Show up and down votes in theme
--------------------------------------------------------------*/

if ( ! function_exists( 'ghostpool_voting_show_up_votes' ) ) {
	function ghostpool_voting_show_up_votes( $post_id = '' ) {
		
		if ( $post_id == '' ) {
			$post_id = get_the_ID();
		} else {
			$post_id = intval( sanitize_text_field( $post_id ) );
		}
		
		$voting_up = get_post_meta( $post_id, 'ghostpool_voting_up', true );
		
		if ( $voting_up == 0 OR $voting_up > 1 ) {
			$voting_up_text = esc_html__( 'likes', 'huber' );
		} else {
			$voting_up_text = esc_html__( 'like', 'huber' );
		}
		
		if ( $voting_up != '' ) {
			return $voting_up . ' ' . $voting_up_text; 
		} else {
			return '0 ' . $voting_up_text;
		}
		
	}
}

if ( ! function_exists( 'ghostpool_voting_show_down_votes' ) ) {
	function ghostpool_voting_show_down_votes ( $post_id = '' ) {
		
		if ( $post_id == '' ) {
			$post_id = get_the_ID();
		} else {
			$post_id = intval( sanitize_text_field( $post_id ) );
		}
		
		$voting_down = get_post_meta( $post_id, 'ghostpool_voting_down', true );
		
		if ( $voting_down == 0 OR $voting_up > 1 ) {
			$voting_down_text = esc_html__( 'likes', 'huber' );
		} else {
			$voting_down_text = esc_html__( 'like', 'huber' );
		}
		
		if ( $voting_down != '' ) {
			return $voting_down . ' ' . $voting_down_text; 
		} else {
			return '0 ' . $voting_down_text;
		}
		
	}
}