<?php

/*--------------------------------------------------------------
Transfer page template value to new custom field if page is updated before converter is run
--------------------------------------------------------------*/

if ( get_option( 'ghostpool_update_theme_options' ) != 1 ) {
	global $pagenow;
	if ( $pagenow == 'post.php' && ! isset( $_POST['ghostpool_convert_hubs_reviews'] ) ) {				
		if ( ! function_exists( 'ghostpool_new_template_field' ) ) {
			function ghostpool_new_template_field( $data , $post_array ) {
				if ( $data['post_type'] == 'page' ) {
					$post_id = $post_array['ID'];
					if ( get_post_meta( $post_id, '_wp_page_template', true ) != '' && get_post_meta( $post_id, '_wp_page_template', true ) != 'default' && get_post_meta( $post_id, '_ghostpool_old_template', true ) == '' ) {
						add_post_meta( $post_id, '_ghostpool_old_template', get_post_meta( $post_id, '_wp_page_template', true ) );
					}
				}
				return $data;	
			}
		}
		add_filter( 'wp_insert_post_data', 'ghostpool_new_template_field', '99', 2 );
	}
}

/*--------------------------------------------------------------
Create theme converter menu
--------------------------------------------------------------*/

if ( ! function_exists( 'ghostpool_theme_converter_menu' ) ) {
	function ghostpool_theme_converter_menu() {
		add_theme_page( esc_html__( 'Theme Converter', 'huber' ), esc_html__( 'Theme Converter', 'huber' ), 'administrator', 'theme-converter', 'ghostpool_theme_converter_page' );
	}
}
add_action( 'admin_menu', 'ghostpool_theme_converter_menu' );


/*--------------------------------------------------------------
Theme converter page
--------------------------------------------------------------*/		
					
if ( ! function_exists( 'ghostpool_theme_converter_page' ) ) {
	
	function ghostpool_theme_converter_page() {
	
		if ( function_exists( 'ghostpool_huber_plugin_update' ) ) {

			global $post, $wpdb, $gp; $gp_global = get_option( 'gp' ); $convert_content = '';
						
			// Importing hub fields before theme converter is run so release date can be converted
			if ( isset( $gp_global['hub_fields'] ) && $gp_global['hub_fields'] ) {
				Redux::setOption( 'ghostpool_huber', 'hub_fields', $gp_global['hub_fields'] );	
			}

			/*--------------------------------------------------------------
			Update theme options and custom field keys and values
			--------------------------------------------------------------*/
				
			if ( isset( $_POST['ghostpool_update_theme_options'] ) && get_option( 'ghostpool_update_theme_options' ) != 1 ) {		
				
				if ( ! wp_verify_nonce( $_REQUEST['ghostpool_theme_converter_nonce'], 'ghostpool_theme_converter_action' ) ) {
				  exit;
				}

				// Theme Options
				Redux::setOption( 'ghostpool_huber', 'site_rating_text_1', $gp_global['review_site_rating_text_1'] );
				Redux::setOption( 'ghostpool_huber', 'site_rating_text_2', $gp_global['review_site_rating_text_2'] );
				Redux::setOption( 'ghostpool_huber', 'site_rating_text_3', $gp_global['review_site_rating_text_3'] );
				Redux::setOption( 'ghostpool_huber', 'site_rating_text_4', $gp_global['review_site_rating_text_4'] );
				Redux::setOption( 'ghostpool_huber', 'site_rating_text_5', $gp_global['review_site_rating_text_5'] );
				Redux::setOption( 'ghostpool_huber', 'site_rating_text_6', $gp_global['review_site_rating_text_6'] );
				Redux::setOption( 'ghostpool_huber', 'site_rating_text_7', $gp_global['review_site_rating_text_7'] );
				Redux::setOption( 'ghostpool_huber', 'site_rating_text_8', $gp_global['review_site_rating_text_8'] );
				Redux::setOption( 'ghostpool_huber', 'site_rating_text_9', $gp_global['review_site_rating_text_9'] );
				Redux::setOption( 'ghostpool_huber', 'site_rating_text_10', $gp_global['review_site_rating_text_10'] );
				Redux::setOption( 'ghostpool_huber', 'site_rating_criteria', $gp_global['review_rating_criteria'] );
				Redux::setOption( 'ghostpool_huber', 'rating_number', $gp_global['review_rating_number'] );
				Redux::setOption( 'ghostpool_huber', 'exclude_cats', isset( $gp_global['hub_exclude_header_cats'] ) ? $gp_global['hub_exclude_header_cats'] : '' );
				Redux::setOption( 'ghostpool_huber', 'following_items', $gp_global['hub_following_items'] );
		
				// Change the page template field
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", '_ghostpool_old_template', '_wp_page_template' ) );	
					
				// Change subtitle meta key
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'subtitle', 'post_subtitle' ) );			
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'subtitle', 'page_subtitle' ) );		
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'subtitle', 'blog_template_subtitle' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'subtitle', 'homepage_subtitle' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'subtitle', 'portfolio_template_subtitle' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'subtitle', 'hub_subtitle' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'subtitle', 'hub_review_subtitle' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'subtitle', 'review_subtitle' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'subtitle', 'my_reviews_subtitle' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'subtitle', 'following_subtitle' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'subtitle', 'portfolio_item_subtitle' ) );	

				// Change custom title meta key				
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'custom_title', 'post_custom_title' ) );			
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'custom_title', 'page_custom_title' ) );		
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'custom_title', 'blog_template_custom_title' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'custom_title', 'homepage_custom_title' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'custom_title', 'portfolio_template_custom_title' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'custom_title', 'hub_custom_title' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'custom_title', 'hub_review_custom_title' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'custom_title', 'review_custom_title' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'custom_title', 'my_reviews_custom_title' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'custom_title', 'following_custom_title' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'custom_title', 'portfolio_item_custom_title' ) );	

				// Change tab title meta key	
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'tab_title', 'page_tab_title' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'tab_title', 'blog_template_tab_title' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'tab_title', 'portfolio_template_tab_title' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'tab_title', 'hub_tab_title' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'tab_title', 'hub_review_tab_title' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'tab_title', 'review_tab_title' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'tab_title', 'news_tab_title' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'tab_title', 'images_tab_title' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'tab_title', 'link_template_tab_title' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'tab_title', 'write_a_review_tab_title' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'tab_title', 'user_reviews_tab_title' ) );
			
				// Change page header meta key
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'page_header', 'post_title' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'page_header', 'page_title' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'page_header', 'blog_template_title' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'page_header', 'homepage_title' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'page_header', 'portfolio_template_title' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'page_header', 'hub_title' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'page_header', 'hub_review_title' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'page_header', 'review_title' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'page_header', 'my_reviews_title' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'page_header', 'following_title' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'page_header', 'portfolio_item_title' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'page_header', 'bbpress_title' ) );

				// Change page header meta value
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_value = REPLACE( meta_value, %s, %s )", 'gp-standard-title', 'gp-standard-page-header' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_value = REPLACE( meta_value, %s, %s )", 'gp-large-title', 'gp-fullwidth-page-header' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_value = REPLACE( meta_value, %s, %s )", 'gp-fullwidth-title', 'gp-fullwidth-page-header' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_value = REPLACE( meta_value, %s, %s )", 'gp-full-page-title', 'gp-full-page-page-header' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_value = REPLACE( meta_value, %s, %s )", 'gp-no-title', 'gp-standard-page-header' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_value = REPLACE( meta_value, %s, %s )", 'gp-large-title', 'gp-standard-page-header' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_value = REPLACE( meta_value, %s, %s )", 'gp-no-large-title', 'gp-standard-page-header' ) );
		
				// Change page header background meta key
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'page_header_bg', 'post_title_bg' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'page_header_bg', 'page_title_bg' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'page_header_bg', 'blog_template_title_bg' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'page_header_bg', 'portfolio_template_title_bg' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'page_header_bg', 'hub_title_bg' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'page_header_bg', 'portfolio_template_title_bg' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'page_header_bg', 'hub_review_title_bg' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'page_header_bg', 'review_title_bg' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'page_header_bg', 'my_reviews_title_bg' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'page_header_bg', 'following_title_bg' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'page_header_bg', 'portfolio_item_title_bg' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'page_header_bg', 'bbpress_title_bg' ) );
		
				// Change page header video background meta key
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'page_header_video_bg', 'post_title_teaser_video_bg' ) );			
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'page_header_video_bg', 'page_title_teaser_video_bg' ) );		
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'page_header_video_bg', 'blog_title_teaser_video_bg' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'page_header_video_bg', 'homepage_title_teaser_video_bg' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'page_header_video_bg', 'portfolio_template_title_teaser_video_bg' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'page_header_video_bg', 'hub_title_teaser_video_bg' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'page_header_video_bg', 'hub_review_title_teaser_video_bg' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'page_header_video_bg', 'review_title_teaser_video_bg' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'page_header_video_bg', 'my_reviews_title_teaser_video_bg' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'page_header_video_bg', 'following_title_teaser_video_bg' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'page_header_video_bg', 'portfolio_item_title_teaser_video_bg' ) );	
		
				// Change page header video meta key
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'page_header_video', 'post_title_full_video_bg' ) );			
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'page_header_video', 'page_title_full_video_bg' ) );		
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'page_header_video', 'blog_title_full_video_bg' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'page_header_video', 'homepage_title_full_video_bg' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'page_header_video', 'portfolio_template_title_full_video_bg' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'page_header_video', 'hub_title_full_video_bg' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'page_header_video', 'hub_review_title_full_video_bg' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'page_header_video', 'review_title_full_video_bg' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'page_header_video', 'my_reviews_title_full_video_bg' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'page_header_video', 'following_title_full_video_bg' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'page_header_video', 'portfolio_item_title_full_video_bg' ) );	

				// Change layout meta key
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'layout', 'post_layout' ) );			
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'layout', 'page_layout' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'layout', 'blog_template_layout' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'layout', 'portfolio_template_layout' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'layout', 'flexslider_layout' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'layout', 'featured_layout' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'layout', 'hub_layout' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'layout', 'hub_review_layout' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'layout', 'review_layout' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'layout', 'news_layout' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'layout', 'images_layout' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'layout', 'videos_layout' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'layout', 'write_a_review_layout' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'layout', 'user_reviews_layout' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'layout', 'my_reviews_layout' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'layout', 'following_layout' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'layout', 'portfolio_item_layout' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'layout', 'product_layout' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'layout', 'bbpress_layout' ) );		
		
				// Change layout meta value
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_value = REPLACE( meta_value, %s, %s )", 'blog-standard', 'gp-blog-list' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_value = REPLACE( meta_value, %s, %s )", 'blog-large', 'gp-blog-list' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_value = REPLACE( meta_value, %s, %s )", 'blog-columns-2', 'gp-blog-columns-2' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_value = REPLACE( meta_value, %s, %s )", 'blog-columns-3', 'gp-blog-columns-3' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_value = REPLACE( meta_value, %s, %s )", 'blog-columns-4', 'gp-blog-columns-4' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_value = REPLACE( meta_value, %s, %s )", 'blog-columns-5', 'gp-blog-columns-5' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_value = REPLACE( meta_value, %s, %s )", 'blog-columns-6', 'gp-blog-columns-6' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_value = REPLACE( meta_value, %s, %s )", 'blog-masonry', 'gp-blog-masonry' ) );
		
				// Change layout value in shortcodes
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->posts SET post_content = REPLACE( post_content, %s, %s )", 'blog-standard', 'gp-blog-list' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->posts SET post_content = REPLACE( post_content, %s, %s )", 'blog-large', 'gp-blog-list' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->posts SET post_content = REPLACE( post_content, %s, %s )", 'blog-columns-2', 'gp-blog-columns-2' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->posts SET post_content = REPLACE( post_content, %s, %s )", 'blog-columns-3', 'gp-blog-columns-3' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->posts SET post_content = REPLACE( post_content, %s, %s )", 'blog-columns-4', 'gp-blog-columns-4' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->posts SET post_content = REPLACE( post_content, %s, %s )", 'blog-columns-5', 'gp-blog-columns-5' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->posts SET post_content = REPLACE( post_content, %s, %s )", 'blog-columns-6', 'gp-blog-columns-6' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->posts SET post_content = REPLACE( post_content, %s, %s )", 'blog-masonry', 'gp-blog-masonry' ) );
						
				// Change sidebars meta key
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'right_sidebar', 'post_sidebar' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'right_sidebar', 'blog_template_sidebar' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'right_sidebar', 'portfolio_template_sidebar' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'right_sidebar', 'flexslider_sidebar' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'right_sidebar', 'featured_sidebar' ) );		
				//$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'right_sidebar', 'page_sidebar' ) );
				//$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'right_sidebar', 'hub_sidebar' ) );
				//$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'right_sidebar', 'hub_review_sidebar' ) );
				//$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'right_sidebar', 'review_sidebar' ) );
				//$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'right_sidebar', 'news_sidebar' ) );
				//$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'right_sidebar', 'images_sidebar' ) );
				//$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'right_sidebar', 'videos_sidebar' ) );
				//$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'right_sidebar', 'write_a_review_sidebar' ) );
				//$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'right_sidebar', 'user_reviews_sidebar' ) );
				//$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'right_sidebar', 'my_reviews_sidebar' ) );
				//$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'right_sidebar', 'following_sidebar' ) );
				//$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'right_sidebar', 'portfolio_item_sidebar' ) );
				//$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'right_sidebar', 'product_sidebar' ) );
				//$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'right_sidebar', 'bbpress_sidebar' ) );		
					
				// Change blog page template meta keys
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'blog_cats', 'blog_template_cats' ) );							
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'blog_post_types', 'blog_template_post_types' ) );				
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'blog_format', 'blog_template_format' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'blog_orderby', 'blog_template_orderby' ) );	
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'blog_filters', 'blog_template_filter_options' ) );					
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'blog_filter_cat_id', 'blog_template_filter_cats_id' ) );					
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'blog_per_page', 'blog_template_per_page' ) );					
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'blog_content_display', 'blog_template_content_display' ) );					
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'blog_excerpt_length', 'blog_template_excerpt_length' ) );					
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'blog_meta', 'blog_template_meta' ) );					
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'blog_read_more_link', 'blog_template_read_more_link' ) );	
		
				// Change rating meta keys
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'site_rating', 'review_site_rating' ) );	
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'site_rating', 'hub_review_site_rating' ) );				
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'ghostpool_site_rating', '_gp_site_rating' ) );			
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'rating_criteria', 'review_rating_criteria' ) );		
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'rating_criteria', 'hub_review_rating_criteria' ) );		
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'good_points', 'review_good_points' ) );	
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'bad_points', 'review_bad_points' ) );	
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'good_points', 'hub_review_good_points' ) );	
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'bad_points', 'hub_review_bad_points' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'ghostpool_user_votes', '_gp_user_votes' ) );	
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'ghostpool_current_position', '_gp_current_position' ) );	
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'ghostpool_user_rating', '_gp_user_rating' ) );	
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'ghostpool_user_sum', '_gp_user_sum' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'synopsis', 'hub_synopsis' ) );	
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'synopsis', 'hub_review_synopsis' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'summary', 'hub_review_summary' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'summary', 'review_summary' ) );

				// Affiliates
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'affiliates', 'hub_affiliate_button_link' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'affiliates', 'hub_review_affiliate_button_link' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'affiliates', 'review_affiliate_button_link' ) );
					
				// Change post submission meta keys
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'ghostpool_hub_page_id', '_hub_page_id' ) );	
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'ghostpool_post_submission_username', '_user_review_name' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'ghostpool_post_submission_email', 'user_review_email' ) );	
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'ghostpool_site_rating', '_user_review_rating' ) );			
			
				// Following
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'ghostpool_followers', '_gp_followers' ) );	
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->usermeta SET meta_key = %s WHERE meta_key = %s", 'ghostpool_followers' . get_the_ID(), '_gp_followers' ) );

				// Change homepage meta keys
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'flexslider_cats', 'featured_box_cats' ) );	
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'flexslider_ratings', 'featured_box_site_rating' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'featured_cats', 'featured_box_cats' ) );	
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'featured_ratings', 'featured_box_site_rating' ) );
	
				// Change post association meta key	
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'hub_association_ids', 'post_association' ) );

				// Change sidebar option names
				 if ( get_option( 'cs_sidebars' ) ) { 
					add_option( 'ghostpool_sidebars', get_option( 'cs_sidebars' ) );
					delete_option( 'cs_sidebars' );
				}
				if ( get_option( 'cs_modifiable' ) ) { 
					add_option( 'ghostpool_modifiable', get_option( 'cs_modifiable' ) );
					delete_option( 'cs_modifiable' );
				}	
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", '_ghostpool_replacements', '_cs_replacements' ) );
												
				update_option( 'ghostpool_update_theme_options', 1 );
				
			}

			
			/*--------------------------------------------------------------
			Convert hub and video categories to post categories
			--------------------------------------------------------------*/
			
			if ( isset( $_POST['ghostpool_convert_categories'] ) && get_option( 'ghostpool_convert_categories' ) != 1 ) {
				if ( ! wp_verify_nonce( $_REQUEST['ghostpool_theme_converter_nonce'], 'ghostpool_theme_converter_action' ) ) {
				  exit;
				}				
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->term_taxonomy SET taxonomy = %s WHERE taxonomy = %s", 'category', 'gp_hubs' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->term_taxonomy SET taxonomy = %s WHERE taxonomy = %s", 'category', 'gp_videos' ) );
				update_option( 'ghostpool_convert_categories', 1 );
			}


			/*--------------------------------------------------------------
			Convert user reviews to posts
			--------------------------------------------------------------*/
			
			if ( isset( $_POST['ghostpool_convert_user_reviews'] ) && get_option( 'ghostpool_convert_user_reviews' ) != 1 ) {
				if ( ! wp_verify_nonce( $_REQUEST['ghostpool_theme_converter_nonce'], 'ghostpool_theme_converter_action' ) ) {
				  exit;
				}
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->posts SET post_type = %s WHERE post_type = %s", 'post', 'gp_user_review' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->posts SET post_content = REPLACE( post_content, %s, %s )", 'gp_user_review', 'post' ) );
				update_option( 'ghostpool_convert_user_reviews', 1 );
			}
			
				
			/*--------------------------------------------------------------
			Convert deprecated elements to Blog elements
			--------------------------------------------------------------*/

			if ( isset( $_POST['ghostpool_convert_equivalant_elements'] ) && get_option( 'ghostpool_convert_equivalant_elements' ) != 1 ) {
			
				if ( ! wp_verify_nonce( $_REQUEST['ghostpool_theme_converter_nonce'], 'ghostpool_theme_converter_action' ) ) {
				  exit;
				}
			
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->posts SET post_content = REPLACE( post_content, %s, %s )", '[news', '[blog' ) );			
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->posts SET post_content = REPLACE( post_content, %s, %s )", '[videos', '[blog' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->posts SET post_content = REPLACE( post_content, %s, %s )", '[ranking', '[blog ranking="gp-ranking" format="gp-blog-minimal" excerpt_length="0"' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->posts SET post_content = REPLACE( post_content, %s, %s )", '[portfolio', '[blog' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->posts SET post_content = REPLACE( post_content, %s, %s )", 'display_site_rating', 'meta_site_rating' ) );				
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->posts SET post_content = REPLACE( post_content, %s, %s )", 'display_user_rating', 'meta_user_rating' ) );				
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->posts SET post_content = REPLACE( post_content, %s, %s )", 'meta_hub_cats', 'meta_cats' ) );
				update_option( 'ghostpool_convert_equivalant_elements', 1 );
			
			}
		

			/*--------------------------------------------------------------
			Convert slides and portfolios
			--------------------------------------------------------------*/

			if ( isset( $_POST['ghostpool_convert_slides_and_portfolios'] ) && get_option( 'ghostpool_convert_slides_and_portfolios' ) != 1 ) {				
			
				if ( ! wp_verify_nonce( $_REQUEST['ghostpool_theme_converter_nonce'], 'ghostpool_theme_converter_action' ) ) {
				  exit;
				}
			
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->posts SET post_type = %s WHERE post_type = %s", 'post', 'gp_slide' ) );		
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->posts SET post_type = %s WHERE post_type = %s", 'post', 'gp_portfolio_item' ) );	
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->term_taxonomy SET taxonomy = %s WHERE taxonomy = %s", 'category', 'gp_slides' ) );
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->term_taxonomy SET taxonomy = %s WHERE taxonomy = %s", 'category', 'gp_portfolios' ) );
				update_option( 'ghostpool_convert_slides_and_portfolios', 1 );
			
			}
		
		
			/*--------------------------------------------------------------
			Change shortcodes to load posts instead of pages
			--------------------------------------------------------------*/

			if ( isset( $_POST['ghostpool_convert_hubs_to_posts'] ) && get_option( 'ghostpool_convert_hubs_to_posts' ) != 1 ) {
						
				if ( ! wp_verify_nonce( $_REQUEST['ghostpool_theme_converter_nonce'], 'ghostpool_theme_converter_action' ) ) {
				  exit;
				}
			
				$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->posts SET post_content = REPLACE( post_content, %s, %s )", 'post_types="page"', 'post_types="post"' ) );
				update_option( 'ghostpool_convert_hubs_to_posts', 1 );
			
			}
		
		
			/*--------------------------------------------------------------
			Convert home, following and post submission pages
			--------------------------------------------------------------*/

			if ( isset( $_POST['ghostpool_convert_homepage'] ) && get_option( 'ghostpool_convert_homepage' ) != 1 ) {				
			
				if ( ! wp_verify_nonce( $_REQUEST['ghostpool_theme_converter_nonce'], 'ghostpool_theme_converter_action' ) ) {
				  exit;
				}
			
				// Convert homepage template
				$home_args = array(
					'post_type' => 'page',
					'posts_per_page' => -1,
					'meta_query' => array(
						'relation' => 'OR',
						array(
							'key' => '_ghostpool_old_template',
							'value' => 'flexslider-template.php'
						),	
						array(
							'key' => '_ghostpool_old_template',
							'value' => 'featured-template.php'
						),
						array(
							'key' => '_ghostpool_old_template',
							'value' => 'homepage-template.php'
						),
					)
				);
				$query = new WP_Query( $home_args );
				if ( $query->have_posts() ) : $convert_content .= true; while ( $query->have_posts() ) : $query->the_post();
			
					// Convert pages with FlexSlider/Featured templates to Homepage template
					update_post_meta( get_the_ID(), '_wp_page_template', 'homepage-template.php' );	

					// Disable featured posts on homepage
					update_post_meta( get_the_ID(), 'latest_news', 'disabled' );
			
					// Change default value to no sideabr
					update_post_meta( get_the_ID(), 'layout', 'gp-no-sidebar', 'default' );
											
				endwhile; endif; wp_reset_postdata();
		
				// Assign Following page to theme options
				$following_args = array(
					'post_type' => 'page',
					'posts_per_page' => 1,
					'meta_query' => array(
						'relation' => 'OR',
						array(
							'key' => '_wp_page_template',
							'value' => 'following-template.php',	
						),
						array(
							'key' => '_ghostpool_old_template',
							'value' => 'following-template.php'
						),
					),
				);
				$query = new WP_Query( $following_args );
				if ( $query->have_posts() ) : $convert_content .= true; while ( $query->have_posts() ) : $query->the_post();
					Redux::setOption( 'ghostpool_huber', 'following_page', get_the_ID() );			
					delete_post_meta( get_the_ID(), '_wp_page_template' );				
				endwhile; endif; wp_reset_postdata();

				// Assign Post Submission page to theme options
				$following_args = array(
					'post_type' => 'page',
					'posts_per_page' => 1,
					'meta_query' => array(
						'relation' => 'OR',
						array(
							'key' => '_ghostpool_old_template',
							'value' => 'my-reviews-template.php'
						),
					),
				);
				$query = new WP_Query( $following_args );
				if ( $query->have_posts() ) : while ( $query->have_posts() ) : $query->the_post();
					Redux::setOption( 'ghostpool_huber', 'post_submission_page', get_the_ID() );	
					delete_post_meta( get_the_ID(), '_wp_page_template' );							
				endwhile; endif; wp_reset_postdata();
							
				update_option( 'ghostpool_convert_homepage', 1 );

			}	
	

			/*--------------------------------------------------------------
			Convert hubs and reviews
			--------------------------------------------------------------*/
		
			if ( isset( $_POST['ghostpool_convert_hubs_reviews'] ) ) {				
			
				if ( ! wp_verify_nonce( $_REQUEST['ghostpool_theme_converter_nonce'], 'ghostpool_theme_converter_action' ) ) {
				  exit;
				}
			

				/*--------------------------------------------------------------
				Get child pages functions
				--------------------------------------------------------------*/

				if ( ! function_exists( 'ghostpool_child_pages' ) ) {
					function ghostpool_child_pages( $post_id ) {
				
						global $wpdb;
				
						$hub_child_page_args = array(
							'depth'     => -1,
							'child_of'  => $post_id,
						);
						$child_pages = get_pages( $hub_child_page_args ); 
				
						if ( $child_pages ) {
				
							foreach( $child_pages as $child_page ) {
		
								if ( get_post_meta( $child_page->ID, '_ghostpool_old_template', true ) == 'review-template.php' OR get_post_meta( $child_page->ID, '_ghostpool_old_template', true ) == 'news-template.php' OR get_post_meta( $child_page->ID, '_ghostpool_old_template', true ) == 'images-template.php' OR get_post_meta( $child_page->ID, '_ghostpool_old_template', true ) == 'videos-template.php' OR get_post_meta( $child_page->ID, '_ghostpool_old_template', true ) == 'write-a-review-template.php' OR get_post_meta( $child_page->ID, '_ghostpool_old_template', true ) == 'user-reviews-template.php' ) {

									////////////////////// Convert review pages //////////////////////
						
									if ( get_post_meta( $child_page->ID, '_ghostpool_old_template', true ) == 'review-template.php' ) {
							
										// Convert pages with review page template to Template option
										update_post_meta( $child_page->ID, 'template', 'gp-review-post' );
			
										// Associate reviews with parent hub pages
										add_post_meta( $child_page->ID, 'hub_association_ids', $child_page->post_parent );
										
										// Add old URL as custom field
										add_post_meta( $child_page->ID, '_ghostpool_old_permalink', get_permalink( $child_page->ID ) );
																	
										// Assign sidebar
										if ( get_post_meta( $child_page->ID, 'review_sidebar', true ) ) {
											add_post_meta( $child_page->ID, 'right_sidebar', get_post_meta( $child_page->ID, 'review_sidebar', true ) );
										}

										// Prefix parent hub page title to review page				
										if ( isset( $_POST['ghostpool_prefix_reviews'] ) && $_POST['ghostpool_prefix_reviews'] == '1' ) {
											wp_update_post( array(
												'ID'         => $child_page->ID,
												'post_title' => get_the_title( $child_page->post_parent ) . ' ' . get_the_title( $child_page->ID ),
												'post_name'  => sanitize_title_with_dashes( get_the_title( $child_page->post_parent ) . ' ' . get_the_title( $child_page->ID ) ),
											) );
										}
							
										if ( isset( $_POST['ghostpool_convert_hubs_to_posts'] ) && $_POST['ghostpool_convert_hubs_to_posts'] == '1' ) {
											wp_update_post( array(
												'ID'        => $child_page->ID,
												'post_type' => 'post',
											) );
										}

										// Change rating user meta keys
										$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->usermeta SET meta_key = %s WHERE meta_key = %s", 'ghostpool_rated_' . $child_page->post_parent, '_gp_rated_' . $child_page->post_parent ) );
										$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->usermeta SET meta_key = %s WHERE meta_key = %s", 'ghostpool_current_position_' . $child_page->post_parent, '_gp_current_position_' . $child_page->post_parent ) );
										$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->usermeta SET meta_key = %s WHERE meta_key = %s", 'ghostpool_user_rating_' . $child_page->post_parent, '_gp_user_rating_' . $child_page->post_parent ) );
					
									}
							
									////////////////////// Convert image pages //////////////////////
							
									// Transfer and delete images from child image page to hub page
									if ( get_post_meta( $child_page->ID, '_ghostpool_old_template', true ) == 'images-template.php' ) {
										add_post_meta( $child_page->post_parent, 'images_tab_gallery', get_post_meta( $child_page->ID, 'images_gallery', true ) );
										delete_post_meta( $child_page->ID, 'images_gallery' );	
									}
			
									////////////////////// Delete default child pages //////////////////////
							
									if ( isset( $_POST['ghostpool_delete_default_child_pages'] ) && $_POST['ghostpool_delete_default_child_pages'] == '1' ) {
										if ( get_post_meta( $child_page->ID, '_ghostpool_old_template', true ) == 'news-template.php' OR get_post_meta( $child_page->ID, '_ghostpool_old_template', true ) == 'images-template.php' OR get_post_meta( $child_page->ID, '_ghostpool_old_template', true ) == 'videos-template.php' OR get_post_meta( $child_page->ID, '_ghostpool_old_template', true ) == 'write-a-review-template.php' OR get_post_meta( $child_page->ID, '_ghostpool_old_template', true ) == 'user-reviews-template.php' ) {
											wp_delete_post( $child_page->ID );
										}
									}
												
								} else {
			
									// Add custom_hub_tab_ids field to all child pages so can be queried in future
									if ( ! get_post_meta( $child_page->ID, 'custom_hub_tab_ids', true ) ) {
										update_post_meta( $child_page->ID, 'custom_hub_tab_ids', $post_id );
									}
			
									// Change child page to post
									if ( isset( $_POST['ghostpool_convert_child_pages_to_posts'] ) && $_POST['ghostpool_convert_child_pages_to_posts'] == '1' ) {	
										wp_update_post( array(
											'ID'           => $child_page->ID,
											'post_type' => 'post',
										) );
									}

								}

							}
								
						}
					}
				}


				/*--------------------------------------------------------------
				Convert hub pages
				--------------------------------------------------------------*/

				$release_date_error = false;
				$hub_page_args = array(
					'post_type' => 'page',
					'orderby' => 'title',
					'order' => 'asc',
					'posts_per_page' => absint( $_POST['ghostpool_limit'] ),
					'meta_query' => array(
						'relation' => 'OR',
						array(
							'key' => '_ghostpool_old_template',
							'value' => 'hub-template.php'
						),			
						array(
							'key' => '_ghostpool_old_template',
							'value' => 'hub-review-template.php'
						),
					)
				);
				$query = new WP_Query( $hub_page_args );
				if ( $query->have_posts() ) : $convert_content .= true; while ( $query->have_posts() ) : $query->the_post();			
						
					// Convert release date taxonomy to custom date field
					if ( isset( $_POST['ghostpool_release_date_slug'] ) && ! empty( $_POST['ghostpool_release_date_slug'] ) ) {
						$release_date = get_the_terms( get_the_ID(), $_POST['ghostpool_release_date_slug'] );
						if ( $release_date && ! is_wp_error( $release_date ) ) {
							$release_date = $release_date[0];
							try {
								//$new_release_date = date_i18n( ghostpool_option( 'release_date_format' ), strtotime( $release_date->name ) );				
								$new_release_date = new DateTime( $release_date->name );
								$new_release_date = $new_release_date->format( ghostpool_option( 'release_date_format' ) );													
								if ( ! get_post_meta( get_the_ID(), 'release_date', true ) ) {
									update_post_meta( get_the_ID(), 'release_date', $new_release_date );
								}
							} catch(\Exception $e) {
								$release_date_error = true;
							}
						}	
					}	
					
					if ( $release_date_error != true ) {
					
						ghostpool_child_pages( get_the_ID() );

						// Convert pages with hub page template to Template option
						if ( get_post_meta( get_the_ID(), '_ghostpool_old_template', true ) == 'hub-template.php' ) {
							update_post_meta( get_the_ID(), 'template', 'gp-hub-post' );
						} elseif ( get_post_meta( get_the_ID(), '_ghostpool_old_template', true ) == 'hub-review-template.php'  ) {
							update_post_meta( get_the_ID(), 'template', 'gp-review-post' );	
						}	

						// Add hidden site rating field score to main site rating field
						if ( get_post_meta( get_the_ID(), 'ghostpool_site_rating', true ) != '' && get_post_meta( get_the_ID(), '_ghostpool_old_template', true ) == 'hub-template.php' ) {
							update_post_meta( get_the_ID(), 'site_rating', get_post_meta( get_the_ID(), 'ghostpool_site_rating', true ) );
						}
																	
						// Add old URL as custom field
						add_post_meta( get_the_ID(), '_ghostpool_old_permalink', get_permalink( get_the_ID() ) );			
						
						// Assign sidebar
						if ( get_post_meta( get_the_ID(), '_ghostpool_old_template', true ) == 'hub-template.php' && get_post_meta( get_the_ID(), 'hub_sidebar', true ) ) {
							add_post_meta( get_the_ID(), 'right_sidebar', get_post_meta( get_the_ID(), 'hub_sidebar', true ) );
						} elseif ( get_post_meta( get_the_ID(), '_ghostpool_old_template', true ) == 'hub-review-template.php' && get_post_meta( get_the_ID(), 'hub_review_sidebar', true ) ) {
							add_post_meta( get_the_ID(), 'right_sidebar', get_post_meta( get_the_ID(), 'hub_review_sidebar', true ) );
						}
			
						// Delete hub page content			
						if ( isset( $_POST['ghostpool_delete_hub_page_content'] ) && $_POST['ghostpool_delete_hub_page_content'] == '1' && get_post_meta( get_the_ID(), '_ghostpool_old_template', true ) == 'hub-template.php' ) {
							wp_update_post( array(
								'ID'           => get_the_ID(),
								'post_content' => '',
							) );
						}
			
						// Change hub page to post	
						if ( isset( $_POST['ghostpool_convert_hubs_to_posts'] ) && $_POST['ghostpool_convert_hubs_to_posts'] == '1' ) {
							wp_update_post( array(
								'ID'        => get_the_ID(),
								'post_type' => 'post',
							) );
						}

						// Change rating user meta keys
						$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->usermeta SET meta_key = %s WHERE meta_key = %s", 'ghostpool_rated_' . get_the_ID(), '_gp_rated_' . get_the_ID() ) );
						$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->usermeta SET meta_key = %s WHERE meta_key = %s", 'ghostpool_current_position_' . get_the_ID(), '_gp_current_position_' . get_the_ID() ) );
						$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->usermeta SET meta_key = %s WHERE meta_key = %s", 'ghostpool_user_rating_' . get_the_ID(), '_gp_user_rating_' . get_the_ID() ) );
					
					}
																									
				endwhile; endif; wp_reset_postdata();
			
				update_option( 'ghostpool_convert_hubs_reviews', 1 );
			
			} ?>
			

			<div class="wrap">
			
				<h2><?php esc_html_e( 'Theme Converter', 'huber' ); ?></h2>

				<div class="gp-converter-box">
			
					<p><strong><?php esc_html_e( 'The Theme Converter will convert all your hubs and reviews from the Gauge or The Review theme so they work with Huber.', 'huber' ); ?></strong></p>
	
					<p><strong><?php esc_html_e( 'What IS converted', 'huber' ); ?></strong></p>
					<p><?php esc_html_e( 'Hubs no longer use child pages for tabs. The Reviews, News, Images and Videos tabs are now part of the hub page. The Theme Converter converts your hub pages moving all your associated reviews, news, videos and images to the new system. The following is also converted:', 'huber' ); ?></p>

					<ul class="ul-square">
						<li><?php esc_html_e( 'Associated reviews, news, videos and images.', 'huber' ); ?></li>
						<li><?php esc_html_e( 'Site ratings, user ratings, multi rating criteria, good/bad points, total user votes, your current ratings.', 'huber' ); ?></li>
						<li><?php esc_html_e( 'You can convert your release date hub field to an actual date field.', 'huber' ); ?></li>
						<li><?php esc_html_e( 'Hub categories and hub fields.', 'huber' ); ?></li>
						<li><?php esc_html_e( 'Your custom hub tabs will be displayed after the default hub tabs (Reviews, News, Images, Videos, Forums).', 'huber' ); ?></li>
						<li><?php esc_html_e( 'Affiliate links.', 'huber' ); ?></li>
						<li><?php esc_html_e( 'Following data for logged in users.', 'huber' ); ?></li>
						<li><?php esc_html_e( 'Page header, layout, sidebar, video settings.', 'huber' ); ?></li>
					</ul>
					
					<p><strong><?php esc_html_e( 'What is NOT converted', 'huber' ); ?></strong></p>
					<ul class="ul-square">
						<li><?php esc_html_e( 'Your hub awards from Gauge or The Review are not supported by this theme currently.', 'huber' ); ?></li>
					</ul>

					<p><strong><?php esc_html_e( 'What to do after importing', 'huber' ); ?></strong></p>
					<ul class="ul-square">				
						<li><?php esc_html_e( 'Reselect your menus from Appearance -> Menus.', 'huber' ); ?></li>
						<li><?php esc_html_e( 'To display the synopsis and user rating box you will need to insert the GP Rating Box widget into the desired sidebar.', 'huber' ); ?></li>
						<li><?php esc_html_e( 'To display recent videos on your hub page you will need to insert the GP Blog Posts widget into the desired sidebar.', 'huber' ); ?></li>
						<li><?php esc_html_e( 'To display recent images on your hub page you will need to insert the GP Images widget into the desired sidebar.', 'huber' ); ?></li>
						<li><?php esc_html_e( 'You can no longer set custom image dimensions as the theme does this all for you. You will need to recrop all your images by running the', 'huber' ); ?> <a href="https://wordpress.org/plugins/regenerate-thumbnails/" target="_blank"><?php esc_html_e( 'Regenerate Thumbnails', 'huber' ); ?></a> <?php esc_html_e( 'plugin', 'huber' ); ?>.</li>
					</ul>
					
					<div class="gp-converter-notice"><?php esc_html_e( 'Backup all your data before running this converter as this process cannot be reversed. Use this converter at your own risk.', 'huber' ); ?></div>
				
				</div>
		
				
				<form method="post" enctype="multipart/form-data">			

					<div class="gp-converter-box">
			
						<h3><?php esc_html_e( 'General', 'huber' ); ?></h3>
						
						<?php if ( isset( $_POST['ghostpool_update_theme_options'] ) OR isset( $_POST['ghostpool_convert_categories'] ) OR isset( $_POST['ghostpool_convert_user_reviews'] ) OR isset( $_POST['ghostpool_convert_homepage'] ) OR isset( $_POST['ghostpool_convert_equivalant_elements'] ) OR isset( $_POST['ghostpool_convert_slides_and_portfolios'] ) OR isset( $_POST['ghostpool_convert_release_date'] ) ) { ?>
							<div class="gp-converter-success"><?php esc_html_e( 'These items were succesfully converted!', 'huber' ); ?></div>
						<?php } ?>
					
						<table class="form-table">
							<tbody>
								<tr>
									<th scope="row">
										<label><?php esc_html_e( 'Update theme options', 'huber' ); ?></label>
										<p class="description"><?php esc_html_e( 'Update theme option names and values.', 'huber' ); ?></p>
									</th>
									<td>
										<input type="submit" value="<?php if ( get_option( 'ghostpool_update_theme_options' ) == 1 ) { esc_attr_e( 'Already converted', 'huber' ); } else { esc_attr_e( 'Convert', 'huber' ); } ?>" tabindex="40" name="ghostpool_update_theme_options" class="button<?php if ( get_option( 'ghostpool_update_theme_options' ) != 1 ) { ?> button-primary<?php } ?>" />
									</td>
								</tr>
								<tr>
									<th scope="row">
										<label><?php esc_html_e( 'Convert homepage', 'huber' ); ?></label>
										<p class="description"><?php esc_html_e( 'Convert the homepage to work with the new theme otherwise things will look weird.', 'huber' ); ?></p>
									</th>
									<td>
										<input type="submit" value="<?php if ( get_option( 'ghostpool_convert_homepage' ) == 1 ) { esc_attr_e( 'Already converted', 'huber' ); } else { esc_attr_e( 'Convert', 'huber' ); } ?>" tabindex="40" name="ghostpool_convert_homepage" class="button<?php if ( get_option( 'ghostpool_convert_homepage' ) != 1 ) { ?> button-primary<?php } ?>" />
									</td>
								</tr>	
								<tr>
									<th scope="row">
										<label><?php esc_html_e( 'Convert hub and video categories', 'huber' ); ?></label>
										<p class="description"><?php esc_html_e( 'Convert your hub and video categories to post categories because hubs, reviews and video posts now use ordinary posts categories.', 'huber' ); ?></p>
									</th>
									<td>
										<input type="submit" value="<?php if ( get_option( 'ghostpool_convert_categories' ) == 1 ) { esc_attr_e( 'Already converted', 'huber' ); } else { esc_attr_e( 'Convert', 'huber' ); } ?>" tabindex="40" name="ghostpool_convert_categories" class="button<?php if ( get_option( 'ghostpool_convert_categories' ) != 1 ) { ?> button-primary<?php } ?>" />
									</td>
								</tr>									
								<tr>
									<th scope="row">
										<label><?php esc_html_e( 'Convert user reviews', 'huber' ); ?></label>
										<p class="description"><?php esc_html_e( 'Convert your user reviews to ordinary posts as the user review post type is no longer supported.', 'huber' ); ?></p>
									</th>
									<td>
										<input type="submit" value="<?php if ( get_option( 'ghostpool_convert_user_reviews' ) == 1 ) { esc_attr_e( 'Already converted', 'huber' ); } else { esc_attr_e( 'Convert', 'huber' ); } ?>" tabindex="40" name="ghostpool_convert_user_reviews" class="button<?php if ( get_option( 'ghostpool_convert_user_reviews' ) != 1 ) { ?> button-primary<?php } ?>" />
									</td>
								</tr>																				
								<tr>
									<th scope="row">
										<label><?php esc_html_e( 'Convert equivalant elements', 'huber' ); ?></label>
										<p class="description"><?php esc_html_e( 'The News, Videos, Portfolio and Ranking elements do not exist in this theme. These elements are equivalant to the Blog element, which you can choose to convert them to.', 'huber' ); ?></p>
									</th>
									<td>
										<input type="submit" value="<?php if ( get_option( 'ghostpool_convert_equivalant_elements' ) == 1 ) { esc_attr_e( 'Already converted', 'huber' ); } else { esc_attr_e( 'Convert', 'huber' ); } ?>" tabindex="40" name="ghostpool_convert_equivalant_elements" class="button<?php if ( get_option( 'ghostpool_convert_equivalant_elements' ) != 1 ) { ?> button-primary<?php } ?>" />
									</td>
								</tr>	
													
								<tr>
									<th scope="row">
										<label><?php esc_html_e( 'Convert slides and portfolio post types to posts', 'huber' ); ?></label>
										<p class="description"><?php esc_html_e( 'This theme does not support slide and portfolio post types, so you can choose convert these to posts.', 'huber' ); ?></p>		
									</th>
									<td>
										<input type="submit" value="<?php if ( get_option( 'ghostpool_convert_slides_and_portfolios' ) == 1 ) { esc_attr_e( 'Already converted', 'huber' ); } else { esc_attr_e( 'Convert', 'huber' ); } ?>" tabindex="40" name="ghostpool_convert_slides_and_portfolios" class="button<?php if ( get_option( 'ghostpool_convert_slides_and_portfolios' ) != 1 ) { ?> button-primary<?php } ?>" />
									</td>
								</tr>			
							</tbody>																
						</table>
						
					</div>
				
					<div class="gp-converter-box">
					
						<h3><?php esc_html_e( 'Convert hub and reviews', 'huber' ); ?></h3>

						<?php if ( isset( $_POST['ghostpool_convert_hubs_reviews'] ) ) { ?>
							<?php if ( $release_date_error == true ) { ?>
								<div class="gp-converter-error"><?php esc_html_e( 'No hubs have been converted because your release dates do not use a valid date format. If you\'re using the names of the months in a language other than English you will first need to change these to English and then run the converter again. Alternatively leave the release date field empty.', 'huber' ); ?></div>
							<?php } else { ?>
								<?php if ( $convert_content == '' ) { ?>
									<div class="gp-converter-error"><?php esc_html_e( 'No hubs have been converted, this is probably because you have already converted all of them.', 'huber' ); ?></div>
								<?php } else { ?>
									<div class="gp-converter-success"><?php echo $_POST['ghostpool_limit']; ?> <?php esc_html_e( 'hubs have been successfully converted.', 'huber' ); ?></div>
								<?php } ?>
							<?php } ?>	
						<?php } ?>
					
						<table class="form-table">
							<tbody>
								<tr>
									<th scope="row">
										<label><?php esc_html_e( 'Number of hubs to convert at a time', 'huber' ); ?></label><p class="description"><?php esc_html_e( 'Enter a lower number if you get an error when converting.', 'huber' ); ?></p>
									</th>
									<td>
										<input type="number" step="1" min="0" name="ghostpool_limit" class="small-text" value="<?php if ( isset( $_POST['ghostpool_limit'] ) ) { echo absint( $_POST['ghostpool_limit'] ); } else { echo 25; } ?>" />
									</td>
								</tr>
								<tr>
									<th scope="row">
										<label><?php esc_html_e( 'Convert hub and reviews to posts', 'huber' ); ?></label>
										<p class="description"><?php esc_html_e( 'Choose to convert hub and review pages to posts.', 'huber' ); ?></p>
									</th>
									<td>
										<input type="checkbox" name="ghostpool_convert_hubs_to_posts" value="1"<?php if ( isset( $_POST['ghostpool_convert_hubs_to_posts'] ) OR get_option( 'ghostpool_convert_hubs_reviews' ) != '1' ) { echo ' checked'; } ?> />
									</td>
								</tr>
								<tr>
									<th scope="row">
										<label><?php esc_html_e( 'Delete hub page content', 'huber' ); ?></label>
										<p class="description"><?php esc_html_e( 'Hub pages now display the latest news posts by default and no longer require Visual Composer elements. The News, Videos and Images shortcodes are no longer supported. As a result you may want to remove this content from your hub pages.', 'huber' ); ?></p>
									</th>
									<td>
										<input type="checkbox" name="ghostpool_delete_hub_page_content" value="1"<?php if ( isset( $_POST['ghostpool_delete_hub_page_content'] ) OR get_option( 'ghostpool_convert_hubs_reviews' ) != '1' ) { echo ' checked'; } ?> />
									</td>
								</tr>
																				
								<tr>
									<th scope="row">
										<label><?php esc_html_e( 'Delete default child pages', 'huber' ); ?></label>
										<p class="description"><?php esc_html_e( 'When you run the theme converter all your child page content is incorporated into the hub page so they can be deleted. This deletes ANY child pages that use the Review, News, Images, Videos, Write A Review and User Review page templates.', 'huber' ); ?></p>
										</th>
									<td>
										<input type="checkbox" name="ghostpool_delete_default_child_pages" value="1"<?php if ( isset( $_POST['ghostpool_delete_default_child_pages'] ) OR get_option( 'ghostpool_convert_hubs_reviews' ) != '1' ) { echo ' checked'; } ?> />
									</td>
								</tr>							
								<tr>
									<th scope="row">
										<label><?php esc_html_e( 'Convert custom child pages to posts', 'huber' ); ?></label>
										<p class="description"><?php esc_html_e( 'Choose to convert custom child pages to posts. This does NOT convert any child pages that use the Review, News, Images, Videos, Write A Review and User Review page templates).', 'huber' ); ?></p>	
									</th>
									<td>
										<input type="checkbox" name="ghostpool_convert_child_pages_to_posts" value="1"<?php if ( isset( $_POST['ghostpool_convert_child_pages_to_posts'] )  OR get_option( 'ghostpool_convert_hubs_reviews' ) != '1' ) { echo ' checked'; } ?> />
									</td>
								</tr>					
								<tr>
									<th scope="row">
										<label><?php esc_html_e( 'Prefix reviews with hub page title', 'huber' ); ?></label>
										<p class="description"><?php esc_html_e( 'Reviews are no longer child pages of hub pages they are completely separate. If your review pages are just called "Review" for example you can prefix the parent hub page titles to the review page titles.', 'huber' ); ?></p>	
									</th>
									<td>
										<input type="checkbox" name="ghostpool_prefix_reviews" value="1"<?php if ( isset( $_POST['ghostpool_prefix_reviews'] ) OR get_option( 'ghostpool_convert_hubs_reviews' ) != '1' ) { echo ' checked'; } ?> />
									</td>
								</tr>								
								<tr>
									<th scope="row">
										<label><?php esc_html_e( 'Convert release date hub field to date field', 'huber' ); ?></label>
										<p class="description"><?php esc_html_e( 'Enter the slug of your release date taxonomy e.g. "release-date".', 'huber' ); ?></p>	
									</th>
									<td>
										<input type="text" name="ghostpool_release_date_slug" value="<?php if ( isset( $_POST['ghostpool_release_date_slug'] ) ) { echo $_POST['ghostpool_release_date_slug']; } ?>" />
									</td>
								</tr>				
							</tbody>
						</table>
							
						<p><input type="submit" value="<?php esc_attr_e( 'Convert', 'huber' ); ?>" tabindex="40" name="ghostpool_convert_hubs_reviews" class="button" /></p>
			
					</div>
					
					<?php wp_nonce_field( 'ghostpool_theme_converter_action', 'ghostpool_theme_converter_nonce' ); ?>
						
				</form>	

			</div>
	
		<?php } else { ?>
		
			<h2><?php esc_html_e( 'Theme Converter', 'huber' ); ?></h2>

			<strong><?php esc_html_e( 'Please enable the Huber Plugin before running the Theme Converter.', 'huber' ); ?></strong>
			
		<?php }
	}
}

?>