<?php

/* Page/paged query
 *
 */	
if ( ! function_exists( 'ghostpool_paged' ) ) {
	function ghostpool_paged() {
		if ( get_query_var( 'paged' ) ) {
			return get_query_var( 'paged' );
		} elseif ( get_query_var( 'page' ) ) {
			return get_query_var( 'page' );
		} else {
			return 1;
		}
	}
}	

/**
 * Get categories
 *
 */
if ( ! function_exists( 'ghostpool_cats' ) ) {
	function ghostpool_cats( $cats = '', $type = 'param' ) {

		// Convert array to string
		if ( is_array( $cats ) ) {
			$cats = implode( ',', $cats );
		}
		
		if ( ! empty( $cats ) && preg_match( '/^[1-9, ][0-9, ]*$/', $cats ) ) {
			$param = 'cat';
		} elseif ( ! empty( $cats ) ) {
			$param = 'category_name';
		} else {
			$param = null;
		}
		
		if ( $type == 'param' ) {
			return $param;
		} elseif ( $type == 'variables' ) {
			return $cats;
		}				
						
	}
}		
			
/**
 * Get hub fields
 *
 */
if ( ! function_exists( 'ghostpool_tax' ) ) {
	function ghostpool_tax( $hub_fields = '' ) {

		if ( $hub_fields ) {
			$field = array();
			// Put hub fields into an array
			$hub_fields_array = explode( ',', $hub_fields );
			foreach ( $hub_fields_array as $hub_field ) {
				// Get taxonomy e.g. genre
				$taxonomy = strstr( $hub_field, ':', true );
				// Get terms e.g. horror, romance
				$terms = strstr( $hub_field, ':', false );
				// Remove : from front of terms
				$terms = ltrim( $terms, ':' );
				// Put list of terms into an array
				$terms = explode( ':', $terms );
				// Hub field tax query
				$field[] = array( 
					'taxonomy' => $taxonomy,
					'field'     => 'slug',
					'terms'     => $terms,
					'operator' => 'AND',
				);	
			}
			$hub_fields_arrays = array( 'relation' => 'AND' ) + $field;
		} else {
			$hub_fields_arrays = null;
		}
		
		// Output tax_query arrays
		return array( 
			'relation' => 'AND',
			$hub_fields_arrays,
		);	
		
	}
}			

/**
 * Get orderby values
 *
 */
if ( ! function_exists( 'ghostpool_orderby' ) ) {
	function ghostpool_orderby( $value, $type = '', $release_date_from = '', $release_date_to = '', $post_association = '', $post_id = '' ) {
	
		$orderby = '';
		$order = '';	
		$meta_key = '';		
		$meta_query = '';

		if ( $value == 'newest' ) {
			$orderby = 'date';
			$order = 'desc';
		} elseif ( $value == 'oldest' ) {
			$orderby = 'date';
			$order = 'asc';		
		} elseif ( $value  == 'title_az' ) {
			$orderby = 'title';
			$order = 'asc';
		} elseif ( $value  == 'title_za' ) {
			$orderby = 'title';
			$order = 'desc';								
		} elseif ( $value == 'comment_count' ) {
			$orderby = 'comment_count';
			$order = 'desc';
		} elseif ( $value == 'views' ) {
			$orderby = 'meta_value_num';
			$order = 'desc';
			$meta_key = apply_filters( 'ghostpool_views_meta_key', 'views_total' );	
		} elseif ( $value == 'likes' ) {
			$orderby = 'meta_value_num';
			$order = 'desc';
			$meta_key = 'ghostpool_voting_up';
		} elseif ( $value == 'menu_order' ) {
			$orderby = 'menu_order';
			$order = 'asc';
		} elseif ( $value == 'rand' ) {
			$orderby = 'rand';
			$order = 'asc';
		} elseif ( $value == 'release_date' ) {
			$orderby = 'meta_value';
			$order = apply_filters( 'ghostpool_release_date_order', 'desc' );
			$meta_key = 'release_date';
			$meta_query =  array(
			   'key' => 'release_date',
			   'type' => 'DATETIME',
		   );
		} elseif ( $value == 'release_date_asc' ) {
			$orderby = 'meta_value';
			$order = 'asc';
			$meta_key = 'release_date';
			$meta_query =  array(
			   'key' => 'release_date',
			   'type' => 'DATETIME',
		   );		   
		} elseif ( $value == 'site_rating' ) {
			$orderby = 'meta_value_num';
			$order = 'desc';
			$meta_key = 'ghostpool_site_rating';	
		} elseif ( $value  == 'user_rating' ) {
			$orderby = array( 'meta_value_num' => 'desc', 'ghostpool_user_rating' => 'desc', 'user_votes' => 'desc' );
			$order = 'desc';
			$meta_key = 'ghostpool_user_rating';	
			$meta_query = array( 
				'user_rating' => array( 'key' => 'ghostpool_user_rating', 'type' => 'DECIMAL', 'compare' => 'EXISTS' ), 
				'user_votes' => array( 'key' => 'ghostpool_user_votes', 'type' => 'NUMERIC', 'compare' => 'EXISTS' )
			);
		} elseif ( $value == 'relevance' ) {
			$orderby = 'relevance';
			$order = 'desc';
		}
		
		// Release date meta queries
		if ( $release_date_from == 'today' ) {
			$release_date_from = date( 'Ymd', strtotime( '+1 day' ) );
		} elseif ( $release_date_from != '' ) {
			$release_date_from = date( 'Ymd', strtotime( $release_date_from ) );
		} else {
			$release_date_from = null;
		}
		if ( $release_date_to == 'today' ) {
			$release_date_to = date( 'Ymd' );
		} elseif ( $release_date_to != '' ) {
			$release_date_to = date( 'Ymd', strtotime( $release_date_to ) );
		} else {
			$release_date_to = null;
		}
		if ( $release_date_from ) {
			$release_date_from_array = array(
				'key' => 'release_date',
				'value' => $release_date_from,
				'compare' => '>=',
				'type' => 'DATETIME'
			);
		} else {
			$release_date_from_array = '';	
		}
		if ( $release_date_to ) {
			$release_date_to_array = array(
				'key' => 'release_date',
				'value' => $release_date_to,
				'compare' => '<=',
				'type' => 'DATETIME'
			);	
		} else {
			$release_date_to_array = null;	
		}		
	
		// Post Association
		if ( $post_association == 'enabled' ) {
			$post_association_array = array( 
				'relation' => 'AND', 
				array(
					'relation' => 'OR',
					array( 'key' => 'hub_association_ids', 'value' => sprintf( ' "%s" ', $post_id ), 'compare' => 'LIKE' ),	
					array( 'key' => 'hub_association_ids', 'value' => $post_id, 'compare' => '=' ),		
				),	
			);
		} else {
			$post_association_array = null;
		}
						
		if ( $type == 'orderby' ) {
			return $orderby;
		} elseif ( $type == 'order' ) {	
			return $order;
		} elseif ( $type == 'meta_key' ) {
			return $meta_key;
		} elseif ( $type == 'meta_query' ) {
			return array(
				'relation' => 'AND',
				$meta_query,
				$release_date_from_array,
				$release_date_to_array,
				$post_association_array
			);
		}	

	}
}

/**
 * Get templates and post type queries
 *
 */ 
if ( ! function_exists( 'ghostpool_category_queries' ) ) {
	function ghostpool_templates_query( $templates = '' ) {	
		if ( $templates ) {
			$fields = array();
			foreach( $templates as $template ) {
				$fields[] = array( 
					'key' => 'template',
					'value' => $template,
					'compare' => '=',
				);			
			}
			return array( 'relation' => 'OR' ) + $fields;
		} else {	
			return null;		
		}	
	}
}

/*global $ghostpool_db_version;
$ghostpool_db_version = '1.0';

if ( get_site_option( 'ghostpool_huber_db_table_version' ) != $ghostpool_db_version ) {
	function ghostpool_create_table() {
		global $wpdb;
		global $ghostpool_db_version;

		$table_name = $wpdb->prefix . 'ghostpool_template';
	
		$charset_collate = $wpdb->get_charset_collate();

		$sql = "CREATE TABLE $table_name (
			post_id bigint(20) DEFAULT '0' NOT NULL,
			template varchar(20) DEFAULT 'gp-standard-post' NOT NULL,
			PRIMARY KEY  (post_id)
		) $charset_collate;";

		require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
		dbDelta( $sql );

		add_option( 'ghostpool_huber_db_table_version', $ghostpool_db_version );
	}
	add_action( 'init', 'ghostpool_create_table' );
}

function ghostpool_add_data( $ID ) {
	global $wpdb;
	
	$template = get_post_meta( $ID, 'template', true );

	$table_name = $wpdb->prefix . 'ghostpool_template';
	
	$wpdb->insert( 
		$table_name, 
		array(
			'post_id' => $ID, 
			'template' => $template, 
		) 
	);
}
add_action( 'publish_post', 'ghostpool_add_data', 12, 1 );*/

/**
 * Alter taxonomy queries
 *
 */	
if ( ! function_exists( 'ghostpool_category_queries' ) ) {
	function ghostpool_category_queries( $query ) {	
		if ( is_admin() OR ! $query->is_main_query() ) { 
			return;
		} elseif ( is_archive() OR is_search() OR is_author() OR $query->get( 'wc_query' ) === 'product_query' ) {

			// Load variables for specific taxonomy type
			if ( function_exists( 'is_woocommerce' ) && is_shop() ) {
				$per_page = ghostpool_option( 'wc_shop_per_page' );
			} elseif ( function_exists( 'is_woocommerce' ) && ( is_product_category() OR is_product_tag() ) ) {
				$per_page = ghostpool_option( 'wc_product_cat_per_page' );	
			} elseif ( is_search() ) {
				$orderby = ghostpool_option( 'search_orderby' );
				$per_page = ghostpool_option( 'search_per_page' );
				$post_type = ghostpool_option( 'search_post_types' );
				$meta_query = ghostpool_templates_query( ghostpool_option( 'search_templates' ) );
			} elseif ( is_author() ) {
				$orderby = ghostpool_option( 'author_orderby' );
				$per_page = ghostpool_option( 'author_per_page' );
				$post_type = ghostpool_option( 'author_post_types' );
				$meta_query = ghostpool_templates_query( ghostpool_option( 'author_templates' ) );
			} elseif ( is_archive() ) {
				$orderby = ghostpool_option( 'cat_orderby' );
				$per_page = ghostpool_option( 'cat_per_page' );
			}

			// Set global taxonomy queries
			if ( isset( $per_page ) ) {
				$query->set( 'posts_per_page', $per_page );
			}
			if ( isset( $orderby ) ) {
				$query->set( 'orderby', ghostpool_orderby( $orderby, 'orderby' ) );	
				$query->set( 'order', ghostpool_orderby( $orderby, 'order' ) );
				$query->set( 'meta_key', ghostpool_orderby( $orderby, 'meta_key' ) );
			}
			if ( isset( $post_type ) ) {
				$query->set( 'post_type', $post_type );
			}
			if ( isset( $meta_query ) ) {
				$query->set( 'meta_query', $meta_query );
			}
			
			return;
		}
	}
}	
add_action( 'pre_get_posts', 'ghostpool_category_queries', 1 );

/**
 * Load category and orderby filters
 *
 */
if ( ! function_exists( 'ghostpool_filter' ) ) {
	function ghostpool_filter( $type = '', $cats_id = '', $orderby = '', $pagination = '', $page = true ) {
	
		// Sorting options
		$relevance = ( isset( $type['relevance'] ) && $type['relevance'] != '' && $type['relevance'] != 0 ) ? '1' : '0';
		$date = ( isset( $type['date'] ) && $type['date'] != '' && $type['date'] != 0 ) ? '1' : '0';
		$title = ( isset( $type['title'] ) && $type['title'] != '' && $type['title'] != 0 ) ? '1' : '0';
		$comment_count = ( isset( $type['comment_count'] ) && $type['comment_count'] != '' && $type['comment_count'] != 0 ) ? '1' : '0';
		$views = ( isset( $type['views'] ) && $type['views'] != '' && $type['views'] != 0 ) ? '1' : '0';
		$likes = ( isset( $type['likes'] ) && $type['likes'] != '' && $type['likes'] != 0 ) ? '1' : '0';
		$release_date_desc = ( isset( $type['release_date'] ) && $type['release_date'] != '' && $type['release_date'] != 0 ) ? '1' : '0';
		$release_date_asc = ( isset( $type['release_date_asc'] ) && $type['release_date_asc'] != '' && $type['release_date_asc'] != 0 ) ? '1' : '0';
		$site_rating = ( isset( $type['site_rating'] ) && $type['site_rating'] != '' && $type['site_rating'] != 0 ) ? '1' : '0';
		$user_rating = ( isset( $type['user_rating'] ) && $type['user_rating'] != '' && $type['user_rating'] != 0 ) ? '1' : '0';		

		if ( ( $cats_id != '' OR $relevance OR $date OR $title OR $comment_count OR $views OR $likes OR $release_date_desc OR $release_date_asc OR $site_rating OR $user_rating ) && ghostpool_option( 'ajax' ) == 'gp-ajax-loop' && $pagination != 'load-more' ) { ?>
		
			<?php if ( $page == true ) { ?><div class="gp-filter-wrapper"><?php } ?>
			
				<div class="gp-filter-menus">

					<?php if ( $cats_id != '' ) { 

						// Add slug support for filter categories option
						if ( ! preg_match( '/^[1-9][0-9]*$/', $cats_id ) ) {
							$cats_slug = get_term_by( 'slug', $cats_id, 'category' );
							if ( $cats_slug ) {
								$cats_id = $cats_slug->term_id;
							}
						}
						$args = array(
							'parent' 	 => (int) $cats_id,
							'hide_empty' => false,
						);
						$term = term_exists( (int) $cats_id, 'category' );
						if ( $term !== 0 && $term !== null ) {
							$terms = get_terms( 'category', $args );
						} else {
							$terms = get_terms( 'category' );
						}
		
						if ( $terms ) { ?>
							<select name="gp-filter-cats" class="gp-filter-menu gp-filter-cats">	
								<option value="<?php echo esc_attr( $cats_id ); ?>"><?php esc_html_e( 'All', 'huber' ); ?></option>		
								<?php foreach( $terms as $term ) {
									if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) { ?>
										<option value="<?php echo esc_attr( $term->term_id ); ?>"><?php echo esc_attr( $term->name ); ?></option>
									<?php } ?>
								<?php } ?>
							</select>
						<?php } ?>
					<?php }
		
					if ( $relevance OR $date OR $title OR $comment_count OR $views OR $likes OR $release_date_desc OR $release_date_asc OR $site_rating OR $user_rating ) { ?>

						<select name="gp-filter-orderby" class="gp-filter-menu gp-filter-orderby">

							<?php if ( ( isset( $type['relevance'] ) && $type['relevance'] == '1' ) ) { ?>
								<option value="relevance"<?php if ( $orderby == 'relevance' ) { ?> selected="selected"<?php } ?>><?php esc_html_e( 'Relevance', 'huber' ); ?></option>
							<?php } ?>
					
							<?php if ( $type['date'] == '1' ) { ?>
								<option value="newest"<?php if ( $orderby == 'newest' ) { ?> selected="selected"<?php } ?>><?php esc_html_e( 'Newest', 'huber' ); ?></option>
								<option value="oldest"<?php if ( $orderby == 'oldest' ) { ?> selected="selected"<?php } ?>><?php esc_html_e( 'Oldest', 'huber' ); ?></option>
							<?php } ?>

							<?php if ( $type['title'] == '1' ) { ?>
								<option value="title_az"<?php if ( $orderby == 'title_az' ) { ?> selected="selected"<?php } ?>><?php esc_html_e( 'Title (A-Z)', 'huber' ); ?></option>
								<option value="title_za"<?php if ( $orderby == 'title_za' ) { ?> selected="selected"<?php } ?>><?php esc_html_e( 'Title (Z-A)', 'huber' ); ?></option>
							<?php } ?>		
									
							<?php if ( $type['comment_count'] == '1' ) { ?>
								<option value="comment_count"<?php if ( $orderby == 'comment_count' ) { ?> selected="selected"<?php } ?>><?php esc_html_e( 'Most Comments', 'huber' ); ?></option>
							<?php } ?>		
				
							<?php if ( $type['views'] ) { ?>
								<option value="views"<?php if ( $orderby == 'views' ) { ?> selected="selected"<?php } ?>><?php esc_html_e( 'Most Views', 'huber' ); ?></option>
							<?php } ?>

							<?php if ( $type['likes'] ) { ?>
								<option value="likes"<?php if ( $orderby == 'likes' ) { ?> selected="selected"<?php } ?>><?php esc_html_e( 'Most Likes', 'huber' ); ?></option>
							<?php } ?>

							<?php if ( $type['release_date'] ) { ?>
								<option value="release_date"<?php if ( $orderby == 'release_date' ) { ?> selected="selected"<?php } ?>><?php esc_html_e( 'Latest Releases', 'huber' ); ?></option>
							<?php } ?>

							<?php if ( $type['release_date_asc'] ) { ?>
								<option value="release_date_asc"<?php if ( $orderby == 'release_date_asc' ) { ?> selected="selected"<?php } ?>><?php esc_html_e( 'Oldest Releases', 'huber' ); ?></option>
							<?php } ?>

							<?php if ( $type['site_rating'] ) { ?>
								<option value="site_rating"<?php if ( $orderby == 'site_rating' ) { ?> selected="selected"<?php } ?>><?php esc_html_e( 'Top Site Rated', 'huber' ); ?></option>
							<?php } ?>

							<?php if ( $type['user_rating'] ) { ?>
								<option value="user_rating"<?php if ( $orderby == 'user_rating' ) { ?> selected="selected"<?php } ?>><?php esc_html_e( 'Top User Rated', 'huber' ); ?></option>
							<?php } ?>
														
						</select>

					<?php } ?>			
			
				</div>
			
			<?php if ( $page == true ) { ?></div><?php } ?>
						
		<?php }
	}
}

/**
 * Load template filter
 *
 */
if ( ! function_exists( 'ghostpool_template_filter' ) ) {
	function ghostpool_template_filter( $templates_default = '', $templates_filters = '', $pagination = '' ) {

		if ( is_array( $templates_filters ) && ghostpool_option( 'ajax' ) == 'gp-ajax-loop' && $pagination != 'load-more' ) { ?>

			<div class="gp-filter-templates">
						
				<?php if ( in_array( 'gp-standard-post', $templates_filters ) ) { ?>
					<label><input type="checkbox" name="templates[]" class="gp-template-type" value="gp-standard-post"<?php if ( in_array( 'gp-standard-post', $templates_default ) ) { ?> checked<?php } ?> /> <?php esc_html_e( 'Articles', 'huber' ); ?></label>
				<?php } ?>
		
				<?php if ( in_array( 'gp-hub-post', $templates_filters ) ) { ?>
					<label><input type="checkbox" name="templates[]" class="gp-template-type" value="gp-hub-post"<?php if ( in_array( 'gp-hub-post', $templates_default ) ) { ?> checked<?php } ?> /> <?php esc_html_e( 'Hubs', 'huber' ); ?></label>
				<?php } ?>
		
				<?php if ( in_array( 'gp-review-post', $templates_filters ) ) { ?>				
					<label><input type="checkbox" name="templates[]" class="gp-template-type" value="gp-review-post"<?php if ( in_array( 'gp-review-post', $templates_default ) ) { ?> checked<?php } ?> /> <?php esc_html_e( 'Reviews', 'huber' ); ?></label>
				<?php } ?>
				
				<?php if ( in_array( 'gp-user-review-post', $templates_filters ) ) { ?>				
					<label><input type="checkbox" name="templates[]" class="gp-template-type" value="gp-user-review-post"<?php if ( in_array( 'gp-user-review-post', $templates_default ) ) { ?> checked<?php } ?> /> <?php esc_html_e( 'User Reviews', 'huber' ); ?></label>
				<?php } ?>
				
				<?php if ( in_array( 'gp-preview-post', $templates_filters ) ) { ?>				
					<label><input type="checkbox" name="templates[]" class="gp-template-type" value="gp-preview-post"<?php if ( in_array( 'gp-preview-post', $templates_default ) ) { ?> checked<?php } ?> /> <?php esc_html_e( 'Previews', 'huber' ); ?></label>
				<?php } ?>
						
			</div>

		<?php }
	}
}

/**
 * Get total search results number
 *
 */
if ( ! function_exists( 'ghostpool_search_results_total' ) ) {
	function ghostpool_search_results_total( $query = '' ) {	
		if ( $query > 1 ) {
			$results_text = esc_html__( 'results found', 'huber' );
		} else {
			$results_text = esc_html__( 'result found', 'huber' );
		}	
		return '<div id="gp-search-results-count">' . absint( $query ) . ' ' . $results_text . '</div>';
	}
}

/**
 * GP Category Filters widget query
 *
 */	
if ( ! function_exists( 'ghostpool_category_filter_query' ) ) {
	function ghostpool_category_filter_query( $query ) {	
	
		if ( isset( $_REQUEST['ghostpool_category_filter_nonce'] ) && wp_verify_nonce( $_REQUEST['ghostpool_category_filter_nonce'], 'ghostpool_category_filter_action' ) ) {

			if ( $query->is_main_query() ) {

				// Category name
				if ( isset( $_POST['category'] ) && $_POST['category'] != '' ) {				
					$query->set( 'category_name', $_POST['category'] );
				}

				// Release dates
				if ( isset( $_POST['release_date'] ) && $_POST['release_date'] != 'all' ) {
					$query->set( 'orderby', ghostpool_orderby( 'release_date', 'orderby' ) );
					$query->set( 'order', ghostpool_orderby( 'release_date', 'order' ) );
					$query->set( 'meta_key', ghostpool_orderby( 'release_date', 'meta_key' ) );
					if ( $_POST['release_date'] == '12months' ) {
						$query->set( 'meta_query', ghostpool_orderby( 'release_date', 'meta_query', date( 'Ymd', strtotime( '-12 months' ) ), date( 'Ymd' ) ) );
					} elseif ( $_POST['release_date'] == '6months' ) {
						$query->set( 'meta_query', ghostpool_orderby( 'release_date', 'meta_query', date( 'Ymd', strtotime( '-6 months' ) ), date( 'Ymd' ) ) );
					} elseif ( $_POST['release_date'] == '3months' ) {
						$query->set( 'meta_query', ghostpool_orderby( 'release_date', 'meta_query', date( 'Ymd', strtotime( '-3 months' ) ), date( 'Ymd' ) ) );
					} elseif ( $_POST['release_date'] == 'date_range' ) {
						$query->set( 'meta_query', ghostpool_orderby( 'release_date', 'meta_query', $_POST['from'], $_POST['to'] ) );
					}
				}
				
				// Hub fields
				if ( isset( $_POST['ghostpool_hub_fields'] ) ) {
		
					$field = array();
					$hub_fields = explode( ',', $_POST['ghostpool_hub_fields'] );
					foreach ( $hub_fields as $hub_field ) {
						$terms = get_terms( $hub_field );
						if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) {
							foreach( $terms as $term ) {
								if ( $_POST[$hub_field] == $term->slug ) {		
									$field[] = array( 
										'taxonomy'  => $hub_field,
										'field'     => 'slug',
										'terms'     => $_POST[$hub_field],
										'operator'  => 'AND',
									);	
								}
							}
						}						
					}
					$hub_fields = array( 'relation' => 'AND' ) + $field;			
					$query->set( 'tax_query', $hub_fields );
		
				}

			}
		}
	
	}
}	
add_action( 'pre_get_posts', 'ghostpool_category_filter_query', 1 );

/**
 * Storing WordPress Popular Posts views as meta key
 *
 */
if ( ! function_exists( 'ghostpool_wpp_postviews' ) ) {
	function ghostpool_wpp_postviews( $post_id ) {
		// Accuracy:
		//   10  = 1 in 10 visits will update view count. (Recommended for high traffic sites.)
		//   30 = 30% of visits. (Medium traffic websites)
		//   100 = Every visit. Creates many db write operations every request.
		$accuracy = apply_filters( 'ghostpool_wpp_postviews_accuracy', '50' );
		if ( function_exists( 'wpp_get_views' ) && ( mt_rand( 0, 100 ) < $accuracy ) ) {
			update_post_meta( $post_id, 'views_total', (int) wpp_get_views( $post_id, '', false ) );
			//update_post_meta( $post_id, 'views_daily', wpp_get_views( $post_id, 'daily' )  );
			//update_post_meta( $post_id, 'views_weekly', wpp_get_views( $post_id, 'weekly' ) );
			//update_post_meta( $post_id, 'views_monthly', wpp_get_views( $post_id, 'monthly' ) );
		}
	}
}
add_action( 'wpp_post_update_views', 'ghostpool_wpp_postviews' );