<?php if ( ! function_exists( 'ghostpool_post_loop_showcase' ) ) {
	function ghostpool_post_loop_showcase( $format = '', $excerpt_length = '', $meta_release_date = '', $meta_author = '', $meta_date = '', $meta_comment_count = '', $meta_views = '', $meta_likes = '', $meta_followers = '', $meta_cats = '', $meta_tags = '', $meta_hub_fields = '',	$meta_site_rating = '', $meta_user_rating = '', $read_more_link = '', $counter = '', $ranking = '', $ranking_counter = '', $per_page = '', $images = '', $post_count = '' ) { 
	
	// Image dimensions
	if ( $counter > 1 ) {
		$image_size = 'thumbnail';							
	} else {
		$image_size = 'ghostpool-col-category-image';
	}
	
	?>
	
		<?php if ( $counter % $per_page == 2 OR $counter == 2 ) { 
			$widget_images = $images; ?>
			</div>
			<div class="gp-small-posts">
		<?php } elseif ( $counter % $per_page == 1 OR $counter == 1 ) { 
			$widget_images = ''; ?>
			<div class="gp-large-post">
		<?php } else {
			$widget_images = $images;
		} ?>

			<section <?php post_class( 'gp-post-item ' . get_post_meta( get_the_ID(), 'template', true ) ); ?>>
	
				<?php if ( ( ( ! has_post_thumbnail() && ( function_exists( 'kdmfi_get_featured_image_id' ) && ! kdmfi_has_featured_image( 'ghostpool-featured-image-2' ) ) ) OR $widget_images == 'disabled' ) && ( $ranking == 'gp-ranking' && $ranking_counter > 0 ) ) { ?>
					<div class="gp-ranking-counter"><?php echo absint( $ranking_counter ); ?></div>
				<?php } ?>	

				<?php if ( ( ( function_exists( 'kdmfi_get_featured_image_id' ) && kdmfi_has_featured_image( 'ghostpool-featured-image-2' ) ) OR has_post_thumbnail() ) && $widget_images != 'disabled' ) { ?>

					<div class="gp-post-thumbnail gp-loop-featured">
						<a href="<?php if ( get_post_format() == 'link' ) { echo esc_url( get_post_meta( get_the_ID(), 'link', true ) ); } else { the_permalink(); } ?>" title="<?php the_title_attribute(); ?>"<?php if ( get_post_format() == 'link' ) { ?> target="<?php echo get_post_meta( get_the_ID(), 'link_target', true ); ?>"<?php } ?>>
							<?php if ( $counter > 1 ) { ?>
								<?php if ( function_exists( 'kdmfi_get_featured_image_id' ) && kdmfi_has_featured_image( 'ghostpool-featured-image-2' ) ) {
									kdmfi_the_featured_image( 'ghostpool-featured-image-2', apply_filters( 'ghostpool_showcase_small_image_size', 'thumbnail' ) );
								} else {
									the_post_thumbnail( apply_filters( 'ghostpool_showcase_small_image_size', 'thumbnail' ) ); 
								} ?>
							<?php } else { ?>
								<?php the_post_thumbnail( apply_filters( 'ghostpool_showcase_large_image_size', 'ghostpool-col-category-image' ) ); ?>
							<?php } ?>
							<?php if ( $ranking == 'gp-ranking' && $ranking_counter > 0 ) { ?>
								<div class="gp-ranking-counter"><?php echo absint( $ranking_counter ); ?></div>
							<?php } ?>	
							<?php if ( $counter == 1 ) { ?>
								<span class="gp-loop-ratings">
									<?php if ( $meta_site_rating == '1' ) {
										get_template_part( 'lib/sections/taxonomies/loop-site-rating' ); 
									} 	
									if ( $meta_user_rating == '1' ) {
										get_template_part( 'lib/sections/taxonomies/loop-user-rating' ); 
									} ?>
								</span>	
							<?php } ?>	
						</a>					
					</div>

				<?php } elseif ( get_post_format() == 'gallery' && get_post_meta( get_the_ID(), 'gallery_slider', true ) ) {
			
					echo ghostpool_gallery_slider_loop_content( $format, $image_size );
			
				} elseif ( get_post_format() == 'video' ) {
			
					echo ghostpool_video_loop_content( $format, $image_size );
			
				} elseif ( get_post_format() == 'quote' ) {	
		
					get_template_part( 'lib/sections/taxonomies/loop-quote' ); 

				} ?>		

				<?php if ( get_post_format() == 'audio' && $counter == 1 ) {
					get_template_part( 'lib/sections/taxonomies/loop-audio' ); 
				} ?>

				<?php if ( get_post_format() != 'quote' OR ( has_post_thumbnail() && $widget_images != 'disabled' ) ) { ?>

					<div class="gp-loop-content">	
			
						<?php if ( get_post_format() == 'audio' && $counter > '1' ) {
							get_template_part( 'lib/sections/taxonomies/loop-audio' ); 
						} ?>
				
						<h2 class="gp-loop-title"><a href="<?php if ( get_post_format() == 'link' ) { echo esc_url( get_post_meta( get_the_ID(), 'link', true ) ); } else { the_permalink(); } ?>" title="<?php the_title_attribute(); ?>"<?php if ( get_post_format() == 'link' ) { ?> target="<?php echo get_post_meta( get_the_ID(), 'link_target', true ); ?>"<?php } ?>><?php the_title(); ?></a></h2>

						<?php if ( $excerpt_length != '0' ) { ?>
							<div class="gp-loop-text">
								<p><?php echo ghostpool_excerpt( $excerpt_length, $read_more_link ); ?></p>
							</div>
						<?php } ?>

						<?php ghostpool_loop_meta(
							$meta_release_date,
							$meta_author,
							$meta_date,
							$meta_comment_count,
							$meta_views,
							$meta_likes,
							$meta_followers,
							$meta_cats,
							$meta_hub_fields
						); ?>

						<?php if ( $meta_tags ) { the_tags( '<div class="gp-loop-tags">', ' ', '</div>' ); } ?>

					</div>

				<?php } ?>	

				<?php if ( $counter > 1 OR ! has_post_thumbnail() ) { ?>
					<span class="gp-loop-ratings">
						<?php if ( $meta_site_rating == '1' ) {
							get_template_part( 'lib/sections/taxonomies/loop-site-rating' ); 
						} 	
						if ( $meta_user_rating == '1' ) {
							get_template_part( 'lib/sections/taxonomies/loop-user-rating' ); 
						} ?>
					</span>
				<?php } ?>
			</section>

		<?php if ( ( $counter % $per_page == 0 ) OR $counter == $post_count ) { ?>
			</div>
		<?php } ?>

	<?php }

} ?>