<?php if ( ! function_exists( 'ghostpool_post_edit' ) ) {
	function ghostpool_post_edit() {

		if ( isset( $_GET['post_edit'] ) && $_GET['post_edit'] == '1' && wp_verify_nonce( $_REQUEST['_wpnonce'], 'ghostpool_post_edit_action' ) ) {

			$has_error = '';

			 if ( 'POST' == $_SERVER['REQUEST_METHOD'] && ! empty( $_POST['ghostpool_action'] ) && $_POST['ghostpool_action'] == 'ghostpool_edit_post' ) {
	 
				$post_edit = array();
				$post_edit = get_post( $_POST['ghostpool_post_id'] );

				// Check all required fields are filled in
				if ( trim( $_POST['ghostpool_post_title'] ) === '' ) {
					$has_error = true;
				}

				if ( isset( $_POST['ghostpool_post_username'] ) && trim( $_POST['ghostpool_post_username'] ) === '' && ! is_user_logged_in() ) {
					$has_error = true;
				}

				if ( isset( $_POST['ghostpool_post_email'] ) && trim( $_POST['ghostpool_post_email'] ) === '' && ! is_user_logged_in() && ! is_email( $_POST['ghostpool_post_email'] ) ) {
					$has_error = true;
				}

				if ( isset( $_POST['ghostpool_post_user_rating'] ) && ( trim( $_POST['ghostpool_post_user_rating'] ) === '' OR $_POST['ghostpool_post_user_rating'] < 1 OR $_POST['ghostpool_post_user_rating'] > ghostpool_option( 'rating_number' ) OR ! is_numeric( $_POST['ghostpool_post_user_rating'] ) ) ) {
					$has_error = true;
				}	
	
				if ( ghostpool_option( 'post_submission_categories' ) == 'enabled' && isset( $_POST['ghostpool_post_categories'] ) && trim( $_POST['ghostpool_post_categories'] ) === '' ) {
					$has_error = true;
				} elseif ( ghostpool_option( 'post_submission_categories' ) == 'disabled' ) {
					$_POST['ghostpool_post_categories'] = '';
				}
	
				if ( ghostpool_option( 'post_submission_formats' ) == 'enabled' && isset( $_POST['ghostpool_post_formats'] ) && trim( $_POST['ghostpool_post_formats'] ) === '' ) {
					$has_error = true;
				} elseif ( ghostpool_option( 'post_submission_formats' ) == 'disabled' ) {
					$_POST['ghostpool_post_formats'] = '';	
				}	
						
				if ( isset( $_POST['ghostpool_post_content'] ) && trim( $_POST['ghostpool_post_content'] ) === '' ) {
					$has_error = true;
				}

				// If all required fields are valid submit form	
				if ( $has_error == false ) {

					if ( $post_edit->post_status == 'publish' && ghostpool_option( 'post_editing_status' ) == 'approved' ) {
						$post_edit->post_status = 'publish';
					} else {
						$post_edit->post_status = 'pending';
					}
					$post_edit->post_title = stripslashes( $_POST['ghostpool_post_title'] );
					$post_edit->post_content = stripslashes( $_POST['ghostpool_post_content'] );
					$post_edit->post_category = array( $_POST['ghostpool_post_categories'] );
					$post_edit->post_format = $_POST['ghostpool_post_formats'];
					$post_edit->tags_input = $_POST['ghostpool_post_tags'];
		
					$post_id = wp_update_post( $post_edit );
					wp_set_post_terms( $post_id, $post_edit->post_format, 'post_format' );
					wp_set_post_terms( $post_id, $post_edit->post_category, 'category' );

					// Add rating custom field
					if ( isset( $_POST['ghostpool_post_user_rating'] ) ) {
						update_post_meta( $post_id, 'ghostpool_site_rating', $_POST['ghostpool_post_user_rating'] );
					}
											
					// Notify admin of post via email
					if ( $post_edit->post_status == 'pending' && ghostpool_option( 'post_submission_email_notification' ) == 'email_always' ) {
						$to = get_option( 'admin_email' );
						$subject = esc_html__( 'Post [edit]: ', 'huber' ) . "'" . stripslashes( $_POST['ghostpool_post_title'] ) . "' - " . get_bloginfo( 'name' );
						$message = esc_html__( 'A post was edited on ', 'huber' ) . get_bloginfo( 'name' ) . "\r\n\r\n";
						$message .= esc_html__( 'Title: ', 'huber' ) . stripslashes( $_POST['ghostpool_post_title'] ) . "\r\n\r\n";
						$message .= esc_html__( 'You can view this post at ', 'huber' ) . esc_url( get_permalink( $post_id ) );
						$message .= ghostpool_option( 'post_submission_email_notification' );
						$headers = '';
						if ( function_exists( 'ghostpool_wp_mail' ) ) { 
							ghostpool_wp_mail( $to, $subject, $message, $headers );				
						}
					}
					
					// Upload featured image
					if ( ! empty( $_FILES ) ) {
						foreach ( $_FILES as $file => $array ) { 
							$newupload = ghostpool_insert_attachment( $file, $post_id );
						}
					}

					if ( get_option( 'permalink_structure' ) ) {
						$permalink_structure = '?';
					} else { 
						$permalink_structure = '&';
					}

					wp_redirect( get_permalink( ghostpool_option( 'post_submission_page' ) ) . $permalink_structure . 'post_edit=1&post_editted=1&post_id=' . $post_id . '&_wpnonce=' . wp_create_nonce( 'ghostpool_post_edit_action' ) );
					
					exit;
		
				}
	
			}
		
		}
		
	} 
}	
add_action( 'init', 'ghostpool_post_edit' ); ?>