<?php if ( ! function_exists( 'ghostpool_page_header' ) ) {

	function ghostpool_page_header( $post_id = '', $type = 'gp-standard-page-header', $bg = '', $height = '' ) {
	
		if ( $type != 'gp-standard-page-header' OR get_post_meta( $post_id, 'page_header_video_bg', true ) != ''  ) {

			if ( isset( $bg['id'] ) && $bg['id'] > 0 ) {
				$id = $bg['id'];
			} elseif ( is_singular() && has_post_thumbnail( $post_id ) ) {
				$id = get_post_thumbnail_id( $post_id );
			} elseif ( ! is_array( $bg ) ) {
				$id = attachment_url_to_postid( $bg );
			} else {
				$id = '';
			}
			
			if ( $id > 0 ) {
				$bg_image = wp_get_attachment_image_src( $id, apply_filters( 'ghostpool_page_header_image_size', 'ghostpool-page-header-image' ) );
				$bg_image = isset( $bg_image[0] ) ? $bg_image[0] : '';
				$full_bg_image = wp_get_attachment_image_src( $id, apply_filters( 'ghostpool_full_page_header_image_size', 'full' ) );
				$full_bg_image = isset( $full_bg_image[0] ) ? $full_bg_image[0] : '';
			} else {
				$bg_image = '';
				$full_bg_image = '';
			}
						
			// BuddyPress user pages
			if ( function_exists( 'bp_is_active' ) && bp_is_user() ) {
				$cover_image_url = bp_attachments_get_attachment( 'url', array( 'members' => 'groups', 'item_id' => bp_displayed_user_id() ) );
				$bg_css = 'background-image: url(' . $cover_image_url . ');';
		
			// BuddyPress group pages
			} elseif ( function_exists( 'bp_is_active' ) && bp_is_group_single() ) { 
				global $bp;
				$cover_image_url = bp_attachments_get_attachment( 'url', array( 'object_dir' => 'groups', 'item_id' => $bp->groups->current_group->id ) );
				$bg_css = 'background-image: url(' . $cover_image_url . ');';			
				
			} elseif ( $bg_image ) {
				
				$bg_css = 'background-image: url(' . esc_url( $bg_image ) . ');';
				$full_bg_css = 'background-image: url(' . esc_url( $full_bg_image ) . ');';

			} else {
			
				$bg_css = '';
				$full_bg_css = '';
			
			}
			
			// Page header height styling
			$height_css = 'padding-bottom: ' . $height . ';';
		
		} else {
		
			$bg_css = '';
			$height_css = '';
		
		}
		
		$class = '';
		
		if ( ghostpool_option( 'theme_layout' ) == 'gp-boxed-layout' ) {
			$class .= 'gp-container';
		}	
		
		if ( get_post_meta( $post_id, 'page_header_video_bg', true ) ) {
			$class .= ' gp-has-video-bg';
		}
		
		$classes = ' class="' . $class . '"';
	
		?>
						
		<?php if ( $type == 'gp-full-page-page-header' ) { ?>
			<div id="gp-full-page-bg" style="<?php echo esc_attr( $full_bg_css ); ?>"></div>
		<?php } ?>

 		<?php if ( $type == 'gp-fullwidth-page-header' OR $type == 'gp-full-page-page-header' OR ( function_exists( 'bp_is_active' ) && ( bp_is_user() OR bp_is_group_single() ) ) ) { ?>
	
			<header id="gp-page-header"<?php echo wp_kses_post( $classes ); ?>>										

				<div id="gp-page-header-inner" style="<?php if ( $type != 'gp-full-page-page-header' ) { echo esc_attr( $bg_css ); } ?>">
				
					<?php ghostpool_page_header_video_bg( $post_id ); ?>
		
					<div class="gp-container" style="<?php echo esc_attr( $height_css ); ?>">		

						<?php ghostpool_page_header_video( $post_id ); ?>
							
						<?php if ( function_exists( 'bp_is_active' ) && bp_is_user() ) { ?>
							
							<div id="item-header-avatar">
								<a href="<?php bp_displayed_user_link(); ?>">
									<?php bp_displayed_user_avatar( 'type=full' ); ?>
								</a>
							</div>
							
						<?php } elseif ( function_exists( 'bp_is_active' ) && bp_is_group_single() && ! bp_disable_group_avatar_uploads() ) { global $bp; ?>
							
							<div id="item-header-avatar">
								<a href="<?php echo bp_get_group_url( $bp->groups->current_group ); ?>" title="<?php echo esc_attr( $bp->groups->current_group->name ); ?>">
									<?php $args = array( 
										'item_id' => $bp->groups->current_group->id,  
										'object' => 'group',  
										'type' => 'full', 
										'html' => true,
									); 
									echo bp_core_fetch_avatar( $args ); ?>
								</a>
							</div>
							
						<?php } ?>
					
					</div>
																			
				</div>
						
				<?php if ( ghostpool_option( 'theme_layout' ) != 'gp-boxed-layout' ) { ?>
					<div class="gp-blurred-bg" style="<?php if ( $type != 'gp-full-page-page-header' ) { echo esc_attr( $bg_css ); } ?>"></div>
				<?php } ?>	
					
			</header>
		
		<?php }
							
	}

} ?>