<?php
/*
Version: 1.6.2
Author: Huseyin Berberoglu
Author URI: https://nxsn.com
*/

define( 'GHOSTPOOL_META_KEY', 'ghostpool_followers' );
define( 'GHOSTPOOL_USER_OPTION_KEY', 'ghostpool_user_options' );

// Manage default privacy of users followed items lists by adding this constant to wp-config.php
if ( ! defined( 'GHOSTPOOL_DEFAULT_PRIVACY_SETTING' ) ) {
	define( 'GHOSTPOOL_DEFAULT_PRIVACY_SETTING', false );
}

$ajax_mode = 1;

function ghostpool_follow_items() {
	if ( isset( $_REQUEST['wpfpaction'] ) ) {
		global $ajax_mode;
		$ajax_mode = isset( $_REQUEST['ajax'] ) ? $_REQUEST['ajax'] : false;
		if ( $_REQUEST['wpfpaction'] == 'add' ) {
			ghostpool_follow();
		} elseif ( $_REQUEST['wpfpaction'] == 'remove' ) {
			ghostpool_unfollow();
		} elseif ( $_REQUEST['wpfpaction'] == 'clear' ) {
			if ( ghostpool_clear_followed() ) {
				ghostpool_die_or_go( '<strong class="gp-no-items-found">' . esc_html__( 'All items removed.', 'huber' ) . '</strong>' );
			} else {
				ghostpool_die_or_go( 'Error' );
			}	
		}
	}
}
add_action( 'wp_loaded', 'ghostpool_follow_items' );

function ghostpool_follow() {
	
	$post_id = $_REQUEST['postid'];

	if ( ! is_user_logged_in() ) {
		return;
	}

	if ( ghostpool_do_add_to_list( $post_id ) ) {
		do_action( 'ghostpool_after_add', $post_id );
		ghostpool_update_post_meta( $post_id, 1 );   	    
		$str = ghostpool_follow_button( $post_id, 1, 'remove' );
		ghostpool_die_or_go( $str );
	}

}

function ghostpool_do_add_to_list( $post_id ) {
	if ( ghostpool_check_followed( $post_id ) )
		return false;
	if ( is_user_logged_in() ) {
		return ghostpool_add_to_usermeta( $post_id );
	}
}

function ghostpool_unfollow() {
	
	$post_id = $_REQUEST['postid'];

	if ( ghostpool_do_unfollow( $post_id ) ) {
		do_action( 'ghostpool_after_remove', $post_id );
		ghostpool_update_post_meta( $post_id, -1 );
		if ( isset( $_REQUEST['page'] ) && $_REQUEST['page'] == 1 ) {
			$str = '';
		} else {
			$str = ghostpool_follow_button( $post_id, 1, 'add' );
		}
		ghostpool_die_or_go( $str );
 
	} else {
		return false;
	}	
}

function ghostpool_die_or_go( $str ) {
	global $ajax_mode;
	if ( $ajax_mode) {
		die( $str );
	} else {
		wp_redirect( $_SERVER['HTTP_REFERER'] );
	}
}

function ghostpool_add_to_usermeta( $post_id ) {
	if ( ! is_array( ghostpool_get_user_meta() ) ) {
		$followed = array();
	} else {
		$followed = ghostpool_get_user_meta();
	}
	$followed[] = $post_id;
	ghostpool_update_user_meta( $followed );
	return true;
}

function ghostpool_check_followed( $cid ) {
	if ( is_user_logged_in() ) {
		$following_page_ids = ghostpool_get_user_meta();
		if ( $following_page_ids )
			foreach ( $following_page_ids as $fpost_id )
				if ( $fpost_id == $cid ) return true;
	}
	return false;
}

// Changes button text
function ghostpool_follow_button( $post_id, $return = 0, $action = '' ) {

	$str = '';

	if ( $action == 'remove' ) :
		$str .= ghostpool_follow_button_html( $post_id, esc_html__( 'Unfollow', 'huber' ), 'remove' );
	elseif ( $action == 'add' ) :
		$str .= ghostpool_follow_button_html( $post_id, esc_html__( 'Follow', 'huber' ), 'add' );
	elseif ( ghostpool_check_followed( $post_id ) ) :
		$str .= ghostpool_follow_button_html( $post_id, esc_html__( 'Unfollow', 'huber' ), 'remove' );
	else:
		$str .= ghostpool_follow_button_html( $post_id, esc_html__( 'Follow', 'huber' ), 'add' );
	endif;

	if ( $return ) {
		return $str;
	} else {
		echo html_entity_decode( $str );
	}
}

// Generates button
function ghostpool_follow_button_html( $post_id, $opt, $action ) {

	if ( ! is_user_logged_in() ) {
		return;
	}

	$link = "<a class='gp-follow-button button gp-follow-item' href='?wpfpaction=" . $action . "&amp;postid=" .  $post_id . "' title='". $opt ."' rel='nofollow'>" . ghostpool_loader() . $opt . "</a>";
	$link = apply_filters( 'ghostpool_follow_button_html', $link );
	return $link;
}

function ghostpool_list_follow_items( $user_id ) {

	$following_page_ids = array();

	if ( is_user_logged_in() ) {
		$following_page_ids = ghostpool_get_user_meta();
	}

	return $following_page_ids;
}

function ghostpool_loader() {
	return '<span class="fa-spin gp-follow-loader"></span>';
}

function ghostpool_clear_followed() {
	if ( is_user_logged_in() ) {
		$following_page_ids = ghostpool_get_user_meta();
		if ( $following_page_ids ) :
			foreach ( $following_page_ids as $post_id ) {
				ghostpool_update_post_meta( $post_id, -1 );
			}
		endif;
		if ( ! delete_user_meta( get_current_user_id(), GHOSTPOOL_META_KEY ) ) {
			return false;
		}
	}
	return true;
}

function ghostpool_do_unfollow( $post_id ) {
	if ( ! ghostpool_check_followed( $post_id ) )
		return true;

	$a = true;
	if ( is_user_logged_in() ) {
		$user_following = ghostpool_get_user_meta();
		$user_following = array_diff( $user_following, array( $post_id ) );
		$user_following = array_values( $user_following );
		$a = ghostpool_update_user_meta( $user_following );
	}
	return $a;
}

function ghostpool_update_user_meta( $arr ) {
	return update_user_meta( get_current_user_id(), GHOSTPOOL_META_KEY, $arr );
}

function ghostpool_update_post_meta( $post_id, $val ) {
	$oldval = ghostpool_get_post_meta( $post_id );
	if ( $val == -1 && $oldval == 0 ) {
		$val = 0;
	} else {
		$val = $oldval + $val;
	}
	return add_post_meta( $post_id, GHOSTPOOL_META_KEY, $val, true ) OR update_post_meta( $post_id, GHOSTPOOL_META_KEY, $val );
}

function ghostpool_delete_post_meta( $post_id ) {
	return delete_post_meta( $post_id, GHOSTPOOL_META_KEY );
}

function ghostpool_get_user_meta( $user = '' ) {
	if ( ! empty( $user ) ) :
		$userdata = get_user_by( 'login', $user );
		$user_id = $userdata->ID;
		return get_user_meta( $user_id, GHOSTPOOL_META_KEY, true );
	else:
		return get_user_meta( get_current_user_id(), GHOSTPOOL_META_KEY, true );
	endif;
}

function ghostpool_get_post_meta( $post_id ) {
	$val = get_post_meta( $post_id, GHOSTPOOL_META_KEY, true );
	if ( $val == '' OR $val < 0) {
		$val = 0;
	}
	return $val;
}

function ghostpool_is_user_can_edit() {
	if ( isset( $_REQUEST['user'] ) && $_REQUEST['user'] )
		return false;
	return true;
}

function ghostpool_remove_follow_button( $post_id ) {
	if ( ghostpool_is_user_can_edit() ) {
		$link = "<a id='rem_$post_id' class='gp-follow-button gp-unfollow-item button' href='?wpfpaction=remove&amp;page=1&amp;postid=" . $post_id . "' title='". esc_html__( 'Remove', 'huber' ) . "' rel='nofollow'>" . esc_html__( 'Remove', 'huber' ) . "</a>";
		$link = apply_filters( 'ghostpool_remove_follow_button', $link );
		echo html_entity_decode( $link );
	}
}

function ghostpool_clear_list_link() {
	if ( ghostpool_is_user_can_edit() ) {
		echo "<a class='gp-follow-button gp-unfollow-all-items button' href='?wpfpaction=clear' rel='nofollow'>" . ghostpool_loader() . esc_html__( 'Unfollow All Items', 'huber' ) . "</a>";
	}
}