jQuery( document ).ready( function( $ ) {

	'use strict';

	/**
	 * Show page template/post format dependant metaboxes
	 *
	 */
	if ( $( 'body' ).hasClass( 'block-editor-page' ) && ! $( 'body' ).hasClass( 'widgets-php' ) ) { // Is Gutenberg active?

		wp.data.subscribe( () => {

			var newPageTemplate = wp.data.select( 'core/editor' ).getEditedPostAttribute( 'template' );
		
			$( 'body.post-type-page' ).find( '.redux-metabox' ).each( function() {
		
				var metabox = $( this ),
					metaboxID = metabox.attr( 'id' ),
					pattern = /-template-options/;

				if ( metaboxID !== 'redux-ghostpool_huber-metabox-page-options' && pattern.test( metaboxID ) ) {

					metaboxID = metaboxID.replace( 'redux-ghostpool_huber-metabox-', '' );
					metaboxID = metaboxID.replace( 'template-options', '' );
					metaboxID = metaboxID + 'template.php';
			
					if ( metaboxID === newPageTemplate ) {
						metabox.removeClass( 'hide-if-js closed' );
					} else if ( 'page' !== newPageTemplate ) {
						metabox.addClass( 'hide-if-js' );
					}
					
				}	
		
			});

		});

		wp.data.subscribe( () => {

			var newPostFormat = wp.data.select( 'core/editor' ).getEditedPostAttribute( 'format' );

			$( 'body.post-type-post' ).find( '.redux-metabox' ).each( function() {
	
				var metabox = $( this ),
					metaboxID = metabox.attr( 'id' ),
					pattern = /-format-options/;
					
				if ( metaboxID !== 'redux-ghostpool_huber-metabox-page-options' && pattern.test( metaboxID ) ) {
							
					metaboxID = metaboxID.replace( 'redux-ghostpool_huber-metabox-', '' );
					metaboxID = metaboxID.replace( '-format-options', '' );
				
					if ( metaboxID === newPostFormat ) {
						metabox.removeClass( 'hide-if-js closed' );
					} else {
						metabox.addClass( 'hide-if-js' );
					}
				
									
				}	
	
			});

		});

	}

	/**
	 * Load demo content
	 *
	 */				
	$( window ).on( 'load', function() {

		if ( document.getElementById( 'home_presets-select' ) != null ) {

			document.getElementById( 'home_presets-select' ).onchange = function ( value ) {
			
				var value = document.getElementById( 'home_presets-select' ).value;	

				if ( value.indexOf( 'homepage-1' ) >= 0 ) {	
					$( '#layout_5' ).prop( 'checked', true );
					$( '.redux-image-select' ).removeClass( 'redux-image-select-selected' );
					$( '.redux-image-select.layout_5' ).addClass( 'redux-image-select-selected' );
					$( '#featured_box_format-select' ).val( 'gp-featured-box-3' );
					$( '#featured_box_size-buttonsetgp-featured-box-fullwidth' ).prop( 'checked', true );
					$( '#featured_box_caption_text-buttonsetenabled' ).prop( 'checked', true );
					$( '#featured_posts-buttonsetenabled' ).prop( 'checked', true );
					$( '#featured_posts_format-select' ).val( 'gp-blog-columns-4' );
					$( '#featured_posts_per_page' ).val( '4' );
					$( '#latest_news-buttonsetdisabled' ).prop( 'checked', true );
					if ( typeof tinymce != 'undefined' ) {
						var editor = tinymce.get( 'content' );
						var vc_content = '[vc_row][vc_column width="2/3"][showcase widget_title="Latest Games" orderby="release_date" large_excerpt_length="160" large_meta_release_date="1" large_meta_views="1" large_meta_site_rating="1" small_meta_release_date="1" small_meta_views="1" small_meta_site_rating="1" icon="fa-star-half-empty" cats="demo-games" release_date_to="today"][vc_separator css=".vc_custom_1495185463503{margin-top: 15px !important;}"][blog widget_title="Top News" format="gp-blog-columns-3" per_page="6" excerpt_length="0" meta_author="1" meta_date="1" pagination="disabled" icon_bg_color="#41e2cd" icon="fa-file-text-o"][vc_separator css=".vc_custom_1495185463503{margin-top: 15px !important;}"][showcase widget_title="Most Viewed Reviews" orderby="views" large_excerpt_length="160" large_meta_views="1" large_meta_site_rating="1" small_meta_views="1" small_meta_site_rating="1" icon_bg_color="#e83ec3" icon="fa-eye" cats="demo-reviews"][vc_empty_space height="15px"][/vc_column][vc_column width="1/3"][showcase widget_title="Top User Reviews" format="gp-blog-vertical" orderby="site_rating" large_meta_date="1" large_meta_site_rating="1" small_meta_date="1" small_meta_site_rating="1" icon_bg_color="#5cacff" icon="fa-users" cats="demo-user-reviews"][vc_separator css=".vc_custom_1495188241195{margin-top: 35px !important;}"][blog widget_title="Favourite Reviews" ranking="gp-ranking" format="gp-blog-minimal" orderby="likes" per_page="6" excerpt_length="0" pagination="disabled" icon_bg_color="#ff8787" icon="fa-heart-o" cats="demo-reviews"][vc_empty_space height="35px"][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1495464905037{padding-bottom: 20px !important;background-image: url(https://huber.ghostpool.com/wp-content/uploads/megamenu-bg.jpg?id=347) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column][carousel widget_title="Videos" items_in_view="5" icon_color="" icon_bg_color="" title_color="#ffffff" post_title_color="#ffffff" post_title_hover_color="#fed766" meta_text_color="#ffffff" cats="demo-videos"][/vc_column][/vc_row][vc_row css=".vc_custom_1495534930512{margin-bottom: 35px !important;}"][vc_column width="1/3"][showcase widget_title="XBox One Reviews" format="gp-blog-vertical" per_page="3" large_excerpt_length="120" small_excerpt_length="60" large_meta_date="1" large_meta_comment_count="1" small_meta_date="1" small_meta_comment_count="1" icon_bg_color="#5dc21e" icon="fa-close" cats="demo-xbox-one-reviews"][/vc_column][vc_column width="1/3"][showcase widget_title="PS4 Reviews" format="gp-blog-vertical" per_page="3" large_excerpt_length="120" small_excerpt_length="60" large_meta_date="1" large_meta_comment_count="1" small_meta_date="1" small_meta_comment_count="1" icon_bg_color="#003791" icon="fa-dropbox" cats="demo-ps4-reviews"][/vc_column][vc_column width="1/3"][showcase widget_title="PC Reviews" format="gp-blog-vertical" per_page="3" large_excerpt_length="120" small_excerpt_length="60" large_meta_date="1" large_meta_comment_count="1" small_meta_date="1" small_meta_comment_count="1" icon_bg_color="#1b384c" icon="fa-desktop" cats="demo-pc-reviews"][/vc_column][/vc_row]';
						if ( editor && editor instanceof tinymce.Editor ) {
							editor.setContent( vc_content );
							editor.save( { no_events: true } );
						} else {
		   					jQuery( 'textarea#content' ).val( vc_content );
						}
					}
				} else if ( value.indexOf( 'homepage-2' ) >= 0 ) {
					$( '#layout_5' ).prop( 'checked', true );	
					$( '.redux-image-select' ).removeClass( 'redux-image-select-selected' );
					$( '.redux-image-select.layout_5' ).addClass( 'redux-image-select-selected' );
					$( '#featured_box_format-select' ).val( 'gp-featured-box-1' );
					$( '#featured_box_size-buttonsetgp-featured-box-boxed' ).prop( 'checked', true );
					$( '#featured_box_caption_text-buttonsetenabled' ).prop( 'checked', true );
					$( '#featured_posts-buttonsetenabled' ).prop( 'checked', true );
					$( '#featured_posts_format-select' ).val( 'gp-blog-columns-5' );
					$( '#featured_posts_per_page' ).val( '5' );
					$( '#latest_news-buttonsetenabled' ).prop( 'checked', true );
					$( '#latest_news_format-select' ).val( 'gp-blog-columns-3' );	
					$( '#latest_news_per_page' ).val( '9' );
					if ( typeof tinymce != 'undefined' ) {
						var editor = tinymce.get( 'content' );
						if ( editor && editor instanceof tinymce.Editor ) {
							editor.setContent( '' );
							editor.save( { no_events: true } );
						} else {
		   					jQuery( 'textarea#content' ).val( '' );
						}
					}
				} else if ( value.indexOf( 'homepage-3' ) >= 0 ) {
					$( '#layout_5' ).prop( 'checked', true );	
					$( '.redux-image-select' ).removeClass( 'redux-image-select-selected' );
					$( '.redux-image-select.layout_5' ).addClass( 'redux-image-select-selected' );
					$( '#featured_box_format-select' ).val( 'gp-featured-box-1' );
					$( '#featured_box_size-buttonsetgp-featured-box-fullwidth' ).prop( 'checked', true );
					$( '#featured_box_caption_text-buttonsetenabled' ).prop( 'checked', true );
					$( '#featured_posts-buttonsetdisabled' ).prop( 'checked', true );
					$( '#latest_news-buttonsetdisabled' ).prop( 'checked', true );
					if ( typeof tinymce != 'undefined' ) {
						var editor = tinymce.get( 'content' );
						var vc_content = '[vc_row full_width="stretch_row" css=".vc_custom_1495202424700{margin-top: 5px !important;margin-bottom: 20px !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column css=".vc_custom_1495202441032{padding-top: 0px !important;padding-bottom: 0px !important;}"][blog widget_title="Top Rated Games" format="gp-blog-columns-3" orderby="site_rating" filter_cats="1" filter_date="1" filter_title="1" filter_comment_count="1" filter_likes="1" filter_release_date="1" filter_site_rating="1" filter_user_rating="1" per_page="6" excerpt_length="0" meta_release_date="1" meta_site_rating="1" pagination="disabled" cats="demo-games" filter_cat_id="demo-games"][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1495202808395{padding-bottom: 40px !important;background-color: #3e6a91 !important;}"][vc_column][blog widget_title="Latest User Reviews" format="gp-blog-columns-4" per_page="8" excerpt_length="0" meta_release_date="1" meta_site_rating="1" title_color="#ffffff" post_title_color="#ffffff" post_title_hover_color="#fed766" meta_text_color="#ffffff" cats="demo-user-reviews"][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1493026920280{padding-bottom: 10px !important;}"][vc_column][blog widget_title="Latest News" format="gp-blog-columns-4" per_page="12" excerpt_length="0" meta_author="1" meta_date="1" pagination="disabled" cats="demo-news"][/vc_column][/vc_row]';
						if ( editor && editor instanceof tinymce.Editor ) {
							editor.setContent( vc_content );
							editor.save( { no_events: true } );
						} else {
		   					jQuery( 'textarea#content' ).val( vc_content );
						}
					}
				} else if ( value.indexOf( 'homepage-4' ) >= 0 ) {
					$( '#layout_3' ).prop( 'checked', true );
					$( '.redux-image-select' ).removeClass( 'redux-image-select-selected' );
					$( '.redux-image-select.layout_3' ).addClass( 'redux-image-select-selected' );
					$( '#featured_box_format-select' ).val( 'gp-featured-box-3' );
					$( '#featured_box_size-buttonsetgp-featured-box-boxed' ).prop( 'checked', true );
					$( '#featured_box_caption_text-buttonsetenabled' ).prop( 'checked', true );
					$( '#featured_posts-buttonsetenabled' ).prop( 'checked', true );
					$( '#featured_posts_format-select' ).val( 'gp-blog-columns-4' );
					$( '#featured_posts_per_page' ).val( '4' );
					$( '#latest_news-buttonsetdisabled' ).prop( 'checked', true );
					if ( typeof tinymce != 'undefined' ) {
						var editor = tinymce.get( 'content' );
						var vc_content = '[vc_row][vc_column][vc_tta_tabs style="flat" shape="square" color="sky" gap="10" active_section="1" no_fill_content_area="true"][vc_tta_section title="News" tab_id="1492783385856-2a3c9e0a-4733"][blog meta_date="1" meta_comment_count="1" meta_views="1" pagination="load-more" cats="demo-news"][/vc_tta_section][vc_tta_section title="Reviews" tab_id="1492784051404-3d6e2105-c0f3"][blog meta_release_date="1" meta_site_rating="1" pagination="load-more" cats="demo-reviews"][/vc_tta_section][vc_tta_section title="Videos" tab_id="1492783385865-07e7b385-a7af"][blog meta_date="1" meta_comment_count="1" meta_views="1" pagination="load-more" cats="demo-videos"][/vc_tta_section][/vc_tta_tabs][/vc_column][/vc_row]';
						if ( editor && editor instanceof tinymce.Editor ) {
							editor.setContent( vc_content );
							editor.save( { no_events: true } );
						} else {
		   					jQuery( 'textarea#content' ).val( vc_content );
						}
					}	
				} else if ( value.indexOf( 'homepage-5' ) >= 0 ) {
					$( '#layout_3' ).prop( 'checked', true );	
					$( '.redux-image-select' ).removeClass( 'redux-image-select-selected' );
					$( '.redux-image-select.layout_3' ).addClass( 'redux-image-select-selected' );
					$( '#featured_box_format-select' ).val( 'gp-featured-box-2' );
					$( '#featured_box_size-buttonsetgp-featured-box-fullwidth' ).prop( 'checked', true );
					$( '#featured_box_caption_text-buttonsetdisabled' ).prop( 'checked', true );
					$( '#featured_posts-buttonsetenabled' ).prop( 'checked', true );
					$( '#featured_posts_format-select' ).val( 'gp-blog-columns-4' );
					$( '#featured_posts_per_page' ).val( '4' );	
					$( '#latest_news-buttonsetenabled' ).prop( 'checked', true );
					$( '#latest_news_format-select' ).val( 'gp-blog-list' );	
					$( '#latest_news_per_page' ).val( '8' );	
					if ( typeof tinymce != 'undefined' ) {
						var editor = tinymce.get( 'content' );
						if ( editor && editor instanceof tinymce.Editor ) {
							editor.setContent( '' );
							editor.save( { no_events: true } );
						} else {
		   					jQuery( 'textarea#content' ).val( '' );
						}
					}	
				} else if ( value.indexOf( 'homepage-6' ) >= 0 ) {
					$( '#layout_3' ).prop( 'checked', true );	
					$( '.redux-image-select' ).removeClass( 'redux-image-select-selected' );
					$( '.redux-image-select.layout_5' ).addClass( 'redux-image-select-selected' );
					$( '#featured_box_format-select' ).val( 'gp-featured-box-3' );
					$( '#featured_box_size-buttonsetgp-featured-box-fullwidth' ).prop( 'checked', true );
					$( '#featured_box_caption_text-buttonsetenabled' ).prop( 'checked', true );
					$( '#featured_posts-buttonsetdisabled' ).prop( 'checked', true );
					$( '#featured_posts_format-select' ).val( 'gp-blog-columns-4' );
					$( '#featured_posts_per_page' ).val( '4' );	
					$( '#latest_news-buttonsetdisabled' ).prop( 'checked', true );
					$( '#latest_news_format-select' ).val( 'gp-blog-list' );	
					$( '#latest_news_per_page' ).val( '8' );	
					if ( typeof tinymce != 'undefined' ) {
						var editor = tinymce.get( 'content' );
						var vc_content = '[vc_row full_width="stretch_row" css=".vc_custom_1495533180141{margin-top: -30px !important;padding-bottom: 15px !important;background-color: #363e4c !important;}"][vc_column width="2/3"][blog widget_title="Top News" ranking="gp-ranking" format="gp-blog-columns-3" excerpt_length="0" pagination="disabled" title_color="#ffffff" post_title_color="#ffffff" post_title_hover_color="#ffffff" meta_text_color="#ffffff" cats="demo-news"][/vc_column][vc_column width="1/3"][showcase widget_title="Videos" format="gp-blog-vertical" per_page="4" small_meta_date="1" title_color="#ffffff" post_title_color="#ffffff" post_title_hover_color="#ffffff" post_link_color="#ffffff" post_link_hover_color="#ffffff" post_text_color="#8e98a9" meta_text_color="#eeeeee" post_border_color="#4c576b" cats="demo-videos"][vc_empty_space height="35px"][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1495533546852{padding-bottom: 35px !important;background-color: #272727 !important;}"][vc_column width="1/3"][showcase widget_title="Most Commented Reviews" format="gp-blog-vertical" orderby="comment_count" per_page="6" large_excerpt_length="200" large_meta_date="1" large_meta_comment_count="1" small_meta_author="1" small_meta_comment_count="1" large_read_more_link="enabled" title_color="#ffffff" post_title_color="#ffffff" post_title_hover_color="#ffffff" post_link_color="#5cd2ff" post_link_hover_color="#ffffff" post_text_color="#eeeeee" meta_text_color="#eeeeee" post_border_color="#424242" cats="demo-reviews"][/vc_column][vc_column width="1/3"][showcase widget_title="Top Site Rated Games" format="gp-blog-vertical" orderby="site_rating" per_page="6" large_excerpt_length="200" large_meta_date="1" large_meta_comment_count="1" large_meta_site_rating="1" small_meta_author="1" small_meta_comment_count="1" small_meta_site_rating="1" large_read_more_link="enabled" title_color="#ffffff" post_title_color="#ffffff" post_title_hover_color="#ffffff" post_link_color="#5cd2ff" post_link_hover_color="#ffffff" post_text_color="#eeeeee" meta_text_color="#eeeeee" post_border_color="#424242" cats="demo-games"][/vc_column][vc_column width="1/3"][showcase widget_title="Top User Rated Games" format="gp-blog-vertical" orderby="user_rating" per_page="6" large_excerpt_length="200" large_meta_date="1" large_meta_comment_count="1" large_meta_user_rating="1" small_meta_author="1" small_meta_comment_count="1" small_meta_user_rating="1" large_read_more_link="enabled" title_color="#ffffff" post_title_color="#ffffff" post_title_hover_color="#ffffff" post_link_color="#5cd2ff" post_link_hover_color="#ffffff" post_text_color="#eeeeee" meta_text_color="#eeeeee" post_border_color="#424242" cats="demo-games"][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1495534559361{padding-bottom: 35px !important;background-color: #342d44 !important;}"][vc_column][carousel widget_title="Games" items_in_view="4" meta_site_rating="1" arrows="disabled" title_color="#ffffff" post_title_color="#ffffff" post_title_hover_color="#ffffff" post_link_color="#ffffff" post_link_hover_color="#ffffff" post_text_color="#ffffff" meta_text_color="#eeeeee" post_border_color="#ffffff" cats="demo-games"][/vc_column][/vc_row]';
						if ( editor && editor instanceof tinymce.Editor ) {
							editor.setContent( vc_content );
							editor.save( { no_events: true } );
						} else {
		   					jQuery( 'textarea#content' ).val( vc_content );
						}
					}	
				}
			
			}
		
		}
	
	});	
	
});